package com.biz.crm.tpm.business.month.budget.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetControlQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetExamineCircularQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailExportVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 17:50
 */
public interface MonthBudgetMapper extends BaseMapper<MonthBudgetEntity> {

    /**
     * 月度预算分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/10/27 20:20
     **/
    Page<MonthBudgetVo> findByConditions(Page<MonthBudgetVo> page, @Param("dto") MonthBudgetDto dto);

    /**
     * 条件查询预算
     *
     * @param dto
     * @return
     */
    List<MonthBudgetVo> findListByConditions(@Param("dto") MonthBudgetDto dto);

    /**
     * 查询同维度月度预算
     *
     * @param monthBudgetDto
     * @return com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity
     * @author huojia
     * @date 2022/11/7 21:01
     **/
    List<MonthBudgetEntity> findByDimension(@Param("dto") MonthBudgetDto monthBudgetDto);

    /**
     * 考核通报分页查询预算
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo>
     * @author huojia
     * @date 2022/11/24 23:11
     **/
    Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Page<MonthBudgetExamineCircularQueryVo> page, @Param("dto") MonthBudgetExamineCircularQueryDto dto);

    /**
     * 分页查询所有数据（包含分子公司）
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2023/1/30 9:55
     **/
    Page<MonthBudgetVo> findByUnionConditions(Page<MonthBudgetVo> page, @Param("dto") MonthBudgetDto dto);

    /**
     * 根据编码查询数据（包含分子公司）
     *
     * @param codes
     * @return
     **/
    List<MonthBudgetVo> findUnionListByCodes(@Param("codes") List<String> codes);

    /**
     * 查询同预算维度的月度预算
     *
     * @author huojia
     * @date 2023/2/2 18:02
     * @param monthBudgetControlQueryDto
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity>
     **/
    List<MonthBudgetEntity> listSameDimensionControlBudget(@Param("dto") MonthBudgetControlQueryDto monthBudgetControlQueryDto);


    List<MonthBudgetVo> findCustomerGroupMonthBudget(@Param("dto") List<MonthBudgetDto> dtos, @Param("tenantCode") String tenantCode);

    /**
     * 查询当前计算年月的月度计划
     * @param dto
     * @return {@link MonthBudgetVo}
     */
    MonthBudgetVo findCurrMonthBudgetById(@Param("dto") MonthBudgetDto dto);

    BigDecimal sumFirstReplyAmount(@Param("dto") MonthBudgetDto dto, @Param("tenantCode") String tenantCode);

    BigDecimal sumFirstReplyAmountStudent(@Param("dto") MonthBudgetDto dto, @Param("tenantCode") String tenantCode);

    BigDecimal sumFirstReplyAmountOthers(@Param("dto") MonthBudgetDto dto, @Param("tenantCode") String tenantCode);

    BigDecimal sumActualSales(@Param("dto") MonthBudgetDto dto, @Param("tenantCode") String tenantCode);

    BigDecimal sumActualSalesStudent(@Param("dto") MonthBudgetDto dto, @Param("tenantCode") String tenantCode);

    BigDecimal sumActualSalesOthers(@Param("dto") MonthBudgetDto dto, @Param("tenantCode") String tenantCode);

    /**
     * 导出分页查询所有预算明细
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo>
     * @author huojia
     * @date 2022/10/27 21:24
     **/
    Page<MonthBudgetDetailExportVo> findExportByConditions(Page<MonthBudgetDetailExportVo> page, @Param("dto") MonthBudgetDetailDto dto);

    Page<MonthBudgetVo> findPageForOut(@Param("page") Page<MonthBudgetVo> page,@Param("dto") MonthBudgetDto dto);

    List<MonthBudgetVo> findMonthBudgetForVariable(@Param("dto") MonthBudgetDto dto,@Param("tenantCode") String tenantCode);

    List<MonthBudgetVo> findMonthBudgetConditionForVariable(@Param("dto") MonthBudgetDto monthBudgetDto);

    MonthBudgetVo findMonthBudgetSumAuditAmount(@Param("dto") MonthBudgetDto monthBudgetDto);

    MonthBudgetVo findMonthBudgetSumInitResolveAmount(@Param("dto") MonthBudgetDto monthBudgetDto);

    /**
     * 预算总使用金额：按照年月+区域+系统汇总批复金额-批复结案差
     * @param monthBudgetDtos
     * @return
     */
    List<MonthBudgetVo> findListForFR(@Param("dtos") List<MonthBudgetDto> monthBudgetDtos,@Param("tenantCode") String tenantCode);
}
