package com.biz.crm.tpm.business.month.budget.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetExamineCircularQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月31日 20:53
 */
public interface SubComMonthBudgetMapper extends BaseMapper<SubComMonthBudgetEntity> {

    /**
     * 分页查询分子公司月度预算
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo>
     * @author huojia
     * @date 2022/10/31 20:57
     **/
    Page<SubComMonthBudgetVo> findByConditions(Page<SubComMonthBudgetVo> page, @Param("dto") SubComMonthBudgetDto dto);

    /**
     * 根据相同维度，查询分子公司月度预算
     *
     * @param subComMonthBudgetDto
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity>
     * @author huojia
     * @date 2022/11/8 10:48
     **/
    List<SubComMonthBudgetEntity> findByDimension(@Param("dto") SubComMonthBudgetDto subComMonthBudgetDto);

    /**
     * 分页查询
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo>
     * @author huojia
     * @date 2022/11/25 0:00
     **/
    Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Page<MonthBudgetExamineCircularQueryVo> page, @Param("dto") MonthBudgetExamineCircularQueryDto dto);


    /**
     * 根据分子预算预测更新自动生成的分子月度预算
     *
     * @param onlyKeys 维度唯一拼接编码集合
     * @return List<SubComMonthBudgetEntity>
     */
    List<SubComMonthBudgetEntity> listByOnlyKeys(@Param("onlyKeys") List<String> onlyKeys, @Param("tenantCode") String tenantCode);

    Page<SubComMonthBudgetVo> findBySonCompanyBudgetWarn(@Param("page") Page<SubComMonthBudgetVo> page, @Param("list") List<String> yearMonthList,@Param("orgCode") String orgCode,@Param("saleCompanyCode") String saleCompanyCode,@Param("channelCode") String channelCode,@Param("saleGroupCode") String saleGroupCode,@Param("customerCode") String customerCode,@Param("budgetItemCode") String budgetItemCode);
}
