package com.biz.crm.tpm.business.month.budget.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author huojia
 * @date 2022年11月07日 17:10
 */
@Component
public class MonthBudgetRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_new_month_budget_data_view";
    }

    @Override
    public String desc() {
        return "TPM-新月度预算";
    }

    @Override
    public String buildSql() {
        return " select a.id ," +
                "a.budget_item_code," +
                "a.create_name," +
                "a.sales_group_code," +
                "a.customer_channel_level_code," +
                "a.org_level_code," +
                "a.year_budget_code," +
                "a.sales_institution_code," +
                "a.customer_code," +
                "a.modify_time," +
                "a.sales_org_name," +
                "a.channel_code," +
                "a.customer_channel_code," +
                "a.org_name," +
                "a.product_code," +
                "a.system_name," +
                "a.product_item_code," +
                "a.region_name," +
                "a.enable_status," +
                "a.remark," +
                "a.budget_item_level_code," +
                "a.del_flag," +
                "a.product_brand_name," +
                "a.terminal_code," +
                "a.product_item_name," +
                "a.product_name," +
                "a.modify_account," +
                "a.terminal_channel_code," +
                "a.create_time," +
                "a.control_balance_amount," +
                "a.month_budget_code," +
                "a.sales_org_code," +
                "a.product_brand_code," +
                "a.system_code," +
                "a.year_month_ly," +
                "a.year_month_date," +
                "a.channel_name," +
                "a.customer_name," +
                "a.group_code," +
                "a.business_unit_code," +
                "a.create_account," +
                "a.terminal_channel_level_code," +
                "a.org_code," +
                "a.region_code," +
                "a.sales_institution_name," +
                "a.product_category_code," +
                "a.customer_channel_name," +
                "a.sales_org_level_code," +
                "a.terminal_name," +
                "a.business_format_code," +
                "a.resolve_amount," +
                "a.modify_name," +
                "a.budget_item_name," +
                "a.budget_item_level," +
                "a.terminal_channel_name," +
                "a.product_category_name," +
                "a.tenant_code," +
                "a.channel_level_code," +
                "a.fee_belong_code," +
                "a.budget_cal_code," +
                "a.computed_result," +
                "a.bill_actual_sales," +
                "a.actual_sales," +
                "a.actual_costs," +
                "a.actual_reply_diff," +
                "a.budget_intensity," +
                "a.budget_intensity_numerator," +
                "a.budget_intensity_denominator," +
                "a.budget_total_point as orig_budget_total_point," +
                "TRUNCATE(a.budget_total_point, 2) as budget_total_point," +
                "TRUNCATE(a.total_goal_quantity, 2) as total_goal_quantity," +
                "TRUNCATE(a.init_resolve_amount, 2) as init_resolve_amount," +
                "TRUNCATE(a.approving_amount, 2) as approving_amount," +
                "TRUNCATE(a.first_reply_amount, 2) as first_reply_amount," +
                "TRUNCATE(a.cal_amount, 2) as cal_amount," +
                "TRUNCATE(a.first_reply_resolve_diff_amount, 2) as first_reply_resolve_diff_amount," +
                "TRUNCATE(a.last_month_rolling_amount, 2) as last_month_rolling_amount," +
                "TRUNCATE(a.adjust_amount, 2) as adjust_amount," +
                "TRUNCATE(a.last_actual_sales_replay_diff_amount, 2) as last_actual_sales_replay_diff_amount," +
                "TRUNCATE(a.freeze_amount, 2) as freeze_amount," +
                "TRUNCATE(a.after_freeze_amount, 2) as after_freeze_amount," +
                "TRUNCATE(a.approved_amount, 2) as approved_amount," +
                "TRUNCATE(a.pre_audit_amount, 2) as pre_audit_amount," +
                "TRUNCATE(a.estimated_excess_amount, 2) as estimated_excess_amount," +
                "TRUNCATE(a.accumulated_available_balance, 2) as accumulated_available_balance," +
                "TRUNCATE(a.available_ratio, 2) as available_ratio," +
                "TRUNCATE(a.month_rolling_amount, 2) as month_rolling_amount," +
                "TRUNCATE(a.month_balance_amount, 2) as month_balance_amount," +
                "TRUNCATE(a.process_reply_budget_amount, 2) as process_reply_budget_amount," +
                "TRUNCATE(a.process_reply_resolve_diff_amount, 2) as process_reply_resolve_diff_amount," +
                "TRUNCATE(a.process_reference_amount, 2) as process_reference_amount," +
                "TRUNCATE(a.process_offset_amount, 2) as process_offset_amount," +
                "TRUNCATE(a.audit_amount, 2) as audit_amount," +
                "TRUNCATE(a.approved_audit_diff, 2) as approved_audit_diff," +
                "TRUNCATE(a.year_total_available_amount, 2) as year_total_available_amount," +
                "TRUNCATE(a.used_strategy_amount, 2) as used_strategy_amount, " +
                "(IFNULL(a.approved_amount,0) + IFNULL(a.estimated_excess_amount,0)) as estimated_audit_amount " +
                "from tpm_month_budget a " +
                "where a.tenant_code = :tenantCode " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}

