package com.biz.crm.tpm.business.month.budget.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetDetailMapper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月31日 22:24
 */
@Component
public class SubComMonthBudgetDetailRepository extends ServiceImpl<SubComMonthBudgetDetailMapper, SubComMonthBudgetDetailEntity> {

    /**
     * 根据审批编码查询明细
     *
     * @param processNo
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity>
     * @author huojia
     * @date 2022/11/14 17:06
     **/
    public List<SubComMonthBudgetDetailEntity> listByProcessNo(String processNo) {
        if (StringUtils.isEmpty(processNo)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(SubComMonthBudgetDetailEntity::getProcessNo, processNo)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 批量查询明细
     *
     * @author huojia
     * @date 2023/1/15 10:21
     * @param monthBudgetCode
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity>
     **/
    public List<SubComMonthBudgetDetailEntity> listByMonthBudgetCode(String monthBudgetCode) {
        if (StringUtils.isEmpty(monthBudgetCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery().eq(SubComMonthBudgetDetailEntity::getMonthBudgetCode, monthBudgetCode).list();
    }
}
