package com.biz.crm.tpm.business.month.budget.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.month.budget.local.entity.VerticalAreaFeeWarningEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.VerticalAreaFeeWarningMapper;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @CLASS_DESCRIBE: 类的描述
 * @AUTHOR: create by zkey on 2023-11-03
 */
@Component
public class VerticalAreaFeeWarningRepository extends ServiceImpl<VerticalAreaFeeWarningMapper, VerticalAreaFeeWarningEntity> {

    /**
     * 垂直区域费用预警-给帆软跑
     * @param pageable
     * @return
     */
    public Page<VerticalAreaFeeWarningEntity> verticalAreaFeeWarning(Pageable pageable, List<String> yearMonths) {
        Page<VerticalAreaFeeWarningEntity> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        return this.baseMapper.verticalAreaFeeWarning(page,yearMonths);
    }

    public VerticalAreaFeeWarningEntity accumulate(VerticalAreaFeeWarningEntity e) {
        return this.baseMapper.accumulate(e);
    }
}
