package com.biz.crm.tpm.business.month.budget.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.month.budget.local.entity.VerticalWarningPanelEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.VerticalWarningPanelMapper;
import com.google.common.collect.Lists;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Component
public class VerticalWarningPanelRepository extends ServiceImpl<VerticalWarningPanelMapper, VerticalWarningPanelEntity> {

    /**
     * 垂直区域费用预警-给帆软跑
     * @param pageable
     * @return
     */
    public Page<VerticalWarningPanelEntity> verticalWarningPanel(Pageable pageable, List<String> yearMonths) {
        Page<VerticalWarningPanelEntity> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
        return this.baseMapper.verticalWarningPanel(page,yearMonths);
    }

    public List<VerticalWarningPanelEntity> findListForFR(List<String> yearMonths) {
        if(CollectionUtils.isEmpty(yearMonths)) return Lists.newArrayListWithCapacity(0);
        return this.baseMapper.findListForFR(yearMonths);
    }
}
