package com.biz.crm.tpm.business.month.budget.local.service;

import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;

import java.util.List;
import java.util.Map;

/**
 * 、字段分组计算策略
 *
 * @author : rentao
 * @date : 2023/1/19 10:54
 */
public interface FieldsDimenDiameterGroupStrategy {

  /**
   * 字段分组编码 例如：通过组织分组
   * 此编码来自 FieldsDimenDiameterEnum 并且需要在此策略中唯一
   */
  String getFieldsDimenDiameterCode();

  /**
   * 字段分组名称 例如：通过组织分组
   * 此编码来自 FieldsDimenDiameterEnum 并且需要在此策略中唯一
   */
  String getFieldsDimenDiameterName();

  /**
   * 在已经分组的基础商继续进行分组 得到最新的分组记录
   */
  Map<String, List<MonthBudgetVo>> onFieldsDimenDiameterGroup(Map<String, List<MonthBudgetVo>> oldMap);

}
