package com.biz.crm.tpm.business.month.budget.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 20:06
 */
public interface MonthBudgetDetailService {

    /**
     * 分页查询所有月度预算明细
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo>
     * @author huojia
     * @date 2022/10/27 21:22
     **/
    Page<MonthBudgetDetailVo> findByConditions(Pageable pageable, MonthBudgetDetailDto dto);

    /**
     * 生成月度预算操作明细
     *
     * @param monthBudgetDetailDto
     * @author huojia
     * @date 2022/11/1 11:22
     **/
    void create(MonthBudgetDetailDto monthBudgetDetailDto);

    void createList(List<MonthBudgetDetailDto> list);

    /**
     * 根据明细ids删除操作明细
     *
     * @param detailIds
     * @author huojia
     * @date 2022/11/5 17:35
     **/
    void deleteByIds(List<String> detailIds);

    List<MonthBudgetDetailVo> findListByBusiness(List<String> auditDetailCodes, String auditCode);

    void updateStatusByBusiness(List<MonthBudgetDetailVo> monthBudgetDetailVos);

    List<MonthBudgetDetailVo> findListByDetailPlanItemCodes(List<String> detailPlanItemCodes);
}
