package com.biz.crm.tpm.business.month.budget.local.service;

import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

/**
 * @author huojia
 * @date 2022年11月12日 17:41
 */
public interface SubComMonthBudgetCallBackService {

    /**
     * 月度预算调整 审批通过
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:42
     **/
    void adjustPass(ProcessStatusDto dto);

    /**
     * 月度预算调整 审批驳回、追回
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:42
     **/
    void adjustRejectAndRecover(ProcessStatusDto dto);

    /**
     * 月度预算变更 审批通过
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:47
     **/
    void changePass(ProcessStatusDto dto);

    /**
     * 月度预算变更 审批驳回、追回
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:48
     **/
    void changeRejectAndRecover(ProcessStatusDto dto);

    /**
     * 月度预算划拨 审批通过
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:49
     **/
    void transferPass(ProcessStatusDto dto);

    /**
     * 月度预算划拨 审批驳回、追回
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:49
     **/
    void transferRejectAndRecover(ProcessStatusDto dto);
}
