package com.biz.crm.tpm.business.month.budget.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月31日 20:37
 */
public interface SubComMonthBudgetDetailService {

    /**
     * 分页查询分子公司月度预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailVo>
     * @author huojia
     * @date 2022/10/31 21:15
     **/
    Page<SubComMonthBudgetDetailVo> findByConditions(Pageable pageable, SubComMonthBudgetDetailDto dto);

    /**
     * 新增分子公司月度预算明细
     *
     * @param detailDto
     * @author huojia
     * @date 2022/11/2 11:11
     **/
    void create(SubComMonthBudgetDetailDto detailDto);

    /**
     * 查询明细
     *
     * @param monthBudgetCode
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity>
     * @author huojia
     * @date 2023/1/15 10:19
     **/
    List<SubComMonthBudgetDetailEntity> listByMonthBudgetCode(String monthBudgetCode);

    void createList(List<SubComMonthBudgetDetailDto> detailList);

}
