package com.biz.crm.tpm.business.month.budget.local.service;

import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;

import java.util.List;
import java.util.Map;

/**
 * 时间范围分组策略
 * @author : rentao
 * @date : 2023/1/19 11:16
 */
public interface TimeDimensionGroupStrategy {

  /**
   * 分组编码 例如：通过季度
   * 此编码来自 TimeDimension 并且需要在此策略中唯一
   */
  String getTimeDimensionCode();

  /**
   * 分组名称 例如：通过季度
   * 此编码来自 TimeDimension 并且需要在此策略中唯一
   */
  String getTimeDimensionName();

  /**
   * 在已经分组的基础商继续进行分组 得到最新的分组记录
   */
  Map<String, List<MonthBudgetVo>> onTimeDimensionGroup(Map<String, List<MonthBudgetVo>> oldMap);
}
