package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetDetailMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月27日 20:14
 */
@Slf4j
@Service
public class MonthBudgetDetailServiceImpl implements MonthBudgetDetailService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MonthBudgetDetailMapper monthBudgetDetailMapper;

    @Autowired(required = false)
    private MonthBudgetDetailRepository monthBudgetDetailRepository;

    /**
     * 分页查询预算操作明细
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo>
     * @author huojia
     * @date 2022/11/1 21:03
     **/
    @Override
    public Page<MonthBudgetDetailVo> findByConditions(Pageable pageable, MonthBudgetDetailDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDetailDto();
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page<MonthBudgetDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.monthBudgetDetailMapper.findByConditions(page, dto);
    }

    /**
     * 新增月度预算操作明细
     *
     * @param monthBudgetDetailDto
     * @author huojia
     * @date 2022/11/1 21:03
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(MonthBudgetDetailDto monthBudgetDetailDto) {
        if (ObjectUtils.isEmpty(monthBudgetDetailDto)) {
            return;
        }
        MonthBudgetDetailEntity monthBudgetDetailEntity = nebulaToolkitService.copyObjectByWhiteList(
                monthBudgetDetailDto, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class
        );
        Date date = new Date();
        monthBudgetDetailEntity.setId(null);
        monthBudgetDetailEntity.setCreateTime(date);
        monthBudgetDetailEntity.setModifyTime(date);
        monthBudgetDetailRepository.save(monthBudgetDetailEntity);
    }

    /**
     * 批量新增月度预算操作明细
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createList(List<MonthBudgetDetailDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list = list.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<MonthBudgetDetailEntity> entityList = (List<MonthBudgetDetailEntity>) nebulaToolkitService.copyCollectionByBlankList(list, MonthBudgetDetailDto.class, MonthBudgetDetailEntity.class, HashSet.class, ArrayList.class);
        entityList.forEach(item -> item.setId(null));
        monthBudgetDetailRepository.saveBatch(entityList);
    }

    /**
     * 根据明细id批量删除月度预算明细
     *
     * @param detailIds
     * @author huojia
     * @date 2022/11/5 17:37
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<String> detailIds) {
        if (CollectionUtils.isEmpty(detailIds)) {
            return;
        }
        List<MonthBudgetDetailEntity> monthBudgetDetailEntities = this.monthBudgetDetailRepository.listByIds(detailIds);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntities)) {
            return;
        }
        monthBudgetDetailEntities.forEach(monthBudgetDetailEntity -> {
            monthBudgetDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.monthBudgetDetailRepository.updateBatchById(monthBudgetDetailEntities);
    }

    @Override
    public List<MonthBudgetDetailVo> findListByBusiness(List<String> auditDetailCodes, String auditCode) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetDetailEntity> monthBudgetDetailEntities = this.monthBudgetDetailRepository.findListByBusiness(auditDetailCodes, auditCode);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntities)) {
            return Lists.newArrayList();
        }
        Collection<MonthBudgetDetailVo> monthBudgetDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetDetailEntities, MonthBudgetDetailEntity.class, MonthBudgetDetailVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<MonthBudgetDetailVo>) monthBudgetDetailVos;
    }

    @Override
    public void updateStatusByBusiness(List<MonthBudgetDetailVo> monthBudgetDetailVos) {
        if (CollectionUtils.isEmpty(monthBudgetDetailVos)) {
            return;
        }
        this.monthBudgetDetailRepository.updateStatusByBusiness(monthBudgetDetailVos);
    }

    @Override
    public List<MonthBudgetDetailVo> findListByDetailPlanItemCodes(List<String> detailPlanItemCodes) {

        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.monthBudgetDetailRepository.findListByDetailPlanItemCodes(detailPlanItemCodes);
    }
}
