package com.biz.crm.tpm.business.month.budget.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeBudgetDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeRelationDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.*;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.*;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.*;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetControlTypeEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetItemLevelEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemControlConditionVoService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.builder.MonthBudgetActualSalesBuilder;
import com.biz.crm.tpm.business.month.budget.local.calculate.BudgetCalculateStrategy;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.VerticalAreaFeeWarningEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.VerticalWarningPanelEntity;
import com.biz.crm.tpm.business.month.budget.local.filter.MonthBudgetConditionFilter;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetCalculateHelper;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetHelper;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.VerticalAreaFeeWarningRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.VerticalWarningPanelRepository;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.*;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.*;
import com.biz.crm.tpm.business.month.budget.sdk.event.MonthBudgetLogEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.event.YearBudgetEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.*;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.biz.crm.tpm.business.profit.goal.discount.sdk.constant.ProfitGoalDiscountConstant.AUTO_AMOUNT_BUDGET_ITEM_CODE;

/**
 * @author huojia
 * @date 2022年10月27日 20:12
 */
@Slf4j
@Service
public class MonthBudgetServiceImpl implements MonthBudgetService {

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private MonthBudgetMapper monthBudgetMapper;

    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private MonthBudgetRepository monthBudgetRepository;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private BudgetCalConfigService budgetCalConfigService;

    @Autowired(required = false)
    private SubComMonthBudgetService subComMonthBudgetService;

    @Autowired(required = false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;

    @Autowired(required = false)
    private MonthBudgetDetailService monthBudgetDetailService;

    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Autowired(required = false)
    private MonthBudgetDetailRepository monthBudgetDetailRepository;

    @Autowired(required = false)
    private DimensionControlsService dimensionControlsService;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    /**
     * 引入自己，做事务隔离
     */
    @Autowired(required = false)
    private MonthBudgetServiceImpl monthBudgetService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired
    private List<MonthBudgetConditionFilter> monthBudgetConditionFilters;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Resource
    private MonthBudgetHelper monthBudgetHelper;

    @Resource
    private MonthBudgetCalculateHelper monthBudgetCalculateHelper;

    @Resource
    private List<BudgetCalculateStrategy> budgetCalculateStrategies;

    @Autowired(required = false)
    private SubComBudgetForecastService subComBudgetForecastService;

    @Autowired(required = false)
    private BudgetItemControlConditionVoService budgetItemControlConditionVoService;

    @Autowired(required = false)
    private VerticalAreaFeeWarningRepository verticalAreaFeeWarningRepository;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private VerticalWarningPanelRepository verticalWarningPanelRepository;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    @Autowired(required = false)
    private TpmDailySalesDataService tpmDailySalesDataService;

    @Override
    public Page<MonthBudgetVo> findByConditions(Pageable pageable, MonthBudgetDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDto();
        }
        Page<MonthBudgetVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        //根据不同的分组构建参数
        if (!CollectionUtils.isEmpty(monthBudgetConditionFilters)) {
            for (MonthBudgetConditionFilter budgetConditionFilter : monthBudgetConditionFilters) {
                budgetConditionFilter.buildDto(dto);
            }
        }
        page = this.monthBudgetMapper.findByConditions(page, dto);
        convertMonthBudgetProperty(page.getRecords());
        buildAmount(page.getRecords());
        return page;
    }

    @Override
    public Page<MonthBudgetVo> findByConditionsNoFilter(Pageable pageable, MonthBudgetDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDto();
        }
        Page<MonthBudgetVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page = this.monthBudgetMapper.findByConditions(page, dto);
        //这里清空下数据权限。。。
        MarsAuthorityContextHolder.getContext().setListCode("");
        convertMonthBudgetProperty(page.getRecords());
        buildAmount(page.getRecords());
        return page;
    }

    /**
     * 构建管控金额
     *
     * @param records
     * @author huojia
     * @date 2023/2/3 11:09
     **/
    private void buildAmount(List<MonthBudgetVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List<String> monthBudgetCodeList = records.stream().map(MonthBudgetVo::getMonthBudgetCode).collect(Collectors.toList());
        Map<String, MonthBudgetControlVo> map = mapControlAmount(monthBudgetCodeList);
        records.forEach(record -> {
            if (map.containsKey(record.getMonthBudgetCode())) {
                record.setControlSituation(map.get(record.getMonthBudgetCode()).getControlSituation());
                record.setControlTypeCode(map.get(record.getMonthBudgetCode()).getControlTypeCode());
                record.setControlsConfigCode(map.get(record.getMonthBudgetCode()).getControlsConfigCode());
                record.setControlRatio(map.get(record.getMonthBudgetCode()).getControlRatio());
                record.setControlBalanceAmount(map.get(record.getMonthBudgetCode()).getControlBalanceAmount());
            }
        });
    }

    @Override
    public Page<MonthBudgetVo> findUnionByConditions(Pageable pageable, MonthBudgetDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDto();
        }
        Page<MonthBudgetVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        page = this.monthBudgetMapper.findByUnionConditions(page, dto);
        return page;
    }

    @Override
    public List<MonthBudgetVo> findUnionListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return this.monthBudgetMapper.findUnionListByCodes(codes);
    }

    @Override
    public List<MonthBudgetVo> findListByConditions(MonthBudgetDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        return this.monthBudgetMapper.findListByConditions(dto);
    }

    /**
     * 转换字段
     */
    public void convertMonthBudgetProperty(List<MonthBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, String> feeSourceMap = Maps.newHashMap();
        if (null != dictDataVoService) {
            try {
                List<DictDataVo> feeSourceList = dictDataVoService.findByDictTypeCode(MonthBudgetConstant.DICT_TPM_FEE_BELONG_VERTICAL);
                if (!CollectionUtils.isEmpty(feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            } catch (Exception e) {
                log.error("费用归口数据字典查询失败：" + e.getMessage());
            }
        }
        for (MonthBudgetVo vo : list) {
            //费用来源转换
            if (StringUtils.isNotEmpty(vo.getFeeBelongCode())) {
                vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MonthBudgetVo update(MonthBudgetDto dto) {
        this.updateValidate(dto);
        boolean lock = true;
        try {
            lock = monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lock, "预算正在操作中，请稍后重试！");
            MonthBudgetVo monthBudgetVo = this.findById(dto.getId());
            if (ObjectUtils.isEmpty(monthBudgetVo)) {
                throw new RuntimeException("修改数据失败，原数据不存在！");
            }
            // 校验能否编辑，明细只有期初数据的月度预算才能编辑（月度预算明细数 <= 1）
            List<MonthBudgetDetailEntity> monthBudgetDetailEntities = monthBudgetDetailRepository.listDetailByBudgetCode(dto.getMonthBudgetCode());
            List<MonthBudgetDetailEntity> collect = monthBudgetDetailEntities.stream().filter(vo -> !BudgetOperationTypeEnum.INIT.getCode().equals(vo.getOperationType())).collect(Collectors.toList());
            if (collect.size() > 0) {
                throw new RuntimeException("当前月度预算存在已操作明细，不能进行编辑！");
            }
            // 保存月度预算
            MonthBudgetDto oldVo = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetVo, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            MonthBudgetEntity monthBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(dto, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
            monthBudgetEntity.setYearMonthDate(DateUtil.parseDate(monthBudgetEntity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
            this.monthBudgetRepository.saveOrUpdate(monthBudgetEntity);
            // 业务日志编辑
            MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<MonthBudgetLogEventListener, MonthBudgetLogEventDto> onUpdate =
                    MonthBudgetLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, MonthBudgetLogEventListener.class, onUpdate);
            return this.nebulaToolkitService.copyObjectByWhiteList(dto, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    @Override
    public MonthBudgetVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull(monthBudgetEntity, "数据不存在，请刷新后重试！");
        return nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public MonthBudgetVo findByCode(String code, String enableStatus) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        MonthBudgetEntity monthBudgetEntity = monthBudgetRepository.getByMonthBudgetCode(code, enableStatus);
        Validate.notNull(monthBudgetEntity, "数据不存在，请刷新后重试！");
        return nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public List<MonthBudgetVo> findByCodes(List<String> codes, String enableStatus) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List<MonthBudgetEntity> monthBudgetEntities = monthBudgetRepository.getByMonthBudgetCodes(codes, enableStatus);
        if (CollectionUtils.isEmpty(monthBudgetEntities)) {
            return null;
        }
        Map<String, MonthBudgetControlVo> map = this.mapControlAmount(codes);
        List<MonthBudgetVo> monthBudgetVos = (List<MonthBudgetVo>) nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntities, MonthBudgetEntity.class, MonthBudgetVo.class, HashSet.class, ArrayList.class
        );
        monthBudgetVos.forEach(monthBudgetVo -> {
            if (map.containsKey(monthBudgetVo.getMonthBudgetCode())) {
                monthBudgetVo.setControlSituation(map.get(monthBudgetVo.getMonthBudgetCode()).getControlSituation());
                monthBudgetVo.setControlBalanceAmount(map.get(monthBudgetVo.getMonthBudgetCode()).getControlBalanceAmount());
                monthBudgetVo.setControlTypeCode(map.get(monthBudgetVo.getMonthBudgetCode()).getControlTypeCode());
                monthBudgetVo.setControlRatio(map.get(monthBudgetVo.getMonthBudgetCode()).getControlRatio());
            }
        });
        return monthBudgetVos;
    }

    /**
     * 调出的金额，不能超过当前预算可用余额，选择需要调入的预算编码，提交发起审批流程，调出方占用预算，审批通过后调入方增加预算，审批驳回后调出方释放预算，系统记录操作明细信息。
     *
     * @param dto
     * @author huojia
     * @date 2022/11/1 16:55
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void adjust(MonthBudgetAdjustDto dto) {
        // 校验参数
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getAdjustOutBudgetCode(), "调出方编码不能为空！");
        Validate.notNull(dto.getAdjustOutAmount(), "调出金额不能为空！");
        Validate.isTrue(dto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0, "调出金额不能小于等于0！");
        Validate.notEmpty(dto.getAdjustInBudgetCode(), "调入方编码不能为空！");
        Validate.notNull(dto.getProcessBusiness(), "审批流参数不能为空！");
        Validate.notNull(dto.getProcessBusiness().getProcessKey(), "流程key不能为空！");
        Validate.notNull(dto.getProcessBusiness().getProcessTitle(), "流程主题不能为空！");
        List<String> lockKeys = new ArrayList<>();
        lockKeys.add(dto.getAdjustOutBudgetCode());
        lockKeys.add(dto.getAdjustInBudgetCode());
        boolean lockFlag = true;
        try {
            // 月度预算批量加锁
            lockFlag = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "预算调整失败，当前调入、调出预算正在操作中，请稍后！");
            MonthBudgetEntity adjustInEntity = monthBudgetRepository.getByMonthBudgetCode(dto.getAdjustInBudgetCode(), null);
            Validate.notNull(adjustInEntity, "调入方不存在，请检查！");
            MonthBudgetEntity adjustOutEntity = monthBudgetRepository.getByMonthBudgetCode(dto.getAdjustOutBudgetCode(), null);
            Validate.notNull(adjustOutEntity, "调出方不存在，请检查！");
            if (Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).compareTo(dto.getAdjustOutAmount()) < 0) {
                throw new RuntimeException("月度预算[" + dto.getAdjustOutBudgetCode() + "]的调出金额" + dto.getAdjustOutAmount().setScale(4, RoundingMode.HALF_UP) + "不能大于当前可用余额" + Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP));
            }
            BigDecimal adjustOutBeforeAmount = adjustOutEntity.getAccumulatedAvailableBalance();
            BigDecimal adjustInBeforeAmount = adjustInEntity.getAccumulatedAvailableBalance();
            // 修改调整、可用金额、审批中金额
            adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setApprovingAmount(Optional.ofNullable(adjustOutEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setAfterFreezeAmount(Optional.ofNullable(adjustOutEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setAccumulatedAvailableBalance(Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
            this.monthBudgetRepository.updateById(adjustOutEntity);
            this.monthBudgetRepository.updateById(adjustInEntity);
            // 提交审批，更新审批状态
            String processNo = this.adjustSubmit(dto);
            // 生成调出方操作明细
            MonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, dto.getAdjustOutAmount(),adjustOutBeforeAmount, BudgetOperationTypeEnum.ADJUST_OUT.getCode(), null);
            adjustOutDetailDto.setProcessNo(processNo);
            adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            adjustOutDetailDto.setOperationRemarks(dto.getOperationRemarks());
            monthBudgetDetailService.create(adjustOutDetailDto);
            // 生成调入方操作明细
            MonthBudgetDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustOutAmount(), adjustInBeforeAmount,BudgetOperationTypeEnum.ADJUST_IN.getCode(), null);
            adjustInDetailDto.setProcessNo(processNo);
            adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            adjustInDetailDto.setOperationRemarks(dto.getOperationRemarks());
            monthBudgetDetailService.create(adjustInDetailDto);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    /**
     * 调出的金额，不能超过当前预算可用余额，选择需要调入的预算编码，提交发起审批流程，调出方占用预算，审批通过后调入方增加预算，审批驳回后调出方释放预算，系统记录操作明细信息。
     *
     * @param dto
     * @author huojia
     * @date 2022/11/1 16:55
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void monthBudgetAdjust(MonthBudgetAdjustDto dto) {
        // 校验参数
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getAdjustOutBudgetDtoList(), "调出方不能为空！");
        for (MonthBudgetAdjustItemDto monthBudgetAdjustItemDto : dto.getAdjustOutBudgetDtoList()) {
            Validate.notNull(monthBudgetAdjustItemDto.getAdjustOutAmount(), "调出金额不能为空！");
            Validate.isTrue(monthBudgetAdjustItemDto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0, "调出金额不能小于等于0！");
        }
        Validate.notEmpty(dto.getAdjustInBudgetCode(), "调入方编码不能为空！");
        Validate.notNull(dto.getProcessBusiness(), "审批流参数不能为空！");
        Validate.notNull(dto.getProcessBusiness().getProcessKey(), "流程key不能为空！");
        Validate.notNull(dto.getProcessBusiness().getProcessTitle(), "流程主题不能为空！");
        List<String> lockKeys = new ArrayList<>();
        List<MonthBudgetAdjustItemDto> adjustOutBudgetDtoList = dto.getAdjustOutBudgetDtoList();
        Map<String, BigDecimal> adjustOutBudgetDtoMap = adjustOutBudgetDtoList.stream().collect(Collectors.toMap(MonthBudgetAdjustItemDto::getAdjustOutBudgetCode, MonthBudgetAdjustItemDto::getAdjustOutAmount));
        List<String> adjustOutBudgetCodeList = adjustOutBudgetDtoList.stream().map(MonthBudgetAdjustItemDto::getAdjustOutBudgetCode).distinct().collect(Collectors.toList());
        lockKeys.addAll(adjustOutBudgetCodeList);
        lockKeys.add(dto.getAdjustInBudgetCode());
        boolean lockFlag = true;
        try {
            // 月度预算批量加锁
            lockFlag = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "预算调整失败，当前调入、调出预算正在操作中，请稍后！");
            MonthBudgetEntity adjustInEntity = monthBudgetRepository.getByMonthBudgetCode(dto.getAdjustInBudgetCode(), null);
            Validate.notNull(adjustInEntity, "调入方不存在，请检查！");
            List<MonthBudgetEntity> adjustOutEntityList = monthBudgetRepository.getByMonthBudgetCodes(adjustOutBudgetCodeList, null);
            Validate.notNull(adjustOutEntityList, "调出方不存在，请检查！");
            Validate.isTrue(adjustOutEntityList.size() == adjustOutBudgetCodeList.size(), "查询的调出方数量不匹配，请检查！");
            Map<String,BigDecimal> beforeAmountMap = Maps.newHashMap();
            beforeAmountMap.put(adjustInEntity.getMonthBudgetCode(),adjustInEntity.getAccumulatedAvailableBalance());
            for (MonthBudgetEntity adjustOutEntity : adjustOutEntityList) {
                BigDecimal bigDecimal = Optional.ofNullable(adjustOutBudgetDtoMap.get(adjustOutEntity.getMonthBudgetCode())).orElse(BigDecimal.ZERO);
                if (Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).compareTo(bigDecimal) < 0) {
                    throw new RuntimeException("月度预算[" + adjustOutEntity.getMonthBudgetCode() + "]的调出金额" + bigDecimal.setScale(4, RoundingMode.HALF_UP) + "不能大于当前可用余额" + Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP));
                }
                beforeAmountMap.put(adjustOutEntity.getMonthBudgetCode(),adjustOutEntity.getAccumulatedAvailableBalance());
                // 修改调整、可用金额、审批中金额
                adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
                adjustOutEntity.setApprovingAmount(Optional.ofNullable(adjustOutEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
                adjustOutEntity.setAfterFreezeAmount(Optional.ofNullable(adjustOutEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
                adjustOutEntity.setAccumulatedAvailableBalance(Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
            }
            // 修改调整、可用金额、审批中金额
            adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustInAmount()));
            this.monthBudgetRepository.updateBatchById(adjustOutEntityList);
            this.monthBudgetRepository.updateById(adjustInEntity);
            // 提交审批，更新审批状态
            String processNo = this.adjustSubmit(dto);
            // 生成调出方操作明细
            List<MonthBudgetDetailDto> adjustOutDetailDtoList = new ArrayList<>();
            for (MonthBudgetEntity adjustOutEntity : adjustOutEntityList) {
                BigDecimal bigDecimal = Optional.ofNullable(adjustOutBudgetDtoMap.get(adjustOutEntity.getMonthBudgetCode())).orElse(BigDecimal.ZERO);
                MonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, bigDecimal,beforeAmountMap.get(adjustOutEntity.getMonthBudgetCode()), BudgetOperationTypeEnum.ADJUST_OUT.getCode(), null);
                adjustOutDetailDto.setProcessNo(processNo);
                adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
                adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                adjustOutDetailDto.setOperationRemarks(dto.getOperationRemarks());
                adjustOutDetailDtoList.add(adjustOutDetailDto);
            }
            monthBudgetDetailService.createList(adjustOutDetailDtoList);
            // 生成调入方操作明细
            MonthBudgetDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustInAmount(),beforeAmountMap.get(adjustInEntity.getMonthBudgetCode()), BudgetOperationTypeEnum.ADJUST_IN.getCode(), null);
            adjustInDetailDto.setProcessNo(processNo);
            adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            adjustInDetailDto.setOperationRemarks(dto.getOperationRemarks());
            monthBudgetDetailService.create(adjustInDetailDto);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    /**
     * 月度预算调整提交审批
     *
     * @param dto
     * @return java.lang.String
     * @author huojia
     * @date 2022/11/12 18:30
     **/
    private String adjustSubmit(MonthBudgetAdjustDto dto) {
        // 提交审批流
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(MonthBudgetConstant.ADJUST_MONTH_BUDGET);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull(processBusinessVo, "提交审批失败！");
        return processBusinessVo.getProcessNo();
    }

    /**
     * （1）追加：流程审批通过将即可完成预算的追加。
     * （2）削减：不能超过当前预算可用金额，提交发起审批流程并占用预算，审批驳回将预算的释放。
     *
     * @param dto
     * @author huojia
     * @date 2022/11/14 11:27
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void change(MonthBudgetOperateDto dto) {
        // 参数校验
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notBlank(dto.getMonthBudgetCode(), "月度预算编码不能为空！");
        Validate.notBlank(dto.getOperationType(), "变更类型不能为空！");
        Validate.isTrue(BudgetOperationTypeEnum.changeMap().containsKey(dto.getOperationType()), "变更类型只能是追加、削减！");
        Validate.notNull(dto.getOperationAmount(), "变更金额不能为空！");
        Validate.isTrue(dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0, "变更金额不能小于等于0！");
        Validate.notNull(dto.getProcessBusiness(), "审批流参数不能为空！");
        Validate.notNull(dto.getProcessBusiness().getProcessKey(), "流程key不能为空！");
        Validate.notNull(dto.getProcessBusiness().getProcessTitle(), "流程主题不能为空！");
        boolean lockFlag = true;
        try {
            // 预算加锁
            lockFlag = monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "当前预算正在操作中，请稍后！");
            MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull(monthBudgetEntity, "当前预算不存在，请刷新后重试！");
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                Validate.isTrue(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                        .compareTo(dto.getOperationAmount()) >= 0, "削减金额不能超过当前预算可用金额" + monthBudgetEntity.getAccumulatedAvailableBalance().setScale(4, RoundingMode.HALF_UP) + "！");
            }
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            // 金额计算
            if (BudgetOperationTypeEnum.ADD.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setApprovingAmount(
                        Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO)
                                .add(dto.getOperationAmount())
                );
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setAdjustAmount(
                        Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
                monthBudgetEntity.setApprovingAmount(
                        Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
                monthBudgetEntity.setAfterFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
            }
            monthBudgetEntity.setYearMonthDate(DateUtil.parseDate(monthBudgetEntity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
            this.monthBudgetRepository.saveOrUpdate(monthBudgetEntity);
            // 提交审批，更新审批状态
            String processNo = this.changeSubmit(dto);
            // 生成操作明细
            MonthBudgetDetailDto changeDetailDto = this.buildDetail(monthBudgetEntity, dto.getOperationAmount(),beforeAmount, dto.getOperationType(), null);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                changeDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            } else {
                changeDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            }
            changeDetailDto.setProcessNo(processNo);
            changeDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            changeDetailDto.setOperationRemarks(dto.getOperationRemarks());
            monthBudgetDetailService.create(changeDetailDto);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    /**
     * 预算变更提交审批
     *
     * @param dto
     * @return java.lang.String
     * @author huojia
     * @date 2022/11/14 11:42
     **/
    private String changeSubmit(MonthBudgetOperateDto dto) {
        // 提交审批流
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(MonthBudgetConstant.CHANGE_MONTH_BUDGET);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull(processBusinessVo, "提交审批失败！");
        return processBusinessVo.getProcessNo();
    }

    /**
     * 1.冻结：冻结金额不能超过当前预算可用金额，提交后扣减预算，系统记录操作明细信息。
     * 2.解冻：解冻金额不能超冻结金额，提交后增加预算，系统记录操作明细信息。
     *
     * @param dto
     * @author huojia
     * @date 2022/11/1 16:54
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unOrFreeze(MonthBudgetOperateDto dto, String operationType) {
        // 参数校验
        Validate.notNull(dto, "请求参数不能为空！");
        dto.setOperationType(operationType);
        Validate.notBlank(dto.getMonthBudgetCode(), "月度预算编码不能为空！");
        Validate.notBlank(dto.getOperationType(), "操作类型不能为空！");
        Validate.isTrue(BudgetOperationTypeEnum.freezeMap().containsKey(dto.getOperationType()), "操作类型只能是冻结、解冻！");
        Validate.notNull(dto.getOperationAmount(), "操作金额不能为空！");
        Validate.isTrue(dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0, "操作金额不能小于等于0！");

        boolean lockFlag = true;
        try {
            // 预算加锁
            lockFlag = monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "当前预算正在操作中，请稍后！");
            MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull(monthBudgetEntity, "当前预算不存在，请刷新后重试！");
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                        .compareTo(dto.getOperationAmount()) >= 0, "冻结金额不能超过当前预算可用金额" + monthBudgetEntity.getAccumulatedAvailableBalance().setScale(4, RoundingMode.HALF_UP) + "！");
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue(Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)
                        .compareTo(dto.getOperationAmount()) >= 0, "解冻金额不能超过当前冻结金额" + monthBudgetEntity.getFreezeAmount().setScale(4, RoundingMode.HALF_UP) + "！");
            }
            // 冻结、解冻
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)
                                .add(dto.getOperationAmount())
                );
                monthBudgetEntity.setAfterFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
                monthBudgetEntity.setAfterFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO)
                                .add(dto.getOperationAmount())
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                                .add(dto.getOperationAmount())
                );
            }
            monthBudgetEntity.setYearMonthDate(DateUtil.parseDate(monthBudgetEntity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
            this.monthBudgetRepository.saveOrUpdate(monthBudgetEntity);
            // 生成操作明细
            MonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(monthBudgetEntity, dto.getOperationAmount(),beforeAmount, dto.getOperationType(), null);
            monthBudgetDetailService.create(adjustOutDetailDto);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    /**
     * 根据预算项目编码批量查询预算
     *
     * @param budgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/11/1 20:39
     **/
    @Override
    public List<MonthBudgetVo> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        List<MonthBudgetEntity> monthBudgetEntityList = monthBudgetRepository.listByBudgetItemCodeList(budgetItemCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class));
    }

    /**
     * 月度预算批量新增（通过年度预算生成）（仅年度预算可使用该接口）
     *
     * @param monthBudgetDtoList
     * @author huojia
     * @date 2022/11/3 14:38
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBatch(List<MonthBudgetDto> monthBudgetDtoList) {
        if (CollectionUtils.isEmpty(monthBudgetDtoList)) {
            return;
        }
        // 一个年度预算对应只会生成12条月度预算，每次生成之前，先将对应月度预算删除
        Set<String> yearBudgetCodeList = monthBudgetDtoList.stream().map(MonthBudgetDto::getYearBudgetCode).collect(Collectors.toSet());
        this.delByYearBudgetCode(Lists.newArrayList(yearBudgetCodeList));
        // 保存新的月度预算
        List<MonthBudgetEntity> monthBudgetEntities = new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetDtoList, MonthBudgetDto.class, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class)
        );
        log.info("monthBudgetEntities {}", JSONObject.toJSONString(monthBudgetEntities));
        monthBudgetEntities.forEach(entity -> {
            entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
        });
        this.monthBudgetRepository.saveBatch(monthBudgetEntities);
        // 月度预算生成期初操作明细
        this.buildInitDetail(monthBudgetEntities);
        // 业务日志新增
        monthBudgetDtoList.forEach(dto -> {
            MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<MonthBudgetLogEventListener, MonthBudgetLogEventDto> onCreate =
                    MonthBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, MonthBudgetLogEventListener.class, onCreate);
        });
    }

    /**
     * 批量生成期初明细
     *
     * @param monthBudgetEntities
     * @author huojia
     * @date 2022/11/5 17:40
     **/
    private void buildInitDetail(List<MonthBudgetEntity> monthBudgetEntities) {
        List<MonthBudgetDetailEntity> monthBudgetDetailEntities = new ArrayList<>();
        monthBudgetEntities.forEach(monthBudgetEntity -> {
            MonthBudgetDetailEntity monthBudgetDetailEntity = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
            monthBudgetDetailEntity.setInitialAmount(monthBudgetEntity.getInitResolveAmount());
            monthBudgetDetailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
            monthBudgetDetailEntities.add(monthBudgetDetailEntity);
        });
        this.monthBudgetDetailRepository.saveBatch(monthBudgetDetailEntities);
    }

    /**
     * 根据年度预算编码查询对应月度预算
     *
     * @param yearBudgetCode
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/11/3 21:11
     **/
    @Override
    public List<MonthBudgetVo> listByYearBudgetCode(String yearBudgetCode) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearBudgetCode(yearBudgetCode);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            Lists.newArrayList();
        }
        return new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class));
    }

    /**
     * 月度预算批量编辑（异步计算时调用，其他地方不能用）
     *
     * @param monthBudgetDtoList
     * @author huojia
     * @date 2022/11/4 11:54
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBatch(List<MonthBudgetDto> monthBudgetDtoList) {
        if (CollectionUtils.isEmpty(monthBudgetDtoList)) {
            return;
        }
        List<MonthBudgetEntity> monthBudgetEntities = Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetDtoList, MonthBudgetDto.class, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class));
        this.monthBudgetRepository.updateBatchById(monthBudgetEntities);
    }

    /**
     * 根据年度预算编码删除月度预算
     *
     * @param yearBudgetCodeList
     * @author huojia
     * @date 2022/11/5 16:38
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delByYearBudgetCode(List<String> yearBudgetCodeList) {
        if (CollectionUtils.isEmpty(yearBudgetCodeList)) {
            return;
        }
        // 有操作明细的不允许删除
        List<MonthBudgetDetailEntity> monthBudgetDetailEntities = this.monthBudgetDetailRepository.listDetailByYearBudgetCodeList(yearBudgetCodeList);
        if (!CollectionUtils.isEmpty(monthBudgetDetailEntities)) {
            Map<String, List<MonthBudgetDetailEntity>> detailMap = monthBudgetDetailEntities.stream().collect(Collectors.groupingBy(MonthBudgetDetailEntity::getMonthBudgetCode));
            detailMap.forEach((monthBudgetCode, detailList) -> {
                List<MonthBudgetDetailEntity> collect = detailList.stream().filter(vo -> !BudgetOperationTypeEnum.INIT.getCode().equals(vo.getOperationType())).collect(Collectors.toList());
                if (collect.size() > 0) {
                    throw new RuntimeException("月度预算" + monthBudgetCode + "已生成操作明细，不能修改、删除！");
                }
            });
        }
        this.monthBudgetRepository.delByYearBudgetCode(yearBudgetCodeList);
        List<String> detailIds = monthBudgetDetailEntities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.monthBudgetDetailService.deleteByIds(detailIds);
    }

    /**
     * 手动执行回复量或者计划量
     *
     * @param ids
     * @param planFlag
     * @author huojia
     * @date 2022/11/16 16:15
     **/
    @Override
    public void manualReplay(List<String> ids, String planFlag) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        List<String> budgetItemCodeList = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode)
                .collect(Collectors.toList());
        // 查询预算项目
        List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(budgetItemCodeList);
        Map<String, BudgetItemVo> budgetItemVoMap = CollectionUtils.isEmpty(budgetItemVos) ? Maps.newHashMap() :
                budgetItemVos.stream().collect(Collectors
                        .toMap(BudgetItemVo::getBudgetItemCode, Function.identity(),
                                (oldVo, newVo) -> newVo));
        monthBudgetEntityList.forEach(entity -> {
            List<String> lockKeys = Lists.newArrayList();
            lockKeys.add(entity.getMonthBudgetCode());
            //加锁
            boolean lock = true;
            try {
                lock = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
                if (lock) {
                    log.error("开始重新计算预算：{}", entity.getMonthBudgetCode());
//                    this.calPlanReplay(entity.getId(), budgetItemVoMap, BooleanEnum.FALSE.getCapital());
                    this.calPlanReplay(entity.getId(), budgetItemVoMap, planFlag);
                }
            } catch (Exception e) {
                log.error("计算预算报错：编码{}，报错：{}", entity.getMonthBudgetCode(), e);
            } finally {
                if (lock) {
                    monthBudgetLockService.unLock(lockKeys);
                }
            }
        });
    }

    /**
     * 销管资金池预算项目计算回复量
     *
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualRestoreReplayReimburse(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        Set<String> budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode)
                .collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0026")) {
            throw new RuntimeException("所选月度预算必须为销管资金池预算项目！");
        }

        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");

            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();

            //（1）中括号部分计算逻辑：在销售计划数据表中，计算得到20116000销售机构下，经销商+分子公司的剔除掉整体不计费产品【2个，130100003400	蒙牛纯牛奶全脂灭菌乳利乐苗条装200mlX24包（全国版）、130100002946纯甄巴氏杀菌热处理香草味风味酸牛乳利乐钻200g×10包（加高版）】、乳饮料产品、现代牧业产品后的产品折后回复金额总量A；同时计算得到20112752销售机构下，经销商+分子公司的学生奶的产品折后回复金额总量B；
            //（2）整体常规点数=根据年度预算数据表，（当前年份的）取关联的预算项目其管控类型为按率、费用归口为大区和总部、分组为部门、部门归口为销管的年度预算，计算这些年度预算的年度预算点数之和；
            //（3）区域常规费用=∑（在月度预算数据表中，计算各大区预算项目管控类型为按率、部门归口为销管，且分组为部门、费用归口为大区的月度预算的月度分解金额之和）
            //（4）总部各部门项目费用=根据月度预算数据表，取关联的预算项目其管控类型为按率、费用归口为总部、部门归口为销管的月度预算，计算这些月度预算的月度分解金额之和；
            //（5）学生奶费用=根据月度预算数据表，计算预算项目层级为三级预算项目，预算项目名称包含学生奶专项的月度预算的月度分解金额之和；
            //（6）其他预留项目=根据月度预算数据表，计算预算项目为其他预留项目（Z0020）的月度预算的月度分解金额之和；
            //销售资金池预算项目的月度预算的回复量口径预算=（（1）中A+B）*（2）-（3）-（4）-（5）-（6）
            SalesPlanDto salesPlanDto1 = new SalesPlanDto();
            salesPlanDto1.setSalesInstitutionCode("20116000");
            salesPlanDto1.setExcludeProductCodeList(Arrays.asList("130100003400", "130100002946"));
            salesPlanDto1.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109"));
            salesPlanDto1.setYearMonthLy(yearMonthLy);
            List<SalesPlanVo> salesPlanVosA = salesPlanService.sumReplayReimburse(salesPlanDto1);
            Map<String, BigDecimal> mapA = CollectionUtils.isEmpty(salesPlanVosA) ? Maps.newHashMap() : salesPlanVosA.stream().collect(Collectors.toMap(SalesPlanVo::getYearMonthLy, SalesPlanVo::getDiscountRestoreAmount));
            SalesPlanDto salesPlanDto2 = new SalesPlanDto();
            salesPlanDto2.setSalesInstitutionCode("20112752");
            salesPlanDto2.setProductCategoryCode("106");
            salesPlanDto2.setYearMonthLy(yearMonthLy);
            List<SalesPlanVo> salesPlanVosB = salesPlanService.sumReplayReimburse(salesPlanDto2);
            Map<String, BigDecimal> mapB = CollectionUtils.isEmpty(salesPlanVosB) ? Maps.newHashMap() : salesPlanVosB.stream().collect(Collectors.toMap(SalesPlanVo::getYearMonthLy, SalesPlanVo::getDiscountRestoreAmount));

            YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
            yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
            yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode(), FeeBelongEnum.HEAD.getCode()));
            yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
            BigDecimal budgetTotalPoint = yearBudgetSdkService.sumBudgetTotalPoint(yearBudgetDto);

            MonthBudgetDto monthBudgetDto = nebulaToolkitService.copyObjectByBlankList(yearBudgetDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            monthBudgetDto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
            monthBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
            monthBudgetDto.setYear(String.valueOf(LocalDate.now().getYear()));
            BigDecimal sumFirstReplyAmountArea = Optional.ofNullable(monthBudgetRepository.sumFirstReplyAmount(monthBudgetDto)).orElse(BigDecimal.ZERO);
            monthBudgetDto.setFeeBelongCode(FeeBelongEnum.HEAD.getCode());
            BigDecimal sumFirstReplyAmountHead = Optional.ofNullable(monthBudgetRepository.sumFirstReplyAmount(monthBudgetDto)).orElse(BigDecimal.ZERO);
            BigDecimal sumFirstReplyAmounStudent = Optional.ofNullable(monthBudgetRepository.sumFirstReplyAmountStudent(monthBudgetDto)).orElse(BigDecimal.ZERO);
            monthBudgetDto.setBudgetItemCode("Z0020");
            BigDecimal sumFirstReplyAmounOthers = Optional.ofNullable(monthBudgetRepository.sumFirstReplyAmountOthers(monthBudgetDto)).orElse(BigDecimal.ZERO);

            for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                BigDecimal a = Optional.ofNullable(mapA.get(monthBudgetEntity.getYearMonthLy())).orElse(BigDecimal.ZERO);
                BigDecimal b = Optional.ofNullable(mapB.get(monthBudgetEntity.getYearMonthLy())).orElse(BigDecimal.ZERO);
                BigDecimal calAmount = (a.add(b)).multiply(budgetTotalPoint)
                        .subtract(sumFirstReplyAmountArea)
                        .subtract(sumFirstReplyAmountHead)
                        .subtract(sumFirstReplyAmounStudent)
                        .subtract(sumFirstReplyAmounOthers).setScale(2, BigDecimal.ROUND_HALF_UP);
                monthBudgetEntity.setCalAmount(calAmount);
                monthBudgetEntity.setFirstReplyAmount(calAmount);
                //差异费用
                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                // 更新月度预算上回复量
                monthBudgetEntity.setComputedResult("完成");
                this.monthBudgetRepository.updateById(monthBudgetEntity);
                MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), null, BudgetOperationTypeEnum.REPLAY.getCode(), null);
                monthBudgetDetailService.create(monthBudgetDetailDto);
            }
            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 销管资金池预算项目计算回复差
     *
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualActualReplayDiffReimburse(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        Set<String> budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode)
                .collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0026")) {
            throw new RuntimeException("所选月度预算必须为销管资金池预算项目！");
        }
        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");

            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(e -> e.getYearMonthLy().replace("-", "")));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();

            //（1）中括号部分计算逻辑：在主体日销售报表和主体日销售明细表中，计算得到20116000销售机构下16个大区的，经销商+分子公司的剔除掉整体不计费产品【2个不计费产品，130100003400蒙牛纯牛奶全脂灭菌乳利乐苗条装200mlX24包（全国版）、130100002946纯甄巴氏杀菌热处理香草味风味酸牛乳利乐钻200g×10包（加高版）】、乳饮料产品、现代牧业产品后的产品实销金额总量A；同时计算得到20112752销售机构下16个大区的，经销商+分子公司的学生奶的产品实销金额总量B；
            //（2）整体常规点数=根据年度预算数据表，取关联的预算项目其管控类型为按率、费用归口为大区和总部、分组为部门、部门归口为销管的年度预算，计算这些年度预算的年度预算点数之和；
            //（3）区域常规费用=∑（在月度预算数据表中，计算各大区预算项目管控类型为按率、部门归口为销管，且分组为部门、费用归口为大区的月度预算的实销量口径费用（元）字段值之和）
            //（4）总部各部门项目费用=根据月度预算数据表，取关联的预算项目其管控类型为按率、费用归口为总部、部门归口为销管的月度预算，计算这些月度预算的实销量口径费用（元）字段值之和；
            //（5）学生奶费用=根据月度预算数据表，计算预算项目层级为三级预算项目，预算项目名称包含学生奶专项的月度预算的实销量口径费用（元）字段值之和；
            //（6）其他预留项目=根据月度预算数据表，计算预算项目为其他预留项目（Z0020）的月度预算的实销量口径费用（元）字段值之和；
            //销售资金池预算项目的月度预算的实销口径预算=（（1）中A+B）*（2）-（3）-（4）-（5）-（6）。得到实际销售金额字段值，进而计算实销回复差字段值（＝实际销售金额字段值-月度分解金额字段值）
            MainOnedaySalesDataDto mainOnedaySalesDataDto1 = new MainOnedaySalesDataDto();
            mainOnedaySalesDataDto1.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            mainOnedaySalesDataDto1.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            mainOnedaySalesDataDto1.setSalesInstitutionCode("20116000");
            mainOnedaySalesDataDto1.setExcludeProductCodeList(Arrays.asList("130100003400", "130100002946"));
            mainOnedaySalesDataDto1.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109"));
            mainOnedaySalesDataDto1.setYearMonthLy(yearMonthLy);
            mainOnedaySalesDataDto1.setSalesOrgRegionCodeList(Arrays.asList("201160001028", "201160001027", "201160001026", "201160001025", "201160001024", "201160001018", "201160001014",
                    "201160001012", "201160001011", "201160001009", "201160001008", "201160001006", "201160001005", "201160001004", "201160001003", "201160001001"));
            List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.actualReplayDiffReimburse(mainOnedaySalesDataDto1);
            Map<String, BigDecimal> mapA = CollectionUtils.isEmpty(mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.toMap(MainOnedaySalesDataVo::getYearMonthLy, MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
            MainOnedaySalesDataDto mainOnedaySalesDataDto2 = new MainOnedaySalesDataDto();
            mainOnedaySalesDataDto2.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            mainOnedaySalesDataDto2.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            mainOnedaySalesDataDto2.setSalesInstitutionCode("20112752");
            mainOnedaySalesDataDto2.setSalesOrgRegionCodeList(Arrays.asList("201127521717", "201127521716", "201127521715", "201127521714", "201127521712", "201127521711", "201127521710",
                    "201127521709", "201127521708", "201127521707", "201127521706", "201127521705", "201127521704", "201127521703", "201127521702", "201127521701"));
            List<MainOnedaySalesDataVo> mainOnedaySalesDataVos2 = mainOnedaySaleDataService.actualReplayDiffReimburse(mainOnedaySalesDataDto1);
            Map<String, BigDecimal> mapB = CollectionUtils.isEmpty(mainOnedaySalesDataVos2) ? Maps.newHashMap() : mainOnedaySalesDataVos2.stream().collect(Collectors.toMap(MainOnedaySalesDataVo::getYearMonthLy, MainOnedaySalesDataVo::getDiscountBehindSaleAmount));

            YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
            yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
            yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode(), FeeBelongEnum.HEAD.getCode()));
            yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
            BigDecimal budgetTotalPoint = Optional.ofNullable(yearBudgetSdkService.sumBudgetTotalPoint(yearBudgetDto)).orElse(BigDecimal.ZERO);

            MonthBudgetDto monthBudgetDto = nebulaToolkitService.copyObjectByBlankList(yearBudgetDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            List<String> salesOrgList = Lists.newArrayList();
            salesOrgList.add("20116000");
            salesOrgList.add("20112752");
            monthBudgetDto.setSalesOrgList(salesOrgList);
            monthBudgetDto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
            monthBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
            monthBudgetDto.setYear(String.valueOf(LocalDate.now().getYear()));
            BigDecimal sumActualSalesArea = Optional.ofNullable(monthBudgetRepository.sumActualSales(monthBudgetDto)).orElse(BigDecimal.ZERO);
            monthBudgetDto.setFeeBelongCode(FeeBelongEnum.HEAD.getCode());
            BigDecimal sumActualSalesHead = Optional.ofNullable(monthBudgetRepository.sumActualSales(monthBudgetDto)).orElse(BigDecimal.ZERO);
            BigDecimal sumActualSalesStudent = Optional.ofNullable(monthBudgetRepository.sumActualSalesStudent(monthBudgetDto)).orElse(BigDecimal.ZERO);
            monthBudgetDto.setBudgetItemCode("Z0020");
            BigDecimal sumActualSalesOthers = Optional.ofNullable(monthBudgetRepository.sumActualSalesOthers(monthBudgetDto)).orElse(BigDecimal.ZERO);

                thisMonthBudgetEntityList.forEach(e -> {
                BigDecimal a = Optional.ofNullable(mapA.get(e.getYearMonthLy().replace("-", ""))).orElse(BigDecimal.ZERO);
                BigDecimal b = Optional.ofNullable(mapB.get(e.getYearMonthLy().replace("-", ""))).orElse(BigDecimal.ZERO);
                e.setActualSales((a.add(b)).multiply(budgetTotalPoint)
                        .subtract(sumActualSalesArea)
                        .subtract(sumActualSalesHead)
                        .subtract(sumActualSalesStudent)
                        .subtract(sumActualSalesOthers).setScale(2, BigDecimal.ROUND_HALF_UP));
            });
                thisMonthBudgetEntityList.forEach(entity -> {
                    entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
                });
                monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);

            List<String> thisIdList = thisMonthBudgetEntityList.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList());
            Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper)
                    .basic()
                    .builder();

            actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff(v, null));


            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 其他预留项目预算项目计算（计划、回复）量
     *
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualRestoreReplayOthers(List<String> ids, String planFlag) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        Set<String> budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode)
                .collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0020")) {
            throw new RuntimeException("所选月度预算必须为其他预留项目预算项目！");
        }
        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");

            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();

            //1.计算公式：剔除产品不定期变化
            //计划量口径预算=∑（16个大区经销商和分子公司的区域不计费产品的折后计划金额*各大区区域整体授权点数）
            //回复量口径预算=∑（16个大区经销商和分子公司的区域不计费产品的折后回复金额*各大区区域整体授权点数）
            //计划量口径预算费用/回复量口径预算费用，均记录在该月度预算的月度分解金额字段，进而计算下月度分解金额和年初分解金额的差异（＝月份分解金额字段值-年初分解金额字段值）字段值，并更新该条月度预算的冻结后可用金额和累计可用金额
            //2.涉及数据表来源：销售计划表、年度预算数据表
            List<String> salesOrgList = Arrays.asList("201160001028", "201160001027", "201160001026", "201160001025", "201160001024", "201160001018", "201160001014",
                    "201160001012", "201160001011", "201160001009", "201160001008", "201160001006", "201160001005", "201160001004", "201160001003", "201160001001");
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            salesPlanDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesPlanDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            salesPlanDto.setSalesProductCodeList(Arrays.asList("130100003400", "130100002946", "130100003010", "130100003206", "130100003205", "130100002890", "130100003039", "130100003031",
                    "130100003105", "130100003116", "130100003227", "130100003021", "130100003427", "130100003450", "130100002188", "130100002187"));
            salesPlanDto.setYearMonthLy(yearMonthLy);
            salesPlanDto.setSalesOrgRegionCodeList(salesOrgList);
            List<SalesPlanVo> salesPlanVos;
            if (BooleanEnum.TRUE.getCapital().equals(planFlag)) {
                salesPlanVos = salesPlanService.sumReplayPlan(salesPlanDto);
            } else {
                salesPlanVos = salesPlanService.sumReplayRestore(salesPlanDto);
            }
            Map<String, Map<String, BigDecimal>> map = CollectionUtils.isEmpty(salesPlanVos) ? Maps.newHashMap() :
                    salesPlanVos.stream().filter(item -> StringUtils.isNotEmpty(item.getYearMonthLy()) && StringUtils.isNotEmpty(item.getSalesOrgRegionCode()) && null != item.getDiscountRestoreAmount())
                            .collect(Collectors.groupingBy(SalesPlanVo::getYearMonthLy,
                    Collectors.toMap(SalesPlanVo::getSalesOrgRegionCode, SalesPlanVo::getDiscountRestoreAmount)));

            YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
            yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
            yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode()));
            yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
            yearBudgetDto.setSalesOrgList(salesOrgList);
            List<YearBudgetVo> yearBudgetVos = yearBudgetSdkService.getYearBudgetTotalPointGroupBySalesOrg(yearBudgetDto);
            Map<String, BigDecimal> yearBudgetMap = CollectionUtils.isEmpty(yearBudgetVos) ? Maps.newHashMap() : yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getSalesOrgCode, YearBudgetVo::getBudgetTotalPoint));

            for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                Map<String, BigDecimal> salesOrgMap = map.get(monthBudgetEntity.getYearMonthLy());
                if (CollectionUtils.isEmpty(salesOrgMap)) {
                    continue;
                }
                AtomicReference<BigDecimal> firstReplyAmount = new AtomicReference<>(BigDecimal.ZERO);
                salesOrgMap.forEach((k, v) -> {
                    BigDecimal budgetTotalPoint = yearBudgetMap.getOrDefault(k, BigDecimal.ZERO);
                    firstReplyAmount.set(firstReplyAmount.get().add(v.multiply(budgetTotalPoint)));
                });
                BigDecimal firstReplyAmountDecimal = firstReplyAmount.get();
                monthBudgetEntity.setCalAmount(firstReplyAmountDecimal);
                monthBudgetEntity.setFirstReplyAmount(firstReplyAmountDecimal);
                //差异费用
                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                // 更新月度预算上回复量
                monthBudgetEntity.setComputedResult("完成");
                this.monthBudgetRepository.updateById(monthBudgetEntity);
                MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), null,
                        BooleanEnum.TRUE.getCapital().equals(planFlag) ? BudgetOperationTypeEnum.PLAN.getCode() : BudgetOperationTypeEnum.REPLAY.getCode(), null);
                monthBudgetDetailService.create(monthBudgetDetailDto);
            }

            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 其他预留项目预算项目计算回复差
     *
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualActualReplayDiffOthers(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        Set<String> budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode)
                .collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0020")) {
            throw new RuntimeException("所选月度预算必须为其他预留项目预算项目！");
        }
        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");

            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(e -> e.getYearMonthLy().replace("-", "")));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();

            //1.计算公式：剔除产品不定期变化
            //实销量口径预算=∑（16个大区经销商和分子公司的不计费产品产品的折后销售额（不含奶卡）*各大区区域整体授权点数）
            //得到该月度预算的实际销售金额字段值，进而计算实销回复差字段值（＝实际销售金额字段值-月度分解金额字段值）
            //2.涉及数据表来源：主体日销售报表、主体日销售明细表（订单类型ZOR5、ZOR8）、年度预算数据表
            List<String> salesOrgList = Arrays.asList("201160001028", "201160001027", "201160001026", "201160001025", "201160001024", "201160001018", "201160001014",
                    "201160001012", "201160001011", "201160001009", "201160001008", "201160001006", "201160001005", "201160001004", "201160001003", "201160001001");
            List<String> productCodeList = Arrays.asList("130100003400", "130100002946", "130100003010", "130100003206", "130100003205", "130100002890", "130100003039", "130100003031",
                    "130100003105", "130100003116", "130100003227", "130100003021", "130100003427", "130100003450", "130100002188", "130100002187");
            MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
            mainOnedaySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            mainOnedaySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            mainOnedaySalesDataDto.setSalesInstitutionCode("20116000");
            mainOnedaySalesDataDto.setProductCodes(productCodeList);
            mainOnedaySalesDataDto.setYearMonthLy(yearMonthLy);
            mainOnedaySalesDataDto.setSalesOrgRegionCodeList(salesOrgList);
            List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, Map<String, BigDecimal>> mapA = CollectionUtils.isEmpty(mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthLy,
                    Collectors.toMap(MainOnedaySalesDataVo::getSalesOrgRegionCode, MainOnedaySalesDataVo::getDiscountBehindSaleAmount)));

            TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
            dailySalesDataDto.setSalesProductCodeList(productCodeList);
            dailySalesDataDto.setYearMonthLy(yearMonthLy);
            dailySalesDataDto.setSalesOrgRegionCodeList(salesOrgList);
            List<TpmDailySalesDataVo> dailySalesDataVos = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, Map<String, BigDecimal>> mapB = CollectionUtils.isEmpty(dailySalesDataVos) ? Maps.newHashMap() : dailySalesDataVos.stream().collect(Collectors.groupingBy(TpmDailySalesDataVo::getYearMonthLy,
                    Collectors.toMap(TpmDailySalesDataVo::getSalesOrgRegionCode, TpmDailySalesDataVo::getAfterDiscountAmt)));

            YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
            yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
            yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode()));
            yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
            yearBudgetDto.setSalesOrgList(salesOrgList);
            List<YearBudgetVo> yearBudgetVos = yearBudgetSdkService.getYearBudgetTotalPointGroupBySalesOrg(yearBudgetDto);
            Map<String, BigDecimal> yearBudgetMap = CollectionUtils.isEmpty(yearBudgetVos) ? Maps.newHashMap() : yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getSalesOrgCode, YearBudgetVo::getBudgetTotalPoint));


            for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                AtomicReference<BigDecimal> afterDiscountAmt = new AtomicReference<>(BigDecimal.ZERO);
                Map<String, BigDecimal> salesOrgMapA = mapA.get(monthBudgetEntity.getYearMonthLy());
                Map<String, BigDecimal> salesOrgMapB = mapB.get(monthBudgetEntity.getYearMonthLy());
                if (!CollectionUtils.isEmpty(salesOrgMapA)) {
                    salesOrgMapA.forEach((k, v) -> {
                        BigDecimal budgetTotalPoint = yearBudgetMap.getOrDefault(k, BigDecimal.ZERO);
                        afterDiscountAmt.set(afterDiscountAmt.get().add(v.multiply(budgetTotalPoint)));
                    });
                }
                if (!CollectionUtils.isEmpty(salesOrgMapB)) {
                    salesOrgMapB.forEach((k, v) -> {
                        BigDecimal budgetTotalPoint = yearBudgetMap.getOrDefault(k, BigDecimal.ZERO);
                        afterDiscountAmt.set(afterDiscountAmt.get().add(v.multiply(budgetTotalPoint)));
                    });
                }
                monthBudgetEntity.setActualSales(afterDiscountAmt.get());
            }
                thisMonthBudgetEntityList.forEach(entity -> {
                    entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
                });
            monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);

            List<String> thisIdList = thisMonthBudgetEntityList.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList());
            Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper)
                    .basic()
                    .builder();
            actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff(v, null));

            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 特仑苏统筹和授权预算项目计算回复量
     *
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualRestoreReplayRestoreDeluxu(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");

            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();


                Set<String> budgetItemCodeSet = new HashSet<>();
                Set<String> salesOrgSet = new HashSet<>();
                Set<String> yearBudgetCodeSet = new HashSet<>();
                monthBudgetEntityList.forEach(e -> {
                    if (!"Z0019".equals(e.getBudgetItemCode()) && !"Z0030".equals(e.getBudgetItemCode())) {
                        throw new RuntimeException("所选月度预算必须为品类政策费用-特仑苏授权或品类政策费用-特仑苏统筹预算项目！");
                    }
                    budgetItemCodeSet.add(e.getBudgetItemCode());
                    salesOrgSet.add(e.getSalesOrgCode());
                    yearBudgetCodeSet.add(e.getYearBudgetCode());
                });

            //1.特仑苏授权（各大区，经销商&分子公司）
            //1.1涉及数据表来源：
            //（1）销售计划表：业态为常温，业务单元为主体和垂直重客，年月为月度预算对应年月；
            //（2）销售任务表：业态为常温，业务单元为主体和垂直重客，年月为月度预算对应年月，年度任务分类为内控；
            //1.2进行以下步骤计算：
            //（1）计算大区的全品达成率=大区的月度全品的销售计划总量（包含主体和垂直，折后回复金额）/ 月度全品的销售任务总量（包含主体和垂直，折后销售额）【注：全品里需剔除乳饮料、现代牧业、学生奶，产品管理中主体分类字段可查找到乳饮料、现代牧业、学生奶产品】；
            //（2）计算大区的特仑苏品牌达成率=大区的月度特仑苏品牌产品的销售计划总量（包含主体和垂直，折后回复金额）/ 月度特仑苏品牌产品的销售任务总量（包含主体和垂直，折后销售额）；
            //（3）达成率=Max（大区全品达成率，大区特仑苏品牌达成率）；
            //（4）核销比例=根据（3）中的结果和以下判断条件进行取值
            //A.达成率≥90%，核销比例=1；
            //B.80%≤达成率＜90%，核销比例=0.9；
            //C.达成率＜80%，核销比例=0。
            //（5）大区的年度授权费用=月度预算对应的年度预算上的预算总金额字段值；
            //（6）大区的特仑苏苗条装系列的销售达成进度=特仑苏苗条装产品的月度销售计划总量（主体，折后回复金额）/ 特仑苏苗条装产品全年销售任务量（取对应年度预算上的年度目标量）【注：特仑苏苗条装产品包括 : 特仑苏纯牛奶全脂灭菌乳利乐苗条装250ml×12包（一物一码）、特仑苏纯牛奶苗条装250ml×12盒，业务单元取主体】
            //（7）月度分解金额=（4）*（5）*（6），进而计算下月度分解金额和年初分解金额的差异（＝月份分解金额字段值-年初分解金额字段值）字段值，并更新该条月度预算的冻结后可用金额和累计可用金额。
            //
            //2.特仑苏统筹（总部）
            //2.1涉及数据表来源：每年情况不同，23年是这样
            //销售计划表：业态为常温，业务单元为主体和垂直重客，年月为月度预算对应年月；
            //2.2进行以下计算：
            //（1）特仑苏整体费用=和林销售组织20116000下经销商+分子公司的特仑苏纯牛奶苗条装250ml×12盒产品的销售计划总量（回复数量）*预算对应的年度力度（取所计算的月度预算的年度力度字段值）；
            //（2）特仑苏统筹的月度预算的月度分解金额=（1）- 特仑苏授权（各大区的月度分解金额之和）；

            //年度预算
            List<YearBudgetVo> yearBudgetVos = yearBudgetSdkService.findYearBudgetByYearBudgetCodes(new ArrayList<>(yearBudgetCodeSet));
            Map<String, YearBudgetVo> yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));

            //特仑苏授权
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            salesPlanDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesPlanDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
            salesPlanDto.setYearMonthLy(yearMonthLy);
            salesPlanDto.setSalesOrgRegionCodeList(new ArrayList<>(salesOrgSet));
            salesPlanDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
            //全品销售计划
            List<SalesPlanVo> salesPlanVos = salesPlanService.sumReplayRestore(salesPlanDto);
            Map<String, BigDecimal> mapSalesPlanAll = CollectionUtils.isEmpty(salesPlanVos) ? Maps.newHashMap() : salesPlanVos.stream()
                    .filter(item -> null != item.getDiscountRestoreAmount())
                    .collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesPlanVo::getDiscountRestoreAmount));
            //特仑苏销售计划
            salesPlanDto.setProductBrandCode("130009");
            salesPlanDto.setExcludeProductCategoryCodeList(null);
            List<SalesPlanVo> salesPlanVosDeluxu = salesPlanService.sumReplayRestore(salesPlanDto);
            Map<String, BigDecimal> mapSalesPlanDeluxu = CollectionUtils.isEmpty(salesPlanVosDeluxu) ? Maps.newHashMap() : salesPlanVosDeluxu.stream()
                    .filter(item -> null != item.getDiscountRestoreAmount())
                    .collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesPlanVo::getDiscountRestoreAmount));
            //特仑苏苗条装产品销售计划
            salesPlanDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
            salesPlanDto.setProductBrandCode(null);
            salesPlanDto.setSalesProductCodeList(Arrays.asList("130100003394", "130100000138"));
            List<SalesPlanVo> salesPlanVosSlender = salesPlanService.sumReplayRestore(salesPlanDto);
            Map<String, BigDecimal> mapSalesPlanSlender = CollectionUtils.isEmpty(salesPlanVosSlender) ? Maps.newHashMap() : salesPlanVosSlender.stream()
                    .filter(item -> null != item.getDiscountRestoreAmount())
                    .collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesPlanVo::getDiscountRestoreAmount));

            //全品销售任务
            SalesGoalDto salesGoalDto = new SalesGoalDto();
            salesGoalDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
            salesGoalDto.setYearMonthLy(yearMonthLy);
            salesGoalDto.setSalesOrgRegionList(new ArrayList<>(salesOrgSet));
            salesGoalDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
            salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
            List<SalesGoalVo> salesGoalVos = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalAll = CollectionUtils.isEmpty(salesGoalVos) ? Maps.newHashMap() : salesGoalVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏销售任务
            salesGoalDto.setProductBrandCode("130009");
            salesGoalDto.setExcludeProductCategoryCodeList(null);
            List<SalesGoalVo> salesGoalVosDeluxu = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalDeluxu = CollectionUtils.isEmpty(salesGoalVosDeluxu) ? Maps.newHashMap() : salesGoalVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏苗条装产品销售任务
            salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
            salesGoalDto.setProductBrandCode(null);
            salesGoalDto.setIncludeProductCodeList(Arrays.asList("130100003394", "130100000138"));
            List<SalesGoalVo> salesGoalVosSlender = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalSlender = CollectionUtils.isEmpty(salesGoalVosSlender) ? Maps.newHashMap() : salesGoalVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏统筹
            Map<String, BigDecimal> mapSalesPlanHead = new HashMap<>();
            if (budgetItemCodeSet.contains("Z0030")) {
                salesPlanDto.setSalesProductCodeList(Arrays.asList("130100000138"));
                salesPlanDto.setSalesOrgRegionCodeList(null);
                salesPlanDto.setSalesInstitutionCode("20116000");
                List<SalesPlanVo> salesPlanVosHead = salesPlanService.sumReplayRestore(salesPlanDto);
                mapSalesPlanHead = CollectionUtils.isEmpty(salesPlanVosHead) ? Maps.newHashMap() : salesPlanVosHead.stream().collect(Collectors.groupingBy(SalesPlanVo::getYearMonthLy,
                        Collectors.reducing(BigDecimal.ZERO, SalesPlanVo::getDiscountPlanAmount, BigDecimal::add)));
            }


            for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                BigDecimal budgetTotalAmount = yearBudgetVoMap.get(monthBudgetEntity.getYearBudgetCode()).getBudgetTotalAmount();

                BigDecimal planAll = mapSalesPlanAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal planDeluxu = mapSalesPlanDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal goalAll = mapSalesGoalAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal goalDeluxu = mapSalesGoalDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal planSlender = mapSalesPlanSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal goalSlender = mapSalesGoalSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);

                //大区的全品达成率
                BigDecimal planAllRate = goalAll.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planAll.divide(goalAll, 4, BigDecimal.ROUND_HALF_UP);
                //大区的特仑苏品牌达成率
                BigDecimal planDeluxuRate = goalDeluxu.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planDeluxu.divide(goalDeluxu, 4, BigDecimal.ROUND_HALF_UP);
                //大区的特仑苏苗条装系列的销售达成率
                BigDecimal planSlenderRate = goalSlender.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planSlender.divide(goalSlender, 4, BigDecimal.ROUND_HALF_UP);
                BigDecimal maxRate = planAllRate.max(planDeluxuRate);
                if (maxRate.compareTo(new BigDecimal("0.9")) >= 0) {
                    maxRate = BigDecimal.ONE;
                } else if (maxRate.compareTo(new BigDecimal("0.9")) < 0 && maxRate.compareTo(new BigDecimal("0.8")) >= 0) {
                    maxRate = new BigDecimal("0.9");
                } else {
                    maxRate = BigDecimal.ZERO;
                }
                BigDecimal monthArea = maxRate.multiply(budgetTotalAmount).multiply(planSlenderRate).setScale(2, BigDecimal.ROUND_HALF_UP);
                if ("Z0030".equals(monthBudgetEntity.getBudgetItemCode())) {
                    BigDecimal head = mapSalesPlanHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO);
                    head = head.multiply(StringUtils.isNotBlank(monthBudgetEntity.getBudgetIntensity()) ? new BigDecimal(monthBudgetEntity.getBudgetIntensity()) : BigDecimal.ZERO);
                    monthArea = head.subtract(monthArea);
                }

                monthBudgetEntity.setCalAmount(monthArea);
                monthBudgetEntity.setFirstReplyAmount(monthArea);
                //差异费用
                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                // 更新月度预算上回复量
                monthBudgetEntity.setComputedResult("完成");
                this.monthBudgetRepository.updateById(monthBudgetEntity);
                MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), null, BudgetOperationTypeEnum.REPLAY.getCode(), null);
                monthBudgetDetailService.create(monthBudgetDetailDto);
            }
            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 特仑苏统筹和授权预算项目计算月度实销回复差
     *
     * @param ids
     */
    @Override
    public void manualActualReplayDiffDeluxuMonth(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");

            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                String yearMonthNum = yearMonthLy.replace("-", "");
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();

                Set<String> budgetItemCodeSet = new HashSet<>();
                Set<String> salesOrgSet = new HashSet<>();
                Set<String> yearBudgetCodeSet = new HashSet<>();
                thisMonthBudgetEntityList.forEach(e -> {
                    if (!"Z0019".equals(e.getBudgetItemCode()) && !"Z0030".equals(e.getBudgetItemCode())) {
                        throw new RuntimeException("所选月度预算必须为品类政策费用-特仑苏授权或品类政策费用-特仑苏统筹预算项目！");
                    }
                    budgetItemCodeSet.add(e.getBudgetItemCode());
                    salesOrgSet.add(e.getSalesOrgCode());
                    yearBudgetCodeSet.add(e.getYearBudgetCode());
                });

            //1.1特仑苏授权（各大区月度，经销商&分子公司）
            //1.1.1涉及数据表来源：每年情况不同，23年是这样
            //（1）主体日销售表：年月为月度预算对应年月；
            //（2）主体日销售明细报表：订单类型为ZOR5和ZOR8；
            //（3）垂直销售业绩表：年月为月度预算对应年月；
            //（4）销售任务表：业态为常温，业务单元为主体和垂直重客，年月为月度预算对应年月，年度任务分类为内控；
            //1.1.2进行以下步骤计算：
            //（1）计算大区的全品达成率=大区的月度全品的实销总金额（包括主体和垂直）/ 月度全品的销售任务总量（包含主体和垂直，折后销售额）【注：全品里需剔除乳饮料、现代牧业、学生奶】；
            //（2）计算大区的特仑苏品牌达成率=大区的月度特仑苏品牌产品的实销总金额（包括主体和垂直）/ 月度特仑苏品牌产品的销售任务总量（包含主体和垂直，折后销售额）；
            //（3）达成率=Max（大区全品达成率，大区特仑苏品牌达成率）；
            //（4）核销比例=根据（3）中的结果和以下判断条件进行取值
            //A.达成率≥90%，核销比例=1；
            //B.80%≤达成率＜90%，核销比例=0.9；
            //C.达成率＜80%，核销比例=0。
            //（5）大区的年度授权费用=月度预算对应的年度预算上的预算总金额；
            //（6）大区的特仑苏苗条装系列的销售达成进度=特仑苏苗条装产品的月度实销总金额（主体） / 特仑苏苗条装产品全年销售任务量（取对应年度预算上的年度目标量）【注：特仑苏苗条装产品：特仑苏纯牛奶全脂灭菌乳利乐苗条装250ml×12包（一物一码）、特仑苏纯牛奶苗条装250ml×12盒，业务单元取主体】
            //（7）实销量口径费用字段值（即实销量口径预算）=（4）*（5）*（6），得到该月度预算的实销量口径费用字段值，进而计算实销回复差字段值（＝实销量口径费用字段值-月度分解金额字段值）
            //
            //1.2特仑苏统筹（总部月度）
            //1.2.1涉及数据表来源：每年情况不同，23年是这样
            //（1）主体日销售表：年月为月度预算对应年月；
            //（2）主体日销售明细报表：订单类型为ZOR5和ZOR8；
            //1.2.2进行以下计算：
            //（1）特仑苏整体费用=和林销售组织下经销商+分子公司的特仑苏纯牛奶苗条装250ml×12盒产品的实际销售件数*预算对应的年度力度；
            //（2）特仑苏统筹的月度分解金额=（1）- 特仑苏授权（各大区的实际销售金额之和）；

            //年度预算
            List<YearBudgetVo> yearBudgetVos = yearBudgetSdkService.findYearBudgetByYearBudgetCodes(new ArrayList<>(yearBudgetCodeSet));
            Map<String, YearBudgetVo> yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));

            //特仑苏授权
            MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
            mainOnedaySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            mainOnedaySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            mainOnedaySalesDataDto.setYearMonthLy(yearMonthNum);
            mainOnedaySalesDataDto.setSalesOrgRegionCodeList(new ArrayList<>(salesOrgSet));
            mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
            //全品日销售表
            List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, BigDecimal> mapMainOnedaySalesAll = CollectionUtils.isEmpty(mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
            //特仑苏日销售表
            mainOnedaySalesDataDto.setProductBrandCode("130009");
            mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(null);
            List<MainOnedaySalesDataVo> mainOnedaySalesDataDeluxu = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, BigDecimal> mapMainOnedaySalesDeluxu = CollectionUtils.isEmpty(mainOnedaySalesDataDeluxu) ? Maps.newHashMap() : mainOnedaySalesDataDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
            //特仑苏苗条装产品日销售表
            mainOnedaySalesDataDto.setProductBrandCode(null);
            mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100003394", "130100000138"));
            List<MainOnedaySalesDataVo> mainOnedaySalesDataSlenderVos = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, BigDecimal> mapMainOnedaySalesDataSlender = CollectionUtils.isEmpty(mainOnedaySalesDataSlenderVos) ? Maps.newHashMap() : mainOnedaySalesDataSlenderVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));

            //全品日销售明细
            TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
            dailySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            dailySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            dailySalesDataDto.setYearMonthLy(yearMonthNum);
            dailySalesDataDto.setSalesOrgRegionCodeList(new ArrayList<>(salesOrgSet));
            List<TpmDailySalesDataVo> dailySalesDataVos = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, BigDecimal> mapDailySalesData = CollectionUtils.isEmpty(dailySalesDataVos) ? Maps.newHashMap() : dailySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
            //特仑苏日销售明细
            dailySalesDataDto.setBrand("特仑苏");
            List<TpmDailySalesDataVo> dailySalesDataVosDeluxu = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, BigDecimal> mapDailySalesDataDeluxu = CollectionUtils.isEmpty(dailySalesDataVosDeluxu) ? Maps.newHashMap() : dailySalesDataVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
            //特仑苏苗条装产品日销售明细
            dailySalesDataDto.setBrand(null);
            dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100003394", "130100000138"));
            List<TpmDailySalesDataVo> dailySalesDataVosSlender = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, BigDecimal> mapDailySalesDataSlender = CollectionUtils.isEmpty(dailySalesDataVosSlender) ? Maps.newHashMap() : dailySalesDataVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));

            //全品销售任务
            SalesGoalDto salesGoalDto = new SalesGoalDto();
            salesGoalDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
            salesGoalDto.setYearMonthLy(yearMonthLy);
            salesGoalDto.setSalesOrgRegionList(new ArrayList<>(salesOrgSet));
            salesGoalDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
            salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
            List<SalesGoalVo> salesGoalVos = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalAll= CollectionUtils.isEmpty(salesGoalVos) ? Maps.newHashMap() : salesGoalVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏销售任务
            salesGoalDto.setProductBrandCode("130009");
            salesGoalDto.setExcludeProductCategoryCodeList(null);
            List<SalesGoalVo> salesGoalVosDeluxu = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalDeluxu= CollectionUtils.isEmpty(salesGoalVosDeluxu) ? Maps.newHashMap() : salesGoalVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏苗条装产品销售任务
            salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
            salesGoalDto.setProductBrandCode(null);
            salesGoalDto.setIncludeProductCodeList(Arrays.asList("130100003394", "130100000138"));
            List<SalesGoalVo> salesGoalVosSlender = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalSlender= CollectionUtils.isEmpty(salesGoalVosSlender) ? Maps.newHashMap() : salesGoalVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏统筹
            Map<String, BigDecimal> mapMainOnedaySalesDataHead = new HashMap<>();
            Map<String, BigDecimal> mapDailySalesDataHead = new HashMap<>();
            if (budgetItemCodeSet.contains("Z0030")) {
                mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100000138"));
                mainOnedaySalesDataDto.setSalesOrgRegionCodeList(null);
                mainOnedaySalesDataDto.setSalesInstitutionCode("20116000");
                List<MainOnedaySalesDataVo> mainOnedaySalesDataHead = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                mapMainOnedaySalesDataHead = CollectionUtils.isEmpty(mainOnedaySalesDataHead) ? Maps.newHashMap() : mainOnedaySalesDataHead.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthLy,
                        Collectors.reducing(BigDecimal.ZERO, MainOnedaySalesDataVo::getDiscountBehindSaleAmount, BigDecimal::add)));
                dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100000138"));
                dailySalesDataDto.setSalesOrgRegionCodeList(null);
                dailySalesDataDto.setSalesInstitutionCode("20116000");
                List<TpmDailySalesDataVo> dailySalesDataHead = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                mapDailySalesDataHead = CollectionUtils.isEmpty(dailySalesDataHead) ? Maps.newHashMap() : dailySalesDataHead.stream().collect(Collectors.groupingBy(TpmDailySalesDataVo::getYearMonthLy,
                        Collectors.reducing(BigDecimal.ZERO, TpmDailySalesDataVo::getAfterDiscountAmt, BigDecimal::add)));
            }


            for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                BigDecimal budgetTotalAmount = yearBudgetVoMap.get(monthBudgetEntity.getYearBudgetCode()).getBudgetTotalAmount();

                String yearMonthLyNum = monthBudgetEntity.getYearMonthLy().replace("-", "");
                BigDecimal mainOnedaySalesAll = mapMainOnedaySalesAll.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal mainOnedaySalesDeluxu = mapMainOnedaySalesDeluxu.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal mainOnedaySalesDataSlender = mapMainOnedaySalesDataSlender.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal dailySalesDataAll = mapDailySalesData.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal dailySalesDataDeluxu = mapDailySalesDataDeluxu.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal dailySalesDataSlender = mapDailySalesDataSlender.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal goalAll = mapSalesGoalAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal goalDeluxu = mapSalesGoalDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                BigDecimal goalSlender = mapSalesGoalSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);

                //大区的全品达成率
                BigDecimal planAllRate = goalAll.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (mainOnedaySalesAll.add(dailySalesDataAll)).divide(goalAll, 4, BigDecimal.ROUND_HALF_UP);
                //大区的特仑苏品牌达成率
                BigDecimal planDeluxuRate = goalDeluxu.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (mainOnedaySalesDeluxu.add(dailySalesDataDeluxu)).divide(goalDeluxu, 4, BigDecimal.ROUND_HALF_UP);
                //大区的特仑苏苗条装系列的销售达成率
                BigDecimal planSlenderRate = goalSlender.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (mainOnedaySalesDataSlender.add(dailySalesDataSlender)).divide(goalSlender, 4, BigDecimal.ROUND_HALF_UP);
                BigDecimal maxRate = planAllRate.max(planDeluxuRate);
                if (maxRate.compareTo(new BigDecimal("0.9")) >= 0) {
                    maxRate = BigDecimal.ONE;
                } else if (maxRate.compareTo(new BigDecimal("0.9")) < 0 && maxRate.compareTo(new BigDecimal("0.8")) >= 0) {
                    maxRate = new BigDecimal("0.9");
                } else {
                    maxRate = BigDecimal.ZERO;
                }
                BigDecimal monthArea = maxRate.multiply(budgetTotalAmount).multiply(planSlenderRate).setScale(2, BigDecimal.ROUND_HALF_UP);
                if ("Z0030".equals(monthBudgetEntity.getBudgetItemCode())) {
                    BigDecimal head = mapMainOnedaySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO).add(
                            mapDailySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO)
                    );
                    head = head.multiply(StringUtils.isNotBlank(monthBudgetEntity.getBudgetIntensity()) ? new BigDecimal(monthBudgetEntity.getBudgetIntensity()) : BigDecimal.ZERO);
                    monthArea = head.subtract(monthArea);
                }
                monthBudgetEntity.setActualSales(monthArea);
            }
                thisMonthBudgetEntityList.forEach(entity -> {
                    entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
                });
                monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);

            List<String> thisIdList = thisMonthBudgetEntityList.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList());
            Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper)
                    .basic()
                    .builder();
            actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff(v, null));

            }

        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 特仑苏统筹和授权预算项目计算季度实销回复差
     *
     * @param ids
     */
    @Override
    public void manualActualReplayDiffDeluxuQuarter(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        boolean lock = false;
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            //加锁
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lock, "其他人正在操作数据,加锁失败,请稍后重试!");


            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                String yearMonthNum = yearMonthLy.replace("-", "");
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();

            Set<String> budgetItemCodeSet = new HashSet<>();
            Set<String> yearMonthSet = new HashSet<>();
            Set<String> yearMonthNumSet = new HashSet<>();
            Set<String> salesOrgSet = new HashSet<>();
            Set<String> yearBudgetCodeSet = new HashSet<>();
                thisMonthBudgetEntityList.forEach(e -> {
                if (!"Z0019".equals(e.getBudgetItemCode()) && !"Z0030".equals(e.getBudgetItemCode())) {
                    throw new RuntimeException("所选月度预算必须为品类政策费用-特仑苏授权或品类政策费用-特仑苏统筹预算项目！");
                }
                Map<String, Set<String>> quarterMonth = getQuarterMonth(e.getYearMonthLy());
                budgetItemCodeSet.add(e.getBudgetItemCode());
                yearMonthSet.addAll(quarterMonth.get("yearMonthLySet"));
                yearMonthNumSet.addAll(quarterMonth.get("yearMonthLyNumSet"));
                salesOrgSet.add(e.getSalesOrgCode());
                yearBudgetCodeSet.add(e.getYearBudgetCode());
            });
            if (CollectionUtils.isEmpty(yearMonthSet)) {
                throw new RuntimeException("当前数据月份属于第一季度，无需计算季度实销回复差！");
            }

            //2.1特仑苏授权（各大区季度）
            //2.1.1涉及数据表来源：
            //（1）主体日销售表：年月时间范围为所计算的季度；
            //（2）主体日销售明细报表：订单类型为ZOR5和ZOR8；
            //（3）垂直销售业绩表：年月时间范围为所计算的季度；
            //（4）销售任务表：业态为常温，业务单元为主体和垂直重客，年月时间范围为所计算的季度，年度任务分类为内控；
            //2.1.2进行以下步骤计算：
            //（1）计算大区的全品达成率=大区的季度全品的实销总金额（包括主体和垂直）/ 季度全品的销售任务总量（包括主体和垂直，折后销售额）【注：全品里需剔除乳饮料、现代牧业、学生奶】；
            //（2）计算大区的特仑苏品牌达成率=大区的季度特仑苏品牌产品的实销总金额（包括主体和垂直，包括主体和垂直）/ 季度特仑苏品牌产品的销售任务总量（包括主体和垂直，折后销售额）；
            //（3）达成率=Max（大区全品达成率，大区特仑苏品牌达成率）；
            //（4）核销比例=根据（3）中的结果和以下判断条件进行取值
            //A.达成率≥90%，核销比例=1；
            //B.80%≤达成率＜90%，核销比例=0.9；
            //C.达成率＜80%，核销比例=0。
            //（5）大区的年度授权费用=月度预算对应的年度预算上的预算总金额；
            //（6）大区的特仑苏苗条装系列的销售达成进度=特仑苏苗条装产品季度实销总金额 / 特仑苏苗条装产品全年销售任务量（取对应年度预算上的年度目标量）【注：特仑苏苗条装产品：特仑苏纯牛奶全脂灭菌乳利乐苗条装250ml×12包（一物一码）、特仑苏纯牛奶苗条装250ml×12盒，业务单元取主体】
            //（7）季度的实际销售金额（即实销量口径预算）=（4）*（5）*（6）
            //（8）若（7）不为0，则大区补兑费用=（7）- 季度中月度实际销售金额之和，将该补兑费用记录在当前月度的预算的调整中，并更新对应的冻结后可用金额和累计可用余额。
            //
            //2.2特仑苏统筹（总部季度）
            //2.2.1涉及数据表来源：每年情况不同，23年是这样
            //（1）主体日销售表：年月为月度预算对应年月；
            //（2）主体日销售明细报表：订单类型为ZOR5和ZOR8；
            //2.2.2进行以下计算：
            //（1）特仑苏整体费用=和林销售组织下经销商+分子公司的特仑苏纯牛奶苗条装250ml×12盒产品的实际销售件数*预算对应的年度力度；
            //（2）特仑苏统筹的月度分解金额=（1）- 特仑苏授权（各大区的实际销售金额之和）；

            //年度预算
            List<YearBudgetVo> yearBudgetVos = yearBudgetSdkService.findYearBudgetByYearBudgetCodes(new ArrayList<>(yearBudgetCodeSet));
            Map<String, YearBudgetVo> yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));

            //特仑苏授权
            MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
            mainOnedaySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            mainOnedaySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            mainOnedaySalesDataDto.setYearMonthLy(yearMonthNum);
            mainOnedaySalesDataDto.setSalesOrgRegionCodeList(new ArrayList<>(salesOrgSet));
            mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
            //全品日销售表
            List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, BigDecimal> mapMainOnedaySalesAll = CollectionUtils.isEmpty(mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
            //特仑苏日销售表
            mainOnedaySalesDataDto.setProductBrandCode("130009");
            mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(null);
            List<MainOnedaySalesDataVo> mainOnedaySalesDataDeluxu = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, BigDecimal> mapMainOnedaySalesDeluxu = CollectionUtils.isEmpty(mainOnedaySalesDataDeluxu) ? Maps.newHashMap() : mainOnedaySalesDataDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
            //特仑苏苗条装产品日销售表
            mainOnedaySalesDataDto.setProductBrandCode(null);
            mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100003394", "130100000138"));
            List<MainOnedaySalesDataVo> mainOnedaySalesDataSlenderVos = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
            Map<String, BigDecimal> mapMainOnedaySalesDataSlender = CollectionUtils.isEmpty(mainOnedaySalesDataSlenderVos) ? Maps.newHashMap() : mainOnedaySalesDataSlenderVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));

            //全品日销售明细
            TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
            dailySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            dailySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            dailySalesDataDto.setYearMonthLyList(new ArrayList<>(yearMonthNumSet));
            dailySalesDataDto.setSalesOrgRegionCodeList(new ArrayList<>(salesOrgSet));
            List<TpmDailySalesDataVo> dailySalesDataVos = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, BigDecimal> mapDailySalesData = CollectionUtils.isEmpty(dailySalesDataVos) ? Maps.newHashMap() : dailySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
            //特仑苏日销售明细
            dailySalesDataDto.setBrand("特仑苏");
            List<TpmDailySalesDataVo> dailySalesDataVosDeluxu = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, BigDecimal> mapDailySalesDataDeluxu = CollectionUtils.isEmpty(dailySalesDataVosDeluxu) ? Maps.newHashMap() : dailySalesDataVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
            //特仑苏苗条装产品日销售明细
            dailySalesDataDto.setBrand(null);
            dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100003394", "130100000138"));
            List<TpmDailySalesDataVo> dailySalesDataVosSlender = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
            Map<String, BigDecimal> mapDailySalesDataSlender = CollectionUtils.isEmpty(dailySalesDataVosSlender) ? Maps.newHashMap() : dailySalesDataVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));

            //全品销售任务
            SalesGoalDto salesGoalDto = new SalesGoalDto();
            salesGoalDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
            salesGoalDto.setYearMonthLy(yearMonthLy);
            salesGoalDto.setSalesOrgRegionList(new ArrayList<>(salesOrgSet));
            salesGoalDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
            salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
            List<SalesGoalVo> salesGoalVos = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalAll= CollectionUtils.isEmpty(salesGoalVos) ? Maps.newHashMap() : salesGoalVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏销售任务
            salesGoalDto.setProductBrandCode("130009");
            salesGoalDto.setExcludeProductCategoryCodeList(null);
            List<SalesGoalVo> salesGoalVosDeluxu = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalDeluxu= CollectionUtils.isEmpty(salesGoalVosDeluxu) ? Maps.newHashMap() : salesGoalVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏苗条装产品销售任务
            salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
            salesGoalDto.setProductBrandCode(null);
            salesGoalDto.setIncludeProductCodeList(Arrays.asList("130100003394", "130100000138"));
            List<SalesGoalVo> salesGoalVosSlender = salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
            Map<String, BigDecimal> mapSalesGoalSlender= CollectionUtils.isEmpty(salesGoalVosSlender) ? Maps.newHashMap() : salesGoalVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
            //特仑苏统筹
            Map<String, BigDecimal> mapMainOnedaySalesDataHead = new HashMap<>();
            Map<String, BigDecimal> mapDailySalesDataHead = new HashMap<>();
            if (budgetItemCodeSet.contains("Z0030")) {
                mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100000138"));
                mainOnedaySalesDataDto.setSalesOrgRegionCodeList(null);
                mainOnedaySalesDataDto.setSalesInstitutionCode("20116000");
                List<MainOnedaySalesDataVo> mainOnedaySalesDataHead = mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                mapMainOnedaySalesDataHead = CollectionUtils.isEmpty(mainOnedaySalesDataHead) ? Maps.newHashMap() : mainOnedaySalesDataHead.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthLy,
                        Collectors.reducing(BigDecimal.ZERO, MainOnedaySalesDataVo::getDiscountBehindSaleAmount, BigDecimal::add)));
                dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100000138"));
                dailySalesDataDto.setSalesOrgRegionCodeList(null);
                dailySalesDataDto.setSalesInstitutionCode("20116000");
                List<TpmDailySalesDataVo> dailySalesDataHead = tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                mapDailySalesDataHead = CollectionUtils.isEmpty(dailySalesDataHead) ? Maps.newHashMap() : dailySalesDataHead.stream().collect(Collectors.groupingBy(TpmDailySalesDataVo::getYearMonthLy,
                        Collectors.reducing(BigDecimal.ZERO, TpmDailySalesDataVo::getAfterDiscountAmt, BigDecimal::add)));
            }


            for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                BigDecimal budgetTotalAmount = yearBudgetVoMap.get(monthBudgetEntity.getYearBudgetCode()).getBudgetTotalAmount();

                Map<String, Set<String>> quarterMonth = getQuarterMonth(monthBudgetEntity.getYearMonthLy());
                Set<String> yearMonthLyNumSet = quarterMonth.get("yearMonthLyNumSet");
                if (CollectionUtils.isEmpty(yearMonthLyNumSet)) {
                    continue;
                }
                AtomicReference<BigDecimal> mainOnedaySalesAll = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> mainOnedaySalesDeluxu = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> mainOnedaySalesDataSlender = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> dailySalesDataAll = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> dailySalesDataDeluxu = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> dailySalesDataSlender = new AtomicReference<>(BigDecimal.ZERO);
                yearMonthLyNumSet.forEach(e -> {
                    mainOnedaySalesAll.set(mainOnedaySalesAll.get().add(mapMainOnedaySalesAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    mainOnedaySalesDeluxu.set(mainOnedaySalesDeluxu.get().add(mapMainOnedaySalesDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    mainOnedaySalesDataSlender.set(mainOnedaySalesDataSlender.get().add(mapMainOnedaySalesDataSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    dailySalesDataAll.set(dailySalesDataAll.get().add(mapDailySalesData.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    dailySalesDataDeluxu.set(dailySalesDataDeluxu.get().add(mapDailySalesDataDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    dailySalesDataSlender.set(dailySalesDataSlender.get().add(mapDailySalesDataSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                });
                Set<String> yearMonthLySet = quarterMonth.get("yearMonthLySet");
                AtomicReference<BigDecimal> goalAll = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> goalDeluxu = new AtomicReference<>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> goalSlender = new AtomicReference<>(BigDecimal.ZERO);
                yearMonthLySet.forEach(e -> {
                    goalAll.set(goalAll.get().add(mapSalesGoalAll.getOrDefault(e + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    goalDeluxu.set(goalDeluxu.get().add(mapSalesGoalDeluxu.getOrDefault(e + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    goalSlender.set(goalSlender.get().add(mapSalesGoalSlender.getOrDefault(e + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                });

                //大区的全品达成率
                BigDecimal planAllRate = goalAll.get().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (mainOnedaySalesAll.get().add(dailySalesDataAll.get())).divide(goalAll.get(), 4, BigDecimal.ROUND_HALF_UP);
                //大区的特仑苏品牌达成率
                BigDecimal planDeluxuRate = goalDeluxu.get().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (mainOnedaySalesDeluxu.get().add(dailySalesDataDeluxu.get())).divide(goalDeluxu.get(), 4, BigDecimal.ROUND_HALF_UP);
                //大区的特仑苏苗条装系列的销售达成率
                BigDecimal planSlenderRate = goalSlender.get().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : (mainOnedaySalesDataSlender.get().add(dailySalesDataSlender.get())).divide(goalSlender.get(), 4, BigDecimal.ROUND_HALF_UP);
                BigDecimal maxRate = planAllRate.max(planDeluxuRate);
                if (maxRate.compareTo(new BigDecimal("0.9")) >= 0) {
                    maxRate = BigDecimal.ONE;
                } else if (maxRate.compareTo(new BigDecimal("0.9")) < 0 && maxRate.compareTo(new BigDecimal("0.8")) >= 0) {
                    maxRate = new BigDecimal("0.9");
                } else {
                    maxRate = BigDecimal.ZERO;
                }
                BigDecimal monthArea = maxRate.multiply(budgetTotalAmount).multiply(planSlenderRate).setScale(2, BigDecimal.ROUND_HALF_UP);
                if ("Z0030".equals(monthBudgetEntity.getBudgetItemCode())) {
                    BigDecimal head = mapMainOnedaySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO).add(
                            mapDailySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO)
                    );
                    head = head.multiply(StringUtils.isNotBlank(monthBudgetEntity.getBudgetIntensity()) ? new BigDecimal(monthBudgetEntity.getBudgetIntensity()) : BigDecimal.ZERO);
                    monthArea = head.subtract(monthArea);
                }
                monthBudgetEntity.setActualSales(monthArea);
            }

                thisMonthBudgetEntityList.forEach(entity -> {
                    entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
                });
            monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);

            List<String> thisIdList = thisMonthBudgetEntityList.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList());
            Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper)
                    .basic()
                    .builder();
            actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff(v, null));

            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 获取当前年月上一季度的年月
     *
     * @param yearMonthLy
     * @return
     */
    Map<String, Set<String>> getQuarterMonth(String yearMonthLy) {
        Set<String> yearMonthLySet = new HashSet<>();
        Set<String> yearMonthLyNumSet = new HashSet<>();
        String[] split = yearMonthLy.split("-");
        int month = Integer.valueOf(split[1]);
        if (month > 3 && month <= 6) {
            yearMonthLyNumSet.add(split[0] + "01");
            yearMonthLyNumSet.add(split[0] + "02");
            yearMonthLyNumSet.add(split[0] + "03");
            yearMonthLySet.add(split[0] + "-" + "01");
            yearMonthLySet.add(split[0] + "-" + "02");
            yearMonthLySet.add(split[0] + "-" + "03");
        } else if (month > 6 && month <= 9) {
            yearMonthLyNumSet.add(split[0] + "04");
            yearMonthLyNumSet.add(split[0] + "05");
            yearMonthLyNumSet.add(split[0] + "06");
            yearMonthLySet.add(split[0] + "-" + "04");
            yearMonthLySet.add(split[0] + "-" + "05");
            yearMonthLySet.add(split[0] + "-" + "06");
        } else if (month > 9 && month <= 12) {
            yearMonthLyNumSet.add(split[0] + "07");
            yearMonthLyNumSet.add(split[0] + "08");
            yearMonthLyNumSet.add(split[0] + "09");
            yearMonthLySet.add(split[0] + "-" + "07");
            yearMonthLySet.add(split[0] + "-" + "08");
            yearMonthLySet.add(split[0] + "-" + "09");
        }
        return new HashMap<String, Set<String>>() {{
            put("yearMonthLySet", yearMonthLySet);
            put("yearMonthLyNumSet", yearMonthLyNumSet);
        }};
    }

    /**
     * 异步执行数据
     *
     * @param yearMonth
     * @param planFlag
     * @author huojia
     * @date 2023/1/31 20:52
     **/
    /*@Async*/
    @Override
    public void manualReplayYearMonth(String yearMonth, String planFlag, AbstractCrmUserIdentity crmUserIdentity) {

    }

    /**
     * 计算[首次回复预算金额]等，并保存数据
     *
     * @param finalBudgetItemVoMap 预算项目
     * @param calConfigDataVo      预算计算配置
     * @param monthBudgetEntity    月度预算实体
     * @param salesPlanVos         销售计划 （排除好的销售计划）
     * @author huojia
     * @date 2022/11/5 19:47
     **/
    @Transactional(rollbackFor = Exception.class)
    void buildData(Map<String, BudgetItemVo> finalBudgetItemVoMap,
                   BudgetCalConfigDataVo calConfigDataVo,
                   MonthBudgetEntity monthBudgetEntity,
                   List<SalesPlanVo> salesPlanVos,
                   String planFlag,
                   BudgetCalConfigVo budgetCalConfigVo) {
        // 销量目标为空，则只算按额
        // 根据销量计划计算[首次回复预算金额]
        AtomicReference<BigDecimal> reduce = new AtomicReference<>(BigDecimal.ZERO);

        //产品计费比例算好的金额 * 计费点数
        AtomicReference<BigDecimal> productRatioreduce = new AtomicReference<>(BigDecimal.ZERO);
        //获取管控类型
        BudgetItemControlConditionVo conditionVo = this.monthBudgetHelper.getBudgetItemControlCondition(monthBudgetEntity, finalBudgetItemVoMap);

        BigDecimal yearBudgetTotalPoint = null;
        YearBudgetEventDto eventDto = new YearBudgetEventDto();
        eventDto.setYearBudgetCode(monthBudgetEntity.getYearBudgetCode());
        eventDto.setSalesOrgCode(monthBudgetEntity.getSalesOrgCode());
        eventDto.setBusinessFormatCode(budgetCalConfigVo.getBusinessFormatCode());
        eventDto.setBusinessUnitCode(budgetCalConfigVo.getBusinessUnitCode());
        eventDto.setBudgetTypeCode(budgetCalConfigVo.getBudgetTypeCode());
        eventDto.setFeeBelongCode(budgetCalConfigVo.getFeeBelongCode());
        eventDto.setControlType(budgetCalConfigVo.getControlType());
        eventDto.setOrgAreaCode(budgetCalConfigVo.getOrgAreaCode());
        eventDto.setSalesOrgList(budgetCalConfigVo.getSalesOrgList());
        eventDto.setOrgCode(monthBudgetEntity.getOrgCode());
        eventDto.setGroupCode(monthBudgetEntity.getGroupCode());
        eventDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
        eventDto.setYearLy(DateUtil.dateToStr(DateUtil.strToDate(monthBudgetEntity.getYearMonthLy(), DateUtil.date_yyyy_MM)
                , DateUtil.date_yyyy));

        SerializableBiConsumer<YearBudgetEventListener, YearBudgetEventDto> getYearBudgetByCode =
                YearBudgetEventListener::getYearBudgetByCode;
        EventResponse eventResponse = this.nebulaNetEventClient.directPublish(eventDto, YearBudgetEventListener.class, getYearBudgetByCode);
        if (!Objects.isNull(eventResponse)) {
            YearBudgetResponse budgetResponse = (YearBudgetResponse) eventResponse;
            if (!Objects.isNull(budgetResponse.getBudgetTotalPoint())) {
                yearBudgetTotalPoint = budgetResponse.getBudgetTotalPoint().divide(new BigDecimal(100), 8, BigDecimal.ROUND_HALF_UP);
            }
        }

        //金额类型
        String amountTypeCode = calConfigDataVo.getAmountTypeCode();
        log.error("金额类型：{}，年度预算总点数={}", amountTypeCode, yearBudgetTotalPoint);
        if (!CollectionUtils.isEmpty(salesPlanVos)) {
            BigDecimal finalBudgetTotalPoint = yearBudgetTotalPoint;
            salesPlanVos.forEach(salesPlanVo -> {
                //汇总预算计算配置表中金额类型的金额
                this.monthBudgetHelper.calculationReduce(reduce, salesPlanVo, amountTypeCode, budgetCalConfigVo, monthBudgetEntity, finalBudgetTotalPoint);
            });
        }
        log.info("月度预算计划量/回复量，reduce=:{}", reduce.get());
        // 根据预算项目上配置的管控类型（按额、按率）；
        //（1）按率：首次回复量*点数（回复量取首次回复金额，过程数据源变化不更新）：回复量一直会变，基本在当月25-26号左右回复下月的，指的是算下个月回复预算金额时取下月第一次回复的时间（也就是当月25-26号），下个月过程中回复量变化不能影响做个值变化
        //（2）按额：等于年初分解金额。
        BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
        if (finalBudgetItemVoMap.containsKey(monthBudgetEntity.getBudgetItemCode())) {
            //管控类型
            String controlTypeCode = conditionVo.getControlTypeCode();
            if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlTypeCode)) {
                monthBudgetEntity.setFirstReplyAmount(monthBudgetEntity.getInitResolveAmount());
                monthBudgetEntity.setCalAmount(BigDecimal.ZERO);
                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));

                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));

                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            } else if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) {
                Assert.notNull(monthBudgetEntity.getBudgetTotalPoint(), "预算项目" + monthBudgetEntity.getBudgetItemCode() + "预算点数不能为空！");
                BigDecimal budgetTotalPoint = monthBudgetEntity.getBudgetTotalPoint().divide(new BigDecimal(100), 8, RoundingMode.HALF_UP);
                monthBudgetEntity.setFirstReplyAmount(reduce.get().multiply(budgetTotalPoint));
                monthBudgetEntity.setCalAmount(reduce.get());
                monthBudgetEntity.setFirstReplyResolveDiffAmount(
                        Optional.ofNullable(monthBudgetEntity.getFirstReplyAmount()).orElse(BigDecimal.ZERO)
                                .subtract(Optional.ofNullable(monthBudgetEntity.getInitResolveAmount()).orElse(BigDecimal.ZERO))
                );

                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            } else if (BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
                //按力度
                //(1）计算数据取跟预算项目关联产品的数据进行统计
                //(2）月度分解金额=计算数据*年度力度
                //----------------------------
                //计算数据
                BigDecimal calculatingData = reduce.get();
                //获取年度预算力度
                //分子
                BigDecimal budgetIntensityNumerator = monthBudgetEntity.getBudgetIntensityNumerator();
                //分母
                BigDecimal budgetIntensityDenominator = monthBudgetEntity.getBudgetIntensityDenominator();

                monthBudgetEntity.setFirstReplyAmount(monthBudgetEntity.getInitResolveAmount());
                monthBudgetEntity.setCalAmount(calculatingData);
                //月度分解金额
                monthBudgetEntity.setFirstReplyAmount(calculatingData
                        .multiply(budgetIntensityNumerator).divide(budgetIntensityDenominator, 6, BigDecimal.ROUND_HALF_UP));

                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));

                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
            }
        }
        monthBudgetEntity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
        // 更新月度预算上回复量
        monthBudgetEntity.setComputedResult("完成");
        this.monthBudgetRepository.updateById(monthBudgetEntity);
        MonthBudgetDetailDto monthBudgetDetailDto = new MonthBudgetDetailDto();
        if (BooleanEnum.TRUE.getCapital().equals(planFlag)) {
            monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(),beforeAmount, BudgetOperationTypeEnum.PLAN.getCode(), null);
        } else {
            monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(),beforeAmount, BudgetOperationTypeEnum.REPLAY.getCode(), null);
        }
        monthBudgetDetailService.create(monthBudgetDetailDto);
    }

    /**
     * 1.实销量与回复量差额：（实销量-回复量）*点数；根据预算项目上配置的管控类型（按额、按率）；
     * （1）按额：默认等于0；
     * （2）按率：根据预算管控维度配置的规则；
     * （2.1）不滚动：差异原路返回（2月1-2号，计算的是1月份实销量与回复差额，体现在1月份的调整金额中，更新1月的累计可用金额）
     * （2.2）滚动：全部滚动、结余滚动、超支滚动；
     * （2.2.1）全部滚动：差异体现在发生月份（2月1-2号，计算的是1月份实销量与回复差额，体现在2月份的调整金额中，更新2月的累计可用金额），不区分正负数；
     * （2.2.2）结余滚动：实销量与回复量差值为正数时滚动到发生月份，差值为负数不滚动；
     * （2.2.3）超支滚动：实销量与回复量差值为负数时滚动到发生月份，差值为正数不滚动。
     *
     * @param ids
     * @author huojia
     * @date 2022/11/16 15:16
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void manualActualReplayDiff(List<String> ids) {
        Validate.notEmpty(ids, "请选择要手工执行实销量与回复量差额的数据！");
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        this.calActualReplayDiff(ids);
    }

    /**
     * 手动执行滚动
     * 上月滚动金额：根据预算管控维度配置的规则；
     * （1）不滚动：等于0；
     * （2）滚动：全部滚动、结余滚动、超支滚动；
     * a.全部滚动：等于同一维度下M-1月（不跨年）的月度累计可用金额（不判断正负数）；
     * b.结余滚动：判断M-1月累计可用金额是否正数，为正数才计入M月的上月滚动金额字段；
     * c.超支滚动：判断M-1月累计可用金额是否负数，为负数才计入M月的上月滚动金额字段；
     * 注：手动滚动（按钮）：需记录是否滚动成功的标记，如果滚动时发现没有可滚动的预算，则标记为否，可手动将未滚动成功的数据进行滚动。
     * <p>
     * 上述金额都要记录操作明细日志
     *
     * @param ids
     * @author huojia
     * @date 2022/11/5 20:11
     **/
    @Override
    public void manualRolling(List<String> ids) {
        Validate.notEmpty(ids, "请选择要手工执行滚动的数据！");
        List<MonthBudgetEntity> currMonthBudgetList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(currMonthBudgetList)) {
            return;
        }
        //当前年月时间
        String currDateStr = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH);
        Date currDate = DateUtil.parseDate(currDateStr, DateUtil.DEFAULT_YEAR_MONTH);
        currMonthBudgetList.forEach(monthbudget -> {
            String yearMonthLy = monthbudget.getYearMonthLy();
            Date monthbudgetDate = DateUtil.parseDate(yearMonthLy, DateUtil.DEFAULT_YEAR_MONTH);
            Assert.isTrue(monthbudgetDate.compareTo(currDate) <= 0, "所选月度预算年月不能大于当前年月");
        });
        //区分费用归口，总部 不加销售机构 大区才加

        //查询预算管控配置 key: 业态+业务单元+销售机构
        Map<String, List<DimensionControlsVo>> dimensionControlMap = this.monthBudgetHelper.findDimensionControl();
        //查询预算管控配置 key: 业态+业务单元
        Map<String, List<DimensionControlsVo>> dimensionControlMap2 = this.monthBudgetHelper.findDimensionControlNoSalesOrg();
        //按年度预算分组
        Map<String, List<MonthBudgetEntity>> yearBudgetCodeMap = currMonthBudgetList.stream()
                .filter(k -> StringUtil.isNotEmpty(k.getYearBudgetCode()))
                .collect(Collectors.groupingBy(MonthBudgetEntity::getYearBudgetCode));
        yearBudgetCodeMap.forEach((yearBudgetCode, monthBudgetEntities) -> {
            //年月排序升序
            monthBudgetEntities.stream().sorted(Comparator.comparing(MonthBudgetEntity::getYearMonthLy))
                    .forEach(entity -> {
                        String yearMonthLy = entity.getYearMonthLy();
                        //如果为一月直接跳过
                        String[] yearMonthArray = yearMonthLy.split("-");
                        LocalDate currMonthBudgetLocalDate = LocalDate.of(Integer.parseInt(yearMonthArray[0]), Integer.parseInt(yearMonthArray[1]), 1);
                        int monthValue = currMonthBudgetLocalDate.getMonthValue();
                        if (monthValue == 1) {
                            return;
                        }
                        log.error("月份:{}", entity.getYearMonthLy());
                        //管控纬度key
                        List<DimensionControlsVo> dimensionControlsVos = null;
                        if (FeeBelongEnum.HEAD.getCode().equals(entity.getFeeBelongCode())) {
                            String dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode();
                            dimensionControlsVos = dimensionControlMap2.get(dimensionControlKey);
                        } else {
                            String dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getSalesOrgCode();
                            dimensionControlsVos = dimensionControlMap.get(dimensionControlKey);
                        }
                        if (CollectionUtils.isEmpty(dimensionControlsVos)) {
                            return;
                        }
                        //管控维度
//                    AtomicReference<DimensionControlsVo> dimensionControlsVoAtomic = new AtomicReference<>();
//                    dimensionControlsVos.forEach(dc -> {
//                        if (!CollectionUtils.isEmpty(dc.getBudgetItemCodeList())
//                            && dc.getBudgetItemCodeList().contains(entity.getBudgetItemCode())) {
//                            dimensionControlsVoAtomic.set(dc);
//                        }
//                    });
//                    DimensionControlsVo dimensionControlsVo = dimensionControlsVoAtomic.get();
                        DimensionControlsVo dimensionControlsVo = this.monthBudgetHelper.matchDimensionControl(dimensionControlsVos, entity.getBudgetItemCode());

                        log.error("预算滚动管控配置：{}", JSONObject.toJSONString(dimensionControlsVo));
                        if (org.springframework.util.ObjectUtils.isEmpty(dimensionControlsVo)) {
                            return;
                        }
                        //判断是否滚动
                        if (BooleanEnum.TRUE.getCapital().equals(dimensionControlsVo.getIfRolling())) {
                            //查询上月月度预算
                            LocalDate lastLocalDate = currMonthBudgetLocalDate.minusMonths(1);
                            String lastYearMonth = lastLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
                            MonthBudgetEntity lastMonthBudget = this.monthBudgetRepository
                                    .findByYearMonthAndYearBudgetCode(lastYearMonth, yearBudgetCode);
                            if (org.springframework.util.ObjectUtils.isEmpty(lastMonthBudget)) {
                                return;
                            }
                        /*//判断是否已滚动
                        if (BooleanEnum.TRUE.getCapital().equals(lastMonthBudget.getIfRolling())) {
                            return;
                        }*/
                            //加锁
                            boolean lock = true;
                            List<String> lockKeys = Lists.newArrayList(entity.getMonthBudgetCode()
                                    , lastMonthBudget.getMonthBudgetCode());
                            try {
                                lock = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
                                if (lock) {
                                    this.calRolling(entity.getId(), lastMonthBudget.getId(),
                                            dimensionControlsVo.getRollingType());
                                }
                            } finally {
                                if (lock) {
                                    monthBudgetLockService.unLock(lockKeys);
                                }
                            }
                        }
                    });
        });
    }

    /**
     * 月度计划滚动
     *
     * @param currId
     * @param lastId
     * @param rollingType
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void calRolling(String currId, String lastId, String rollingType) {
        this.monthBudgetHelper.calRolling(currId, lastId, rollingType);
    }


    /**
     * 批量计算月度预算回复量
     *
     * @param id
     * @param planFlag
     * @author huojia
     * @date 2022/11/16 19:08
     **/
    public void calPlanReplay(String id, Map<String, BudgetItemVo> budgetItemVoMap, String planFlag) {
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getById(id);
        // 能找到对应计算配置的，才能通过销售计划进行计算 首次回复预算金额
        BudgetItemVo budgetItemVo = budgetItemVoMap.get(monthBudgetEntity.getBudgetItemCode());
        //获取管控条件
        BudgetItemControlConditionVo conditionVo = this.monthBudgetHelper
                .getBudgetItemControlCondition(monthBudgetEntity, budgetItemVoMap);
        log.error("获取管控条件：{}", JSONObject.toJSONString(conditionVo));
        if (org.springframework.util.ObjectUtils.isEmpty(conditionVo)) {
            monthBudgetEntity.setBudgetCalCode("");
            monthBudgetEntity.setComputedResult("未匹配到管控类型");
            this.monthBudgetRepository.updateById(monthBudgetEntity);
            return;
        }
        // 根据年度预算维度，查询对应计算配置    主体有费用归口，其他的有没有呢？
        MonthBudgetVo monthBudgetVo = this.nebulaToolkitService
                .copyObjectByWhiteList(monthBudgetEntity, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        //查询预算计算配置
        BudgetCalConfigVo budgetCalConfigVo = this.monthBudgetHelper
                .findMonthBudgetCalConfigByDto(monthBudgetVo, conditionVo.getControlTypeCode());
        log.error("获取预算计算配置：{}", JSONObject.toJSONString(budgetCalConfigVo));
        // 没维护计算配置则不进行计算，跳过当前循环
        if (org.springframework.util.ObjectUtils.isEmpty(budgetCalConfigVo)) {
            monthBudgetEntity.setBudgetCalCode("");
            this.monthBudgetRepository.updateById(monthBudgetEntity);
            return;
        }
        monthBudgetEntity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
        // 区分数据来源：销售计划、实际销售数据
        List<SalesPlanVo> salesPlanVos = new ArrayList<>();
        //取数为销售计划
        BudgetCalConfigDataVo calConfigDataVo = this.monthBudgetHelper.findMonthBudgetCalConfigData(budgetCalConfigVo, planFlag);
        log.error("获取计算配置数据配置：{}", JSONObject.toJSONString(calConfigDataVo));
        if (org.springframework.util.ObjectUtils.isEmpty(calConfigDataVo)) {
            monthBudgetEntity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
            this.monthBudgetRepository.updateById(monthBudgetEntity);
            return;
        }
        // 主体电商
        if (BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetEntity.getBusinessUnitCode())
                || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            salesPlanVos = this.listSalesPlan(budgetCalConfigVo, monthBudgetEntity);
            log.error("销售计划数据条数={}，总金额={}", salesPlanVos.size(),
                    salesPlanVos.stream().map(SalesPlanVo::getDiscountRestoreAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        // 垂直逻辑
        if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            salesPlanVos = this.listVerticalSalesPlan(budgetCalConfigVo, monthBudgetEntity);
        }
        //判断是否存在销售数据和计算数据
        // 主体逻辑：归口只会是总部、大区；
        if (BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetEntity.getBusinessUnitCode())
                || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            // 计算[首次回复预算金额]等，并保存数据
            this.buildData(budgetItemVoMap, calConfigDataVo, monthBudgetEntity, salesPlanVos, planFlag, budgetCalConfigVo);
        }
        // 垂直逻辑
        if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            // 计算[首次回复预算金额]等，并保存数据
            this.buildVerticalData(budgetItemVoMap, calConfigDataVo, monthBudgetEntity, salesPlanVos, planFlag, budgetCalConfigVo);
        }
    }

    /**
     * 垂直增加计算逻辑
     *
     * @param budgetCalConfigVo
     * @param monthBudgetEntity
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>
     * @author huojia
     * @date 2023/1/11 15:52
     **/
    private List<SalesPlanVo> listVerticalSalesPlan(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        SalesPlanDto salesPlanDto = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class);
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        //当前年月
        String currYearMonth = DateUtil.dateToStr(new SimpleDateFormat("yyyy-MM"));
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            //非包含产品这里加一个年月过滤
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream()
                    .filter(o -> !org.springframework.util.StringUtils.hasText(o.getFilYearMonth())
                            || (org.springframework.util.StringUtils.hasText(o.getFilYearMonth()) && currYearMonth.equals(o.getFilYearMonth())))
                    .map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeProductCodeList(productCodeList);
        }
        // 查询销量计划，用于计算[首次回复预算金额]，但是只有管控类型为按率的场景才进行计算
        return salesPlanService.listByConditions(salesPlanDto);
    }

    /**
     * 主体、电商查询销售计划
     *
     * @return java.util.List<com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>
     * @author huojia
     * @date 2023/1/11 15:46
     **/
    private List<SalesPlanVo> listSalesPlan(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        SalesPlanDto salesPlanDto = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class);
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getCustomerList())) {
            List<String> customerCodeList = budgetCalConfigVo.getCustomerList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeProductCodeList(productCodeList);
        }
        // 销售组织范围：全部、当前、自选；全部则不用查询客户过滤；当前需要按月度预算上的组织查询下级；自选则直接按所选销售组织查询
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (StringUtils.isEmpty(monthBudgetEntity.getSalesOrgCode()) && StringUtils.isEmpty(monthBudgetEntity.getOrgCode())) {
                return Lists.newArrayList();
            }
            String salesOrgCode = null;
            // 获取年度预算上当前组织
            if (!StringUtils.isEmpty(monthBudgetEntity.getSalesOrgCode())) {
                salesOrgCode = monthBudgetEntity.getSalesOrgCode();
            } else {
                if (!StringUtils.isEmpty(monthBudgetEntity.getOrgCode())) {
                    OrgVo byOrgCode = orgVoService.findByOrgCode(monthBudgetEntity.getOrgCode());
                    salesOrgCode = byOrgCode.getSalesOrgCode();
                }
            }
            if (StringUtils.isEmpty(salesOrgCode)) {
                return Lists.newArrayList();
            }
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCode(salesOrgCode);
            if (CollectionUtils.isEmpty(salesOrgVos)) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getErpCode).collect(Collectors.toList());
            saleOrgCodeList.add(salesOrgCode);
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(salesPlanDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(salesPlanDto.getExcludeCustomerCodeList());
            }
            salesPlanDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            // 自定义的组织，自选组织
            if (CollectionUtils.isEmpty(budgetCalConfigVo.getSalesOrgList())) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream()
                    .map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull)
                    .collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(salesPlanDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(salesPlanDto.getExcludeCustomerCodeList());
            }
            salesPlanDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUR_CUSTOMER.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (!CollectionUtils.isEmpty(salesPlanDto.getExcludeCustomerCodeList())) {
                salesPlanDto.getExcludeCustomerCodeList().remove(monthBudgetEntity.getCustomerCode());
            }
            salesPlanDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
        }
        //判断是否为按力度
        String controlType = budgetCalConfigVo.getControlType();
        if (BudgetControlTypeEnum.INTENSITY.getCode().equals(controlType) || BudgetControlTypeEnum.RATIO.getCode().equals(controlType)) {
            //根据预算范围的产品过滤
            List<BudgetCalConfigAreaVo> budgetItemList = budgetCalConfigVo.getBudgetItemList();
            if (!CollectionUtils.isEmpty(budgetItemList)) {
                Set<String> productCodes = Sets.newHashSet();
                //预算项目维护的产品
                budgetItemList.stream().filter(o -> o.getDataCode().equals(monthBudgetEntity.getBudgetItemCode())).forEach(o -> {
                    List<BudgetCalConfigScopeProductVo> scopeProducts = o.getScopeProducts();
                    if (!CollectionUtils.isEmpty(scopeProducts)) {
                        scopeProducts.forEach(product -> {
                            productCodes.add(product.getProductCode());
                        });
                    }
                });
                salesPlanDto.setSalesProductCodeList(Lists.newArrayList(productCodes));
                //和产品非包含互斥
                if (!CollectionUtils.isEmpty(productCodes)) {
                    salesPlanDto.setExcludeProductCodeList(null);
                }
            }
        }

        // 查询销量计划，用于计算[首次回复预算金额]，但是只有管控类型为按率的场景才进行计算
        return salesPlanService.listByConditions(salesPlanDto);
    }

    /**
     * 构建垂直预算
     *
     * @param finalBudgetItemVoMap
     * @param calConfigDataVo
     * @param monthBudgetEntity
     * @param salesPlanVos
     * @param planFlag
     * @author huojia
     * @date 2023/1/11 14:21
     **/
    private void buildVerticalData(Map<String, BudgetItemVo> finalBudgetItemVoMap,
                                   BudgetCalConfigDataVo calConfigDataVo,
                                   MonthBudgetEntity monthBudgetEntity,
                                   List<SalesPlanVo> salesPlanVos,
                                   String planFlag,
                                   BudgetCalConfigVo budgetCalConfigVo) {
        // 销量目标为空，则只算按额
        // 根据销量计划计算[首次回复预算金额]
        AtomicReference<BigDecimal> reduce = new AtomicReference<>(BigDecimal.ZERO);
        //产品计费比例算好的金额 * 计费点数
        AtomicReference<BigDecimal> productRatioreduce = new AtomicReference<>(BigDecimal.ZERO);
        //获取管控类型
        BudgetItemControlConditionVo conditionVo = this.monthBudgetHelper.getBudgetItemControlCondition(monthBudgetEntity, finalBudgetItemVoMap);
        //拿到配置的产品计费比例
        List<BudgetCalConfigProductRatioVo> productRatios = budgetCalConfigVo.getProductRatios();
        Map<String, BudgetCalConfigProductRatioVo> productRatioVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(productRatios)) {
            productRatioVoMap.putAll(productRatios.stream().collect(Collectors.toMap(BudgetCalConfigProductRatioVo::getProductCode, e -> e)));
        }
        //产品计费比例计算数据值
        AtomicReference<BigDecimal> reduceRatio = new AtomicReference<>(BigDecimal.ZERO);
        //金额类型
        String amountTypeCode = calConfigDataVo.getAmountTypeCode();
        // 销量目标为空，则只算按额
        if (!CollectionUtils.isEmpty(salesPlanVos)) {
            salesPlanVos.forEach(salesPlanVo -> {
                //产品编码
                String productCode = salesPlanVo.getProductCode();
                BudgetCalConfigProductRatioVo budgetCalConfigProductRatioVo = productRatioVoMap.get(productCode);
                // 折前计划量
                if (SalesPlanAmountTypeEnum.PLAN_AMOUNT.getCode().equals(amountTypeCode)) {
                    BigDecimal amount = Optional.ofNullable(salesPlanVo.getPlanAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add(reduce.get()));
                    //计费比例
                    if (!org.springframework.util.ObjectUtils.isEmpty(budgetCalConfigProductRatioVo)) {
                        BigDecimal productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add(reduceRatio.get()));
                    }
                }
                // 折后计划量
                if (SalesPlanAmountTypeEnum.DISCOUNT_PLAN_AMOUNT.getCode().equals(amountTypeCode)) {
                    BigDecimal amount = Optional.ofNullable(salesPlanVo.getDiscountPlanAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add(reduce.get()));
                    //计费比例
                    if (!org.springframework.util.ObjectUtils.isEmpty(budgetCalConfigProductRatioVo)) {
                        BigDecimal productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add(reduceRatio.get()));
                    }
                }
                // 折前回复金额
                if (SalesPlanAmountTypeEnum.RESTORE_AMOUNT.getCode().equals(amountTypeCode)) {
                    BigDecimal amount = Optional.ofNullable(salesPlanVo.getRestoreAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add(reduce.get()));
                    //计费比例
                    if (!org.springframework.util.ObjectUtils.isEmpty(budgetCalConfigProductRatioVo)) {
                        BigDecimal productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add(reduceRatio.get()));
                    }
                }
                // 折后回复金额
                if (SalesPlanAmountTypeEnum.DISCOUNT_RESTORE_AMOUNT.getCode().equals(amountTypeCode)) {
                    BigDecimal amount = Optional.ofNullable(salesPlanVo.getDiscountRestoreAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add(reduce.get()));
                    //计费比例
                    if (!org.springframework.util.ObjectUtils.isEmpty(budgetCalConfigProductRatioVo)) {
                        BigDecimal productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add(reduceRatio.get()));
                    }
                }
                // 出库数*产品到岸价
                if (SalesPlanAmountTypeEnum.DELIVERY_MULTIPLY_PRICE.getCode().equals(amountTypeCode)) {
                    // reduce.set(Optional.ofNullable(salesPlanVo.get()).orElse(BigDecimal.ZERO).add(reduce.get()));
                }

            });
        }
        // 根据预算项目上配置的管控类型（按额、按率）；
        //（1）按率：首次回复量*点数（回复量取首次回复金额，过程数据源变化不更新）：回复量一直会变，基本在当月25-26号左右回复下月的，指的是算下个月回复预算金额时取下月第一次回复的时间（也就是当月25-26号），下个月过程中回复量变化不能影响做个值变化
        //（2）按额：等于年初分解金额。
        BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
        if (finalBudgetItemVoMap.containsKey(monthBudgetEntity.getBudgetItemCode())) {
            // BigDecimal firstReplyResolveDiffAmount = Optional.ofNullable(monthBudgetEntity.getFirstReplyResolveDiffAmount()).orElse(BigDecimal.ZERO);
            if (BudgetControlTypeEnum.AMOUNT.getCode().equals(conditionVo.getControlTypeCode())) {
                monthBudgetEntity.setFirstReplyAmount(monthBudgetEntity.getInitResolveAmount());
                monthBudgetEntity.setCalAmount(reduce.get());
                monthBudgetEntity.setFirstReplyResolveDiffAmount(
                        Optional.ofNullable(monthBudgetEntity.getFirstReplyAmount()).orElse(BigDecimal.ZERO)
                                .subtract(Optional.ofNullable(monthBudgetEntity.getInitResolveAmount()).orElse(BigDecimal.ZERO))
                );
                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalance(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmount(monthBudgetEntity, BusinessUnitEnum.VERTICAL));

                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            } else if (BudgetControlTypeEnum.RATIO.getCode().equals(conditionVo.getControlTypeCode()) && monthBudgetEntity.getBudgetTotalPoint() != null) {
                //计算月度分解金额
                //判断是预算计算配置否维护了产品计费比例
                if (!CollectionUtils.isEmpty(productRatios)) {
                    monthBudgetEntity.setFirstReplyAmount(reduceRatio.get());
                } else {
                    BigDecimal budgetTotalPoint = monthBudgetEntity.getBudgetTotalPoint().divide(new BigDecimal(100), 6, RoundingMode.HALF_UP);
                    monthBudgetEntity.setFirstReplyAmount(reduce.get().multiply(budgetTotalPoint));
                }

                monthBudgetEntity.setCalAmount(reduce.get());
                monthBudgetEntity.setFirstReplyResolveDiffAmount(
                        Optional.ofNullable(monthBudgetEntity.getFirstReplyAmount()).orElse(BigDecimal.ZERO)
                                .subtract(Optional.ofNullable(monthBudgetEntity.getInitResolveAmount()).orElse(BigDecimal.ZERO))
                );

                //累计可用
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                        .buildAccumulatedAvailableBalance(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                //冻结可用
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                        .buildAfterFreezeAmount(monthBudgetEntity, BusinessUnitEnum.VERTICAL));

                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            }
        }
        // 更新月度预算上回复量
        monthBudgetEntity.setComputedResult("完成");
        this.monthBudgetRepository.updateById(monthBudgetEntity);
        MonthBudgetDetailDto monthBudgetDetailDto = new MonthBudgetDetailDto();
        if (BooleanEnum.TRUE.getCapital().equals(planFlag)) {
            monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(),beforeAmount, BudgetOperationTypeEnum.PLAN.getCode(), null);
        } else {
            monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(),beforeAmount, BudgetOperationTypeEnum.REPLAY.getCode(), null);
        }
        monthBudgetDetailService.create(monthBudgetDetailDto);
    }

    /**
     * 批量计算实销量与回复量差额
     *
     * @param ids
     * @author huojia
     * @date 2022/11/17 0:04
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void calActualReplayDiff(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<MonthBudgetEntity> monthBudgetList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        List<String> monthBudgetCodeList = monthBudgetList.stream()
                .map(MonthBudgetEntity::getMonthBudgetCode)
                .collect(Collectors.toList());
        Map<String, List<MonthBudgetEntity>> monthMap = monthBudgetList.stream()
                .collect(Collectors.groupingBy(MonthBudgetEntity::getYearBudgetCode));
        // 查询预算项目
        Set<String> budgetItemCodeSet = monthBudgetList.stream().map(MonthBudgetEntity::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<String, BudgetItemVo> budgetItemVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(budgetItemCodeSet)) {
            List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(new ArrayList<>(budgetItemCodeSet));
            if (!CollectionUtils.isEmpty(budgetItemVos)) {
                budgetItemVoMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity(), (oldVo, newVo) -> newVo));
            }
        }
        // 查询对应一月月度预算
        Set<String> yearBudgetSet = monthBudgetList.stream().map(MonthBudgetEntity::getYearBudgetCode).collect(Collectors.toSet());
        Set<String> yearMonthSet = monthBudgetList.stream().map(entity -> entity.getYearMonthLy().split("-")[0] + "-" + MonthConstant.JANUARY).collect(Collectors.toSet());
        List<MonthBudgetEntity> januaryList = this.getByYearMonthCodeAndMonth(Lists.newArrayList(yearBudgetSet), new ArrayList<>(yearMonthSet));
        Map<String, MonthBudgetEntity> januaryMap = januaryList.stream().collect(Collectors.toMap(MonthBudgetEntity::getYearBudgetCode, Function.identity()));
        List<String> januaryCodeList = januaryList.stream().map(MonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
        // 一月的预算也进行批量加锁
        monthBudgetCodeList.addAll(januaryCodeList);
        Map<String, BudgetItemVo> finalBudgetItemVoMap = budgetItemVoMap;
        // 查询管控配置
        // 查询预算管控配置，执行手动滚动
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<DimensionControlsVo> dimensionControlsVos = dimensionControlsService.listByConditions(dimensionControlsDto);
        if (CollectionUtils.isEmpty(dimensionControlsVos)) {
            return;
        }
        Map<String, List<DimensionControlsVo>> controlMap = dimensionControlsVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getMarketOrganization()));

        boolean lock = true;

        // 按年度预算划分，避免事务问题
        try {
            lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lock, "实销量与回复量差额计算失败，当前预算操作中，请稍后！");
            monthMap.forEach((yearBudgetCode, subMonthBudgetList) -> {
                // 同一年度预算下所有月度预算对应预算项目编码一致
                if (!finalBudgetItemVoMap.containsKey(subMonthBudgetList.get(0).getBudgetItemCode())) {
                    return;
                }
                BudgetItemVo budgetItemVo = finalBudgetItemVoMap.get(subMonthBudgetList.get(0).getBudgetItemCode());
                // 获取管控配置
                List<BudgetItemControlConditionVo> conditionVos = budgetItemVo.getControlConditionDtoList().stream()
                        .filter(controlVo -> subMonthBudgetList.get(0).getBusinessFormatCode().equals(controlVo.getBusinessFormatCode())
                                && subMonthBudgetList.get(0).getBusinessUnitCode().equals(controlVo.getBusinessUnitCode()))
                        .collect(Collectors.toList());
                if (CollectionUtils.isEmpty(conditionVos)) {
                    return;
                }
                // 按额管控不做计算
                String controlType = conditionVos.get(0).getControlTypeCode();
                if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlType)) {
                    return;
                }
                // 查询计算配置
                BudgetCalConfigDto budgetCalConfigDto = this.nebulaToolkitService.copyObjectByWhiteList(
                        subMonthBudgetList.get(0), BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class
                );
                budgetCalConfigDto.setBudgetTypeCode(BudgetTypeEnum.MONTH_BUDGET.getCode());
                budgetCalConfigDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                List<BudgetCalConfigVo> budgetCalConfigVos = budgetCalConfigService.listByConditions(budgetCalConfigDto);
                // 没维护计算配置则不进行计算，跳过当前循环
                if (CollectionUtils.isEmpty(budgetCalConfigVos)) {
                    return;
                }
                List<BudgetCalConfigDataVo> dataVoList = new ArrayList<>();
                budgetCalConfigVos.forEach(budgetCalConfigVo -> {
                    dataVoList.addAll(budgetCalConfigVo.getDataList().stream()
                            .filter(budgetCalConfigDataVo -> CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode().equals(budgetCalConfigDataVo.getCalDataFromCode()))
                            .collect(Collectors.toList()));
                });
                if (CollectionUtils.isEmpty(dataVoList)) {
                    return;
                }
                BudgetCalConfigDataVo budgetCalConfigDataVo = dataVoList.get(0);
                BudgetCalConfigVo budgetCalConfigVo = budgetCalConfigVos.stream().filter(vo -> vo.getBudgetCalCode().equals(budgetCalConfigDataVo.getBudgetCalCode())).collect(Collectors.toList()).get(0);
                Map<String, List<MainOnedaySalesDataVo>> oneDayMap = new HashMap<>();
                Map<String, SalesPerformanceSumVo> salesPerformanceSumMap = new HashMap<>();
                if (BusinessUnitEnum.isDefaultBusinessUnit(subMonthBudgetList.get(0).getBusinessUnitCode())) {
                    // 获取实销量（接口获取？）
                    List<MainOnedaySalesDataVo> mainOnedaySalesDataVoList = this.listMainOneDay(budgetCalConfigVo, subMonthBudgetList.get(0));
                    if (!CollectionUtils.isEmpty(mainOnedaySalesDataVoList)) {
                        List<MainOnedaySalesDataVo> collect = mainOnedaySalesDataVoList.stream()
                                .filter(vo -> !StringUtils.isEmpty(vo.getYearMonthDay())).collect(Collectors.toList());
                        collect.forEach(mainOnedaySalesDataVo -> {
                            String[] split = mainOnedaySalesDataVo.getYearMonthDay().split("-");
                            mainOnedaySalesDataVo.setYearMonthDay(split[0] + "-" + split[1]);
                        });
                        oneDayMap = collect.stream().filter(vo -> vo.getDiscountBehindSaleAmount() != null)
                                .collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthDay));
                    }
                } else if (BusinessUnitEnum.VERTICAL.getCode().equals(subMonthBudgetList.get(0).getBusinessUnitCode())) {
                    List<SalesPerformanceSumVo> salesPerformanceSumVoList = this.listPerformance(budgetCalConfigVo, subMonthBudgetList.get(0));
                    if (!CollectionUtils.isEmpty(salesPerformanceSumVoList)) {
                        salesPerformanceSumVoList.forEach(salesPerformanceSumVo -> {
                            if (!StringUtils.isEmpty(salesPerformanceSumVo.getSalesMonth())) {
                                Date yyyyMM = DateUtil.parse(salesPerformanceSumVo.getSalesMonth(), "yyyyMM");
                                String format = DateUtil.format(yyyyMM, DateUtil.DEFAULT_YEAR_MONTH);
                                salesPerformanceSumVo.setSalesMonth(format);
                            }
                        });
                        salesPerformanceSumMap = salesPerformanceSumVoList.stream().collect(Collectors.toMap(SalesPerformanceSumVo::getSalesMonth, Function.identity()));
                    }
                }
                Map<String, List<MainOnedaySalesDataVo>> finalOneDayMap = oneDayMap;
                Map<String, SalesPerformanceSumVo> finalSalesPerformanceSumMap = salesPerformanceSumMap;
                // 更新实销量
                MonthBudgetEntity januaryEntity = januaryMap.get(yearBudgetCode);
                this.refreshActualSales(subMonthBudgetList, budgetCalConfigDataVo, finalOneDayMap, finalSalesPerformanceSumMap, controlMap, januaryEntity);
            });
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /**
     * 更新实销数据
     *
     * @param subMonthBudgetList
     * @param budgetCalConfigDataVo
     * @param finalOneDayMap
     * @param finalSalesPerformanceSumMap
     * @author huojia
     * @date 2023/2/13 16:33
     **/
    private void refreshActualSales(List<MonthBudgetEntity> subMonthBudgetList,
                                    BudgetCalConfigDataVo budgetCalConfigDataVo,
                                    Map<String, List<MainOnedaySalesDataVo>> finalOneDayMap,
                                    Map<String, SalesPerformanceSumVo> finalSalesPerformanceSumMap,
                                    Map<String, List<DimensionControlsVo>> controlMap,
                                    MonthBudgetEntity januaryEntity) {
        AtomicReference<String> rollingType = new AtomicReference<>("");
        AtomicReference<String> isRolling = new AtomicReference<>(BooleanEnum.FALSE.getCapital());

        AtomicReference<BigDecimal> januaryActualSalesReplayDiffAmount = new AtomicReference<>(BigDecimal.ZERO);
        subMonthBudgetList.forEach(monthBudgetEntity -> {
            BigDecimal actualSales = this.buildActualSales(monthBudgetEntity, budgetCalConfigDataVo, finalOneDayMap, finalSalesPerformanceSumMap);
            String controlKey = monthBudgetEntity.getBusinessFormatCode() + monthBudgetEntity.getBusinessUnitCode() + monthBudgetEntity.getSalesOrgCode();
            if (controlMap.containsKey(controlKey)) {
                List<DimensionControlsVo> dimensionControlsList = controlMap.get(controlKey);
                dimensionControlsList.forEach(dimensionControlsVo -> {
                    if (!CollectionUtils.isEmpty(dimensionControlsVo.getBudgetItemCodeList()) && dimensionControlsVo.getBudgetItemCodeList().contains(monthBudgetEntity.getBudgetItemCode())) {
                        rollingType.set(dimensionControlsVo.getRollingType());
                        isRolling.set(dimensionControlsVo.getIfRolling());
                    }
                });
            }
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            // 减去上次实销与回复差异，保证不会重复计算
            BigDecimal lastAdjustAmount = Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO);
            BigDecimal lastActualSalesReplayDiffAmount = Optional.ofNullable(monthBudgetEntity.getLastActualSalesReplayDiffAmount()).orElse(BigDecimal.ZERO);
            BigDecimal calAmount = monthBudgetEntity.getCalAmount();
            BigDecimal curActualSalesReplayDiffAmount = (actualSales.subtract(Optional.ofNullable(calAmount).orElse(BigDecimal.ZERO)))
                    .multiply(Optional.ofNullable(monthBudgetEntity.getBudgetTotalPoint()).orElse(BigDecimal.ZERO))
                    .divide(new BigDecimal(100), RoundingMode.HALF_UP);
            BigDecimal curAdjustAmount = lastAdjustAmount.subtract(lastActualSalesReplayDiffAmount).add(curActualSalesReplayDiffAmount);
            BigDecimal curAccumulatedAvailableBalance = Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                    .subtract(lastActualSalesReplayDiffAmount)
                    .add(curActualSalesReplayDiffAmount);
            if (BooleanEnum.TRUE.getCapital().equals(isRolling.get())) {
                // a-全部滚动：差异体现在发生月份（2月1-2号，计算的是1月份实销量与回复差额，体现在2月份的调整金额中，更新2月的累计可用金额），不区分正负数；
                if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType.get())) {
                    monthBudgetEntity.setAdjustAmount(curAdjustAmount);
                    monthBudgetEntity.setLastActualSalesReplayDiffAmount(curActualSalesReplayDiffAmount);
                    monthBudgetEntity.setAccumulatedAvailableBalance(curAccumulatedAvailableBalance);
                    MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount),beforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
                // b-结余滚动：实销量与回复量差值为正数时滚动到发生月份，差值为负数不滚动；
                if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType.get())) {
                    if (BigDecimal.ZERO.compareTo(curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount)) < 0) {
                        monthBudgetEntity.setAdjustAmount(curAdjustAmount);
                        monthBudgetEntity.setLastActualSalesReplayDiffAmount(curActualSalesReplayDiffAmount);
                        monthBudgetEntity.setAccumulatedAvailableBalance(curAccumulatedAvailableBalance);
                        MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount),beforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
                        this.monthBudgetDetailService.create(monthBudgetDetailDto);
                    }
                }
                // c-超支滚动：实销量与回复量差值为负数时滚动到发生月份，差值为正数不滚动；
                if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType.get())) {
                    if (BigDecimal.ZERO.compareTo(curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount)) > 0) {
                        monthBudgetEntity.setAdjustAmount(curAdjustAmount);
                        monthBudgetEntity.setLastActualSalesReplayDiffAmount(curActualSalesReplayDiffAmount);
                        monthBudgetEntity.setAccumulatedAvailableBalance(curAccumulatedAvailableBalance);
                        MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount),beforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
                        this.monthBudgetDetailService.create(monthBudgetDetailDto);
                    }
                }
            } else {
                // 不滚动的情况做累加
                januaryActualSalesReplayDiffAmount.set(januaryActualSalesReplayDiffAmount.get().add(curActualSalesReplayDiffAmount));
            }
        });
        // 不滚动：差异原路返回（2月1-2号，计算的是1月份实销量与回复差额，体现在1月份的调整金额中，更新1月的累计可用金额）
        if (!BooleanEnum.TRUE.getCapital().equals(isRolling.get())) {
            BigDecimal lastActualSalesReplayDiffAmount = Optional.ofNullable(januaryEntity.getLastActualSalesReplayDiffAmount()).orElse(BigDecimal.ZERO);
            januaryEntity.setAdjustAmount(Optional.ofNullable(januaryEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)
                    .subtract(lastActualSalesReplayDiffAmount)
                    .add(januaryActualSalesReplayDiffAmount.get()));
            januaryEntity.setLastActualSalesReplayDiffAmount(januaryActualSalesReplayDiffAmount.get());
            BigDecimal januaryBeforeAmount = januaryEntity.getAccumulatedAvailableBalance();
            januaryEntity.setAccumulatedAvailableBalance(januaryEntity.getAccumulatedAvailableBalance().subtract(lastActualSalesReplayDiffAmount).add(januaryActualSalesReplayDiffAmount.get()));
            this.monthBudgetRepository.updateById(januaryEntity);
            this.buildDetail(januaryEntity, januaryActualSalesReplayDiffAmount.get().subtract(lastActualSalesReplayDiffAmount),januaryBeforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
        } else {
            this.monthBudgetRepository.updateBatchById(subMonthBudgetList);
        }
    }

    /**
     * 垂直
     *
     * @param budgetCalConfigVo
     * @param monthBudgetEntity
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo>
     * @author huojia
     * @date 2023/1/17 20:12
     **/
    private List<SalesPerformanceSumVo> listPerformance(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        SalesPerformanceDto salesPerformanceDto = new SalesPerformanceDto();
        salesPerformanceDto.setSalesDate(monthBudgetEntity.getYearMonthLy().split("-")[0]);
        salesPerformanceDto.setSalesMonth(monthBudgetEntity.getYearMonthLy().replace("-", ""));
        salesPerformanceDto.setRegion(monthBudgetEntity.getRegionCode());
        salesPerformanceDto.setSalesOrg(monthBudgetEntity.getSalesOrgCode());
        salesPerformanceDto.setRetailer(monthBudgetEntity.getSystemCode());
        salesPerformanceDto.setShipToparty(monthBudgetEntity.getTerminalCode());
        salesPerformanceDto.setBrand(monthBudgetEntity.getProductBrandCode());
        salesPerformanceDto.setCategoryCode(monthBudgetEntity.getProductItemCode());
        salesPerformanceDto.setMaterialCode(monthBudgetEntity.getProductCode());
        if (StringUtils.isEmpty(salesPerformanceDto.getMaterialCode())
                && !CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPerformanceDto.setExcludeProductCodeList(productCodeList);
        }
        return salesPerformanceVoService.listYearByConditions(salesPerformanceDto);
    }

    /**
     * 构建实销量数据
     *
     * @param finalOneDayMap
     * @return java.math.BigDecimal
     * @author huojia
     * @date 2023/1/17 17:05
     **/
    private BigDecimal buildActualSales(MonthBudgetEntity monthBudgetEntity,
                                        BudgetCalConfigDataVo budgetCalConfigDataVo,
                                        Map<String, List<MainOnedaySalesDataVo>> finalOneDayMap,
                                        Map<String, SalesPerformanceSumVo> salesPerformanceSumMap) {
        BigDecimal actualSales = BigDecimal.ZERO;
        if (BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetEntity.getBusinessUnitCode())) {
            if (ActualSalesAmountTypeEnum.DISCOUNT_BEHIND_SALE_AMOUNT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode())) {
                if (finalOneDayMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                    actualSales = finalOneDayMap.get(monthBudgetEntity.getYearMonthLy())
                            .stream().map(MainOnedaySalesDataVo::getDiscountBehindSaleAmount)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }
            if (ActualSalesAmountTypeEnum.ORDER_RULE_AMT_IN_REBATE.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode())) {
                if (finalOneDayMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                    actualSales = finalOneDayMap.get(monthBudgetEntity.getYearMonthLy())
                            .stream().map(MainOnedaySalesDataVo::getDiscountFrontSaleAmount)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }
            if (ActualSalesAmountTypeEnum.DISCOUNT_BEHIND_TAX_SALE_AMOUNT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode())) {
                if (finalOneDayMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                    actualSales = finalOneDayMap.get(monthBudgetEntity.getYearMonthLy())
                            .stream().map(MainOnedaySalesDataVo::getDiscountBehindTaxSaleAmount)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            if (ActualSalesAmountTypeEnum.DISCOUNT_BEHIND_SALE_AMOUNT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode())) {
                if (salesPerformanceSumMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                    actualSales = salesPerformanceSumMap.get(monthBudgetEntity.getYearMonthLy()).getOrderRuleAmtInRebateIncM();
                }
            }
            if (ActualSalesAmountTypeEnum.WAREHS_OUT_DISCOUNT_AMT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode())) {
                if (salesPerformanceSumMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                    actualSales = salesPerformanceSumMap.get(monthBudgetEntity.getYearMonthLy()).getWarehsOutDiscountAmtIncM();
                }
            }
        }
        return actualSales;
    }

    /**
     * 批量查询
     *
     * @param budgetCalConfigVo
     * @param monthBudgetEntity
     * @return java.util.List<com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo>
     * @author huojia
     * @date 2023/1/13 2:37
     **/
    private List<MainOnedaySalesDataVo> listMainOneDay(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
        mainOnedaySalesDataDto.setYearMonthDay(monthBudgetEntity.getYearMonthLy().split("-")[0]);
        mainOnedaySalesDataDto.setBusinessFormatCode(monthBudgetEntity.getBusinessFormatCode());
        mainOnedaySalesDataDto.setBusinessUnitCode(monthBudgetEntity.getBusinessUnitCode());
        mainOnedaySalesDataDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
        mainOnedaySalesDataDto.setProductBrandCode(monthBudgetEntity.getProductBrandCode());
        mainOnedaySalesDataDto.setProductCategoryCode(monthBudgetEntity.getProductCategoryCode());
        mainOnedaySalesDataDto.setProductItemCode(monthBudgetEntity.getProductItemCode());
        mainOnedaySalesDataDto.setTerminalCode(monthBudgetEntity.getTerminalCode());
        mainOnedaySalesDataDto.setSystemCode(monthBudgetEntity.getSystemCode());
        mainOnedaySalesDataDto.setSalesOrgRegionCode(monthBudgetEntity.getSalesOrgCode());

        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getCustomerList())) {
            List<String> customerCodeList = budgetCalConfigVo.getCustomerList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            mainOnedaySalesDataDto.setExcludeCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            mainOnedaySalesDataDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            mainOnedaySalesDataDto.setExcludeProductCodeList(productCodeList);
        }

        // 销售组织范围：全部、当前、自选；全部则不用查询客户过滤；当前需要按月度预算上的组织查询下级；自选则直接按所选销售组织查询
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (StringUtils.isEmpty(monthBudgetEntity.getSalesOrgCode()) && StringUtils.isEmpty(monthBudgetEntity.getOrgCode())) {
                return Lists.newArrayList();
            }
            String salesOrgCode = null;
            // 获取年度预算上当前组织
            if (!StringUtils.isEmpty(monthBudgetEntity.getSalesOrgCode())) {
                salesOrgCode = monthBudgetEntity.getSalesOrgCode();
            } else {
                if (!StringUtils.isEmpty(monthBudgetEntity.getOrgCode())) {
                    OrgVo byOrgCode = orgVoService.findByOrgCode(monthBudgetEntity.getOrgCode());
                    salesOrgCode = byOrgCode.getSalesOrgCode();
                }
            }
            if (StringUtils.isEmpty(salesOrgCode)) {
                return Lists.newArrayList();
            }
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCode(salesOrgCode);
            if (CollectionUtils.isEmpty(salesOrgVos)) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mainOnedaySalesDataDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(mainOnedaySalesDataDto.getExcludeCustomerCodeList());
            }
            mainOnedaySalesDataDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            // 自定义的组织，自选组织
            if (CollectionUtils.isEmpty(budgetCalConfigVo.getSalesOrgList())) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream()
                    .map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull)
                    .collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mainOnedaySalesDataDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(mainOnedaySalesDataDto.getExcludeCustomerCodeList());
            }
            mainOnedaySalesDataDto.setCustomerCodeList(customerCodeList);
        }
        return mainOnedaySaleDataService.listMainOnedaySalesData(mainOnedaySalesDataDto);
    }

    /**
     * 根据年度预算编码，加月份查询月度预算
     *
     * @param yearBudgetList
     * @param yearMonth
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity>
     * @author huojia
     * @date 2022/11/17 10:20
     **/
    private List<MonthBudgetEntity> getByYearMonthCodeAndMonth(List<String> yearBudgetList, List<String> yearMonth) {
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return null;
        }
        return this.monthBudgetRepository.getByYearMonthCodeAndMonth(yearBudgetList, yearMonth);
    }


    /**
     * 条件查询月度预算
     *
     * @param monthBudgetDto
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/11/22 14:46
     **/
    @Override
    public List<MonthBudgetVo> listByConditions(MonthBudgetDto monthBudgetDto) {
        Validate.notNull(monthBudgetDto, "查询月度预算失败，请求参数不能为空！");
        List<MonthBudgetEntity> monthBudgetEntities = this.monthBudgetRepository.listByConditions(monthBudgetDto);
        if (CollectionUtils.isEmpty(monthBudgetEntities)) {
            return Lists.newArrayList();
        }
        return (List<MonthBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntities, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 考核通报分页查询预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo>
     * @author huojia
     * @date 2022/11/24 17:30
     **/
    @Override
    public Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Pageable pageable, MonthBudgetExamineCircularQueryDto dto) {
        if (Objects.isNull(dto)) {
            return new Page<>();
        }
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (StringUtils.isEmpty(dto.getBusinessFormatCode()) || StringUtils.isEmpty(dto.getBusinessUnitCode())) {
            return new Page<>();
        }
        Page<MonthBudgetExamineCircularQueryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        // 根据业务单元区分分子公司月度预算、月度预算
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return subComMonthBudgetService.findExamineCircularByConditions(page, dto);
        } else {
            return monthBudgetMapper.findExamineCircularByConditions(page, dto);
        }
    }

    /**
     * 商务政策分页查预算（电商的预算都是到第三级）
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo>
     * @author huojia
     * @date 2022/12/2 11:48
     **/
    @Override
    public Page<MonthBudgetBusinessPolicyQueryVo> findBusinessPolicyByConditions(Pageable pageable, MonthBudgetBusinessPolicyQueryDto dto) {
        ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetBusinessPolicyQueryDto();
        }
        List<String> budgetItemCodeList = new ArrayList<>();
        // 活动分类
        if (StringUtils.isNotEmpty(dto.getActivityTypeCode())) {
            ActivityTypeVo activityTypeVo = activityTypeService.getActivityTypeByActivityTypeCode(dto.getActivityTypeCode());
            if (ObjectUtils.isEmpty(activityTypeVo)) {
                return new Page<>();
            }
            List<ActivityTypeRelationDto> activityTypeRelationDtoList = activityTypeVo.getActivityTypeRelationDtoList();
            if (CollectionUtils.isEmpty(activityTypeRelationDtoList)) {
                return new Page<>();
            }
            activityTypeRelationDtoList.forEach(activityTypeRelationDto -> {
                if (CollectionUtils.isEmpty(activityTypeRelationDto.getActivityTypeBudgetDtoList())) {
                    return;
                }
                List<String> collect = activityTypeRelationDto.getActivityTypeBudgetDtoList().stream()
                        .map(ActivityTypeBudgetDto::getBudgetProjectCode)
                        .collect(Collectors.toList());
                budgetItemCodeList.addAll(collect);
            });
        }
        MonthBudgetDto monthBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(dto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
//        monthBudgetDto.setBudgetItemLevelCode(BudgetItemLevelEnum.THIRD.getCode());
        monthBudgetDto.setBudgetItemCodeList(budgetItemCodeList);
        Page<MonthBudgetVo> conditions = this.findByConditions(pageable, monthBudgetDto);
        if (CollectionUtils.isEmpty(conditions.getRecords())) {
            return new Page<>();
        }
        List<MonthBudgetVo> records = conditions.getRecords();
        List<MonthBudgetBusinessPolicyQueryVo> result = (List<MonthBudgetBusinessPolicyQueryVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                records, MonthBudgetVo.class, MonthBudgetBusinessPolicyQueryVo.class, LinkedHashSet.class, ArrayList.class
        );
        // 重新组装数据
        Page<MonthBudgetBusinessPolicyQueryVo> pageResult = new Page<>();
        pageResult.setTotal(conditions.getTotal());
        pageResult.setCurrent(conditions.getCurrent());
        pageResult.setSize(conditions.getSize());
        pageResult.setRecords(result);

        Set<String> budgetItemCodeSet = Sets.newHashSet();
        for (MonthBudgetBusinessPolicyQueryVo monthBudgetBusinessPolicyQueryVo : result) {
            if (BudgetItemLevelEnum.THIRD.getCode().equals(monthBudgetBusinessPolicyQueryVo.getBudgetItemLevelCode())) {
                //三级预算
                budgetItemCodeSet.add(monthBudgetBusinessPolicyQueryVo.getBudgetItemCode());
            }else if(BudgetItemLevelEnum.SECOND.getCode().equals(monthBudgetBusinessPolicyQueryVo.getBudgetItemLevelCode())){
                //二级预算
                monthBudgetBusinessPolicyQueryVo.setSecondBudgetItemCode(monthBudgetBusinessPolicyQueryVo.getBudgetItemCode());
                monthBudgetBusinessPolicyQueryVo.setSecondBudgetItemName(monthBudgetBusinessPolicyQueryVo.getBudgetItemName());
                monthBudgetBusinessPolicyQueryVo.setSecondBudgetItemBalance(monthBudgetBusinessPolicyQueryVo.getAccumulatedAvailableBalance());
                monthBudgetBusinessPolicyQueryVo.setBudgetItemCode(null);
                monthBudgetBusinessPolicyQueryVo.setBudgetItemName(null);
            }else if(BudgetItemLevelEnum.FIRST.getCode().equals(monthBudgetBusinessPolicyQueryVo.getBudgetItemLevelCode())){
                //一级预算
                monthBudgetBusinessPolicyQueryVo.setFirstBudgetItemCode(monthBudgetBusinessPolicyQueryVo.getBudgetItemCode());
                monthBudgetBusinessPolicyQueryVo.setFirstBudgetItemName(monthBudgetBusinessPolicyQueryVo.getBudgetItemName());
                monthBudgetBusinessPolicyQueryVo.setBudgetItemCode(null);
                monthBudgetBusinessPolicyQueryVo.setBudgetItemName(null);
            }
        }
        
        

        setSecondBudgetItem:{
        // 获取对应预算项目
        List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(new ArrayList<>(budgetItemCodeSet));
        // 汇总二级预算项目对应月度预算
        if (CollectionUtils.isEmpty(budgetItemVos)) {
            break setSecondBudgetItem;
        }
        // 获取对应上级预算项目
        Map<String, String> parentMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getParentBudgetItemCode));
        Set<String> parentCodeSet = budgetItemVos.stream().map(BudgetItemVo::getParentBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        // 根据上级，获取对应子级
        List<BudgetItemVo> sonBudgetItemVos = budgetItemService.listByParent(new ArrayList<>(parentCodeSet));
        if (CollectionUtils.isEmpty(sonBudgetItemVos)) {
            break setSecondBudgetItem;
        }
        // 获取对应上级信息
        List<BudgetItemVo> parentBudgetItemVos = budgetItemService.listByCodes(new ArrayList<>(parentCodeSet));
        if (CollectionUtils.isEmpty(parentBudgetItemVos)) {
            break setSecondBudgetItem;
        }
        Map<String, BudgetItemVo> parentBudgetMap = parentBudgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Map<String, List<BudgetItemVo>> sonMap = sonBudgetItemVos.stream().collect(Collectors.groupingBy(BudgetItemVo::getParentBudgetItemCode));
        List<String> thirdBudgetList = sonBudgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
        // 获取同级月度预算
        List<MonthBudgetVo> monthBudgetVoList = this.listByBudgetItemCodeList(new ArrayList<>(thirdBudgetList));
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            break setSecondBudgetItem;
        }
        result.forEach(businessPolicy -> {
            // 获取当前父级对应所有下级的汇总
            String parentCode = parentMap.get(businessPolicy.getBudgetItemCode());
            if (!StringUtils.isEmpty(parentCode)) {
                BudgetItemVo parentBudgetItemVo = parentBudgetMap.get(parentCode);
                List<String> thirdList = sonMap.get(parentCode).stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
                BigDecimal reduce = monthBudgetVoList.stream()
                        .filter(vo -> thirdList.contains(vo.getBudgetItemCode()) && vo.getAccumulatedAvailableBalance() != null)
                        .map(MonthBudgetVo::getAccumulatedAvailableBalance)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                businessPolicy.setSecondBudgetItemCode(parentCode);
                businessPolicy.setSecondBudgetItemName(parentBudgetItemVo.getBudgetItemName());
                businessPolicy.setSecondBudgetItemBalance(reduce);
            }
        });
        }

        setFirstBudgetItem:{
        Set<String> secondBudgetItemCodeSet = result.stream().map(MonthBudgetBusinessPolicyQueryVo::getSecondBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(secondBudgetItemCodeSet)){
            break setFirstBudgetItem;
        }
        List<BudgetItemVo> secondBudgetItemList = budgetItemService.listByCodes(new ArrayList<>(secondBudgetItemCodeSet));
        Map<String, String> parentBudgetMap = secondBudgetItemList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getParentBudgetItemCode));
        Set<String> firstBudgetItemSet = secondBudgetItemList.stream().map(BudgetItemVo::getParentBudgetItemCode).collect(Collectors.toSet());
        List<BudgetItemVo> firstBudgetItemList = budgetItemService.listByCodes(new ArrayList<>(firstBudgetItemSet));
        Map<String, BudgetItemVo> firstBudgetItemMap = firstBudgetItemList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        result.forEach(businessPolicy -> {
            if (StringUtils.isEmpty(businessPolicy.getSecondBudgetItemCode())) {
                return;
            }
            String firstBudgetItemCode = parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode());
            if (StringUtils.isEmpty(firstBudgetItemCode)){
                return;
            }
            businessPolicy.setFirstBudgetItemCode(firstBudgetItemCode);
            if (firstBudgetItemMap.containsKey(firstBudgetItemCode)) {
                businessPolicy.setFirstBudgetItemName(firstBudgetItemMap.get(firstBudgetItemCode).getBudgetItemName());
            }
        });
        }
        pageResult.setRecords(result);
        return pageResult;
    }

    /**
     * 批量查询
     *
     * @param codes
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2022/12/20 16:38
     **/
    @Override
    public List<MonthBudgetVo> listByCodes(List<String> codes) {
       return listByCodes(codes, null);
    }

    @Override
    public List<MonthBudgetVo> listByCodes(List<String> codes, String businessUnitCode) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByCodes(codes, businessUnitCode);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List<MonthBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 根据预算项目编码批量查询
     *
     * @param codes
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo>
     * @author huojia
     * @date 2022/12/28 10:58
     **/
    @Override
    public List<MonthBudgetBusinessPolicyQueryVo> findBusinessPolicyByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByCodes(codes);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetBusinessPolicyQueryVo> monthBudgetBusinessPolicyQueryVos = (List<MonthBudgetBusinessPolicyQueryVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetBusinessPolicyQueryVo.class, LinkedHashSet.class, ArrayList.class
        );
        // 获取管控金额
        Map<String, MonthBudgetControlVo> map = mapControlAmount(codes);
        monthBudgetBusinessPolicyQueryVos.forEach(monthBudgetBusinessPolicyQueryVo -> {
            if (map.containsKey(monthBudgetBusinessPolicyQueryVo.getMonthBudgetCode())) {
                MonthBudgetControlVo monthBudgetControlVo = map.get(monthBudgetBusinessPolicyQueryVo.getMonthBudgetCode());
                monthBudgetBusinessPolicyQueryVo.setControlTypeCode(monthBudgetControlVo.getControlTypeCode());
                monthBudgetBusinessPolicyQueryVo.setControlRatio(monthBudgetControlVo.getControlRatio());
                monthBudgetBusinessPolicyQueryVo.setControlBalanceAmount(monthBudgetControlVo.getControlBalanceAmount());
                monthBudgetBusinessPolicyQueryVo.setControlSituation(monthBudgetControlVo.getControlSituation());
            }
        });
        // 获取对应预算项目
        Set<String> budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(new ArrayList<>(budgetItemCodeSet));
        // 汇总二级预算项目对应月度预算
        if (CollectionUtils.isEmpty(budgetItemVos)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        Map<String, String> parentMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getParentBudgetItemCode));
        Set<String> parentCodeSet = budgetItemVos.stream().map(BudgetItemVo::getParentBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        // 根据上级，获取对应子级
        List<BudgetItemVo> sonBudgetItemVos = budgetItemService.listByParent(new ArrayList<>(parentCodeSet));
        if (CollectionUtils.isEmpty(sonBudgetItemVos)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        // 获取对应上级信息
        List<BudgetItemVo> parentBudgetItemVos = budgetItemService.listByCodes(new ArrayList<>(parentCodeSet));
        if (CollectionUtils.isEmpty(parentBudgetItemVos)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        Map<String, BudgetItemVo> parentBudgetMap = parentBudgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Map<String, List<BudgetItemVo>> sonMap = sonBudgetItemVos.stream().collect(Collectors.groupingBy(BudgetItemVo::getParentBudgetItemCode));
        List<String> thirdBudgetList = sonBudgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
        // 获取同级月度预算
        List<MonthBudgetVo> monthBudgetVoList = this.listByBudgetItemCodeList(new ArrayList<>(thirdBudgetList));
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        monthBudgetBusinessPolicyQueryVos.forEach(businessPolicy -> {
            // 获取当前父级对应所有下级的汇总
            String parentCode = parentMap.get(businessPolicy.getBudgetItemCode());
            BudgetItemVo parentBudgetItemVo = parentBudgetMap.get(parentCode);
            List<String> thirdList = sonMap.get(parentCode).stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
            BigDecimal reduce = monthBudgetVoList.stream()
                    .filter(vo -> thirdList.contains(vo.getBudgetItemCode()) && vo.getAccumulatedAvailableBalance() != null)
                    .map(MonthBudgetVo::getAccumulatedAvailableBalance)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            businessPolicy.setSecondBudgetItemCode(parentCode);
            businessPolicy.setSecondBudgetItemName(parentBudgetItemVo.getBudgetItemName());
            businessPolicy.setSecondBudgetItemBalance(reduce);
        });
        Set<String> secondBudgetItemCodeSet = monthBudgetBusinessPolicyQueryVos.stream().map(MonthBudgetBusinessPolicyQueryVo::getSecondBudgetItemCode).collect(Collectors.toSet());
        List<BudgetItemVo> secondBudgetItemList = budgetItemService.listByCodes(new ArrayList<>(secondBudgetItemCodeSet));
        Set<String> firstBudgetItemSet = secondBudgetItemList.stream().map(BudgetItemVo::getParentBudgetItemCode).collect(Collectors.toSet());
        List<BudgetItemVo> firstBudgetItemList = budgetItemService.listByCodes(new ArrayList<>(firstBudgetItemSet));
        Map<String, BudgetItemVo> firstBudgetItemMap = firstBudgetItemList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        monthBudgetBusinessPolicyQueryVos.forEach(businessPolicy -> {
            if (!parentBudgetMap.containsKey(businessPolicy.getSecondBudgetItemCode())) {
                return;
            }
            businessPolicy.setFirstBudgetItemCode(parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode()).getParentBudgetItemCode());
            if (firstBudgetItemMap.containsKey(parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode()).getParentBudgetItemCode())) {
                businessPolicy.setFirstBudgetItemName(firstBudgetItemMap.get(parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode()).getParentBudgetItemCode()).getBudgetItemName());
            }
        });
        return monthBudgetBusinessPolicyQueryVos;
    }

    /**
     * 根据年度预算编码批量查询
     *
     * @param yearBudgetList
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo>
     * @author huojia
     * @date 2023/1/8 17:38
     **/
    @Override
    public List<MonthBudgetVo> listByYearBudgetCodes(List<String> yearBudgetList) {
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearBudgetCodes(yearBudgetList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetVo> monthBudgetVos = (List<MonthBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class
        );
        convertMonthBudgetProperty(monthBudgetVos);
        return monthBudgetVos;
    }

    /**
     * 垂直自动计算计划量
     *
     * @param yearMonth
     * @author huojia
     * @date 2023/1/20 22:38
     **/
    @Override
    public void autoPlan(String yearMonth, List<String> businessUnitCodeList) {

    }

    @Override
    public List<String> listByYearMonth(String yearMonth, List<String> businessUnitCodeList) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        return monthBudgetEntityList.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList());
    }

    /**
     * 垂直自动计算回复量
     *
     * @param yearMonth
     * @author huojia
     * @date 2023/1/20 22:38
     **/
    @Override
    public void autoPlanReplay(String yearMonth, List<String> businessUnitCodeList, String planFlag) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return;
        }
        List<String> budgetItemCodeList = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode)
                .collect(Collectors.toList());
        // 查询预算项目
        List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(budgetItemCodeList);
        Map<String, BudgetItemVo> budgetItemVoMap = CollectionUtils.isEmpty(budgetItemVos) ? Maps.newHashMap() :
                budgetItemVos.stream().collect(Collectors
                        .toMap(BudgetItemVo::getBudgetItemCode, Function.identity(),
                                (oldVo, newVo) -> newVo));
        monthBudgetEntityList.forEach(entity -> {
            List<String> lockKeys = Lists.newArrayList();
            lockKeys.add(entity.getMonthBudgetCode());
            //加锁
            boolean lock = true;
            try {
                lock = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
                if (lock) {
                    this.calPlanReplay(entity.getId(), budgetItemVoMap, BooleanEnum.FALSE.getCapital());
                }
            } finally {
                if (lock) {
                    monthBudgetLockService.unLock(lockKeys);
                }
            }
        });
    }

    /**
     * 垂直自动计算实销量
     *
     * @param yearMonth
     * @author huojia
     * @date 2023/1/20 22:48
     **/
    @Override
    public List<String> autoActualSales(String yearMonth, List<String> businessUnitCodeList) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return null;
        }
        return monthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
        //this.calActualReplayDiff(ids);
    }

    @Override
    public List<MonthBudgetVo> findCustomerGroupMonthBudget(List<MonthBudgetDto> dtos) {

        if (CollectionUtils.isEmpty(dtos)) {
            return Lists.newArrayList();
        }
        List<String> monthBudgetCodeList = dtos.stream().map(MonthBudgetDto::getMonthBudgetCode).collect(Collectors.toList());
        List<MonthBudgetVo> monthBudgetVoList = this.listByCodes(monthBudgetCodeList);
        //预算编码维度
        Map<String, MonthBudgetVo> monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        for (MonthBudgetDto dto : dtos) {
            MonthBudgetVo monthBudgetVo = monthBudgetVoMap.get(dto.getMonthBudgetCode());
            if (monthBudgetVo != null) {
                dto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
                dto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
            }
        }
        List<MonthBudgetVo> customerMonthBudget = this.monthBudgetRepository.findCustomerGroupMonthBudget(dtos);
        //年月+预算项目维度
        Map<String, MonthBudgetVo> monthBudgetVoMap2 = monthBudgetVoList.stream().collect(Collectors.toMap(o -> o.getYearMonthLy() + o.getBudgetItemCode(), Function.identity()));
        for (MonthBudgetVo monthBudgetVo : customerMonthBudget) {
            MonthBudgetVo monthBudgetVo1 = monthBudgetVoMap2.get(monthBudgetVo.getYearMonthLy() + monthBudgetVo.getBudgetItemCode());
            if (monthBudgetVo1 != null) {
                monthBudgetVo.setDepartMonthBudgetCode(monthBudgetVo1.getMonthBudgetCode());
            }
        }
        return customerMonthBudget;
    }

    /**
     * 根据ids集合修改预算管控可用余额
     *
     * @param ids                  主键集合
     * @param controlBalanceAmount 预算管控可用余额
     * @date 2023/1/8 17:36
     **/
    @Override
    @Transactional
    public void updateControlBalanceAmountByIds(Set<String> ids, BigDecimal controlBalanceAmount) {
        this.monthBudgetRepository.updateControlBalanceAmountByIds(ids, controlBalanceAmount);
    }

    /**
     * 批量查询管控金额
     *
     * @param monthBudgetCodeList
     * @return java.util.Map<java.lang.String, java.math.BigDecimal>
     * @author huojia
     * @date 2023/2/2 16:05
     **/
    @Override
    public Map<String, MonthBudgetControlVo> mapControlAmount(List<String> monthBudgetCodeList) {
        if (CollectionUtils.isEmpty(monthBudgetCodeList)) {
            return new HashMap<>();
        }
        List<MonthBudgetEntity> monthBudgetList = this.monthBudgetRepository.getByMonthBudgetCodes(monthBudgetCodeList, EnableStatusEnum.ENABLE.getCode());
        return mapControlAmountByBudgetList(monthBudgetList);
    }

    public Map<String, MonthBudgetControlVo> mapControlAmountByBudgetList(List<MonthBudgetEntity> monthBudgetList) {
        if (CollectionUtils.isEmpty(monthBudgetList)) {
            return new HashMap<>();
        }
        Map<String, MonthBudgetControlVo> amountMap = new HashMap<>();
        // 批量查询维度管控数据
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<DimensionControlsVo> dimensionControlsVos = dimensionControlsService.listByConditions(dimensionControlsDto);
        monthBudgetList.forEach(monthBudgetEntity -> {
            MonthBudgetControlVo monthBudgetControlVo = new MonthBudgetControlVo();
            monthBudgetControlVo.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());

            List<DimensionControlsVo> collect = dimensionControlsVos.stream().filter(vo -> monthBudgetEntity.getBusinessUnitCode().equals(vo.getBusinessUnitCode())).collect(Collectors.toList());
            // 按维度去查询预算的管控
            DimensionControlsVo sameItemControlsVo = null;
            DimensionControlsVo dimensionControlsVo = null;
            // 主体、垂直先按当前层级预算项目去匹配管控，没匹配到再去查上级预算项目对应管控维度
            if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())
                    || BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetEntity.getBusinessUnitCode())
                    || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
                sameItemControlsVo = this.findSameItemControlConfig(monthBudgetEntity, collect);
            }
            if (ObjectUtils.isEmpty(sameItemControlsVo)) {
                dimensionControlsVo = this.findControlConfig(monthBudgetEntity, collect);
            } else {
                dimensionControlsVo = sameItemControlsVo;
            }

            if (MonthBudgetGroupEnum.customer.getCode().equals(monthBudgetEntity.getGroupCode())) {
                if (BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetEntity.getBusinessUnitCode())) {
                    //主体的客户预算不管控
                    monthBudgetControlVo.setControlSituation(ControlSituationEnum.WARNING_TIPS.getCode());
                    monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                    if (ObjectUtils.isNotEmpty(dimensionControlsVo)) {
                        monthBudgetControlVo.setIfRolling(dimensionControlsVo.getIfRolling());
                        monthBudgetControlVo.setControlsCaliber(dimensionControlsVo.getControlsCaliber());
                    }
                    amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                    return;
                }
            }

            // 没查询到配置，则直接使用余额
            if (ObjectUtils.isEmpty(dimensionControlsVo)) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            } else {
                monthBudgetControlVo.setIfRolling(dimensionControlsVo.getIfRolling());
                monthBudgetControlVo.setControlsCaliber(dimensionControlsVo.getControlsCaliber());
            }
            monthBudgetControlVo.setControlsConfigCode(dimensionControlsVo.getControlsConfigCode());
            // 按维度查询月度预算
            List<MonthBudgetEntity> sameDimensionControlList = this.listSameDimensionControlBudget(monthBudgetEntity, dimensionControlsVo);
            // 按理说不会为空的，至少应该能把当前的预算查出来才对
            if (CollectionUtils.isEmpty(sameDimensionControlList)) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            }
            // 电商需要按维度管控上预算项目对应的管控条件来计算管控金额
            if (BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
                BudgetItemVo controlItem = budgetItemService.findByCode(dimensionControlsVo.getControlBudgetItemCode(), null);
                // 不存在管控条件 或者 管控条件中不包含电商，直接按当前预算的余额控
                if (CollectionUtils.isEmpty(controlItem.getControlConditionDtoList())) {
                    monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                    monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                } else {
                    List<BudgetItemControlConditionVo> onlineList = controlItem.getControlConditionDtoList()
                            .stream()
                            .filter(budgetItemControlConditionVo -> BusinessUnitEnum.ONLINE.getCode().equals(budgetItemControlConditionVo.getBusinessUnitCode()))
                            .collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(onlineList)) {
                        monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                        monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                    } else {
                        monthBudgetControlVo.setControlTypeCode(onlineList.get(0).getControlTypeCode());
                        if (BudgetControlTypeEnum.CONTROL_RATIO.getCode().equals(onlineList.get(0).getControlTypeCode())) {
                            BigDecimal initResolveAmount = sameDimensionControlList.stream()
                                    .map(MonthBudgetEntity::getInitResolveAmount)
                                    .filter(Objects::nonNull)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal reduce = BigDecimal.ZERO;
                            // 时间维度为月度，则管控率=所选预算项目下的所有末级预算项目对应月度的年初分解金额汇总值/所选预算项目下的任意一个末级预算项目的对应月度的销售目标*100
                            if (TimeDimension.MONTHLY.getCode().equals(dimensionControlsVo.getTimeDimension())) {
                                if (sameDimensionControlList.get(0).getTotalGoalQuantity() == null
                                        || BigDecimal.ZERO.compareTo(sameDimensionControlList.get(0).getTotalGoalQuantity()) == 0) {
                                    reduce = BigDecimal.ZERO;
                                } else {
                                    reduce = initResolveAmount.divide(sameDimensionControlList.get(0).getTotalGoalQuantity(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                                }
                            }
                            // 时间维度为季度，则管控率=所选预算项目下的所有末级预算项目对应季度的年初分解金额汇总值/所选预算项目下的任意一个末级预算项目的对应季度的销售目标*100；（季度销售目标=对应月度的汇总）
                            // 时间维度为年度，则管控率=所选预算项目下的所有末级预算项目对应年度的年初分解金额汇总值/所选预算项目下的任意一个末级预算项目的对应年度的销售目标*100；（年度销售目标=对应月度的汇总）
                            if (TimeDimension.QUARTER.getCode().equals(dimensionControlsVo.getTimeDimension())
                                    || TimeDimension.YEAR.getCode().equals(dimensionControlsVo.getTimeDimension())) {
                                // 如果是按季度控的，查出来的同维度的月度预算都是同季度的数据；如果是按年度控的，查出来的同维度的月度预算都是同年度的数据。所以直接取同年度预算的就行了
                                BigDecimal totalGoal = sameDimensionControlList.stream()
                                        .filter(sameDimensionControl -> sameDimensionControl.getYearBudgetCode().equals(monthBudgetEntity.getYearBudgetCode())
                                                && sameDimensionControl.getTotalGoalQuantity() != null)
                                        .map(MonthBudgetEntity::getTotalGoalQuantity)
                                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                                if (BigDecimal.ZERO.compareTo(totalGoal) == 0) {
                                    reduce = BigDecimal.ZERO;
                                } else {
                                    reduce = initResolveAmount.divide(totalGoal, 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                                }
                            }
                            monthBudgetControlVo.setControlSituation(dimensionControlsVo.getControlSituation());
                            monthBudgetControlVo.setControlRatio(reduce);
                            monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                        } else {
                            BigDecimal reduce = sameDimensionControlList.stream()
                                    .map(MonthBudgetEntity::getAccumulatedAvailableBalance)
                                    .filter(Objects::nonNull)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            monthBudgetControlVo.setControlSituation(dimensionControlsVo.getControlSituation());
                            monthBudgetControlVo.setControlBalanceAmount(reduce);
                        }
                    }
                }
            } else {
                BigDecimal reduce = sameDimensionControlList.stream()
                        .map(MonthBudgetEntity::getAccumulatedAvailableBalance)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                monthBudgetControlVo.setControlSituation(dimensionControlsVo.getControlSituation());
                monthBudgetControlVo.setControlBalanceAmount(reduce);
            }
            amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
        });
        return amountMap;
    }

    /**
     * 过滤当前预算对应配置
     *
     * @param monthBudgetEntity
     * @param dimensionControlsVos
     * @return com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo
     * @author huojia
     * @date 2023/2/4 22:10
     **/
    private DimensionControlsVo findSameItemControlConfig(MonthBudgetEntity monthBudgetEntity, List<DimensionControlsVo> dimensionControlsVos) {
        if (CollectionUtils.isEmpty(dimensionControlsVos)) {
            return null;
        }
        // 查询预算项目
        AtomicReference<DimensionControlsVo> result = new AtomicReference<>(null);
        AtomicBoolean flag = new AtomicBoolean(false);
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (flag.get()) {
                return;
            }
            if (CollectionUtils.isEmpty(dimensionControlsVo.getBudgetItemCodeList())) {
                return;
            }
            if (!dimensionControlsVo.getBudgetItemCodeList().contains(monthBudgetEntity.getBudgetItemCode())) {
                return;
            }
            // 维护了组织，则必须和预算上组织一致
            if (!StringUtils.isEmpty(dimensionControlsVo.getOrgCode())
                    && !dimensionControlsVo.getOrgCode().equals(monthBudgetEntity.getOrgCode())) {
                return;
            }
            // 必须保证按顺序来
            StringBuilder fieldsStr = new StringBuilder();
            if (StringUtils.isNotEmpty(monthBudgetEntity.getSalesOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.TISSUE.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.DEPARTMENT.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getCustomerChannelCode())
                    || StringUtils.isNotEmpty(monthBudgetEntity.getCustomerChannelCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CHANNEL.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getSystemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SYSTEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getRegionCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.REGION.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getCustomerCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CLIEN.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getTerminalCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SHOP.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductBrandCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.BRAND.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductCategoryCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CATEGORY.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductItemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.ITEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.PRODUCT.getName() + ",");
            }
            // 管控的维度与预算的维度相同 或 预算的维度小于管控的维度
            /*if (StringUtils.isNotEmpty(dimensionControlsVo.getFieldsDimensionality())
                    && (dimensionControlsVo.getFieldsDimensionality().equals(fieldsStr.toString()) || fieldsStr.toString().contains(dimensionControlsVo.getFieldsDimensionality()))) {
                dimensionControlsVo.setSameBudgetItemCodeList(Lists.newArrayList(monthBudgetEntity.getBudgetItemCode()));
                result.set(dimensionControlsVo);
                flag.set(true);
            }*/
            // 不再考虑管控维度，只要有相交的即可
            if (StringUtils.isNotEmpty(dimensionControlsVo.getFieldsDimensionality())) {
                List<String> fieldList = Lists.newArrayList(fieldsStr.toString().split(","));
                List<String> dimensionalityList = Lists.newArrayList(dimensionControlsVo.getFieldsDimensionality().split(","));
                if (fieldList.containsAll(dimensionalityList) || dimensionalityList.containsAll(fieldList)) {
                    dimensionControlsVo.setSameBudgetItemCodeList(Lists.newArrayList(monthBudgetEntity.getBudgetItemCode()));
                    dimensionControlsVo.setControlBudgetItemCode(monthBudgetEntity.getBudgetItemCode());
                    result.set(dimensionControlsVo);
                    flag.set(true);
                }
            } else {
                dimensionControlsVo.setSameBudgetItemCodeList(Lists.newArrayList(monthBudgetEntity.getBudgetItemCode()));
                dimensionControlsVo.setControlBudgetItemCode(monthBudgetEntity.getBudgetItemCode());
                result.set(dimensionControlsVo);
                flag.set(true);
            }
        });
        return result.get();
    }

    /**
     * 批量查询同预算管控维度的月度预算
     *
     * @param dimensionControlsVo
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity>
     * @author huojia
     * @date 2023/2/2 17:44
     **/
    private List<MonthBudgetEntity> listSameDimensionControlBudget(MonthBudgetEntity monthBudgetEntity, DimensionControlsVo dimensionControlsVo) {
        String fieldsDimensionality = dimensionControlsVo.getFieldsDimensionality();
        List<String> fieldsList = Lists.newArrayList(fieldsDimensionality.split(","));

        MonthBudgetControlQueryDto monthBudgetControlQueryDto = new MonthBudgetControlQueryDto();

        // 2月14日：垂直又又又又又又又又又又又又又又又又要改东西！！！！！！！！！！！！！！！！
        /*if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.TISSUE.getName())) {
                monthBudgetControlQueryDto.setSalesOrgCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.TISSUE.getName());
                monthBudgetControlQueryDto.setSalesOrgCode(monthBudgetEntity.getSalesOrgCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.DEPARTMENT.getName())) {
                monthBudgetControlQueryDto.setOrgCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.DEPARTMENT.getName());
                monthBudgetControlQueryDto.setOrgCode(monthBudgetEntity.getOrgCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.CHANNEL.getName())) {
                monthBudgetControlQueryDto.setCustomerChannelCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.CHANNEL.getName());
                monthBudgetControlQueryDto.setCustomerChannelCode(monthBudgetEntity.getCustomerChannelCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.SYSTEM.getName())) {
                monthBudgetControlQueryDto.setSystemCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.SYSTEM.getName());
                monthBudgetControlQueryDto.setSystemCode(monthBudgetEntity.getSystemCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.REGION.getName())) {
                monthBudgetControlQueryDto.setRegionCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.REGION.getName());
                monthBudgetControlQueryDto.setRegionCode(monthBudgetEntity.getRegionCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.CLIEN.getName())) {
                monthBudgetControlQueryDto.setCustomerCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.CLIEN.getName());
                monthBudgetControlQueryDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.SHOP.getName())) {
                monthBudgetControlQueryDto.setTerminalCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.SHOP.getName());
                monthBudgetControlQueryDto.setTerminalCode(monthBudgetEntity.getTerminalCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.BRAND.getName())) {
                monthBudgetControlQueryDto.setProductBrandCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.BRAND.getName());
                monthBudgetControlQueryDto.setProductBrandCode(monthBudgetEntity.getProductBrandCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.CATEGORY.getName())) {
                monthBudgetControlQueryDto.setProductCategoryCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.CATEGORY.getName());
                monthBudgetControlQueryDto.setProductCategoryCode(monthBudgetEntity.getProductCategoryCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.ITEM.getName())) {
                monthBudgetControlQueryDto.setProductItemCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.ITEM.getName());
                monthBudgetControlQueryDto.setProductItemCode(monthBudgetEntity.getProductItemCode());
            }
        }

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (!fieldsList.contains(FieldsDimenDiameterEnum.PRODUCT.getName())) {
                monthBudgetControlQueryDto.setProductCodeFlag(BooleanEnum.FALSE.getCapital());
            } else {
                fieldsList.remove(FieldsDimenDiameterEnum.PRODUCT.getName());
                monthBudgetControlQueryDto.setProductCode(monthBudgetEntity.getProductCode());
            }
        }*/

        if (!CollectionUtils.isEmpty(fieldsList)) {
            if (fieldsList.contains(FieldsDimenDiameterEnum.TISSUE.getName())) {
                monthBudgetControlQueryDto.setSalesOrgCode(monthBudgetEntity.getSalesOrgCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.DEPARTMENT.getName())) {
                monthBudgetControlQueryDto.setOrgCode(monthBudgetEntity.getOrgCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.CHANNEL.getName())) {
                monthBudgetControlQueryDto.setCustomerChannelCode(monthBudgetEntity.getCustomerChannelCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.SYSTEM.getName())) {
                monthBudgetControlQueryDto.setSystemCode(monthBudgetEntity.getSystemCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.REGION.getName())) {
                monthBudgetControlQueryDto.setRegionCode(monthBudgetEntity.getRegionCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.CLIEN.getName())) {
                monthBudgetControlQueryDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.SHOP.getName())) {
                monthBudgetControlQueryDto.setTerminalCode(monthBudgetEntity.getTerminalCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.BRAND.getName())) {
                monthBudgetControlQueryDto.setProductBrandCode(monthBudgetEntity.getProductBrandCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.CATEGORY.getName())) {
                monthBudgetControlQueryDto.setProductCategoryCode(monthBudgetEntity.getProductCategoryCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.ITEM.getName())) {
                monthBudgetControlQueryDto.setProductItemCode(monthBudgetEntity.getProductItemCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.PRODUCT.getName())) {
                monthBudgetControlQueryDto.setProductCode(monthBudgetEntity.getProductCode());
            }
        }

        List<String> yearMonthList = new ArrayList<>();
        String yearly = monthBudgetEntity.getYearMonthLy().split("-")[0];
        if (TimeDimension.YEAR.getCode().equals(dimensionControlsVo.getTimeDimension())) {
            List<String> monthList = MonthEnum.concertEnumToList();
            monthList.forEach(monthly -> {
                yearMonthList.add(yearly + "-" + monthly);
            });
        }
        if (TimeDimension.QUARTER.getCode().equals(dimensionControlsVo.getTimeDimension())) {
            Calendar calendar = DateUtil.getCalendar();
            calendar.setTime(DateUtil.parseDate(monthBudgetEntity.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
            int quarterByMonth = DateUtil.getQuarterByMonth(calendar.get(Calendar.MONTH) + 1);
            if (quarterByMonth == 1) {
                yearMonthList.add(yearly + "-" + MonthEnum.JANUARY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.FEBRUARY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.MARCH.getCode());
            }
            if (quarterByMonth == 2) {
                yearMonthList.add(yearly + "-" + MonthEnum.APRIL.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.MAY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.JUNE.getCode());
            }
            if (quarterByMonth == 3) {
                yearMonthList.add(yearly + "-" + MonthEnum.JULY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.AUGUST.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.SEPTEMBER.getCode());
            }
            if (quarterByMonth == 4) {
                yearMonthList.add(yearly + "-" + MonthEnum.OCTOBER.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.NOVEMBER.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.DECEMBER.getCode());
            }
        }
        if (TimeDimension.MONTHLY.getCode().equals(dimensionControlsVo.getTimeDimension())) {
            yearMonthList.add(monthBudgetEntity.getYearMonthLy());
        }
        monthBudgetControlQueryDto.setBusinessFormatCode(monthBudgetEntity.getBusinessFormatCode());
        monthBudgetControlQueryDto.setBusinessUnitCode(monthBudgetEntity.getBusinessUnitCode());
        monthBudgetControlQueryDto.setGroupCode(monthBudgetEntity.getGroupCode());
        monthBudgetControlQueryDto.setFeeBelongCode(monthBudgetEntity.getFeeBelongCode());
        monthBudgetControlQueryDto.setYearMonthList(yearMonthList);
        monthBudgetControlQueryDto.setSameBudgetItemCodeList(dimensionControlsVo.getSameBudgetItemCodeList());
        return this.monthBudgetMapper.listSameDimensionControlBudget(monthBudgetControlQueryDto);
    }

    /**
     * 按月度预算的维度去查询管控配置
     *
     * @param monthBudgetEntity
     * @return com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo
     * @author huojia
     * @date 2023/2/2 16:26
     **/
    private DimensionControlsVo findControlConfig(MonthBudgetEntity monthBudgetEntity, List<DimensionControlsVo> dimensionControlsVos) {
        if (CollectionUtils.isEmpty(dimensionControlsVos)) {
            return null;
        }
        // 查询预算项目
        List<String> budgetItemCodeList = new ArrayList<>();
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (!CollectionUtils.isEmpty(dimensionControlsVo.getBudgetItemCodeList())) {
                budgetItemCodeList.addAll(dimensionControlsVo.getBudgetItemCodeList());
            }
        });
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return null;
        }
        // 预算做到三级，管控做的二级   后续可能会改吧。。
        List<BudgetItemVo> budgetItemVos = budgetItemService.listByParent(budgetItemCodeList);
        if (CollectionUtils.isEmpty(budgetItemVos)) {
            return null;
        }
        Map<String, List<BudgetItemVo>> parentMap = budgetItemVos.stream().collect(Collectors.groupingBy(BudgetItemVo::getParentBudgetItemCode));

        AtomicReference<DimensionControlsVo> result = new AtomicReference<>(null);
        AtomicBoolean flag = new AtomicBoolean(false);
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (flag.get()) {
                return;
            }
            if (CollectionUtils.isEmpty(dimensionControlsVo.getBudgetItemCodeList())) {
                return;
            }
            // 维护了组织，则必须和预算上组织一致
            if (!StringUtils.isEmpty(dimensionControlsVo.getOrgCode())
                    && !dimensionControlsVo.getOrgCode().equals(monthBudgetEntity.getOrgCode())) {
                return;
            }
            List<String> allItemList = new ArrayList<>();
            AtomicReference<String> controlBudgetItemCode = new AtomicReference<>();
            dimensionControlsVo.getBudgetItemCodeList().forEach(parentCode -> {
                List<String> thirdBudgetItemCodeList = new ArrayList<>();
                if (parentMap.containsKey(parentCode)) {
                    thirdBudgetItemCodeList.addAll(parentMap.get(parentCode).stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList()));
                }
                if (thirdBudgetItemCodeList.contains(monthBudgetEntity.getBudgetItemCode())) {
                    allItemList.addAll(thirdBudgetItemCodeList);
                    controlBudgetItemCode.set(parentCode);
                }
            });

            if (CollectionUtils.isEmpty(allItemList)) {
                return;
            }
            // 必须保证按顺序来
            StringBuilder fieldsStr = new StringBuilder();
            if (StringUtils.isNotEmpty(monthBudgetEntity.getSalesOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.TISSUE.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.DEPARTMENT.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getCustomerChannelCode())
                    || StringUtils.isNotEmpty(monthBudgetEntity.getCustomerChannelCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CHANNEL.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getSystemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SYSTEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getRegionCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.REGION.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getCustomerCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CLIEN.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getTerminalCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SHOP.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductBrandCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.BRAND.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductCategoryCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CATEGORY.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductItemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.ITEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty(monthBudgetEntity.getProductCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.PRODUCT.getName() + ",");
            }
            // 管控的维度与预算的维度相同 或 预算的维度小于管控的维度
            /*if (StringUtils.isNotEmpty(dimensionControlsVo.getFieldsDimensionality())
                    && (dimensionControlsVo.getFieldsDimensionality().equals(fieldsStr.toString()) || fieldsStr.toString().contains(dimensionControlsVo.getFieldsDimensionality()))) {
                dimensionControlsVo.setSameBudgetItemCodeList(allItemList);
                result.set(dimensionControlsVo);
                flag.set(true);
            }*/
            // 不再考虑管控维度，只要有相交的即可
            /*if (StringUtils.isNotEmpty(dimensionControlsVo.getFieldsDimensionality())
                    && (dimensionControlsVo.getFieldsDimensionality().equals(fieldsStr.toString())
                    || fieldsStr.toString().contains(dimensionControlsVo.getFieldsDimensionality())
                    || dimensionControlsVo.getFieldsDimensionality().contains(fieldsStr.toString()))
            ) {
                dimensionControlsVo.setSameBudgetItemCodeList(Lists.newArrayList(monthBudgetEntity.getBudgetItemCode()));
                result.set(dimensionControlsVo);
                flag.set(true);
            }*/
            // 不再考虑管控维度，只要有相交的即可
            if (StringUtils.isNotEmpty(dimensionControlsVo.getFieldsDimensionality())) {
                List<String> fieldList = Lists.newArrayList(fieldsStr.toString().split(","));
                List<String> dimensionalityList = Lists.newArrayList(dimensionControlsVo.getFieldsDimensionality().split(","));
                if (fieldList.containsAll(dimensionalityList) || dimensionalityList.containsAll(fieldList)) {
                    // dimensionControlsVo.setSameBudgetItemCodeList(Lists.newArrayList(monthBudgetEntity.getBudgetItemCode()));
                    dimensionControlsVo.setSameBudgetItemCodeList(allItemList);
                    dimensionControlsVo.setControlBudgetItemCode(controlBudgetItemCode.get());
                    result.set(dimensionControlsVo);
                    flag.set(true);
                }
            } else {
                dimensionControlsVo.setControlBudgetItemCode(controlBudgetItemCode.get());
                dimensionControlsVo.setSameBudgetItemCodeList(Lists.newArrayList(monthBudgetEntity.getBudgetItemCode()));
                result.set(dimensionControlsVo);
                flag.set(true);
            }
        });
        return result.get();
    }

    /**
     * 根据月度预算编码、预算操作类型操作预算
     *
     * @param monthBudgetCode
     * @param operationAmount
     * @param budgetType
     * @param operationType
     * @author huojia
     * @date 2022/11/7 10:13
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(String monthBudgetCode, BigDecimal operationAmount, String budgetType, String operationType, String businessCode) {
        Validate.notEmpty(budgetType, "操作预算时，预算类型不能为空！");
        if (MonthBudgetTypeEnum.MONTH_BUDGET.getCode().equals(budgetType)) {
            this.operateBudget(monthBudgetCode, BigDecimal.ZERO, operationAmount, operationType, businessCode);
        } else if (MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode().equals(budgetType)) {
            subComMonthBudgetService.operateBudget(monthBudgetCode, operationAmount, operationType, businessCode);
        } else {
            throw new RuntimeException("预算操作失败，预算类型错误！");
        }
    }

    /**
     * 促销规划批量操作预算
     *
     * @param operateMonthBudgetDtoList
     * @author huojia
     * @date 2023/2/15 17:51
     **/
    @Override
    public void operatePromotionBudget(List<PromotionOperateMonthBudgetDto> operateMonthBudgetDtoList) {
        Validate.notEmpty(operateMonthBudgetDtoList, "预算不能为空！");
        operateMonthBudgetDtoList.forEach(operateMonthBudgetDto -> {
            if (MonthBudgetTypeEnum.MONTH_BUDGET.getCode().equals(operateMonthBudgetDto.getBudgetType())) {
                this.operateBudget(operateMonthBudgetDto.getMonthBudgetCode(), operateMonthBudgetDto.getFeeRatio(), operateMonthBudgetDto.getOperationAmount(), operateMonthBudgetDto.getOperationType(), operateMonthBudgetDto.getBusinessCode());
            } else if (MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode().equals(operateMonthBudgetDto.getBudgetType())) {
                subComMonthBudgetService.operateBudget(operateMonthBudgetDto.getMonthBudgetCode(), operateMonthBudgetDto.getOperationAmount(), operateMonthBudgetDto.getOperationType(), operateMonthBudgetDto.getBusinessCode());
            } else {
                throw new RuntimeException("预算操作失败，预算类型错误！");
            }
        });
    }

    /**
     * 操作月度预算
     *
     * @param monthBudgetCode
     * @param operationAmount
     * @param operationType
     * @author huojia
     * @date 2022/11/7 10:33
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(String monthBudgetCode, BigDecimal feeRatio, BigDecimal operationAmount, String operationType, String businessCode) {
        Validate.notEmpty(monthBudgetCode, "操作预算时，预算编码不能为空！");
        Validate.notNull(operationAmount, "操作预算时，操作金额不能为空！");
        Validate.notEmpty(operationType, "操作预算时，操作类型不能为空！");
        MonthBudgetEntity monthBudgetEntity = monthBudgetRepository.getByMonthBudgetCode(monthBudgetCode, EnableStatusEnum.ENABLE.getCode());
        Validate.notNull(monthBudgetEntity, "月度预算" + monthBudgetCode + "查询失败，请检查预算是否启用或是否存在！");
        if (!redisLockService.isLock(BudgetLockConstant.MONTH_BUDGET_LOCK + monthBudgetCode)) {
            throw new RuntimeException("预算操作失败，月度预算" + monthBudgetCode + "未加锁！");
        }
        BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
        // 根据预算类型操作预算
        if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
            Map<String, MonthBudgetControlVo> map = mapControlAmount(Lists.newArrayList(monthBudgetCode));
            MonthBudgetControlVo monthBudgetControlVo = map.get(monthBudgetCode);
            String controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();//默认强管控
            if (StringUtils.isNotEmpty(monthBudgetControlVo.getControlSituation())) {
                controlSituation = monthBudgetControlVo.getControlSituation();
            }
            // 电商且是按管控率
            if (BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())
                    && BudgetControlTypeEnum.CONTROL_RATIO.getCode().equals(monthBudgetControlVo.getControlTypeCode())) {
                if (Optional.ofNullable(feeRatio).orElse(BigDecimal.ZERO).compareTo(monthBudgetControlVo.getControlRatio()) > 0
                        && ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    throw new RuntimeException("[" + businessCode + "]费用率[" + feeRatio + "]大于管控率" + monthBudgetControlVo.getControlRatio() + "，请检查！");
                } else {
                    monthBudgetEntity.setApprovedAmount(
                            operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO))
                    );
                    monthBudgetEntity.setAccumulatedAvailableBalance(
                            Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                    );
                }
            } else {
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    Validate.isTrue(monthBudgetControlVo.getControlBalanceAmount().compareTo(operationAmount) >= 0, "[" + businessCode + "]使用金额[" + operationAmount + "]大于管控余额" + monthBudgetControlVo.getControlBalanceAmount() + "，请检查！");
                }
                monthBudgetEntity.setApprovedAmount(
                        operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO))
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
            }
        } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
            monthBudgetEntity.setApprovedAmount(
                    Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
            );
            monthBudgetEntity.setAccumulatedAvailableBalance(
                    Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
            );
        } else if (BudgetOperationTypeEnum.ADJUST.getCode().equals(operationType)) {
            monthBudgetEntity.setAdjustAmount(
                    Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
            );
            monthBudgetEntity.setAccumulatedAvailableBalance(
                    Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
            );
            monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
        } else if (BudgetOperationTypeEnum.AUDIT_DIFF.getCode().equals(operationType)) {
            monthBudgetEntity.setAdjustAmount(
                    Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount)
            );
            monthBudgetEntity.setAccumulatedAvailableBalance(
                    Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
            );
        } else if (BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType)) {
            monthBudgetEntity.setEstimatedExcessAmount(
                    Optional.ofNullable(monthBudgetEntity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO).add(operationAmount)
            );
            monthBudgetEntity.setAccumulatedAvailableBalance(
                    Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
            );
        } else if (BudgetOperationTypeEnum.DUTY_PROFIT_ADJUST.getCode().equals(operationType)) {
            //调入调整金额校验
            Validate.isTrue(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount).compareTo(BigDecimal.ZERO) >= 0, "调整金额必须小于可用余额");
            monthBudgetEntity.setAdjustAmount(
                    Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
            );
            monthBudgetEntity.setAccumulatedAvailableBalance(
                    Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
            );
        }
        this.monthBudgetRepository.updateById(monthBudgetEntity);
        // 构建操作明细
        MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, operationAmount,beforeAmount, operationType, businessCode);
        monthBudgetDetailService.create(monthBudgetDetailDto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(List<OperateMonthBudgetDto> operateList) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        Set<String> monthBudgetCodeSet = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(monthBudgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");
            operateBudget(operateList, Maps.newHashMap());
        } finally {
            monthBudgetLockService.unLock(new ArrayList<>(monthBudgetCodeSet));
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(List<OperateMonthBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        operateList.forEach(dto -> {
            if (!redisLockService.isLock(BudgetLockConstant.MONTH_BUDGET_LOCK + dto.getMonthBudgetCode())) {
                throw new RuntimeException("预算操作失败，月度预算" + dto.getMonthBudgetCode() + "未加锁！");
            }
        });
        //垂直滚动预算ids
        List<String> ids = new ArrayList<>();
        List<MonthBudgetEntity> budgetEntityList = validateOperateBudget(operateList);
        Map<String, MonthBudgetEntity> budgetEntityMap = budgetEntityList.stream().collect(Collectors.toMap(MonthBudgetEntity::getMonthBudgetCode, Function.identity()));
        Map<String, MonthBudgetControlVo> controlMap = this.mapControlAmountByBudgetList(budgetEntityList);
        log.info("活动方案预算跟踪表退预算2:controlMap-key:{},value:{}", JsonUtils.obj2JsonString(controlMap.keySet()), JsonUtils.obj2JsonString(controlMap.values()));
        List<MonthBudgetDetailDto> detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            MonthBudgetEntity monthBudgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            MonthBudgetControlVo monthBudgetControlVo = controlMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = Optional.ofNullable(operateMonthBudgetDto.getOperationAmount()).orElse(BigDecimal.ZERO);
            BigDecimal looseAmount = looseAmountMap.getOrDefault(operateMonthBudgetDto.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal alreadyEndCaseAmount = Optional.ofNullable(operateMonthBudgetDto.getAlreadyEndCaseAmount()).orElse(BigDecimal.ZERO);
            // 根据预算类型操作预算
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)
                    || BudgetOperationTypeEnum.DEDUCTION.getCode().equals(operationType)) {
                String controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();//默认强管控
                if (StringUtils.isNotEmpty(monthBudgetControlVo.getControlSituation())) {
                    controlSituation = monthBudgetControlVo.getControlSituation();
                }
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    String controlsConfigCode = monthBudgetControlVo.getControlsConfigCode();
                    String controlCodeDesc = "预算编码[" + operateMonthBudgetDto.getMonthBudgetCode() + "]";
                    if (StringUtils.isNotBlank(controlsConfigCode)) {
                        controlCodeDesc += "管控维度[" + controlsConfigCode + "]";
                    }
                    Validate.isTrue(monthBudgetControlVo.getControlBalanceAmount().add(looseAmount).compareTo(operationAmount) >= 0, (StringUtils.isEmpty(businessCode) ? "第[" + operateMonthBudgetDto.getIndexNo() + "行]" : "[" + businessCode + "]") + "使用金额[" + operationAmount + "]大于当前" + controlCodeDesc + "余额" + monthBudgetControlVo.getControlBalanceAmount() + "，请检查！");
                }
                monthBudgetEntity.setApprovedAmount(
                        operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO))
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                monthBudgetEntity.setApprovedAmount(
                        Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType)) {
                // 修改调整、可用金额、审批中金额
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.RELEASE.getCode().equals(operationType)) {
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType)) {
                Validate.isTrue(monthBudgetEntity.getAccumulatedAvailableBalance().compareTo(operationAmount) >= 0, "调出方【" + monthBudgetEntity.getMonthBudgetCode() + "】调出金额" + operationAmount + "元大于当前累计可用余额" + monthBudgetEntity.getAccumulatedAvailableBalance() + "元");
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.AUDIT_DIFF.getCode().equals(operationType)) {
                monthBudgetEntity.setAdjustAmount(
                        Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType)) {
                monthBudgetEntity.setEstimatedExcessAmount(
                        Optional.ofNullable(monthBudgetEntity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO).add(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.DUTY_PROFIT_ADJUST.getCode().equals(operationType)) {
                //调入调整金额校验
                Validate.isTrue(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount).compareTo(BigDecimal.ZERO) >= 0, "调整金额必须小于可用余额");
                monthBudgetEntity.setAdjustAmount(
                        Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
                //考核扣款
                String controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();//默认强管控
                if (StringUtils.isNotEmpty(monthBudgetControlVo.getControlSituation())) {
                    controlSituation = monthBudgetControlVo.getControlSituation();
                }
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    Validate.isTrue(monthBudgetControlVo.getControlBalanceAmount().compareTo(operationAmount) >= 0, "[" + businessCode + "]使用金额[" + operationAmount + "]大于当前管控余额" + monthBudgetControlVo.getControlBalanceAmount() + "，请检查！");
                }
                monthBudgetEntity.setApprovedAmount(
                        operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO))
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
                //考核奖励
                monthBudgetEntity.setApprovedAmount(
                        Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
                );
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType)) {
                monthBudgetEntity.setFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)
                                .add(operationAmount)
                );
                monthBudgetEntity.setAfterFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO)
                                .subtract(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                                .subtract(operationAmount)
                );
            } else if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType)) {
                monthBudgetEntity.setFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)
                                .subtract(operationAmount)
                );
                monthBudgetEntity.setAfterFreezeAmount(
                        Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO)
                                .add(operationAmount)
                );
                monthBudgetEntity.setAccumulatedAvailableBalance(
                        Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO)
                                .add(operationAmount)
                );
            } else if (BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
                //管控口径为“批复口径”时,将总部/大区/分子公司本次结案金额+总部/大区/分子公司已结案金额的合计金额记录在申请时月度预算编码“结案金额”栏位中，2）且将总部/大区/分子公司结案金额与申请金额的差额记录在“结案差”字段；-----总结：按申请选择的预算原路退回
                monthBudgetEntity.setAuditAmount(Optional.ofNullable(monthBudgetEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(alreadyEndCaseAmount));
                monthBudgetEntity.setChangeAuditAmount(YesOrNoEnum.YES.getCode());

                monthBudgetEntity.setAlreadyEndCaseAmount(alreadyEndCaseAmount);
                monthBudgetEntity.setApprovedAuditDiff(Optional.ofNullable(monthBudgetEntity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setChangeApprovedAuditDiff(YesOrNoEnum.YES.getCode());

                monthBudgetEntity.setOldAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance());
                //当是否滚动为“是”，管控口径为“批复+结案口径”时：1）将总部/大区/分子公司本次结案金额+已结案金额的合计金额记录在申请时月度预算编码“结案金额”栏位中，2）且将总部/大区/分子公司结案金额与申请金额的差额记录在“结案差”字段；3）将差额记录在申请时月度预算编码中对应年度预算编码+预算年月为结案发生月份的月度预算编码“调整”栏位，并且更新累计可用余额-----总结：按申请选择的月度预算退到发生月份对应的月度预算编码，记录在调整金额栏位
                String yearMonth = null;
                if (StringUtils.isEmpty(operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth())) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
                    yearMonth = df.format(new Date());
                } else {
                    yearMonth = operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth();
                }
                //如果跨年了就取最后一个月
                String yearMonthLy = monthBudgetEntity.getYearMonthLy();
                String yearLy = yearMonthLy.substring(0,4);
                String currYearLy = yearMonth.substring(0,4);
                if (!yearLy.equals(currYearLy)){
                    yearMonth = yearLy + "-12";
                }
                monthBudgetEntity.setPlanReturnBudgetYearAndMonth(yearMonth);
                monthBudgetEntity.setAuditCode(operateMonthBudgetDto.getAuditCode());
                if (monthBudgetControlVo == null) {
                    monthBudgetEntity.setLogRemark("管控编码:无");
                } else {
                    monthBudgetEntity.setLogRemark("管控编码:" + monthBudgetControlVo.getControlsConfigCode() + ",是否滚动:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode(Optional.ofNullable(monthBudgetControlVo.getControlsCaliber()).orElse("").trim()));
                }
                if ((!yearMonth.equals(monthBudgetEntity.getYearMonthLy())) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) {

                    if (BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
                        List<String> yearMonths = Lists.newArrayList();
                        try {
                            Date nowYearMonth = df.parse(yearMonth);
                            Date budgetYearMonth = df.parse(monthBudgetEntity.getYearMonthLy());
                            Calendar cal = Calendar.getInstance();

                            do {
                                cal.setTime(budgetYearMonth);
                                cal.add(Calendar.MONTH, 1);
                                yearMonths.add(df.format(cal.getTime()));
                                budgetYearMonth = cal.getTime();
                            } while (budgetYearMonth.compareTo(nowYearMonth) < 0);
                        } catch (ParseException e) {
                            log.error("结案核销退预算错误", e);
                            throw new RuntimeException(e);
                        }
                        monthBudgetEntity.setAccumulatedAvailableBalance(
                                this.monthBudgetCalculateHelper
                                        .buildAccumulatedAvailableBalanceBefore(monthBudgetEntity, BusinessUnitEnum.VERTICAL)
                        );
                        monthBudgetEntity.setChangeAccumulatedAvailableBalance(YesOrNoEnum.YES.getCode());

                        List<MonthBudgetEntity> monthBudgetEntities = monthBudgetRepository.getListByYearMonth(monthBudgetEntity.getYearBudgetCode(), yearMonths);
                        ids.addAll(monthBudgetEntities.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList()));
                    } else {
                        MonthBudgetEntity one = monthBudgetRepository.getOneByYearBudgetCodeAndMonth(monthBudgetEntity.getYearBudgetCode(), yearMonth);
                        Validate.notNull(one, "月度预算编码【%s】未找到对应年度预算下当前月份%s的预算", monthBudgetEntity.getMonthBudgetCode(),yearMonth);
                        MonthBudgetEntity monthBudgetEntity1 = budgetEntityMap.get(one.getMonthBudgetCode());
                        if (monthBudgetEntity1 != null) {
                            one = monthBudgetEntity1;
                        }
                        one.setOldAccumulatedAvailableBalance(one.getAccumulatedAvailableBalance());
                        one.setAdjustAmount(
                                Optional.ofNullable(one.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                        );
                        one.setChangeAdjustAmount(YesOrNoEnum.YES.getCode());
                        one.setAccumulatedAvailableBalance(
                                Optional.ofNullable(one.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                        );
                        one.setChangeAccumulatedAvailableBalance(YesOrNoEnum.YES.getCode());
                        one.setAfterFreezeAmount(Optional.ofNullable(one.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                        one.setChangeAfterFreezeAmount(YesOrNoEnum.YES.getCode());
                        one.setLogRemark("管控编码:" + monthBudgetControlVo.getControlsConfigCode() + ",是否滚动:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode(monthBudgetControlVo.getControlsCaliber().trim()));
                        one.setAuditCode(operateMonthBudgetDto.getAuditCode());
                        budgetEntityMap.put(one.getMonthBudgetCode(), one);
                        detailList.add(this.buildDetail(one, operationAmount,one.getOldAccumulatedAvailableBalance(), operationType, businessCode));
                    }
                }
                //场景4：当是否滚动为“否”，管控口径为“批复口+结案口径”时：1）总部/大区/分子公司将本次结案金额+已结案金额的合计金额记录在申请时月度预算编码“结案金额”栏位中；2）且将总部/大区/分子公司结案金额与申请金额的差额记录在“结案差”字段；3）更新批复金额，批复金额=批复金额 减（总部/大区/分子公司结案金额与申请金额的差额），3）将差额按申请时的月度预算编码进行退回，数据更新在“调整”栏位；并且更新累计可用余额---总结：按申请选择的预算原路退回
                if ((yearMonth.equals(monthBudgetEntity.getYearMonthLy()) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) || monthBudgetControlVo == null || monthBudgetControlVo.getIfRolling() == null || (YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim()))) {
                    monthBudgetEntity.setAdjustAmount(
                            Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                    );
                    monthBudgetEntity.setChangeAdjustAmount(YesOrNoEnum.YES.getCode());
                    monthBudgetEntity.setAccumulatedAvailableBalance(
                            Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount)
                    );
                    monthBudgetEntity.setChangeAccumulatedAvailableBalance(YesOrNoEnum.YES.getCode());
                    monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                    monthBudgetEntity.setChangeAfterFreezeAmount(YesOrNoEnum.YES.getCode());
                }
            } else if (BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType)) {
                //管控口径为“批复口径”时,将总部/大区/分子公司本次结案金额+总部/大区/分子公司已结案金额的合计金额记录在申请时月度预算编码“结案金额”栏位中，2）且将总部/大区/分子公司结案金额与申请金额的差额记录在“结案差”字段；-----总结：按申请选择的预算原路退回

                monthBudgetEntity.setAuditAmount(Optional.ofNullable(monthBudgetEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(alreadyEndCaseAmount));
                monthBudgetEntity.setAlreadyEndCaseAmount(alreadyEndCaseAmount);

                monthBudgetEntity.setOldAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance());
                //如果结案差等于0，只记录结案金额
                if (Optional.ofNullable(operationAmount).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) != 0 || BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                    monthBudgetEntity.setApprovedAuditDiff(Optional.ofNullable(monthBudgetEntity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO).add(operationAmount));

                    //当是否滚动为“是”，管控口径为“批复+结案口径”时：1）将总部/大区/分子公司本次结案金额+已结案金额的合计金额记录在申请时月度预算编码“结案金额”栏位中，2）且将总部/大区/分子公司结案金额与申请金额的差额记录在“结案差”字段；3）将差额记录在申请时月度预算编码中对应年度预算编码+预算年月为结案发生月份的月度预算编码“调整”栏位，并且更新累计可用余额-----总结：按申请选择的月度预算退到发生月份对应的月度预算编码，记录在调整金额栏位
                    String yearMonth = null;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
                    if (StringUtils.isEmpty(operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth())) {
                        yearMonth = df.format(new Date());
                    } else {
                        yearMonth = operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth();
                    }
                    //如果跨年了就取最后一个月
                    String yearMonthLy = monthBudgetEntity.getYearMonthLy();
                    String yearLy = yearMonthLy.substring(0,4);
                    String currYearLy = yearMonth.substring(0,4);
                    if (!yearLy.equals(currYearLy)){
                        yearMonth = yearLy + "-12";
                    }

                    log.info("活动方案预算跟踪表退预算yearMonth:{},monthBudgetEntity:{},monthBudgetControlVo:{}", yearMonth, monthBudgetEntity, monthBudgetControlVo);
                    monthBudgetEntity.setPlanReturnBudgetYearAndMonth(yearMonth);
                    if (monthBudgetControlVo == null) {
                        monthBudgetEntity.setLogRemark("管控编码:无");
                    } else {
                        monthBudgetEntity.setLogRemark("管控编码:" + monthBudgetControlVo.getControlsConfigCode() + ",是否滚动:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode(Optional.ofNullable(monthBudgetControlVo.getControlsCaliber()).orElse("").trim()));
                    }
                    if ((!yearMonth.equals(monthBudgetEntity.getYearMonthLy())) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) {

                        log.info("活动方案预算跟踪表退预算operateMonthBudgetDto:{}", operateMonthBudgetDto);
                        if (BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {

                            List<String> yearMonths = Lists.newArrayList();
                            try {
                                Date nowYearMonth = df.parse(yearMonth);
                                Date budgetYearMonth = df.parse(monthBudgetEntity.getYearMonthLy());
                                Calendar cal = Calendar.getInstance();

                                do {
                                    cal.setTime(budgetYearMonth);
                                    cal.add(Calendar.MONTH, 1);
                                    yearMonths.add(df.format(cal.getTime()));
                                    budgetYearMonth = cal.getTime();
                                } while (budgetYearMonth.compareTo(nowYearMonth) < 0);
                            } catch (ParseException e) {
                                log.error("结案核销退预算错误", e);
                                throw new RuntimeException(e);
                            }
                            monthBudgetEntity.setAccumulatedAvailableBalance(
                                    this.monthBudgetCalculateHelper
                                            .buildAccumulatedAvailableBalanceBefore(monthBudgetEntity, BusinessUnitEnum.VERTICAL)
                            );

                            List<MonthBudgetEntity> monthBudgetEntities = monthBudgetRepository.getListByYearMonth(monthBudgetEntity.getYearBudgetCode(), yearMonths);
                            ids.addAll(monthBudgetEntities.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList()));
                            log.info("活动方案预算跟踪表退预算ids:{}", JsonUtils.obj2JsonString(ids));
                        } else {
                            MonthBudgetEntity one = monthBudgetRepository.getOneByYearBudgetCodeAndMonth(monthBudgetEntity.getYearBudgetCode(), yearMonth);
                            Validate.notNull(one, "月度预算编码【%s】未找到对应年度预算下当前月份%s的预算", monthBudgetEntity.getMonthBudgetCode(),yearMonth);
                            MonthBudgetEntity monthBudgetEntity1 = budgetEntityMap.get(one.getMonthBudgetCode());
                            if (monthBudgetEntity1 != null) {
                                one = monthBudgetEntity1;
                            }

                            one.setOldAccumulatedAvailableBalance(one.getAccumulatedAvailableBalance());
                            one.setAdjustAmount(
                                    Optional.ofNullable(one.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount)
                            );
                            one.setAccumulatedAvailableBalance(
                                    Optional.ofNullable(one.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
                            );
                            one.setAfterFreezeAmount(Optional.ofNullable(one.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                            one.setLogRemark("管控编码:" + monthBudgetControlVo.getControlsConfigCode() + ",是否滚动:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode(monthBudgetControlVo.getControlsCaliber().trim()));
                            budgetEntityMap.put(one.getMonthBudgetCode(), one);
                            detailList.add(this.buildDetail(one, operationAmount,beforeAmount, operationType, businessCode));
                        }
                    }
                    //场景4：当是否滚动为“否”，管控口径为“批复口+结案口径”时：1）总部/大区/分子公司将本次结案金额+已结案金额的合计金额记录在申请时月度预算编码“结案金额”栏位中；2）且将总部/大区/分子公司结案金额与申请金额的差额记录在“结案差”字段；3）更新批复金额，批复金额=批复金额 减（总部/大区/分子公司结案金额与申请金额的差额），3）将差额按申请时的月度预算编码进行退回，数据更新在“调整”栏位；并且更新累计可用余额---总结：按申请选择的预算原路退回
                    if ((yearMonth.equals(monthBudgetEntity.getYearMonthLy()) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) || monthBudgetControlVo == null || monthBudgetControlVo.getIfRolling() == null || (YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim()))) {
                        if (!BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                            monthBudgetEntity.setAdjustAmount(
                                    Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount)
                            );
                        }
                        monthBudgetEntity.setAccumulatedAvailableBalance(
                                Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount)
                        );
                        monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                    }
                } else if (Optional.ofNullable(operationAmount).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) == 0 || BusinessUnitEnum.isDefaultBusinessUnit(operateMonthBudgetDto.getBusinessUnitCode())) {
                    monthBudgetEntity.setLogRemark("管控编码:无");
                }
            } else if (BudgetOperationTypeEnum.AUDIT_REJECT.getCode().equals(operationType)) {
                monthBudgetEntity.setOldAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance());
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAuditAmount())) {
                    monthBudgetEntity.setAuditAmount(Optional.ofNullable(monthBudgetEntity.getAuditAmount()).orElse(BigDecimal.ZERO).subtract(alreadyEndCaseAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeApprovedAuditDiff())) {
                    monthBudgetEntity.setApprovedAuditDiff(Optional.ofNullable(monthBudgetEntity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAdjustAmount())) {
                    monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAccumulatedAvailableBalance())) {
                    monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAfterFreezeAmount())) {
                    monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
            } else {
                throw new RuntimeException("月度预算操作类型有误！");
            }
            // 构建操作明细
            MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, operationAmount,beforeAmount, operationType, businessCode);
            detailList.add(monthBudgetDetailDto);
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave) {//为空默认保存
            monthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            manualRolling(ids);
        }
    }

    @Override
    public void operateBudgetStrategy(List<OperateMonthBudgetDto> operateList) {
        operateBudgetStrategy(operateList, Maps.newHashMap());
    }

    @Override
    public void operateBudgetStrategy(List<OperateMonthBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        List<MonthBudgetEntity> budgetEntityList = validateOperateBudget(operateList);
        Map<String, MonthBudgetEntity> budgetEntityMap = budgetEntityList.stream().collect(Collectors.toMap(MonthBudgetEntity::getMonthBudgetCode, Function.identity()));
        Map<String, MonthBudgetControlVo> controlMap = this.mapControlAmountByBudgetList(budgetEntityList);

        Boolean throwException = operateList.get(0).getThrowException();
        List<MonthBudgetDetailDto> detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            MonthBudgetEntity monthBudgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            MonthBudgetControlVo monthBudgetControlVo = controlMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            BigDecimal looseAmount = looseAmountMap.getOrDefault(monthBudgetEntity.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal usedStrategyAmount = Optional.ofNullable(monthBudgetEntity.getUsedStrategyAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usableStrategyAmount = monthBudgetEntity.getAfterFreezeAmount().add(looseAmount).subtract(usedStrategyAmount);
            // 根据预算类型操作预算
            String businessDesc = "";
            if (StringUtils.isNotEmpty(businessCode)) {
                businessDesc = "[" + businessCode + "]";
            }
            opertion:
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                String controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();//默认强管控
                if (ObjectUtils.isNotEmpty(monthBudgetControlVo)
                        && StringUtils.isNotEmpty(monthBudgetControlVo.getControlSituation())) {
                    controlSituation = monthBudgetControlVo.getControlSituation();
                }
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    if (!(usableStrategyAmount.compareTo(operationAmount) >= 0)) {
                        if (throwException) {
                            throw new RuntimeException(businessDesc + "使用金额[" + operationAmount + "]大于预算[" + operateMonthBudgetDto.getMonthBudgetCode() + "]可用余额" + usableStrategyAmount + "，请检查！");
                        } else {
                            operateMonthBudgetDto.setGapAmount(operationAmount.subtract(usableStrategyAmount));
                            monthBudgetEntity.setUsedStrategyAmount(monthBudgetEntity.getAfterFreezeAmount());
                            break opertion;//不够就记录差额就行了，不处理数据
                        }
                    }
                }
                monthBudgetEntity.setUsedStrategyAmount(usedStrategyAmount.add(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                monthBudgetEntity.setUsedStrategyAmount(usedStrategyAmount.subtract(operationAmount));
            } else {
                throw new RuntimeException(businessDesc + "月度预算策略占用金额操作类型有误！");
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave) {//为空默认保存
            monthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
        }
    }

    public List<MonthBudgetEntity> validateOperateBudget(List<OperateMonthBudgetDto> operateList) {
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty(operateMonthBudgetDto.getMonthBudgetCode(), "操作预算时，预算编码不能为空！");
//            Validate.notNull(operateMonthBudgetDto.getOperationAmount(), "操作预算时，操作金额不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getOperationType(), "操作预算时，操作类型不能为空！");
        }

        List<String> monthBudgetCodeList = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<MonthBudgetEntity> budgetEntityList = monthBudgetRepository.listByCodes(monthBudgetCodeList);
        if (budgetEntityList.size() < monthBudgetCodeList.size()) {
            List<String> existsCodes = budgetEntityList.stream().map(MonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
            String notExistsJoinCodesStr = monthBudgetCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("预算操作失败，月度预算[" + notExistsJoinCodesStr + "]查询失败，请检查预算是否启用或是否存在！！");
        }
        for (MonthBudgetEntity monthBudgetEntity : budgetEntityList) {
            if (null == monthBudgetEntity.getUsedStrategyAmount()) {
                monthBudgetEntity.setUsedStrategyAmount(BigDecimal.ZERO);
            }
            if (null == monthBudgetEntity.getInitResolveAmount()) {
                monthBudgetEntity.setInitResolveAmount(BigDecimal.ZERO);
            }
        }
        return budgetEntityList;
    }

    /**
     * 保存更新操作预算数据
     *
     * @param budgetList 预算头数据
     * @param detailList 预算明细数据
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateOperateBudget(Collection<MonthBudgetEntity> budgetList, List<MonthBudgetDetailDto> detailList) {
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.monthBudgetRepository.updateBatchById(budgetList);
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            // 构建操作明细
            monthBudgetDetailService.createList(detailList);
        }
    }

    /**
     * 划拨
     *
     * @param dto
     * @author huojia
     * @date 2022/11/7 19:55
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transfer(MonthBudgetTransferDto dto) {
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getMonthBudgetCode(), "月度预算编码不能为空！");
        Validate.notEmpty(dto.getDetailDtoList(), "操作明细不能为空！");
        // 查询当前月度预算
        MonthBudgetEntity monthBudgetEntity = monthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), EnableStatusEnum.ENABLE.getCode());
        Validate.notNull(monthBudgetEntity, "当前预算不存在或未启用，请刷新后重试！");
        List<MonthBudgetEntity> dimensionBudgetList = new ArrayList<>();
        // 查询同维度的预算，存在则直接划拨；不存在则新增预算
        dto.getDetailDtoList().forEach(detailDto -> {
            MonthBudgetDto monthBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(detailDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            monthBudgetDto.setYearMonthLy(monthBudgetEntity.getYearMonthLy());
            // 不应该自己划拨到自己
            // 如果寻到拨出的月度预算，则表明选择拨入维度时，选择的值和拨出预算完全一致（组织、客户等字段），拨入预算的值不应该和拨出预算完全一致
            List<MonthBudgetEntity> monthBudgetEntityList = this.findByDimension(monthBudgetDto);
            if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
                // 没查询到当前维度月度预算，则新增月度预算
                MonthBudgetEntity addMonthBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailDto, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
                addMonthBudgetEntity.setYearMonthLy(monthBudgetEntity.getYearMonthLy());
                addMonthBudgetEntity.setAdjustAmount(detailDto.getTransferAmount());
                addMonthBudgetEntity.setAccumulatedAvailableBalance(detailDto.getTransferAmount());
                dimensionBudgetList.add(addMonthBudgetEntity);
            } else {
                // 理论上只应该寻到一条
                log.info("查询同维度月度预算成功，共查询到" + monthBudgetEntityList.size() + "条");
                MonthBudgetEntity dimensionBudget = monthBudgetEntityList.get(0);
                if (StringUtils.equals(monthBudgetEntity.getMonthBudgetCode(), dimensionBudget.getMonthBudgetCode())) {
                    throw new RuntimeException("划拨失败，预算" + monthBudgetEntity.getMonthBudgetCode() + "不能划拨至预算" + dimensionBudget.getMonthBudgetCode());
                }
                dimensionBudget.setAdjustAmount(Optional.ofNullable(dimensionBudget.getAdjustAmount()).orElse(BigDecimal.ZERO).add(detailDto.getTransferAmount()));
                dimensionBudget.setAccumulatedAvailableBalance(dimensionBudget.getAccumulatedAvailableBalance().add(detailDto.getTransferAmount()));
                dimensionBudgetList.add(dimensionBudget);
            }
        });
        boolean lockFlag = true;
        List<String> lockKeys = new ArrayList<>();
        // 批量加锁，只能在这个时候加锁，会不会有问题呢？
        if (!CollectionUtils.isEmpty(dimensionBudgetList)) {
            lockKeys = dimensionBudgetList.stream().map(MonthBudgetEntity::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toList());
        }
        lockKeys.add(dto.getMonthBudgetCode());
        try {
            lockFlag = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            // 拨出
            BigDecimal transferAmount = dto.getDetailDtoList().stream().map(MonthBudgetTransferDetailDto::getTransferAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(transferAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance().subtract(transferAmount));
            dimensionBudgetList.add(monthBudgetEntity);
            dimensionBudgetList.forEach(entity->{
                entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(),DateUtil.DEFAULT_YEAR_MONTH));
            });
            monthBudgetRepository.saveOrUpdateBatch(dimensionBudgetList);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    /**
     * 根据流程编码，查看月度预算调整数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetAdjustVo
     * @author huojia
     * @date 2022/11/14 15:45
     **/
    @Override
    public MonthBudgetMainAdjustVo adjustQuery(String processNo) {
        Validate.notEmpty(processNo, "请求失败，流程编码不能为空！");
        List<MonthBudgetDetailEntity> monthBudgetDetailEntityList = monthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntityList)) {
            throw new RuntimeException("数据查询失败，对应月度预算调整明细不存在！");
        }
        List<String> codeList = monthBudgetDetailEntityList.stream().filter(k -> StringUtils.isNotEmpty(k.getMonthBudgetCode()))
                .map(MonthBudgetDetailEntity::getMonthBudgetCode)
                .distinct().collect(Collectors.toList());
        List<MonthBudgetEntity> budgetEntityList = monthBudgetRepository.getByMonthBudgetCodes(codeList, null);
        Map<String, MonthBudgetAdjustVo> budgetAdjustVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(budgetEntityList)) {
            Collection<MonthBudgetAdjustVo> adjustList = this.nebulaToolkitService.copyCollectionByWhiteList(budgetEntityList, MonthBudgetEntity.class, MonthBudgetAdjustVo.class, LinkedHashSet.class, ArrayList.class);
            budgetAdjustVoMap.putAll(adjustList.stream()
                    .filter(k -> StringUtils.isNotEmpty(k.getMonthBudgetCode()))
                    .collect(Collectors.toMap(MonthBudgetAdjustVo::getMonthBudgetCode, v -> v, (n, o) -> n)));
        }
        MonthBudgetMainAdjustVo monthBudgetMainAdjustVo = new MonthBudgetMainAdjustVo();
        List<MonthBudgetAdjustVo> adjustOutVoList = new ArrayList<>();
        // 查看页面的可用余额用实时的数据
        monthBudgetDetailEntityList.forEach(detailEntity -> {
            MonthBudgetAdjustVo monthBudgetVo = budgetAdjustVoMap.get(detailEntity.getMonthBudgetCode());
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(detailEntity.getOperationType())) {
                monthBudgetVo.setAccumulatedAvailableBalance(detailEntity.getBeforeAmount());
                monthBudgetVo.setAdjustInAmount(detailEntity.getCurOperationAmount());
                monthBudgetVo.setAdjustInBalance(detailEntity.getBalanceAmount().add(detailEntity.getCurOperationAmount()));
                monthBudgetVo.setOperationRemarks(detailEntity.getOperationRemarks());
                monthBudgetMainAdjustVo.setAdjustInVo(monthBudgetVo);
            } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(detailEntity.getOperationType())) {
                monthBudgetVo.setAccumulatedAvailableBalance(detailEntity.getBeforeAmount());
                monthBudgetVo.setAdjustOutAmount(detailEntity.getCurOperationAmount());
                monthBudgetVo.setAdjustInBalance(detailEntity.getBalanceAmount());
                adjustOutVoList.add(monthBudgetVo);
            }
        });
        monthBudgetMainAdjustVo.setAdjustOutVoList(adjustOutVoList);
        return monthBudgetMainAdjustVo;
    }

    /**
     * 根据流程编码，查看月度预算调整数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetAdjustVo
     * @author huojia
     * @date 2022/11/14 15:45
     **/
    @Override
    public MonthBudgetMainAdjustVo adjustSumQuery(String processNo) {
        Validate.notEmpty(processNo, "请求失败，流程编码不能为空！");
        List<MonthBudgetDetailEntity> monthBudgetDetailEntityList = monthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntityList)) {
            throw new RuntimeException("数据查询失败，对应月度预算调整明细不存在！");
        }
        List<String> codeList = monthBudgetDetailEntityList.stream().filter(k -> StringUtils.isNotEmpty(k.getMonthBudgetCode()))
                .map(MonthBudgetDetailEntity::getMonthBudgetCode)
                .distinct().collect(Collectors.toList());
        List<MonthBudgetEntity> budgetEntityList = monthBudgetRepository.getByMonthBudgetCodes(codeList, null);
        Map<String, MonthBudgetAdjustVo> budgetAdjustVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(budgetEntityList)) {
            Collection<MonthBudgetAdjustVo> adjustList = this.nebulaToolkitService.copyCollectionByWhiteList(budgetEntityList, MonthBudgetEntity.class, MonthBudgetAdjustVo.class, LinkedHashSet.class, ArrayList.class);
            budgetAdjustVoMap.putAll(adjustList.stream()
                    .filter(k -> StringUtils.isNotEmpty(k.getMonthBudgetCode()))
                    .collect(Collectors.toMap(MonthBudgetAdjustVo::getMonthBudgetCode, v -> v, (n, o) -> n)));
        }


        MonthBudgetMainAdjustVo monthBudgetMainAdjustVo = new MonthBudgetMainAdjustVo();
        Map<String,MonthBudgetAdjustVo> sumMap = Maps.newHashMap();
//        展示发起预算调整的调出方预算的预算项目、所属部门名称、年月、调出金额以及调出后的余额。并按照预算项目+部门名称+年月进行汇总调出金额以及调出后的余额展示
        // 查看页面的可用余额用实时的数据
        monthBudgetDetailEntityList.forEach(detailEntity -> {
            MonthBudgetAdjustVo monthBudgetVo = budgetAdjustVoMap.get(detailEntity.getMonthBudgetCode());
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(detailEntity.getOperationType())) {
                monthBudgetVo.setAccumulatedAvailableBalance(detailEntity.getBeforeAmount());
                monthBudgetVo.setAdjustInAmount(detailEntity.getCurOperationAmount());
                monthBudgetVo.setAdjustInBalance(detailEntity.getBalanceAmount().add(detailEntity.getCurOperationAmount()));
                monthBudgetVo.setOperationRemarks(detailEntity.getOperationRemarks());
                monthBudgetMainAdjustVo.setAdjustInVo(monthBudgetVo);
            } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(detailEntity.getOperationType())) {
                String key = monthBudgetVo.getBudgetItemName()+monthBudgetVo.getOrgName()+monthBudgetVo.getYearMonthLy();
                MonthBudgetAdjustVo sumVo = sumMap.computeIfAbsent(key,tempKey -> monthBudgetVo);
                sumVo.setAccumulatedAvailableBalance(Optional.ofNullable(sumVo.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getBeforeAmount()).orElse(BigDecimal.ZERO)));
                sumVo.setAdjustOutAmount(Optional.ofNullable(sumVo.getAdjustOutAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                sumVo.setAdjustOutBalance(Optional.ofNullable(sumVo.getAdjustOutBalance()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getBalanceAmount()).orElse(BigDecimal.ZERO)));
            }
        });
        List<MonthBudgetAdjustVo> adjustOutVoList = Lists.newArrayList(sumMap.values());
        monthBudgetMainAdjustVo.setAdjustOutVoList(adjustOutVoList);
//        展示发起预算调整的调出方预算的预算项目、所属部门名称、年月、调出金额以及调出后的余额。并按照预算项目+部门名称+年月进行汇总调出金额以及调出后的余额展示
        return monthBudgetMainAdjustVo;
    }

    /**
     * 审批中查看 变更明细
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetChangeVo
     * @author huojia
     * @date 2022/11/14 16:24
     **/
    @Override
    public MonthBudgetChangeVo changeQuery(String processNo) {
        Validate.notEmpty(processNo, "请求失败，流程编码不能为空！");
        List<MonthBudgetDetailEntity> monthBudgetDetailEntityList = monthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntityList)) {
            throw new RuntimeException("数据查询失败，对应月度预算调整明细不存在！");
        }
        MonthBudgetDetailEntity monthBudgetDetailEntity = monthBudgetDetailEntityList.get(0);
        MonthBudgetEntity monthBudgetEntity = monthBudgetRepository.getByMonthBudgetCode(monthBudgetDetailEntity.getMonthBudgetCode(), null);
        MonthBudgetChangeVo monthBudgetChangeVo = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, MonthBudgetChangeVo.class, LinkedHashSet.class, ArrayList.class);
        if (BudgetOperationTypeEnum.ADD.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
            monthBudgetChangeVo.setAccumulatedAvailableBalance(monthBudgetDetailEntity.getBeforeAmount());
            monthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.ADD.getCode());
            monthBudgetChangeVo.setChangeAmount(monthBudgetDetailEntity.getCurOperationAmount());
            monthBudgetChangeVo.setChangeBalance(monthBudgetDetailEntity.getBalanceAmount().add(monthBudgetDetailEntity.getCurOperationAmount()));
            monthBudgetChangeVo.setChangeRemarks(monthBudgetDetailEntity.getOperationRemarks());
        }
        if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
            monthBudgetChangeVo.setAccumulatedAvailableBalance(monthBudgetDetailEntity.getBeforeAmount());
            monthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.SUBTRACT.getCode());
            monthBudgetChangeVo.setChangeAmount(monthBudgetDetailEntity.getCurOperationAmount());
            monthBudgetChangeVo.setChangeBalance(monthBudgetDetailEntity.getBalanceAmount());
            monthBudgetChangeVo.setChangeRemarks(monthBudgetDetailEntity.getOperationRemarks());
        }
        return monthBudgetChangeVo;
    }

    /**
     * 查询同维度的月度预算
     *
     * @param monthBudgetDto
     * @return com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity
     * @author huojia
     * @date 2022/11/7 20:55
     **/
    private List<MonthBudgetEntity> findByDimension(MonthBudgetDto monthBudgetDto) {
        Validate.notNull(monthBudgetDto, "查询同维度的月度预算的请求参数不能为空！");
        List<MonthBudgetEntity> monthBudgetEntityList = monthBudgetMapper.findByDimension(monthBudgetDto);
        return monthBudgetEntityList;
    }

    /**
     * 构建预算操作明细
     *
     * @param monthBudgetEntity 月度预算编码
     * @param operationAmount   操作金额
     * @param operationType     操作类型
     * @param businessCode      业务编码
     * @return com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto
     * @author huojia
     * @date 2022/11/1 11:33
     **/
    private MonthBudgetDetailDto buildDetail(MonthBudgetEntity monthBudgetEntity, BigDecimal operationAmount, BigDecimal beforeAmount,String operationType, String businessCode) {
        MonthBudgetDetailDto monthBudgetDetailDto = nebulaToolkitService.copyObjectByWhiteList(
                monthBudgetEntity, MonthBudgetDetailDto.class, LinkedHashSet.class, ArrayList.class
        );
        operationAmount = Objects.isNull(operationAmount) ? BigDecimal.ZERO : operationAmount;
        monthBudgetDetailDto.setId(null);
        monthBudgetDetailDto.setBusinessCode(businessCode);
        monthBudgetDetailDto.setOperationType(operationType);
        monthBudgetDetailDto.setInitialAmount(monthBudgetEntity.getInitResolveAmount());
        monthBudgetDetailDto.setBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
        // 根据不同操作类型，设置不同操作前金额
        if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType)
                || BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)
                || BudgetOperationTypeEnum.REPLAY.getCode().equals(operationType)
                || BudgetOperationTypeEnum.PLAN.getCode().equals(operationType)
                || BudgetOperationTypeEnum.ACTUAL_SALES.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType)
                || BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType)
                || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType)
                || BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)
                || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType)
                || BudgetOperationTypeEnum.USE.getCode().equals(operationType)
                || BudgetOperationTypeEnum.DEDUCTION.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.ADD.getCode().equals(operationType)
                || BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)
                || BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        }  else if (BudgetOperationTypeEnum.AUDIT_DIFF.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType) || BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType) || BudgetOperationTypeEnum.AUDIT_REJECT.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
            monthBudgetDetailDto.setAlreadyEndCaseAmount(monthBudgetEntity.getAlreadyEndCaseAmount());
            monthBudgetDetailDto.setPlanReturnBudgetYearAndMonth(monthBudgetEntity.getPlanReturnBudgetYearAndMonth());
            monthBudgetDetailDto.setAuditCode(monthBudgetEntity.getAuditCode());
            monthBudgetDetailDto.setRemark(monthBudgetEntity.getLogRemark());
            if (BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
                monthBudgetDetailDto.setChangeAuditAmount(monthBudgetEntity.getChangeAuditAmount());
                monthBudgetDetailDto.setChangeApprovedAuditDiff(monthBudgetEntity.getChangeApprovedAuditDiff());
                monthBudgetDetailDto.setChangeAdjustAmount(monthBudgetEntity.getChangeAdjustAmount());
                monthBudgetDetailDto.setChangeAccumulatedAvailableBalance(monthBudgetEntity.getChangeAccumulatedAvailableBalance());
                monthBudgetDetailDto.setChangeAfterFreezeAmount(monthBudgetEntity.getChangeAfterFreezeAmount());
            }
        } else if (BudgetOperationTypeEnum.IMPORT.getCode().equals(operationType)) {
            //传入的操作金额 为旧数据的累计可用金额
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
            operationAmount = monthBudgetDetailDto.getBeforeAmount().subtract(monthBudgetDetailDto.getBalanceAmount()).abs();
        }
        monthBudgetDetailDto.setCurOperationAmount(operationAmount);
        return monthBudgetDetailDto;
    }

    /**
     * 必要参数校验
     *
     * @param dto
     * @author huojia
     * @date 2022/10/27 20:41
     **/
    private void updateValidate(MonthBudgetDto dto) {
        Validate.notBlank(dto.getId(), "修改数据时，主键不能为空！");
        if (StringUtils.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        // 根据维度校验字段
        DimensionInformationQueryData dimensionVo = new DimensionInformationQueryData();
        dimensionVo.setBusinessFormatCode(dto.getBusinessFormatCode());
        dimensionVo.setBusinessUnitCode(dto.getBusinessUnitCode());
        dimensionVo.setMenu(MenuCodeEnum.MONTH_BUDGET.getCode());
        dimensionVo.setSalesOrgCodeList(Arrays.asList(dto.getSalesOrgCode()));
        List<DimensionDimensionInformationVo> dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dimensionVo);
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("未维护对应维度配置数据，请检查！");
        }
        Class<MonthBudgetDto> clazz = MonthBudgetDto.class;
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(dto);
                if (ObjectUtils.isEmpty(o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
    }

    /**
     * 月度预算导入
     *
     * @param monthBudgetDto
     */
    @Override
    public void importSave(MonthBudgetDto monthBudgetDto) {
        // 保存新的月度预算
        MonthBudgetEntity entity = this.nebulaToolkitService.copyObjectByBlankList(
                monthBudgetDto, MonthBudgetEntity.class, HashSet.class, ArrayList.class);
        //生成月度预算编码
//        String ruleCode = StringUtils.join(MonthBudgetConstant.MONTH_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> monthCodeList = generateCodeService.generateCode(MonthBudgetConstant.MONTH_BUDGET_CODE, 1, 8, 2, TimeUnit.DAYS);
        entity.setMonthBudgetCode(monthCodeList.get(0));
        monthBudgetDto.setMonthBudgetCode(entity.getMonthBudgetCode());
        entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(),DateUtil.DEFAULT_YEAR_MONTH));
        this.monthBudgetRepository.save(entity);
        // 月度预算生成期初操作明细
        MonthBudgetDetailEntity detailEntity = this.nebulaToolkitService.copyObjectByBlankList(
                entity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
        detailEntity.setInitialAmount(entity.getInitResolveAmount());
        detailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
        this.monthBudgetDetailRepository.save(detailEntity);
        // 业务日志新增
        MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(monthBudgetDto);
        SerializableBiConsumer<MonthBudgetLogEventListener, MonthBudgetLogEventDto> onCreate =
                MonthBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, MonthBudgetLogEventListener.class, onCreate);
    }

    /**
     * 优先计算实际销量
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map<String, MonthBudgetActualSalesVo> calculateActualSales(List<String> ids) {
        //构建实际销量计算对象
        Map<String, MonthBudgetActualSalesVo> salesVos = MonthBudgetActualSalesBuilder
                .init(ids, this.budgetCalculateStrategies, this.monthBudgetHelper)
                .basic()
                .salesData()
                .builder();
        List<MonthBudgetEntity> monthBudgetEntities = this.monthBudgetRepository.listByIds(ids);
        //保存实际销量
        monthBudgetEntities.forEach(entity -> {
            MonthBudgetActualSalesVo salesVo = salesVos.get(entity.getMonthBudgetCode());
            if (Objects.isNull(salesVo)) {
                log.info("月度预算[" + entity.getMonthBudgetCode() + "]未获取到月度预算计算实际销量Vo");
                return;
            }
            BudgetCalConfigVo budgetCalConfigVo = salesVo.getBudgetCalConfigVo();
            log.info("月度预算[" + entity.getMonthBudgetCode() + "]月度预算计算实际销量Vo" + JSONObject.toJSONString(salesVo));
            if (Objects.isNull(budgetCalConfigVo)) {
                entity.setBudgetCalCode("");
            } else {
                entity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
            }
            entity.setBillActualSales(salesVo.getActualSales());
            entity.setActualSales(salesVo.getActualSalesAmount());
            entity.setActualCosts(salesVo.getActualCostsAmount());
        });
        this.monthBudgetRepository.updateBatchById(monthBudgetEntities);
        return salesVos;
    }

    /**
     * 查询当前计算年月的月度计划
     *
     * @param id
     * @return {@link MonthBudgetVo}
     */
    @Override
    public MonthBudgetVo findCurrMonthBudgetById(String id, String yearMonthLy) {
        MonthBudgetDto dto = new MonthBudgetDto();
        dto.setId(id);
        Date date = DateUtil.parseDate(yearMonthLy, DateUtil.DEFAULT_YEAR_MONTH);
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.add(Calendar.MONTH, 1);
        dto.setYearMonthLy(DateUtil.format(cl.getTime(), "yyyy-MM"));
        return this.monthBudgetRepository.findCurrMonthBudgetById(dto);
    }

    @Override
    public ChangeBudgetVo auditUseBudget(AuditBudgetHeadVo auditBudgetHeadVo) {


        ChangeBudgetVo changeBudgetVo = new ChangeBudgetVo();

        List<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<>();

        //退预算预测
        List<SubComBudgetForecastDetailDto> subComBudgetForecastDetailDtoList = new ArrayList<>();
        //主体一个核销明细对应一个预算
        for (AuditBudgetVo auditBudgetVo : auditBudgetHeadVo.getAuditBudgetVoList()) {
            AuditBudgetItemVo auditBudgetItemVo = auditBudgetVo.getBudgetItems().get(0);
            if (BusinessUnitEnum.isDefaultBusinessUnit(auditBudgetHeadVo.getBusinessUnitCode()) ) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setOperationAmount(auditBudgetVo.getAmount());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                if (AuditUseBudgetTypeEnum.USE.equals(auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                } else if (AuditUseBudgetTypeEnum.USE_RETURN.equals(auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
                } else {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                }
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(auditBudgetVo.getPlanReturnBudgetYearAndMonth());
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {
                List<AuditBudgetItemVo> budgetItems = auditBudgetVo.getBudgetItems();
                operateMonthBudgetDtos.addAll(buildBudgetItem(budgetItems, auditBudgetVo));
                if (!CollectionUtils.isEmpty(operateMonthBudgetDtos)) {
                    operateMonthBudgetDtos.forEach(item -> {
                        item.setAuditCode(auditBudgetHeadVo.getAuditCode());
                    });
                }
            }
            if (BusinessUnitEnum.ONLINE.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setOperationAmount(auditBudgetVo.getAmount());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                if (AuditUseBudgetTypeEnum.USE.equals(auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                } else if (AuditUseBudgetTypeEnum.USE_RETURN.equals(auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
                } else {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                }
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAuditCode(auditBudgetHeadVo.getAuditCode());
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
            }
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {

                if (!CollectionUtils.isEmpty(auditBudgetVo.getBudgetItems())) {
                    //分子公司退预算
                    operateMonthBudgetDtos.addAll(Objects.requireNonNull(buildBudgetSonItem(auditBudgetVo)));
                }
                if (!CollectionUtils.isEmpty(auditBudgetVo.getDesignBudgetItems())) {
                    //退预算预测
                    subComBudgetForecastDetailDtoList.addAll(Objects.requireNonNull(buildForecastBudgetSonItem(auditBudgetVo, changeBudgetVo)));
                }
            }
        }
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {
            log.info("结案核销分子退预算operateMonthBudgetDtos:{}", JsonUtils.obj2JsonString(operateMonthBudgetDtos));
            if (!CollectionUtils.isEmpty(operateMonthBudgetDtos)) {
                List<String> monthBudgetCodes = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).collect(Collectors.toList());
                List<SubComMonthBudgetVo> subComMonthBudgetVos = subComMonthBudgetService.listByBudgetCodeList(monthBudgetCodes);
                Map<String, MonthBudgetControlVo> controlMap = this.mapControlAmountBySonComBudgetList(subComMonthBudgetVos);
                //加锁
                boolean lockSuccess = false;
                List<String> lockKeys = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
                try {
                    lockSuccess = subComMonthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME);
                    Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
                    subComMonthBudgetService.operateBudgetByAudit(operateMonthBudgetDtos, controlMap);
                } finally {
                    if (lockSuccess) {
                        subComMonthBudgetLockService.unlock(lockKeys);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(subComBudgetForecastDetailDtoList)) {
                List<String> budgetForecastCodes = subComBudgetForecastDetailDtoList.stream().map(SubComBudgetForecastDetailDto::getBudgetForecastCode).distinct().collect(Collectors.toList());
                boolean lock = subComBudgetForecastService.lock(budgetForecastCodes, TimeUnit.SECONDS, 60);
                Validate.isTrue(lock, "操作分子预算预测失败，获取操作锁失败！");
                try {
                    subComBudgetForecastDetailDtoList.forEach(item -> {
                        item.setProcessNo(auditBudgetHeadVo.getProcessNo());
                    });
                    subComBudgetForecastService.operationBudgetForecast(subComBudgetForecastDetailDtoList);

                } finally {
                    subComBudgetForecastService.unLock(budgetForecastCodes);
                }
                return changeBudgetVo;
            }
        } else {
            if (!CollectionUtils.isEmpty(operateMonthBudgetDtos)) {
                //加锁
                boolean lock = true;
                List<String> lockKeys = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
                try {
                    lock = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME);
                    if (lock) {
                        operateBudget(operateMonthBudgetDtos);
                    }
                } finally {
                    if (lock) {
                        monthBudgetLockService.unLock(lockKeys);
                    }
                }
            }
        }
        return null;
    }

    private List<SubComBudgetForecastDetailDto> buildForecastBudgetSonItem(AuditBudgetVo auditBudgetVo, ChangeBudgetVo changeBudgetVo) {
        List<SubComBudgetForecastDetailDto> operateMonthBudgetDtos = new ArrayList<>();
        List<AuditDesignBudgetItemVo> designBudgetItems = auditBudgetVo.getDesignBudgetItems();
        List<String> monthBudgetCodes = designBudgetItems.stream().map(AuditDesignBudgetItemVo::getBudgetForecastCode).collect(Collectors.toList());

        List<SubComBudgetForecastVo> subComBudgetForecastVoList = subComBudgetForecastService.findListByCodes(monthBudgetCodes);
        BigDecimal amount = auditBudgetVo.getAmount();
        //占用预算
        if (AuditUseBudgetTypeEnum.USE.equals(auditBudgetVo.getType())) {
            //1.点外
            List<SubComBudgetForecastVo> offPointFeeVoList = subComBudgetForecastVoList.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(offPointFeeVoList)) {
                for (SubComBudgetForecastVo subComBudgetForecastVo : offPointFeeVoList) {
                    SubComBudgetForecastDetailDto operateMonthBudgetDto = new SubComBudgetForecastDetailDto();
                    operateMonthBudgetDto.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                    if (amount.compareTo(subComBudgetForecastVo.getRemainderAmount()) <= 0) {
                        operateMonthBudgetDto.setCurOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = BigDecimal.ZERO;
                        break;
                    } else {
                        amount = amount.subtract(subComBudgetForecastVo.getRemainderAmount());
                        operateMonthBudgetDto.setCurOperationAmount(subComBudgetForecastVo.getRemainderAmount());
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    }
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //2.点内
            List<SubComBudgetForecastVo> internalPointFeeVoList = subComBudgetForecastVoList.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(internalPointFeeVoList)) {
                for (SubComBudgetForecastVo subComBudgetForecastVo : internalPointFeeVoList) {
                    SubComBudgetForecastDetailDto operateMonthBudgetDto = new SubComBudgetForecastDetailDto();
                    operateMonthBudgetDto.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                    if (amount.compareTo(subComBudgetForecastVo.getRemainderAmount()) <= 0) {
                        operateMonthBudgetDto.setCurOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = BigDecimal.ZERO;
                        break;
                    } else {
                        amount = amount.subtract(subComBudgetForecastVo.getRemainderAmount());
                        operateMonthBudgetDto.setCurOperationAmount(subComBudgetForecastVo.getRemainderAmount());
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    }
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //3.自投
            List<SubComBudgetForecastVo> autoFeeVoList = subComBudgetForecastVoList.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(autoFeeVoList)) {

                SonComBugdetDimensionalityDto detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo();

                List<SubComBudgetForecastVo> subComBudgetForecastVos = findAutoFeeForForecast(detailPlanItemVo);

                Validate.isTrue(!CollectionUtils.isEmpty(subComBudgetForecastVos), "占用预算未查询到自投的预算预测");
                if (!CollectionUtils.isEmpty(subComBudgetForecastVos)) {
                    SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVos.get(0);
                    SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                    subComBudgetForecastDetailDto.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                    subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    if (amount.compareTo(subComBudgetForecastVo.getRemainderAmount()) < 0) {
                        //特批
                        changeBudgetVo.setIsSpecial(YesOrNoEnum.YES.getCode());
                    }
                }

            } else {
                SubComBudgetForecastVo subComMonthBudgetVo = autoFeeVoList.get(0);

                SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto.setBudgetForecastCode(subComMonthBudgetVo.getBudgetForecastCode());
                subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                if (amount.compareTo(subComMonthBudgetVo.getRemainderAmount()) < 0) {
                    //特批
                    changeBudgetVo.setIsSpecial(YesOrNoEnum.YES.getCode());
                }
            }
            //退回预算
        } else {
            List<AuditDesignBudgetItemVo> designBudgetItemVos = auditBudgetVo.getDesignBudgetItems();
            //1.退自投
            List<AuditDesignBudgetItemVo> autoFeeItems = designBudgetItemVos.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(autoFeeItems)) {
                //结案金额为负数的时候负数部分是否退预算
                boolean negativeIsReturn = false;
                for (AuditDesignBudgetItemVo autoFeeItem : autoFeeItems) {
                    SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                    subComBudgetForecastDetailDto.setBudgetForecastCode(autoFeeItem.getBudgetForecastCode());
                    subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                    subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                    BigDecimal budgetCanReturnAmount = autoFeeItem.getBudgetAmount();
                    if (!negativeIsReturn && auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0) {
                        negativeIsReturn = true;
                        amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                        if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                            subComBudgetForecastDetailDto.setCurOperationAmount(amount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                            operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                            amount = BigDecimal.ZERO;
                            break;
                        } else {
                            subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                            operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                            amount = amount.subtract(budgetCanReturnAmount);
                        }
                    } else {
                        if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                            subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                            operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                            amount = BigDecimal.ZERO;
                            break;
                        } else {
                            subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount);
                            operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                            amount = amount.subtract(budgetCanReturnAmount);
                        }
                    }
                }
            } else {
                if (auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0) {
                    //寻预算
                    SonComBugdetDimensionalityDto detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo();
                    List<SubComBudgetForecastVo> subComBudgetForecastVos = findAutoFeeForForecast(detailPlanItemVo);
                    if (!CollectionUtils.isEmpty(subComBudgetForecastVos)) {
                        SubComBudgetForecastVo subComMonthBudgetVo = subComBudgetForecastVos.get(0);

                        SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                        subComBudgetForecastDetailDto.setBudgetForecastCode(subComMonthBudgetVo.getBudgetForecastCode());
                        subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                        subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                        subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                        subComBudgetForecastDetailDto.setCurOperationAmount(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                        operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);

                        amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                    }
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //2.退点内
            List<AuditDesignBudgetItemVo> internalPointFeeItems = designBudgetItemVos.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditDesignBudgetItemVo internalPointFeeItem : internalPointFeeItems) {
                SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto.setBudgetForecastCode(internalPointFeeItem.getBudgetForecastCode());
                subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                BigDecimal budgetCanReturnAmount = internalPointFeeItem.getBudgetAmount();
                if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                    subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    amount = BigDecimal.ZERO;
                    break;
                } else {
                    subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    amount = amount.subtract(budgetCanReturnAmount);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //3.退点外
            List<AuditDesignBudgetItemVo> offPointFeeItems = designBudgetItemVos.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditDesignBudgetItemVo offPointFeeItem : offPointFeeItems) {
                SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto.setBudgetForecastCode(offPointFeeItem.getBudgetForecastCode());
                subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                BigDecimal budgetCanReturnAmount = offPointFeeItem.getBudgetAmount();
                if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                    subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    break;
                } else {
                    subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    amount = amount.subtract(budgetCanReturnAmount);
                }
            }
        }
        return operateMonthBudgetDtos;
    }

    private List<SubComBudgetForecastVo> findAutoFeeForForecast(SonComBugdetDimensionalityDto detailPlanItemVo) {
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setBusinessFormatCode(detailPlanItemVo.getBusinessFormatCode());
        subComBudgetForecastDto.setOrgCode(detailPlanItemVo.getOrgCode());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        subComBudgetForecastDto.setYearMonthLy(df.format(detailPlanItemVo.getFeeYearMonth()));
        subComBudgetForecastDto.setBusinessUnitCode(detailPlanItemVo.getBusinessUnitCode());
        subComBudgetForecastDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        //业态+组织+年月+业务单元+费用来源（自投费用）
        return subComBudgetForecastService.findListByConditions(subComBudgetForecastDto);

    }

    private Map<String, MonthBudgetControlVo> mapControlAmountBySonComBudgetList(List<SubComMonthBudgetVo> monthBudgetList) {
        if (CollectionUtils.isEmpty(monthBudgetList)) {
            return new HashMap<>();
        }
        Map<String, MonthBudgetControlVo> amountMap = new HashMap<>();
        // 批量查询维度管控数据
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<DimensionControlsVo> dimensionControlsVos = dimensionControlsService.listByConditions(dimensionControlsDto);
        monthBudgetList.forEach(monthBudgetEntity -> {
            MonthBudgetControlVo monthBudgetControlVo = new MonthBudgetControlVo();
            monthBudgetControlVo.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());

            List<DimensionControlsVo> collect = dimensionControlsVos.stream().filter(vo -> monthBudgetEntity.getBusinessUnitCode().equals(vo.getBusinessUnitCode())).collect(Collectors.toList());
            // 按维度去查询预算的管控
            DimensionControlsVo sameItemControlsVo = null;
            DimensionControlsVo dimensionControlsVo = null;
            MonthBudgetEntity monthBudgetEntity1 = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, MonthBudgetEntity.class, null, null);
            sameItemControlsVo = this.findSameItemControlConfig(monthBudgetEntity1, collect);
            if (ObjectUtils.isEmpty(sameItemControlsVo)) {
                dimensionControlsVo = this.findControlConfig(monthBudgetEntity1, collect);
            } else {
                dimensionControlsVo = sameItemControlsVo;
            }

            // 没查询到配置，则直接使用余额
            if (ObjectUtils.isEmpty(dimensionControlsVo)) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            } else {
                monthBudgetControlVo.setIfRolling(dimensionControlsVo.getIfRolling());
                monthBudgetControlVo.setControlsCaliber(dimensionControlsVo.getControlsCaliber());
            }
            amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
        });
        return amountMap;
    }

    private List<OperateMonthBudgetDto> buildBudgetSonItem(AuditBudgetVo auditBudgetVo) {

        List<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<>();
        List<AuditBudgetItemVo> budgetItems = auditBudgetVo.getBudgetItems();
        List<String> monthBudgetCodes = budgetItems.stream().map(AuditBudgetItemVo::getMonthBudgetCode).collect(Collectors.toList());
        List<SubComMonthBudgetVo> subComMonthBudgetVoList = subComMonthBudgetService.listByBudgetCodeList(monthBudgetCodes);

        List<AuditDesignBudgetItemVo> designBudgetItems = auditBudgetVo.getDesignBudgetItems();
        List<String> budgetForecastCodes = designBudgetItems.stream().map(AuditDesignBudgetItemVo::getBudgetForecastCode).collect(Collectors.toList());
        List<SubComBudgetForecastVo> subComBudgetForecastVoList = subComBudgetForecastService.findListByCodes(budgetForecastCodes);
        //通过分子月度预算菜单的字段【年月】、【业态】、【业务单元】、【组织编码】【归口】、【预算项目编码】
        // 匹配分子预算预测菜单的字段：【年月】、【业态】、【业务单元】、【组织编码】【费用来源】、【预算项目编码】，
        // 匹配出每一条分子月度预算对应的分子预算预测，取分子预算预测字段【剩余可用余额】作为所有预算的可用余额判断
        Map<String, SubComBudgetForecastVo> subComBudgetForecastVoMap = subComBudgetForecastVoList.stream().collect(Collectors.toMap(o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode() + o.getBudgetItemCode(), Function.identity()));
        BigDecimal amount = auditBudgetVo.getAmount();
        //占用预算
        if (AuditUseBudgetTypeEnum.USE.equals(auditBudgetVo.getType())) {
            //1.点外
            List<SubComMonthBudgetVo> offPointFeeVoList = subComMonthBudgetVoList.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(offPointFeeVoList)) {
                for (SubComMonthBudgetVo subComMonthBudgetVo : offPointFeeVoList) {
                    OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                    SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVoMap.get(subComMonthBudgetVo.getYearMonthLy() + subComMonthBudgetVo.getBusinessFormatCode() + subComMonthBudgetVo.getBusinessUnitCode() + subComMonthBudgetVo.getOrgCode() + subComMonthBudgetVo.getFeeSourceCode() + subComMonthBudgetVo.getBudgetItemCode());
                    Validate.notNull(subComBudgetForecastVo, "月度预算【%s】未找到对应的预算预测", subComMonthBudgetVo.getMonthBudgetCode());

                    BigDecimal balance = subComBudgetForecastVo.getRemainderAmount();
                    if (amount.compareTo(balance) <= 0) {
                        operateMonthBudgetDto.setOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = BigDecimal.ZERO;
                        break;
                    } else {
                        amount = amount.subtract(balance);
                        operateMonthBudgetDto.setOperationAmount(balance);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    }
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //2.点内
            List<SubComMonthBudgetVo> internalPointFeeVoList = subComMonthBudgetVoList.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(internalPointFeeVoList)) {
                for (SubComMonthBudgetVo subComMonthBudgetVo : internalPointFeeVoList) {
                    OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                    SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVoMap.get(subComMonthBudgetVo.getYearMonthLy() + subComMonthBudgetVo.getBusinessFormatCode() + subComMonthBudgetVo.getBusinessUnitCode() + subComMonthBudgetVo.getOrgCode() + subComMonthBudgetVo.getFeeSourceCode() + subComMonthBudgetVo.getBudgetItemCode());
                    Validate.notNull(subComBudgetForecastVo, "月度预算【%s】未找到对应的预算预测", subComMonthBudgetVo.getMonthBudgetCode());

                    BigDecimal balance = subComBudgetForecastVo.getRemainderAmount();

                    if (amount.compareTo(balance) <= 0) {
                        operateMonthBudgetDto.setOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = BigDecimal.ZERO;
                        break;
                    } else {
                        amount = amount.subtract(balance);
                        operateMonthBudgetDto.setOperationAmount(balance);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    }
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //3.自投
            List<SubComMonthBudgetVo> autoFeeVoList = subComMonthBudgetVoList.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(autoFeeVoList)) {
                SonComBugdetDimensionalityDto detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo();
                List<SubComMonthBudgetVo> subComMonthBudgetVos = findAutoFee(detailPlanItemVo);
                if (!CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                    SubComMonthBudgetVo subComMonthBudgetVo = subComMonthBudgetVos.get(0);
                    OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    operateMonthBudgetDto.setOperationAmount(amount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                }

            } else {
                SubComMonthBudgetVo subComMonthBudgetVo = autoFeeVoList.get(0);

                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setOperationAmount(amount);
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
            }
            //退回预算
        } else {
            List<AuditBudgetItemVo> returnBudgetItems = auditBudgetVo.getBudgetItems();
            //1.退自投 （如果有只会找到一个自投）
            //结案金额为负数的那部分钱，都退到自投里面
            List<AuditBudgetItemVo> autoFeeItems = returnBudgetItems.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(autoFeeItems)) {
                //结案金额为负数的时候负数部分是否退预算
                boolean negativeIsReturn = false;
                for (AuditBudgetItemVo autoFeeItem : autoFeeItems) {
                    OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(autoFeeItem.getMonthBudgetCode());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                    BigDecimal budgetCanReturnAmount = autoFeeItem.getUseAmount().subtract(Optional.ofNullable(autoFeeItem.getCloseAmount()).orElse(BigDecimal.ZERO));

                    if (!negativeIsReturn && auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0) {
                        negativeIsReturn = true;
                        amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                        if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                            operateMonthBudgetDto.setOperationAmount(amount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                            amount = BigDecimal.ZERO;
                            break;
                        } else {
                            operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                            amount = amount.subtract(budgetCanReturnAmount);
                        }
                    } else {
                        if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                            operateMonthBudgetDto.setOperationAmount(amount);
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                            amount = BigDecimal.ZERO;
                            break;
                        } else {
                            operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount);
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                            amount = amount.subtract(budgetCanReturnAmount);
                        }
                    }
                }
            } else {

                if (auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0) {
                    //寻预算
                    SonComBugdetDimensionalityDto detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo();
                    List<SubComMonthBudgetVo> subComMonthBudgetVos = findAutoFee(detailPlanItemVo);
                    if (!CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                        SubComMonthBudgetVo subComMonthBudgetVo = subComMonthBudgetVos.get(0);
                        OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                        operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                        operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                        operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                        operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                        operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                        operateMonthBudgetDto.setOperationAmount(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                    }
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //2.退点内
            List<AuditBudgetItemVo> internalPointFeeItems = returnBudgetItems.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditBudgetItemVo internalPointFeeItem : internalPointFeeItems) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(internalPointFeeItem.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                BigDecimal budgetCanReturnAmount = internalPointFeeItem.getUseAmount().subtract(Optional.ofNullable(internalPointFeeItem.getCloseAmount()).orElse(BigDecimal.ZERO));
                if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                    operateMonthBudgetDto.setOperationAmount(amount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    amount = BigDecimal.ZERO;
                    break;
                } else {
                    operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    amount = amount.subtract(budgetCanReturnAmount);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            //3.退点外
            List<AuditBudgetItemVo> offPointFeeItems = returnBudgetItems.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditBudgetItemVo offPointFeeItem : offPointFeeItems) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(offPointFeeItem.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());

                BigDecimal budgetCanReturnAmount = offPointFeeItem.getUseAmount().subtract(Optional.ofNullable(offPointFeeItem.getCloseAmount()).orElse(BigDecimal.ZERO));
                if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                    operateMonthBudgetDto.setOperationAmount(amount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    break;
                } else {
                    operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    amount = amount.subtract(budgetCanReturnAmount);
                }
            }

        }
        return operateMonthBudgetDtos;
    }

    private List<SubComMonthBudgetVo> findAutoFee(SonComBugdetDimensionalityDto detailPlanItemVo) {
        //寻预算 最大的维度 业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组+客户+门店+品牌+品类+品项+产品
        SubComMonthBudgetDto subComMonthBudgetDto = new SubComMonthBudgetDto();
        subComMonthBudgetDto.setBusinessFormatCode(detailPlanItemVo.getBusinessFormatCode());
        subComMonthBudgetDto.setBusinessUnitCode(detailPlanItemVo.getBusinessUnitCode());
        subComMonthBudgetDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        subComMonthBudgetDto.setBudgetItemCode(AUTO_AMOUNT_BUDGET_ITEM_CODE);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        subComMonthBudgetDto.setYearMonthLy(df.format(detailPlanItemVo.getFeeYearMonth()));
        subComMonthBudgetDto.setSalesInstitutionCode(detailPlanItemVo.getSalesInstitutionCode());
        subComMonthBudgetDto.setSalesRegionCode(detailPlanItemVo.getSalesOrgCode());
        subComMonthBudgetDto.setSalesOrgCode(detailPlanItemVo.getSalesGroupCode());
        subComMonthBudgetDto.setOrgCode(detailPlanItemVo.getOrgCode());
        subComMonthBudgetDto.setChannelCode(detailPlanItemVo.getChannelCode());
        subComMonthBudgetDto.setCustomerCode(detailPlanItemVo.getCustomerCode());
        subComMonthBudgetDto.setTerminalCode(detailPlanItemVo.getTerminalCode());
        subComMonthBudgetDto.setProductBrandCode(detailPlanItemVo.getProductBrandCode());
        subComMonthBudgetDto.setProductCategoryCode(detailPlanItemVo.getProductCategoryCode());
        subComMonthBudgetDto.setProductItemCode(detailPlanItemVo.getProductItemCode());
        subComMonthBudgetDto.setProductCode(detailPlanItemVo.getProductCode());
        List<SubComMonthBudgetVo> subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
        if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
            //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组+客户+门店+品牌+品类+品项
            subComMonthBudgetDto.setProductCode(null);
            subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
            if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组+客户+门店+品牌+品类
                subComMonthBudgetDto.setProductItemCode(null);
                subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                    //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组+客户+门店+品牌
                    subComMonthBudgetDto.setProductCategoryCode(null);
                    subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                    if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                        //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组+客户+门店
                        subComMonthBudgetDto.setProductBrandCode(null);
                        subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                        if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                            //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组+客户
                            subComMonthBudgetDto.setTerminalCode(null);
                            subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                            if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                                //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门+销售组
                                subComMonthBudgetDto.setCustomerCode(null);
                                subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                                if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                                    //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道+销售部门
                                    subComMonthBudgetDto.setChannelCode(null);
                                    subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                                    if (CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                                        //业态+业务单元+费用归口+预算项目+年月+销售机构+组织编码+渠道
                                        subComMonthBudgetDto.setOrgCode(null);
                                        subComMonthBudgetVos = subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return subComMonthBudgetVos;
    }

    private List<OperateMonthBudgetDto> buildBudgetItem(List<AuditBudgetItemVo> budgetItems, AuditBudgetVo auditBudgetVo) {

        List<OperateMonthBudgetDto> operateMonthBudgetDtoList = new LinkedList<>();

        //如果预估超额值
        Map<String, List<MonthBudgetDetailVo>> monthBudgetDetailVoMap = new HashMap<>();
        if (Objects.nonNull(auditBudgetVo.getOverBudgetAmount()) && auditBudgetVo.getOverBudgetAmount().compareTo(BigDecimal.ZERO) != 0) {
            List<MonthBudgetDetailVo> monthBudgetDetailVoList = this.monthBudgetDetailService.findListByDetailPlanItemCodes(auditBudgetVo.getDetailPlanItemCodes());
            if (!CollectionUtils.isEmpty(monthBudgetDetailVoList)) {
                monthBudgetDetailVoMap = monthBudgetDetailVoList.stream().collect(Collectors.groupingBy(MonthBudgetDetailVo::getMonthBudgetCode));
            }

        }

        if (AuditUseBudgetTypeEnum.USE.equals(auditBudgetVo.getType())) {
            //查询出预算余额
            List<String> monthBudgetCodes = budgetItems.stream().map(AuditBudgetItemVo::getMonthBudgetCode).collect(Collectors.toList());
            List<MonthBudgetVo> monthBudgetVos = this.listByCodes(monthBudgetCodes);

            Map<String, MonthBudgetVo> monthBudgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            //公投
            List<AuditBudgetItemVo> regionReferendumBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_REFERENDUM.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            List<AuditBudgetItemVo> useBudget = new LinkedList<>(regionReferendumBudget);
            //总部
            List<AuditBudgetItemVo> headBudget = budgetItems.stream().filter(o -> FeeBelongEnum.HEAD.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            useBudget.addAll(headBudget);
            //2.占用自投
            List<AuditBudgetItemVo> regionAutomaticBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(regionAutomaticBudget)) {
                regionAutomaticBudget = regionAutomaticBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).reversed().thenComparing(AuditBudgetItemVo::getMonthBudgetCode)).collect(Collectors.toList());
                useBudget.addAll(regionAutomaticBudget);
            } else {
                //寻找预算
                ActivityDetailPlanItemVo2 planItemVo = auditBudgetVo.getPlanItemVo();
                MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
                monthBudgetDto.setRegionCode(planItemVo.getRegion());
                SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
                monthBudgetDto.setYearMonthLy(yearMonthFormat.format(planItemVo.getFeeYearMonth()));
                monthBudgetDto.setSystemCode(planItemVo.getSystemCode());
                //预算项目为“产品促销"
                monthBudgetDto.setBudgetItemCode("C0023");
                List<MonthBudgetVo> monthBudgetVoList = this.findListByConditions(monthBudgetDto);
                Validate.isTrue(!CollectionUtils.isEmpty(monthBudgetVoList), "未找到预算项目为产品促销-垂直的月度预算");
                useBudget.add(this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetVoList.get(0), AuditBudgetItemVo.class, null, null));
            }
            int regionAutomaticCount = (int) useBudget.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).count();
            int count = 0;
            BigDecimal useAmount = auditBudgetVo.getAmount();
            for (AuditBudgetItemVo auditBudgetItemVo : useBudget) {
                MonthBudgetVo monthBudgetVo = monthBudgetVoMap.get(auditBudgetItemVo.getMonthBudgetCode());
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                //预算上的结案金额 = 活动本次使用金额 + 占用预算的金额
                BigDecimal itemUseAmount = Optional.ofNullable(auditBudgetItemVo.getUseAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(auditBudgetItemVo.getRollbackAmount()).orElse(BigDecimal.ZERO));
                List<MonthBudgetDetailVo> monthBudgetDetailVos = monthBudgetDetailVoMap.get(auditBudgetItemVo.getMonthBudgetCode());
                if (!CollectionUtils.isEmpty(monthBudgetDetailVos)) {
                    itemUseAmount = itemUseAmount.add(monthBudgetDetailVos.stream().map(MonthBudgetDetailVo::getCurOperationAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                }

                if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(auditBudgetItemVo.getFeeBelongCode())) {
                    count++;
                    if (useAmount.compareTo(BigDecimal.ZERO) != 0) {
                        if (count == regionAutomaticCount) {
                            operateMonthBudgetDto.setOperationAmount(useAmount);
                            itemUseAmount = itemUseAmount.add(useAmount);
                            useAmount = BigDecimal.ZERO;
                        } else if (useAmount.compareTo(monthBudgetVo.getAccumulatedAvailableBalance()) <= 0) {
                            operateMonthBudgetDto.setOperationAmount(useAmount);
                            itemUseAmount = itemUseAmount.add(useAmount);
                            useAmount = BigDecimal.ZERO;
                        } else {
                            operateMonthBudgetDto.setOperationAmount(monthBudgetVo.getAccumulatedAvailableBalance());
                            itemUseAmount = itemUseAmount.add(monthBudgetVo.getAccumulatedAvailableBalance());
                            useAmount = useAmount.subtract(monthBudgetVo.getAccumulatedAvailableBalance());
                        }
                    }
                }
                operateMonthBudgetDto.setAlreadyEndCaseAmount(itemUseAmount);
                operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(auditBudgetVo.getPlanReturnBudgetYearAndMonth());
                operateMonthBudgetDtoList.add(operateMonthBudgetDto);
            }

        } else {
            //1.先退自投
            List<AuditBudgetItemVo> regionAutomaticBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            regionAutomaticBudget = regionAutomaticBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).thenComparing(AuditBudgetItemVo::getMonthBudgetCode).reversed()).collect(Collectors.toList());
            List<AuditBudgetItemVo> returnBudget = new LinkedList<>(regionAutomaticBudget);
            //2.在退公投
            List<AuditBudgetItemVo> regionReferendumBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_REFERENDUM.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            regionReferendumBudget = regionReferendumBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).thenComparing(AuditBudgetItemVo::getMonthBudgetCode).reversed()).collect(Collectors.toList());
            returnBudget.addAll(regionReferendumBudget);
            //3.在退总部
            List<AuditBudgetItemVo> headBudget = budgetItems.stream().filter(o -> FeeBelongEnum.HEAD.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            headBudget = headBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).thenComparing(AuditBudgetItemVo::getMonthBudgetCode).reversed()).collect(Collectors.toList());
            returnBudget.addAll(headBudget);
            BigDecimal returnAmount = auditBudgetVo.getAmount();
            BigDecimal alreadyEndCaseAmount = auditBudgetVo.getAlreadyEndCaseAmount();

            for (AuditBudgetItemVo auditBudgetItemVo : returnBudget) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                if (AuditUseBudgetTypeEnum.RETURN.equals(auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                } else if (AuditUseBudgetTypeEnum.USE_RETURN.equals(auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
                }
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(auditBudgetVo.getPlanReturnBudgetYearAndMonth());
                BigDecimal useAmount = Optional.ofNullable(auditBudgetItemVo.getUseAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(auditBudgetItemVo.getRollbackAmount()).orElse(BigDecimal.ZERO));

                List<MonthBudgetDetailVo> monthBudgetDetailVos = monthBudgetDetailVoMap.get(auditBudgetItemVo.getMonthBudgetCode());
                if (!CollectionUtils.isEmpty(monthBudgetDetailVos)) {
                    useAmount = useAmount.add(monthBudgetDetailVos.stream().map(MonthBudgetDetailVo::getCurOperationAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                }

                //退的金额和使用金额的差额
                BigDecimal useMinusReturnAmount = BigDecimal.ZERO;
                if (returnAmount.compareTo(BigDecimal.ZERO) != 0) {
                    if (returnAmount.compareTo(useAmount) <= 0) {
                        operateMonthBudgetDto.setOperationAmount(returnAmount);
                        useMinusReturnAmount = useAmount.subtract(returnAmount);
                        returnAmount = BigDecimal.ZERO;
                    } else {
                        operateMonthBudgetDto.setOperationAmount(useAmount);
                        returnAmount = returnAmount.subtract(useAmount);
                    }
                }
                if (returnAmount.compareTo(BigDecimal.ZERO) == 0) {
                    if (useMinusReturnAmount.compareTo(BigDecimal.ZERO) > 0) {
                        operateMonthBudgetDto.setAlreadyEndCaseAmount(useMinusReturnAmount);
                        alreadyEndCaseAmount = alreadyEndCaseAmount.subtract(useMinusReturnAmount);
                    } else {
                        if (alreadyEndCaseAmount.compareTo(useAmount) <= 0) {
                            operateMonthBudgetDto.setAlreadyEndCaseAmount(alreadyEndCaseAmount);
                            operateMonthBudgetDtoList.add(operateMonthBudgetDto);
                            break;
                        } else {
                            operateMonthBudgetDto.setAlreadyEndCaseAmount(useAmount);
                            alreadyEndCaseAmount = alreadyEndCaseAmount.subtract(useAmount);
                        }
                    }
                }
                operateMonthBudgetDtoList.add(operateMonthBudgetDto);
            }

        }
        return operateMonthBudgetDtoList;
    }

    private Map<String, DimensionControlsVo> mapDimensionControl(List<String> monthBudgetCodeList) {
        if (CollectionUtils.isEmpty(monthBudgetCodeList)) {
            return new HashMap<>();
        }
        List<MonthBudgetEntity> monthBudgetList = this.monthBudgetRepository.getByMonthBudgetCodes(monthBudgetCodeList, EnableStatusEnum.ENABLE.getCode());
        return mapDimensionControlByBudgetList(monthBudgetList);
    }

    private Map<String, DimensionControlsVo> mapDimensionControlByBudgetList(List<MonthBudgetEntity> monthBudgetList) {
        if (CollectionUtils.isEmpty(monthBudgetList)) {
            return new HashMap<>();
        }
        HashMap<String, DimensionControlsVo> returnMap = Maps.newHashMap();
        // 批量查询维度管控数据
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<DimensionControlsVo> dimensionControlsVos = dimensionControlsService.listByConditions(dimensionControlsDto);
        monthBudgetList.forEach(monthBudgetEntity -> {
            List<DimensionControlsVo> collect = dimensionControlsVos.stream().filter(vo -> monthBudgetEntity.getBusinessUnitCode().equals(vo.getBusinessUnitCode())).collect(Collectors.toList());
            // 按维度去查询预算的管控
            DimensionControlsVo sameItemControlsVo = null;
            DimensionControlsVo dimensionControlsVo = null;
            // 主体、垂直先按当前层级预算项目去匹配管控，没匹配到再去查上级预算项目对应管控维度
            if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())
                    || BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetEntity.getBusinessUnitCode())
                    || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
                sameItemControlsVo = this.findSameItemControlConfig(monthBudgetEntity, collect);
            }
            if (ObjectUtils.isEmpty(sameItemControlsVo)) {
                dimensionControlsVo = this.findControlConfig(monthBudgetEntity, collect);
            } else {
                dimensionControlsVo = sameItemControlsVo;
            }
            returnMap.put(monthBudgetEntity.getMonthBudgetCode(), dimensionControlsVo);
        });
        return returnMap;
    }

    /**
     * 计算实销量与回复量差额
     *
     *
     * @param actualSalesVo
     * @param currMonthBudget
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void calculateActualReplyDiff(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget) {
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(actualSalesVo.getBusinessUnitCode());
        //小业务单元的走主体的逻辑
        if (BusinessUnitEnum.isDefaultBusinessUnit(actualSalesVo.getBusinessUnitCode())) {
            businessUnitEnum = BusinessUnitEnum.HEADQUARTERS;
        }
        BusinessUnitEnum finalBusinessUnitEnum = businessUnitEnum;
        this.budgetCalculateStrategies.forEach(strategy -> {
            if (finalBusinessUnitEnum.getCode().equals(strategy.getBusinessUnit())) {
                //计算数据
                strategy.calculation(actualSalesVo, currMonthBudget);
            }
        });
    }

    /**
     * 删除
     *
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, "选择的数据ids集合不能为空");
        //查询明细
        List<MonthBudgetDetailVo> detailVos = this.monthBudgetDetailRepository.findByMainIds(ids);
        if (!CollectionUtils.isEmpty(detailVos)) {
            throw new IllegalArgumentException("[" + detailVos.get(0).getMonthBudgetCode() + "]月度预算，存在操作类型不为‘期初’的其他使用明细，不满足删除条件");
        }
        this.monthBudgetRepository.deleteBatch(ids);
    }

    /**
     * 计算对应年月的
     *
     * @param yearMonth
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void calHeadYearTotalAvailableBalanceSyncXxlJob(String yearMonth) {
        if (StringUtils.isBlank(yearMonth)) {
            return;
        }
        //获取当前月份
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.strToDate(yearMonth, DateUtil.date_yyyy_MM));
        int month = calendar.get(Calendar.MONTH);
        //分页查询当前年月的月度预算(主体的)
        List<String> businessUnitCodeList = new ArrayList<>();
        businessUnitCodeList.add(BusinessUnitEnum.HEADQUARTERS.getCode());
        List<MonthBudgetEntity> entities = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        //循环月度预算
        List<MonthBudgetEntity> updateList = new ArrayList<>();
        for (MonthBudgetEntity entity : entities) {
            //查询同一个年度预算下的所有月度预算并按照年月排序
            List<MonthBudgetEntity> list = this.monthBudgetRepository.listByYearBudgetCode(entity.getYearBudgetCode());
            if (CollectionUtils.isEmpty(list) || list.size() < 12) {
                log.error("通过年度预算编码未获取12月的月度预算，年度预算编码={}", entity.getYearBudgetCode());
                continue;
            }
            list = list.stream().sorted(Comparator.comparing(MonthBudgetEntity::getYearMonthLy)).collect(Collectors.toList());
            //获取预算管控条件
            List<BudgetItemControlConditionVo> conditionVos = budgetItemControlConditionVoService.findByCode(entity.getBudgetItemCode());
            if (CollectionUtils.isEmpty(conditionVos)) {
                log.error("通过预算项目编码未查找到预算管控条件，预算项目编码={}", entity.getBudgetItemCode());
                continue;
            }

            MonthBudgetEntity newEn = new MonthBudgetEntity();
            newEn.setId(entity.getId());


            BigDecimal totalBalance = BigDecimal.ZERO;
            //区分按额和（按率或按力度）
            String controlTypeCode = conditionVos.get(0).getControlTypeCode();
            if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlTypeCode)) {
                //1月至当前月份的年初分解金额-1月至当前月份的结案或批复金额+（未来剩余月份所有的【年初分解金额之和】-未来剩余月份所有的【批复金额之和】
                BigDecimal yearTotalBalance = BigDecimal.ZERO;
                for (int i = 0; i < list.size(); i++) {
                    MonthBudgetEntity e = list.get(i);
                    if (i <= month) {
                        yearTotalBalance = yearTotalBalance.add(Optional.ofNullable(e.getInitResolveAmount()).orElse(BigDecimal.ZERO))
                                .subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                    } else {
                        yearTotalBalance = yearTotalBalance.add(Optional.ofNullable(e.getInitResolveAmount()).orElse(BigDecimal.ZERO))
                                .subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                    }
                }
                newEn.setYearTotalAvailableAmount(yearTotalBalance);
                totalBalance = yearTotalBalance;
            } else if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode) || BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
                //1月至当前月份的（实际销售量或计划回复量*预算点数/预算力度(=月度分解金额)）-（1月至当前月份的批复金额）+（未来剩余月份所有的【年初分解金额之和】-未来剩余月份所有的【批复金额之和】）
                BigDecimal yearTotalBalance = BigDecimal.ZERO;
                for (int i = 0; i < list.size(); i++) {
                    MonthBudgetEntity e = list.get(i);
                    if (i <= month) {
                        if (null != e.getActualSales() && BigDecimal.ZERO.compareTo(e.getActualSales()) != 0) {
                            yearTotalBalance = yearTotalBalance.add(e.getActualSales());
                        } else {
                            yearTotalBalance = yearTotalBalance.add(Optional.ofNullable(e.getFirstReplyAmount()).orElse(BigDecimal.ZERO));
                        }
                        yearTotalBalance = yearTotalBalance.subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                    } else {
                        yearTotalBalance = yearTotalBalance.add(Optional.ofNullable(e.getInitResolveAmount()).orElse(BigDecimal.ZERO))
                                .subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                    }
                }
                newEn.setYearTotalAvailableAmount(yearTotalBalance);
                totalBalance = yearTotalBalance;
            }
            log.error("月度预算编码={}，年度累计可用余额={}", entity.getMonthBudgetCode(), newEn.getYearTotalAvailableAmount());
            updateList.add(newEn);
            //未来年月也需要显示这个金额
            for (int i = 0; i < list.size(); i++) {
                if (i >= month) {
                    MonthBudgetEntity e = list.get(i);
                    MonthBudgetEntity en = new MonthBudgetEntity();
                    en.setId(e.getId());
                    en.setYearTotalAvailableAmount(totalBalance);
                    updateList.add(en);
                }
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.monthBudgetRepository.updateBatchById(updateList);
        }
    }

    @Override
    public List<MonthBudgetDetailVo> findDetailByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return Lists.newArrayList();
        }
        return monthBudgetDetailRepository.findByBusinessCodes(businessCodes);
    }

    @Override
    public String auditUseRetrunOperateBudget(List<String> auditDetailCodes, String auditCode) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return null;
        }

        List<MonthBudgetDetailVo> monthBudgetDetailVos = monthBudgetDetailService.findListByBusiness(auditDetailCodes, auditCode);
        if (CollectionUtils.isEmpty(monthBudgetDetailVos)) {
            return null;
        }
        log.info("结案核销审批通过,驳回退预算-1:{},monthBudgetDetailVos:{}",auditCode,JsonUtils.obj2JsonString(monthBudgetDetailVos));
        List<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<>();
        for (MonthBudgetDetailVo monthBudgetDetailVo : monthBudgetDetailVos) {
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
            operateMonthBudgetDto.setMonthBudgetCode(monthBudgetDetailVo.getMonthBudgetCode());
            operateMonthBudgetDto.setOperationAmount(monthBudgetDetailVo.getCurOperationAmount());
            operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
            operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
            operateMonthBudgetDto.setBusinessCode(monthBudgetDetailVo.getBusinessCode());
            operateMonthBudgetDto.setBusinessUnitCode(monthBudgetDetailVo.getMonthBudgetCode());
            operateMonthBudgetDto.setAlreadyEndCaseAmount(monthBudgetDetailVo.getAlreadyEndCaseAmount());
            operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(monthBudgetDetailVo.getPlanReturnBudgetYearAndMonth());
            operateMonthBudgetDto.setChangeAuditAmount(monthBudgetDetailVo.getChangeAuditAmount());
            operateMonthBudgetDto.setChangeApprovedAuditDiff(monthBudgetDetailVo.getChangeApprovedAuditDiff());
            operateMonthBudgetDto.setChangeAdjustAmount(monthBudgetDetailVo.getChangeAdjustAmount());
            operateMonthBudgetDto.setChangeAccumulatedAvailableBalance(monthBudgetDetailVo.getChangeAccumulatedAvailableBalance());
            operateMonthBudgetDto.setChangeAfterFreezeAmount(monthBudgetDetailVo.getChangeAfterFreezeAmount());

            operateMonthBudgetDtos.add(operateMonthBudgetDto);
        }
        //加锁
        boolean lock = true;
        List<String> lockKeys = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
        try {
            lock = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME);
            if (lock) {
                operateBudget(operateMonthBudgetDtos);
                //更改核销操作日志，防止第二次驳回的时候把第一次驳回的数据查询出来
                monthBudgetDetailService.updateStatusByBusiness(monthBudgetDetailVos);
            }
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(lockKeys);
            }
        }
        return monthBudgetDetailVos.get(0).getBusinessCode();

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<String> saveBatchForOut(List<MonthBudgetDto> monthBudgetDtoList) {
        if (CollectionUtils.isEmpty(monthBudgetDtoList)) {
            return null;
        }
        // 一个年度预算对应只会生成12条月度预算，每次生成之前，先将对应月度预算删除
        Set<String> yearBudgetCodeList = monthBudgetDtoList.stream().map(MonthBudgetDto::getYearBudgetCode).collect(Collectors.toSet());
        this.delByYearBudgetCode(Lists.newArrayList(yearBudgetCodeList));
        // 保存新的月度预算
        List<MonthBudgetEntity> monthBudgetEntities = new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetDtoList, MonthBudgetDto.class, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class)
        );
        monthBudgetEntities.forEach(entity->{
            entity.setYearMonthDate(DateUtil.parseDate(entity.getYearMonthLy(),DateUtil.DEFAULT_YEAR_MONTH));
        });
        this.monthBudgetRepository.saveBatch(monthBudgetEntities);
        // 月度预算生成期初操作明细
        this.buildInitDetail(monthBudgetEntities);
        // 业务日志新增
        monthBudgetDtoList.forEach(dto -> {
            MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<MonthBudgetLogEventListener, MonthBudgetLogEventDto> onCreate =
                    MonthBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, MonthBudgetLogEventListener.class, onCreate);
        });
        return monthBudgetEntities.stream().map(MonthBudgetEntity::getId).collect(Collectors.toList());
    }

    /**
     * 根据月度预算编码集合查询月度预算
     *
     * @param monthBudgetCodes 月度预算编码集合
     * @return List<MonthBudgetVo>
     */
    @Override
    public List<MonthBudgetVo> findBudgetByMonthBudgetCodes(List<String> monthBudgetCodes) {
        if (CollectionUtils.isEmpty(monthBudgetCodes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> list = this.monthBudgetRepository.listByCodes(monthBudgetCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<MonthBudgetVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, MonthBudgetEntity.class, MonthBudgetVo.class,
                HashSet.class, ArrayList.class);
    }

    /**
     * 更新月度预算并执行滚动
     *
     * @param dtoList 月度预算集合
     */
    @Override
    public void updateAndRoll(List<MonthBudgetDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> ids = dtoList.stream().map(MonthBudgetDto::getId).collect(Collectors.toList());
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        List<String> monthBudgetCodeList = monthBudgetEntityList.stream()
                .filter(k -> StringUtil.isNotEmpty(k.getMonthBudgetCode()))
                .map(MonthBudgetEntity::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 10);
        Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
        try {
            //区分费用归口，总部 不加销售机构 大区才加
            //查询预算管控配置 key: 业态+业务单元+销售机构
            Map<String, List<DimensionControlsVo>> dimensionControlMap = this.monthBudgetHelper.findDimensionControl();
            //查询预算管控配置 key: 业态+业务单元
            Map<String, List<DimensionControlsVo>> dimensionControlMap2 = this.monthBudgetHelper.findDimensionControlNoSalesOrg();

            Map<String, MonthBudgetDto> dtoMap = dtoList.stream()
                    .collect(Collectors.toMap(MonthBudgetDto::getMonthBudgetCode,
                            Function.identity(), (n, o) -> n));
            monthBudgetEntityList.stream().sorted(Comparator.comparing(MonthBudgetEntity::getYearMonthLy))
                    .forEach(entity -> {
                        //更新月度预算数据
                        MonthBudgetDto budgetDto = dtoMap.get(entity.getMonthBudgetCode());
                        if (!Objects.isNull(budgetDto.getCalAmount())) {
                            entity.setCalAmount(budgetDto.getCalAmount());
                        }
                        if (!Objects.isNull(budgetDto.getFirstReplyAmount())) {
                            entity.setFirstReplyAmount(budgetDto.getFirstReplyAmount());
                        }
                        if (!Objects.isNull(budgetDto.getFirstReplyResolveDiffAmount())) {
                            entity.setFirstReplyResolveDiffAmount(budgetDto.getFirstReplyResolveDiffAmount());
                        }
                        if (!Objects.isNull(budgetDto.getLastMonthRollingAmount())) {
                            entity.setLastMonthRollingAmount(budgetDto.getLastMonthRollingAmount());
                        }
                        if (!Objects.isNull(budgetDto.getActualSales())) {
                            entity.setActualSales(budgetDto.getActualSales());
                        }
                        //管控纬度key
                        List<DimensionControlsVo> dimensionControlsVos = null;
                        if (FeeBelongEnum.HEAD.getCode().equals(entity.getFeeBelongCode())) {
                            String dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode();
                            dimensionControlsVos = dimensionControlMap2.get(dimensionControlKey);
                        } else {
                            String dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getSalesOrgCode();
                            dimensionControlsVos = dimensionControlMap.get(dimensionControlKey);
                        }
                        boolean rollTag = false;
                        String rollingType = null;
                        //未查找到管控配置，直接更新月度预算
                        if (!CollectionUtils.isEmpty(dimensionControlsVos)) {
                            DimensionControlsVo dimensionControlsVo = this.monthBudgetHelper.matchDimensionControl(dimensionControlsVos, entity.getBudgetItemCode());
                            //判断是否滚动
                            if (null != dimensionControlsVo
                                    && StringUtils.isNotBlank(dimensionControlsVo.getIfRolling())
                                    && BooleanEnum.TRUE.getCapital().equals(dimensionControlsVo.getIfRolling())) {
                                rollTag = true;
                                rollingType = dimensionControlsVo.getRollingType();
                                //如果为一月直接跳过
                                String yearMonthLy = entity.getYearMonthLy();
                                String[] yearMonthArray = yearMonthLy.split("-");
                                LocalDate currMonthBudgetLocalDate = LocalDate.of(Integer.parseInt(yearMonthArray[0]), Integer.parseInt(yearMonthArray[1]), 1);
                                int monthValue = currMonthBudgetLocalDate.getMonthValue();
                                if (monthValue != 1) {
                                    //查询上月月度预算
                                    LocalDate lastLocalDate = currMonthBudgetLocalDate.minusMonths(1);
                                    String lastYearMonth = lastLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
                                    MonthBudgetEntity lastMonthBudget = this.monthBudgetRepository
                                            .findByYearMonthAndYearBudgetCode(lastYearMonth, entity.getYearBudgetCode());
                                    if (null != lastMonthBudget && null != lastMonthBudget.getAccumulatedAvailableBalance()
                                            && BigDecimal.ZERO.compareTo(lastMonthBudget.getAccumulatedAvailableBalance()) != 0) {
                                        BigDecimal lastBalance = lastMonthBudget.getAccumulatedAvailableBalance();
                                        lastMonthBudget.setMonthRollingAmount(lastBalance);
                                        //冻结后可用金额=年初分解金额+月度分解金额与年初分解金额的差异+上月滚动金额+调整金额-冻结金额
                                        lastMonthBudget.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                                                .buildAfterFreezeAmountHeadquartersAndOnline(lastMonthBudget, BusinessUnitEnum.HEADQUARTERS));
                                        //累计可用余额=冻结后可用金额-批复金额-预估超额-本月滚动金额
                                        lastMonthBudget.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                                                .buildAccumulatedAvailableBalanceHeadquartersAndOnline(lastMonthBudget, BusinessUnitEnum.HEADQUARTERS));
                                        //调整明细
                                        MonthBudgetDetailEntity detailEntity = this.monthBudgetHelper.buildDetail(lastMonthBudget,
                                                lastBalance, lastBalance,
                                                BudgetOperationTypeEnum.ROLLING.getCode(), null);
                                        this.monthBudgetDetailRepository.save(detailEntity);
                                        this.monthBudgetRepository.updateById(lastMonthBudget);
                                    }
                                }
                            }
                        }
                        //更新本月的月度预算
                        this.updateMonthBudget(entity);
                        //开始计算实销回复差
                        if (!Objects.isNull(entity.getFirstReplyAmount()) && !Objects.isNull(entity.getActualSales())) {
                            //实销回复差
                            BigDecimal diffAmount = entity.getActualSales().subtract(entity.getFirstReplyAmount()).setScale(6, BigDecimal.ROUND_HALF_UP);
                            entity.setActualReplyDiff(diffAmount);
                            if (BigDecimal.ZERO.compareTo(diffAmount) == 0) {
                                this.monthBudgetRepository.updateById(entity);
                                return;
                            }
                            Date date = DateUtil.strToDate(entity.getYearMonthLy(), DateUtil.date_yyyy_MM);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(date);
                            Date currDate = DateUtil.getDate(DateUtil.date_yyyy_MM);
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.setTime(currDate);
                            String curryearMonth = DateUtil.dateToStr(DateUtil.date_yyyy_MM);
                            //必须属于同一年
                            if (calendar.get(Calendar.YEAR) != calendar2.get(Calendar.YEAR)) {
                                log.error("计算实销回复差-》必须属于同一年");
                                return;
                            }
                            boolean roll = false;
                            if (rollTag && StringUtils.isNotBlank(rollingType)) {
                                // a-全部滚动：不判断正负数；
                                if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType)) {
                                    roll = true;
                                }
                                // b-结余滚动：为正数；
                                if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType)) {
                                    if (BigDecimal.ZERO.compareTo(diffAmount) < 0) {
                                        roll = true;
                                    }
                                }
                                // c-超支滚动：为负数；
                                if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType)) {
                                    if (BigDecimal.ZERO.compareTo(diffAmount) > 0) {
                                        roll = true;
                                    }
                                }
                            }

                            DateUtil.getCurrentMonth();
                            //判断是否滚动，月份12不滚动
                            if (roll) {
                                //当前年月必须大于选择的预算年月
                                if (currDate.getTime() <= date.getTime()) {
                                    log.error("计算实销回复差-》当前年月必须大于选择的预算年月");
                                    return;
                                }
                                //对应预算管控配置下“是否滚动”字段维护的“是”，则“实销回复差”展示在计算年月（当前年月）预算的调整金额下；
                                //获取当前年月的月度预算
                                MonthBudgetEntity currEntity = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(entity.getYearBudgetCode(), curryearMonth);
                                this.monthBudgetRepository.updateById(entity);

                                String businessCode = currEntity.getMonthBudgetCode() + DateUtil.getDate("yyyyMM");
                                MonthBudgetDetailVo monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode);
                                if (Objects.isNull(monthBudgetDetailVo)) {
                                    BigDecimal beforeAmount = currEntity.getAccumulatedAvailableBalance();
                                    //第一次计算
                                    currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                                    //冻结可用
                                    currEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                    //累计可用
                                    currEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                    //调整明细
                                    MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(currEntity,
                                            diffAmount,
                                            BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                                    this.monthBudgetDetailRepository.save(detailEntity);
                                    this.monthBudgetRepository.updateById(currEntity);
                                } else {
                                    //非第一次计算
                                    BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
                                    if (histOperationAmount.compareTo(diffAmount) != 0) {
                                        BigDecimal beforeAmount = currEntity.getAccumulatedAvailableBalance();
                                        //先将金额还回去
                                        //金额计算变动
                                        currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(histOperationAmount));
                                        //冻结可用
                                        currEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                        //累计可用
                                        currEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                        //调整明细
                                        MonthBudgetDetailEntity histDetailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(currEntity,
                                                histOperationAmount,
                                                BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                                        this.monthBudgetDetailRepository.save(histDetailEntity);

                                        BigDecimal beforeAmount2 = currEntity.getAccumulatedAvailableBalance();
                                        //用新的差额计算
                                        currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                                        //冻结可用
                                        currEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                        //累计可用
                                        currEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                        //明细
                                        MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(currEntity,
                                                diffAmount,
                                                BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount2);
                                        this.monthBudgetDetailRepository.save(detailEntity);
                                        this.monthBudgetRepository.updateById(currEntity);
                                    }
                                }
                            } else {
                                //对应预算管控配置下“是否滚动”字段维护的“否”，则“实销回复差”展示在对应实销量年月预算的调整金额下；
                                //判断是否为第一次计算
                                String businessCode = entity.getMonthBudgetCode() + DateUtil.getDate("yyyyMM");
                                MonthBudgetDetailVo monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode);
                                if (Objects.isNull(monthBudgetDetailVo)) {
                                    BigDecimal beforeAmount = entity.getAccumulatedAvailableBalance();
                                    //第一次计算
                                    entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                                    //冻结可用
                                    entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                                    //累计可用
                                    entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                                    //调整明细
                                    MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(entity,
                                            diffAmount,
                                            BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                                    this.monthBudgetDetailRepository.save(detailEntity);
                                    this.monthBudgetRepository.updateById(entity);
                                } else {
                                    //非第一次计算
                                    BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
                                    if (histOperationAmount.compareTo(diffAmount) != 0) {
                                        BigDecimal beforeAmount = entity.getAccumulatedAvailableBalance();
                                        //先将金额还回去
                                        //金额计算变动
                                        entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(histOperationAmount));
                                        //冻结可用
                                        entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                                        //累计可用
                                        entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                                        //调整明细
                                        MonthBudgetDetailEntity histDetailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(entity,
                                                histOperationAmount,
                                                BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                                        this.monthBudgetDetailRepository.save(histDetailEntity);

                                        BigDecimal beforeAmount2 = entity.getAccumulatedAvailableBalance();
                                        //用新的差额计算
                                        entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                                        //冻结可用
                                        entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                                        //累计可用
                                        entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                                        //明细
                                        MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(entity,
                                                diffAmount,
                                                BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount2);
                                        this.monthBudgetDetailRepository.save(detailEntity);
                                        this.monthBudgetRepository.updateById(entity);
                                    }
                                }
                            }

                        }
                    });
        } catch (Exception e) {
            log.error("", e);
            throw e;
        } finally {
            monthBudgetLockService.unLock(monthBudgetCodeList);
        }


    }

    @Override
    public Page<MonthBudgetVo> auditAdjustFindBudget(Pageable pageable, String customerCode) {

        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        MonthBudgetDto dto = new MonthBudgetDto();
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isNotEmpty(customerCode)) {
            CustomerVo customerVo = customerVoService.findDetailsByIdOrCode(null, customerCode);
            if (RtmModelCodeEnum.SON_COMPANY.getCode().equals(customerVo.getRtmModelCode())) {
                dto.setGroupCode(MonthBudgetGroupEnum.customer.getCode());
            } else {
                dto.setGroupCode(MonthBudgetGroupEnum.organization.getCode());
            }
        }
        Page<MonthBudgetVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.monthBudgetRepository.findByConditions(page, dto);
    }

    @Override
    public List<MonthBudgetVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.getByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull(monthBudgetEntityList, "数据不存在，请刷新后重试！");
        return (List<MonthBudgetVo>) nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public MonthBudgetVo getOneByYearBudgetCodeAndMonth(String yearBudgetCode, String feeYearMonth) {
        if(StringUtils.isEmpty(yearBudgetCode)){
            return null;
        }
        if(StringUtils.isEmpty(feeYearMonth)){
            return null;
        }
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(yearBudgetCode, feeYearMonth);
        MonthBudgetVo monthBudgetVo = this.nebulaToolkitService.copyObjectByBlankList(monthBudgetEntity, MonthBudgetVo.class, null, null);
        return monthBudgetVo;
    }


    /**
     * 月度预算更新
     *
     * @param entity 月度预算
     */
    public void updateMonthBudget(MonthBudgetEntity entity) {
        BigDecimal balance = entity.getAccumulatedAvailableBalance();
        //冻结后可用金额=年初分解金额+月度分解金额与年初分解金额的差异+上月滚动金额+调整金额-冻结金额
        entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper
                .buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.HEADQUARTERS));
        //累计可用余额=冻结后可用金额-批复金额-预估超额-本月滚动金额
        entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper
                .buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.HEADQUARTERS));
        //调整明细
        MonthBudgetDetailDto detailDto = this.buildDetail(entity,
                balance,balance,
                BudgetOperationTypeEnum.IMPORT.getCode(), null);
        monthBudgetDetailService.create(detailDto);
        this.monthBudgetRepository.updateById(entity);
    }

    @Override
    public Page<MonthBudgetVo> findPageForOut(Pageable pageable, MonthBudgetDto dto) {
        return monthBudgetRepository.findPageForOut(pageable, dto);
    }


    /**
     * 垂直区域费用预警-给帆软跑
     * @param yearMonths
     */
    @Override
    @Transactional
    public void verticalAreaFeeWarning(List<String> yearMonths) {
        this.loginUserService.refreshAuthentication(null);
        //先删除吧
        this.verticalAreaFeeWarningRepository.lambdaUpdate().in(VerticalAreaFeeWarningEntity::getYearMonthLy,yearMonths).remove();
        //200条执行一次
        int pageSize = 200;
        int current = 1;
        int count = 1;

        Page<VerticalAreaFeeWarningEntity> result;
        do{
            Pageable pageable = PageRequest.of(current,pageSize);
            result = this.verticalAreaFeeWarningRepository.verticalAreaFeeWarning(pageable,yearMonths);
            if(Objects.isNull(result) || CollectionUtils.isEmpty(result.getRecords())) break;
            current++;

            //销售任务：统计“年月+区域+系统”维度内控版的销售任务折后金额
            List<SalesGoalDto> salesGoalDtos = result.getRecords().stream().map(e -> new SalesGoalDto(){{
               this.setYearMonthLy(e.getYearMonthLy());
               this.setRegionCode(e.getRegionCode());
               this.setSystemCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<SalesGoalVo> salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
            Map<String,SalesGoalVo> salesGoalVoMap = salesGoalVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(),e.getRegionCode(),e.getSystemCode()),Function.identity()));

            result.getRecords().forEach(e -> {
                e.setTenantCode(TenantUtils.getTenantCode());
                String key = StringUtils.join(e.getYearMonthLy(),e.getRegionCode(),e.getSystemCode());
                e.setBudgetSales(BigDecimal.ZERO);
                if(salesGoalVoMap.containsKey(key)){
                    e.setBudgetSales(salesGoalVoMap.get(key).getDeliveryDiscountSalesAmount());
                }
                //预算点数 预算额/预算销量*100%
                e.setBudgetPoints(BigDecimal.ZERO);
                if(BigDecimal.ZERO.compareTo(e.getBudgetSales()) != 0) {
                    e.setBudgetPoints(e.getInitResolveAmount().divide(e.getBudgetSales(),4,BigDecimal.ROUND_HALF_UP));
                }
                //预计费用额：预计折后销售额*预算点数
                e.setEstimatedFeeAmount(e.getEstimatedDiscountSales().multiply(e.getBudgetPoints()));
            });

            this.verticalAreaFeeWarningRepository.saveOrUpdateBatch(result.getRecords());

            //计算累计的数据
            result.getRecords().forEach(e -> {
                VerticalAreaFeeWarningEntity entity = this.verticalAreaFeeWarningRepository.accumulate(e);
                if(Objects.nonNull(entity)) {
                    e.setAccumulateBudgetAmount(entity.getAccumulateBudgetAmount());
                    e.setAccumulateBudgetSales(entity.getAccumulateBudgetSales());
                }else{
                    e.setAccumulateBudgetAmount(BigDecimal.ZERO);
                    e.setAccumulateBudgetSales(BigDecimal.ZERO);
                }
                //累计预算点数：累计预算额/累计预算销量*100%
                e.setAccumulateBudgetPoints(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getAccumulateBudgetSales()) != 0) {
                    e.setAccumulateBudgetPoints(e.getAccumulateBudgetAmount().divide(e.getAccumulateBudgetSales(),4,BigDecimal.ROUND_HALF_UP));
                }
                e.setAccumulateUseAmount(e.getAccumulateBudgetAmount());
                e.setAccumulateDiscountAmount(e.getAccumulateDiscountAmount());
                //累计预计剩余费用额：累计预算额-累计已使用费用额
                e.setAccumulateResidueAmount(e.getAccumulateBudgetAmount().subtract(e.getAccumulateUseAmount()));
            });

            this.verticalAreaFeeWarningRepository.saveOrUpdateBatch(result.getRecords());
            count++;
        }while (count <= 1000 && result.hasNext());
    }
    @Override
    public List<MonthBudgetVo> findMonthBudgetForVariable(MonthBudgetDto dto) {
        return monthBudgetRepository.findMonthBudgetForVariable(dto);
    }

    @Override
    public List<MonthBudgetVo> findMonthBudgetConditionForVariable(MonthBudgetDto monthBudgetDto) {
        if (Objects.isNull(monthBudgetDto)) {
            return Lists.newArrayList();
        }
        monthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
        List<MonthBudgetVo> list = monthBudgetRepository.findMonthBudgetConditionForVariable(monthBudgetDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public MonthBudgetVo findMonthBudgetSumAuditAmount(MonthBudgetDto monthBudgetDto) {
        return monthBudgetRepository.findMonthBudgetSumAuditAmount(monthBudgetDto);
    }

    @Override
    public MonthBudgetVo findMonthBudgetSumInitResolveAmount(MonthBudgetDto monthBudgetDto) {
        return monthBudgetRepository.findMonthBudgetSumInitResolveAmount(monthBudgetDto);
    }

    /**
     * 垂直预警面板-给帆软跑
     * @param yearMonths
     */
    @Override
    @Transactional
    public void verticalWarningPanel(List<String> yearMonths) {
        this.loginUserService.refreshAuthentication(null);
        //先删除吧
        this.verticalWarningPanelRepository.lambdaUpdate().in(VerticalWarningPanelEntity::getYearMonthLy, yearMonths).remove();
        //200条执行一次
        int pageSize = 200;
        int current = 1;
        int count = 1;

        Page<VerticalWarningPanelEntity> result;
        Map<String, String> region = this.dictToolkitService.findMapByDictTypeCode(DictTypeCodeConstant.MDM_CUSTOMIZE_ORG);
        do{
            //从月度预算汇总维度：年月+区域+系统+预算项目
            Pageable pageable = PageRequest.of(current,pageSize);
            result = this.verticalWarningPanelRepository.verticalWarningPanel(pageable,yearMonths);
            if(Objects.isNull(result) || CollectionUtils.isEmpty(result.getRecords())) break;
            current++;

            //垂直销售业绩-折后实际销额
            List<SalesPerformanceDto> salesPerformanceDtos = result.getRecords().stream().map(e -> new SalesPerformanceDto(){{
                this.setSalesMonth(e.getYearMonthLy().replace("-",""));
                this.setRegion(region.getOrDefault(e.getRegionCode(),"not found"));
                this.setRetailer(e.getSystemName());
            }}).collect(Collectors.toList());
            List<SalesPerformanceVo> salesPerformanceVos = this.salesPerformanceVoService.findListForFR(salesPerformanceDtos);
            Map<String,SalesPerformanceVo> salesPerformanceVoMap = salesPerformanceVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getSalesMonth(), e.getRegion(), e.getRetailer()), Function.identity(),(v1,v2) -> v1));

            //取POS
            List<SalesDataDto> salesDataDtos = result.getRecords().stream().map(e -> new SalesDataDto(){{
                this.setYearMonth(e.getYearMonthLy());
                this.setBusinessArea(e.getRegionCode());
                this.setCustomerRetailerCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<SalesDataVo> salesDataVos = this.invoiceSalesDataVoService.findListForFR(salesDataDtos);
            Map<String,SalesDataVo> salesDataVoMap = salesDataVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonth(), e.getBusinessArea(), e.getCustomerRetailerCode()), Function.identity(),(v1,v2) -> v1));

            //销售任务：统计“年月+区域+系统”维度内控版的销售任务折后金额
            List<SalesGoalDto> salesGoalDtos = result.getRecords().stream().map(e -> new SalesGoalDto(){{
                this.setYearMonthLy(e.getYearMonthLy());
                this.setRegionCode(e.getRegionCode());
                this.setSystemCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<SalesGoalVo> salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
            Map<String,SalesGoalVo> salesGoalVoMap = salesGoalVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(),e.getRegionCode(),e.getSystemCode()),Function.identity(),(v1,v2) -> v1));

            //同期
            List<String> unionKeys = result.getRecords().stream()
                    .map(e -> StringUtils.join(e.getLastYear(), e.getRegionCode(), e.getSystemCode(), e.getBudgetItemCode()))
                    .collect(Collectors.toList());
            List<VerticalWarningPanelEntity> lastList = this.verticalWarningPanelRepository.lambdaQuery().in(VerticalWarningPanelEntity::getUnionKey,unionKeys).list();
            Map<String,VerticalWarningPanelEntity> lastMap = lastList.stream().collect(Collectors.toMap(VerticalWarningPanelEntity::getUnionKey,Function.identity(),(v1,v2) -> v1));

            //预算总使用金额：按照年月+区域+系统汇总批复金额-批复结案差
            List<MonthBudgetDto> monthBudgetDtos = result.getRecords().stream().map(e -> new MonthBudgetDto(){{
                this.setYearMonthLy(e.getYearMonthLy());
                this.setRegionCode(e.getRegionCode());
                this.setSystemCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<MonthBudgetVo> monthBudgetVos = this.monthBudgetRepository.findListForFR(monthBudgetDtos);
            Map<String,MonthBudgetVo> monthMap = monthBudgetVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(),e.getRegionCode(),e.getSystemCode()),Function.identity(),(v1,v2) -> v1));


            result.getRecords().forEach(e -> {
                String key = StringUtils.join(e.getYearMonthLy(),e.getRegionCode(),e.getSystemCode());
                String key1 = StringUtils.join(e.getYearMonthLy().replace("-",""),region.getOrDefault(e.getRegionCode(),"not found"),e.getSystemName());
                //垂直销售业绩
                e.setDiscountSalesAmount(BigDecimal.ZERO);
                if(salesPerformanceVoMap.containsKey(key1)){
                    e.setDiscountSalesAmount(salesPerformanceVoMap.get(key1).getWarehsOutDiscountAmt());
                }
                //销售任务
                e.setSalesDiscountAmount(BigDecimal.ZERO);
                if(salesGoalVoMap.containsKey(key)){
                    e.setSalesDiscountAmount(salesGoalVoMap.get(key).getDeliveryDiscountSalesAmount());
                }
                //销售达成率
                e.setSalesAchievementRate(BigDecimal.ZERO);
                if(BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0){
                    e.setSalesAchievementRate(e.getDiscountSalesAmount().divide(e.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP));
                }

                //POS费用率
                e.setPosFeeRate(BigDecimal.ZERO);
                if(monthMap.containsKey(key) && salesDataVoMap.containsKey(key)){
                    BigDecimal pos = ObjectUtils.defaultIfNull(salesDataVoMap.get(key).getSalesAmount(),BigDecimal.ZERO);
                    BigDecimal use = ObjectUtils.defaultIfNull(monthMap.get(key).getApprovedAmount(),BigDecimal.ZERO);
                    if(BigDecimal.ZERO.compareTo(pos) != 0){
                        e.setPosFeeRate(use.divide(pos,4,BigDecimal.ROUND_HALF_UP));
                    }
                }
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setCurrentRate(BigDecimal.ZERO);
                e.setVsBudget(BigDecimal.ZERO);
                if(BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0){
                    e.setCurrentRate(ObjectUtils.defaultIfNull(e.getBudgetUseAmount(),BigDecimal.ZERO).divide(e.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP));
                    e.setVsBudget(e.getCurrentRate().subtract(e.getInitResolveAmount().divide(e.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP)));
                }
                e.setUnionKey(StringUtils.join(e.getYearMonthLy(),e.getRegionCode(),e.getSystemCode(),e.getBudgetItemCode()));
                e.setVsTq(BigDecimal.ZERO);
                String last = StringUtils.join(e.getLastYear(),e.getRegionCode(),e.getSystemCode(),e.getBudgetItemCode());
                if(lastMap.containsKey(last)){
                    e.setVsTq(e.getCurrentRate().subtract(lastMap.get(last).getCurrentRate()));
                }
            });

            this.verticalWarningPanelRepository.saveOrUpdateBatch(result.getRecords());

            //增加费用合计
            List<VerticalWarningPanelEntity> panelList = this.verticalWarningPanelRepository.findListForFR(yearMonths);
            if(!CollectionUtils.isEmpty(panelList)){
                //合计同期
                List<String> totalUnionKeys = panelList.stream()
                        .map(e -> StringUtils.join(e.getLastYear(), e.getRegionCode(), e.getSystemCode(), "total"))
                        .collect(Collectors.toList());
                List<VerticalWarningPanelEntity> totalLastList = this.verticalWarningPanelRepository.lambdaQuery().in(VerticalWarningPanelEntity::getUnionKey,totalUnionKeys).list();
                Map<String,VerticalWarningPanelEntity> totalLastMap = totalLastList.stream().collect(Collectors.toMap(VerticalWarningPanelEntity::getUnionKey,Function.identity(),(v1,v2) -> v1));

                panelList.forEach(panel -> {
                    panel.setBudgetItemCode("total");
                    panel.setBudgetItemName("费用合计");
                    panel.setTenantCode(TenantUtils.getTenantCode());
                    panel.setCurrentRate(BigDecimal.ZERO);
                    panel.setVsBudget(BigDecimal.ZERO);
                    if(BigDecimal.ZERO.compareTo(panel.getSalesDiscountAmount()) != 0){
                        panel.setCurrentRate(panel.getBudgetUseAmount().divide(panel.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP));
                        panel.setVsBudget(panel.getCurrentRate().subtract(panel.getInitResolveAmount().divide(panel.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP)));
                    }
                    panel.setUnionKey(StringUtils.join(panel.getYearMonthLy(),panel.getRegionCode(),panel.getSystemCode(),panel.getBudgetItemCode()));
                    panel.setVsTq(BigDecimal.ZERO);
                    String last = StringUtils.join(panel.getLastYear(),panel.getRegionCode(),panel.getSystemCode(),panel.getBudgetItemCode());
                    if(totalLastMap.containsKey(last)){
                        panel.setVsTq(panel.getCurrentRate().subtract(totalLastMap.get(last).getCurrentRate()));
                    }
                });
                this.verticalWarningPanelRepository.saveOrUpdateBatch(panelList);
            }
            count++;
        }while(count <= 1000 && result.hasNext());
    }
}
