package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetDetailMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author huojia
 * @date 2022年10月31日 21:13
 */
@Slf4j
@Service
public class SubComMonthBudgetDetailServiceImpl implements SubComMonthBudgetDetailService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SubComMonthBudgetDetailMapper subComMonthBudgetDetailMapper;

    @Autowired(required = false)
    private SubComMonthBudgetDetailRepository subComMonthBudgetDetailRepository;

    /**
     * 分页查询分子公司操作明细
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailVo>
     * @author huojia
     * @date 2022/11/1 21:04
     **/
    @Override
    public Page<SubComMonthBudgetDetailVo> findByConditions(Pageable pageable, SubComMonthBudgetDetailDto dto) {
        ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new SubComMonthBudgetDetailDto();
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page<SubComMonthBudgetDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.subComMonthBudgetDetailMapper.findByConditions(page, dto);
    }

    /**
     * 创建分子公司月度预算明细
     *
     * @param detailDto
     * @author huojia
     * @date 2022/11/2 11:33
     **/
    @Override
    public void create(SubComMonthBudgetDetailDto detailDto) {
        if (ObjectUtils.isEmpty(detailDto)) {
            return;
        }
        SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = nebulaToolkitService.copyObjectByWhiteList(detailDto, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
        subComMonthBudgetDetailEntity.setId(null);
        subComMonthBudgetDetailEntity.setTenantCode(TenantUtils.getTenantCode());
        subComMonthBudgetDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        subComMonthBudgetDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        subComMonthBudgetDetailRepository.save(subComMonthBudgetDetailEntity);
    }

    @Override
    public void createList(List<SubComMonthBudgetDetailDto> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List<SubComMonthBudgetDetailEntity> entityList = (List<SubComMonthBudgetDetailEntity>) nebulaToolkitService.copyCollectionByWhiteList(detailList, SubComMonthBudgetDetailDto.class,SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
        entityList.forEach(item -> {
            item.setId(null);
        });
        subComMonthBudgetDetailRepository.saveBatch(entityList);
    }

    /**
     * 查询明细
     *
     * @param monthBudgetCode
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity>
     * @author huojia
     * @date 2023/1/15 10:19
     **/
    @Override
    public List<SubComMonthBudgetDetailEntity> listByMonthBudgetCode(String monthBudgetCode) {
        if (StringUtils.isEmpty(monthBudgetCode)) {
            return Lists.newArrayList();
        }
        return this.subComMonthBudgetDetailRepository.listByMonthBudgetCode(monthBudgetCode);
    }
}
