package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetLogService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetLogEventDto;
import com.biz.crm.tpm.business.month.budget.sdk.event.SubComMonthBudgetLogEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/2/17 17:09
 * @description: 分子月度预算管理日志服务接口实现类
 */
@Service("SubComMonthBudgetLogService")
public class SubComMonthBudgetLogServiceImpl implements SubComMonthBudgetLogService {
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Async
    @Override
    public void addLogAsync(List<SubComMonthBudgetDto> addList) {
        SerializableBiConsumer<SubComMonthBudgetLogEventListener, SubComMonthBudgetLogEventDto> onCreate =
                SubComMonthBudgetLogEventListener::onCreate;
        for (SubComMonthBudgetDto in : addList) {
            //新增业务日志
            SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(in);
            this.nebulaNetEventClient.publish(logEventDto, SubComMonthBudgetLogEventListener.class, onCreate);
        }
    }

    @Async
    @Override
    public void updateLogAsync(List<SubComMonthBudgetLogEventDto> editLogs) {
        SerializableBiConsumer<SubComMonthBudgetLogEventListener, SubComMonthBudgetLogEventDto> onUpdate =
                SubComMonthBudgetLogEventListener::onUpdate;
        for (SubComMonthBudgetLogEventDto log : editLogs) {
            this.nebulaNetEventClient.publish(log, SubComMonthBudgetLogEventListener.class, onUpdate);
        }
    }
}
