package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.RollingTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetPlanBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetPlanBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetLogService;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.*;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.ControlsCaliberEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.DataSourceEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.month.budget.sdk.event.SubComMonthBudgetLogEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.*;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月31日 20:50
 */
@Slf4j
@Service
public class SubComMonthBudgetServiceImpl implements SubComMonthBudgetService {

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private SubComMonthBudgetMapper subComMonthBudgetMapper;

    @Autowired(required = false)
    private DimensionControlsService dimensionControlsService;

    @Autowired(required = false)
    private SubComMonthBudgetRepository subComMonthBudgetRepository;

    @Autowired(required = false)
    private SubComMonthBudgetDetailService subComMonthBudgetDetailService;

    @Autowired(required = false)
    private SubComMonthBudgetDetailRepository subComMonthBudgetDetailRepository;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    @Autowired(required = false)
    private SubComMonthBudgetPlanBudgetRepository subComMonthBudgetPlanBudgetRepository;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private SubComMonthBudgetServiceImpl subComMonthBudgetService;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private SubComMonthBudgetLogService subComMonthBudgetLogService;

    @Autowired(required = false)
    private SubComBudgetForecastService subComBudgetForecastService;


    /**
     * 分页查询分子公司预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo>
     * @author huojia
     * @date 2022/11/1 21:05
     **/
    @Override
    public Page<SubComMonthBudgetVo> findByConditions(Pageable pageable, SubComMonthBudgetDto dto) {
        ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new SubComMonthBudgetDto();
        }
        Page<SubComMonthBudgetVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page = this.subComMonthBudgetMapper.findByConditions(page, dto);
        convertSubComMonthBudgetProperty(page.getRecords());
        return page;
    }

    /**
     * 转换字段
     */
    public void convertSubComMonthBudgetProperty(List<SubComMonthBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, String> feeSourceMap = Maps.newHashMap();
        if (null != dictDataVoService) {
            try {
                List<DictDataVo> feeSourceList = dictDataVoService.findByDictTypeCode(MonthBudgetConstant.DICT_TPM_FEE_SOURCE);
                if (!CollectionUtils.isEmpty(feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            } catch (Exception e) {
                log.error("分公司费用来源数据字典查询失败：" + e.getMessage());
            }
        }
        for (SubComMonthBudgetVo vo : list) {
            //费用来源转换
            if (StringUtils.isNotEmpty(vo.getFeeSourceCode())) {
                vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeSourceCode(), vo.getFeeSourceCode()));
            }
        }
    }

    /**
     * 根据主键查询分子公司月度预算
     *
     * @param id
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo
     * @author huojia
     * @date 2022/11/1 21:05
     **/
    @Override
    public SubComMonthBudgetVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        SubComMonthBudgetEntity subComMonthBudgetEntity = subComMonthBudgetRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull(subComMonthBudgetEntity, "数据不存在，请刷新后重试！");
        return nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 创建分子公司月度预算
     *
     * @param dto
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo
     * @author huojia
     * @date 2022/11/1 21:06
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SubComMonthBudgetVo create(SubComMonthBudgetDto dto) {
        this.createValidate(dto);
        // 保存分子公司月度预算
        SubComMonthBudgetEntity subComMonthBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(dto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
        //自动生成、手动添加
        subComMonthBudgetEntity.setDataSource(DataSourceEnum.MANUAL.getCode());
        subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getBudgetAmount());
        this.subComMonthBudgetRepository.saveOrUpdate(subComMonthBudgetEntity);
        // 生成预算明细
        // 月度预算生成期初操作明细
        this.buildInitDetail(subComMonthBudgetEntity);
        dto.setId(subComMonthBudgetEntity.getId());
        // 业务日志新增
        SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<SubComMonthBudgetLogEventListener, SubComMonthBudgetLogEventDto> onCreate =
                SubComMonthBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, SubComMonthBudgetLogEventListener.class, onCreate);
        return this.nebulaToolkitService.copyObjectByWhiteList(dto, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 构建期初明细
     *
     * @param subComMonthBudgetEntity
     * @author huojia
     * @date 2022/11/11 17:08
     **/
    private void buildInitDetail(SubComMonthBudgetEntity subComMonthBudgetEntity) {
        SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
        subComMonthBudgetDetailEntity.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
        subComMonthBudgetDetailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
        this.subComMonthBudgetDetailRepository.save(subComMonthBudgetDetailEntity);
    }

    /**
     * 新增时校验必填字段
     *
     * @param dto
     * @author huojia
     * @date 2022/10/31 22:34
     **/
    private void createValidate(SubComMonthBudgetDto dto) {
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.findByDimension(dto);
        if (!CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            throw new RuntimeException("当前预算维度已存在");
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//        String ruleCode = StringUtils.join(MonthBudgetConstant.SUB_COM_MONTH_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        dto.setMonthBudgetCode(generateCodeService.generateCode(MonthBudgetConstant.SUB_COM_MONTH_BUDGET_CODE, 1, 8, 2, TimeUnit.DAYS).get(0));
        dto.setCurrentBalanceAmount(dto.getBudgetAmount());
        // 根据维度校验字段
        /*DimensionInformationQueryData dimensionVo = new DimensionInformationQueryData();
        dimensionVo.setBusinessState(dto.getBusinessFormatCode());
        dimensionVo.setBusinessUnit(dto.getBusinessUnitCode());
        dimensionVo.setMenu(MenuCodeEnum.SUB_COM_MONTH_BUDGET.getCode());
        List<DimensionDimensionInformationVo> dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dimensionVo);
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("未维护对应维度配置数据，请检查！");
        }
        Class<SubComMonthBudgetDto> clazz = SubComMonthBudgetDto.class;
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(dto);
                if (ObjectUtils.isEmpty(o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        });*/
    }

    /**
     * 编辑分子公司月度预算
     *
     * @param dto
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo
     * @author huojia
     * @date 2022/11/1 21:06
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SubComMonthBudgetVo update(SubComMonthBudgetDto dto) {
        this.updateValidate(dto);
        boolean lockFlag = false;
        try {
            lockFlag = monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Assert.isTrue(lockFlag, "其他人正在操作数据,加锁失败,请稍后重试!");
            SubComMonthBudgetVo subComMonthBudgetVo = this.findById(dto.getId());
            Validate.isTrue(!DataSourceEnum.AUTO.getCode().equals(subComMonthBudgetVo.getDataSource()),"自动生成的分子月度预算不允许编辑");
            // 保存分子公司月度预算项目
            SubComMonthBudgetDto oldVo = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetVo, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(dto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getBudgetAmount());
            this.subComMonthBudgetRepository.saveOrUpdate(subComMonthBudgetEntity);
            // 业务日志编辑
            SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<SubComMonthBudgetLogEventListener, SubComMonthBudgetLogEventDto> onUpdate =
                    SubComMonthBudgetLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, SubComMonthBudgetLogEventListener.class, onUpdate);
            return this.nebulaToolkitService.copyObjectByWhiteList(dto, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    /**
     * 分子公司月度预算调整
     *
     * @param dto
     * @author huojia
     * @date 2022/11/2 10:54
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void adjust(SubComMonthBudgetAdjustDto dto) {
        // 校验参数
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getAdjustOutBudgetCode(), "调出方编码不能为空！");
        Validate.notNull(dto.getAdjustOutAmount(), "调出金额不能为空！");
        Validate.isTrue(dto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0, "调出金额不能小于等于0！");
        Validate.notEmpty(dto.getAdjustInBudgetCode(), "调入方编码不能为空！");
        // 月度预算批量加锁
        List<String> lockKeys = new ArrayList<>();
        lockKeys.add(dto.getAdjustOutBudgetCode());
        lockKeys.add(dto.getAdjustInBudgetCode());
        boolean lockFlag = true;
        try {
            lockFlag = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "预算调整失败，当前调入、调出预算正在操作中，请稍后！");
            SubComMonthBudgetEntity adjustInEntity = subComMonthBudgetRepository.getByMonthBudgetCode(dto.getAdjustInBudgetCode(), null);
            Validate.notNull(adjustInEntity, "调入方不存在，请检查！");
            SubComMonthBudgetEntity adjustOutEntity = subComMonthBudgetRepository.getByMonthBudgetCode(dto.getAdjustOutBudgetCode(), null);
            Validate.notNull(adjustOutEntity, "调出方不存在，请检查！");
            Validate.isTrue(!DataSourceEnum.AUTO.getCode().equals(adjustOutEntity.getDataSource()),"自动生成的分子月度预算不允许调整");
            if (Optional.ofNullable(adjustOutEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getAdjustOutAmount()) < 0) {
                throw new RuntimeException("月度预算[" + dto.getAdjustOutBudgetCode() + "]的调出金额" + dto.getAdjustOutAmount().setScale(4, RoundingMode.HALF_UP) + "不能大于本期结余余额" + Optional.ofNullable(adjustOutEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP));
            }
            // 修改调整、可用金额
            adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setCurrentBalanceAmount(Optional.ofNullable(adjustOutEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            //adjustInEntity.setAdjustAmount(Optional.ofNullable(adjustInEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
            //adjustInEntity.setCurrentBalanceAmount(Optional.ofNullable(adjustInEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
            adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
            this.subComMonthBudgetRepository.updateById(adjustOutEntity);
            this.subComMonthBudgetRepository.updateById(adjustInEntity);
            // 提交审批，更新审批状态
            String processNo = this.adjustSubmit(dto);
            // 生成调出方操作明细
            SubComMonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, dto.getAdjustOutAmount(), BudgetOperationTypeEnum.ADJUST_OUT.getCode(), null);
            adjustOutDetailDto.setProcessNo(processNo);
            adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            subComMonthBudgetDetailService.create(adjustOutDetailDto);
            // 生成调入方操作明细
            SubComMonthBudgetDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustOutAmount(), BudgetOperationTypeEnum.ADJUST_IN.getCode(), null);
            adjustInDetailDto.setProcessNo(processNo);
            adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            subComMonthBudgetDetailService.create(adjustInDetailDto);
        }catch (Exception e){
            throw e;
        }finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    /**
     * 审批中查看调整数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetMainAdjustVo
     * @author huojia
     * @date 2022/12/23 14:21
     **/
    @Override
    public SubComMonthBudgetMainAdjustVo adjustQuery(String processNo) {
        Validate.notEmpty(processNo, "请求失败，流程编码不能为空！");
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = subComMonthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComMonthBudgetDetailEntityList)) {
            throw new RuntimeException("数据查询失败，对应分子公司月度预算调整明细不存在！");
        }
        SubComMonthBudgetMainAdjustVo subComMonthBudgetMainAdjustVo = new SubComMonthBudgetMainAdjustVo();
        // 查看页面的可用余额用实时的数据
        subComMonthBudgetDetailEntityList.forEach(monthBudgetDetailEntity -> {
            SubComMonthBudgetEntity subComMonthBudgetEntity = subComMonthBudgetRepository.getByMonthBudgetCode(monthBudgetDetailEntity.getMonthBudgetCode(), null);
            SubComMonthBudgetAdjustVo subComMonthBudgetAdjustVo = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetAdjustVo.class, LinkedHashSet.class, ArrayList.class);
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
                subComMonthBudgetAdjustVo.setCurrentBalanceAmount(monthBudgetDetailEntity.getBeforeAmount());
                subComMonthBudgetAdjustVo.setAdjustInAmount(monthBudgetDetailEntity.getCurOperationAmount());
                subComMonthBudgetAdjustVo.setAdjustInBalance(
                        subComMonthBudgetAdjustVo.getCurrentBalanceAmount().add(monthBudgetDetailEntity.getCurOperationAmount())
                );
                subComMonthBudgetMainAdjustVo.setAdjustInVo(subComMonthBudgetAdjustVo);
            }
            if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
                subComMonthBudgetAdjustVo.setCurrentBalanceAmount(monthBudgetDetailEntity.getBeforeAmount());
                subComMonthBudgetAdjustVo.setAdjustOutAmount(monthBudgetDetailEntity.getCurOperationAmount());
                subComMonthBudgetAdjustVo.setAdjustOutBalance(monthBudgetDetailEntity.getBalanceAmount());
                subComMonthBudgetMainAdjustVo.setAdjustOutVo(subComMonthBudgetAdjustVo);
            }
        });
        return subComMonthBudgetMainAdjustVo;
    }

    /**
     * 审批中查看变更数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetChangeVo
     * @author huojia
     * @date 2022/12/23 14:29
     **/
    @Override
    public SubComMonthBudgetChangeVo changeQuery(String processNo) {
        Validate.notEmpty(processNo, "请求失败，流程编码不能为空！");
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = subComMonthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComMonthBudgetDetailEntityList)) {
            throw new RuntimeException("数据查询失败，对应月度预算调整明细不存在！");
        }
        SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = subComMonthBudgetDetailEntityList.get(0);
        SubComMonthBudgetEntity subComMonthBudgetEntity = subComMonthBudgetRepository.getByMonthBudgetCode(subComMonthBudgetDetailEntity.getMonthBudgetCode(), null);
        SubComMonthBudgetChangeVo subComMonthBudgetChangeVo = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetChangeVo.class, LinkedHashSet.class, ArrayList.class);
        if (BudgetOperationTypeEnum.ADD.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
            subComMonthBudgetChangeVo.setCurrentBalanceAmount(subComMonthBudgetDetailEntity.getBeforeAmount());
            subComMonthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.ADD.getCode());
            subComMonthBudgetChangeVo.setChangeAmount(subComMonthBudgetDetailEntity.getCurOperationAmount());
            subComMonthBudgetChangeVo.setChangeBalance(subComMonthBudgetDetailEntity.getBalanceAmount().add(subComMonthBudgetDetailEntity.getCurOperationAmount()));
        }
        if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
            subComMonthBudgetChangeVo.setCurrentBalanceAmount(subComMonthBudgetDetailEntity.getBeforeAmount());
            subComMonthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.SUBTRACT.getCode());
            subComMonthBudgetChangeVo.setChangeAmount(subComMonthBudgetDetailEntity.getCurOperationAmount());
            subComMonthBudgetChangeVo.setChangeBalance(subComMonthBudgetDetailEntity.getBalanceAmount());
        }
        return subComMonthBudgetChangeVo;
    }

    /**
     * 分子公司月度预算对接审批流
     *
     * @param dto
     * @return java.lang.String
     * @author huojia
     * @date 2022/11/14 16:36
     **/
    private String adjustSubmit(SubComMonthBudgetAdjustDto dto) {
        // 提交审批流
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(MonthBudgetConstant.SUB_COM_ADJUST_MONTH_BUDGET);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull(processBusinessVo, "提交审批失败！");
        return processBusinessVo.getProcessNo();
    }

    /**
     * 构建明细操作
     *
     * @param subComMonthBudgetEntity
     * @param operationAmount
     * @param operationType
     * @param businessCode
     * @return com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto
     * @author huojia
     * @date 2022/11/2 11:06
     **/
    private SubComMonthBudgetDetailDto buildDetail(SubComMonthBudgetEntity subComMonthBudgetEntity, BigDecimal operationAmount, String operationType, String businessCode) {
        SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetDetailDto.class, LinkedHashSet.class, ArrayList.class);
        subComMonthBudgetDetailDto.setId(null);
        subComMonthBudgetDetailDto.setBusinessCode(businessCode);
        subComMonthBudgetDetailDto.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
        subComMonthBudgetDetailDto.setOperationType(operationType);
        // 根据不同操作类型，设置不同操作前金额
        if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType)
                || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType)
                || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType)
                || BudgetOperationTypeEnum.USE.getCode().equals(operationType)
                || BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        } else if (BudgetOperationTypeEnum.ADD.getCode().equals(operationType)
                || BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType)
                || BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
        }
        subComMonthBudgetDetailDto.setCurOperationAmount(operationAmount);
        subComMonthBudgetDetailDto.setBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
        return subComMonthBudgetDetailDto;
    }

    /**
     * 分子公司月度预算变更
     *
     * @param dto
     * @author huojia
     * @date 2022/11/2 10:54
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void change(SubComMonthBudgetOperateDto dto) {
        // 参数校验
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notBlank(dto.getMonthBudgetCode(), "分子公司月度预算编码不能为空！");
        Validate.notBlank(dto.getOperationType(), "变更类型不能为空！");
        Validate.isTrue(BudgetOperationTypeEnum.changeMap().containsKey(dto.getOperationType()), "变更类型只能是追加、削减！");
        Validate.notNull(dto.getOperationAmount(), "变更金额不能为空！");
        Validate.isTrue(dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0, "变更金额不能小于等于0！");

        boolean lockFlag = true;
        try {
            // 预算加锁
            lockFlag = monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "当前预算正在操作中，请稍后！");
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull(subComMonthBudgetEntity, "当前预算不存在，请刷新后重试！");
            Validate.isTrue(!DataSourceEnum.AUTO.getCode().equals(subComMonthBudgetEntity.getDataSource()),"自动生成的分子月度预算不允许变更");
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                Validate.isTrue(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO)
                        .compareTo(dto.getOperationAmount()) >= 0, "削减金额不能超过当前预算可用金额" + Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP) + "！");
            }
            // 预算
            if (BudgetOperationTypeEnum.ADD.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setApprovingAmount(
                        Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO)
                                .add(dto.getOperationAmount())
                );
                // subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                // subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setAdjustAmount(
                        Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
                subComMonthBudgetEntity.setCurrentBalanceAmount(
                        Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO)
                                .subtract(dto.getOperationAmount())
                );
            }
            this.subComMonthBudgetRepository.saveOrUpdate(subComMonthBudgetEntity);
            // 分子公司月度预算提审
            String processNo = this.changeSubmit(dto);
            // 生成操作明细
            SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, dto.getOperationAmount(), dto.getOperationType(), null);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            } else {
                subComMonthBudgetDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            }
            subComMonthBudgetDetailDto.setProcessNo(processNo);
            subComMonthBudgetDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    /**
     * 分子公司月度预算提审
     *
     * @param dto
     * @return java.lang.String
     * @author huojia
     * @date 2022/11/14 16:51
     **/
    private String changeSubmit(SubComMonthBudgetOperateDto dto) {
        // 提交审批流
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(MonthBudgetConstant.SUB_COM_CHANGE_MONTH_BUDGET);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull(processBusinessVo, "提交审批失败！");
        return processBusinessVo.getProcessNo();
    }

    /**
     * 分子公司月度预算解冻、冻结
     *
     * @param dto
     * @param operationType
     * @author huojia
     * @date 2022/11/2 10:54
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unOrFreeze(SubComMonthBudgetOperateDto dto, String operationType) {
        // 参数校验
        Validate.notNull(dto, "请求参数不能为空！");
        dto.setOperationType(operationType);
        Validate.notBlank(dto.getMonthBudgetCode(), "分子公司月度预算编码不能为空！");
        Validate.notBlank(dto.getOperationType(), "操作类型不能为空！");
        Validate.isTrue(BudgetOperationTypeEnum.freezeMap().containsKey(dto.getOperationType()), "操作类型只能是冻结、解冻！");
        Validate.notNull(dto.getOperationAmount(), "操作金额不能为空！");
        Validate.isTrue(dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0, "操作金额不能小于等于0！");

        boolean lockFlag = true;
        try {
            // 预算加锁
            lockFlag = monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            Validate.isTrue(lockFlag, "当前预算正在操作中，请稍后！");
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull(subComMonthBudgetEntity, "当前预算不存在，请刷新后重试！");
            Validate.isTrue(!DataSourceEnum.AUTO.getCode().equals(subComMonthBudgetEntity.getDataSource()),"自动生成的分子月度预算不允许冻结或解冻");
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO)
                        .compareTo(dto.getOperationAmount()) >= 0, "冻结金额不能超过当前预算可用金额" + Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP) + "！");
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue(Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)
                        .compareTo(dto.getOperationAmount()) >= 0, "解冻金额不能超过当前冻结金额" + Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP) + "！");
            }
            // 金额调整
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setFreezeAmount(Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setFreezeAmount(Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            this.subComMonthBudgetRepository.saveOrUpdate(subComMonthBudgetEntity);
            // 生成操作明细
            SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, dto.getOperationAmount(), dto.getOperationType(), null);
            subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    /**
     * 本模块使用
     * <p>
     * 操作分子公司月度预算（月度预算编码、操作金额、操作类型必填）
     *
     * @param monthBudgetCode
     * @param operationAmount
     * @param operationType
     * @param businessCode
     * @author huojia
     * @date 2022/11/7 10:41
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(String monthBudgetCode, BigDecimal operationAmount, String operationType, String businessCode) {
        Validate.notEmpty(monthBudgetCode, "操作预算时，预算编码不能为空！");
        Validate.notNull(operationAmount, "操作预算时，操作金额不能为空！");
        Validate.notEmpty(operationType, "操作预算时，操作类型不能为空！");
        SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(monthBudgetCode, EnableStatusEnum.ENABLE.getCode());
        Validate.notNull(subComMonthBudgetEntity, "分子公司月度预算" + monthBudgetCode + "查询失败，请检查预算是否启用或是否存在！");
        if (!redisLockService.isLock(BudgetLockConstant.MONTH_BUDGET_LOCK + monthBudgetCode)) {
            throw new RuntimeException("预算操作失败，月度预算" + monthBudgetCode + "未加锁！");
        }
        // 预算使用、退回
        if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        } else {

        }
        this.subComMonthBudgetRepository.updateById(subComMonthBudgetEntity);
        // 构建操作明细
        SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, operationAmount, operationType, businessCode);
        subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudget(List<OperateMonthBudgetDto> operateList) {
        Map<String, SubComMonthBudgetEntity> budgetEntityMap = validateOperateBudget(operateList);
        List<SubComMonthBudgetDetailDto> detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            SubComMonthBudgetEntity subComMonthBudgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else {
                throw new RuntimeException("月度预算操作类型有误！");
            }
            // 构建操作明细
            SubComMonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, operationAmount, operationType, businessCode);
            detailList.add(monthBudgetDetailDto);
        }
        subComMonthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateBudgetByAudit(List<OperateMonthBudgetDto> operateList,Map<String, MonthBudgetControlVo> controlMap) {
        Map<String, SubComMonthBudgetEntity> budgetEntityMap = validateOperateBudget(operateList);
        List<SubComMonthBudgetDetailDto> detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            SubComMonthBudgetEntity subComMonthBudgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            MonthBudgetControlVo monthBudgetControlVo = controlMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            }else if(BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
                if(YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling())&& ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())){
                    subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                    subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
                }else {
                    throw new RuntimeException("预算修改失败，没有找到对应的管控维度");
                }
            }else if(BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType)){
                if(YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling())&& ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())){
                    subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                    subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
                }else {
                    throw new RuntimeException("预算修改失败，没有找到对应的管控维度");
                }
            } else {
                throw new RuntimeException("月度预算操作类型有误！");
            }
            // 构建操作明细
            SubComMonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, operationAmount, operationType, businessCode);
            detailList.add(monthBudgetDetailDto);
        }
        log.info("结案核销分子退预算：budgetEntity:{}",JsonUtils.obj2JsonString(budgetEntityMap.values()));
        subComMonthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
    }

    /**
     * 保存更新操作预算数据
     *
     * @param budgetList 预算头数据
     * @param detailList 预算明细数据
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateOperateBudget(Collection<SubComMonthBudgetEntity> budgetList, List<SubComMonthBudgetDetailDto> detailList) {
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.subComMonthBudgetRepository.updateBatchById(budgetList);
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            // 构建操作明细
            subComMonthBudgetDetailService.createList(detailList);
        }
    }


    public Map<String, SubComMonthBudgetEntity> validateOperateBudget(List<OperateMonthBudgetDto> operateList) {
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty(operateMonthBudgetDto.getMonthBudgetCode(), "操作预算时，预算编码不能为空！");
            Validate.notNull(operateMonthBudgetDto.getOperationAmount(), "操作预算时，操作金额不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getOperationType(), "操作预算时，操作类型不能为空！");
        }

        List<String> monthBudgetCodeList = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<SubComMonthBudgetEntity> budgetEntityList = subComMonthBudgetRepository.listByCodes(monthBudgetCodeList);
        if (budgetEntityList.size() < monthBudgetCodeList.size()) {
            List<String> existsCodes = budgetEntityList.stream().map(SubComMonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
            String notExistsJoinCodesStr = monthBudgetCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("预算操作失败，分子公司月度预算[" + notExistsJoinCodesStr + "]查询失败，请检查预算是否启用或是否存在！！");
        }
        return budgetEntityList.stream().collect(Collectors.toMap(SubComMonthBudgetEntity::getMonthBudgetCode, Function.identity()));
    }

    /**
     * 分子公司划拨
     *
     * @param dto
     * @author huojia
     * @date 2022/11/8 10:36
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transfer(SubComMonthBudgetTransferDto dto) {
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getMonthBudgetCode(), "分子公司月度预算编码不能为空！");
        Validate.notEmpty(dto.getDetailDtoList(), "操作明细不能为空！");
        // 查询当前分子公司月度预算
        SubComMonthBudgetEntity subComMonthBudgetEntity = subComMonthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), EnableStatusEnum.ENABLE.getCode());
        Validate.notNull(subComMonthBudgetEntity, "当前预算不存在或未启用，请刷新后重试！");
        List<SubComMonthBudgetEntity> dimensionBudgetList = new ArrayList<>();
        // 查询同维度的预算，存在则直接划拨；不存在则新增预算
        dto.getDetailDtoList().forEach(detailDto -> {
            SubComMonthBudgetDto subComMonthBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(detailDto, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            subComMonthBudgetDto.setYearMonthLy(subComMonthBudgetEntity.getYearMonthLy());
            // 不应该自己划拨到自己
            // 如果寻到拨出的分子公司月度预算，则表明选择拨入维度时，选择的值和拨出预算完全一致（组织、客户等字段），拨入预算的值不应该和拨出预算完全一致
            List<SubComMonthBudgetEntity> monthBudgetEntityList = this.findByDimension(subComMonthBudgetDto);
            if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
                // 没查询到当前维度分子公司月度预算，则新增分子公司月度预算
                SubComMonthBudgetEntity addMonthBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailDto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
                addMonthBudgetEntity.setYearMonthLy(subComMonthBudgetEntity.getYearMonthLy());
                addMonthBudgetEntity.setAdjustAmount(detailDto.getTransferAmount());
                addMonthBudgetEntity.setCurrentBalanceAmount(detailDto.getTransferAmount());
                dimensionBudgetList.add(addMonthBudgetEntity);
            } else {
                log.info("查询同维度分子公司月度预算成功，共查询到" + monthBudgetEntityList.size() + "条");
                SubComMonthBudgetEntity dimensionBudget = monthBudgetEntityList.get(0);
                if (StringUtils.equals(subComMonthBudgetEntity.getMonthBudgetCode(), dimensionBudget.getMonthBudgetCode())) {
                    throw new RuntimeException("划拨失败，预算" + subComMonthBudgetEntity.getMonthBudgetCode() + "不能划拨至预算" + dimensionBudget.getMonthBudgetCode());
                }
                dimensionBudget.setAdjustAmount(Optional.ofNullable(dimensionBudget.getAdjustAmount()).orElse(BigDecimal.ZERO).add(detailDto.getTransferAmount()));
                dimensionBudget.setCurrentBalanceAmount(dimensionBudget.getCurrentBalanceAmount().add(detailDto.getTransferAmount()));
                dimensionBudgetList.add(dimensionBudget);
            }
        });
        boolean lockFlag = true;
        List<String> lockKeys = new ArrayList<>();
        // 批量加锁，只能在这个时候加锁，会不会有问题呢？考虑到用的mysql，事务隔离级别为可重复读，那么加锁的地方不重要，只要保证执行 finally 后方法就立刻结束即可
        if (!CollectionUtils.isEmpty(dimensionBudgetList)) {
            lockKeys = dimensionBudgetList.stream().map(SubComMonthBudgetEntity::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toList());
        }
        lockKeys.add(dto.getMonthBudgetCode());
        try {
            lockFlag = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
            // 拨出
            BigDecimal transferAmount = dto.getDetailDtoList().stream().map(SubComMonthBudgetTransferDetailDto::getTransferAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(transferAmount));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(transferAmount));
            dimensionBudgetList.add(subComMonthBudgetEntity);
            subComMonthBudgetRepository.saveOrUpdateBatch(dimensionBudgetList);
        } finally {
            if (lockFlag) {
                monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    /**
     * 根据预算项目编码查询分子公司月度预算
     *
     * @param budgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo>
     * @author huojia
     * @date 2022/11/12 11:55
     **/
    @Override
    public List<SubComMonthBudgetVo> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.subComMonthBudgetRepository.listByBudgetItemCodeList(budgetItemCodeList);
        if (CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(subComMonthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class));
    }

    /**
     * 根据预算编码查询分子公司月度预算
     *
     * @param budgetCodeList
     * @return
     */
    @Override
    public List<SubComMonthBudgetVo> listByBudgetCodeList(List<String> budgetCodeList) {
        if (CollectionUtils.isEmpty(budgetCodeList)) {
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetEntity> monthBudgetEntityList = this.subComMonthBudgetRepository.listByCodes(budgetCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List<SubComMonthBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 手动执行滚动
     *
     * @param ids
     * @author huojia
     * @date 2022/11/23 20:04
     **/
    @Override
    public void manualRolling(List<String> ids) {
        Validate.notEmpty(ids, "请选择要手工执行滚动的数据！");
        List<SubComMonthBudgetEntity> asyncList = this.subComMonthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(asyncList)) {
            throw new RuntimeException("当前数据不存在，请检查！");
        }
        this.calRolling(ids);

    }

    /**
     * 计算分子公司月度预算滚动
     *
     * @param ids
     * @author huojia
     * @date 2022/11/23 20:14
     **/
    @Override
    public void calRolling(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.subComMonthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        List<String> subComMonthBudgetCodeList = subComMonthBudgetEntityList.stream().map(SubComMonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
        boolean lock = true;
        try {
            lock = monthBudgetLockService.lock(subComMonthBudgetCodeList, TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME);
            Validate.isTrue(lock, "手动执行滚动失败，当前预算正在操作中，请稍后！");
            // 查询预算管控配置，执行手动滚动
            DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
            dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
            dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List<DimensionControlsVo> dimensionControlsVos = dimensionControlsService.listByConditions(dimensionControlsDto);
            if (CollectionUtils.isEmpty(dimensionControlsVos)) {
                return;
            }
            Map<String, List<DimensionControlsVo>> controlMap = dimensionControlsVos.stream()
                    .collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode()));
            AtomicReference<String> rollingType = new AtomicReference<>("");
            AtomicReference<String> isRolling = new AtomicReference<>(BooleanEnum.FALSE.getCapital());
            // 查询对应管控配置，根据管控判断是否滚动
            subComMonthBudgetEntityList.forEach(subComMonthBudgetEntity -> {
                String controlKey = subComMonthBudgetEntity.getBusinessFormatCode() + subComMonthBudgetEntity.getBusinessUnitCode();
                if (controlMap.containsKey(controlKey)) {
                    List<DimensionControlsVo> dimensionControlsList = controlMap.get(controlKey);
                    dimensionControlsList.forEach(dimensionControlsVo -> {
                        if (!CollectionUtils.isEmpty(dimensionControlsVo.getBudgetItemCodeList())
                                && dimensionControlsVo.getBudgetItemCodeList().contains(subComMonthBudgetEntity.getBudgetItemCode())) {
                            rollingType.set(dimensionControlsVo.getRollingType());
                            isRolling.set(dimensionControlsVo.getIfRolling());
                        }
                    });
                }
                // 查询同一年度预算对应上一月的月度预算，没查询到表示跨年了，不进行计算
                SubComMonthBudgetDto subComMonthBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
                Date date = DateUtil.formatAddMonth(DateUtil.parseDate(subComMonthBudgetDto.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH), -1);
                int lastMonthYear = DateUtil.getDaysOfYear(date);
                int curYear = DateUtil.getDaysOfYear(DateUtil.parseDate(subComMonthBudgetDto.getYearMonthLy(), DateUtil.DEFAULT_YEAR_MONTH));
                // 跨年不滚动
                if (lastMonthYear != curYear) {
                    return;
                }
                subComMonthBudgetDto.setYearMonthLy(DateUtil.format(date, DateUtil.DEFAULT_YEAR_MONTH));
                List<SubComMonthBudgetEntity> dimensions = this.findByDimension(subComMonthBudgetDto);
                if (CollectionUtils.isEmpty(dimensions)) {
                    subComMonthBudgetEntity.setLastMonthRollingAmount(BigDecimal.ZERO);
                    return;
                }
                SubComMonthBudgetEntity lastMonthBudget = dimensions.get(0);
                if (BooleanEnum.TRUE.getCapital().equals(isRolling.get())) {
                    // 回滚上次滚动金额
                    BigDecimal lastRolling = Optional.ofNullable(subComMonthBudgetEntity.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO);
                    // a-全部滚动：等于同一维度下M-1月（不跨年）的月度累计可用金额（不判断正负数）；
                    if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType.get())) {
                        subComMonthBudgetEntity.setLastMonthRollingAmount(lastMonthBudget.getCurrentBalanceAmount());
                        subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(subComMonthBudgetEntity.getLastMonthRollingAmount()).subtract(lastRolling));
                    }
                    // b-结余滚动：判断M-1月累计可用金额是否正数，为正数才计入M月的上月滚动金额字段；
                    if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType.get())) {
                        if (BigDecimal.ZERO.compareTo(lastMonthBudget.getCurrentBalanceAmount()) < 0) {
                            subComMonthBudgetEntity.setLastMonthRollingAmount(lastMonthBudget.getCurrentBalanceAmount());
                            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(subComMonthBudgetEntity.getLastMonthRollingAmount()).subtract(lastRolling));
                        }
                    }
                    // c-超支滚动：判断M-1月累计可用金额是否负数，为负数才计入M月的上月滚动金额字段；
                    if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType.get())) {
                        if (BigDecimal.ZERO.compareTo(lastMonthBudget.getCurrentBalanceAmount()) > 0) {
                            subComMonthBudgetEntity.setLastMonthRollingAmount(lastMonthBudget.getCurrentBalanceAmount());
                            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(subComMonthBudgetEntity.getLastMonthRollingAmount()).subtract(lastRolling));
                        }
                    }
                } else {
                    subComMonthBudgetEntity.setLastMonthRollingAmount(BigDecimal.ZERO);
                }
            });
            this.subComMonthBudgetRepository.updateBatchById(subComMonthBudgetEntityList);
        } finally {
            if (lock) {
                monthBudgetLockService.unLock(subComMonthBudgetCodeList);
            }
        }
    }

    @Override
    public Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Page<MonthBudgetExamineCircularQueryVo> page, MonthBudgetExamineCircularQueryDto dto) {
        return subComMonthBudgetMapper.findExamineCircularByConditions(page, dto);
    }

    /**
     * 分子公司活动规划生成分子公司月度预算
     *
     * @param subComMonthBudgetDtoList
     * @author huojia
     * @date 2022/12/8 23:12
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<SubComMonthBudgetVo> designMonthBudget(List<SubComMonthBudgetDto> subComMonthBudgetDtoList) {
        if (CollectionUtils.isEmpty(subComMonthBudgetDtoList)) {
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetVo> subComMonthBudgetVoList = new ArrayList<>();
//        String ruleCode = StringUtils.join(MonthBudgetConstant.SUB_COM_MONTH_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> codeList = generateCodeService.generateCode(MonthBudgetConstant.SUB_COM_MONTH_BUDGET_CODE, subComMonthBudgetDtoList.size(), 8, 2, TimeUnit.DAYS);
        Iterator<String> iterator = codeList.iterator();

        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = new ArrayList<>();
        List<SubComMonthBudgetDetailEntity> initList = new ArrayList<>();
        List<SubComMonthBudgetDetailEntity> approvedDetailList = new ArrayList<>();
        List<SubComMonthBudgetPlanBudgetEntity> planBudgetEntityList = new ArrayList<>();

        subComMonthBudgetDtoList.forEach(subComMonthBudgetDto -> {
            subComMonthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
            subComMonthBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            subComMonthBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            subComMonthBudgetDto.setMonthBudgetCode(iterator.next());
            // 保存分子公司月度预算
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetDto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
            subComMonthBudgetEntity.setDataSource(DataSourceEnum.AUTO.getCode());
            subComMonthBudgetEntityList.add(subComMonthBudgetEntity);
            SubComMonthBudgetVo subComMonthBudgetVo = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class);
            List<SubComMonthBudgetPlanBudgetVo> planBudgetVos = (List<SubComMonthBudgetPlanBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                    subComMonthBudgetDto.getPlanBudgetList(), SubComMonthBudgetPlanBudgetDto.class, SubComMonthBudgetPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class
            );
            subComMonthBudgetVo.setPlanBudgetList(planBudgetVos);
            subComMonthBudgetVoList.add(subComMonthBudgetVo);
            // 生成预算明细
            // 月度预算生成期初操作明细
            SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetEntity, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
            subComMonthBudgetDetailEntity.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
            subComMonthBudgetDetailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
            initList.add(subComMonthBudgetDetailEntity);
            // 月度预算生成批复明细
            SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, subComMonthBudgetEntity.getApprovedAmount(), BudgetOperationTypeEnum.USE.getCode(), "");
            SubComMonthBudgetDetailEntity approvedDetail = nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetDetailDto, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class);
            approvedDetail.setId(null);
            approvedDetailList.add(approvedDetail);

            // 生成方案、细案预算对应明细
            List<SubComMonthBudgetPlanBudgetDto> planBudgetList = subComMonthBudgetDto.getPlanBudgetList();
            if (!CollectionUtils.isEmpty(planBudgetList)) {
                List<SubComMonthBudgetPlanBudgetEntity> subComMonthBudgetPlanBudgetEntityList = (List<SubComMonthBudgetPlanBudgetEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(
                        planBudgetList, SubComMonthBudgetPlanBudgetDto.class, SubComMonthBudgetPlanBudgetEntity.class, LinkedHashSet.class, ArrayList.class
                );
                subComMonthBudgetPlanBudgetEntityList.forEach(subComMonthBudgetPlanBudgetEntity -> {
                    subComMonthBudgetPlanBudgetEntity.setId(null);
                    subComMonthBudgetPlanBudgetEntity.setMonthBudgetCode(subComMonthBudgetDto.getMonthBudgetCode());
                    subComMonthBudgetPlanBudgetEntity.setTenantCode(TenantUtils.getTenantCode());
                    subComMonthBudgetPlanBudgetEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                });
                planBudgetEntityList.addAll(subComMonthBudgetPlanBudgetEntityList);
            }

            subComMonthBudgetDto.setId(subComMonthBudgetEntity.getId());
            // 业务日志新增
            SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(subComMonthBudgetDto);
            SerializableBiConsumer<SubComMonthBudgetLogEventListener, SubComMonthBudgetLogEventDto> onCreate =
                    SubComMonthBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, SubComMonthBudgetLogEventListener.class, onCreate);
        });
        //根据预算预测修改批复金额=对应预算预测预算金额,本期结余金额=批复金额+调整金额-冻结金额
        if (!CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            Set<String> onlykeys = subComMonthBudgetEntityList.stream().map(
                    o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode()).collect(Collectors.toSet());
            List<SubComBudgetForecastVo> forecastVos = this.subComBudgetForecastService.listByOnlyKeys(new ArrayList<>(onlykeys));
            Map<String, BigDecimal> forMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(forecastVos)) {
                forMap = forecastVos.stream().collect(Collectors.toMap(
                        o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode(),
                        SubComBudgetForecastVo::getBudgetAmount,
                        (oldV, newV) -> newV
                ));
            }
            for (SubComMonthBudgetEntity budgetEntity : subComMonthBudgetEntityList) {
                String key = budgetEntity.getYearMonthLy() + budgetEntity.getBusinessFormatCode() +
                        budgetEntity.getBusinessUnitCode() + budgetEntity.getOrgCode() + budgetEntity.getFeeSourceCode();
                if (forMap.containsKey(key) && null != forMap.get(key)) {
                    budgetEntity.setApprovedAmount(forMap.get(key));
                }
                budgetEntity.setCurrentBalanceAmount(Optional.ofNullable(budgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)
                        .add(Optional.ofNullable(budgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO))
                        .subtract(Optional.ofNullable(budgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO))
                );
            }
        }
        this.subComMonthBudgetRepository.saveBatch(subComMonthBudgetEntityList);
        this.subComMonthBudgetDetailRepository.saveBatch(initList);
        this.subComMonthBudgetDetailRepository.saveBatch(approvedDetailList);
        this.subComMonthBudgetPlanBudgetRepository.saveBatch(planBudgetEntityList);
        return subComMonthBudgetVoList;
    }

    /**
     * 生成方案、细案对应明细
     *
     * @param subComMonthBudgetDto
     * @author huojia
     * @date 2022/12/8 23:23
     **/
    private void buildPlanDetail(SubComMonthBudgetDto subComMonthBudgetDto) {
        List<SubComMonthBudgetPlanBudgetDto> planBudgetList = subComMonthBudgetDto.getPlanBudgetList();
        if (CollectionUtils.isEmpty(planBudgetList)) {
            return;
        }
        List<SubComMonthBudgetPlanBudgetEntity> subComMonthBudgetPlanBudgetEntityList = (List<SubComMonthBudgetPlanBudgetEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(
                planBudgetList, SubComMonthBudgetPlanBudgetDto.class, SubComMonthBudgetPlanBudgetEntity.class, LinkedHashSet.class, ArrayList.class
        );
        subComMonthBudgetPlanBudgetEntityList.forEach(subComMonthBudgetPlanBudgetEntity -> {
            subComMonthBudgetPlanBudgetEntity.setId(null);
            subComMonthBudgetPlanBudgetEntity.setMonthBudgetCode(subComMonthBudgetDto.getMonthBudgetCode());
            subComMonthBudgetPlanBudgetEntity.setTenantCode(TenantUtils.getTenantCode());
            subComMonthBudgetPlanBudgetEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        subComMonthBudgetPlanBudgetRepository.saveBatch(subComMonthBudgetPlanBudgetEntityList);
    }

    /**
     * 同维度
     *
     * @param subComMonthBudgetDto
     * @return java.util.List<com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity>
     * @author huojia
     * @date 2022/11/8 10:46
     **/
    private List<SubComMonthBudgetEntity> findByDimension(SubComMonthBudgetDto subComMonthBudgetDto) {
        Validate.notNull(subComMonthBudgetDto, "查询同维度的分子公司月度预算的请求参数不能为空！");
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = subComMonthBudgetMapper.findByDimension(subComMonthBudgetDto);
        return subComMonthBudgetEntityList;
    }

    /**
     * 编辑时校验字段必填
     *
     * @param dto
     * @author huojia
     * @date 2022/10/31 22:38
     **/
    private void updateValidate(SubComMonthBudgetDto dto) {
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getId(), "编辑数据时，id不能为空！");
        dto.setExcludeCode(dto.getMonthBudgetCode());
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.findByDimension(dto);
        if (!CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            throw new RuntimeException("当前预算维度已存在！");
        }
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailService.listByMonthBudgetCode(dto.getMonthBudgetCode());
        if (subComMonthBudgetDetailEntityList.size() > 1) {
            throw new RuntimeException("当前预算已存在明细，无法编辑！");
        }
        // 根据维度校验字段
        /*DimensionInformationQueryData dimensionVo = new DimensionInformationQueryData();
        dimensionVo.setBusinessState(dto.getBusinessFormatCode());
        dimensionVo.setBusinessUnit(dto.getBusinessUnitCode());
        dimensionVo.setMenu(MenuCodeEnum.SUB_COM_MONTH_BUDGET.getCode());
        List<DimensionDimensionInformationVo> dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dimensionVo);
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("未维护对应维度配置数据，请检查！");
        }
        Class<SubComMonthBudgetDto> clazz = SubComMonthBudgetDto.class;
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(dto);
                if (ObjectUtils.isEmpty(o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        });*/
    }

    /**
     * 大批量保存
     *
     * @param importList 导入数据列表
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void bulkImportSave(List<SubComMonthBudgetDto> importList) {
        try {
            if (CollectionUtils.isEmpty(importList)) {
                return;
            }
            //设置基础信息
            AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
            Date date = new Date();
            //循环设置信息并区分编辑和新增数据
            List<SubComMonthBudgetDto> addList = new ArrayList<>();
            List<SubComMonthBudgetDto> editList = new ArrayList<>();
            for (SubComMonthBudgetDto dto : importList) {
                dto.setCurrentBalanceAmount(dto.getBudgetAmount());
                if (StringUtils.isNotBlank(dto.getId())) {
                    dto.setModifyAccount(loginDetails.getUsername());
                    dto.setModifyName(loginDetails.getRealName());
                    dto.setModifyTime(date);
                    editList.add(dto);
                } else {
                    dto.setCreateAccount(loginDetails.getUsername());
                    dto.setCreateName(loginDetails.getRealName());
                    dto.setCreateTime(date);
                    dto.setTenantCode(loginDetails.getTenantCode());
                    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    //自动生成、手动添加
                    dto.setDataSource(DataSourceEnum.MANUAL.getCode());
                    addList.add(dto);
                }
            }
            //新增数据
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("开始执行大批量保存-----------------新增数据条数：{}", editList.size());
//                String ruleCode = StringUtils.join(MonthBudgetConstant.SUB_COM_MONTH_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
                List<String> codes = this.generateCodeService.generateCode(MonthBudgetConstant.SUB_COM_MONTH_BUDGET_CODE, addList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < addList.size(); i++) {
                    SubComMonthBudgetDto budgetDto = addList.get(i);
                    budgetDto.setMonthBudgetCode(codes.get(i));
                }
                Collection<SubComMonthBudgetEntity> adds = this.nebulaToolkitService.copyCollectionByWhiteList(
                        addList, SubComMonthBudgetDto.class, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
                List<SubComMonthBudgetEntity> rateList = (List<SubComMonthBudgetEntity>) adds;
                //分批保存
                List<List<SubComMonthBudgetEntity>> rates = Lists.partition(rateList, 500);
                for (List<SubComMonthBudgetEntity> list : rates) {

                    this.subComMonthBudgetRepository.saveBatch(list);
                }
            }
            //更新数据
            List<SubComMonthBudgetLogEventDto> editLogs = new ArrayList<>();
            if (!CollectionUtils.isEmpty(editList)) {
                log.info("开始执行大批量保存-----------------编辑数据条数：{}", editList.size());
                //分批保存
                List<List<SubComMonthBudgetDto>> rates = Lists.partition(editList, 500);
                for (List<SubComMonthBudgetDto> list : rates) {
                    List<String> ids = list.stream().map(SubComMonthBudgetDto::getId).collect(Collectors.toList());
                    List<SubComMonthBudgetEntity> oldList = this.subComMonthBudgetRepository.lambdaQuery()
                            .in(SubComMonthBudgetEntity::getId, ids)
                            .eq(SubComMonthBudgetEntity::getTenantCode, TenantUtils.getTenantCode())
                            .list();
                    Collection<SubComMonthBudgetDto> oldDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(
                            oldList, SubComMonthBudgetEntity.class, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
                    Map<String, SubComMonthBudgetDto> oldMap = oldDtoList.stream().collect(Collectors.toMap(SubComMonthBudgetDto::getId, Function.identity()));
                    for (SubComMonthBudgetDto dto : list) {
                        SubComMonthBudgetLogEventDto eventDto = new SubComMonthBudgetLogEventDto();
                        eventDto.setNewest(dto);
                        eventDto.setOriginal(oldMap.getOrDefault(dto.getId(), new SubComMonthBudgetDto()));
                        editLogs.add(eventDto);
                    }
                    Collection<SubComMonthBudgetEntity> res = this.nebulaToolkitService.copyCollectionByWhiteList(
                            list, SubComMonthBudgetDto.class, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
                    this.subComMonthBudgetRepository.updateBatchByIdAndTenantCode(res, TenantUtils.getTenantCode());
                }
            }

            //新增日志
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("开始执行大批量保存-----------------新增日志");
                subComMonthBudgetLogService.addLogAsync(addList);
            }
            //编辑日志
            if (!CollectionUtils.isEmpty(editLogs)) {
                log.info("开始执行大批量保存-----------------编辑日志");
                subComMonthBudgetLogService.updateLogAsync(editLogs);
            }
        } catch (Exception e) {
            log.error("", e);
            throw new NullPointerException(e.getMessage());
        }
    }

    @Override
    public List<SubComMonthBudgetVo> listByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetEntity> monthBudgetEntityList = this.subComMonthBudgetRepository.listByCodes(codes);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List<SubComMonthBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                monthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    /**
     * 删除数据
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<SubComMonthBudgetEntity> entityList = subComMonthBudgetRepository.findByIds(ids);
        Assert.notEmpty(entityList, "删除的数据不存在,请刷新重试!");
        entityList.forEach(entity -> {
            Validate.isTrue(!DataSourceEnum.AUTO.getCode().equals(entity.getDataSource()), "自动生成的数据不可删除！");
        });
        subComMonthBudgetRepository.deleteById(ids);
    }

    @Override
    public List<SubComMonthBudgetVo> findListByCondition(SubComMonthBudgetDto subComMonthBudgetDto) {
        if(Objects.isNull(subComMonthBudgetDto)){
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = subComMonthBudgetRepository.findListByCondition(subComMonthBudgetDto);
        if(CollectionUtils.isEmpty(subComMonthBudgetEntityList)){
            return Lists.newArrayList();
        }else {
            return (List<SubComMonthBudgetVo>)this.nebulaToolkitService.copyCollectionByWhiteList(subComMonthBudgetEntityList,SubComMonthBudgetEntity.class,SubComMonthBudgetVo.class,LinkedHashSet.class,ArrayList.class);
        }
    }

    /**
     * 根据分子预算预测更新自动生成的分子月度预算
     *
     * @param forecastMap 维度map
     */
    @Override
    public void updateSubComMonthBudgetByBudgetForecast(Map<String, BigDecimal> forecastMap) {
        if (forecastMap.isEmpty()) {
            return;
        }
        List<String> onlyKeys = new ArrayList<>(forecastMap.keySet());
        List<SubComMonthBudgetEntity> list = this.subComMonthBudgetRepository.listByOnlyKeys(onlyKeys);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (SubComMonthBudgetEntity entity : list) {
            String key = entity.getYearMonthLy() + entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getOrgCode() + entity.getFeeSourceCode()+entity.getBudgetItemCode();
            if (forecastMap.containsKey(key)) {
                entity.setApprovedAmount(Optional.ofNullable(forecastMap.get(key)).orElse(BigDecimal.ZERO));
                entity.setCurrentBalanceAmount(
                        Optional.ofNullable(entity.getApprovedAmount()).orElse(BigDecimal.ZERO)
                                .add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO))
                                .subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO))
                );
            }
        }
        this.subComMonthBudgetRepository.updateBatchById(list);
    }

    @Override
    public Page<SubComMonthBudgetVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        if(CollectionUtils.isEmpty(yearMonthList)){
            return new Page<>(0,0);
        }
        return this.subComMonthBudgetRepository.findBySonCompanyBudgetWarn(pageable,yearMonthList,orgCode,saleCompanyCode,channelCode,saleGroupCode,customerCode,budgetItemCode);
    }
}
