package com.biz.crm.tpm.business.month.budget.local.service.listener;

import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.FieldsDimenDiameterEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.event.DimensionControlsEventListener;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.local.service.FieldsDimenDiameterGroupStrategy;
import com.biz.crm.tpm.business.month.budget.local.service.TimeDimensionGroupStrategy;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author : 预算管控配置新增通知月度改变 预算管控可用余额  注：现阶段根产品沟通只实现正向流程 并且只管新增预算管控时 改变 预算管控可用余额
 * 可覆盖。不是准确的。后续开发人员注意。
 * @author : rentao
 * @date : 2023/1/19 9:11
 */
@Slf4j
@Component
public class ChangeControlBalanceAmountEventListener implements DimensionControlsEventListener {

  @Autowired
  private BudgetItemService budgetItemService;
  @Autowired
  private MonthBudgetService monthBudgetService;
  @Autowired(required = false)
  private List<FieldsDimenDiameterGroupStrategy> fieldsDimenDiameterGroupStrategies;
  @Autowired(required = false)
  private List<TimeDimensionGroupStrategy> timeDimensionGroupStrategies;

  /**
   * 场景1：预算项目选择三级预算项目，字段维度【部门】、【客户】，时间维度【月度】
   * 场景2：预算项目选择三级级预算项目，字段维度【部门】、【客户】，时间维度【季度】
   * 场景3：预算项目选择三级预算项目，字段维度【部门】、【客户】，时间维度【年度】
   * 场景4：预算项目选择三级预算项目，字段维度【部门】，时间维度【月度】
   * 场景5：预算项目选择三级预算项目，字段维度【部门】，时间维度【季度】
   * 场景6：预算项目选择三级级预算项目，字段维度【部门】，时间维度【年度】
   * 场景7：预算项目选择二级预算项目【陈列】，字段维度【部门】、【客户】，时间维度【月度】
   * 场景8：预算项目选择二级预算项目【陈列】，字段维度【部门】，时间维度【月度】
   * 注：与产品本版沟通后 这里只是保存数据，并且关联 controlsConfigCode 管控配置编码。统计金额。
   * 并且后续新增月度预算增加数据也不会对应增加，如有需求变更 后续开发人员需处理此问题点。
   * <p>
   * 1,获取管控配置中关联预算项目所有预算项目编码（包括子集）
   * 2,查询关联的月度预算,并通过字段维度筛选。
   * 3,通过时间维度，和最小统计单位（字段维度 com.biz.crm.tpm.business.budget.controls.config.sdk.enums.FieldsDimenDiameterEnum 中sorts）统计金额
   * 4,写入 FieldsDimenDiameterGroupStrategy
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void onCreate(DimensionControlsVo dimensionControlsVo) {
    String fieldsDimensionalitys = dimensionControlsVo.getFieldsDimensionality();
    String timeDimension = dimensionControlsVo.getTimeDimension();
    String[] split = fieldsDimensionalitys.split(",");
    List<String> fieldsDimensionality = Lists.newArrayList(split);
    List<String> budgetItemCodeList = dimensionControlsVo.getBudgetItemCodeList();
    if (dimensionControlsVo.getControlType().equals(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())) {
      //1
      List<BudgetItemVo> budgetItemVos = budgetItemService.listByParent(budgetItemCodeList);
      if (!CollectionUtils.isEmpty(budgetItemVos)) {
        List<String> budgetItemCodes = budgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
        budgetItemCodeList.addAll(budgetItemCodes);
      }
      //2
      List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByBudgetItemCodeList(budgetItemCodeList);
      List<MonthBudgetVo> monthBudgetVoList = this.screenMonthBudgetVo(monthBudgetVos, fieldsDimensionality);
      //3
      Map<String, List<MonthBudgetVo>> groupMap = monthBudgetVoList.stream().collect(Collectors.groupingBy(MonthBudgetVo::getBudgetItemCode));
      //得到分组后的集合
      for (String s : fieldsDimensionality) {
        List<FieldsDimenDiameterGroupStrategy> fieldsDimenDiameterGroupStrategyList = fieldsDimenDiameterGroupStrategies.stream()
                .filter(fieldsDimenDiameterGroupStrategy -> fieldsDimenDiameterGroupStrategy.getFieldsDimenDiameterCode().equals(s))
                .collect(Collectors.toList());
        FieldsDimenDiameterGroupStrategy fieldsDimenDiameterGroupStrategy = fieldsDimenDiameterGroupStrategyList.get(0);
        groupMap = fieldsDimenDiameterGroupStrategy.onFieldsDimenDiameterGroup(groupMap);
      }
      List<TimeDimensionGroupStrategy> timeDimensionGroupStrategyList = timeDimensionGroupStrategies.stream()
              .filter(timeDimensionGroupStrategy -> timeDimensionGroupStrategy.getTimeDimensionCode().equals(timeDimension))
              .collect(Collectors.toList());
      TimeDimensionGroupStrategy timeDimensionGroupStrategy = timeDimensionGroupStrategyList.get(0);
      groupMap = timeDimensionGroupStrategy.onTimeDimensionGroup(groupMap);
      //4
      for (String code:groupMap.keySet()){
        List<MonthBudgetVo> budgetVos = groupMap.get(code);
        BigDecimal amount = budgetVos.stream().map(MonthBudgetVo::getAccumulatedAvailableBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        Set<String> ids = budgetVos.stream().map(MonthBudgetVo::getId).collect(Collectors.toSet());
        monthBudgetService.updateControlBalanceAmountByIds(ids,amount);
      }
    }
  }

  /**
   * 查询关联的月度预算,并通过字段维度筛选。
   * 得到符合条件的 月度预算。
   *
   * @param fieldsDimensionality 字段维度
   * @param monthBudgetVos       未筛选的月度预算集合
   */
  private List<MonthBudgetVo> screenMonthBudgetVo(List<MonthBudgetVo> monthBudgetVos, List<String> fieldsDimensionality) {
    List<MonthBudgetVo> monthBudgetVoList = Lists.newArrayList();
    if (!CollectionUtils.isEmpty(monthBudgetVos) && !CollectionUtils.isEmpty(fieldsDimensionality)) {
      for (String s : fieldsDimensionality) {
        FieldsDimenDiameterEnum dimenDiameterEnum = FieldsDimenDiameterEnum.codeToEnum(s);
        //验证筛选
        switch (dimenDiameterEnum) {
          case TISSUE:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getSalesOrgCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getSalesOrgCode())).collect(Collectors.toList());
            }
            break;
          case DEPARTMENT:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getOrgCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getOrgCode())).collect(Collectors.toList());
            }
            break;
          case CHANNEL:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getCustomerChannelCode()) || StringUtils.isNoneBlank(monthBudgetVo.getTerminalChannelCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getCustomerChannelCode()) || StringUtils.isNoneBlank(monthBudgetVo.getTerminalChannelCode())).collect(Collectors.toList());
            }
            break;
          case SYSTEM:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getSystemCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getSystemCode())).collect(Collectors.toList());
            }
            break;
          case REGION:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getRegionCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getRegionCode())).collect(Collectors.toList());
            }
            break;
          case CLIEN:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getCustomerCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getCustomerCode())).collect(Collectors.toList());
            }
            break;
          case BRAND:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductBrandCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductBrandCode())).collect(Collectors.toList());
            }
            break;
          case SHOP:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getTerminalCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getTerminalCode())).collect(Collectors.toList());
            }
            break;
          case CATEGORY:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductCategoryCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductCategoryCode())).collect(Collectors.toList());
            }
            break;
          case ITEM:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductItemCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductItemCode())).collect(Collectors.toList());
            }
            break;
          case PRODUCT:
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
              monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductCode())).collect(Collectors.toList());
            } else {
              monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank(monthBudgetVo.getProductCode())).collect(Collectors.toList());
            }
            break;
        }
      }
    }
    return monthBudgetVoList;
  }


}
