package com.biz.crm.tpm.business.month.budget.local.service.listener;

import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetCallBackService;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 月度预算调整 回调监听器
 *
 * @author huojia
 * @date 2022年11月12日 16:47
 */
@Slf4j
@Component
public class SubComAdjustMonthBudgetCompleteListener implements ProcessCompleteListener {

    @Resource
    private SubComMonthBudgetCallBackService subComMonthBudgetCallBackService;

    @Override
    public String getBusinessCode() {
        return MonthBudgetConstant.SUB_COM_ADJUST_MONTH_BUDGET;
    }

    /**
     * 调整回调
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 16:49
     **/
    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notNull(dto, "分子公司月度预算调整回调失败，请求参数不能为空！");
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            subComMonthBudgetCallBackService.adjustPass(dto);
        }
        //审批驳回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            subComMonthBudgetCallBackService.adjustRejectAndRecover(dto);
        }
        //流程追回
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            subComMonthBudgetCallBackService.adjustRejectAndRecover(dto);
        }
    }
}
