package com.biz.crm.tpm.business.month.budget.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @Description 销售计划定时任务通知
 * @Author YangWei
 * @Date 2023/3/1 上午10:43
 */
@Slf4j
@Component
public class SalesPlanJobEventListenerImpl implements SalesPlanJobEventListener {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    /**
     * 销售计划拉取 通知更新 下月月度预算计划量
     * @param param
     */
    @Override
    public void onPlan(SalesPlanLogEventDto param) {
        log.info("=====>    垂直计算计划量[{}] start    <=====", DateUtil.dateStrNowAll());
        SalesPlanDto newest = param.getNewest();
        String yearMonthLy = newest.getYearMonthLy();
        List<String> businessUnitCodeList = new ArrayList<>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        this.monthBudgetService.autoPlanReplay(yearMonthLy, businessUnitCodeList, BooleanEnum.TRUE.getCapital());
        log.info("=====>    垂直计算计划量[{}] end    <=====", DateUtil.dateStrNowAll());
    }

    /**
     * 销售计划拉取 通知更新 当前月度预算回复量
     * @param param
     */
    @Override
    public void onReplay(SalesPlanLogEventDto param) {

        log.info("=====>    垂直计算回复量[{}] start    <=====", DateUtil.dateStrNowAll());
        SalesPlanDto newest = param.getNewest();
        String yearMonthLy = newest.getYearMonthLy();
        List<String> businessUnitCodeList = new ArrayList<>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        monthBudgetService.autoPlanReplay(yearMonthLy, businessUnitCodeList, BooleanEnum.FALSE.getCapital());
        log.info("=====>    垂直计算回复量[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}