package com.biz.crm.tpm.business.month.budget.local.service.strategy;

import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.TimeDimension;
import com.biz.crm.tpm.business.month.budget.local.service.TimeDimensionGroupStrategy;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 月度分组
 * @author : rentao
 * @date : 2023/1/19 21:56
 */
public class MonthTimeDimensionGroupStrategy implements TimeDimensionGroupStrategy {
  @Override
  public String getTimeDimensionCode() {
    return TimeDimension.MONTHLY.getCode();
  }

  @Override
  public String getTimeDimensionName() {
    return TimeDimension.MONTHLY.getName();
  }

  @Override
  public Map<String, List<MonthBudgetVo>> onTimeDimensionGroup(Map<String, List<MonthBudgetVo>> oldMap) {
    Map<String, List<MonthBudgetVo>> listMap = new HashMap<>();
    for (String oldKey : oldMap.keySet()) {
      List<MonthBudgetVo> monthBudgetVoList1 = oldMap.get(oldKey);
      //组织编码分组后的
      Map<String, List<MonthBudgetVo>> shareInfoGroups = monthBudgetVoList1.stream().collect(Collectors.groupingBy(MonthBudgetVo::getYearMonthLy));
      for (String key : shareInfoGroups.keySet()) {
        String newKey = oldKey + "," + key;
        listMap.put(newKey, shareInfoGroups.get(key));
      }
    }
    return listMap;
  }
}
