package com.biz.crm.tpm.business.month.budget.local.service.strategy;

import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.FieldsDimenDiameterEnum;
import com.biz.crm.tpm.business.month.budget.local.service.FieldsDimenDiameterGroupStrategy;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 组织维度的分组
 *
 * @author : rentao
 * @date : 2023/1/19 11:02
 */
@Component
public class OrgFieldsDimenDiameterGroupStrategy implements FieldsDimenDiameterGroupStrategy {


  @Override
  public String getFieldsDimenDiameterCode() {
    return FieldsDimenDiameterEnum.TISSUE.getCode();
  }

  @Override
  public String getFieldsDimenDiameterName() {
    return FieldsDimenDiameterEnum.TISSUE.getName();
  }

  @Override
  public Map<String, List<MonthBudgetVo>> onFieldsDimenDiameterGroup(Map<String, List<MonthBudgetVo>> oldMap) {
    Map<String, List<MonthBudgetVo>> listMap = new HashMap<>();
    for (String oldKey : oldMap.keySet()) {
      List<MonthBudgetVo> monthBudgetVoList1 = oldMap.get(oldKey);
      //组织编码分组后的
      Map<String, List<MonthBudgetVo>> shareInfoGroups = monthBudgetVoList1.stream().collect(Collectors.groupingBy(MonthBudgetVo::getOrgCode));
      for (String key : shareInfoGroups.keySet()) {
        String newKey = oldKey + "," + key;
        listMap.put(newKey, shareInfoGroups.get(key));
      }
    }
    return listMap;
  }
}
