package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 计算实际销量    job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class HeadActualSalesAutoSyncXxlJob {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 计算回复量
     */
    @DynamicTaskService(cornExpression = "0 0 2 1/1 1/1 ?", taskDesc = "主体计算实际销量定时任务")
    public void actualSalesAutoSyncXxlJob() {
        loginUserService.refreshAuthentication(null);

        log.info("=====>    主体、电商计算实际销量定时任务[{}] start    <=====", DateUtil.dateStrNowAll());
        List<String> businessUnitCodeList = new ArrayList<>();
        businessUnitCodeList.add(BusinessUnitEnum.HEADQUARTERS.getCode());
        businessUnitCodeList.add(BusinessUnitEnum.ONLINE.getCode());
        monthBudgetService.autoActualSales(DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH), businessUnitCodeList);
        log.info("=====>    主体、电商计算实际销量定时任务[{}] end    <=====", DateUtil.dateStrNowAll());
    }

}
