package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * 计算回复量    job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class HeadReplayAutoSyncXxlJob {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    private static final String LOCK_KEY = "REPLAY_AUTO_SYNC_XXL_JOB_";

    /**
     * 计算回复量 每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 1 1/1 1/1 ?", taskDesc = "主体计算回复量定时任务")
    public void replayAutoSyncXxlJob() {
        loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12);
            if (!lock) {
                return;
            }
            log.info("=====>    主体、电商计算回复量[{}] start    <=====", DateUtil.dateStrNowAll());

            List<String> businessUnitCodeList = new ArrayList<>();
            businessUnitCodeList.add(BusinessUnitEnum.HEADQUARTERS.getCode());
            businessUnitCodeList.add(BusinessUnitEnum.ONLINE.getCode());
            monthBudgetService.autoPlanReplay(DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH), businessUnitCodeList, BooleanEnum.FALSE.getCapital());

        }catch (Exception e){
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        }finally {
            log.info("=====>    主体、电商计算回复量[{}] end    <=====", DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

}
