package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;


/**
 * 计算年度累计可用金额    job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class HeadYearTotalAvailableBalanceSyncXxlJob {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    private static final String LOCK_KEY = "YEAR_TOTAL_AVAILABLE_BALANCE_SYNC_XXL_JOB_";

    /**
     * 计算年度累计可用金额  每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 2 1 * ?", taskDesc = "主体计算年度累计可用金额定时任务")
    public void calHeadYearTotalAvailableBalanceSyncXxlJob() {
        loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12);
            if (!lock) {
                return;
            }
            log.info("=====>    主体计算年度累计可用金额[{}] start    <=====", DateUtil.dateStrNowAll());

            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.MONTH,-1);
            String yearMonth = DateUtil.format(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
            monthBudgetService.calHeadYearTotalAvailableBalanceSyncXxlJob(yearMonth);

        }catch (Exception e){
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        }finally {
            log.info("=====>    主体计算年度累计可用金额[{}] end    <=====", DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

}
