package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * 计算实际销量    job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class VerticalActualSalesAutoSyncXxlJob {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    private static final String DAY = "02";

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    private static final String LOCK_KEY = "ACTUAL_SALES_AUTO_SYNC_XXL_JOB_";

    public String getLockKey() {
        return LOCK_KEY;
    }

    /**
     * 3、每月10、20、24、27号用实销量更新本月预算（如果实销量小于回复量，则不更新）；每月2号用实销量更新上月预算
     */
    @DynamicTaskService(cornExpression = "0 0 2 2,10,20,24,27 1/1 ?", taskDesc = "（垂直实销量）计算实销回复差定时任务")
    public void actualSalesAutoSyncXxlJob() {
        loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = this.getLockKey() + DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12);
            if (!lock) {
                return;
            }
            this.handle(null);
        } catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        } finally {
            log.info("=====>    垂直计算实际销量定时任务[{}] end    <=====", DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void handle(String yearMonth) {

        log.info("=====>    垂直计算实际销量定时任务[{}] start    <=====", DateUtil.dateStrNowAll());
        List<String> businessUnitCodeList = new ArrayList<>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        //时间处理
        Calendar cl = Calendar.getInstance();
        String yearMonthDay = DateUtil.format(cl.getTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String currDay = yearMonthDay.split("-")[2];
        if (DAY.equals(currDay)) {
            //二月更新上月月度预算
            cl.add(Calendar.MONTH, -1);
        }
        if (StringUtils.isEmpty(yearMonth)) {
            yearMonth = DateUtil.format(cl.getTime(), DateUtil.DEFAULT_YEAR_MONTH);
        }
        List<String> ids = monthBudgetService.autoActualSales(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Map<String, MonthBudgetActualSalesVo> actualSalesMap = this.monthBudgetService.calculateActualSales(ids);
        //计算实销量与回复量差额
        actualSalesMap.forEach((k, v) -> {
            List<String> lockKeys = Lists.newArrayList();
            lockKeys.add(v.getMonthBudgetCode());
            //加锁
            boolean dataLock = true;
            try {
                dataLock = monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, BudgetLockConstant.LOCK_TIME_FIVE);
                if (dataLock) {
                    v.setDAY(DAY);
                    this.monthBudgetService.calculateActualReplyDiff(v, null);
                }
            } catch (Exception e) {
                throw e;
            } finally {
                if (dataLock) {
                    monthBudgetLockService.unLock(lockKeys);
                }
            }
        });

    }
}
