package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * 滚动上月余额    job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class VerticalRollingAutoSyncXxlJob {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    private static final String DAY = "02";

    /**
     * （垂直）滚动上月余额
     */
    @DynamicTaskService(cornExpression = "0 0 6 2 1/1 ?", taskDesc = "（垂直）滚动上月余额")
    public void actualSalesAutoSyncXxlJob() {
        loginUserService.refreshAuthentication(null);
        log.info("=====>    垂直计算实际销量定时任务[{}] start    <=====", DateUtil.dateStrNowAll());
        Calendar cl = Calendar.getInstance();
        this.handle(DateUtil.format(cl.getTime(), DateUtil.DEFAULT_YEAR_MONTH));
        log.info("=====>    垂直计算实际销量定时任务[{}] end    <=====", DateUtil.dateStrNowAll());
    }

    public void handle(String yearMonth) {
        log.info("=====>    垂直计算实际销量 年月 [{}] start {}   <=====", yearMonth, DateUtil.dateStrNowAll());
        List<String> businessUnitCodeList = new ArrayList<>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        List<String> ids = this.monthBudgetService.listByYearMonth(yearMonth, businessUnitCodeList);
        this.monthBudgetService.manualRolling(ids);
        log.info("=====>    垂直计算实际销量 年月 [{}] end {}   <=====", yearMonth, DateUtil.dateStrNowAll());
    }
}
