package com.biz.crm.tpm.business.month.budget.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;


/**
 * 垂直预警面板-给帆软跑
 */
@Slf4j
@Service
public class VerticalWarningPanelXxlJob {

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    private static final String LOCK_KEY = "VERTICAL_WARNING_PANEL:";

    /**
     * 跑本月+上月
     */
    @DynamicTaskService(cornExpression = "0 20 2 * * ?", taskDesc = "垂直预警面板-给帆软跑")
    public void verticalAreaFeeWarningXxlJob() {
        loginUserService.refreshAuthentication(null);
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12);
            if (!lock) {
                return;
            }
            log.info("=====>    垂直预警面板-给帆软跑[{}] start    <=====", DateUtil.dateStrNowAll());
            List<String> yearMonths = Lists.newArrayList();
            YearMonth yearMonth = YearMonth.now();
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));//本月的
            yearMonth = yearMonth.plusMonths(-1);
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));//上月的

            this.monthBudgetService.verticalWarningPanel(yearMonths);
        }catch (Exception e){
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        }finally {
            log.info("=====>    垂直预警面板-给帆软跑[{}] end    <=====", DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}
