/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.builder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.BudgetTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.local.calculate.BudgetCalculateStrategy;
import com.biz.crm.tpm.business.month.budget.local.calculate.dto.SalesDataDto;
import com.biz.crm.tpm.business.month.budget.local.calculate.vo.SalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetHelper;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MonthBudgetActualSalesBuilder {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetActualSalesBuilder.class);
    private List<String> monthBudgetIds;
    private Map<String, MonthBudgetActualSalesVo> monthBudgetActualSalesMap;
    private List<BudgetCalculateStrategy> budgetCalculateStrategies;
    private MonthBudgetHelper helper;
    private List<MonthBudgetVo> monthBudgetVos;
    private Map<String, List<DimensionControlsVo>> dimensionControlMap;
    private Map<String, List<DimensionControlsVo>> dimensionControlMap2;

    public MonthBudgetActualSalesBuilder(List<String> monthBudgetIds, List<BudgetCalculateStrategy> budgetCalculateStrategies, MonthBudgetHelper helper) {
        this.monthBudgetIds = monthBudgetIds;
        this.budgetCalculateStrategies = budgetCalculateStrategies;
        this.helper = helper;
    }

    public static MonthBudgetActualSalesBuilder init(List<String> monthBudgetIds, List<BudgetCalculateStrategy> budgetCalculateStrategies, MonthBudgetHelper helper) {
        log.info("\u5b9e\u9645\u9500\u91cf\u8ba1\u7b97\u5bf9\u8c61,\u521d\u59cb\u5316");
        return new MonthBudgetActualSalesBuilder(monthBudgetIds, budgetCalculateStrategies, helper);
    }

    public MonthBudgetActualSalesBuilder basic() {
        log.info("\u5b9e\u9645\u9500\u91cf\u8ba1\u7b97\u5bf9\u8c61,\u57fa\u7840\u4fe1\u606f");
        this.monthBudgetActualSalesMap = Maps.newHashMap();
        this.monthBudgetVos = this.helper.findByIds(this.monthBudgetIds);
        List<String> budgetItemCodes = this.monthBudgetVos.stream().map(MonthBudgetVo::getBudgetItemCode).distinct().collect(Collectors.toList());
        Map<String, BudgetItemVo> budgetItemVoMap = this.helper.findBudgetItemByCodes(budgetItemCodes);
        this.dimensionControlMap = this.helper.findDimensionControl();
        this.dimensionControlMap2 = this.helper.findDimensionControlNoSalesOrg();
        this.monthBudgetVos.forEach(monthBudgetVo -> {
            String dimensionControlKey;
            monthBudgetVo.setBudgetType(BudgetTypeEnum.MONTH_BUDGET.getCode());
            MonthBudgetActualSalesVo actualSalesVo = new MonthBudgetActualSalesVo();
            actualSalesVo.setId(monthBudgetVo.getId());
            actualSalesVo.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
            actualSalesVo.setYearBudgetCode(monthBudgetVo.getYearBudgetCode());
            actualSalesVo.setYearMonthLy(monthBudgetVo.getYearMonthLy());
            actualSalesVo.setFirstReplyAmount(monthBudgetVo.getFirstReplyAmount());
            actualSalesVo.setBudgetTotalPoint(monthBudgetVo.getBudgetTotalPoint());
            actualSalesVo.setBudgetType(monthBudgetVo.getBudgetType());
            actualSalesVo.setBusinessUnitCode(monthBudgetVo.getBusinessUnitCode());
            actualSalesVo.setBusinessFormatCode(monthBudgetVo.getBusinessFormatCode());
            actualSalesVo.setCalAmount(monthBudgetVo.getCalAmount());
            actualSalesVo.setBudgetIntensityDenominator(monthBudgetVo.getBudgetIntensityDenominator());
            actualSalesVo.setBudgetIntensityNumerator(monthBudgetVo.getBudgetIntensityNumerator());
            actualSalesVo.setSalesOrgCode(monthBudgetVo.getSalesOrgCode());
            actualSalesVo.setOrgCode(monthBudgetVo.getOrgCode());
            String budgetItemCode = monthBudgetVo.getBudgetItemCode();
            BudgetItemVo budgetItemVo = (BudgetItemVo)budgetItemVoMap.get(budgetItemCode);
            BudgetItemControlConditionVo conditionVo = this.builderControl((MonthBudgetVo)monthBudgetVo, budgetItemVo);
            if (ObjectUtils.isEmpty((Object)conditionVo)) {
                return;
            }
            actualSalesVo.setControlTypeCode(conditionVo.getControlTypeCode());
            actualSalesVo.setDepartmentBelongCode(conditionVo.getDepartmentBelongCode());
            actualSalesVo.setFeeBelongCode(conditionVo.getFeeBelongCode());
            BudgetCalConfigVo budgetCalConfigVo = this.helper.findMonthBudgetCalConfigByDto((MonthBudgetVo)monthBudgetVo, conditionVo.getControlTypeCode());
            log.info("\u6708\u5ea6\u9884\u7b97[" + monthBudgetVo.getMonthBudgetCode() + "]\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e" + JSON.toJSONString((Object)budgetCalConfigVo));
            actualSalesVo.setBudgetCalConfigVo(budgetCalConfigVo);
            List<DimensionControlsVo> dimensionControlsVos = null;
            if (FeeBelongEnum.HEAD.getCode().equals(monthBudgetVo.getFeeBelongCode())) {
                dimensionControlKey = monthBudgetVo.getBusinessFormatCode() + monthBudgetVo.getBusinessUnitCode();
                dimensionControlsVos = this.dimensionControlMap2.get(dimensionControlKey);
            } else {
                dimensionControlKey = monthBudgetVo.getBusinessFormatCode() + monthBudgetVo.getBusinessUnitCode() + monthBudgetVo.getSalesOrgCode();
                dimensionControlsVos = this.dimensionControlMap.get(dimensionControlKey);
            }
            if (!CollectionUtils.isEmpty(dimensionControlsVos)) {
                log.error("\u901a\u8fc7\u4e1a\u6001\u4e1a\u52a1\u5355\u5143\u9500\u552e\u7ec4\u7ec7\u7b5b\u9009\u51fa\u6765\u7684\u7ba1\u63a7\u914d\u7f6e={}", (Object)JSONObject.toJSONString(dimensionControlsVos));
                DimensionControlsVo dimensionControlsVo = this.helper.matchDimensionControl(dimensionControlsVos, monthBudgetVo.getBudgetItemCode());
                log.error("\u83b7\u53d6\u5230\u7684\u6eda\u52a8\u7ba1\u63a7\u914d\u7f6e={}", (Object)JSONObject.toJSONString((Object)dimensionControlsVo));
                if (null != dimensionControlsVo) {
                    actualSalesVo.setRollingType(dimensionControlsVo.getRollingType());
                    actualSalesVo.setRolling(dimensionControlsVo.getIfRolling());
                }
            }
            this.monthBudgetActualSalesMap.put(monthBudgetVo.getMonthBudgetCode(), actualSalesVo);
        });
        return this;
    }

    public MonthBudgetActualSalesBuilder salesData() {
        log.info("\u5b9e\u9645\u9500\u91cf\u8ba1\u7b97\u5bf9\u8c61,\u67e5\u8be2\u9500\u552e\u6570\u636e,monthBudgetVos.size:{},budgetCalculateStrategies.size:{}", (Object)this.monthBudgetVos.size(), (Object)this.budgetCalculateStrategies.size());
        this.monthBudgetVos.forEach(monthBudgetVo -> {
            String monthBudgetCode = monthBudgetVo.getMonthBudgetCode();
            MonthBudgetActualSalesVo actualSalesVo = this.monthBudgetActualSalesMap.get(monthBudgetCode);
            if (ObjectUtils.isEmpty((Object)actualSalesVo)) {
                return;
            }
            BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)monthBudgetVo.getBusinessUnitCode());
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetVo.getBusinessUnitCode())) {
                businessUnitEnum = BusinessUnitEnum.HEADQUARTERS;
            }
            BusinessUnitEnum finalBusinessUnitEnum = businessUnitEnum;
            this.budgetCalculateStrategies.forEach(strategy -> {
                SalesDataDto salesDataDto;
                if (finalBusinessUnitEnum.getCode().equals(strategy.getBusinessUnit()) && null != (salesDataDto = strategy.buildDto((MonthBudgetVo)monthBudgetVo, actualSalesVo))) {
                    log.info("\u6708\u5ea6\u9884\u7b97[" + monthBudgetCode + "]\u65e5\u9500\u552e\u6570\u636e\u67e5\u8be2:" + JSON.toJSONString((Object)((Object)salesDataDto)));
                    Map<String, List<SalesDataVo>> salesData = strategy.findSalesData(salesDataDto);
                    strategy.summarySalesData(actualSalesVo, salesData, salesDataDto, (MonthBudgetVo)monthBudgetVo);
                }
            });
        });
        return this;
    }

    private BudgetItemControlConditionVo builderControl(MonthBudgetVo monthBudgetVo, BudgetItemVo budgetItemVo) {
        if (ObjectUtils.isEmpty((Object)budgetItemVo)) {
            return null;
        }
        List controlConditionDtoList = budgetItemVo.getControlConditionDtoList();
        if (CollectionUtils.isEmpty((Collection)controlConditionDtoList)) {
            return null;
        }
        List conditionVos = budgetItemVo.getControlConditionDtoList().stream().filter(controlVo -> monthBudgetVo.getBusinessFormatCode().equals(controlVo.getBusinessFormatCode()) && monthBudgetVo.getBusinessUnitCode().equals(controlVo.getBusinessUnitCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(conditionVos)) {
            return null;
        }
        return (BudgetItemControlConditionVo)conditionVos.get(0);
    }

    public Map<String, MonthBudgetActualSalesVo> builder() {
        return this.monthBudgetActualSalesMap;
    }
}

