/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.calculate.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.ActualSalesAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalDataFromEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesOrgAreaEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigAreaVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigDataVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigSalesOrgVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetControlTypeEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.calculate.BudgetCalculateStrategy;
import com.biz.crm.tpm.business.month.budget.local.calculate.dto.SalesDataDto;
import com.biz.crm.tpm.business.month.budget.local.calculate.vo.SalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetCalculateHelper;
import com.biz.crm.tpm.business.month.budget.sdk.dto.YearBudgetEventDto;
import com.biz.crm.tpm.business.month.budget.sdk.event.YearBudgetEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.YearBudgetResponse;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class BudgetCalculateHeadStrategy
implements BudgetCalculateStrategy {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalculateHeadStrategy.class);
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Resource
    private MonthBudgetCalculateHelper monthBudgetCalculateHelper;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private TpmDailySalesDataService tpmDailySalesDataService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    @Override
    public String getBusinessUnit() {
        return BusinessUnitEnum.HEADQUARTERS.getCode();
    }

    @Override
    public SalesDataDto buildDto(MonthBudgetVo monthBudgetVo, MonthBudgetActualSalesVo actualSalesVo) {
        List budgetItemList;
        log.info("\u5b9e\u9645\u9500\u91cf\u8ba1\u7b97\u5bf9\u8c61,\u6784\u5efa\u67e5\u8be2\u9500\u552e\u6570\u636e\u53c2\u6570-\u4e3b\u4f53");
        SalesDataDto dto = new SalesDataDto();
        dto.setYearMonthLy(monthBudgetVo.getYearMonthLy().replace("-", ""));
        dto.setBusinessFormatCode(monthBudgetVo.getBusinessFormatCode());
        dto.setBusinessUnitCode(monthBudgetVo.getBusinessUnitCode());
        BudgetCalConfigVo budgetCalConfigVo = actualSalesVo.getBudgetCalConfigVo();
        if (ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            return null;
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getCustomerList())) {
            List<String> customerCodeList = budgetCalConfigVo.getCustomerList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            dto.setExcludeCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            dto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            dto.setExcludeProductCodeList(productCodeList);
        }
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            List customerVoList;
            List list;
            if (StringUtils.isEmpty((CharSequence)monthBudgetVo.getSalesOrgCode()) && StringUtils.isEmpty((CharSequence)monthBudgetVo.getOrgCode())) {
                return null;
            }
            String salesOrgCode = null;
            if (!StringUtils.isEmpty((CharSequence)monthBudgetVo.getSalesOrgCode())) {
                salesOrgCode = monthBudgetVo.getSalesOrgCode();
            } else if (!StringUtils.isEmpty((CharSequence)monthBudgetVo.getOrgCode())) {
                OrgVo byOrgCode = this.orgVoService.findByOrgCode(monthBudgetVo.getOrgCode());
                salesOrgCode = byOrgCode.getSalesOrgCode();
            }
            if (StringUtils.isEmpty((CharSequence)salesOrgCode)) {
                return null;
            }
            List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCode(salesOrgCode);
            if (CollectionUtils.isEmpty((Collection)salesOrgVos)) {
                return null;
            }
            List<String> saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            dto.setCusSalesOrgCodeList(saleOrgCodeList);
            if (!CollectionUtils.isEmpty(saleOrgCodeList) && !CollectionUtils.isEmpty((Collection)(list = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(saleOrgCodeList)))) {
                List<String> salesInstitutionCodes = list.stream().filter(e -> saleOrgCodeList.contains(e.getCurrSalesOrgCode())).map(SalesOrgAllParentVo::getSalesInstitutionCode).distinct().collect(Collectors.toList());
                dto.setSalesInstitutionCodes(salesInstitutionCodes);
            }
            if (CollectionUtils.isEmpty((Collection)(customerVoList = this.customerVoService.findBySalesOrgCodes(saleOrgCodeList)))) {
                return null;
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(dto.getExcludeCustomerCodeList());
            }
            dto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            List customerVoList;
            List list;
            if (CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getSalesOrgList())) {
                return null;
            }
            List<String> saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream().map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toList());
            dto.setCusSalesOrgCodeList(saleOrgCodeList);
            if (!CollectionUtils.isEmpty(saleOrgCodeList) && !CollectionUtils.isEmpty((Collection)(list = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(saleOrgCodeList)))) {
                List<String> salesInstitutionCodes = list.stream().filter(e -> saleOrgCodeList.contains(e.getCurrSalesOrgCode())).map(SalesOrgAllParentVo::getSalesInstitutionCode).distinct().collect(Collectors.toList());
                dto.setSalesInstitutionCodes(salesInstitutionCodes);
            }
            if (CollectionUtils.isEmpty((Collection)(customerVoList = this.customerVoService.findBySalesOrgCodes(saleOrgCodeList)))) {
                return null;
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(dto.getExcludeCustomerCodeList());
            }
            dto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUR_CUSTOMER.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            ArrayList<String> customerCodes = new ArrayList<String>();
            customerCodes.add(monthBudgetVo.getCustomerCode());
            dto.setCustomerCodeList(customerCodes);
        }
        String controlType = budgetCalConfigVo.getControlType();
        if ((BudgetControlTypeEnum.INTENSITY.getCode().equals(controlType) || BudgetControlTypeEnum.RATIO.getCode().equals(controlType)) && !CollectionUtils.isEmpty((Collection)(budgetItemList = budgetCalConfigVo.getBudgetItemList()))) {
            HashSet productCodes = Sets.newHashSet();
            budgetItemList.stream().filter(o -> o.getDataCode().equals(monthBudgetVo.getBudgetItemCode())).forEach(o -> {
                List scopeProducts = o.getScopeProducts();
                if (!CollectionUtils.isEmpty((Collection)scopeProducts)) {
                    scopeProducts.forEach(product -> productCodes.add(product.getProductCode()));
                }
            });
            dto.setIncludeProductCodeList(Lists.newArrayList((Iterable)productCodes));
            if (!CollectionUtils.isEmpty((Collection)productCodes)) {
                dto.setExcludeProductCodeList(null);
            }
        }
        return dto;
    }

    @Override
    public Map<String, List<SalesDataVo>> findSalesData(SalesDataDto dto) {
        MainOnedaySalesDataDto salesDataDto = (MainOnedaySalesDataDto)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, MainOnedaySalesDataDto.class, HashSet.class, ArrayList.class, new String[0]);
        salesDataDto.setExcludeCustomerCodeList(dto.getExcludeCustomerCodeList());
        salesDataDto.setExcludeTerminalCodeList(dto.getExcludeTerminalCodeList());
        salesDataDto.setExcludeProductCodeList(dto.getExcludeProductCodeList());
        salesDataDto.setCustomerCodeList(dto.getCustomerCodeList());
        salesDataDto.setProductCodes(dto.getIncludeProductCodeList());
        salesDataDto.setCusSalesOrgCodeList(dto.getCusSalesOrgCodeList());
        log.error("\u67e5\u8be2\u4e3b\u4f53\u65e5\u9500\u552e\u6570\u636e\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)salesDataDto));
        List mainOnedaySalesDataVos = this.mainOnedaySaleDataService.listMainOnedaySalesDataForMonthBudget(salesDataDto);
        if (CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos)) {
            return Maps.newHashMap();
        }
        log.error("\u4e3b\u4f53\u65e5\u9500\u552e\u6570\u636e\u8fd4\u56de\u91d1\u989d\uff1a{}", (Object)mainOnedaySalesDataVos.stream().map(MainOnedaySalesDataVo::getDiscountBehindSaleAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        log.error("\u4e3b\u4f53\u65e5\u9500\u552e\u6570\u636e\u8fd4\u56de\u5ba2\u6237\u7f16\u7801={},\u8fd4\u56de\u6570\u636e\u6761\u6570{}", (Object)JSONObject.toJSONString(mainOnedaySalesDataVos.stream().map(MainOnedaySalesDataVo::getCustomerCode).collect(Collectors.toSet())), (Object)mainOnedaySalesDataVos.size());
        List salesDataVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)mainOnedaySalesDataVos, MainOnedaySalesDataVo.class, SalesDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return salesDataVos.stream().collect(Collectors.groupingBy(i -> i.getCustomerCode() + i.getProductCode()));
    }

    @Override
    public void summarySalesData(MonthBudgetActualSalesVo actualSalesVo, Map<String, List<SalesDataVo>> salesDataMap, SalesDataDto salesDataDto, MonthBudgetVo monthBudgetVo) {
        YearBudgetResponse budgetResponse;
        log.info("\u5b9e\u9645\u9500\u91cf\u8ba1\u7b97\u5bf9\u8c61,\u6c47\u603b");
        BudgetCalConfigVo budgetCalConfigVo = actualSalesVo.getBudgetCalConfigVo();
        if (ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            return;
        }
        List dataList = budgetCalConfigVo.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        BudgetCalConfigDataVo budgetCalConfigDataVo = dataList.stream().filter(o -> CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode().equals(o.getCalDataFromCode())).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)budgetCalConfigDataVo)) {
            return;
        }
        List productRatios = budgetCalConfigVo.getProductRatios();
        HashMap<String, BudgetCalConfigProductRatioVo> productRatioVoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)productRatios)) {
            productRatioVoMap = productRatios.stream().collect(Collectors.toMap(BudgetCalConfigProductRatioVo::getProductCode, e -> e));
        }
        BigDecimal yearBudgetTotalPoint = null;
        YearBudgetEventDto eventDto = new YearBudgetEventDto();
        eventDto.setYearBudgetCode(actualSalesVo.getYearBudgetCode());
        eventDto.setSalesOrgCode(actualSalesVo.getSalesOrgCode());
        eventDto.setBusinessFormatCode(budgetCalConfigVo.getBusinessFormatCode());
        eventDto.setBusinessUnitCode(budgetCalConfigVo.getBusinessUnitCode());
        eventDto.setBudgetTypeCode(budgetCalConfigVo.getBudgetTypeCode());
        eventDto.setFeeBelongCode(budgetCalConfigVo.getFeeBelongCode());
        eventDto.setControlType(budgetCalConfigVo.getControlType());
        eventDto.setOrgAreaCode(budgetCalConfigVo.getOrgAreaCode());
        eventDto.setSalesOrgList(budgetCalConfigVo.getSalesOrgList());
        eventDto.setOrgCode(actualSalesVo.getOrgCode());
        eventDto.setCustomerCode(monthBudgetVo.getCustomerCode());
        eventDto.setGroupCode(monthBudgetVo.getGroupCode());
        eventDto.setYearLy(DateUtil.dateToStr((Date)DateUtil.strToDate((String)actualSalesVo.getYearMonthLy(), (SimpleDateFormat)DateUtil.date_yyyy_MM), (SimpleDateFormat)DateUtil.date_yyyy));
        log.info("\u6708\u5ea6\u9884\u7b97\u8ba1\u7b97\u8ba1\u5212\u91cf/\u56de\u590d\u91cf,eventDto==>:{}", (Object)eventDto);
        SerializableBiConsumer & Serializable getYearBudgetByCode = YearBudgetEventListener::getYearBudgetByCode;
        EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, YearBudgetEventListener.class, (SerializableBiConsumer)getYearBudgetByCode);
        if (!Objects.isNull(eventResponse) && !Objects.isNull((budgetResponse = (YearBudgetResponse)eventResponse).getBudgetTotalPoint())) {
            yearBudgetTotalPoint = budgetResponse.getBudgetTotalPoint().divide(new BigDecimal(100), 8, 4);
        }
        BigDecimal pointOrIntensity = null;
        String controlTypeCode = budgetCalConfigVo.getControlType();
        if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) {
            Assert.notNull((Object)actualSalesVo.getBudgetTotalPoint(), (String)"\u9884\u7b97\u603b\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            pointOrIntensity = actualSalesVo.getBudgetTotalPoint().divide(new BigDecimal(100), 8, 4);
        } else if (BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
            log.info("summarySalesData \u8ba1\u7b97\u5b9e\u9500\u91cf\u56de\u590d\u5dee");
            BigDecimal budgetIntensityNumerator = actualSalesVo.getBudgetIntensityNumerator();
            Assert.notNull((Object)budgetIntensityNumerator, (String)"\u5e74\u5ea6\u529b\u5ea6\u5206\u5b50\u4e0d\u80fd\u4e3a\u7a7a");
            log.info("summarySalesData \u8ba1\u7b97\u5b9e\u9500\u91cf\u56de\u590d\u5dee\uff1a\u5206\u5b50{}", (Object)budgetIntensityNumerator);
            BigDecimal budgetIntensityDenominator = actualSalesVo.getBudgetIntensityDenominator();
            Assert.notNull((Object)budgetIntensityDenominator, (String)"\u5e74\u5ea6\u529b\u5ea6\u5206\u6bcd\u4e0d\u80fd\u4e3a\u7a7a");
            log.info("summarySalesData \u8ba1\u7b97\u5b9e\u9500\u91cf\u56de\u590d\u5dee\uff1a\u5206\u6bcd{}", (Object)budgetIntensityDenominator);
            pointOrIntensity = budgetIntensityNumerator.divide(budgetIntensityDenominator, 6, 4);
        }
        log.info("summarySalesData \u8ba1\u7b97\u5b9e\u9500\u91cf\u56de\u590d\u5dee\uff1a{}", pointOrIntensity);
        if (FeeBelongEnum.AREA.getCode().equals(budgetCalConfigVo.getFeeBelongCode())) {
            pointOrIntensity = yearBudgetTotalPoint;
        }
        if (null == pointOrIntensity) {
            return;
        }
        AtomicReference<BigDecimal> actualSales = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        String amountTypeCode = budgetCalConfigDataVo.getAmountTypeCode();
        ActualSalesAmountTypeEnum amountTypeEnum = ActualSalesAmountTypeEnum.getByCode((String)amountTypeCode);
        Assert.notNull((Object)amountTypeEnum, (String)("\u91d1\u989d\u7c7b\u578b[" + amountTypeCode + "]\u4e0d\u5408\u6cd5!"));
        List salesDataVos = new ArrayList();
        Map jituanCardMap = this.dictToolkitService.findMapByDictTypeCode("mdm_customer_jituan_card");
        ArrayList jituanCardCustomerList = new ArrayList();
        if (!CollectionUtils.isEmpty(salesDataDto.getSalesInstitutionCodes())) {
            jituanCardMap.forEach((k, v) -> {
                if (salesDataDto.getSalesInstitutionCodes().contains(k)) {
                    jituanCardCustomerList.add(v);
                }
            });
        }
        String yearMonthLy = actualSalesVo.getYearMonthLy().replace("-", "");
        switch (amountTypeEnum) {
            case DISCOUNT_BEHIND_SALE_AMOUNT: {
                TpmDailySalesDataTotalDto totalDto3 = new TpmDailySalesDataTotalDto();
                totalDto3.setYearMonthLy(yearMonthLy);
                totalDto3.setBusinessFormatCode(salesDataDto.getBusinessFormatCode());
                totalDto3.setBusinessUnitCode(salesDataDto.getBusinessUnitCode());
                totalDto3.setExcludeCustomerCodeList(salesDataDto.getExcludeCustomerCodeList());
                totalDto3.setExcludeTerminalCodeList(salesDataDto.getExcludeTerminalCodeList());
                totalDto3.setExcludeProductCodeList(salesDataDto.getExcludeProductCodeList());
                totalDto3.setCustomerCodeList(salesDataDto.getCustomerCodeList());
                totalDto3.setSalesProductCodeList(salesDataDto.getIncludeProductCodeList());
                salesDataVos = this.tpmDailySalesDataService.statisticsListByCondition(totalDto3);
                log.error("summarySalesData 033\u62a5\u8868\u7edf\u8ba1\u6570\u636e=DISCOUNT_BEHIND_SALE_AMOUNT={}", (Object)salesDataVos.stream().map(TpmDailySalesDataVo::getAfterDiscountAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                if (!CollectionUtils.isEmpty(jituanCardCustomerList)) {
                    Iterator<String> soldPartyCodeList = salesDataDto.getCustomerCodeList().stream().map(e -> e.substring(0, Math.min(e.length(), 10))).collect(Collectors.toList());
                    totalDto3.setCustomerCodeList(jituanCardCustomerList);
                    totalDto3.setServiceCodeList(soldPartyCodeList);
                    List vos = this.tpmDailySalesDataService.statisticsListByCondition(totalDto3);
                    log.error("summarySalesData 033\u62a5\u8868\u7edf\u8ba1\u6570\u636e=DISCOUNT_BEHIND_SALE_AMOUNT=\u96c6\u56e2\u5361={}", (Object)vos.stream().map(TpmDailySalesDataVo::getAfterDiscountAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                    salesDataVos.addAll(vos);
                }
                for (TpmDailySalesDataVo salesDataVo : salesDataVos) {
                    BigDecimal amount = Optional.ofNullable(salesDataVo.getAfterDiscountAmt()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
                    this.setReduce(amount, actualSales, productRatioVoMap, salesDataVo.getMaterialCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                for (String key : salesDataMap.keySet()) {
                    SalesDataVo dataVo = salesDataMap.get(key).get(0);
                    BigDecimal bigDecimal = Optional.ofNullable(dataVo.getDiscountBehindSaleAmount()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    log.error("summarySalesData setReduce amount={} ", (Object)bigDecimal);
                    this.setReduce(bigDecimal, actualSales, productRatioVoMap, dataVo.getProductCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                break;
            }
            case ORDER_RULE_AMT_IN_REBATE: {
                for (Map.Entry<String, List<SalesDataVo>> entry : salesDataMap.entrySet()) {
                    SalesDataVo dataVo = entry.getValue().get(0);
                    BigDecimal bigDecimal = Optional.ofNullable(dataVo.getDiscountFrontSaleAmount()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    this.setReduce(bigDecimal, actualSales, productRatioVoMap, dataVo.getProductCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                break;
            }
            case WAREHS_OUT_DISCOUNT_AMT: {
                for (Map.Entry<String, List<SalesDataVo>> entry : salesDataMap.entrySet()) {
                    SalesDataVo dataVo = entry.getValue().get(0);
                    BigDecimal bigDecimal = Optional.ofNullable(dataVo.getWarehsOutDiscountAmtIncM()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    this.setReduce(bigDecimal, actualSales, productRatioVoMap, dataVo.getProductCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                break;
            }
            case DISCOUNT_BEHIND_TAX_SALE_AMOUNT: {
                for (Map.Entry<String, List<SalesDataVo>> entry : salesDataMap.entrySet()) {
                    SalesDataVo dataVo = entry.getValue().get(0);
                    BigDecimal bigDecimal = Optional.ofNullable(dataVo.getDiscountBehindTaxSaleAmount()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    this.setReduce(bigDecimal, actualSales, productRatioVoMap, dataVo.getProductCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                break;
            }
            case SALE_QUANTITY: {
                TpmDailySalesDataTotalDto totalDto = new TpmDailySalesDataTotalDto();
                totalDto.setYearMonthLy(yearMonthLy);
                totalDto.setBusinessFormatCode(salesDataDto.getBusinessFormatCode());
                totalDto.setBusinessUnitCode(salesDataDto.getBusinessUnitCode());
                totalDto.setExcludeCustomerCodeList(salesDataDto.getExcludeCustomerCodeList());
                totalDto.setExcludeTerminalCodeList(salesDataDto.getExcludeTerminalCodeList());
                totalDto.setExcludeProductCodeList(salesDataDto.getExcludeProductCodeList());
                totalDto.setCustomerCodeList(salesDataDto.getCustomerCodeList());
                totalDto.setSalesProductCodeList(salesDataDto.getIncludeProductCodeList());
                salesDataVos = this.tpmDailySalesDataService.statisticsListByCondition(totalDto);
                log.error("summarySalesData 033\u62a5\u8868\u7edf\u8ba1\u6570\u636e=SALE_QUANTITY={}", (Object)salesDataVos.stream().map(TpmDailySalesDataVo::getOrderNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                if (!CollectionUtils.isEmpty(jituanCardCustomerList)) {
                    Iterator<Map.Entry<String, List<SalesDataVo>>> soldPartyCodeList = salesDataDto.getCustomerCodeList().stream().map(e -> e.substring(0, Math.min(e.length(), 10))).collect(Collectors.toList());
                    totalDto.setCustomerCodeList(jituanCardCustomerList);
                    totalDto.setServiceCodeList(soldPartyCodeList);
                    List vos = this.tpmDailySalesDataService.statisticsListByCondition(totalDto);
                    log.error("summarySalesData 033\u62a5\u8868\u7edf\u8ba1\u6570\u636e=SALE_QUANTITY=\u96c6\u56e2\u5361\u5ba2\u6237={}", (Object)vos.stream().map(TpmDailySalesDataVo::getOrderNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                    salesDataVos.addAll(vos);
                }
                for (TpmDailySalesDataVo salesDataVo : salesDataVos) {
                    BigDecimal bigDecimal = Optional.ofNullable(salesDataVo.getOrderNum()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    this.setReduce(bigDecimal, actualSales, productRatioVoMap, salesDataVo.getMaterialCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                for (Map.Entry<String, List<SalesDataVo>> entry : salesDataMap.entrySet()) {
                    SalesDataVo salesDataVo = entry.getValue().get(0);
                    BigDecimal amount = Optional.ofNullable(salesDataVo.getSaleQuantity()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
                    this.setReduce(amount, actualSales, productRatioVoMap, salesDataVo.getProductCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                break;
            }
            case DELIVERY_MULTIPLY_PRICE: {
                TpmDailySalesDataTotalDto totalDto2 = new TpmDailySalesDataTotalDto();
                totalDto2.setYearMonthLy(yearMonthLy);
                totalDto2.setBusinessFormatCode(salesDataDto.getBusinessFormatCode());
                totalDto2.setBusinessUnitCode(salesDataDto.getBusinessUnitCode());
                totalDto2.setExcludeCustomerCodeList(salesDataDto.getExcludeCustomerCodeList());
                totalDto2.setExcludeTerminalCodeList(salesDataDto.getExcludeTerminalCodeList());
                totalDto2.setExcludeProductCodeList(salesDataDto.getExcludeProductCodeList());
                totalDto2.setCustomerCodeList(salesDataDto.getCustomerCodeList());
                totalDto2.setSalesProductCodeList(salesDataDto.getIncludeProductCodeList());
                salesDataVos = this.tpmDailySalesDataService.statisticsListByCondition(totalDto2);
                log.error("summarySalesData 033\u62a5\u8868\u7edf\u8ba1\u6570\u636e=DELIVERY_MULTIPLY_PRICE=\u96c6\u56e2\u5361\u5ba2\u6237={}", (Object)salesDataVos.stream().map(TpmDailySalesDataVo::getOrderAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                if (!CollectionUtils.isEmpty(jituanCardCustomerList)) {
                    List soldPartyCodeList = salesDataDto.getCustomerCodeList().stream().map(e -> e.substring(0, Math.min(e.length(), 10))).collect(Collectors.toList());
                    totalDto2.setCustomerCodeList(jituanCardCustomerList);
                    totalDto2.setServiceCodeList(soldPartyCodeList);
                    List list = this.tpmDailySalesDataService.statisticsListByCondition(totalDto2);
                    log.error("summarySalesData 033\u62a5\u8868\u7edf\u8ba1\u6570\u636e=DELIVERY_MULTIPLY_PRICE=\u96c6\u56e2\u5361\u5ba2\u6237={}", (Object)list.stream().map(TpmDailySalesDataVo::getOrderAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                    salesDataVos.addAll(list);
                }
                for (TpmDailySalesDataVo tpmDailySalesDataVo : salesDataVos) {
                    BigDecimal amount = Optional.ofNullable(tpmDailySalesDataVo.getOrderAmount()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
                    this.setReduce(amount, actualSales, productRatioVoMap, tpmDailySalesDataVo.getMaterialCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                for (Map.Entry entry : salesDataMap.entrySet()) {
                    SalesDataVo dataVo = (SalesDataVo)((Object)((List)entry.getValue()).get(0));
                    BigDecimal amount = Optional.ofNullable(dataVo.getDiscountFrontSaleAmount()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
                    this.setReduce(amount, actualSales, productRatioVoMap, dataVo.getProductCode(), yearBudgetTotalPoint, pointOrIntensity);
                }
                break;
            }
        }
        actualSalesVo.setActualSales(actualSales.get());
        if (BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
            log.error("summarySalesData \u5408\u8ba1\u91d1\u989d={}\uff0c\u70b9\u6570={}", (Object)actualSales.get(), (Object)pointOrIntensity);
            actualSalesVo.setActualSalesAmount(actualSales.get().multiply(pointOrIntensity).setScale(6, 4));
            return;
        }
        BigDecimal budgetTotalPoint = monthBudgetVo.getBudgetTotalPoint();
        if (Objects.isNull(budgetTotalPoint)) {
            budgetTotalPoint = BigDecimal.ZERO;
        }
        BigDecimal actualSalesAmount = actualSales.get().multiply(budgetTotalPoint).divide(new BigDecimal(100), 6, 4);
        log.error("summarySalesData actualSalesAmount={}", (Object)actualSalesAmount);
        log.error("summarySalesData \u5408\u8ba1\u91d1\u989d={}\uff0c\u70b9\u6570={}", (Object)actualSales.get(), (Object)budgetTotalPoint);
        actualSalesVo.setActualSalesAmount(actualSalesAmount);
    }

    private void setReduce(BigDecimal amount, AtomicReference<BigDecimal> actualSales, Map<String, BudgetCalConfigProductRatioVo> productRatioVoMap, String productCode, BigDecimal yearBudgetTotalPoint, BigDecimal pointOrIntensity) {
        if (productRatioVoMap.containsKey(productCode)) {
            BudgetCalConfigProductRatioVo ratioVo = productRatioVoMap.get(productCode);
            if (!Objects.isNull(ratioVo) && !Objects.isNull(ratioVo.getChargedRatio())) {
                if (StringUtils.isNotBlank((CharSequence)ratioVo.getReduceTag()) && BooleanEnum.TRUE.getCapital().equals(ratioVo.getReduceTag()) && !Objects.isNull(yearBudgetTotalPoint)) {
                    BigDecimal ratio = yearBudgetTotalPoint.subtract(ratioVo.getChargedRatio());
                    actualSales.set(actualSales.get().add(amount.multiply(ratio).divide(pointOrIntensity, 8, RoundingMode.HALF_UP)));
                } else {
                    actualSales.set(actualSales.get().add(amount.multiply(ratioVo.getChargedRatio()).divide(pointOrIntensity, 8, RoundingMode.HALF_UP)));
                }
            } else {
                actualSales.set(actualSales.get().add(amount));
            }
        } else {
            actualSales.set(actualSales.get().add(amount));
        }
    }

    @Override
    public void calculation(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget) {
        this.monthBudgetCalculateHelper.calculationActualReplyDiffHead(actualSalesVo, currMonthBudget);
    }
}

