/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.calculate.strategy;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.ActualSalesAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalDataFromEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigAreaVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigDataVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetControlTypeEnum;
import com.biz.crm.tpm.business.month.budget.local.calculate.BudgetCalculateStrategy;
import com.biz.crm.tpm.business.month.budget.local.calculate.dto.SalesDataDto;
import com.biz.crm.tpm.business.month.budget.local.calculate.vo.SalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetCalculateHelper;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class BudgetCalculateVerticalStrategy
implements BudgetCalculateStrategy {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalculateVerticalStrategy.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Resource
    private MonthBudgetCalculateHelper monthBudgetCalculateHelper;

    @Override
    public String getBusinessUnit() {
        return BusinessUnitEnum.VERTICAL.getCode();
    }

    @Override
    public SalesDataDto buildDto(MonthBudgetVo monthBudgetVo, MonthBudgetActualSalesVo actualSalesVo) {
        List productRatios;
        log.info("\u5b9e\u9645\u9500\u91cf\u8ba1\u7b97\u5bf9\u8c61,\u6784\u5efa\u67e5\u8be2\u9500\u552e\u6570\u636e\u53c2\u6570-\u5782\u76f4");
        BudgetCalConfigVo budgetCalConfigVo = actualSalesVo.getBudgetCalConfigVo();
        SalesDataDto dto = new SalesDataDto();
        dto.setSalesDate(monthBudgetVo.getYearMonthLy().split("-")[0]);
        dto.setSalesMonth(monthBudgetVo.getYearMonthLy().replace("-", ""));
        dto.setYearMonthLy(monthBudgetVo.getYearMonthLy().replace("-", ""));
        dto.setRegion(monthBudgetVo.getRegionName());
        dto.setSalesOrg(monthBudgetVo.getSalesOrgCode());
        dto.setRetailer(monthBudgetVo.getSystemName());
        dto.setShipToparty(monthBudgetVo.getTerminalCode());
        dto.setBrand(monthBudgetVo.getProductBrandCode());
        dto.setCategoryCode(monthBudgetVo.getProductItemCode());
        dto.setMaterialCode(monthBudgetVo.getProductCode());
        if (ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            return null;
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            dto.setExcludeTerminalCodeList(terminalCodeList);
        }
        String currYearMonth = DateUtil.dateToStr((SimpleDateFormat)new SimpleDateFormat("yyyy-MM"));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getMaterialCode()) && !CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().filter(o -> !StringUtils.hasText((String)o.getFilYearMonth()) || StringUtils.hasText((String)o.getFilYearMonth()) && currYearMonth.equals(o.getFilYearMonth())).map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            dto.setExcludeProductCodeList(productCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)(productRatios = budgetCalConfigVo.getProductRatios()))) {
            dto.setIncludeProductCodeList(productRatios.stream().map(BudgetCalConfigProductRatioVo::getProductCode).collect(Collectors.toList()));
        }
        return dto;
    }

    @Override
    public Map<String, List<SalesDataVo>> findSalesData(SalesDataDto dto) {
        List salesPerformanceSumVos;
        if (ObjectUtils.isEmpty((Object)((Object)dto))) {
            return Maps.newHashMap();
        }
        SalesPerformanceDto salesDataDto = (SalesPerformanceDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SalesPerformanceDto.class, HashSet.class, ArrayList.class, new String[0]);
        salesDataDto.setExcludeTerminalCodeList(dto.getExcludeTerminalCodeList());
        salesDataDto.setExcludeCustomerCodeList(dto.getExcludeCustomerCodeList());
        salesDataDto.setIncludeProductCodeList(null);
        if (!CollectionUtils.isEmpty(dto.getExcludeProductCodeList())) {
            if (!CollectionUtils.isEmpty(dto.getIncludeProductCodeList())) {
                ArrayList newExcludeProductCodeList = Lists.newArrayList(dto.getExcludeProductCodeList());
                newExcludeProductCodeList.removeAll(dto.getIncludeProductCodeList());
                salesDataDto.setExcludeProductCodeList((List)newExcludeProductCodeList);
            } else {
                salesDataDto.setExcludeProductCodeList(dto.getExcludeProductCodeList());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(salesPerformanceSumVos = this.salesPerformanceVoService.listYearByConditions(salesDataDto)))) {
            return Maps.newHashMap();
        }
        List salesDataVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)salesPerformanceSumVos, SalesPerformanceSumVo.class, SalesDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        salesDataVos.forEach(salesPerformanceSumVo -> {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)salesPerformanceSumVo.getSalesMonth())) {
                Date yyyyMM = DateUtil.parse((String)salesPerformanceSumVo.getSalesMonth(), (String)"yyyyMM");
                String format = DateUtil.format((Date)yyyyMM, (String)"yyyy-MM");
                salesPerformanceSumVo.setSalesMonth(format);
            }
        });
        return salesDataVos.stream().collect(Collectors.groupingBy(SalesDataVo::getSalesMonth));
    }

    @Override
    public void summarySalesData(MonthBudgetActualSalesVo actualSalesVo, Map<String, List<SalesDataVo>> salesDataMap, SalesDataDto salesDataDto, MonthBudgetVo monthBudgetVo) {
        BudgetCalConfigVo budgetCalConfigVo = actualSalesVo.getBudgetCalConfigVo();
        if (ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            return;
        }
        List dataList = budgetCalConfigVo.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        BudgetCalConfigDataVo budgetCalConfigDataVo = dataList.stream().filter(o -> CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode().equals(o.getCalDataFromCode())).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)budgetCalConfigDataVo)) {
            return;
        }
        String amountTypeCode = budgetCalConfigDataVo.getAmountTypeCode();
        ActualSalesAmountTypeEnum amountTypeEnum = ActualSalesAmountTypeEnum.getByCode((String)amountTypeCode);
        if (ObjectUtils.isEmpty((Object)amountTypeEnum)) {
            return;
        }
        List<SalesDataVo> salesDataVos = salesDataMap.get(actualSalesVo.getYearMonthLy());
        if (CollectionUtils.isEmpty(salesDataVos)) {
            return;
        }
        AtomicReference<BigDecimal> actualSalesAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> actualCostsAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        List budgetCalConfigProductRatioVos = budgetCalConfigVo.getProductRatios();
        HashMap productRatioVoMap = CollectionUtils.isEmpty((Collection)budgetCalConfigProductRatioVos) ? Maps.newHashMap() : budgetCalConfigProductRatioVos.stream().collect(Collectors.toMap(BudgetCalConfigProductRatioVo::getProductCode, Function.identity()));
        String controlTypeCode = actualSalesVo.getControlTypeCode();
        List<String> includeProductCodeList = salesDataDto.getIncludeProductCodeList();
        List<String> excludeProductCodeList = salesDataDto.getExcludeProductCodeList();
        salesDataVos.forEach(salesDataVo -> {
            String productCode = salesDataVo.getMaterialCode();
            BudgetCalConfigProductRatioVo budgetCalConfigProductRatioVo = (BudgetCalConfigProductRatioVo)productRatioVoMap.get(productCode);
            BigDecimal productRatio = ObjectUtils.isEmpty((Object)budgetCalConfigProductRatioVo) ? null : Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
            boolean addSales = false;
            if (!CollectionUtils.isEmpty((Collection)excludeProductCodeList)) {
                if (!excludeProductCodeList.contains(productCode)) {
                    addSales = true;
                }
            } else {
                addSales = true;
            }
            boolean addCost = false;
            if (!CollectionUtils.isEmpty((Collection)includeProductCodeList)) {
                if (includeProductCodeList.contains(productCode)) {
                    addCost = true;
                }
            } else {
                addCost = true;
            }
            switch (amountTypeEnum) {
                case DISCOUNT_BEHIND_SALE_AMOUNT: {
                    break;
                }
                case ORDER_RULE_AMT_IN_REBATE: {
                    BigDecimal orderRuleAmtInRebate = Optional.ofNullable(salesDataVo.getOrderRuleAmtInRebate()).orElse(BigDecimal.ZERO);
                    if (addSales) {
                        actualSalesAmount.set(((BigDecimal)actualSalesAmount.get()).add(orderRuleAmtInRebate));
                    }
                    if (!addCost || !BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) break;
                    if (!ObjectUtils.isEmpty((Object)productRatio)) {
                        actualCostsAmount.set(orderRuleAmtInRebate.multiply(productRatio).setScale(6, 4).add((BigDecimal)actualCostsAmount.get()));
                        break;
                    }
                    actualCostsAmount.set(orderRuleAmtInRebate.add((BigDecimal)actualCostsAmount.get()));
                    break;
                }
                case WAREHS_OUT_DISCOUNT_AMT: {
                    BigDecimal warehsOutDiscountAmt = Optional.ofNullable(salesDataVo.getWarehsOutDiscountAmt()).orElse(BigDecimal.ZERO);
                    if (addSales) {
                        actualSalesAmount.set(((BigDecimal)actualSalesAmount.get()).add(warehsOutDiscountAmt));
                    }
                    if (!addCost || !BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) break;
                    if (!ObjectUtils.isEmpty((Object)productRatio)) {
                        actualCostsAmount.set(warehsOutDiscountAmt.multiply(productRatio).setScale(6, 4).add((BigDecimal)actualCostsAmount.get()));
                        break;
                    }
                    actualCostsAmount.set(warehsOutDiscountAmt.add((BigDecimal)actualCostsAmount.get()));
                    break;
                }
                case DISCOUNT_BEHIND_TAX_SALE_AMOUNT: {
                    break;
                }
            }
        });
        if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) {
            if (CollectionUtils.isEmpty((Collection)budgetCalConfigProductRatioVos)) {
                if (ObjectUtils.isEmpty((Object)actualSalesVo.getBudgetTotalPoint())) {
                    actualCostsAmount.set(null);
                } else {
                    BigDecimal budgetTotalPoint = actualSalesVo.getBudgetTotalPoint().divide(new BigDecimal(100), 6, 4);
                    actualCostsAmount.set(actualCostsAmount.get().multiply(budgetTotalPoint).setScale(6, 4));
                }
            }
        } else if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlTypeCode)) {
            actualCostsAmount.set(actualSalesVo.getFirstReplyAmount());
        }
        actualSalesVo.setActualCostsAmount(actualCostsAmount.get());
        actualSalesVo.setActualSalesAmount(actualSalesAmount.get());
    }

    @Override
    public void calculation(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget) {
        this.monthBudgetCalculateHelper.calculationActualReplyDiffVertical(actualSalesVo, currMonthBudget);
    }
}

