/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetActualReplayService;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.local.service.xxjob.VerticalActualSalesAutoSyncXxlJob;
import com.biz.crm.tpm.business.month.budget.local.service.xxjob.VerticalRollingAutoSyncXxlJob;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetAdjustDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetBatchLockDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetBusinessPolicyQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetExamineCircularQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetLockDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetOperateDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetTransferDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetChangeVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetControlVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetMainAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.plan.local.service.xxjob.AutoPullMonthPlanReplayXxJob;
import com.biz.crm.tpm.business.sales.plan.local.service.xxjob.AutoPullMonthPlanXxJob;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/month/budget"})
@Api(tags={"\u6708\u5ea6\u9884\u7b97"})
public class MonthBudgetController {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetController.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private MonthBudgetDetailService monthBudgetDetailService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private VerticalActualSalesAutoSyncXxlJob verticalActualSalesAutoSyncXxlJob;
    @Autowired(required=false)
    private AutoPullMonthPlanReplayXxJob autoPullMonthPlanReplayXxJob;
    @Autowired(required=false)
    private AutoPullMonthPlanXxJob autoPullMonthPlanXxJob;
    @Autowired(required=false)
    private VerticalRollingAutoSyncXxlJob verticalRollingAutoSyncXxlJob;
    @Autowired(required=false)
    private MonthBudgetActualReplayService monthBudgetActualReplayService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<MonthBudgetVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="monthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetDto dto) {
        try {
            Page page = this.monthBudgetService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @PostMapping(value={"findByCodes"})
    public Result<List<MonthBudgetVo>> findByCodes(@RequestBody List<String> codes) {
        try {
            List page = this.monthBudgetService.findByCodes(codes, EnableStatusEnum.ENABLE.getCode());
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findUnionByConditions"})
    public Result<Page<MonthBudgetVo>> findUnionByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="monthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetDto dto) {
        try {
            Page page = this.monthBudgetService.findUnionByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8003\u6838\u901a\u62a5\u5206\u9875\u67e5\u8be2\u9884\u7b97")
    @GetMapping(value={"findExamineCircularByConditions"})
    public Result<Page<MonthBudgetExamineCircularQueryVo>> findExamineCircularByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="monthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetExamineCircularQueryDto dto) {
        try {
            Page page = this.monthBudgetService.findExamineCircularByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @PostMapping(value={"listByCodes"})
    public Result<List<MonthBudgetVo>> listByCodes(@RequestBody List<String> codes) {
        try {
            List result = this.monthBudgetService.listByCodes(codes);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5546\u52a1\u653f\u7b56\u6839\u636e\u7f16\u7801\u67e5\u8be2\u9884\u7b97")
    @PostMapping(value={"findBusinessPolicyByCodes"})
    public Result<List<MonthBudgetBusinessPolicyQueryVo>> findBusinessPolicyByCodes(@RequestBody List<String> monthBudgetCodes) {
        try {
            List result = this.monthBudgetService.findBusinessPolicyByCodes(monthBudgetCodes);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5546\u52a1\u653f\u7b56\u5206\u9875\u67e5\u8be2\u9884\u7b97")
    @GetMapping(value={"findBusinessPolicyByConditions"})
    public Result<Page<MonthBudgetBusinessPolicyQueryVo>> findBusinessPolicyByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MonthBudgetBusinessPolicyQueryDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetBusinessPolicyQueryDto dto) {
        try {
            Page page = this.monthBudgetService.findBusinessPolicyByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6708\u5ea6\u9884\u7b97\u660e\u7ec6\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/detail/findByConditions"})
    public Result<Page<MonthBudgetDetailVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="monthBudgetDetailDto", value="\u6708\u5ea6\u9884\u7b97\u660e\u7ec6\u4fe1\u606f") MonthBudgetDetailDto dto) {
        try {
            Page<MonthBudgetDetailVo> page = this.monthBudgetDetailService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"detail"})
    public Result<MonthBudgetVo> detail(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            MonthBudgetVo monthBudgetVo = this.monthBudgetService.findById(id);
            return Result.ok((Object)monthBudgetVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u591a\u6761\u6570\u636e")
    @GetMapping(value={"details"})
    public Result<List<MonthBudgetVo>> details(@RequestParam(value="ids") @ApiParam(name="ids", value="\u4e3b\u952eid") List<String> ids) {
        try {
            List monthBudgetVoList = this.monthBudgetService.findByIds(ids);
            return Result.ok((Object)monthBudgetVoList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u6570\u636e")
    @PostMapping(value={"listByBudgetItemCodeList"})
    public Result<List<MonthBudgetVo>> listByBudgetItemCodeList(@RequestBody List<String> budgetItemCodeList) {
        try {
            List result = this.monthBudgetService.listByBudgetItemCodeList(budgetItemCodeList);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5e74\u5ea6\u9884\u7b97\u7f16\u7801\u6279\u91cf\u67e5\u8be2")
    @GetMapping(value={"listByYearBudgetCode"})
    public Result<List<MonthBudgetVo>> listByYearBudgetCode(@RequestParam(value="yearBudgetCode") String yearBudgetCode) {
        try {
            List result = this.monthBudgetService.listByYearBudgetCode(yearBudgetCode);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u64cd\u4f5c\u6708\u5ea6\u9884\u7b97")
    @GetMapping(value={"operateBudget"})
    public Result<?> operateBudget(String monthBudgetCode, BigDecimal operationAmount, String budgetType, String operationType, String businessCode) {
        try {
            this.monthBudgetService.operateBudget(monthBudgetCode, operationAmount, budgetType, operationType, businessCode);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u6279\u91cf\u52a0\u9501")
    @GetMapping(value={"lockBatch"})
    public Result<Boolean> lockBatch(List<String> monthBudgetCodeList, TimeUnit timeUnit, int time) {
        try {
            boolean result = this.monthBudgetLockService.lock(monthBudgetCodeList, timeUnit, time);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u6279\u91cf\u52a0\u9501")
    @PostMapping(value={"lockBatchPost"})
    public Result<Boolean> lockBatchPost(@RequestBody MonthBudgetBatchLockDto dto) {
        try {
            boolean result = this.monthBudgetLockService.lock(dto.getMonthBudgetCodeList(), dto.getTimeUnit(), dto.getLockTime(), dto.getWaiteTime());
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u6279\u91cf\u89e3\u9501")
    @PostMapping(value={"unLockBatch"})
    public Result unLockBatch(@RequestBody List<String> monthBudgetCodeList) {
        try {
            this.monthBudgetLockService.unLock(monthBudgetCodeList);
            return Result.ok((String)"\u9884\u7b97\u6279\u91cf\u89e3\u9501\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u52a0\u9501")
    @GetMapping(value={"lock"})
    public Result<Boolean> lock(String monthBudgetCode, TimeUnit timeUnit, int time) {
        try {
            boolean result = this.monthBudgetLockService.lock(monthBudgetCode, timeUnit, time);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u52a0\u9501")
    @PostMapping(value={"lock"})
    public Result<Boolean> lockPost(@RequestBody MonthBudgetLockDto dto) {
        try {
            boolean result = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), dto.getTimeUnit(), dto.getTime());
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u89e3\u9501")
    @GetMapping(value={"unLock"})
    public Result unLock(@RequestParam(value="monthBudgetCode") String monthBudgetCode) {
        try {
            this.monthBudgetLockService.unLock(monthBudgetCode);
            return Result.ok((String)"\u89e3\u9501\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8c03\u6574")
    @PostMapping(value={"adjust"})
    public Result adjust(@ApiParam(name="monthBudgetAdjustDto", value="TPM-\u6708\u5ea6\u9884\u7b97") @RequestBody MonthBudgetAdjustDto dto) {
        try {
            this.monthBudgetService.adjust(dto);
            return Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6708\u5ea6\u9884\u7b97\u591a\u9009\u8c03\u6574\u8c03\u6574")
    @PostMapping(value={"monthBudgetAdjust"})
    public Result monthBudgetAdjust(@ApiParam(name="monthBudgetAdjustDto", value="TPM-\u6708\u5ea6\u9884\u7b97") @RequestBody MonthBudgetAdjustDto dto) {
        try {
            this.monthBudgetService.monthBudgetAdjust(dto);
            return Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u4e2d\u67e5\u770b\u8c03\u6574\u660e\u7ec6\uff08bpm\u4f7f\u7528\uff09")
    @GetMapping(value={"adjustQuery"})
    public Result<MonthBudgetMainAdjustVo> adjustQuery(@RequestParam(value="processNo") @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u7801") String processNo) {
        try {
            MonthBudgetMainAdjustVo monthBudgetMainAdjustVo = this.monthBudgetService.adjustQuery(processNo);
            return Result.ok((Object)monthBudgetMainAdjustVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u4e2d\u67e5\u770b\u8c03\u6574\u660e\u7ec6-\u6279\u91cf\u67e5\u8be2\uff08bpm\u4f7f\u7528\uff09")
    @GetMapping(value={"adjustSumQuery"})
    public Result<MonthBudgetMainAdjustVo> adjustSumQuery(@RequestParam(value="processNo") @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u7801") String processNo) {
        try {
            MonthBudgetMainAdjustVo monthBudgetMainAdjustVo = this.monthBudgetService.adjustSumQuery(processNo);
            return Result.ok((Object)monthBudgetMainAdjustVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d8\u66f4")
    @PostMapping(value={"change"})
    public Result change(@ApiParam(name="monthBudgetOperateDto", value="TPM-\u6708\u5ea6\u9884\u7b97") @RequestBody MonthBudgetOperateDto dto) {
        try {
            this.monthBudgetService.change(dto);
            return Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u4e2d\u67e5\u770b\u53d8\u66f4\u660e\u7ec6\uff08bpm\u4f7f\u7528\uff09")
    @GetMapping(value={"changeQuery"})
    public Result<MonthBudgetChangeVo> changeQuery(@RequestParam(value="processNo") @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u7801") String processNo) {
        try {
            MonthBudgetChangeVo monthBudgetChangeVo = this.monthBudgetService.changeQuery(processNo);
            return Result.ok((Object)monthBudgetChangeVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u51bb\u7ed3")
    @PostMapping(value={"freeze"})
    public Result freeze(@ApiParam(name="monthBudgetOperateDto", value="TPM-\u6708\u5ea6\u9884\u7b97") @RequestBody MonthBudgetOperateDto dto) {
        try {
            this.monthBudgetService.unOrFreeze(dto, BudgetOperationTypeEnum.FREEZE.getCode());
            return Result.ok((String)"\u51bb\u7ed3\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89e3\u51bb")
    @PostMapping(value={"unfreeze"})
    public Result unfreeze(@ApiParam(name="monthBudgetOperateDto", value="TPM-\u6708\u5ea6\u9884\u7b97") @RequestBody MonthBudgetOperateDto dto) {
        try {
            this.monthBudgetService.unOrFreeze(dto, BudgetOperationTypeEnum.UNFREEZE.getCode());
            return Result.ok((String)"\u89e3\u51bb\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5212\u62e8")
    @PostMapping(value={"transfer"})
    public Result transfer(@ApiParam(name="monthBudgetOperateDto", value="TPM-\u6708\u5ea6\u9884\u7b97") @RequestBody MonthBudgetTransferDto dto) {
        try {
            this.monthBudgetService.transfer(dto);
            return Result.ok((String)"\u5212\u62e8\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u6267\u884c\u6eda\u52a8")
    @PostMapping(value={"manualRolling"})
    public Result manualRolling(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualRolling(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u6eda\u52a8\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\uff08\u8ba1\u5212\u91cf\uff09")
    @PostMapping(value={"manualReplay"})
    public Result manualReplay(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualReplay(ids, BooleanEnum.TRUE.getCapital());
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\uff08\u8ba1\u5212\u91cf\uff09")
    @GetMapping(value={"manualReplayYearMonth"})
    public Result manualReplayYearMonth(@ApiParam(name="yearMonth", value="\u5e74\u6708") @RequestParam(value="yearMonth") String yearMonth) {
        try {
            AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
            if (this.redisLockService.isLock("month_budget:lock:" + yearMonth)) {
                throw new RuntimeException("\u8ba1\u5212\u91cf\u8ba1\u7b97\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e");
            }
            this.monthBudgetService.manualReplayYearMonth(yearMonth, BooleanEnum.TRUE.getCapital(), crmUserIdentity);
            return Result.ok((String)"\u5f00\u59cb\u624b\u52a8\u8ba1\u7b97\u8ba1\u5212\u91cf\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u7ed3\u679c");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\uff08\u56de\u590d\u91cf\uff09")
    @PostMapping(value={"manualRestoreReplay"})
    public Result manualRestoreReplay(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualReplay(ids, BooleanEnum.FALSE.getCapital());
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9500\u7ba1\u8d44\u91d1\u6c60\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u91cf\uff08\u56de\u590d\u91cf\uff09")
    @PostMapping(value={"manualRestoreReplayReimburse"})
    public Result manualRestoreReplayReimburse(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualRestoreReplayReimburse(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9500\u7ba1\u8d44\u91d1\u6c60\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u5dee")
    @PostMapping(value={"manualActualReplayDiffReimburse"})
    public Result manualActualReplayDiffReimburse(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualActualReplayDiffReimburse(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u8ba1\u5212\u91cf")
    @PostMapping(value={"manualRestoreReplayPlanOthers"})
    public Result manualRestoreReplayPlanOthers(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualRestoreReplayOthers(ids, BooleanEnum.TRUE.getCapital());
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u8ba1\u5212\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u91cf")
    @PostMapping(value={"manualRestoreReplayRestoreOthers"})
    public Result manualRestoreReplayRestoreOthers(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualRestoreReplayOthers(ids, BooleanEnum.FALSE.getCapital());
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u5dee")
    @PostMapping(value={"manualActualReplayDiffOthers"})
    public Result manualActualReplayDiffOthers(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualActualReplayDiffOthers(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7279\u4ed1\u82cf\u7edf\u7b79\u548c\u6388\u6743\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u91cf")
    @PostMapping(value={"manualRestoreReplayRestoreDeluxu"})
    public Result manualRestoreReplayRestoreDeluxu(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualRestoreReplayRestoreDeluxu(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u7279\u4ed1\u82cf\u7edf\u7b79\u548c\u6388\u6743\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u56de\u590d\u91cf\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7279\u4ed1\u82cf\u7edf\u7b79\u548c\u6388\u6743\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u6708\u5ea6\u5b9e\u9500\u56de\u590d\u5dee")
    @PostMapping(value={"manualActualReplayDiffDeluxuMonth"})
    public Result manualActualReplayDiffDeluxuMonth(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualActualReplayDiffDeluxuMonth(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u5dee\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7279\u4ed1\u82cf\u7edf\u7b79\u548c\u6388\u6743\u9884\u7b97\u9879\u76ee\u8ba1\u7b97\u5b63\u5ea6\u5b9e\u9500\u56de\u590d\u5dee")
    @PostMapping(value={"manualActualReplayDiffDeluxuQuarter"})
    public Result manualActualReplayDiffDeluxuQuarter(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetService.manualActualReplayDiffDeluxuQuarter(ids);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u56de\u590d\u5dee\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u6267\u884c\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d")
    @PostMapping(value={"manualActualReplayDiff"})
    public Result manualActualReplayDiff(@ApiParam(name="ids", value="TPM-\u6708\u5ea6\u9884\u7b97ids") @RequestBody List<String> ids) {
        try {
            this.monthBudgetActualReplayService.manualActualReplayDiffMq(ids);
            return Result.ok((String)"\u5f02\u6b65\u6267\u884c\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u8be2\u6267\u884c\u7ed3\u679c!");
        }
        catch (Exception e) {
            log.info("\u624b\u52a8\u6267\u884c\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d\u5931\u8d25");
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u63a7\u91d1\u989d")
    @PostMapping(value={"mapControlAmount"})
    public Result<Map<String, MonthBudgetControlVo>> mapControlAmount(@RequestBody List<String> monthBudgetCodeList) {
        try {
            Map map = this.monthBudgetService.mapControlAmount(monthBudgetCodeList);
            return Result.ok((Object)map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u9884\u7b97\u5173\u8054\u7684\u5ba2\u6237\u9884\u7b97")
    @PostMapping(value={"findCustomerGroupMonthBudget"})
    public Result<List<MonthBudgetVo>> findCustomerGroupMonthBudget(@RequestBody List<MonthBudgetDto> dtos) {
        try {
            return Result.ok((Object)this.monthBudgetService.findCustomerGroupMonthBudget(dtos));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5e74\u6708\u624b\u52a8\u6267\u884c\u8ba1\u7b97\u8ba1\u5212\u91cf")
    @GetMapping(value={"planAutoSyncXxlJob"})
    public Result planAutoSyncXxlJob(@ApiParam(name="yearMonth", value="\u5e74\u6708") @RequestParam(value="yearMonth", required=false) String yearMonth) {
        try {
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u8ba1\u5212\u91cf[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            Date date = null;
            if (StringUtils.isEmpty((CharSequence)yearMonth)) {
                Calendar calendar = DateUtil.getCalendar();
                calendar.setTime(new Date());
                calendar.add(2, 1);
                date = calendar.getTime();
            } else {
                date = DateUtil.parseDate((String)yearMonth, (String)"yyyy-MM");
            }
            Assert.notNull((Object)date, (String)("\u5e74\u6708[" + yearMonth + "]\u4e0d\u5408\u6cd5,\u683c\u5f0f\u5fc5\u987b\u4e3a[" + "yyyy-MM" + "]!"));
            yearMonth = DateUtil.format((Date)date, (String)"yyyy-MM");
            ArrayList<String> businessUnitCodeList = new ArrayList<String>();
            businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
            this.monthBudgetService.autoPlan(yearMonth, businessUnitCodeList);
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u8ba1\u5212\u91cf[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.monthBudgetService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u6267\u884c\u4e3b\u4f53\u8ba1\u7b97\u5e74\u5ea6\u7d2f\u8ba1\u53ef\u7528\u91d1\u989d")
    @GetMapping(value={"/manualcalHeadYearTotalAvailableBalance"})
    public Result<?> manualcalHeadYearTotalAvailableBalance(@ApiParam(name="yearMonth", value="\u5e74\u6708(yyyy-MM)") @RequestParam(value="yearMonth", required=true) String yearMonth) {
        try {
            this.monthBudgetService.calHeadYearTotalAvailableBalanceSyncXxlJob(yearMonth);
            return Result.ok((String)"\u624b\u52a8\u6267\u884c\u4e3b\u4f53\u8ba1\u7b97\u5e74\u5ea6\u7d2f\u8ba1\u53ef\u7528\u91d1\u989d\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c")
    @PostMapping(value={"manualVerticalActualSalesAutoSyncXxlJob"})
    public Result manualVerticalActualSalesAutoSyncXxlJob(@RequestBody List<String> yearMonthList) {
        Validate.notEmpty(yearMonthList, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        boolean lock = true;
        String lockKey = this.verticalActualSalesAutoSyncXxlJob.getLockKey() + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                Result result = Result.error((String)"\u6267\u884c\u4e2d...");
                return result;
            }
            for (String yearMonth : yearMonthList) {
                this.verticalActualSalesAutoSyncXxlJob.handle(yearMonth);
            }
        }
        catch (Exception e) {
            Result result = Result.error((String)("\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
            return result;
        }
        finally {
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9645\u9500\u91cf\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5782\u76f4\u8ba1\u7b97\u56de\u590d\u91cf\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c")
    @PostMapping(value={"manualVerticalPlanReplayAutoSyncXxlJob"})
    public Result manualVerticalPlanReplayAutoSyncXxlJob(@RequestBody List<String> yearMonthList) {
        Validate.notEmpty(yearMonthList, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u56de\u590d\u91cf\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        boolean lock = true;
        String lockKey = "manualVerticalPlanReplayAutoSyncXxlJob" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                Result result = Result.error((String)"\u6267\u884c\u4e2d...");
                return result;
            }
            for (String yearMonth : yearMonthList) {
                this.autoPullMonthPlanReplayXxJob.handle(yearMonth);
            }
        }
        catch (Exception e) {
            Result result = Result.error((String)("\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
            return result;
        }
        finally {
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u56de\u590d\u91cf\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5782\u76f4\u8ba1\u7b97\u9500\u552e\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c")
    @PostMapping(value={"manualVerticalPlanAutoSyncXxlJob"})
    public Result manualVerticalPlanAutoSyncXxlJob(@RequestBody List<String> yearMonthList) {
        Validate.notEmpty(yearMonthList, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u9500\u552e\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        boolean lock = true;
        String lockKey = "manualVerticalPlanAutoSyncXxlJob" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                Result result = Result.error((String)"\u6267\u884c\u4e2d...");
                return result;
            }
            for (String yearMonth : yearMonthList) {
                this.autoPullMonthPlanXxJob.handle(yearMonth);
            }
        }
        catch (Exception e) {
            Result result = Result.error((String)("\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
            return result;
        }
        finally {
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u9500\u552e\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5782\u76f4\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee")
    @PostMapping(value={"manualVerticalActualDiffAutoSyncXxlJob"})
    public Result manualVerticalActualDiffAutoSyncXxlJob(@RequestBody List<String> yearMonthList) {
        Validate.notEmpty(yearMonthList, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee\u6267\u884c[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        boolean lock = true;
        String lockKey = "manualVerticalActualDiffAutoSyncXxlJob" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                Result result = Result.error((String)"\u6267\u884c\u4e2d...");
                return result;
            }
            for (String yearMonth : yearMonthList) {
                log.info("manualVerticalActualDiffAutoSyncXxlJob\uff0c\u5e74\u6708[{}}\uff0c\u8ba1\u5212\u91cf\uff1a{}", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
                this.autoPullMonthPlanXxJob.publish(yearMonth);
                log.info("manualVerticalActualDiffAutoSyncXxlJob\uff0c\u5e74\u6708[{}}\uff0c\u56de\u590d\u91cf\uff1a{}", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
                this.autoPullMonthPlanReplayXxJob.publish(yearMonth);
                log.info("manualVerticalActualDiffAutoSyncXxlJob\uff0c\u5e74\u6708[{}}\uff0c\u5b9e\u9500\u56de\u590d\u5dee\uff1a{}", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
                this.verticalActualSalesAutoSyncXxlJob.handle(yearMonth);
                log.info("manualVerticalActualDiffAutoSyncXxlJob\uff0c\u5e74\u6708[{}}\uff0c\u7ed3\u675f\uff1a{}", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
            }
        }
        catch (Exception e) {
            Result result = Result.error((String)("\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
            return result;
        }
        finally {
            log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee\u6267\u884c[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5782\u76f4\u9884\u7b97\u6eda\u52a8\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c")
    @PostMapping(value={"manualVerticalRollingAutoSyncXxlJob"})
    public Result manualVerticalRollingAutoSyncXxlJob(@RequestBody List<String> yearMonthList) {
        Validate.notEmpty(yearMonthList, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("=====>    \u5782\u76f4\u9884\u7b97\u6eda\u52a8\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        boolean lock = true;
        String lockKey = "manualVerticalRollingAutoSyncXxlJob" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 12L);
            if (!lock) {
                Result result = Result.error((String)"\u6267\u884c\u4e2d...");
                return result;
            }
            for (String yearMonth : yearMonthList) {
                log.info("manualVerticalRollingAutoSyncXxlJob\uff0c\u5e74\u6708[{}}\uff0cstart \uff1a{}", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
                this.verticalRollingAutoSyncXxlJob.handle(yearMonth);
                log.info("manualVerticalRollingAutoSyncXxlJob\uff0c\u5e74\u6708[{}}\uff0cend \uff1a{}", (Object)yearMonth, (Object)DateUtil.dateStrNowAll());
            }
        }
        catch (Exception e) {
            Result result = Result.error((String)("\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
            return result;
        }
        finally {
            log.info("=====>    \u5782\u76f4\u9884\u7b97\u6eda\u52a8\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7ed3\u6848\u6838\u9500\u8c03\u6574\u67e5\u8be2\u9884\u7b97")
    @GetMapping(value={"auditAdjustFindBudget"})
    public Result<Page<MonthBudgetVo>> auditAdjustFindBudget(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, String customerCode) {
        try {
            Page page = this.monthBudgetService.auditAdjustFindBudget(pageable, customerCode);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findPageForOut"})
    public Result<Page<MonthBudgetVo>> findPageForOut(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, MonthBudgetDto dto) {
        try {
            Page page = this.monthBudgetService.findPageForOut(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

