/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailExportVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonthBudgetDetailExportProcess
implements ExportProcess<MonthBudgetDetailExportVo> {
    @Autowired(required=false)
    private MonthBudgetMapper exportMapper;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        MonthBudgetDetailDto dto = this.convertParams(params);
        Page<MonthBudgetDetailExportVo> pageResult = this.exportMapper.findExportByConditions((Page<MonthBudgetDetailExportVo>)new Page(0L, 1L), dto);
        Integer total = (int)pageResult.getTotal();
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private MonthBudgetDetailDto convertParams(Map<String, Object> params) {
        return (MonthBudgetDetailDto)JSON.parseObject((String)JSON.toJSONString(params), MonthBudgetDetailDto.class);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        MonthBudgetDetailDto dto = this.convertParams(params);
        Page pageable = new Page((long)(vo.getPageNo() + 1), (long)this.getPageSize().intValue());
        Page<MonthBudgetDetailExportVo> page = this.exportMapper.findExportByConditions((Page<MonthBudgetDetailExportVo>)pageable, dto);
        return JSON.parseArray((String)JSON.toJSONString(this.adjustData(page.getRecords())));
    }

    public Class<MonthBudgetDetailExportVo> findCrmExcelVoClass() {
        return MonthBudgetDetailExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_MONTH_BUDGET_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u660e\u7ec6\u5bfc\u51fa";
    }

    private List<MonthBudgetDetailExportVo> adjustData(List<MonthBudgetDetailExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<MonthBudgetDetailExportVo>(0);
        }
        Map mapDict = this.dictToolkitService.findMapByDictTypeCode("tpm_budget_operation_type");
        for (MonthBudgetDetailExportVo datum : data) {
            BusinessUnitEnum unitEnum;
            datum.setOperationType(mapDict.getOrDefault(datum.getOperationType(), datum.getOperationType()));
            if (!StringUtils.isNotBlank((CharSequence)datum.getBusinessCode()) || null == (unitEnum = BusinessUnitEnum.codeToEnum((String)datum.getBusinessCode()))) continue;
            datum.setBusinessCode(unitEnum.getDesc());
        }
        return data;
    }
}

