/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.filter;

import cn.hutool.core.util.StrUtil;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;

public abstract class MonthBudgetConditionFilter {
    protected MonthBudgetGroupEnum getGroup(String businessFormatCode, String businessUnitCode) {
        if (StrUtil.isBlank((CharSequence)businessFormatCode) || StrUtil.isBlank((CharSequence)businessUnitCode)) {
            return null;
        }
        if (BusinessFormatEnum.NORMAL.getCode().equals(businessFormatCode) && BusinessUnitEnum.isDefaultBusinessUnit((String)businessUnitCode)) {
            return MonthBudgetGroupEnum.organization;
        }
        return null;
    }

    public void buildDto(MonthBudgetDto monthBudgetDto) {
        MonthBudgetGroupEnum budgetGroupEnum = this.getGroup(monthBudgetDto.getBusinessFormatCode(), monthBudgetDto.getBusinessUnitCode());
        if (budgetGroupEnum == null) {
            return;
        }
        switch (budgetGroupEnum) {
            case system: {
                this.buildBySystem(monthBudgetDto);
                break;
            }
            case customer: {
                this.buildByCustomer(monthBudgetDto);
                break;
            }
            case organization: {
                this.buildByOrganization(monthBudgetDto);
                break;
            }
            case channel: {
                this.buildByChannel(monthBudgetDto);
                break;
            }
            case terminal: {
                this.buildByTerminal(monthBudgetDto);
                break;
            }
        }
    }

    protected void buildBySystem(MonthBudgetDto dto) {
    }

    protected void buildByCustomer(MonthBudgetDto dto) {
    }

    protected void buildByOrganization(MonthBudgetDto dto) {
    }

    protected void buildByChannel(MonthBudgetDto dto) {
    }

    protected void buildByTerminal(MonthBudgetDto dto) {
    }
}

