/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.RollingTypeEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class MonthBudgetCalculateHelper {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetCalculateHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MonthBudgetRepository monthBudgetRepository;
    @Autowired(required=false)
    private MonthBudgetDetailRepository monthBudgetDetailRepository;

    public BigDecimal buildAfterFreezeAmount(MonthBudgetEntity entity, BusinessUnitEnum unitEnum) {
        return Optional.ofNullable(entity.getInitResolveAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(entity.getFirstReplyResolveDiffAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getActualReplyDiff()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getMonthRollingAmount()).orElse(BigDecimal.ZERO));
    }

    public BigDecimal buildAccumulatedAvailableBalance(MonthBudgetEntity entity, BusinessUnitEnum unitEnum) {
        return Optional.ofNullable(entity.getInitResolveAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(entity.getFirstReplyResolveDiffAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getActualReplyDiff()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getApprovedAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getMonthRollingAmount()).orElse(BigDecimal.ZERO));
    }

    public BigDecimal buildAccumulatedAvailableBalanceBefore(MonthBudgetEntity entity, BusinessUnitEnum unitEnum) {
        return Optional.ofNullable(entity.getInitResolveAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(entity.getFirstReplyResolveDiffAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getActualReplyDiff()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getApprovedAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO));
    }

    public BigDecimal buildAfterFreezeAmountHeadquartersAndOnline(MonthBudgetEntity entity, BusinessUnitEnum unitEnum) {
        BigDecimal result = Optional.ofNullable(entity.getInitResolveAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(entity.getFirstReplyResolveDiffAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO));
        log.info("\u9884\u7b97[" + entity.getMonthBudgetCode() + "]\u51bb\u7ed3\u540e\u53ef\u7528\u91d1\u989d\u8ba1\u7b97={}", (Object)result);
        return result;
    }

    public BigDecimal buildAccumulatedAvailableBalanceHeadquartersAndOnline(MonthBudgetEntity entity, BusinessUnitEnum unitEnum) {
        BigDecimal result = Optional.ofNullable(entity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getApprovedAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getMonthRollingAmount()).orElse(BigDecimal.ZERO));
        log.info("\u9884\u7b97[" + entity.getMonthBudgetCode() + "]\u7d2f\u8ba1\u53ef\u7528\u91d1\u989d\u8ba1\u7b97={}", (Object)result);
        return result;
    }

    public void calculationActualReplyDiffVertical(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget) {
        String businessCode;
        MonthBudgetDetailVo monthBudgetDetailVo;
        BigDecimal firstReplyAmount = actualSalesVo.getFirstReplyAmount();
        if (ObjectUtils.isEmpty((Object)firstReplyAmount)) {
            return;
        }
        BigDecimal actualSalesAmount = actualSalesVo.getActualSalesAmount();
        BigDecimal actualCostsAmount = actualSalesVo.getActualCostsAmount();
        if (ObjectUtils.isEmpty((Object)actualCostsAmount)) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)actualSalesVo.getCalAmount())) {
            return;
        }
        MonthBudgetEntity entity = null;
        entity = BooleanEnum.TRUE.getCapital().equals(actualSalesVo.getRolling()) && !ObjectUtils.isEmpty((Object)currMonthBudget) ? (MonthBudgetEntity)((Object)this.monthBudgetRepository.getById((Serializable)((Object)currMonthBudget.getId()))) : (MonthBudgetEntity)((Object)this.monthBudgetRepository.getById((Serializable)((Object)actualSalesVo.getId())));
        BigDecimal diffAmount = actualCostsAmount.subtract(firstReplyAmount).setScale(6, 4);
        log.error("\u5b9e\u9500\u56de\u590d\u5dee={}", (Object)diffAmount);
        if (StringUtils.hasText((String)actualSalesVo.getDAY())) {
            Calendar cl = Calendar.getInstance();
            String yearMonthDay = DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM-dd");
            String currDay = yearMonthDay.split("-")[2];
            if (!currDay.equals(actualSalesVo.getDAY()) && actualSalesAmount.compareTo(actualSalesVo.getCalAmount()) <= 0) {
                return;
            }
        } else if (BigDecimal.ZERO.compareTo(diffAmount) == 0) {
            entity.setActualReplyDiff(diffAmount);
            log.error("\u7b2c\u4e00\u79cd\u60c5\u51b5\u66f4\u65b0\uff0c\u6570\u636e={}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            this.monthBudgetRepository.updateById((Object)entity);
            return;
        }
        if (ObjectUtils.isEmpty((Object)(monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode = actualSalesVo.getMonthBudgetCode() + DateUtil.getDate((String)"yyyyMM"))))) {
            entity.setActualReplyDiff(diffAmount);
            entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalance(entity, BusinessUnitEnum.VERTICAL));
            entity.setAfterFreezeAmount(this.buildAfterFreezeAmount(entity, BusinessUnitEnum.VERTICAL));
            MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetail(entity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode);
            this.monthBudgetDetailRepository.save((Object)detailEntity);
            log.error("\u7b2c\u4e8c\u79cd\u60c5\u51b5\u66f4\u65b0\uff0c\u6570\u636e={}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            this.monthBudgetRepository.updateById((Object)entity);
        } else if (monthBudgetDetailVo.getMonthBudgetCode().equals(entity.getMonthBudgetCode())) {
            BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
            if (histOperationAmount.compareTo(diffAmount) != 0) {
                entity.setActualReplyDiff(entity.getActualReplyDiff().subtract(histOperationAmount));
                entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalance(entity, BusinessUnitEnum.VERTICAL));
                entity.setAfterFreezeAmount(this.buildAfterFreezeAmount(entity, BusinessUnitEnum.VERTICAL));
                MonthBudgetDetailEntity histDetailEntity = this.buildActualReplyDiffDetail(entity, histOperationAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), BudgetOperationTypeEnum.ACTUAL_SALES.getCode());
                entity.setActualReplyDiff(diffAmount);
                entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalance(entity, BusinessUnitEnum.VERTICAL));
                entity.setAfterFreezeAmount(this.buildAfterFreezeAmount(entity, BusinessUnitEnum.VERTICAL));
                MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetail(entity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode);
                this.monthBudgetDetailRepository.save((Object)histDetailEntity);
                this.monthBudgetDetailRepository.save((Object)detailEntity);
                this.monthBudgetRepository.updateById((Object)entity);
            }
        } else {
            String monthBudgetCode = monthBudgetDetailVo.getMonthBudgetCode();
            BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
            MonthBudgetEntity histEntity = this.monthBudgetRepository.getByMonthBudgetCode(monthBudgetCode, null);
            histEntity.setActualReplyDiff(histEntity.getActualReplyDiff().subtract(histOperationAmount));
            histEntity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalance(histEntity, BusinessUnitEnum.VERTICAL));
            histEntity.setAfterFreezeAmount(this.buildAfterFreezeAmount(histEntity, BusinessUnitEnum.VERTICAL));
            MonthBudgetDetailEntity histDetailEntity = this.buildActualReplyDiffDetail(histEntity, histOperationAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), BudgetOperationTypeEnum.ACTUAL_SALES.getCode());
            this.monthBudgetDetailRepository.save((Object)histDetailEntity);
            this.monthBudgetRepository.updateById((Object)histEntity);
            entity.setActualReplyDiff(diffAmount);
            entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalance(entity, BusinessUnitEnum.VERTICAL));
            entity.setAfterFreezeAmount(this.buildAfterFreezeAmount(entity, BusinessUnitEnum.VERTICAL));
            MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetail(entity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode);
            this.monthBudgetDetailRepository.save((Object)detailEntity);
            log.error("\u7b2c\u4e09\u79cd\u60c5\u51b5\u66f4\u65b0\uff0c\u6570\u636e={}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            this.monthBudgetRepository.updateById((Object)entity);
        }
    }

    public void calculationActualReplyDiffHead(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget) {
        BigDecimal firstReplyAmount = actualSalesVo.getFirstReplyAmount();
        if (Objects.isNull(firstReplyAmount)) {
            return;
        }
        BigDecimal actualSalesAmount = actualSalesVo.getActualSalesAmount();
        if (Objects.isNull(actualSalesAmount)) {
            return;
        }
        MonthBudgetEntity entity = (MonthBudgetEntity)((Object)this.monthBudgetRepository.getById((Serializable)((Object)actualSalesVo.getId())));
        if (Objects.isNull((Object)entity)) {
            return;
        }
        BigDecimal diffAmount = actualSalesAmount.subtract(firstReplyAmount).setScale(6, 4);
        entity.setActualReplyDiff(diffAmount);
        log.error("\u5b9e\u9500\u56de\u590d\u5dee={}", (Object)diffAmount);
        if (BigDecimal.ZERO.compareTo(diffAmount) == 0) {
            this.monthBudgetRepository.updateById((Object)entity);
            return;
        }
        Date date = DateUtil.strToDate((String)actualSalesVo.getYearMonthLy(), (SimpleDateFormat)DateUtil.date_yyyy_MM);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date currDate = DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(currDate);
        String curryearMonth = DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM);
        if (calendar.get(1) != calendar2.get(1)) {
            log.error("\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee-\u300b\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u5e74");
            return;
        }
        boolean rollTag = false;
        if (BooleanEnum.TRUE.getCapital().equals(actualSalesVo.getRolling()) && calendar.get(2) != 11) {
            if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(actualSalesVo.getRollingType())) {
                rollTag = true;
            }
            if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(actualSalesVo.getRollingType()) && BigDecimal.ZERO.compareTo(diffAmount) < 0) {
                rollTag = true;
            }
            if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(actualSalesVo.getRollingType()) && BigDecimal.ZERO.compareTo(diffAmount) > 0) {
                rollTag = true;
            }
        }
        if (rollTag) {
            if (currDate.getTime() <= date.getTime()) {
                log.error("\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee-\u300b\u5f53\u524d\u5e74\u6708\u5fc5\u987b\u5927\u4e8e\u9009\u62e9\u7684\u9884\u7b97\u5e74\u6708");
                return;
            }
            MonthBudgetEntity currEntity = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(actualSalesVo.getYearBudgetCode(), curryearMonth);
            this.monthBudgetRepository.updateById((Object)entity);
            String businessCode = entity.getMonthBudgetCode() + "-" + DateUtil.getDate((String)"yyyyMM");
            MonthBudgetDetailVo monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode);
            if (Objects.isNull(monthBudgetDetailVo)) {
                BigDecimal beforeAmount = currEntity.getAccumulatedAvailableBalance();
                currEntity.setAdjustAmount(Optional.ofNullable(currEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                currEntity.setAfterFreezeAmount(this.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                currEntity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetailHead(currEntity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                this.monthBudgetDetailRepository.save((Object)detailEntity);
                this.monthBudgetRepository.updateById((Object)currEntity);
            } else {
                BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
                if (histOperationAmount.compareTo(diffAmount) != 0) {
                    BigDecimal beforeAmount = currEntity.getAccumulatedAvailableBalance();
                    currEntity.setAdjustAmount(Optional.ofNullable(currEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(histOperationAmount));
                    currEntity.setAfterFreezeAmount(this.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                    currEntity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                    MonthBudgetDetailEntity histDetailEntity = this.buildActualReplyDiffDetailHead(currEntity, histOperationAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                    this.monthBudgetDetailRepository.save((Object)histDetailEntity);
                    BigDecimal beforeAmount2 = currEntity.getAccumulatedAvailableBalance();
                    currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                    currEntity.setAfterFreezeAmount(this.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                    currEntity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                    MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetailHead(currEntity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount2);
                    this.monthBudgetDetailRepository.save((Object)detailEntity);
                    this.monthBudgetRepository.updateById((Object)currEntity);
                }
            }
        } else {
            String businessCode = actualSalesVo.getMonthBudgetCode() + DateUtil.getDate((String)"yyyyMM");
            MonthBudgetDetailVo monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode);
            if (Objects.isNull(monthBudgetDetailVo)) {
                BigDecimal beforeAmount = entity.getAccumulatedAvailableBalance();
                entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                entity.setAfterFreezeAmount(this.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetailHead(entity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                this.monthBudgetDetailRepository.save((Object)detailEntity);
                this.monthBudgetRepository.updateById((Object)entity);
            } else {
                BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
                if (histOperationAmount.compareTo(diffAmount) != 0) {
                    BigDecimal beforeAmount = entity.getAccumulatedAvailableBalance();
                    entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(histOperationAmount));
                    entity.setAfterFreezeAmount(this.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                    entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                    MonthBudgetDetailEntity histDetailEntity = this.buildActualReplyDiffDetailHead(entity, histOperationAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                    this.monthBudgetDetailRepository.save((Object)histDetailEntity);
                    BigDecimal beforeAmount2 = entity.getAccumulatedAvailableBalance();
                    entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                    entity.setAfterFreezeAmount(this.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                    entity.setAccumulatedAvailableBalance(this.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.VERTICAL));
                    MonthBudgetDetailEntity detailEntity = this.buildActualReplyDiffDetailHead(entity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount2);
                    this.monthBudgetDetailRepository.save((Object)detailEntity);
                    this.monthBudgetRepository.updateById((Object)entity);
                }
            }
        }
    }

    private MonthBudgetDetailEntity buildActualReplyDiffDetail(MonthBudgetEntity entity, BigDecimal amount, String operationType, String businessCode) {
        MonthBudgetDetailEntity detailEntity = (MonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        detailEntity.setId(null);
        detailEntity.setBusinessCode(businessCode);
        detailEntity.setOperationType(operationType);
        detailEntity.setInitialAmount(entity.getInitResolveAmount());
        detailEntity.setBalanceAmount(entity.getAccumulatedAvailableBalance());
        if (amount.compareTo(BigDecimal.ZERO) == 1) {
            detailEntity.setBeforeAmount(entity.getAccumulatedAvailableBalance().subtract(amount));
        } else {
            detailEntity.setBeforeAmount(entity.getAccumulatedAvailableBalance().add(amount));
        }
        detailEntity.setCurOperationAmount(amount);
        return detailEntity;
    }

    public MonthBudgetDetailEntity buildActualReplyDiffDetailHead(MonthBudgetEntity entity, BigDecimal amount, String operationType, String businessCode, BigDecimal beforeAmount) {
        MonthBudgetDetailEntity detailEntity = (MonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        detailEntity.setId(null);
        detailEntity.setBusinessCode(businessCode);
        detailEntity.setOperationType(operationType);
        detailEntity.setInitialAmount(entity.getInitResolveAmount());
        detailEntity.setBalanceAmount(entity.getAccumulatedAvailableBalance());
        detailEntity.setBeforeAmount(beforeAmount);
        detailEntity.setCurOperationAmount(amount);
        return detailEntity;
    }
}

