/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.helper;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.BudgetTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalDataFromEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesPlanAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigDataVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.RollingTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetControlTypeEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetCalculateHelper;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class MonthBudgetHelper {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetHelper.class);
    @Resource
    private MonthBudgetRepository monthBudgetRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private BudgetCalConfigService budgetCalConfigService;
    @Autowired(required=false)
    private DimensionControlsService dimensionControlsService;
    @Autowired(required=false)
    private MonthBudgetDetailRepository monthBudgetDetailRepository;
    @Resource
    private MonthBudgetCalculateHelper monthBudgetCalculateHelper;

    public void calculationReduce(AtomicReference<BigDecimal> reduce, SalesPlanVo salesPlanVo, String amountTypeCode, BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity, BigDecimal budgetTotalPoint) {
        List productRatios = budgetCalConfigVo.getProductRatios();
        HashMap<String, BudgetCalConfigProductRatioVo> productRatioVoMap = new HashMap<String, BudgetCalConfigProductRatioVo>();
        if (!CollectionUtils.isEmpty((Collection)productRatios)) {
            productRatioVoMap.putAll(productRatios.stream().collect(Collectors.toMap(BudgetCalConfigProductRatioVo::getProductCode, e -> e)));
        }
        String productCode = salesPlanVo.getProductCode();
        BigDecimal chargedRatio = null;
        BudgetCalConfigProductRatioVo budgetCalConfigProductRatioVo = (BudgetCalConfigProductRatioVo)productRatioVoMap.get(productCode);
        if (!ObjectUtils.isEmpty((Object)budgetCalConfigProductRatioVo)) {
            chargedRatio = StringUtil.isNotBlank((CharSequence)budgetCalConfigProductRatioVo.getReduceTag()) && BooleanEnum.TRUE.getCapital().equals(budgetCalConfigProductRatioVo.getReduceTag()) ? (!Objects.isNull(budgetTotalPoint) ? budgetTotalPoint.subtract(budgetCalConfigProductRatioVo.getChargedRatio()) : budgetCalConfigProductRatioVo.getChargedRatio()) : budgetCalConfigProductRatioVo.getChargedRatio();
        }
        BigDecimal pointOrIntensity = null;
        String controlTypeCode = budgetCalConfigVo.getControlType();
        if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) {
            Assert.notNull((Object)monthBudgetEntity.getBudgetTotalPoint(), (String)("\u9884\u7b97[" + monthBudgetEntity.getYearBudgetCode() + "]\u603b\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            pointOrIntensity = monthBudgetEntity.getBudgetTotalPoint().divide(new BigDecimal(100), 2, 4);
        } else if (BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
            BigDecimal budgetIntensityNumerator = monthBudgetEntity.getBudgetIntensityNumerator();
            Assert.notNull((Object)budgetIntensityNumerator, (String)("\u9884\u7b97[" + monthBudgetEntity.getYearBudgetCode() + "]\u5e74\u5ea6\u529b\u5ea6\u5206\u5b50\u4e0d\u80fd\u4e3a\u7a7a"));
            BigDecimal budgetIntensityDenominator = monthBudgetEntity.getBudgetIntensityDenominator();
            Assert.notNull((Object)budgetIntensityDenominator, (String)("\u9884\u7b97[" + monthBudgetEntity.getYearBudgetCode() + "]\u5e74\u5ea6\u529b\u5ea6\u5206\u6bcd\u4e0d\u80fd\u4e3a\u7a7a"));
            pointOrIntensity = budgetIntensityNumerator.divide(budgetIntensityDenominator, 6, 4);
        }
        if (FeeBelongEnum.AREA.getCode().equals(budgetCalConfigVo.getFeeBelongCode())) {
            pointOrIntensity = budgetTotalPoint;
        }
        SalesPlanAmountTypeEnum amountTypeEnum = SalesPlanAmountTypeEnum.getByCode((String)amountTypeCode);
        switch (amountTypeEnum) {
            case PLAN_AMOUNT: {
                this.setReduce(salesPlanVo.getPlanAmount(), reduce, chargedRatio, pointOrIntensity);
                break;
            }
            case DISCOUNT_PLAN_AMOUNT: {
                this.setReduce(salesPlanVo.getDiscountPlanAmount(), reduce, chargedRatio, pointOrIntensity);
                break;
            }
            case RESTORE_AMOUNT: {
                this.setReduce(salesPlanVo.getRestoreAmount(), reduce, chargedRatio, pointOrIntensity);
                break;
            }
            case DISCOUNT_RESTORE_AMOUNT: {
                this.setReduce(salesPlanVo.getDiscountRestoreAmount(), reduce, chargedRatio, pointOrIntensity);
                break;
            }
            case DELIVERY_MULTIPLY_PRICE: {
                break;
            }
            case PLAN_QUANTITY: {
                this.setReduce(salesPlanVo.getPlanQuantity(), reduce, chargedRatio, pointOrIntensity);
                break;
            }
            case RESTORE_QUANTITY: {
                this.setReduce(salesPlanVo.getRestoreQuantity(), reduce, chargedRatio, pointOrIntensity);
                break;
            }
        }
    }

    private void setReduce(BigDecimal salesAmount, AtomicReference<BigDecimal> reduce, BigDecimal chargedRatio, BigDecimal budgetTotalPoint) {
        BigDecimal amount = Optional.ofNullable(salesAmount).orElse(BigDecimal.ZERO);
        if (!ObjectUtils.isEmpty((Object)chargedRatio)) {
            Assert.notNull((Object)budgetTotalPoint, (String)"\u9884\u7b97\u603b\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal amountResult = amount.multiply(chargedRatio).divide(budgetTotalPoint, 6, RoundingMode.HALF_UP);
            reduce.set(reduce.get().add(amountResult));
        } else {
            reduce.set(reduce.get().add(amount));
        }
    }

    public BudgetItemControlConditionVo getBudgetItemControlCondition(MonthBudgetEntity monthBudgetEntity, Map<String, BudgetItemVo> finalBudgetItemVoMap) {
        BudgetItemVo budgetItemVo = finalBudgetItemVoMap.get(monthBudgetEntity.getBudgetItemCode());
        if (ObjectUtils.isEmpty((Object)budgetItemVo)) {
            return null;
        }
        List controlConditionDtoList = budgetItemVo.getControlConditionDtoList();
        if (CollectionUtils.isEmpty((Collection)controlConditionDtoList)) {
            return null;
        }
        List conditionVos = finalBudgetItemVoMap.get(monthBudgetEntity.getBudgetItemCode()).getControlConditionDtoList().stream().filter(controlVo -> monthBudgetEntity.getBusinessFormatCode().equals(controlVo.getBusinessFormatCode()) && monthBudgetEntity.getBusinessUnitCode().equals(controlVo.getBusinessUnitCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(conditionVos)) {
            return null;
        }
        return (BudgetItemControlConditionVo)conditionVos.get(0);
    }

    public List<MonthBudgetVo> findByIds(List<String> monthBudgetIds) {
        if (CollectionUtil.isEmpty(monthBudgetIds)) {
            return Collections.emptyList();
        }
        List monthBudgetEntities = this.monthBudgetRepository.listByIds(monthBudgetIds);
        if (CollectionUtil.isEmpty((Collection)monthBudgetEntities)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)monthBudgetEntities, MonthBudgetEntity.class, MonthBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, BudgetItemVo> findBudgetItemByCodes(List<String> budgetItemCodes) {
        if (CollectionUtil.isEmpty(budgetItemCodes)) {
            return Maps.newHashMap();
        }
        List budgetItemVos = this.budgetItemService.listByCodes(budgetItemCodes);
        if (CollectionUtil.isEmpty((Collection)budgetItemVos)) {
            return Maps.newHashMap();
        }
        return budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
    }

    public BudgetCalConfigVo findMonthBudgetCalConfigByDto(MonthBudgetVo monthBudgetVo, String controlTypeCode) {
        List budgetCalConfigVos;
        BudgetCalConfigDto dto = new BudgetCalConfigDto();
        dto.setBudgetTypeCode(BudgetTypeEnum.MONTH_BUDGET.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setBusinessFormatCode(monthBudgetVo.getBusinessFormatCode());
        dto.setBusinessUnitCode(monthBudgetVo.getBusinessUnitCode());
        dto.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetVo.getBusinessUnitCode())) {
            dto.setControlType(controlTypeCode);
            dto.setGroupCode(monthBudgetVo.getGroupCode());
        }
        if (CollectionUtils.isEmpty((Collection)(budgetCalConfigVos = this.budgetCalConfigService.listByConditions(dto)))) {
            return null;
        }
        BudgetCalConfigVo budgetCalConfigVo = budgetCalConfigVos.stream().filter(o -> !CollectionUtils.isEmpty((Collection)o.getBudgetItemList()) && !ObjectUtils.isEmpty(o.getBudgetItemList().stream().filter(d -> d.getDataCode().equals(monthBudgetVo.getBudgetItemCode())).findFirst().orElse(null))).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            return budgetCalConfigVo;
        }
        return budgetCalConfigVos.stream().filter(o -> CollectionUtils.isEmpty((Collection)o.getBudgetItemList())).findFirst().orElse(null);
    }

    public Map<String, List<DimensionControlsVo>> findDimensionControl() {
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
        if (CollectionUtils.isEmpty((Collection)dimensionControlsVos)) {
            return Maps.newHashMap();
        }
        return dimensionControlsVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getMarketOrganization()));
    }

    public Map<String, List<DimensionControlsVo>> findDimensionControlNoSalesOrg() {
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
        if (CollectionUtils.isEmpty((Collection)dimensionControlsVos)) {
            return Maps.newHashMap();
        }
        return dimensionControlsVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode()));
    }

    public void calRolling(String currId, String lastId, String rollingType) {
        MonthBudgetEntity currMonthBudget = (MonthBudgetEntity)((Object)this.monthBudgetRepository.getById((Serializable)((Object)currId)));
        MonthBudgetEntity lastMonthBudget = (MonthBudgetEntity)((Object)this.monthBudgetRepository.getById((Serializable)((Object)lastId)));
        BigDecimal rollAmount = BigDecimal.ZERO;
        BigDecimal lastAccumulatedAvailableBalance = null;
        lastAccumulatedAvailableBalance = BusinessUnitEnum.isDefaultBusinessUnit((String)lastMonthBudget.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(lastMonthBudget.getBusinessUnitCode()) ? Optional.ofNullable(lastMonthBudget.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO) : this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceBefore(lastMonthBudget, BusinessUnitEnum.VERTICAL);
        if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType)) {
            rollAmount = lastAccumulatedAvailableBalance;
        }
        if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType) && BigDecimal.ZERO.compareTo(lastAccumulatedAvailableBalance) < 0) {
            rollAmount = lastAccumulatedAvailableBalance;
        }
        if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType) && BigDecimal.ZERO.compareTo(lastAccumulatedAvailableBalance) > 0) {
            rollAmount = lastAccumulatedAvailableBalance;
        }
        log.error("\u6eda\u52a8\u8fdb\u884c\u4e2d\uff0c\u4e0a\u6708\u9884\u7b97\u7f16\u7801\uff1a{}\uff0c\u672c\u6708\u9884\u7b97\u7f16\u7801\uff1a{}\uff0c\u6eda\u52a8\u7c7b\u578b\uff1a{}\uff0c\u6eda\u52a8\u91d1\u989d\uff1a{}", new Object[]{lastMonthBudget.getMonthBudgetCode(), currMonthBudget.getMonthBudgetCode(), rollingType, rollAmount});
        if (rollAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal beforeAmount = lastMonthBudget.getAccumulatedAvailableBalance();
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)lastMonthBudget.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(lastMonthBudget.getBusinessUnitCode())) {
            lastMonthBudget.setMonthRollingAmount(Optional.ofNullable(lastMonthBudget.getMonthRollingAmount()).orElse(BigDecimal.ZERO).add(rollAmount));
            lastMonthBudget.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(lastMonthBudget, BusinessUnitEnum.HEADQUARTERS));
            lastMonthBudget.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(lastMonthBudget, BusinessUnitEnum.HEADQUARTERS));
        } else {
            lastMonthBudget.setMonthRollingAmount(rollAmount);
            lastMonthBudget.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalance(lastMonthBudget, BusinessUnitEnum.VERTICAL));
            lastMonthBudget.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmount(lastMonthBudget, BusinessUnitEnum.VERTICAL));
        }
        MonthBudgetDetailEntity lastDetailEntity = this.buildDetail(lastMonthBudget, rollAmount, beforeAmount, BudgetOperationTypeEnum.ROLLING.getCode(), null);
        this.monthBudgetDetailRepository.save((Object)lastDetailEntity);
        lastMonthBudget.setIfRolling(BooleanEnum.TRUE.getCapital());
        this.monthBudgetRepository.updateById((Object)lastMonthBudget);
        BigDecimal currBeforeAmount = currMonthBudget.getAccumulatedAvailableBalance();
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)lastMonthBudget.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(lastMonthBudget.getBusinessUnitCode())) {
            currMonthBudget.setLastMonthRollingAmount(Optional.ofNullable(currMonthBudget.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO).add(rollAmount));
            currMonthBudget.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currMonthBudget, BusinessUnitEnum.HEADQUARTERS));
            currMonthBudget.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currMonthBudget, BusinessUnitEnum.HEADQUARTERS));
        } else {
            currMonthBudget.setLastMonthRollingAmount(rollAmount);
            currMonthBudget.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalance(currMonthBudget, BusinessUnitEnum.VERTICAL));
            currMonthBudget.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmount(currMonthBudget, BusinessUnitEnum.VERTICAL));
        }
        MonthBudgetDetailEntity currDetailEntity = this.buildDetail(currMonthBudget, rollAmount, currBeforeAmount, BudgetOperationTypeEnum.ROLLING.getCode(), null);
        this.monthBudgetDetailRepository.save((Object)currDetailEntity);
        this.monthBudgetRepository.updateById((Object)currMonthBudget);
    }

    public MonthBudgetDetailEntity buildDetail(MonthBudgetEntity entity, BigDecimal amount, BigDecimal beforeAmount, String operationType, String businessCode) {
        MonthBudgetDetailEntity detailEntity = (MonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        detailEntity.setId(null);
        detailEntity.setBusinessCode(businessCode);
        detailEntity.setOperationType(operationType);
        detailEntity.setInitialAmount(entity.getInitResolveAmount());
        detailEntity.setBalanceAmount(entity.getAccumulatedAvailableBalance());
        detailEntity.setBeforeAmount(beforeAmount);
        detailEntity.setCurOperationAmount(amount);
        return detailEntity;
    }

    public BudgetCalConfigDataVo findMonthBudgetCalConfigData(BudgetCalConfigVo budgetCalConfigVo, String planFlag) {
        List calConfigDataVos = budgetCalConfigVo.getDataList().stream().filter(budgetCalConfigDataVo -> CalDataFromEnum.SALES_PLAN.getCode().equals(budgetCalConfigDataVo.getCalDataFromCode())).collect(Collectors.toList());
        if (BooleanEnum.TRUE.getCapital().equals(planFlag)) {
            log.info("\u83b7\u53d6\u8ba1\u7b97\u914d\u7f6e\u6570\u636e\u914d\u7f6e,calConfigDataVos => :{}", calConfigDataVos);
            return calConfigDataVos.stream().filter(data -> SalesPlanAmountTypeEnum.PLAN_AMOUNT.getCode().equals(data.getAmountTypeCode()) || SalesPlanAmountTypeEnum.DISCOUNT_PLAN_AMOUNT.getCode().equals(data.getAmountTypeCode()) || SalesPlanAmountTypeEnum.PLAN_QUANTITY.getCode().equals(data.getAmountTypeCode())).findFirst().orElse(null);
        }
        return budgetCalConfigVo.getDataList().stream().filter(data -> SalesPlanAmountTypeEnum.RESTORE_AMOUNT.getCode().equals(data.getAmountTypeCode()) || SalesPlanAmountTypeEnum.DISCOUNT_RESTORE_AMOUNT.getCode().equals(data.getAmountTypeCode()) || SalesPlanAmountTypeEnum.RESTORE_QUANTITY.getCode().equals(data.getAmountTypeCode())).findFirst().orElse(null);
    }

    public DimensionControlsVo matchDimensionControl(List<DimensionControlsVo> dimensionControlsVos, String budgetItemCode) {
        for (DimensionControlsVo dimensionControlsVo : dimensionControlsVos) {
            if (CollectionUtils.isEmpty((Collection)dimensionControlsVo.getBudgetItemCodeList()) || !dimensionControlsVo.getBudgetItemCodeList().contains(budgetItemCode)) continue;
            return dimensionControlsVo;
        }
        BudgetItemVo itemVo = this.budgetItemService.findByCode(budgetItemCode, EnableStatusEnum.ENABLE.getCode());
        if (null == itemVo || StringUtil.isBlank((CharSequence)itemVo.getParentBudgetItemCode())) {
            return null;
        }
        for (DimensionControlsVo vo : dimensionControlsVos) {
            if (CollectionUtils.isEmpty((Collection)vo.getBudgetItemCodeList()) || !vo.getBudgetItemCodeList().contains(itemVo.getParentBudgetItemCode())) continue;
            return vo;
        }
        BudgetItemVo budgetItemVo = this.budgetItemService.findByCode(itemVo.getParentBudgetItemCode(), EnableStatusEnum.ENABLE.getCode());
        if (null == budgetItemVo || StringUtil.isBlank((CharSequence)budgetItemVo.getParentBudgetItemCode())) {
            return null;
        }
        for (DimensionControlsVo vo : dimensionControlsVos) {
            if (CollectionUtils.isEmpty((Collection)vo.getBudgetItemCodeList()) || !vo.getBudgetItemCodeList().contains(budgetItemVo.getParentBudgetItemCode())) continue;
            return vo;
        }
        return null;
    }
}

