/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetDetailMapper;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class MonthBudgetDetailRepository
extends ServiceImpl<MonthBudgetDetailMapper, MonthBudgetDetailEntity> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<MonthBudgetDetailEntity> listDetailByBudgetCode(String monthBudgetCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetDetailEntity::getMonthBudgetCode, (Object)monthBudgetCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MonthBudgetDetailEntity> listDetailByYearBudgetCodeList(List<String> yearBudgetCodeList) {
        if (CollectionUtils.isEmpty(yearBudgetCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetDetailEntity::getYearBudgetCode, yearBudgetCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MonthBudgetDetailEntity> listByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetDetailEntity::getProcessNo, (Object)processNo)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public MonthBudgetDetailVo findByBusinessCode(String businessCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(MonthBudgetDetailEntity::getBusinessCode, (Object)businessCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).orderByDesc(UuidOpEntity::getCreateTime)).last(" limit 1");
        MonthBudgetDetailEntity entity = (MonthBudgetDetailEntity)((Object)((MonthBudgetDetailMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            return null;
        }
        return (MonthBudgetDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MonthBudgetDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<MonthBudgetDetailVo> findByBusinessCodes(List<String> businessCodes) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(MonthBudgetDetailEntity::getBusinessCode, businessCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).orderByDesc(UuidOpEntity::getCreateTime)).last(" limit 1");
        List entityList = ((MonthBudgetDetailMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)entityList)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityList, MonthBudgetDetailEntity.class, MonthBudgetDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<MonthBudgetDetailVo> findByMainIds(List<String> ids) {
        return ((MonthBudgetDetailMapper)this.baseMapper).findByMainIds(ids, BudgetOperationTypeEnum.INIT.getCode());
    }

    public List<MonthBudgetDetailEntity> findListByBusiness(List<String> auditDetailCodes, String auditCode) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetDetailEntity::getBusinessCode, auditDetailCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).isNotNull(MonthBudgetDetailEntity::getPlanReturnBudgetYearAndMonth)).isNotNull(MonthBudgetDetailEntity::getAlreadyEndCaseAmount)).eq(MonthBudgetDetailEntity::getOperationType, (Object)BudgetOperationTypeEnum.AUDIT_USE.getCode())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(MonthBudgetDetailEntity::getReject, (Object)YesOrNoEnum.YES.getCode())).or()).isNull(MonthBudgetDetailEntity::getReject);
        })).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetDetailEntity::getAuditCode, new Object[]{auditCode})).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).isNotNull(MonthBudgetDetailEntity::getPlanReturnBudgetYearAndMonth)).isNotNull(MonthBudgetDetailEntity::getAlreadyEndCaseAmount)).eq(MonthBudgetDetailEntity::getOperationType, (Object)BudgetOperationTypeEnum.AUDIT_USE.getCode())).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(MonthBudgetDetailEntity::getReject, (Object)YesOrNoEnum.YES.getCode())).or()).isNull(MonthBudgetDetailEntity::getReject);
            })).list();
        }
        return list;
    }

    public void updateStatusByBusiness(List<MonthBudgetDetailVo> monthBudgetDetailVos) {
        if (CollectionUtils.isEmpty(monthBudgetDetailVos)) {
            return;
        }
        ((MonthBudgetDetailMapper)this.getBaseMapper()).updateStatusByBusiness(monthBudgetDetailVos);
    }

    public List<MonthBudgetDetailVo> findListByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetDetailEntity::getBusinessCode, detailPlanItemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(MonthBudgetDetailEntity::getOperationType, (Object)BudgetOperationTypeEnum.FORECAST_OVER.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection monthBudgetDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MonthBudgetDetailEntity.class, MonthBudgetDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)monthBudgetDetailVos;
    }
}

