/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MonthBudgetRepository
extends ServiceImpl<MonthBudgetMapper, MonthBudgetEntity> {
    public MonthBudgetEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (MonthBudgetEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public MonthBudgetEntity getByMonthBudgetCode(String code, String enableStatus) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        return (MonthBudgetEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetEntity::getMonthBudgetCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<MonthBudgetEntity> getByMonthBudgetCodes(List<String> codes, String enableStatus) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetEntity::getMonthBudgetCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<MonthBudgetEntity> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetEntity::getBudgetItemCode, budgetItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void delByYearBudgetCode(List<String> yearMonthCodeList) {
        List monthBudgetList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetEntity::getYearBudgetCode, yearMonthCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (!CollectionUtils.isEmpty((Collection)monthBudgetList)) {
            monthBudgetList.forEach(monthBudgetEntity -> monthBudgetEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(monthBudgetList);
        }
    }

    public List<MonthBudgetEntity> listByYearBudgetCode(String yearBudgetCode) {
        if (StringUtils.isEmpty((CharSequence)yearBudgetCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetEntity::getYearBudgetCode, (Object)yearBudgetCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<MonthBudgetEntity> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<MonthBudgetEntity> listByYearMonth(String yearMonth, List<String> businessUnitCodeList) {
        if (StringUtils.isEmpty((CharSequence)yearMonth)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetEntity::getYearMonthLy, (Object)yearMonth)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(!CollectionUtils.isEmpty(businessUnitCodeList), MonthBudgetEntity::getBusinessUnitCode, businessUnitCodeList)).list();
    }

    public List<MonthBudgetEntity> getByYearMonthCodeAndMonth(List<String> yearBudgetList, List<String> yearMonthList) {
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetEntity::getYearBudgetCode, yearBudgetList)).in(!CollectionUtils.isEmpty(yearMonthList), MonthBudgetEntity::getYearMonthLy, yearMonthList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<MonthBudgetEntity> listByConditions(MonthBudgetDto monthBudgetDto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)monthBudgetDto.getYearMonthLy()), MonthBudgetEntity::getYearMonthLy, (Object)monthBudgetDto.getYearMonthLy())).eq(!StringUtils.isEmpty((CharSequence)monthBudgetDto.getFeeBelongCode()), MonthBudgetEntity::getFeeBelongCode, (Object)monthBudgetDto.getFeeBelongCode())).eq(!StringUtils.isEmpty((CharSequence)monthBudgetDto.getBusinessFormatCode()), MonthBudgetEntity::getBusinessFormatCode, (Object)monthBudgetDto.getBusinessFormatCode())).eq(!StringUtils.isEmpty((CharSequence)monthBudgetDto.getBusinessUnitCode()), MonthBudgetEntity::getBusinessUnitCode, (Object)monthBudgetDto.getBusinessUnitCode())).in(!CollectionUtils.isEmpty((Collection)monthBudgetDto.getMonthBudgetCodeList()), MonthBudgetEntity::getMonthBudgetCode, (Collection)monthBudgetDto.getMonthBudgetCodeList())).in(!CollectionUtils.isEmpty((Collection)monthBudgetDto.getBudgetItemCodeList()), MonthBudgetEntity::getBudgetItemCode, (Collection)monthBudgetDto.getBudgetItemCodeList())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MonthBudgetEntity> listByCodes(List<String> codes) {
        return this.listByCodes(codes, null);
    }

    public List<MonthBudgetEntity> listByCodes(List<String> codes, String businessUnitCode) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetEntity::getMonthBudgetCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)businessUnitCode), MonthBudgetEntity::getBusinessUnitCode, (Object)businessUnitCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<MonthBudgetEntity> listByYearBudgetCodes(List<String> yearBudgetList) {
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MonthBudgetEntity::getYearBudgetCode, yearBudgetList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void updateControlBalanceAmountByIds(Set<String> ids, BigDecimal controlBalanceAmount) {
        if (CollectionUtils.isEmpty(ids) && Objects.nonNull(controlBalanceAmount)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(MonthBudgetEntity::getControlBalanceAmount, (Object)controlBalanceAmount)).update();
        }
    }

    public List<MonthBudgetVo> findCustomerGroupMonthBudget(List<MonthBudgetDto> dtos) {
        return ((MonthBudgetMapper)this.getBaseMapper()).findCustomerGroupMonthBudget(dtos, TenantUtils.getTenantCode());
    }

    public MonthBudgetVo findCurrMonthBudgetById(MonthBudgetDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((MonthBudgetMapper)this.baseMapper).findCurrMonthBudgetById(dto);
    }

    public MonthBudgetEntity getOneByYearBudgetCodeAndMonth(String yearBudgetCode, String yearMonth) {
        if (StringUtils.isEmpty((CharSequence)yearBudgetCode)) {
            return null;
        }
        return (MonthBudgetEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetEntity::getYearBudgetCode, (Object)yearBudgetCode)).eq(MonthBudgetEntity::getYearMonthLy, (Object)yearMonth)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<MonthBudgetEntity> getListByYearMonth(String yearBudgetCode, List<String> yearMonths) {
        if (StringUtils.isEmpty((CharSequence)yearBudgetCode)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(yearMonths)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetEntity::getYearBudgetCode, (Object)yearBudgetCode)).in(MonthBudgetEntity::getYearMonthLy, yearMonths)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public MonthBudgetEntity findByYearMonthAndYearBudgetCode(String lastYearMonth, String yearBudgetCode) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MonthBudgetEntity::getYearBudgetCode, (Object)yearBudgetCode)).eq(MonthBudgetEntity::getYearMonthLy, (Object)lastYearMonth)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (MonthBudgetEntity)((Object)list.get(0));
    }

    public void deleteBatch(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Page<MonthBudgetVo> findPageForOut(Pageable pageable, MonthBudgetDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((MonthBudgetMapper)this.baseMapper).findPageForOut((Page<MonthBudgetVo>)page, dto);
    }

    public BigDecimal sumFirstReplyAmount(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).sumFirstReplyAmount(dto, TenantUtils.getTenantCode());
    }

    public BigDecimal sumFirstReplyAmountStudent(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).sumFirstReplyAmountStudent(dto, TenantUtils.getTenantCode());
    }

    public BigDecimal sumFirstReplyAmountOthers(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).sumFirstReplyAmountOthers(dto, TenantUtils.getTenantCode());
    }

    public BigDecimal sumActualSales(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).sumActualSales(dto, TenantUtils.getTenantCode());
    }

    public BigDecimal sumActualSalesStudent(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).sumActualSalesStudent(dto, TenantUtils.getTenantCode());
    }

    public BigDecimal sumActualSalesOthers(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).sumActualSalesOthers(dto, TenantUtils.getTenantCode());
    }

    public Page<MonthBudgetVo> findByConditions(Page<MonthBudgetVo> page, MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.getBaseMapper()).findByConditions(page, dto);
    }

    public List<MonthBudgetEntity> getByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).list();
    }

    public List<MonthBudgetVo> findMonthBudgetForVariable(MonthBudgetDto dto) {
        return ((MonthBudgetMapper)this.baseMapper).findMonthBudgetForVariable(dto, TenantUtils.getTenantCode());
    }

    public List<MonthBudgetVo> findMonthBudgetConditionForVariable(MonthBudgetDto monthBudgetDto) {
        return ((MonthBudgetMapper)this.baseMapper).findMonthBudgetConditionForVariable(monthBudgetDto);
    }

    public MonthBudgetVo findMonthBudgetSumAuditAmount(MonthBudgetDto monthBudgetDto) {
        monthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
        return ((MonthBudgetMapper)this.baseMapper).findMonthBudgetSumAuditAmount(monthBudgetDto);
    }

    public MonthBudgetVo findMonthBudgetSumInitResolveAmount(MonthBudgetDto monthBudgetDto) {
        monthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
        return ((MonthBudgetMapper)this.baseMapper).findMonthBudgetSumInitResolveAmount(monthBudgetDto);
    }

    public List<MonthBudgetVo> findListForFR(List<MonthBudgetDto> monthBudgetDtos) {
        if (CollectionUtils.isEmpty(monthBudgetDtos)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(monthBudgetDtos = monthBudgetDtos.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        return ((MonthBudgetMapper)this.baseMapper).findListForFR(monthBudgetDtos, TenantUtils.getTenantCode());
    }
}

