/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComMonthBudgetRepository
extends ServiceImpl<SubComMonthBudgetMapper, SubComMonthBudgetEntity> {
    public SubComMonthBudgetEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (SubComMonthBudgetEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public SubComMonthBudgetEntity getByMonthBudgetCode(String monthBudgetCode, String enableStatus) {
        if (StringUtils.isEmpty((CharSequence)monthBudgetCode)) {
            return null;
        }
        return (SubComMonthBudgetEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComMonthBudgetEntity::getMonthBudgetCode, (Object)monthBudgetCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).one());
    }

    public List<SubComMonthBudgetEntity> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComMonthBudgetEntity::getBudgetItemCode, budgetItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<SubComMonthBudgetEntity> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)delFlag)).list();
    }

    public List<SubComMonthBudgetEntity> listByCodes(List<String> monthBudgetCodeList) {
        if (CollectionUtils.isEmpty(monthBudgetCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(SubComMonthBudgetEntity::getMonthBudgetCode, monthBudgetCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateBatchByIdAndTenantCode(Collection<SubComMonthBudgetEntity> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((SubComMonthBudgetMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public void deleteById(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public List<SubComMonthBudgetEntity> findListByCondition(SubComMonthBudgetDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), SubComMonthBudgetEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessUnitCode()), SubComMonthBudgetEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getFeeSourceCode()), SubComMonthBudgetEntity::getFeeSourceCode, (Object)dto.getFeeSourceCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBudgetItemCode()), SubComMonthBudgetEntity::getBudgetItemCode, (Object)dto.getBudgetItemCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getYearMonthLy()), SubComMonthBudgetEntity::getYearMonthLy, (Object)dto.getYearMonthLy())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesInstitutionCode()), SubComMonthBudgetEntity::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesRegionCode()), SubComMonthBudgetEntity::getSalesRegionCode, (Object)dto.getSalesRegionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()), SubComMonthBudgetEntity::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()), SubComMonthBudgetEntity::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getOrgCode()), SubComMonthBudgetEntity::getOrgCode, (Object)dto.getOrgCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getChannelCode()), SubComMonthBudgetEntity::getChannelCode, (Object)dto.getChannelCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()), SubComMonthBudgetEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getTerminalCode()), SubComMonthBudgetEntity::getTerminalCode, (Object)dto.getTerminalCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductBrandCode()), SubComMonthBudgetEntity::getProductBrandCode, (Object)dto.getProductBrandCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCategoryCode()), SubComMonthBudgetEntity::getProductCategoryCode, (Object)dto.getProductCategoryCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductItemCode()), SubComMonthBudgetEntity::getProductItemCode, (Object)dto.getProductItemCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), SubComMonthBudgetEntity::getProductCode, (Object)dto.getProductCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        return list;
    }

    public List<SubComMonthBudgetEntity> listByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Lists.newArrayList();
        }
        return ((SubComMonthBudgetMapper)this.baseMapper).listByOnlyKeys(onlyKeys, TenantUtils.getTenantCode());
    }

    public List<SubComMonthBudgetEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public Page<SubComMonthBudgetVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (CollectionUtils.isEmpty(yearMonthList)) {
            return page;
        }
        return ((SubComMonthBudgetMapper)this.baseMapper).findBySonCompanyBudgetWarn((Page<SubComMonthBudgetVo>)page, yearMonthList, orgCode, saleCompanyCode, channelCode, saleGroupCode, customerCode, budgetItemCode);
    }
}

