/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.Validate;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetImportsHeadVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class MonthBudgetImportsHeadProcess
implements ImportProcess<MonthBudgetImportsHeadVo> {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetImportsHeadProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private MonthBudgetService monthBudgetService;

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, MonthBudgetImportsHeadVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            List voList;
            Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
            HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
            HashSet codeSet = new HashSet();
            data.forEach((k, v) -> {
                if (StringUtils.isBlank((CharSequence)v.getMonthBudgetCode())) {
                    errorMap.put((Integer)k, "\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e3a\u7a7a\uff01");
                } else {
                    codeSet.add(v.getMonthBudgetCode());
                }
            });
            HashMap voMap = new HashMap(codeSet.size());
            if (CollectionUtil.isNotEmpty(codeSet) && !CollectionUtils.isEmpty((Collection)(voList = this.monthBudgetService.findBudgetByMonthBudgetCodes(new ArrayList(codeSet))))) {
                voMap.putAll(voList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (n, o) -> n)));
            }
            String tenantCode = TenantUtils.getTenantCode();
            ArrayList dtoList = new ArrayList();
            data.forEach((k, v) -> {
                ArrayList<String> errorMsgList = new ArrayList<String>();
                MonthBudgetDto dto = new MonthBudgetDto();
                if (StringUtil.isNotEmpty((String)v.getCalAmountStr())) {
                    try {
                        dto.setCalAmount(new BigDecimal(v.getCalAmountStr()));
                    }
                    catch (Exception e) {
                        errorMsgList.add("\u8ba1\u5212\u91cf/\u56de\u590d\u91cf\u6709\u8bef,\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b!");
                    }
                }
                if (StringUtil.isNotEmpty((String)v.getFirstReplyAmountStr())) {
                    try {
                        dto.setFirstReplyAmount(new BigDecimal(v.getFirstReplyAmountStr()));
                    }
                    catch (Exception e) {
                        errorMsgList.add("\u6708\u5ea6\u5206\u89e3\u91d1\u989d\u6709\u8bef,\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b!");
                    }
                }
                if (StringUtil.isNotEmpty((String)v.getFirstReplyResolveDiffAmountStr())) {
                    try {
                        dto.setFirstReplyResolveDiffAmount(new BigDecimal(v.getFirstReplyResolveDiffAmountStr()));
                    }
                    catch (Exception e) {
                        errorMsgList.add("\u6708\u6708\u5ea6\u5206\u89e3\u91d1\u989d\u4e0e\u5e74\u521d\u5206\u89e3\u91d1\u989d\u7684\u5dee\u5f02\u6709\u8bef,\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b!");
                    }
                }
                if (StringUtil.isNotEmpty((String)v.getLastMonthRollingAmountStr())) {
                    try {
                        dto.setLastMonthRollingAmount(new BigDecimal(v.getLastMonthRollingAmountStr()));
                    }
                    catch (Exception e) {
                        errorMsgList.add("\u4e0a\u6708\u6eda\u52a8\u91d1\u989d\u6709\u8bef,\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b!");
                    }
                }
                if (StringUtil.isNotEmpty((String)v.getActualSalesStr())) {
                    try {
                        dto.setActualSales(new BigDecimal(v.getActualSalesStr()));
                    }
                    catch (Exception e) {
                        errorMsgList.add("\u5b9e\u9500\u91d1\u989d\u6709\u8bef,\u5e94\u8be5\u4e3a\u6570\u5b57\u7c7b\u578b!");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)v.getMonthBudgetCode())) {
                    MonthBudgetVo vo = (MonthBudgetVo)voMap.get(v.getMonthBudgetCode());
                    if (Objects.isNull(vo)) {
                        errorMsgList.add("\u6708\u5ea6\u9884\u7b97[" + v.getMonthBudgetCode() + "]\u4e0d\u5b58\u5728!");
                    } else {
                        if (!BusinessUnitEnum.isDefaultBusinessUnit((String)vo.getBusinessUnitCode())) {
                            errorMsgList.add("\u6708\u5ea6\u9884\u7b97\u4e1a\u52a1\u5355\u5143\u4e0d\u5c5e\u4e8e\u4e3b\u4f53\u6216\u5c0f\u4e1a\u52a1\u5355\u5143!");
                        }
                        if (!BusinessFormatEnum.NORMAL.getCode().equals(vo.getBusinessFormatCode())) {
                            errorMsgList.add("\u6708\u5ea6\u9884\u7b97\u4e1a\u6001\u4e0d\u5c5e\u4e8e\u5e38\u6e29\uff01");
                        }
                        dto.setId(vo.getId());
                        dto.setMonthBudgetCode(vo.getMonthBudgetCode());
                    }
                }
                if (CollectionUtil.isNotEmpty(errorMsgList)) {
                    errorMap.put((Integer)k, String.join((CharSequence)" | ", errorMsgList));
                } else {
                    dto.setTenantCode(tenantCode);
                    dtoList.add(dto);
                }
            });
            if (!errorMap.isEmpty()) {
                return errorMap;
            }
            if (CollectionUtil.isNotEmpty(dtoList)) {
                this.monthBudgetService.updateAndRoll(dtoList);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    public Integer getBatchCount() {
        return 1000;
    }

    public Class<MonthBudgetImportsHeadVo> findCrmExcelVoClass() {
        return MonthBudgetImportsHeadVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MONTH_BUDGET_HEAD_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6708\u5ea6\u9884\u7b97-\u4e3b\u4f53\u66f4\u65b0\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_MONTH_BUDGET_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6708\u5ea6\u9884\u7b97\u5bfc\u5165";
    }
}

