/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.imports;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetImportsVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class MonthBudgetImportsProcess
implements ImportProcess<MonthBudgetImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetImportsProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private MonthBudgetService monthBudgetService;
    @Resource
    private BudgetItemService budgetItemService;
    @Resource
    private CustomerRetailerVoService customerRetailerVoService;
    @Resource
    private TerminalVoService terminalVoService;
    @Resource
    private ProductBrandService productBrandService;
    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Resource
    private ProductVoService productVoService;
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, MonthBudgetImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, MonthBudgetImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            MonthBudgetImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.hasText((String)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.hasText((String)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.hasText((String)vo.getYearMonthLy()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.hasText((String)vo.getBudgetItemCode()), "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.hasText((String)vo.getFeeBelongCode()), "\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(vo.getAmount() != null, "\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, MonthBudgetImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<MonthBudgetImportsVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            this.initDict();
            ArrayList list = new ArrayList();
            data.forEach((k, v) -> {
                list.add(this.validate((MonthBudgetImportsVo)v));
                String errInfo = this.validateGetErrorInfo();
                if (errInfo != null) {
                    errMap.put((Integer)k, errInfo);
                }
            });
            if (errMap.isEmpty()) {
                list.forEach(e -> this.monthBudgetService.importSave(e));
            }
        }
        catch (IllegalArgumentException e2) {
            throw e2;
        }
        catch (Exception e3) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e3);
            log.error("\u6708\u5ea6\u9884\u7b97\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return errMap;
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit", "tpm_fee_belong_vertical", "MDM_CUSTOMIZE_ORG"}));
    }

    private MonthBudgetDto validate(MonthBudgetImportsVo vo) {
        String productCode;
        String productItemCode;
        String productCategoryCode;
        String productBrandCode;
        String terminalCode;
        this.verifyDictCode(vo);
        SimpleDateFormat yearMonthSF = new SimpleDateFormat("yyyy-MM");
        yearMonthSF.setLenient(false);
        try {
            yearMonthSF.parse(vo.getYearMonthLy());
        }
        catch (ParseException e) {
            this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef");
        }
        try {
            BudgetItemVo budgetItem = this.budgetItemService.findByCode(vo.getBudgetItemCode(), EnableStatusEnum.ENABLE.getCode());
            Assert.notNull((Object)budgetItem, (String)"\u672a\u67e5\u8be2\u5230\u9884\u7b97\u9879\u76ee");
            vo.setBudgetItemName(budgetItem.getBudgetItemName());
            vo.setBudgetItemLevelCode(budgetItem.getBudgetItemLevelCode());
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u67e5\u8be2\u9884\u7b97\u9879\u76ee\u9519\u8bef[" + e.getMessage() + "]");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vo.getSystemCode())) {
            CustomerRetailerVo customerRetailer = this.customerRetailerVoService.findByCode(vo.getSystemCode());
            if (customerRetailer != null) {
                vo.setSystemName(customerRetailer.getCustomerRetailerName());
            } else {
                this.validateIsTrue(false, "\u672a\u67e5\u8be2\u5230\u96f6\u552e\u5546\u4fe1\u606f");
            }
        }
        if (StringUtils.hasText((String)(terminalCode = vo.getTerminalCode()))) {
            List terminalList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, (List)Lists.newArrayList((Object[])new String[]{terminalCode}));
            if (!CollectionUtils.isEmpty((Collection)terminalList)) {
                TerminalVo terminalVo = (TerminalVo)terminalList.get(0);
                vo.setTerminalName(terminalVo.getTerminalName());
            } else {
                this.validateIsTrue(false, "\u672a\u67e5\u8be2\u5230\u95e8\u5e97\u4fe1\u606f");
            }
        }
        if (StringUtils.hasText((String)(productBrandCode = vo.getProductBrandCode()))) {
            List productBrandList = this.productBrandService.listByCodes((List)Lists.newArrayList((Object[])new String[]{productBrandCode}));
            if (!CollectionUtils.isEmpty((Collection)productBrandList)) {
                ProductBrandVo productBrandVo = (ProductBrandVo)productBrandList.get(0);
                vo.setProductBrandName(productBrandVo.getProductBrandName());
            } else {
                this.validateIsTrue(false, "\u4e3a\u67e5\u8be2\u5230\u54c1\u724c\u4fe1\u606f");
            }
        }
        if (StringUtils.hasText((String)(productCategoryCode = vo.getProductCategoryCode()))) {
            List productCategoryList = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList((Object[])new String[]{productCategoryCode}));
            if (!CollectionUtils.isEmpty((Collection)productCategoryList)) {
                ProductLevelVo productCategoryVo = (ProductLevelVo)productCategoryList.get(0);
                vo.setProductCategoryName(productCategoryVo.getProductLevelName());
            } else {
                this.validateIsTrue(false, "\u672a\u67e5\u8be2\u5230\u54c1\u7c7b\u4fe1\u606f");
            }
        }
        if (StringUtils.hasText((String)(productItemCode = vo.getProductItemCode()))) {
            List productItemList = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList((Object[])new String[]{productItemCode}));
            if (!CollectionUtils.isEmpty((Collection)productItemList)) {
                ProductLevelVo productItemVo = (ProductLevelVo)productItemList.get(0);
                vo.setProductItemName(productItemVo.getProductLevelName());
            } else {
                this.validateIsTrue(false, "\u672a\u67e5\u8be2\u5230\u54c1\u9879\u4fe1\u606f");
            }
        }
        if (StringUtils.hasText((String)(productCode = vo.getProductCode()))) {
            List productList = this.productVoService.findByCodes((List)Lists.newArrayList((Object[])new String[]{productCode}));
            if (!CollectionUtils.isEmpty((Collection)productList)) {
                ProductVo productVo = (ProductVo)productList.get(0);
                vo.setProductName(productVo.getProductName());
            } else {
                this.validateIsTrue(false, "\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f");
            }
        }
        this.validateIsTrue(vo.getAmount().compareTo(BigDecimal.ZERO) == 1, "\u8d39\u7528\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6");
        try {
            this.verifyUniqueness(vo);
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u552f\u4e00\u6821\u9a8c\u5f02\u5e38[" + e.getMessage() + "]");
        }
        MonthBudgetDto dto = (MonthBudgetDto)this.nebulaToolkitService.copyObjectByBlankList((Object)vo, MonthBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        dto.setAccumulatedAvailableBalance(vo.getAmount());
        dto.setInitResolveAmount(vo.getAmount());
        dto.setFirstReplyAmount(vo.getAmount());
        dto.setAfterFreezeAmount(vo.getAmount());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }

    private void verifyUniqueness(MonthBudgetImportsVo vo) {
        MonthBudgetDto dto = new MonthBudgetDto();
        dto.setBusinessFormatCode(vo.getBusinessFormatCode());
        dto.setBusinessUnitCode(vo.getBusinessUnitCode());
        dto.setYearMonthLy(vo.getYearMonthLy());
        dto.setBudgetItemCode(vo.getBudgetItemCode());
        dto.setFeeBelongCode(vo.getFeeBelongCode());
        dto.setSystemCode(vo.getSystemCode());
        List monthBudgetVoList = this.monthBudgetService.findListByConditions(dto);
        if (CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
            return;
        }
        String uniqKey = this.buildKey(vo.getRegionCode(), vo.getTerminalCode(), vo.getProductBrandCode(), vo.getProductCategoryCode(), vo.getProductItemCode(), vo.getProductCode());
        Map monthBudgetMap = monthBudgetVoList.stream().collect(Collectors.toMap(o -> this.buildKey(o.getRegionCode(), o.getTerminalCode(), o.getProductBrandCode(), o.getProductCategoryCode(), o.getProductItemCode(), o.getProductCode()), Function.identity()));
        MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(uniqKey);
        Assert.isNull((Object)monthBudgetVo, (String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u6708\u5ea6\u9884\u7b97");
    }

    private String buildKey(String regionCode, String terminalCode, String productBrandCode, String productCategoryCode, String productItemCode, String productCode) {
        StringBuilder sb = new StringBuilder(this.handleStr(regionCode));
        sb.append(this.handleStr(terminalCode));
        sb.append(this.handleStr(productBrandCode));
        sb.append(this.handleStr(productCategoryCode));
        sb.append(this.handleStr(productItemCode));
        sb.append(this.handleStr(productCode));
        return sb.toString();
    }

    private String handleStr(String regionCode) {
        return StringUtils.hasText((String)regionCode) ? regionCode : "0";
    }

    private void verifyDictCode(MonthBudgetImportsVo vo) {
        vo.setBusinessFormatCode(this.findDictValue(vo.getBusinessFormatCode(), "mdm_business_format"));
        this.validateIsTrue(StringUtils.hasText((String)vo.getBusinessFormatCode()), "\u672a\u914d\u7f6e\u8be5\u4e1a\u6001");
        vo.setBusinessUnitCode(this.findDictValue(vo.getBusinessUnitCode(), "mdm_business_unit"));
        this.validateIsTrue(StringUtils.hasText((String)vo.getBusinessUnitCode()), "\u672a\u914d\u7f6e\u8be5\u4e1a\u52a1\u5355\u5143");
        vo.setFeeBelongCode(this.findDictValue(vo.getFeeBelongCode(), "tpm_fee_belong_vertical"));
        this.validateIsTrue(StringUtils.hasText((String)vo.getFeeBelongCode()), "\u672a\u914d\u7f6e\u8be5\u8d39\u7528\u5f52\u53e3");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vo.getRegionCode())) {
            vo.setRegionCode(this.findDictCode(vo.getRegionCode(), "MDM_CUSTOMIZE_ORG"));
            this.validateIsTrue(StringUtils.hasText((String)vo.getRegionCode()), "\u672a\u914d\u7f6e\u8be5\u533a\u57df");
        }
    }

    private String findDictValue(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictValue().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    private String findDictCode(String dictCode, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictCode().equals(dictCode)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Class<MonthBudgetImportsVo> findCrmExcelVoClass() {
        return MonthBudgetImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MONTH_BUDGET_VERTICAL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6708\u5ea6\u9884\u7b97-\u5782\u76f4\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_MONTH_BUDGET_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6708\u5ea6\u9884\u7b97\u5bfc\u5165";
    }
}

