/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComMonthBudgetImportsProcess
implements ImportProcess<SubComMonthBudgetImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComMonthBudgetImportsProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;

    public Integer getBatchCount() {
        return 50001;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComMonthBudgetImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= 50000 ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc750000\u6761", (Object[])new Object[0]);
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            log.info("\u5f00\u59cb\u6570\u636e\u6821\u9a8c-----------------");
            List<SubComMonthBudgetDto> importList = this.validate(data, errMap);
            if (errMap.isEmpty()) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------");
                this.subComMonthBudgetService.bulkImportSave(importList);
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6267\u884c\u5931\u8d25,\u5f02\u5e38{}", (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
        log.info("\u5bfc\u5165\u903b\u8f91\u5904\u7406\u5b8c\u6bd5-----------------");
        return errMap;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, SubComMonthBudgetImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, SubComMonthBudgetImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getYearMonthLy()), "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getGroupCode()), "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getOrgCode()), "\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getBudgetItemCode()), "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getFeeSourceCode()), "\u8d39\u7528\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotBlank((CharSequence)row.getValue().getBudgetAmountStr()), "\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    private List<SubComMonthBudgetDto> validate(LinkedHashMap<Integer, SubComMonthBudgetImportsVo> data, Map<Integer, String> errMap) {
        List levels;
        List ters;
        List syss;
        List budgets;
        List channels;
        ArrayList<SubComMonthBudgetDto> list = new ArrayList<SubComMonthBudgetDto>();
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map groupMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_group_code");
        Map feeSourceMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_fee_source");
        data.forEach((k, v) -> list.add(this.validateData((Integer)k, (SubComMonthBudgetImportsVo)v, formatMap, feeSourceMap, groupMap, errMap)));
        if (!errMap.isEmpty()) {
            return list;
        }
        HashSet<String> orgSet = new HashSet<String>();
        HashSet<String> salesOrgSet = new HashSet<String>();
        HashSet<String> channelSet = new HashSet<String>();
        HashSet<String> budgetSet = new HashSet<String>();
        HashSet<String> sysSet = new HashSet<String>();
        HashSet<String> terSet = new HashSet<String>();
        HashSet<String> brandSet = new HashSet<String>();
        HashSet<String> itemSet = new HashSet<String>();
        HashSet<String> proSet = new HashSet<String>();
        for (SubComMonthBudgetDto dto : list) {
            orgSet.add(dto.getOrgCode());
            String insCode = dto.getChannelCode() + dto.getBusinessFormatCode() + dto.getSalesInstitutionCode();
            salesOrgSet.add(insCode);
            if (StringUtils.isNotBlank((CharSequence)dto.getSalesRegionCode())) {
                String regionCode = insCode + dto.getSalesRegionCode();
                salesOrgSet.add(regionCode);
                if (StringUtils.isNotBlank((CharSequence)dto.getSalesOrgCode())) {
                    String salesOrgCode = regionCode + dto.getSalesOrgCode();
                    salesOrgSet.add(salesOrgCode);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getChannelCode())) {
                channelSet.add(dto.getChannelCode());
            }
            budgetSet.add(dto.getBudgetItemCode());
            if (StringUtils.isNotBlank((CharSequence)dto.getSystemCode())) {
                sysSet.add(dto.getSystemCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
                terSet.add(dto.getCustomerCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getTerminalCode())) {
                terSet.add(dto.getTerminalCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductBrandCode())) {
                brandSet.add(dto.getProductBrandCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductCategoryCode())) {
                itemSet.add(dto.getProductCategoryCode());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductItemCode())) {
                itemSet.add(dto.getProductItemCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)dto.getProductCode())) continue;
            proSet.add(dto.getProductCode());
        }
        Map<Object, Object> orgMap = new HashMap();
        List orgLsit = this.orgVoService.findByOrgCodes(new ArrayList(orgSet));
        if (!CollectionUtils.isEmpty((Collection)orgLsit)) {
            orgMap = orgLsit.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        }
        Map salesOrgMap = new HashMap();
        if (!salesOrgSet.isEmpty()) {
            List sales = Lists.partition(new ArrayList(salesOrgSet), (int)500);
            salesOrgMap = this.salesOrgVoService.findNameBySalesOrgCodes(sales);
        }
        Map<Object, Object> channelMap = new HashMap();
        if (!channelSet.isEmpty() && !CollectionUtils.isEmpty((Collection)(channels = this.customerChannelVoService.findByCodes(new ArrayList(channelSet))))) {
            channelMap = channels.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, CustomerChannelVo::getCustomerChannelName));
        }
        Map<Object, Object> budgetMap = new HashMap();
        if (!budgetSet.isEmpty() && !CollectionUtils.isEmpty((Collection)(budgets = this.budgetItemService.listByCodes(new ArrayList(budgetSet))))) {
            budgetMap = budgets.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        }
        Map<Object, Object> sysMap = new HashMap();
        if (!sysSet.isEmpty() && !CollectionUtils.isEmpty((Collection)(syss = this.customerRetailerVoService.findByCodes(new ArrayList(sysSet))))) {
            sysMap = syss.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, CustomerRetailerVo::getCustomerRetailerName));
        }
        Map<Object, Object> terMap = new HashMap();
        if (!terSet.isEmpty() && !CollectionUtils.isEmpty((Collection)(ters = this.terminalVoService.findBaseByTerminalCodes(new ArrayList(terSet))))) {
            terMap = ters.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, TerminalVo::getTerminalName));
        }
        Map brandMap = new HashMap();
        if (!brandSet.isEmpty()) {
            brandMap = this.productBrandService.findNameByCodeList(new ArrayList(brandSet));
        }
        Map<Object, Object> itemMap = new HashMap();
        if (!itemSet.isEmpty() && !CollectionUtils.isEmpty((Collection)(levels = this.productLevelVoSdkService.findListByCodes(new ArrayList(itemSet))))) {
            itemMap = levels.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (oldValue, newValue) -> newValue));
        }
        Map proMap = new HashMap();
        if (!proSet.isEmpty()) {
            List pros = Lists.partition(new ArrayList(proSet), (int)500);
            proMap = this.productVoService.getProductByCodes(pros);
        }
        for (SubComMonthBudgetDto dto : list) {
            String errInfo;
            if (orgMap.containsKey(dto.getOrgCode())) {
                OrgVo o = (OrgVo)orgMap.get(dto.getOrgCode());
                dto.setOrgName(o.getOrgName());
                dto.setOrgLevelCode(o.getOrgLevel());
            } else {
                this.validateIsTrue(false, "\u901a\u8fc7\u7ec4\u7ec7\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u7ec4\u7ec7\u540d\u79f0");
            }
            String insCode = dto.getChannelCode() + dto.getBusinessFormatCode() + dto.getSalesInstitutionCode();
            if (salesOrgMap.containsKey(insCode)) {
                dto.setSalesInstitutionName((String)salesOrgMap.get(insCode));
                dto.setSalesInstitutionErpCode(dto.getSalesInstitutionCode());
                dto.setSalesInstitutionCode(insCode);
            } else {
                this.validateIsTrue(false, "\u901a\u8fc7\u9500\u552e\u673a\u6784\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u9500\u552e\u673a\u6784\u540d\u79f0");
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getSalesRegionCode())) {
                String regionCode = insCode + dto.getSalesRegionCode();
                if (salesOrgMap.containsKey(regionCode)) {
                    dto.setSalesRegionName((String)salesOrgMap.get(regionCode));
                    dto.setSalesRegionErpCode(dto.getSalesRegionCode());
                    dto.setSalesRegionCode(regionCode);
                    if (StringUtils.isNotBlank((CharSequence)dto.getSalesOrgCode())) {
                        String salesOrgCode = regionCode + dto.getSalesOrgCode();
                        if (salesOrgMap.containsKey(salesOrgCode)) {
                            dto.setSalesOrgName((String)salesOrgMap.get(salesOrgCode));
                            dto.setSalesOrgErpCode(dto.getSalesOrgCode());
                            dto.setSalesOrgCode(salesOrgCode);
                        } else {
                            this.validateIsTrue(false, "\u901a\u8fc7\u9500\u552e\u7ec4\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u9500\u552e\u7ec4\u540d\u79f0");
                        }
                    }
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u9500\u552e\u90e8\u95e8\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getChannelCode())) {
                if (channelMap.containsKey(dto.getChannelCode())) {
                    dto.setChannelName((String)channelMap.get(dto.getChannelCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u6e20\u9053\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u6e20\u9053\u540d\u79f0");
                }
            }
            if (budgetMap.containsKey(dto.getBudgetItemCode())) {
                BudgetItemVo itemVo = (BudgetItemVo)budgetMap.get(dto.getBudgetItemCode());
                dto.setBudgetItemName(itemVo.getBudgetItemName());
                dto.setBudgetItemLevelCode(itemVo.getBudgetItemLevelCode());
            } else {
                this.validateIsTrue(false, "\u901a\u8fc7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u9884\u7b97\u9879\u76ee\u540d\u79f0");
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getSystemCode())) {
                if (sysMap.containsKey(dto.getSystemCode())) {
                    dto.setSystemName((String)sysMap.get(dto.getSystemCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u7cfb\u7edf\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u7cfb\u7edf\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
                if (terMap.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerName((String)terMap.get(dto.getCustomerCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u5ba2\u6237\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getTerminalCode())) {
                if (terMap.containsKey(dto.getTerminalCode())) {
                    dto.setTerminalName((String)terMap.get(dto.getTerminalCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u95e8\u5e97\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u95e8\u5e97\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductBrandCode())) {
                if (brandMap.containsKey(dto.getProductBrandCode())) {
                    dto.setProductBrandName((String)brandMap.get(dto.getProductBrandCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u54c1\u724c\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u54c1\u724c\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductCategoryCode())) {
                if (itemMap.containsKey(dto.getProductCategoryCode())) {
                    dto.setProductCategoryName((String)itemMap.get(dto.getProductCategoryCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u54c1\u7c7b\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u54c1\u7c7b\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductItemCode())) {
                if (itemMap.containsKey(dto.getProductItemCode())) {
                    dto.setProductItemName((String)itemMap.get(dto.getProductItemCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u54c1\u9879\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u54c1\u9879\u540d\u79f0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getProductCode())) {
                if (proMap.containsKey(dto.getProductCode())) {
                    dto.setProductName((String)proMap.get(dto.getProductCode()));
                } else {
                    this.validateIsTrue(false, "\u901a\u8fc7\u4ea7\u54c1\u7f16\u7801\u4e3a\u67e5\u627e\u5230\u4ea7\u54c1\u540d\u79f0");
                }
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(dto.getLineIndex(), errInfo);
        }
        return new ArrayList<SubComMonthBudgetDto>(list);
    }

    private SubComMonthBudgetDto validateData(Integer index, SubComMonthBudgetImportsVo dto, Map<String, String> formatMap, Map<String, String> feeSourceMap, Map<String, String> groupMap, Map<Integer, String> errMap) {
        SubComMonthBudgetDto budget = new SubComMonthBudgetDto();
        budget = (SubComMonthBudgetDto)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SubComMonthBudgetDto.class, null, null, new String[0]);
        if (formatMap.containsKey(dto.getBusinessFormatCode())) {
            budget.setBusinessFormatCode(formatMap.get(dto.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
        }
        if (BusinessUnitEnum.SON_COMPANY.getDesc().equals(dto.getBusinessUnitCode())) {
            budget.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u53ea\u80fd\u586b\u5199\u5206\u5b50\u516c\u53f8");
        }
        if (groupMap.containsKey(dto.getGroupCode())) {
            budget.setGroupCode(feeSourceMap.get(dto.getGroupCode()));
        } else {
            this.validateIsTrue(false, "\u5206\u7ec4\u672a\u80fd\u8bc6\u522b");
        }
        if (feeSourceMap.containsKey(dto.getFeeSourceCode())) {
            budget.setFeeSourceCode(feeSourceMap.get(dto.getFeeSourceCode()));
        } else {
            this.validateIsTrue(false, "\u8d39\u7528\u6765\u6e90\u672a\u80fd\u8bc6\u522b");
        }
        try {
            budget.setYearMonthLy(DateUtil.dateToStr((Date)DateUtil.date_yyyy_MM.parse(dto.getYearMonthLy()), (SimpleDateFormat)DateUtil.date_yyyy_MM));
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        try {
            budget.setBudgetAmount(new BigDecimal(dto.getBudgetAmountStr()));
        }
        catch (Exception e) {
            this.validateIsTrue(false, "\u9884\u7b97\u91d1\u989d\u683c\u5f0f\u9519\u8bef\u3010100000.111\u3011");
        }
        budget.setLineIndex(index);
        String errInfo = this.validateGetErrorInfo();
        if (errInfo != null) {
            errMap.put(index, errInfo);
        }
        return budget;
    }

    public Class<SubComMonthBudgetImportsVo> findCrmExcelVoClass() {
        return SubComMonthBudgetImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_MONTH_BUDGET_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u5bfc\u5165";
    }
}

