/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetActualReplayService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MonthBudgetActualReplayServiceImpl
implements MonthBudgetActualReplayService {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetActualReplayServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private MonthBudgetRepository monthBudgetRepository;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Override
    public void manualActualReplayDiffMq(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u9884\u7b97!");
        List monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids);
        Assert.notEmpty((Collection)monthBudgetEntityList, (String)"\u9009\u62e9\u7684\u9884\u7b97\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        Assert.isTrue((ids.size() == monthBudgetEntityList.size() ? 1 : 0) != 0, (String)"\u9009\u62e9\u7684\u9884\u7b97\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        List monthBudgetCodeList = monthBudgetEntityList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getMonthBudgetCode())).map(MonthBudgetEntity::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean isLock = this.monthBudgetLockService.isLock(monthBudgetCodeList);
        Assert.isTrue((!isLock ? 1 : 0) != 0, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        List entityGroupList = Lists.partition(ids, (int)2);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString((Object)list));
            mqMessageVo.setTag("CAL_MONTH_BUDGET_ACTUAL_REPLAY_TAG");
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualActualReplayDiff(List<String> ids) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Map actualSalesMap = this.monthBudgetService.calculateActualSales(ids);
        stopWatch.stop();
        log.info("=====>    \u6267\u884c\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d actualSalesMap \u8017\u65f6[{}]    <=====", (Object)stopWatch.formatTime());
        List monthBudgetCodeList = actualSalesMap.values().stream().filter(k -> StringUtil.isNotEmpty((String)k.getMonthBudgetCode())).map(MonthBudgetActualSalesVo::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 20);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            actualSalesMap.forEach((k, v) -> {
                stopWatch.reset();
                stopWatch.start();
                this.monthBudgetService.calculateActualReplyDiff(v, null);
                stopWatch.stop();
                log.info("=====>    \u6267\u884c\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d calculateActualReplyDiff [{}] \u8017\u65f6[{}]    <=====", (Object)v.getYearMonthLy(), (Object)stopWatch.formatTime());
            });
        }
        finally {
            this.monthBudgetLockService.unLock(monthBudgetCodeList);
        }
    }
}

