/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetDetailMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MonthBudgetDetailServiceImpl
implements MonthBudgetDetailService {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetDetailServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MonthBudgetDetailMapper monthBudgetDetailMapper;
    @Autowired(required=false)
    private MonthBudgetDetailRepository monthBudgetDetailRepository;

    @Override
    public Page<MonthBudgetDetailVo> findByConditions(Pageable pageable, MonthBudgetDetailDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDetailDto();
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.monthBudgetDetailMapper.findByConditions((Page<MonthBudgetDetailVo>)page, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(MonthBudgetDetailDto monthBudgetDetailDto) {
        if (ObjectUtils.isEmpty((Object)monthBudgetDetailDto)) {
            return;
        }
        MonthBudgetDetailEntity monthBudgetDetailEntity = (MonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetDetailDto, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        Date date = new Date();
        monthBudgetDetailEntity.setId(null);
        monthBudgetDetailEntity.setCreateTime(date);
        monthBudgetDetailEntity.setModifyTime(date);
        this.monthBudgetDetailRepository.save((Object)monthBudgetDetailEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createList(List<MonthBudgetDetailDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list = list.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, MonthBudgetDetailDto.class, MonthBudgetDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
        entityList.forEach(item -> item.setId(null));
        this.monthBudgetDetailRepository.saveBatch(entityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> detailIds) {
        if (CollectionUtils.isEmpty(detailIds)) {
            return;
        }
        List monthBudgetDetailEntities = this.monthBudgetDetailRepository.listByIds(detailIds);
        if (CollectionUtils.isEmpty((Collection)monthBudgetDetailEntities)) {
            return;
        }
        monthBudgetDetailEntities.forEach(monthBudgetDetailEntity -> monthBudgetDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.monthBudgetDetailRepository.updateBatchById(monthBudgetDetailEntities);
    }

    @Override
    public List<MonthBudgetDetailVo> findListByBusiness(List<String> auditDetailCodes, String auditCode) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetDetailEntity> monthBudgetDetailEntities = this.monthBudgetDetailRepository.findListByBusiness(auditDetailCodes, auditCode);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntities)) {
            return Lists.newArrayList();
        }
        Collection monthBudgetDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetDetailEntities, MonthBudgetDetailEntity.class, MonthBudgetDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)monthBudgetDetailVos;
    }

    @Override
    public void updateStatusByBusiness(List<MonthBudgetDetailVo> monthBudgetDetailVos) {
        if (CollectionUtils.isEmpty(monthBudgetDetailVos)) {
            return;
        }
        this.monthBudgetDetailRepository.updateStatusByBusiness(monthBudgetDetailVos);
    }

    @Override
    public List<MonthBudgetDetailVo> findListByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.monthBudgetDetailRepository.findListByDetailPlanItemCodes(detailPlanItemCodes);
    }
}

