/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MonthBudgetLockServiceImpl
implements MonthBudgetLockService {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetLockServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public boolean lock(String monthBudgetCode, TimeUnit timeUnit, int time) {
        Assert.hasLength((String)"\u6708\u5ea6\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (time <= 0) {
            time = 1200;
        }
        return this.redisLockService.tryLock("month_budget:lock:" + monthBudgetCode, timeUnit, (long)time);
    }

    public boolean lock(List<String> monthBudgetCodeList, TimeUnit timeUnit, int time) {
        return this.lock(monthBudgetCodeList, timeUnit, time, 3);
    }

    public boolean isLock(String monthBudgetCode) {
        Assert.hasLength((String)"\u6708\u5ea6\u9884\u7b97\u9501\u9a8c\u8bc1\u5931\u8d25\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisLockService.isLock("month_budget:lock:" + monthBudgetCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(List<String> monthBudgetCodeList, TimeUnit timeUnit, int lockTime, int waiteTime) {
        Assert.notEmpty(monthBudgetCodeList, (String)"\u6708\u5ea6\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (lockTime <= 0) {
            lockTime = 1200;
        }
        if (waiteTime <= 0) {
            waiteTime = 3;
        }
        boolean isLock = true;
        ArrayList<String> successKeys = new ArrayList<String>();
        try {
            for (String monthBudgetCode : monthBudgetCodeList) {
                isLock = this.redisLockService.tryLock("month_budget:lock:" + monthBudgetCode, timeUnit, (long)lockTime, (long)waiteTime);
                if (!isLock) {
                    boolean bl = false;
                    return bl;
                }
                successKeys.add(monthBudgetCode);
            }
        }
        finally {
            if (!isLock && !CollectionUtils.isEmpty(successKeys)) {
                successKeys.forEach(key -> this.redisLockService.unlock("month_budget:lock:" + key));
            }
        }
        return true;
    }

    public boolean isLock(List<String> monthBudgetCodeList) {
        Assert.notEmpty(monthBudgetCodeList, (String)"\u6708\u5ea6\u9884\u7b97\u9501\u9a8c\u8bc1\u5931\u8d25\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisLockService.isBatchLock("month_budget:lock:", monthBudgetCodeList);
    }

    public void unLock(String monthBudgetCode) {
        Assert.hasLength((String)"\u6708\u5ea6\u9884\u7b97\u89e3\u9501\u5931\u8d25\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.redisLockService.unlock("month_budget:lock:" + monthBudgetCode);
    }

    public void unLock(List<String> monthBudgetCodeList) {
        Assert.notEmpty(monthBudgetCodeList, (String)"\u6708\u5ea6\u9884\u7b97\u89e3\u9501\u5931\u8d25\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        monthBudgetCodeList.forEach(monthBudgetCode -> this.redisLockService.unlock("month_budget:lock:" + monthBudgetCode));
    }
}

