/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeBudgetDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.ActualSalesAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.BudgetTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalDataFromEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesOrgAreaEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesPlanAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigAreaVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigDataVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigSalesOrgVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.ControlSituationEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.FieldsDimenDiameterEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.RollingTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.TimeDimension;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetControlTypeEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetItemLevelEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemControlConditionVoService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.builder.MonthBudgetActualSalesBuilder;
import com.biz.crm.tpm.business.month.budget.local.calculate.BudgetCalculateStrategy;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.VerticalAreaFeeWarningEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.VerticalWarningPanelEntity;
import com.biz.crm.tpm.business.month.budget.local.filter.MonthBudgetConditionFilter;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetCalculateHelper;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetHelper;
import com.biz.crm.tpm.business.month.budget.local.mapper.MonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.MonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.VerticalAreaFeeWarningRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.VerticalWarningPanelRepository;
import com.biz.crm.tpm.business.month.budget.local.service.MonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetAdjustDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetAdjustItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetBusinessPolicyQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetControlQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetExamineCircularQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetLogEventDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetOperateDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetTransferDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetTransferDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.PromotionOperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SonComBugdetDimensionalityDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.YearBudgetEventDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.AuditUseBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.ControlsCaliberEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.FeeSourceEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.RtmModelCodeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.month.budget.sdk.event.MonthBudgetLogEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.event.YearBudgetEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.ActivityDetailPlanItemVo2;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetHeadVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditDesignBudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.ChangeBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetBusinessPolicyQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetChangeVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetControlVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetMainAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.YearBudgetResponse;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class MonthBudgetServiceImpl
implements MonthBudgetService {
    private static final Logger log = LoggerFactory.getLogger(MonthBudgetServiceImpl.class);
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private MonthBudgetMapper monthBudgetMapper;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MonthBudgetRepository monthBudgetRepository;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private BudgetCalConfigService budgetCalConfigService;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;
    @Autowired(required=false)
    private MonthBudgetDetailService monthBudgetDetailService;
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required=false)
    private MonthBudgetDetailRepository monthBudgetDetailRepository;
    @Autowired(required=false)
    private DimensionControlsService dimensionControlsService;
    @Autowired(required=false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;
    @Autowired(required=false)
    private MonthBudgetServiceImpl monthBudgetService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired
    private List<MonthBudgetConditionFilter> monthBudgetConditionFilters;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Resource
    private MonthBudgetHelper monthBudgetHelper;
    @Resource
    private MonthBudgetCalculateHelper monthBudgetCalculateHelper;
    @Resource
    private List<BudgetCalculateStrategy> budgetCalculateStrategies;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private BudgetItemControlConditionVoService budgetItemControlConditionVoService;
    @Autowired(required=false)
    private VerticalAreaFeeWarningRepository verticalAreaFeeWarningRepository;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private VerticalWarningPanelRepository verticalWarningPanelRepository;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private TpmDailySalesDataService tpmDailySalesDataService;

    public Page<MonthBudgetVo> findByConditions(Pageable pageable, MonthBudgetDto dto) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDto();
        }
        Page<MonthBudgetVo> page = new Page<MonthBudgetVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (!CollectionUtils.isEmpty(this.monthBudgetConditionFilters)) {
            for (MonthBudgetConditionFilter budgetConditionFilter : this.monthBudgetConditionFilters) {
                budgetConditionFilter.buildDto(dto);
            }
        }
        page = this.monthBudgetMapper.findByConditions(page, dto);
        this.convertMonthBudgetProperty(page.getRecords());
        this.buildAmount(page.getRecords());
        return page;
    }

    public Page<MonthBudgetVo> findByConditionsNoFilter(Pageable pageable, MonthBudgetDto dto) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDto();
        }
        Page<MonthBudgetVo> page = new Page<MonthBudgetVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page = this.monthBudgetMapper.findByConditions(page, dto);
        MarsAuthorityContextHolder.getContext().setListCode("");
        this.convertMonthBudgetProperty(page.getRecords());
        this.buildAmount(page.getRecords());
        return page;
    }

    private void buildAmount(List<MonthBudgetVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List<String> monthBudgetCodeList = records.stream().map(MonthBudgetVo::getMonthBudgetCode).collect(Collectors.toList());
        Map<String, MonthBudgetControlVo> map = this.mapControlAmount(monthBudgetCodeList);
        records.forEach(record -> {
            if (map.containsKey(record.getMonthBudgetCode())) {
                record.setControlSituation(((MonthBudgetControlVo)map.get(record.getMonthBudgetCode())).getControlSituation());
                record.setControlTypeCode(((MonthBudgetControlVo)map.get(record.getMonthBudgetCode())).getControlTypeCode());
                record.setControlsConfigCode(((MonthBudgetControlVo)map.get(record.getMonthBudgetCode())).getControlsConfigCode());
                record.setControlRatio(((MonthBudgetControlVo)map.get(record.getMonthBudgetCode())).getControlRatio());
                record.setControlBalanceAmount(((MonthBudgetControlVo)map.get(record.getMonthBudgetCode())).getControlBalanceAmount());
            }
        });
    }

    public Page<MonthBudgetVo> findUnionByConditions(Pageable pageable, MonthBudgetDto dto) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetDto();
        }
        Page<MonthBudgetVo> page = new Page<MonthBudgetVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page = this.monthBudgetMapper.findByUnionConditions(page, dto);
        return page;
    }

    public List<MonthBudgetVo> findUnionListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return this.monthBudgetMapper.findUnionListByCodes(codes);
    }

    public List<MonthBudgetVo> findListByConditions(MonthBudgetDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        return this.monthBudgetMapper.findListByConditions(dto);
    }

    public void convertMonthBudgetProperty(List<MonthBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_belong_vertical");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                log.error("\u8d39\u7528\u5f52\u53e3\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (MonthBudgetVo vo : list) {
            if (!StringUtils.isNotEmpty((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public MonthBudgetVo update(MonthBudgetDto dto) {
        this.updateValidate(dto);
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lock, (String)"\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            MonthBudgetVo monthBudgetVo = this.findById(dto.getId());
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)monthBudgetVo)) {
                throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
            }
            List<MonthBudgetDetailEntity> monthBudgetDetailEntities = this.monthBudgetDetailRepository.listDetailByBudgetCode(dto.getMonthBudgetCode());
            List collect = monthBudgetDetailEntities.stream().filter(vo -> !BudgetOperationTypeEnum.INIT.getCode().equals(vo.getOperationType())).collect(Collectors.toList());
            if (collect.size() > 0) {
                throw new RuntimeException("\u5f53\u524d\u6708\u5ea6\u9884\u7b97\u5b58\u5728\u5df2\u64cd\u4f5c\u660e\u7ec6\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\uff01");
            }
            MonthBudgetDto oldVo = (MonthBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetVo, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            MonthBudgetEntity monthBudgetEntity = (MonthBudgetEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            monthBudgetEntity.setYearMonthDate(DateUtil.parseDate((String)monthBudgetEntity.getYearMonthLy(), (String)"yyyy-MM"));
            this.monthBudgetRepository.saveOrUpdate((Object)monthBudgetEntity);
            MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onUpdate = MonthBudgetLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MonthBudgetLogEventListener.class, (SerializableBiConsumer)onUpdate);
            MonthBudgetVo monthBudgetVo2 = (MonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return monthBudgetVo2;
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    public MonthBudgetVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)((Object)monthBudgetEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (MonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public MonthBudgetVo findByCode(String code, String enableStatus) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(code, enableStatus);
        Validate.notNull((Object)((Object)monthBudgetEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (MonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<MonthBudgetVo> findByCodes(List<String> codes, String enableStatus) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List<MonthBudgetEntity> monthBudgetEntities = this.monthBudgetRepository.getByMonthBudgetCodes(codes, enableStatus);
        if (CollectionUtils.isEmpty(monthBudgetEntities)) {
            return null;
        }
        Map<String, MonthBudgetControlVo> map = this.mapControlAmount(codes);
        List monthBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntities, MonthBudgetEntity.class, MonthBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
        monthBudgetVos.forEach(monthBudgetVo -> {
            if (map.containsKey(monthBudgetVo.getMonthBudgetCode())) {
                monthBudgetVo.setControlSituation(((MonthBudgetControlVo)map.get(monthBudgetVo.getMonthBudgetCode())).getControlSituation());
                monthBudgetVo.setControlBalanceAmount(((MonthBudgetControlVo)map.get(monthBudgetVo.getMonthBudgetCode())).getControlBalanceAmount());
                monthBudgetVo.setControlTypeCode(((MonthBudgetControlVo)map.get(monthBudgetVo.getMonthBudgetCode())).getControlTypeCode());
                monthBudgetVo.setControlRatio(((MonthBudgetControlVo)map.get(monthBudgetVo.getMonthBudgetCode())).getControlRatio());
            }
        });
        return monthBudgetVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void adjust(MonthBudgetAdjustDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getAdjustOutBudgetCode(), (String)"\u8c03\u51fa\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAdjustOutAmount(), (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getAdjustInBudgetCode(), (String)"\u8c03\u5165\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u5ba1\u6279\u6d41\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessTitle(), (String)"\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add(dto.getAdjustOutBudgetCode());
        lockKeys.add(dto.getAdjustInBudgetCode());
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u9884\u7b97\u8c03\u6574\u5931\u8d25\uff0c\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            MonthBudgetEntity adjustInEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getAdjustInBudgetCode(), null);
            Validate.notNull((Object)((Object)adjustInEntity), (String)"\u8c03\u5165\u65b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            MonthBudgetEntity adjustOutEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getAdjustOutBudgetCode(), null);
            Validate.notNull((Object)((Object)adjustOutEntity), (String)"\u8c03\u51fa\u65b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            if (Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).compareTo(dto.getAdjustOutAmount()) < 0) {
                throw new RuntimeException("\u6708\u5ea6\u9884\u7b97[" + dto.getAdjustOutBudgetCode() + "]\u7684\u8c03\u51fa\u91d1\u989d" + dto.getAdjustOutAmount().setScale(4, RoundingMode.HALF_UP) + "\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u53ef\u7528\u4f59\u989d" + Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP));
            }
            BigDecimal adjustOutBeforeAmount = adjustOutEntity.getAccumulatedAvailableBalance();
            BigDecimal adjustInBeforeAmount = adjustInEntity.getAccumulatedAvailableBalance();
            adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setApprovingAmount(Optional.ofNullable(adjustOutEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setAfterFreezeAmount(Optional.ofNullable(adjustOutEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setAccumulatedAvailableBalance(Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
            this.monthBudgetRepository.updateById((Object)adjustOutEntity);
            this.monthBudgetRepository.updateById((Object)adjustInEntity);
            String processNo = this.adjustSubmit(dto);
            MonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, dto.getAdjustOutAmount(), adjustOutBeforeAmount, BudgetOperationTypeEnum.ADJUST_OUT.getCode(), null);
            adjustOutDetailDto.setProcessNo(processNo);
            adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            adjustOutDetailDto.setOperationRemarks(dto.getOperationRemarks());
            this.monthBudgetDetailService.create(adjustOutDetailDto);
            MonthBudgetDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustOutAmount(), adjustInBeforeAmount, BudgetOperationTypeEnum.ADJUST_IN.getCode(), null);
            adjustInDetailDto.setProcessNo(processNo);
            adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            adjustInDetailDto.setOperationRemarks(dto.getOperationRemarks());
            this.monthBudgetDetailService.create(adjustInDetailDto);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void monthBudgetAdjust(MonthBudgetAdjustDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getAdjustOutBudgetDtoList(), (String)"\u8c03\u51fa\u65b9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (MonthBudgetAdjustItemDto monthBudgetAdjustItemDto : dto.getAdjustOutBudgetDtoList()) {
            Validate.notNull((Object)monthBudgetAdjustItemDto.getAdjustOutAmount(), (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((monthBudgetAdjustItemDto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        }
        Validate.notEmpty((CharSequence)dto.getAdjustInBudgetCode(), (String)"\u8c03\u5165\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u5ba1\u6279\u6d41\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessTitle(), (String)"\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList<String> lockKeys = new ArrayList<String>();
        List adjustOutBudgetDtoList = dto.getAdjustOutBudgetDtoList();
        Map<String, BigDecimal> adjustOutBudgetDtoMap = adjustOutBudgetDtoList.stream().collect(Collectors.toMap(MonthBudgetAdjustItemDto::getAdjustOutBudgetCode, MonthBudgetAdjustItemDto::getAdjustOutAmount));
        List<String> adjustOutBudgetCodeList = adjustOutBudgetDtoList.stream().map(MonthBudgetAdjustItemDto::getAdjustOutBudgetCode).distinct().collect(Collectors.toList());
        lockKeys.addAll(adjustOutBudgetCodeList);
        lockKeys.add(dto.getAdjustInBudgetCode());
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u9884\u7b97\u8c03\u6574\u5931\u8d25\uff0c\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            MonthBudgetEntity adjustInEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getAdjustInBudgetCode(), null);
            Validate.notNull((Object)((Object)adjustInEntity), (String)"\u8c03\u5165\u65b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            List<MonthBudgetEntity> adjustOutEntityList = this.monthBudgetRepository.getByMonthBudgetCodes(adjustOutBudgetCodeList, null);
            Validate.notNull(adjustOutEntityList, (String)"\u8c03\u51fa\u65b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((adjustOutEntityList.size() == adjustOutBudgetCodeList.size() ? 1 : 0) != 0, (String)"\u67e5\u8be2\u7684\u8c03\u51fa\u65b9\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            HashMap beforeAmountMap = Maps.newHashMap();
            beforeAmountMap.put(adjustInEntity.getMonthBudgetCode(), adjustInEntity.getAccumulatedAvailableBalance());
            for (MonthBudgetEntity adjustOutEntity : adjustOutEntityList) {
                BigDecimal bigDecimal = Optional.ofNullable(adjustOutBudgetDtoMap.get(adjustOutEntity.getMonthBudgetCode())).orElse(BigDecimal.ZERO);
                if (Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).compareTo(bigDecimal) < 0) {
                    throw new RuntimeException("\u6708\u5ea6\u9884\u7b97[" + adjustOutEntity.getMonthBudgetCode() + "]\u7684\u8c03\u51fa\u91d1\u989d" + bigDecimal.setScale(4, RoundingMode.HALF_UP) + "\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u53ef\u7528\u4f59\u989d" + Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP));
                }
                beforeAmountMap.put(adjustOutEntity.getMonthBudgetCode(), adjustOutEntity.getAccumulatedAvailableBalance());
                adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
                adjustOutEntity.setApprovingAmount(Optional.ofNullable(adjustOutEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
                adjustOutEntity.setAfterFreezeAmount(Optional.ofNullable(adjustOutEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
                adjustOutEntity.setAccumulatedAvailableBalance(Optional.ofNullable(adjustOutEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(bigDecimal));
            }
            adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustInAmount()));
            this.monthBudgetRepository.updateBatchById(adjustOutEntityList);
            this.monthBudgetRepository.updateById((Object)adjustInEntity);
            String processNo = this.adjustSubmit(dto);
            ArrayList<MonthBudgetDetailDto> adjustOutDetailDtoList = new ArrayList<MonthBudgetDetailDto>();
            for (MonthBudgetEntity adjustOutEntity : adjustOutEntityList) {
                BigDecimal bigDecimal = Optional.ofNullable(adjustOutBudgetDtoMap.get(adjustOutEntity.getMonthBudgetCode())).orElse(BigDecimal.ZERO);
                MonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, bigDecimal, (BigDecimal)beforeAmountMap.get(adjustOutEntity.getMonthBudgetCode()), BudgetOperationTypeEnum.ADJUST_OUT.getCode(), null);
                adjustOutDetailDto.setProcessNo(processNo);
                adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
                adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                adjustOutDetailDto.setOperationRemarks(dto.getOperationRemarks());
                adjustOutDetailDtoList.add(adjustOutDetailDto);
            }
            this.monthBudgetDetailService.createList(adjustOutDetailDtoList);
            MonthBudgetDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustInAmount(), (BigDecimal)beforeAmountMap.get(adjustInEntity.getMonthBudgetCode()), BudgetOperationTypeEnum.ADJUST_IN.getCode(), null);
            adjustInDetailDto.setProcessNo(processNo);
            adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            adjustInDetailDto.setOperationRemarks(dto.getOperationRemarks());
            this.monthBudgetDetailService.create(adjustInDetailDto);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    private String adjustSubmit(MonthBudgetAdjustDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("adjust_month_budget");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        return processBusinessVo.getProcessNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void change(MonthBudgetOperateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getMonthBudgetCode(), (String)"\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)BudgetOperationTypeEnum.changeMap().containsKey(dto.getOperationType()), (String)"\u53d8\u66f4\u7c7b\u578b\u53ea\u80fd\u662f\u8ffd\u52a0\u3001\u524a\u51cf\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationAmount(), (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u5ba1\u6279\u6d41\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessTitle(), (String)"\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull((Object)((Object)monthBudgetEntity), (String)"\u5f53\u524d\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)("\u524a\u51cf\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9884\u7b97\u53ef\u7528\u91d1\u989d" + monthBudgetEntity.getAccumulatedAvailableBalance().setScale(4, RoundingMode.HALF_UP) + "\uff01"), (Object[])new Object[0]);
            }
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            if (BudgetOperationTypeEnum.ADD.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
            }
            monthBudgetEntity.setYearMonthDate(DateUtil.parseDate((String)monthBudgetEntity.getYearMonthLy(), (String)"yyyy-MM"));
            this.monthBudgetRepository.saveOrUpdate((Object)monthBudgetEntity);
            String processNo = this.changeSubmit(dto);
            MonthBudgetDetailDto changeDetailDto = this.buildDetail(monthBudgetEntity, dto.getOperationAmount(), beforeAmount, dto.getOperationType(), null);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                changeDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            } else {
                changeDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            }
            changeDetailDto.setProcessNo(processNo);
            changeDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            changeDetailDto.setOperationRemarks(dto.getOperationRemarks());
            this.monthBudgetDetailService.create(changeDetailDto);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    private String changeSubmit(MonthBudgetOperateDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("change_month_budget");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        return processBusinessVo.getProcessNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void unOrFreeze(MonthBudgetOperateDto dto, String operationType) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setOperationType(operationType);
        Validate.notBlank((CharSequence)dto.getMonthBudgetCode(), (String)"\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)BudgetOperationTypeEnum.freezeMap().containsKey(dto.getOperationType()), (String)"\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u662f\u51bb\u7ed3\u3001\u89e3\u51bb\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationAmount(), (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull((Object)((Object)monthBudgetEntity), (String)"\u5f53\u524d\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9884\u7b97\u53ef\u7528\u91d1\u989d" + monthBudgetEntity.getAccumulatedAvailableBalance().setScale(4, RoundingMode.HALF_UP) + "\uff01"), (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)("\u89e3\u51bb\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u51bb\u7ed3\u91d1\u989d" + monthBudgetEntity.getFreezeAmount().setScale(4, RoundingMode.HALF_UP) + "\uff01"), (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setFreezeAmount(Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                monthBudgetEntity.setFreezeAmount(Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            monthBudgetEntity.setYearMonthDate(DateUtil.parseDate((String)monthBudgetEntity.getYearMonthLy(), (String)"yyyy-MM"));
            this.monthBudgetRepository.saveOrUpdate((Object)monthBudgetEntity);
            MonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(monthBudgetEntity, dto.getOperationAmount(), beforeAmount, dto.getOperationType(), null);
            this.monthBudgetDetailService.create(adjustOutDetailDto);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    public List<MonthBudgetVo> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByBudgetItemCodeList(budgetItemCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return new ArrayList<MonthBudgetVo>(this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<MonthBudgetDto> monthBudgetDtoList) {
        if (CollectionUtils.isEmpty(monthBudgetDtoList)) {
            return;
        }
        Set yearBudgetCodeList = monthBudgetDtoList.stream().map(MonthBudgetDto::getYearBudgetCode).collect(Collectors.toSet());
        this.delByYearBudgetCode(Lists.newArrayList(yearBudgetCodeList));
        ArrayList<MonthBudgetEntity> monthBudgetEntities = new ArrayList<MonthBudgetEntity>(this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetDtoList, MonthBudgetDto.class, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        log.info("monthBudgetEntities {}", (Object)JSONObject.toJSONString(monthBudgetEntities));
        monthBudgetEntities.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
        this.monthBudgetRepository.saveBatch(monthBudgetEntities);
        this.buildInitDetail(monthBudgetEntities);
        monthBudgetDtoList.forEach(dto -> {
            MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = MonthBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MonthBudgetLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    private void buildInitDetail(List<MonthBudgetEntity> monthBudgetEntities) {
        ArrayList monthBudgetDetailEntities = new ArrayList();
        monthBudgetEntities.forEach(monthBudgetEntity -> {
            MonthBudgetDetailEntity monthBudgetDetailEntity = (MonthBudgetDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            monthBudgetDetailEntity.setInitialAmount(monthBudgetEntity.getInitResolveAmount());
            monthBudgetDetailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
            monthBudgetDetailEntities.add(monthBudgetDetailEntity);
        });
        this.monthBudgetDetailRepository.saveBatch(monthBudgetDetailEntities);
    }

    public List<MonthBudgetVo> listByYearBudgetCode(String yearBudgetCode) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearBudgetCode(yearBudgetCode);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            Lists.newArrayList();
        }
        return new ArrayList<MonthBudgetVo>(this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBatch(List<MonthBudgetDto> monthBudgetDtoList) {
        if (CollectionUtils.isEmpty(monthBudgetDtoList)) {
            return;
        }
        ArrayList monthBudgetEntities = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetDtoList, MonthBudgetDto.class, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.monthBudgetRepository.updateBatchById(monthBudgetEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delByYearBudgetCode(List<String> yearBudgetCodeList) {
        if (CollectionUtils.isEmpty(yearBudgetCodeList)) {
            return;
        }
        List<MonthBudgetDetailEntity> monthBudgetDetailEntities = this.monthBudgetDetailRepository.listDetailByYearBudgetCodeList(yearBudgetCodeList);
        if (!CollectionUtils.isEmpty(monthBudgetDetailEntities)) {
            Map<String, List<MonthBudgetDetailEntity>> detailMap = monthBudgetDetailEntities.stream().collect(Collectors.groupingBy(MonthBudgetDetailEntity::getMonthBudgetCode));
            detailMap.forEach((monthBudgetCode, detailList) -> {
                List collect = detailList.stream().filter(vo -> !BudgetOperationTypeEnum.INIT.getCode().equals(vo.getOperationType())).collect(Collectors.toList());
                if (collect.size() > 0) {
                    throw new RuntimeException("\u6708\u5ea6\u9884\u7b97" + monthBudgetCode + "\u5df2\u751f\u6210\u64cd\u4f5c\u660e\u7ec6\uff0c\u4e0d\u80fd\u4fee\u6539\u3001\u5220\u9664\uff01");
                }
            });
        }
        this.monthBudgetRepository.delByYearBudgetCode(yearBudgetCodeList);
        List<String> detailIds = monthBudgetDetailEntities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.monthBudgetDetailService.deleteByIds(detailIds);
    }

    public void manualReplay(List<String> ids, String planFlag) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List budgetItemCodeList = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toList());
        List budgetItemVos = this.budgetItemService.listByCodes(budgetItemCodeList);
        HashMap budgetItemVoMap = CollectionUtils.isEmpty((Collection)budgetItemVos) ? Maps.newHashMap() : budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity(), (oldVo, newVo) -> newVo));
        monthBudgetEntityList.forEach(entity -> {
            ArrayList lockKeys = Lists.newArrayList();
            lockKeys.add(entity.getMonthBudgetCode());
            boolean lock = true;
            try {
                lock = this.monthBudgetLockService.lock((List)lockKeys, TimeUnit.SECONDS, 5);
                if (lock) {
                    log.error("\u5f00\u59cb\u91cd\u65b0\u8ba1\u7b97\u9884\u7b97\uff1a{}", (Object)entity.getMonthBudgetCode());
                    this.calPlanReplay(entity.getId(), budgetItemVoMap, planFlag);
                }
            }
            catch (Exception e) {
                log.error("\u8ba1\u7b97\u9884\u7b97\u62a5\u9519\uff1a\u7f16\u7801{}\uff0c\u62a5\u9519\uff1a{}", (Object)entity.getMonthBudgetCode(), (Object)e);
            }
            finally {
                if (lock) {
                    this.monthBudgetLockService.unLock((List)lockKeys);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void manualRestoreReplayReimburse(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Set budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0026")) {
            throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u9500\u7ba1\u8d44\u91d1\u6c60\u9884\u7b97\u9879\u76ee\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                SalesPlanDto salesPlanDto1 = new SalesPlanDto();
                salesPlanDto1.setSalesInstitutionCode("20116000");
                salesPlanDto1.setExcludeProductCodeList(Arrays.asList("130100003400", "130100002946"));
                salesPlanDto1.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109"));
                salesPlanDto1.setYearMonthLy(yearMonthLy);
                List salesPlanVosA = this.salesPlanService.sumReplayReimburse(salesPlanDto1);
                HashMap mapA = CollectionUtils.isEmpty((Collection)salesPlanVosA) ? Maps.newHashMap() : salesPlanVosA.stream().collect(Collectors.toMap(SalesPlanVo::getYearMonthLy, SalesPlanVo::getDiscountRestoreAmount));
                SalesPlanDto salesPlanDto2 = new SalesPlanDto();
                salesPlanDto2.setSalesInstitutionCode("20112752");
                salesPlanDto2.setProductCategoryCode("106");
                salesPlanDto2.setYearMonthLy(yearMonthLy);
                List salesPlanVosB = this.salesPlanService.sumReplayReimburse(salesPlanDto2);
                HashMap mapB = CollectionUtils.isEmpty((Collection)salesPlanVosB) ? Maps.newHashMap() : salesPlanVosB.stream().collect(Collectors.toMap(SalesPlanVo::getYearMonthLy, SalesPlanVo::getDiscountRestoreAmount));
                YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
                yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
                yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode(), FeeBelongEnum.HEAD.getCode()));
                yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
                BigDecimal budgetTotalPoint = this.yearBudgetSdkService.sumBudgetTotalPoint(yearBudgetDto);
                MonthBudgetDto monthBudgetDto = (MonthBudgetDto)this.nebulaToolkitService.copyObjectByBlankList((Object)yearBudgetDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                monthBudgetDto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
                monthBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
                monthBudgetDto.setYear(String.valueOf(LocalDate.now().getYear()));
                BigDecimal sumFirstReplyAmountArea = Optional.ofNullable(this.monthBudgetRepository.sumFirstReplyAmount(monthBudgetDto)).orElse(BigDecimal.ZERO);
                monthBudgetDto.setFeeBelongCode(FeeBelongEnum.HEAD.getCode());
                BigDecimal sumFirstReplyAmountHead = Optional.ofNullable(this.monthBudgetRepository.sumFirstReplyAmount(monthBudgetDto)).orElse(BigDecimal.ZERO);
                BigDecimal sumFirstReplyAmounStudent = Optional.ofNullable(this.monthBudgetRepository.sumFirstReplyAmountStudent(monthBudgetDto)).orElse(BigDecimal.ZERO);
                monthBudgetDto.setBudgetItemCode("Z0020");
                BigDecimal sumFirstReplyAmounOthers = Optional.ofNullable(this.monthBudgetRepository.sumFirstReplyAmountOthers(monthBudgetDto)).orElse(BigDecimal.ZERO);
                for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                    BigDecimal a = Optional.ofNullable(mapA.get(monthBudgetEntity.getYearMonthLy())).orElse(BigDecimal.ZERO);
                    BigDecimal b = Optional.ofNullable(mapB.get(monthBudgetEntity.getYearMonthLy())).orElse(BigDecimal.ZERO);
                    BigDecimal calAmount = a.add(b).multiply(budgetTotalPoint).subtract(sumFirstReplyAmountArea).subtract(sumFirstReplyAmountHead).subtract(sumFirstReplyAmounStudent).subtract(sumFirstReplyAmounOthers).setScale(2, 4);
                    monthBudgetEntity.setCalAmount(calAmount);
                    monthBudgetEntity.setFirstReplyAmount(calAmount);
                    monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                    monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                    monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                    monthBudgetEntity.setComputedResult("\u5b8c\u6210");
                    this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
                    MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), null, BudgetOperationTypeEnum.REPLAY.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void manualActualReplayDiffReimburse(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Set budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0026")) {
            throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u9500\u7ba1\u8d44\u91d1\u6c60\u9884\u7b97\u9879\u76ee\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(e -> e.getYearMonthLy().replace("-", "")));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                MainOnedaySalesDataDto mainOnedaySalesDataDto1 = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto1.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                mainOnedaySalesDataDto1.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                mainOnedaySalesDataDto1.setSalesInstitutionCode("20116000");
                mainOnedaySalesDataDto1.setExcludeProductCodeList(Arrays.asList("130100003400", "130100002946"));
                mainOnedaySalesDataDto1.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109"));
                mainOnedaySalesDataDto1.setYearMonthLy(yearMonthLy);
                mainOnedaySalesDataDto1.setSalesOrgRegionCodeList(Arrays.asList("201160001028", "201160001027", "201160001026", "201160001025", "201160001024", "201160001018", "201160001014", "201160001012", "201160001011", "201160001009", "201160001008", "201160001006", "201160001005", "201160001004", "201160001003", "201160001001"));
                List mainOnedaySalesDataVos = this.mainOnedaySaleDataService.actualReplayDiffReimburse(mainOnedaySalesDataDto1);
                HashMap mapA = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.toMap(MainOnedaySalesDataVo::getYearMonthLy, MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                MainOnedaySalesDataDto mainOnedaySalesDataDto2 = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto2.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                mainOnedaySalesDataDto2.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                mainOnedaySalesDataDto2.setSalesInstitutionCode("20112752");
                mainOnedaySalesDataDto2.setSalesOrgRegionCodeList(Arrays.asList("201127521717", "201127521716", "201127521715", "201127521714", "201127521712", "201127521711", "201127521710", "201127521709", "201127521708", "201127521707", "201127521706", "201127521705", "201127521704", "201127521703", "201127521702", "201127521701"));
                List mainOnedaySalesDataVos2 = this.mainOnedaySaleDataService.actualReplayDiffReimburse(mainOnedaySalesDataDto1);
                HashMap mapB = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos2) ? Maps.newHashMap() : mainOnedaySalesDataVos2.stream().collect(Collectors.toMap(MainOnedaySalesDataVo::getYearMonthLy, MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
                yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
                yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode(), FeeBelongEnum.HEAD.getCode()));
                yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
                BigDecimal budgetTotalPoint = Optional.ofNullable(this.yearBudgetSdkService.sumBudgetTotalPoint(yearBudgetDto)).orElse(BigDecimal.ZERO);
                MonthBudgetDto monthBudgetDto = (MonthBudgetDto)this.nebulaToolkitService.copyObjectByBlankList((Object)yearBudgetDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                ArrayList salesOrgList = Lists.newArrayList();
                salesOrgList.add("20116000");
                salesOrgList.add("20112752");
                monthBudgetDto.setSalesOrgList((List)salesOrgList);
                monthBudgetDto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
                monthBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
                monthBudgetDto.setYear(String.valueOf(LocalDate.now().getYear()));
                BigDecimal sumActualSalesArea = Optional.ofNullable(this.monthBudgetRepository.sumActualSales(monthBudgetDto)).orElse(BigDecimal.ZERO);
                monthBudgetDto.setFeeBelongCode(FeeBelongEnum.HEAD.getCode());
                BigDecimal sumActualSalesHead = Optional.ofNullable(this.monthBudgetRepository.sumActualSales(monthBudgetDto)).orElse(BigDecimal.ZERO);
                BigDecimal sumActualSalesStudent = Optional.ofNullable(this.monthBudgetRepository.sumActualSalesStudent(monthBudgetDto)).orElse(BigDecimal.ZERO);
                monthBudgetDto.setBudgetItemCode("Z0020");
                BigDecimal sumActualSalesOthers = Optional.ofNullable(this.monthBudgetRepository.sumActualSalesOthers(monthBudgetDto)).orElse(BigDecimal.ZERO);
                thisMonthBudgetEntityList.forEach(e -> {
                    BigDecimal a = Optional.ofNullable(mapA.get(e.getYearMonthLy().replace("-", ""))).orElse(BigDecimal.ZERO);
                    BigDecimal b = Optional.ofNullable(mapB.get(e.getYearMonthLy().replace("-", ""))).orElse(BigDecimal.ZERO);
                    e.setActualSales(a.add(b).multiply(budgetTotalPoint).subtract(sumActualSalesArea).subtract(sumActualSalesHead).subtract(sumActualSalesStudent).subtract(sumActualSalesOthers).setScale(2, 4));
                });
                thisMonthBudgetEntityList.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
                this.monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);
                List<String> thisIdList = thisMonthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
                Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper).basic().builder();
                actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff((MonthBudgetActualSalesVo)v, null));
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void manualRestoreReplayOthers(List<String> ids, String planFlag) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Set budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0020")) {
            throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                List<String> salesOrgList = Arrays.asList("201160001028", "201160001027", "201160001026", "201160001025", "201160001024", "201160001018", "201160001014", "201160001012", "201160001011", "201160001009", "201160001008", "201160001006", "201160001005", "201160001004", "201160001003", "201160001001");
                SalesPlanDto salesPlanDto = new SalesPlanDto();
                salesPlanDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                salesPlanDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                salesPlanDto.setSalesProductCodeList(Arrays.asList("130100003400", "130100002946", "130100003010", "130100003206", "130100003205", "130100002890", "130100003039", "130100003031", "130100003105", "130100003116", "130100003227", "130100003021", "130100003427", "130100003450", "130100002188", "130100002187"));
                salesPlanDto.setYearMonthLy(yearMonthLy);
                salesPlanDto.setSalesOrgRegionCodeList(salesOrgList);
                List salesPlanVos = BooleanEnum.TRUE.getCapital().equals(planFlag) ? this.salesPlanService.sumReplayPlan(salesPlanDto) : this.salesPlanService.sumReplayRestore(salesPlanDto);
                HashMap map = CollectionUtils.isEmpty((Collection)salesPlanVos) ? Maps.newHashMap() : salesPlanVos.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getYearMonthLy()) && StringUtils.isNotEmpty((CharSequence)item.getSalesOrgRegionCode()) && null != item.getDiscountRestoreAmount()).collect(Collectors.groupingBy(SalesPlanVo::getYearMonthLy, Collectors.toMap(SalesPlanVo::getSalesOrgRegionCode, SalesPlanVo::getDiscountRestoreAmount)));
                YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
                yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
                yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode()));
                yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
                yearBudgetDto.setSalesOrgList(salesOrgList);
                List yearBudgetVos = this.yearBudgetSdkService.getYearBudgetTotalPointGroupBySalesOrg(yearBudgetDto);
                HashMap yearBudgetMap = CollectionUtils.isEmpty((Collection)yearBudgetVos) ? Maps.newHashMap() : yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getSalesOrgCode, YearBudgetVo::getBudgetTotalPoint));
                for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                    Map salesOrgMap = (Map)map.get(monthBudgetEntity.getYearMonthLy());
                    if (CollectionUtils.isEmpty((Map)salesOrgMap)) continue;
                    AtomicReference<BigDecimal> firstReplyAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    salesOrgMap.forEach((k, v) -> {
                        BigDecimal budgetTotalPoint = yearBudgetMap.getOrDefault(k, BigDecimal.ZERO);
                        firstReplyAmount.set(((BigDecimal)firstReplyAmount.get()).add(v.multiply(budgetTotalPoint)));
                    });
                    BigDecimal firstReplyAmountDecimal = firstReplyAmount.get();
                    monthBudgetEntity.setCalAmount(firstReplyAmountDecimal);
                    monthBudgetEntity.setFirstReplyAmount(firstReplyAmountDecimal);
                    monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                    monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                    monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                    monthBudgetEntity.setComputedResult("\u5b8c\u6210");
                    this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
                    MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), null, BooleanEnum.TRUE.getCapital().equals(planFlag) ? BudgetOperationTypeEnum.PLAN.getCode() : BudgetOperationTypeEnum.REPLAY.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void manualActualReplayDiffOthers(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Set budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        if (budgetItemCodeSet.size() > 1 || !budgetItemCodeSet.contains("Z0020")) {
            throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u5176\u4ed6\u9884\u7559\u9879\u76ee\u9884\u7b97\u9879\u76ee\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(e -> e.getYearMonthLy().replace("-", "")));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                List<String> salesOrgList = Arrays.asList("201160001028", "201160001027", "201160001026", "201160001025", "201160001024", "201160001018", "201160001014", "201160001012", "201160001011", "201160001009", "201160001008", "201160001006", "201160001005", "201160001004", "201160001003", "201160001001");
                List<String> productCodeList = Arrays.asList("130100003400", "130100002946", "130100003010", "130100003206", "130100003205", "130100002890", "130100003039", "130100003031", "130100003105", "130100003116", "130100003227", "130100003021", "130100003427", "130100003450", "130100002188", "130100002187");
                MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                mainOnedaySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                mainOnedaySalesDataDto.setSalesInstitutionCode("20116000");
                mainOnedaySalesDataDto.setProductCodes(productCodeList);
                mainOnedaySalesDataDto.setYearMonthLy(yearMonthLy);
                mainOnedaySalesDataDto.setSalesOrgRegionCodeList(salesOrgList);
                List mainOnedaySalesDataVos = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapA = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthLy, Collectors.toMap(MainOnedaySalesDataVo::getSalesOrgRegionCode, MainOnedaySalesDataVo::getDiscountBehindSaleAmount)));
                TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
                dailySalesDataDto.setSalesProductCodeList(productCodeList);
                dailySalesDataDto.setYearMonthLy(yearMonthLy);
                dailySalesDataDto.setSalesOrgRegionCodeList(salesOrgList);
                List dailySalesDataVos = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapB = CollectionUtils.isEmpty((Collection)dailySalesDataVos) ? Maps.newHashMap() : dailySalesDataVos.stream().collect(Collectors.groupingBy(TpmDailySalesDataVo::getYearMonthLy, Collectors.toMap(TpmDailySalesDataVo::getSalesOrgRegionCode, TpmDailySalesDataVo::getAfterDiscountAmt)));
                YearBudgetToralPointDto yearBudgetDto = new YearBudgetToralPointDto();
                yearBudgetDto.setYearLy(String.valueOf(LocalDate.now().getYear()));
                yearBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                yearBudgetDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                yearBudgetDto.setFeeBelongCodeList(Arrays.asList(FeeBelongEnum.AREA.getCode()));
                yearBudgetDto.setControlType(BudgetControlTypeEnum.RATIO.getCode());
                yearBudgetDto.setSalesOrgList(salesOrgList);
                List yearBudgetVos = this.yearBudgetSdkService.getYearBudgetTotalPointGroupBySalesOrg(yearBudgetDto);
                HashMap yearBudgetMap = CollectionUtils.isEmpty((Collection)yearBudgetVos) ? Maps.newHashMap() : yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getSalesOrgCode, YearBudgetVo::getBudgetTotalPoint));
                for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                    AtomicReference<BigDecimal> afterDiscountAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    Map salesOrgMapA = (Map)mapA.get(monthBudgetEntity.getYearMonthLy());
                    Map salesOrgMapB = (Map)mapB.get(monthBudgetEntity.getYearMonthLy());
                    if (!CollectionUtils.isEmpty((Map)salesOrgMapA)) {
                        salesOrgMapA.forEach((k, v) -> {
                            BigDecimal budgetTotalPoint = yearBudgetMap.getOrDefault(k, BigDecimal.ZERO);
                            afterDiscountAmt.set(((BigDecimal)afterDiscountAmt.get()).add(v.multiply(budgetTotalPoint)));
                        });
                    }
                    if (!CollectionUtils.isEmpty((Map)salesOrgMapB)) {
                        salesOrgMapB.forEach((k, v) -> {
                            BigDecimal budgetTotalPoint = yearBudgetMap.getOrDefault(k, BigDecimal.ZERO);
                            afterDiscountAmt.set(((BigDecimal)afterDiscountAmt.get()).add(v.multiply(budgetTotalPoint)));
                        });
                    }
                    monthBudgetEntity.setActualSales(afterDiscountAmt.get());
                }
                thisMonthBudgetEntityList.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
                this.monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);
                List<String> thisIdList = thisMonthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
                Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper).basic().builder();
                actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff((MonthBudgetActualSalesVo)v, null));
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void manualRestoreReplayRestoreDeluxu(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                HashSet budgetItemCodeSet = new HashSet();
                HashSet salesOrgSet = new HashSet();
                HashSet yearBudgetCodeSet = new HashSet();
                monthBudgetEntityList.forEach(e -> {
                    if (!"Z0019".equals(e.getBudgetItemCode()) && !"Z0030".equals(e.getBudgetItemCode())) {
                        throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u54c1\u7c7b\u653f\u7b56\u8d39\u7528-\u7279\u4ed1\u82cf\u6388\u6743\u6216\u54c1\u7c7b\u653f\u7b56\u8d39\u7528-\u7279\u4ed1\u82cf\u7edf\u7b79\u9884\u7b97\u9879\u76ee\uff01");
                    }
                    budgetItemCodeSet.add(e.getBudgetItemCode());
                    salesOrgSet.add(e.getSalesOrgCode());
                    yearBudgetCodeSet.add(e.getYearBudgetCode());
                });
                List yearBudgetVos = this.yearBudgetSdkService.findYearBudgetByYearBudgetCodes(new ArrayList(yearBudgetCodeSet));
                Map yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
                SalesPlanDto salesPlanDto = new SalesPlanDto();
                salesPlanDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                salesPlanDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
                salesPlanDto.setYearMonthLy(yearMonthLy);
                salesPlanDto.setSalesOrgRegionCodeList(new ArrayList(salesOrgSet));
                salesPlanDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
                List salesPlanVos = this.salesPlanService.sumReplayRestore(salesPlanDto);
                HashMap mapSalesPlanAll = CollectionUtils.isEmpty((Collection)salesPlanVos) ? Maps.newHashMap() : salesPlanVos.stream().filter(item -> null != item.getDiscountRestoreAmount()).collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesPlanVo::getDiscountRestoreAmount));
                salesPlanDto.setProductBrandCode("130009");
                salesPlanDto.setExcludeProductCategoryCodeList(null);
                List salesPlanVosDeluxu = this.salesPlanService.sumReplayRestore(salesPlanDto);
                HashMap mapSalesPlanDeluxu = CollectionUtils.isEmpty((Collection)salesPlanVosDeluxu) ? Maps.newHashMap() : salesPlanVosDeluxu.stream().filter(item -> null != item.getDiscountRestoreAmount()).collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesPlanVo::getDiscountRestoreAmount));
                salesPlanDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
                salesPlanDto.setProductBrandCode(null);
                salesPlanDto.setSalesProductCodeList(Arrays.asList("130100003394", "130100000138"));
                List salesPlanVosSlender = this.salesPlanService.sumReplayRestore(salesPlanDto);
                HashMap mapSalesPlanSlender = CollectionUtils.isEmpty((Collection)salesPlanVosSlender) ? Maps.newHashMap() : salesPlanVosSlender.stream().filter(item -> null != item.getDiscountRestoreAmount()).collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesPlanVo::getDiscountRestoreAmount));
                SalesGoalDto salesGoalDto = new SalesGoalDto();
                salesGoalDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
                salesGoalDto.setYearMonthLy(yearMonthLy);
                salesGoalDto.setSalesOrgRegionList(new ArrayList(salesOrgSet));
                salesGoalDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
                salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
                List salesGoalVos = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalAll = CollectionUtils.isEmpty((Collection)salesGoalVos) ? Maps.newHashMap() : salesGoalVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                salesGoalDto.setProductBrandCode("130009");
                salesGoalDto.setExcludeProductCategoryCodeList(null);
                List salesGoalVosDeluxu = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalDeluxu = CollectionUtils.isEmpty((Collection)salesGoalVosDeluxu) ? Maps.newHashMap() : salesGoalVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
                salesGoalDto.setProductBrandCode(null);
                salesGoalDto.setIncludeProductCodeList(Arrays.asList("130100003394", "130100000138"));
                List salesGoalVosSlender = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalSlender = CollectionUtils.isEmpty((Collection)salesGoalVosSlender) ? Maps.newHashMap() : salesGoalVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                HashMap mapSalesPlanHead = new HashMap();
                if (budgetItemCodeSet.contains("Z0030")) {
                    salesPlanDto.setSalesProductCodeList(Arrays.asList("130100000138"));
                    salesPlanDto.setSalesOrgRegionCodeList(null);
                    salesPlanDto.setSalesInstitutionCode("20116000");
                    List salesPlanVosHead = this.salesPlanService.sumReplayRestore(salesPlanDto);
                    mapSalesPlanHead = CollectionUtils.isEmpty((Collection)salesPlanVosHead) ? Maps.newHashMap() : salesPlanVosHead.stream().collect(Collectors.groupingBy(SalesPlanVo::getYearMonthLy, Collectors.reducing(BigDecimal.ZERO, SalesPlanVo::getDiscountPlanAmount, BigDecimal::add)));
                }
                for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                    BigDecimal budgetTotalAmount = ((YearBudgetVo)yearBudgetVoMap.get(monthBudgetEntity.getYearBudgetCode())).getBudgetTotalAmount();
                    BigDecimal planAll = mapSalesPlanAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal planDeluxu = mapSalesPlanDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal goalAll = mapSalesGoalAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal goalDeluxu = mapSalesGoalDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal planSlender = mapSalesPlanSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal goalSlender = mapSalesGoalSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal planAllRate = goalAll.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planAll.divide(goalAll, 4, 4);
                    BigDecimal planDeluxuRate = goalDeluxu.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planDeluxu.divide(goalDeluxu, 4, 4);
                    BigDecimal planSlenderRate = goalSlender.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : planSlender.divide(goalSlender, 4, 4);
                    BigDecimal maxRate = planAllRate.max(planDeluxuRate);
                    maxRate = maxRate.compareTo(new BigDecimal("0.9")) >= 0 ? BigDecimal.ONE : (maxRate.compareTo(new BigDecimal("0.9")) < 0 && maxRate.compareTo(new BigDecimal("0.8")) >= 0 ? new BigDecimal("0.9") : BigDecimal.ZERO);
                    BigDecimal monthArea = maxRate.multiply(budgetTotalAmount).multiply(planSlenderRate).setScale(2, 4);
                    if ("Z0030".equals(monthBudgetEntity.getBudgetItemCode())) {
                        BigDecimal head = mapSalesPlanHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO);
                        head = head.multiply(StringUtils.isNotBlank((CharSequence)monthBudgetEntity.getBudgetIntensity()) ? new BigDecimal(monthBudgetEntity.getBudgetIntensity()) : BigDecimal.ZERO);
                        monthArea = head.subtract(monthArea);
                    }
                    monthBudgetEntity.setCalAmount(monthArea);
                    monthBudgetEntity.setFirstReplyAmount(monthArea);
                    monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                    monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                    monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                    monthBudgetEntity.setComputedResult("\u5b8c\u6210");
                    this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
                    MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), null, BudgetOperationTypeEnum.REPLAY.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualActualReplayDiffDeluxuMonth(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                String yearMonthNum = yearMonthLy.replace("-", "");
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                HashSet budgetItemCodeSet = new HashSet();
                HashSet salesOrgSet = new HashSet();
                HashSet yearBudgetCodeSet = new HashSet();
                thisMonthBudgetEntityList.forEach(e -> {
                    if (!"Z0019".equals(e.getBudgetItemCode()) && !"Z0030".equals(e.getBudgetItemCode())) {
                        throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u54c1\u7c7b\u653f\u7b56\u8d39\u7528-\u7279\u4ed1\u82cf\u6388\u6743\u6216\u54c1\u7c7b\u653f\u7b56\u8d39\u7528-\u7279\u4ed1\u82cf\u7edf\u7b79\u9884\u7b97\u9879\u76ee\uff01");
                    }
                    budgetItemCodeSet.add(e.getBudgetItemCode());
                    salesOrgSet.add(e.getSalesOrgCode());
                    yearBudgetCodeSet.add(e.getYearBudgetCode());
                });
                List yearBudgetVos = this.yearBudgetSdkService.findYearBudgetByYearBudgetCodes(new ArrayList(yearBudgetCodeSet));
                Map yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
                MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                mainOnedaySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                mainOnedaySalesDataDto.setYearMonthLy(yearMonthNum);
                mainOnedaySalesDataDto.setSalesOrgRegionCodeList(new ArrayList(salesOrgSet));
                mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
                List mainOnedaySalesDataVos = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapMainOnedaySalesAll = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                mainOnedaySalesDataDto.setProductBrandCode("130009");
                mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(null);
                List mainOnedaySalesDataDeluxu = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapMainOnedaySalesDeluxu = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataDeluxu) ? Maps.newHashMap() : mainOnedaySalesDataDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                mainOnedaySalesDataDto.setProductBrandCode(null);
                mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100003394", "130100000138"));
                List mainOnedaySalesDataSlenderVos = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapMainOnedaySalesDataSlender = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataSlenderVos) ? Maps.newHashMap() : mainOnedaySalesDataSlenderVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
                dailySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                dailySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                dailySalesDataDto.setYearMonthLy(yearMonthNum);
                dailySalesDataDto.setSalesOrgRegionCodeList(new ArrayList(salesOrgSet));
                List dailySalesDataVos = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapDailySalesData = CollectionUtils.isEmpty((Collection)dailySalesDataVos) ? Maps.newHashMap() : dailySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
                dailySalesDataDto.setBrand("\u7279\u4ed1\u82cf");
                List dailySalesDataVosDeluxu = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapDailySalesDataDeluxu = CollectionUtils.isEmpty((Collection)dailySalesDataVosDeluxu) ? Maps.newHashMap() : dailySalesDataVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
                dailySalesDataDto.setBrand(null);
                dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100003394", "130100000138"));
                List dailySalesDataVosSlender = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapDailySalesDataSlender = CollectionUtils.isEmpty((Collection)dailySalesDataVosSlender) ? Maps.newHashMap() : dailySalesDataVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
                SalesGoalDto salesGoalDto = new SalesGoalDto();
                salesGoalDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
                salesGoalDto.setYearMonthLy(yearMonthLy);
                salesGoalDto.setSalesOrgRegionList(new ArrayList(salesOrgSet));
                salesGoalDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
                salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
                List salesGoalVos = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalAll = CollectionUtils.isEmpty((Collection)salesGoalVos) ? Maps.newHashMap() : salesGoalVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                salesGoalDto.setProductBrandCode("130009");
                salesGoalDto.setExcludeProductCategoryCodeList(null);
                List salesGoalVosDeluxu = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalDeluxu = CollectionUtils.isEmpty((Collection)salesGoalVosDeluxu) ? Maps.newHashMap() : salesGoalVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
                salesGoalDto.setProductBrandCode(null);
                salesGoalDto.setIncludeProductCodeList(Arrays.asList("130100003394", "130100000138"));
                List salesGoalVosSlender = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalSlender = CollectionUtils.isEmpty((Collection)salesGoalVosSlender) ? Maps.newHashMap() : salesGoalVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                HashMap mapMainOnedaySalesDataHead = new HashMap();
                HashMap mapDailySalesDataHead = new HashMap();
                if (budgetItemCodeSet.contains("Z0030")) {
                    mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100000138"));
                    mainOnedaySalesDataDto.setSalesOrgRegionCodeList(null);
                    mainOnedaySalesDataDto.setSalesInstitutionCode("20116000");
                    List mainOnedaySalesDataHead = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                    mapMainOnedaySalesDataHead = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataHead) ? Maps.newHashMap() : mainOnedaySalesDataHead.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthLy, Collectors.reducing(BigDecimal.ZERO, MainOnedaySalesDataVo::getDiscountBehindSaleAmount, BigDecimal::add)));
                    dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100000138"));
                    dailySalesDataDto.setSalesOrgRegionCodeList(null);
                    dailySalesDataDto.setSalesInstitutionCode("20116000");
                    List dailySalesDataHead = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                    mapDailySalesDataHead = CollectionUtils.isEmpty((Collection)dailySalesDataHead) ? Maps.newHashMap() : dailySalesDataHead.stream().collect(Collectors.groupingBy(TpmDailySalesDataVo::getYearMonthLy, Collectors.reducing(BigDecimal.ZERO, TpmDailySalesDataVo::getAfterDiscountAmt, BigDecimal::add)));
                }
                for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                    BigDecimal budgetTotalAmount = ((YearBudgetVo)yearBudgetVoMap.get(monthBudgetEntity.getYearBudgetCode())).getBudgetTotalAmount();
                    String yearMonthLyNum = monthBudgetEntity.getYearMonthLy().replace("-", "");
                    BigDecimal mainOnedaySalesAll = mapMainOnedaySalesAll.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal mainOnedaySalesDeluxu = mapMainOnedaySalesDeluxu.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal mainOnedaySalesDataSlender = mapMainOnedaySalesDataSlender.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal dailySalesDataAll = mapDailySalesData.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal dailySalesDataDeluxu = mapDailySalesDataDeluxu.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal dailySalesDataSlender = mapDailySalesDataSlender.getOrDefault(yearMonthLyNum + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal goalAll = mapSalesGoalAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal goalDeluxu = mapSalesGoalDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal goalSlender = mapSalesGoalSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO);
                    BigDecimal planAllRate = goalAll.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainOnedaySalesAll.add(dailySalesDataAll).divide(goalAll, 4, 4);
                    BigDecimal planDeluxuRate = goalDeluxu.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainOnedaySalesDeluxu.add(dailySalesDataDeluxu).divide(goalDeluxu, 4, 4);
                    BigDecimal planSlenderRate = goalSlender.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainOnedaySalesDataSlender.add(dailySalesDataSlender).divide(goalSlender, 4, 4);
                    BigDecimal maxRate = planAllRate.max(planDeluxuRate);
                    maxRate = maxRate.compareTo(new BigDecimal("0.9")) >= 0 ? BigDecimal.ONE : (maxRate.compareTo(new BigDecimal("0.9")) < 0 && maxRate.compareTo(new BigDecimal("0.8")) >= 0 ? new BigDecimal("0.9") : BigDecimal.ZERO);
                    BigDecimal monthArea = maxRate.multiply(budgetTotalAmount).multiply(planSlenderRate).setScale(2, 4);
                    if ("Z0030".equals(monthBudgetEntity.getBudgetItemCode())) {
                        BigDecimal head = mapMainOnedaySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO).add(mapDailySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO));
                        head = head.multiply(StringUtils.isNotBlank((CharSequence)monthBudgetEntity.getBudgetIntensity()) ? new BigDecimal(monthBudgetEntity.getBudgetIntensity()) : BigDecimal.ZERO);
                        monthArea = head.subtract(monthArea);
                    }
                    monthBudgetEntity.setActualSales(monthArea);
                }
                thisMonthBudgetEntityList.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
                this.monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);
                List<String> thisIdList = thisMonthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
                Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper).basic().builder();
                actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff((MonthBudgetActualSalesVo)v, null));
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualActualReplayDiffDeluxuQuarter(List<String> ids) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        boolean lock = false;
        List monthBudgetCodeList = monthBudgetEntityList.stream().map(e -> e.getMonthBudgetCode()).collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map<String, List<MonthBudgetEntity>> monthBudgetMap = monthBudgetEntityList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearMonthLy));
            for (Map.Entry<String, List<MonthBudgetEntity>> entry : monthBudgetMap.entrySet()) {
                String yearMonthLy = entry.getKey();
                String yearMonthNum = yearMonthLy.replace("-", "");
                List<MonthBudgetEntity> thisMonthBudgetEntityList = entry.getValue();
                HashSet budgetItemCodeSet = new HashSet();
                HashSet yearMonthSet = new HashSet();
                HashSet yearMonthNumSet = new HashSet();
                HashSet salesOrgSet = new HashSet();
                HashSet yearBudgetCodeSet = new HashSet();
                thisMonthBudgetEntityList.forEach(e -> {
                    if (!"Z0019".equals(e.getBudgetItemCode()) && !"Z0030".equals(e.getBudgetItemCode())) {
                        throw new RuntimeException("\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5fc5\u987b\u4e3a\u54c1\u7c7b\u653f\u7b56\u8d39\u7528-\u7279\u4ed1\u82cf\u6388\u6743\u6216\u54c1\u7c7b\u653f\u7b56\u8d39\u7528-\u7279\u4ed1\u82cf\u7edf\u7b79\u9884\u7b97\u9879\u76ee\uff01");
                    }
                    Map<String, Set<String>> quarterMonth = this.getQuarterMonth(e.getYearMonthLy());
                    budgetItemCodeSet.add(e.getBudgetItemCode());
                    yearMonthSet.addAll(quarterMonth.get("yearMonthLySet"));
                    yearMonthNumSet.addAll(quarterMonth.get("yearMonthLyNumSet"));
                    salesOrgSet.add(e.getSalesOrgCode());
                    yearBudgetCodeSet.add(e.getYearBudgetCode());
                });
                if (CollectionUtils.isEmpty(yearMonthSet)) {
                    throw new RuntimeException("\u5f53\u524d\u6570\u636e\u6708\u4efd\u5c5e\u4e8e\u7b2c\u4e00\u5b63\u5ea6\uff0c\u65e0\u9700\u8ba1\u7b97\u5b63\u5ea6\u5b9e\u9500\u56de\u590d\u5dee\uff01");
                }
                List yearBudgetVos = this.yearBudgetSdkService.findYearBudgetByYearBudgetCodes(new ArrayList(yearBudgetCodeSet));
                Map yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
                MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                mainOnedaySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                mainOnedaySalesDataDto.setYearMonthLy(yearMonthNum);
                mainOnedaySalesDataDto.setSalesOrgRegionCodeList(new ArrayList(salesOrgSet));
                mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
                List mainOnedaySalesDataVos = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapMainOnedaySalesAll = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos) ? Maps.newHashMap() : mainOnedaySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                mainOnedaySalesDataDto.setProductBrandCode("130009");
                mainOnedaySalesDataDto.setExcludeProductCategoryCodeList(null);
                List mainOnedaySalesDataDeluxu = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapMainOnedaySalesDeluxu = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataDeluxu) ? Maps.newHashMap() : mainOnedaySalesDataDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                mainOnedaySalesDataDto.setProductBrandCode(null);
                mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100003394", "130100000138"));
                List mainOnedaySalesDataSlenderVos = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                HashMap mapMainOnedaySalesDataSlender = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataSlenderVos) ? Maps.newHashMap() : mainOnedaySalesDataSlenderVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), MainOnedaySalesDataVo::getDiscountBehindSaleAmount));
                TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
                dailySalesDataDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                dailySalesDataDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                dailySalesDataDto.setYearMonthLyList(new ArrayList(yearMonthNumSet));
                dailySalesDataDto.setSalesOrgRegionCodeList(new ArrayList(salesOrgSet));
                List dailySalesDataVos = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapDailySalesData = CollectionUtils.isEmpty((Collection)dailySalesDataVos) ? Maps.newHashMap() : dailySalesDataVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
                dailySalesDataDto.setBrand("\u7279\u4ed1\u82cf");
                List dailySalesDataVosDeluxu = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapDailySalesDataDeluxu = CollectionUtils.isEmpty((Collection)dailySalesDataVosDeluxu) ? Maps.newHashMap() : dailySalesDataVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
                dailySalesDataDto.setBrand(null);
                dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100003394", "130100000138"));
                List dailySalesDataVosSlender = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                HashMap mapDailySalesDataSlender = CollectionUtils.isEmpty((Collection)dailySalesDataVosSlender) ? Maps.newHashMap() : dailySalesDataVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), TpmDailySalesDataVo::getAfterDiscountAmt));
                SalesGoalDto salesGoalDto = new SalesGoalDto();
                salesGoalDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode(), BusinessUnitEnum.VERTICAL.getCode()));
                salesGoalDto.setYearMonthLy(yearMonthLy);
                salesGoalDto.setSalesOrgRegionList(new ArrayList(salesOrgSet));
                salesGoalDto.setExcludeProductCategoryCodeList(Arrays.asList("161", "140", "107", "108", "109", "106"));
                salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
                List salesGoalVos = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalAll = CollectionUtils.isEmpty((Collection)salesGoalVos) ? Maps.newHashMap() : salesGoalVos.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                salesGoalDto.setProductBrandCode("130009");
                salesGoalDto.setExcludeProductCategoryCodeList(null);
                List salesGoalVosDeluxu = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalDeluxu = CollectionUtils.isEmpty((Collection)salesGoalVosDeluxu) ? Maps.newHashMap() : salesGoalVosDeluxu.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                salesGoalDto.setBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.HEADQUARTERS.getCode()));
                salesGoalDto.setProductBrandCode(null);
                salesGoalDto.setIncludeProductCodeList(Arrays.asList("130100003394", "130100000138"));
                List salesGoalVosSlender = this.salesGoalService.restoreReplaySalesAfterDiscount(salesGoalDto);
                HashMap mapSalesGoalSlender = CollectionUtils.isEmpty((Collection)salesGoalVosSlender) ? Maps.newHashMap() : salesGoalVosSlender.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getSalesOrgRegionCode(), SalesGoalVo::getDeliveryDiscountSalesAmount));
                HashMap mapMainOnedaySalesDataHead = new HashMap();
                HashMap mapDailySalesDataHead = new HashMap();
                if (budgetItemCodeSet.contains("Z0030")) {
                    mainOnedaySalesDataDto.setProductCodes(Arrays.asList("130100000138"));
                    mainOnedaySalesDataDto.setSalesOrgRegionCodeList(null);
                    mainOnedaySalesDataDto.setSalesInstitutionCode("20116000");
                    List mainOnedaySalesDataHead = this.mainOnedaySaleDataService.actualReplayDiffOthers(mainOnedaySalesDataDto);
                    mapMainOnedaySalesDataHead = CollectionUtils.isEmpty((Collection)mainOnedaySalesDataHead) ? Maps.newHashMap() : mainOnedaySalesDataHead.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthLy, Collectors.reducing(BigDecimal.ZERO, MainOnedaySalesDataVo::getDiscountBehindSaleAmount, BigDecimal::add)));
                    dailySalesDataDto.setSalesProductCodeList(Arrays.asList("130100000138"));
                    dailySalesDataDto.setSalesOrgRegionCodeList(null);
                    dailySalesDataDto.setSalesInstitutionCode("20116000");
                    List dailySalesDataHead = this.tpmDailySalesDataService.afterDiscountAmtByCondition(dailySalesDataDto);
                    mapDailySalesDataHead = CollectionUtils.isEmpty((Collection)dailySalesDataHead) ? Maps.newHashMap() : dailySalesDataHead.stream().collect(Collectors.groupingBy(TpmDailySalesDataVo::getYearMonthLy, Collectors.reducing(BigDecimal.ZERO, TpmDailySalesDataVo::getAfterDiscountAmt, BigDecimal::add)));
                }
                for (MonthBudgetEntity monthBudgetEntity : thisMonthBudgetEntityList) {
                    BigDecimal budgetTotalAmount = ((YearBudgetVo)yearBudgetVoMap.get(monthBudgetEntity.getYearBudgetCode())).getBudgetTotalAmount();
                    Map<String, Set<String>> quarterMonth = this.getQuarterMonth(monthBudgetEntity.getYearMonthLy());
                    Set<String> yearMonthLyNumSet = quarterMonth.get("yearMonthLyNumSet");
                    if (CollectionUtils.isEmpty(yearMonthLyNumSet)) continue;
                    AtomicReference<BigDecimal> mainOnedaySalesAll = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> mainOnedaySalesDeluxu = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> mainOnedaySalesDataSlender = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> dailySalesDataAll = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> dailySalesDataDeluxu = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> dailySalesDataSlender = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    yearMonthLyNumSet.forEach(e -> {
                        mainOnedaySalesAll.set(((BigDecimal)mainOnedaySalesAll.get()).add(mapMainOnedaySalesAll.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        mainOnedaySalesDeluxu.set(((BigDecimal)mainOnedaySalesDeluxu.get()).add(mapMainOnedaySalesDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        mainOnedaySalesDataSlender.set(((BigDecimal)mainOnedaySalesDataSlender.get()).add(mapMainOnedaySalesDataSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        dailySalesDataAll.set(((BigDecimal)dailySalesDataAll.get()).add(mapDailySalesData.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        dailySalesDataDeluxu.set(((BigDecimal)dailySalesDataDeluxu.get()).add(mapDailySalesDataDeluxu.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        dailySalesDataSlender.set(((BigDecimal)dailySalesDataSlender.get()).add(mapDailySalesDataSlender.getOrDefault(monthBudgetEntity.getYearMonthLy() + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    });
                    Set<String> yearMonthLySet = quarterMonth.get("yearMonthLySet");
                    AtomicReference<BigDecimal> goalAll = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> goalDeluxu = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    AtomicReference<BigDecimal> goalSlender = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                    yearMonthLySet.forEach(e -> {
                        goalAll.set(((BigDecimal)goalAll.get()).add(mapSalesGoalAll.getOrDefault(e + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        goalDeluxu.set(((BigDecimal)goalDeluxu.get()).add(mapSalesGoalDeluxu.getOrDefault(e + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                        goalSlender.set(((BigDecimal)goalSlender.get()).add(mapSalesGoalSlender.getOrDefault(e + monthBudgetEntity.getSalesOrgCode(), BigDecimal.ZERO)));
                    });
                    BigDecimal planAllRate = goalAll.get().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainOnedaySalesAll.get().add(dailySalesDataAll.get()).divide(goalAll.get(), 4, 4);
                    BigDecimal planDeluxuRate = goalDeluxu.get().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainOnedaySalesDeluxu.get().add(dailySalesDataDeluxu.get()).divide(goalDeluxu.get(), 4, 4);
                    BigDecimal planSlenderRate = goalSlender.get().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : mainOnedaySalesDataSlender.get().add(dailySalesDataSlender.get()).divide(goalSlender.get(), 4, 4);
                    BigDecimal maxRate = planAllRate.max(planDeluxuRate);
                    maxRate = maxRate.compareTo(new BigDecimal("0.9")) >= 0 ? BigDecimal.ONE : (maxRate.compareTo(new BigDecimal("0.9")) < 0 && maxRate.compareTo(new BigDecimal("0.8")) >= 0 ? new BigDecimal("0.9") : BigDecimal.ZERO);
                    BigDecimal monthArea = maxRate.multiply(budgetTotalAmount).multiply(planSlenderRate).setScale(2, 4);
                    if ("Z0030".equals(monthBudgetEntity.getBudgetItemCode())) {
                        BigDecimal head = mapMainOnedaySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO).add(mapDailySalesDataHead.getOrDefault(monthBudgetEntity.getYearMonthLy(), BigDecimal.ZERO));
                        head = head.multiply(StringUtils.isNotBlank((CharSequence)monthBudgetEntity.getBudgetIntensity()) ? new BigDecimal(monthBudgetEntity.getBudgetIntensity()) : BigDecimal.ZERO);
                        monthArea = head.subtract(monthArea);
                    }
                    monthBudgetEntity.setActualSales(monthArea);
                }
                thisMonthBudgetEntityList.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
                this.monthBudgetRepository.saveOrUpdateBatch(thisMonthBudgetEntityList);
                List<String> thisIdList = thisMonthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
                Map<String, MonthBudgetActualSalesVo> actualSalesMap = MonthBudgetActualSalesBuilder.init(thisIdList, this.budgetCalculateStrategies, this.monthBudgetHelper).basic().builder();
                actualSalesMap.forEach((k, v) -> this.calculateActualReplyDiff((MonthBudgetActualSalesVo)v, null));
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    Map<String, Set<String>> getQuarterMonth(String yearMonthLy) {
        final HashSet<String> yearMonthLySet = new HashSet<String>();
        final HashSet<String> yearMonthLyNumSet = new HashSet<String>();
        String[] split = yearMonthLy.split("-");
        int month = Integer.valueOf(split[1]);
        if (month > 3 && month <= 6) {
            yearMonthLyNumSet.add(split[0] + "01");
            yearMonthLyNumSet.add(split[0] + "02");
            yearMonthLyNumSet.add(split[0] + "03");
            yearMonthLySet.add(split[0] + "-01");
            yearMonthLySet.add(split[0] + "-02");
            yearMonthLySet.add(split[0] + "-03");
        } else if (month > 6 && month <= 9) {
            yearMonthLyNumSet.add(split[0] + "04");
            yearMonthLyNumSet.add(split[0] + "05");
            yearMonthLyNumSet.add(split[0] + "06");
            yearMonthLySet.add(split[0] + "-04");
            yearMonthLySet.add(split[0] + "-05");
            yearMonthLySet.add(split[0] + "-06");
        } else if (month > 9 && month <= 12) {
            yearMonthLyNumSet.add(split[0] + "07");
            yearMonthLyNumSet.add(split[0] + "08");
            yearMonthLyNumSet.add(split[0] + "09");
            yearMonthLySet.add(split[0] + "-07");
            yearMonthLySet.add(split[0] + "-08");
            yearMonthLySet.add(split[0] + "-09");
        }
        return new HashMap<String, Set<String>>(){
            {
                this.put("yearMonthLySet", yearMonthLySet);
                this.put("yearMonthLyNumSet", yearMonthLyNumSet);
            }
        };
    }

    public void manualReplayYearMonth(String yearMonth, String planFlag, AbstractCrmUserIdentity crmUserIdentity) {
    }

    @Transactional(rollbackFor={Exception.class})
    void buildData(Map<String, BudgetItemVo> finalBudgetItemVoMap, BudgetCalConfigDataVo calConfigDataVo, MonthBudgetEntity monthBudgetEntity, List<SalesPlanVo> salesPlanVos, String planFlag, BudgetCalConfigVo budgetCalConfigVo) {
        YearBudgetResponse budgetResponse;
        AtomicReference<BigDecimal> reduce = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> productRatioreduce = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        BudgetItemControlConditionVo conditionVo = this.monthBudgetHelper.getBudgetItemControlCondition(monthBudgetEntity, finalBudgetItemVoMap);
        BigDecimal yearBudgetTotalPoint = null;
        YearBudgetEventDto eventDto = new YearBudgetEventDto();
        eventDto.setYearBudgetCode(monthBudgetEntity.getYearBudgetCode());
        eventDto.setSalesOrgCode(monthBudgetEntity.getSalesOrgCode());
        eventDto.setBusinessFormatCode(budgetCalConfigVo.getBusinessFormatCode());
        eventDto.setBusinessUnitCode(budgetCalConfigVo.getBusinessUnitCode());
        eventDto.setBudgetTypeCode(budgetCalConfigVo.getBudgetTypeCode());
        eventDto.setFeeBelongCode(budgetCalConfigVo.getFeeBelongCode());
        eventDto.setControlType(budgetCalConfigVo.getControlType());
        eventDto.setOrgAreaCode(budgetCalConfigVo.getOrgAreaCode());
        eventDto.setSalesOrgList(budgetCalConfigVo.getSalesOrgList());
        eventDto.setOrgCode(monthBudgetEntity.getOrgCode());
        eventDto.setGroupCode(monthBudgetEntity.getGroupCode());
        eventDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
        eventDto.setYearLy(DateUtil.dateToStr((Date)DateUtil.strToDate((String)monthBudgetEntity.getYearMonthLy(), (SimpleDateFormat)DateUtil.date_yyyy_MM), (SimpleDateFormat)DateUtil.date_yyyy));
        SerializableBiConsumer & Serializable getYearBudgetByCode = YearBudgetEventListener::getYearBudgetByCode;
        EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, YearBudgetEventListener.class, (SerializableBiConsumer)getYearBudgetByCode);
        if (!Objects.isNull(eventResponse) && !Objects.isNull((budgetResponse = (YearBudgetResponse)eventResponse).getBudgetTotalPoint())) {
            yearBudgetTotalPoint = budgetResponse.getBudgetTotalPoint().divide(new BigDecimal(100), 8, 4);
        }
        String amountTypeCode = calConfigDataVo.getAmountTypeCode();
        log.error("\u91d1\u989d\u7c7b\u578b\uff1a{}\uff0c\u5e74\u5ea6\u9884\u7b97\u603b\u70b9\u6570={}", (Object)amountTypeCode, yearBudgetTotalPoint);
        if (!CollectionUtils.isEmpty(salesPlanVos)) {
            BigDecimal finalBudgetTotalPoint = yearBudgetTotalPoint;
            salesPlanVos.forEach(salesPlanVo -> this.monthBudgetHelper.calculationReduce(reduce, (SalesPlanVo)salesPlanVo, amountTypeCode, budgetCalConfigVo, monthBudgetEntity, finalBudgetTotalPoint));
        }
        log.info("\u6708\u5ea6\u9884\u7b97\u8ba1\u5212\u91cf/\u56de\u590d\u91cf\uff0creduce=:{}", (Object)reduce.get());
        BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
        if (finalBudgetItemVoMap.containsKey(monthBudgetEntity.getBudgetItemCode())) {
            String controlTypeCode = conditionVo.getControlTypeCode();
            if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlTypeCode)) {
                monthBudgetEntity.setFirstReplyAmount(monthBudgetEntity.getInitResolveAmount());
                monthBudgetEntity.setCalAmount(BigDecimal.ZERO);
                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            } else if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode)) {
                Assert.notNull((Object)monthBudgetEntity.getBudgetTotalPoint(), (String)("\u9884\u7b97\u9879\u76ee" + monthBudgetEntity.getBudgetItemCode() + "\u9884\u7b97\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                BigDecimal budgetTotalPoint = monthBudgetEntity.getBudgetTotalPoint().divide(new BigDecimal(100), 8, RoundingMode.HALF_UP);
                monthBudgetEntity.setFirstReplyAmount(reduce.get().multiply(budgetTotalPoint));
                monthBudgetEntity.setCalAmount(reduce.get());
                monthBudgetEntity.setFirstReplyResolveDiffAmount(Optional.ofNullable(monthBudgetEntity.getFirstReplyAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(monthBudgetEntity.getInitResolveAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            } else if (BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
                BigDecimal calculatingData = reduce.get();
                BigDecimal budgetIntensityNumerator = monthBudgetEntity.getBudgetIntensityNumerator();
                BigDecimal budgetIntensityDenominator = monthBudgetEntity.getBudgetIntensityDenominator();
                monthBudgetEntity.setFirstReplyAmount(monthBudgetEntity.getInitResolveAmount());
                monthBudgetEntity.setCalAmount(calculatingData);
                monthBudgetEntity.setFirstReplyAmount(calculatingData.multiply(budgetIntensityNumerator).divide(budgetIntensityDenominator, 6, 4));
                monthBudgetEntity.setFirstReplyResolveDiffAmount(monthBudgetEntity.getFirstReplyAmount().subtract(monthBudgetEntity.getInitResolveAmount()));
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(monthBudgetEntity, BusinessUnitEnum.HEADQUARTERS));
            }
        }
        monthBudgetEntity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
        monthBudgetEntity.setComputedResult("\u5b8c\u6210");
        this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
        MonthBudgetDetailDto monthBudgetDetailDto = new MonthBudgetDetailDto();
        monthBudgetDetailDto = BooleanEnum.TRUE.getCapital().equals(planFlag) ? this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), beforeAmount, BudgetOperationTypeEnum.PLAN.getCode(), null) : this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), beforeAmount, BudgetOperationTypeEnum.REPLAY.getCode(), null);
        this.monthBudgetDetailService.create(monthBudgetDetailDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void manualActualReplayDiff(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u624b\u5de5\u6267\u884c\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        this.calActualReplayDiff(ids);
    }

    public void manualRolling(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u624b\u5de5\u6267\u884c\u6eda\u52a8\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List<MonthBudgetEntity> currMonthBudgetList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(currMonthBudgetList)) {
            return;
        }
        String currDateStr = DateUtil.getDate((String)"yyyy-MM");
        Date currDate = DateUtil.parseDate((String)currDateStr, (String)"yyyy-MM");
        currMonthBudgetList.forEach(monthbudget -> {
            String yearMonthLy = monthbudget.getYearMonthLy();
            Date monthbudgetDate = DateUtil.parseDate((String)yearMonthLy, (String)"yyyy-MM");
            Assert.isTrue((monthbudgetDate.compareTo(currDate) <= 0 ? 1 : 0) != 0, (String)"\u6240\u9009\u6708\u5ea6\u9884\u7b97\u5e74\u6708\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u5e74\u6708");
        });
        Map<String, List<DimensionControlsVo>> dimensionControlMap = this.monthBudgetHelper.findDimensionControl();
        Map<String, List<DimensionControlsVo>> dimensionControlMap2 = this.monthBudgetHelper.findDimensionControlNoSalesOrg();
        Map<String, List<MonthBudgetEntity>> yearBudgetCodeMap = currMonthBudgetList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getYearBudgetCode())).collect(Collectors.groupingBy(MonthBudgetEntity::getYearBudgetCode));
        yearBudgetCodeMap.forEach((yearBudgetCode, monthBudgetEntities) -> monthBudgetEntities.stream().sorted(Comparator.comparing(MonthBudgetEntity::getYearMonthLy)).forEach(entity -> {
            String dimensionControlKey;
            String yearMonthLy = entity.getYearMonthLy();
            String[] yearMonthArray = yearMonthLy.split("-");
            LocalDate currMonthBudgetLocalDate = LocalDate.of(Integer.parseInt(yearMonthArray[0]), Integer.parseInt(yearMonthArray[1]), 1);
            int monthValue = currMonthBudgetLocalDate.getMonthValue();
            if (monthValue == 1) {
                return;
            }
            log.error("\u6708\u4efd:{}", (Object)entity.getYearMonthLy());
            List dimensionControlsVos = null;
            if (FeeBelongEnum.HEAD.getCode().equals(entity.getFeeBelongCode())) {
                dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode();
                dimensionControlsVos = (List)dimensionControlMap2.get(dimensionControlKey);
            } else {
                dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getSalesOrgCode();
                dimensionControlsVos = (List)dimensionControlMap.get(dimensionControlKey);
            }
            if (CollectionUtils.isEmpty((Collection)dimensionControlsVos)) {
                return;
            }
            DimensionControlsVo dimensionControlsVo = this.monthBudgetHelper.matchDimensionControl(dimensionControlsVos, entity.getBudgetItemCode());
            log.error("\u9884\u7b97\u6eda\u52a8\u7ba1\u63a7\u914d\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)dimensionControlsVo));
            if (ObjectUtils.isEmpty((Object)dimensionControlsVo)) {
                return;
            }
            if (BooleanEnum.TRUE.getCapital().equals(dimensionControlsVo.getIfRolling())) {
                LocalDate lastLocalDate = currMonthBudgetLocalDate.minusMonths(1L);
                String lastYearMonth = lastLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
                MonthBudgetEntity lastMonthBudget = this.monthBudgetRepository.findByYearMonthAndYearBudgetCode(lastYearMonth, (String)yearBudgetCode);
                if (ObjectUtils.isEmpty((Object)((Object)lastMonthBudget))) {
                    return;
                }
                boolean lock = true;
                ArrayList lockKeys = Lists.newArrayList((Object[])new String[]{entity.getMonthBudgetCode(), lastMonthBudget.getMonthBudgetCode()});
                try {
                    lock = this.monthBudgetLockService.lock((List)lockKeys, TimeUnit.SECONDS, 5);
                    if (lock) {
                        this.calRolling(entity.getId(), lastMonthBudget.getId(), dimensionControlsVo.getRollingType());
                    }
                }
                finally {
                    if (lock) {
                        this.monthBudgetLockService.unLock((List)lockKeys);
                    }
                }
            }
        }));
    }

    @Transactional(rollbackFor={Exception.class})
    public void calRolling(String currId, String lastId, String rollingType) {
        this.monthBudgetHelper.calRolling(currId, lastId, rollingType);
    }

    public void calPlanReplay(String id, Map<String, BudgetItemVo> budgetItemVoMap, String planFlag) {
        MonthBudgetEntity monthBudgetEntity = (MonthBudgetEntity)((Object)this.monthBudgetRepository.getById((Serializable)((Object)id)));
        BudgetItemVo budgetItemVo = budgetItemVoMap.get(monthBudgetEntity.getBudgetItemCode());
        BudgetItemControlConditionVo conditionVo = this.monthBudgetHelper.getBudgetItemControlCondition(monthBudgetEntity, budgetItemVoMap);
        log.error("\u83b7\u53d6\u7ba1\u63a7\u6761\u4ef6\uff1a{}", (Object)JSONObject.toJSONString((Object)conditionVo));
        if (ObjectUtils.isEmpty((Object)conditionVo)) {
            monthBudgetEntity.setBudgetCalCode("");
            monthBudgetEntity.setComputedResult("\u672a\u5339\u914d\u5230\u7ba1\u63a7\u7c7b\u578b");
            this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
            return;
        }
        MonthBudgetVo monthBudgetVo = (MonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        BudgetCalConfigVo budgetCalConfigVo = this.monthBudgetHelper.findMonthBudgetCalConfigByDto(monthBudgetVo, conditionVo.getControlTypeCode());
        log.error("\u83b7\u53d6\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)budgetCalConfigVo));
        if (ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            monthBudgetEntity.setBudgetCalCode("");
            this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
            return;
        }
        monthBudgetEntity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
        List<Object> salesPlanVos = new ArrayList();
        BudgetCalConfigDataVo calConfigDataVo = this.monthBudgetHelper.findMonthBudgetCalConfigData(budgetCalConfigVo, planFlag);
        log.error("\u83b7\u53d6\u8ba1\u7b97\u914d\u7f6e\u6570\u636e\u914d\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)calConfigDataVo));
        if (ObjectUtils.isEmpty((Object)calConfigDataVo)) {
            monthBudgetEntity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
            this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
            return;
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetEntity.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            salesPlanVos = this.listSalesPlan(budgetCalConfigVo, monthBudgetEntity);
            log.error("\u9500\u552e\u8ba1\u5212\u6570\u636e\u6761\u6570={}\uff0c\u603b\u91d1\u989d={}", (Object)salesPlanVos.size(), (Object)salesPlanVos.stream().map(SalesPlanVo::getDiscountRestoreAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            salesPlanVos = this.listVerticalSalesPlan(budgetCalConfigVo, monthBudgetEntity);
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetEntity.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            this.buildData(budgetItemVoMap, calConfigDataVo, monthBudgetEntity, salesPlanVos, planFlag, budgetCalConfigVo);
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            this.buildVerticalData(budgetItemVoMap, calConfigDataVo, monthBudgetEntity, salesPlanVos, planFlag, budgetCalConfigVo);
        }
    }

    private List<SalesPlanVo> listVerticalSalesPlan(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        SalesPlanDto salesPlanDto = (SalesPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getTerminalList())) {
            List terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        String currYearMonth = DateUtil.dateToStr((SimpleDateFormat)new SimpleDateFormat("yyyy-MM"));
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getProductList())) {
            List productCodeList = budgetCalConfigVo.getProductList().stream().filter(o -> !org.springframework.util.StringUtils.hasText((String)o.getFilYearMonth()) || org.springframework.util.StringUtils.hasText((String)o.getFilYearMonth()) && currYearMonth.equals(o.getFilYearMonth())).map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeProductCodeList(productCodeList);
        }
        return this.salesPlanService.listByConditions(salesPlanDto);
    }

    private List<SalesPlanVo> listSalesPlan(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        List budgetItemList;
        SalesPlanDto salesPlanDto = (SalesPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, SalesPlanDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getCustomerList())) {
            List customerCodeList = budgetCalConfigVo.getCustomerList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getTerminalList())) {
            List terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getProductList())) {
            List productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPlanDto.setExcludeProductCodeList(productCodeList);
        }
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (StringUtils.isEmpty((CharSequence)monthBudgetEntity.getSalesOrgCode()) && StringUtils.isEmpty((CharSequence)monthBudgetEntity.getOrgCode())) {
                return Lists.newArrayList();
            }
            String salesOrgCode = null;
            if (!StringUtils.isEmpty((CharSequence)monthBudgetEntity.getSalesOrgCode())) {
                salesOrgCode = monthBudgetEntity.getSalesOrgCode();
            } else if (!StringUtils.isEmpty((CharSequence)monthBudgetEntity.getOrgCode())) {
                OrgVo byOrgCode = this.orgVoService.findByOrgCode(monthBudgetEntity.getOrgCode());
                salesOrgCode = byOrgCode.getSalesOrgCode();
            }
            if (StringUtils.isEmpty((CharSequence)salesOrgCode)) {
                return Lists.newArrayList();
            }
            List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCode(salesOrgCode);
            if (CollectionUtils.isEmpty((Collection)salesOrgVos)) {
                return Lists.newArrayList();
            }
            List saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getErpCode).collect(Collectors.toList());
            saleOrgCodeList.add(salesOrgCode);
            List customerVoList = this.customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty((Collection)customerVoList)) {
                return Lists.newArrayList();
            }
            List customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)salesPlanDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(salesPlanDto.getExcludeCustomerCodeList());
            }
            salesPlanDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getSalesOrgList())) {
                return Lists.newArrayList();
            }
            List saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream().map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toList());
            List customerVoList = this.customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty((Collection)customerVoList)) {
                return Lists.newArrayList();
            }
            List customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)salesPlanDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(salesPlanDto.getExcludeCustomerCodeList());
            }
            salesPlanDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUR_CUSTOMER.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (!CollectionUtils.isEmpty((Collection)salesPlanDto.getExcludeCustomerCodeList())) {
                salesPlanDto.getExcludeCustomerCodeList().remove(monthBudgetEntity.getCustomerCode());
            }
            salesPlanDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
        }
        String controlType = budgetCalConfigVo.getControlType();
        if ((BudgetControlTypeEnum.INTENSITY.getCode().equals(controlType) || BudgetControlTypeEnum.RATIO.getCode().equals(controlType)) && !CollectionUtils.isEmpty((Collection)(budgetItemList = budgetCalConfigVo.getBudgetItemList()))) {
            HashSet productCodes = Sets.newHashSet();
            budgetItemList.stream().filter(o -> o.getDataCode().equals(monthBudgetEntity.getBudgetItemCode())).forEach(o -> {
                List scopeProducts = o.getScopeProducts();
                if (!CollectionUtils.isEmpty((Collection)scopeProducts)) {
                    scopeProducts.forEach(product -> productCodes.add(product.getProductCode()));
                }
            });
            salesPlanDto.setSalesProductCodeList((List)Lists.newArrayList((Iterable)productCodes));
            if (!CollectionUtils.isEmpty((Collection)productCodes)) {
                salesPlanDto.setExcludeProductCodeList(null);
            }
        }
        return this.salesPlanService.listByConditions(salesPlanDto);
    }

    private void buildVerticalData(Map<String, BudgetItemVo> finalBudgetItemVoMap, BudgetCalConfigDataVo calConfigDataVo, MonthBudgetEntity monthBudgetEntity, List<SalesPlanVo> salesPlanVos, String planFlag, BudgetCalConfigVo budgetCalConfigVo) {
        AtomicReference<BigDecimal> reduce = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> productRatioreduce = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        BudgetItemControlConditionVo conditionVo = this.monthBudgetHelper.getBudgetItemControlCondition(monthBudgetEntity, finalBudgetItemVoMap);
        List productRatios = budgetCalConfigVo.getProductRatios();
        HashMap<String, BudgetCalConfigProductRatioVo> productRatioVoMap = new HashMap<String, BudgetCalConfigProductRatioVo>();
        if (!CollectionUtils.isEmpty((Collection)productRatios)) {
            productRatioVoMap.putAll(productRatios.stream().collect(Collectors.toMap(BudgetCalConfigProductRatioVo::getProductCode, e -> e)));
        }
        AtomicReference<BigDecimal> reduceRatio = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        String amountTypeCode = calConfigDataVo.getAmountTypeCode();
        if (!CollectionUtils.isEmpty(salesPlanVos)) {
            salesPlanVos.forEach(salesPlanVo -> {
                BigDecimal productRatio;
                BigDecimal amount;
                String productCode = salesPlanVo.getProductCode();
                BudgetCalConfigProductRatioVo budgetCalConfigProductRatioVo = (BudgetCalConfigProductRatioVo)productRatioVoMap.get(productCode);
                if (SalesPlanAmountTypeEnum.PLAN_AMOUNT.getCode().equals(amountTypeCode)) {
                    amount = Optional.ofNullable(salesPlanVo.getPlanAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add((BigDecimal)reduce.get()));
                    if (!ObjectUtils.isEmpty((Object)budgetCalConfigProductRatioVo)) {
                        productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add((BigDecimal)reduceRatio.get()));
                    }
                }
                if (SalesPlanAmountTypeEnum.DISCOUNT_PLAN_AMOUNT.getCode().equals(amountTypeCode)) {
                    amount = Optional.ofNullable(salesPlanVo.getDiscountPlanAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add((BigDecimal)reduce.get()));
                    if (!ObjectUtils.isEmpty((Object)budgetCalConfigProductRatioVo)) {
                        productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add((BigDecimal)reduceRatio.get()));
                    }
                }
                if (SalesPlanAmountTypeEnum.RESTORE_AMOUNT.getCode().equals(amountTypeCode)) {
                    amount = Optional.ofNullable(salesPlanVo.getRestoreAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add((BigDecimal)reduce.get()));
                    if (!ObjectUtils.isEmpty((Object)budgetCalConfigProductRatioVo)) {
                        productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add((BigDecimal)reduceRatio.get()));
                    }
                }
                if (SalesPlanAmountTypeEnum.DISCOUNT_RESTORE_AMOUNT.getCode().equals(amountTypeCode)) {
                    amount = Optional.ofNullable(salesPlanVo.getDiscountRestoreAmount()).orElse(BigDecimal.ZERO);
                    reduce.set(amount.add((BigDecimal)reduce.get()));
                    if (!ObjectUtils.isEmpty((Object)budgetCalConfigProductRatioVo)) {
                        productRatio = Optional.ofNullable(budgetCalConfigProductRatioVo.getChargedRatio()).orElse(BigDecimal.ONE);
                        reduceRatio.set(amount.multiply(productRatio).add((BigDecimal)reduceRatio.get()));
                    }
                }
                if (SalesPlanAmountTypeEnum.DELIVERY_MULTIPLY_PRICE.getCode().equals(amountTypeCode)) {
                    // empty if block
                }
            });
        }
        BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
        if (finalBudgetItemVoMap.containsKey(monthBudgetEntity.getBudgetItemCode())) {
            if (BudgetControlTypeEnum.AMOUNT.getCode().equals(conditionVo.getControlTypeCode())) {
                monthBudgetEntity.setFirstReplyAmount(monthBudgetEntity.getInitResolveAmount());
                monthBudgetEntity.setCalAmount(reduce.get());
                monthBudgetEntity.setFirstReplyResolveDiffAmount(Optional.ofNullable(monthBudgetEntity.getFirstReplyAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(monthBudgetEntity.getInitResolveAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalance(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmount(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            } else if (BudgetControlTypeEnum.RATIO.getCode().equals(conditionVo.getControlTypeCode()) && monthBudgetEntity.getBudgetTotalPoint() != null) {
                if (!CollectionUtils.isEmpty((Collection)productRatios)) {
                    monthBudgetEntity.setFirstReplyAmount(reduceRatio.get());
                } else {
                    BigDecimal budgetTotalPoint = monthBudgetEntity.getBudgetTotalPoint().divide(new BigDecimal(100), 6, RoundingMode.HALF_UP);
                    monthBudgetEntity.setFirstReplyAmount(reduce.get().multiply(budgetTotalPoint));
                }
                monthBudgetEntity.setCalAmount(reduce.get());
                monthBudgetEntity.setFirstReplyResolveDiffAmount(Optional.ofNullable(monthBudgetEntity.getFirstReplyAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(monthBudgetEntity.getInitResolveAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalance(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                monthBudgetEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmount(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                if (BigDecimal.ZERO.compareTo(monthBudgetEntity.getCalAmount()) != 0) {
                    monthBudgetEntity.setAvailableRatio(monthBudgetEntity.getAccumulatedAvailableBalance().divide(monthBudgetEntity.getCalAmount(), 4, RoundingMode.HALF_UP));
                }
            }
        }
        monthBudgetEntity.setComputedResult("\u5b8c\u6210");
        this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
        MonthBudgetDetailDto monthBudgetDetailDto = new MonthBudgetDetailDto();
        monthBudgetDetailDto = BooleanEnum.TRUE.getCapital().equals(planFlag) ? this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), beforeAmount, BudgetOperationTypeEnum.PLAN.getCode(), null) : this.buildDetail(monthBudgetEntity, monthBudgetEntity.getFirstReplyResolveDiffAmount(), beforeAmount, BudgetOperationTypeEnum.REPLAY.getCode(), null);
        this.monthBudgetDetailService.create(monthBudgetDetailDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void calActualReplayDiff(List<String> ids) {
        List budgetItemVos;
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<MonthBudgetEntity> monthBudgetList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        List monthBudgetCodeList = monthBudgetList.stream().map(MonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
        Map<String, List<MonthBudgetEntity>> monthMap = monthBudgetList.stream().collect(Collectors.groupingBy(MonthBudgetEntity::getYearBudgetCode));
        Set budgetItemCodeSet = monthBudgetList.stream().map(MonthBudgetEntity::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Object, Object> budgetItemVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(budgetItemCodeSet) && !CollectionUtils.isEmpty((Collection)(budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemCodeSet))))) {
            budgetItemVoMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity(), (oldVo, newVo) -> newVo));
        }
        Set yearBudgetSet = monthBudgetList.stream().map(MonthBudgetEntity::getYearBudgetCode).collect(Collectors.toSet());
        Set yearMonthSet = monthBudgetList.stream().map(entity -> entity.getYearMonthLy().split("-")[0] + "-" + "01").collect(Collectors.toSet());
        List<MonthBudgetEntity> januaryList = this.getByYearMonthCodeAndMonth(Lists.newArrayList(yearBudgetSet), new ArrayList<String>(yearMonthSet));
        Map januaryMap = januaryList.stream().collect(Collectors.toMap(MonthBudgetEntity::getYearBudgetCode, Function.identity()));
        List januaryCodeList = januaryList.stream().map(MonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
        monthBudgetCodeList.addAll(januaryCodeList);
        Map<Object, Object> finalBudgetItemVoMap = budgetItemVoMap;
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
        if (CollectionUtils.isEmpty((Collection)dimensionControlsVos)) {
            return;
        }
        Map<String, List<DimensionControlsVo>> controlMap = dimensionControlsVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getMarketOrganization()));
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lock, (String)"\u5b9e\u9500\u91cf\u4e0e\u56de\u590d\u91cf\u5dee\u989d\u8ba1\u7b97\u5931\u8d25\uff0c\u5f53\u524d\u9884\u7b97\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            monthMap.forEach((yearBudgetCode, subMonthBudgetList) -> {
                List<SalesPerformanceSumVo> salesPerformanceSumVoList;
                if (!finalBudgetItemVoMap.containsKey(((MonthBudgetEntity)((Object)((Object)subMonthBudgetList.get(0)))).getBudgetItemCode())) {
                    return;
                }
                BudgetItemVo budgetItemVo = (BudgetItemVo)finalBudgetItemVoMap.get(((MonthBudgetEntity)((Object)((Object)subMonthBudgetList.get(0)))).getBudgetItemCode());
                List conditionVos = budgetItemVo.getControlConditionDtoList().stream().filter(controlVo -> ((MonthBudgetEntity)((Object)((Object)((Object)subMonthBudgetList.get(0))))).getBusinessFormatCode().equals(controlVo.getBusinessFormatCode()) && ((MonthBudgetEntity)((Object)((Object)((Object)subMonthBudgetList.get(0))))).getBusinessUnitCode().equals(controlVo.getBusinessUnitCode())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(conditionVos)) {
                    return;
                }
                String controlType = ((BudgetItemControlConditionVo)conditionVos.get(0)).getControlTypeCode();
                if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlType)) {
                    return;
                }
                BudgetCalConfigDto budgetCalConfigDto = (BudgetCalConfigDto)this.nebulaToolkitService.copyObjectByWhiteList(subMonthBudgetList.get(0), BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                budgetCalConfigDto.setBudgetTypeCode(BudgetTypeEnum.MONTH_BUDGET.getCode());
                budgetCalConfigDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                List budgetCalConfigVos = this.budgetCalConfigService.listByConditions(budgetCalConfigDto);
                if (CollectionUtils.isEmpty((Collection)budgetCalConfigVos)) {
                    return;
                }
                ArrayList dataVoList = new ArrayList();
                budgetCalConfigVos.forEach(budgetCalConfigVo -> dataVoList.addAll(budgetCalConfigVo.getDataList().stream().filter(budgetCalConfigDataVo -> CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode().equals(budgetCalConfigDataVo.getCalDataFromCode())).collect(Collectors.toList())));
                if (CollectionUtils.isEmpty(dataVoList)) {
                    return;
                }
                BudgetCalConfigDataVo budgetCalConfigDataVo = (BudgetCalConfigDataVo)dataVoList.get(0);
                BudgetCalConfigVo budgetCalConfigVo2 = (BudgetCalConfigVo)budgetCalConfigVos.stream().filter(vo -> vo.getBudgetCalCode().equals(budgetCalConfigDataVo.getBudgetCalCode())).collect(Collectors.toList()).get(0);
                Map<String, List<MainOnedaySalesDataVo>> oneDayMap = new HashMap<String, List<MainOnedaySalesDataVo>>();
                Map<String, Object> salesPerformanceSumMap = new HashMap<String, SalesPerformanceSumVo>();
                if (BusinessUnitEnum.isDefaultBusinessUnit((String)((MonthBudgetEntity)((Object)((Object)subMonthBudgetList.get(0)))).getBusinessUnitCode())) {
                    List<MainOnedaySalesDataVo> mainOnedaySalesDataVoList = this.listMainOneDay(budgetCalConfigVo2, (MonthBudgetEntity)((Object)((Object)subMonthBudgetList.get(0))));
                    if (!CollectionUtils.isEmpty(mainOnedaySalesDataVoList)) {
                        List<MainOnedaySalesDataVo> collect = mainOnedaySalesDataVoList.stream().filter(vo -> !StringUtils.isEmpty((CharSequence)vo.getYearMonthDay())).collect(Collectors.toList());
                        collect.forEach(mainOnedaySalesDataVo -> {
                            String[] split = mainOnedaySalesDataVo.getYearMonthDay().split("-");
                            mainOnedaySalesDataVo.setYearMonthDay(split[0] + "-" + split[1]);
                        });
                        oneDayMap = collect.stream().filter(vo -> vo.getDiscountBehindSaleAmount() != null).collect(Collectors.groupingBy(MainOnedaySalesDataVo::getYearMonthDay));
                    }
                } else if (BusinessUnitEnum.VERTICAL.getCode().equals(((MonthBudgetEntity)((Object)((Object)subMonthBudgetList.get(0)))).getBusinessUnitCode()) && !CollectionUtils.isEmpty(salesPerformanceSumVoList = this.listPerformance(budgetCalConfigVo2, (MonthBudgetEntity)((Object)((Object)subMonthBudgetList.get(0)))))) {
                    salesPerformanceSumVoList.forEach(salesPerformanceSumVo -> {
                        if (!StringUtils.isEmpty((CharSequence)salesPerformanceSumVo.getSalesMonth())) {
                            Date yyyyMM = DateUtil.parse((String)salesPerformanceSumVo.getSalesMonth(), (String)"yyyyMM");
                            String format = DateUtil.format((Date)yyyyMM, (String)"yyyy-MM");
                            salesPerformanceSumVo.setSalesMonth(format);
                        }
                    });
                    salesPerformanceSumMap = salesPerformanceSumVoList.stream().collect(Collectors.toMap(SalesPerformanceSumVo::getSalesMonth, Function.identity()));
                }
                HashMap<String, List<MainOnedaySalesDataVo>> finalOneDayMap = oneDayMap;
                HashMap<String, SalesPerformanceSumVo> finalSalesPerformanceSumMap = salesPerformanceSumMap;
                MonthBudgetEntity januaryEntity = (MonthBudgetEntity)((Object)((Object)januaryMap.get(yearBudgetCode)));
                this.refreshActualSales((List<MonthBudgetEntity>)subMonthBudgetList, budgetCalConfigDataVo, (Map<String, List<MainOnedaySalesDataVo>>)finalOneDayMap, (Map<String, SalesPerformanceSumVo>)finalSalesPerformanceSumMap, controlMap, januaryEntity);
            });
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    private void refreshActualSales(List<MonthBudgetEntity> subMonthBudgetList, BudgetCalConfigDataVo budgetCalConfigDataVo, Map<String, List<MainOnedaySalesDataVo>> finalOneDayMap, Map<String, SalesPerformanceSumVo> finalSalesPerformanceSumMap, Map<String, List<DimensionControlsVo>> controlMap, MonthBudgetEntity januaryEntity) {
        AtomicReference<String> rollingType = new AtomicReference<String>("");
        AtomicReference<String> isRolling = new AtomicReference<String>(BooleanEnum.FALSE.getCapital());
        AtomicReference<BigDecimal> januaryActualSalesReplayDiffAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        subMonthBudgetList.forEach(monthBudgetEntity -> {
            BigDecimal actualSales = this.buildActualSales((MonthBudgetEntity)((Object)monthBudgetEntity), budgetCalConfigDataVo, finalOneDayMap, finalSalesPerformanceSumMap);
            String controlKey = monthBudgetEntity.getBusinessFormatCode() + monthBudgetEntity.getBusinessUnitCode() + monthBudgetEntity.getSalesOrgCode();
            if (controlMap.containsKey(controlKey)) {
                List dimensionControlsList = (List)controlMap.get(controlKey);
                dimensionControlsList.forEach(dimensionControlsVo -> {
                    if (!CollectionUtils.isEmpty((Collection)dimensionControlsVo.getBudgetItemCodeList()) && dimensionControlsVo.getBudgetItemCodeList().contains(monthBudgetEntity.getBudgetItemCode())) {
                        rollingType.set(dimensionControlsVo.getRollingType());
                        isRolling.set(dimensionControlsVo.getIfRolling());
                    }
                });
            }
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            BigDecimal lastAdjustAmount = Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO);
            BigDecimal lastActualSalesReplayDiffAmount = Optional.ofNullable(monthBudgetEntity.getLastActualSalesReplayDiffAmount()).orElse(BigDecimal.ZERO);
            BigDecimal calAmount = monthBudgetEntity.getCalAmount();
            BigDecimal curActualSalesReplayDiffAmount = actualSales.subtract(Optional.ofNullable(calAmount).orElse(BigDecimal.ZERO)).multiply(Optional.ofNullable(monthBudgetEntity.getBudgetTotalPoint()).orElse(BigDecimal.ZERO)).divide(new BigDecimal(100), RoundingMode.HALF_UP);
            BigDecimal curAdjustAmount = lastAdjustAmount.subtract(lastActualSalesReplayDiffAmount).add(curActualSalesReplayDiffAmount);
            BigDecimal curAccumulatedAvailableBalance = Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(lastActualSalesReplayDiffAmount).add(curActualSalesReplayDiffAmount);
            if (BooleanEnum.TRUE.getCapital().equals(isRolling.get())) {
                MonthBudgetDetailDto monthBudgetDetailDto;
                if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType.get())) {
                    monthBudgetEntity.setAdjustAmount(curAdjustAmount);
                    monthBudgetEntity.setLastActualSalesReplayDiffAmount(curActualSalesReplayDiffAmount);
                    monthBudgetEntity.setAccumulatedAvailableBalance(curAccumulatedAvailableBalance);
                    monthBudgetDetailDto = this.buildDetail((MonthBudgetEntity)((Object)monthBudgetEntity), curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount), beforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
                if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType.get()) && BigDecimal.ZERO.compareTo(curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount)) < 0) {
                    monthBudgetEntity.setAdjustAmount(curAdjustAmount);
                    monthBudgetEntity.setLastActualSalesReplayDiffAmount(curActualSalesReplayDiffAmount);
                    monthBudgetEntity.setAccumulatedAvailableBalance(curAccumulatedAvailableBalance);
                    monthBudgetDetailDto = this.buildDetail((MonthBudgetEntity)((Object)monthBudgetEntity), curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount), beforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
                if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType.get()) && BigDecimal.ZERO.compareTo(curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount)) > 0) {
                    monthBudgetEntity.setAdjustAmount(curAdjustAmount);
                    monthBudgetEntity.setLastActualSalesReplayDiffAmount(curActualSalesReplayDiffAmount);
                    monthBudgetEntity.setAccumulatedAvailableBalance(curAccumulatedAvailableBalance);
                    monthBudgetDetailDto = this.buildDetail((MonthBudgetEntity)((Object)monthBudgetEntity), curActualSalesReplayDiffAmount.subtract(lastActualSalesReplayDiffAmount), beforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
                    this.monthBudgetDetailService.create(monthBudgetDetailDto);
                }
            } else {
                januaryActualSalesReplayDiffAmount.set(((BigDecimal)januaryActualSalesReplayDiffAmount.get()).add(curActualSalesReplayDiffAmount));
            }
        });
        if (!BooleanEnum.TRUE.getCapital().equals(isRolling.get())) {
            BigDecimal lastActualSalesReplayDiffAmount = Optional.ofNullable(januaryEntity.getLastActualSalesReplayDiffAmount()).orElse(BigDecimal.ZERO);
            januaryEntity.setAdjustAmount(Optional.ofNullable(januaryEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(lastActualSalesReplayDiffAmount).add(januaryActualSalesReplayDiffAmount.get()));
            januaryEntity.setLastActualSalesReplayDiffAmount(januaryActualSalesReplayDiffAmount.get());
            BigDecimal januaryBeforeAmount = januaryEntity.getAccumulatedAvailableBalance();
            januaryEntity.setAccumulatedAvailableBalance(januaryEntity.getAccumulatedAvailableBalance().subtract(lastActualSalesReplayDiffAmount).add(januaryActualSalesReplayDiffAmount.get()));
            this.monthBudgetRepository.updateById((Object)januaryEntity);
            this.buildDetail(januaryEntity, januaryActualSalesReplayDiffAmount.get().subtract(lastActualSalesReplayDiffAmount), januaryBeforeAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), null);
        } else {
            this.monthBudgetRepository.updateBatchById(subMonthBudgetList);
        }
    }

    private List<SalesPerformanceSumVo> listPerformance(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        SalesPerformanceDto salesPerformanceDto = new SalesPerformanceDto();
        salesPerformanceDto.setSalesDate(monthBudgetEntity.getYearMonthLy().split("-")[0]);
        salesPerformanceDto.setSalesMonth(monthBudgetEntity.getYearMonthLy().replace("-", ""));
        salesPerformanceDto.setRegion(monthBudgetEntity.getRegionCode());
        salesPerformanceDto.setSalesOrg(monthBudgetEntity.getSalesOrgCode());
        salesPerformanceDto.setRetailer(monthBudgetEntity.getSystemCode());
        salesPerformanceDto.setShipToparty(monthBudgetEntity.getTerminalCode());
        salesPerformanceDto.setBrand(monthBudgetEntity.getProductBrandCode());
        salesPerformanceDto.setCategoryCode(monthBudgetEntity.getProductItemCode());
        salesPerformanceDto.setMaterialCode(monthBudgetEntity.getProductCode());
        if (StringUtils.isEmpty((CharSequence)salesPerformanceDto.getMaterialCode()) && !CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getProductList())) {
            List productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesPerformanceDto.setExcludeProductCodeList(productCodeList);
        }
        return this.salesPerformanceVoService.listYearByConditions(salesPerformanceDto);
    }

    private BigDecimal buildActualSales(MonthBudgetEntity monthBudgetEntity, BudgetCalConfigDataVo budgetCalConfigDataVo, Map<String, List<MainOnedaySalesDataVo>> finalOneDayMap, Map<String, SalesPerformanceSumVo> salesPerformanceSumMap) {
        BigDecimal actualSales = BigDecimal.ZERO;
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetEntity.getBusinessUnitCode())) {
            if (ActualSalesAmountTypeEnum.DISCOUNT_BEHIND_SALE_AMOUNT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode()) && finalOneDayMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                actualSales = finalOneDayMap.get(monthBudgetEntity.getYearMonthLy()).stream().map(MainOnedaySalesDataVo::getDiscountBehindSaleAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (ActualSalesAmountTypeEnum.ORDER_RULE_AMT_IN_REBATE.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode()) && finalOneDayMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                actualSales = finalOneDayMap.get(monthBudgetEntity.getYearMonthLy()).stream().map(MainOnedaySalesDataVo::getDiscountFrontSaleAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (ActualSalesAmountTypeEnum.DISCOUNT_BEHIND_TAX_SALE_AMOUNT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode()) && finalOneDayMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                actualSales = finalOneDayMap.get(monthBudgetEntity.getYearMonthLy()).stream().map(MainOnedaySalesDataVo::getDiscountBehindTaxSaleAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
            if (ActualSalesAmountTypeEnum.DISCOUNT_BEHIND_SALE_AMOUNT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode()) && salesPerformanceSumMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                actualSales = salesPerformanceSumMap.get(monthBudgetEntity.getYearMonthLy()).getOrderRuleAmtInRebateIncM();
            }
            if (ActualSalesAmountTypeEnum.WAREHS_OUT_DISCOUNT_AMT.getCode().equals(budgetCalConfigDataVo.getAmountTypeCode()) && salesPerformanceSumMap.containsKey(monthBudgetEntity.getYearMonthLy())) {
                actualSales = salesPerformanceSumMap.get(monthBudgetEntity.getYearMonthLy()).getWarehsOutDiscountAmtIncM();
            }
        }
        return actualSales;
    }

    private List<MainOnedaySalesDataVo> listMainOneDay(BudgetCalConfigVo budgetCalConfigVo, MonthBudgetEntity monthBudgetEntity) {
        MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
        mainOnedaySalesDataDto.setYearMonthDay(monthBudgetEntity.getYearMonthLy().split("-")[0]);
        mainOnedaySalesDataDto.setBusinessFormatCode(monthBudgetEntity.getBusinessFormatCode());
        mainOnedaySalesDataDto.setBusinessUnitCode(monthBudgetEntity.getBusinessUnitCode());
        mainOnedaySalesDataDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
        mainOnedaySalesDataDto.setProductBrandCode(monthBudgetEntity.getProductBrandCode());
        mainOnedaySalesDataDto.setProductCategoryCode(monthBudgetEntity.getProductCategoryCode());
        mainOnedaySalesDataDto.setProductItemCode(monthBudgetEntity.getProductItemCode());
        mainOnedaySalesDataDto.setTerminalCode(monthBudgetEntity.getTerminalCode());
        mainOnedaySalesDataDto.setSystemCode(monthBudgetEntity.getSystemCode());
        mainOnedaySalesDataDto.setSalesOrgRegionCode(monthBudgetEntity.getSalesOrgCode());
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getCustomerList())) {
            List customerCodeList = budgetCalConfigVo.getCustomerList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            mainOnedaySalesDataDto.setExcludeCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getTerminalList())) {
            List terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            mainOnedaySalesDataDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getProductList())) {
            List productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            mainOnedaySalesDataDto.setExcludeProductCodeList(productCodeList);
        }
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (StringUtils.isEmpty((CharSequence)monthBudgetEntity.getSalesOrgCode()) && StringUtils.isEmpty((CharSequence)monthBudgetEntity.getOrgCode())) {
                return Lists.newArrayList();
            }
            String salesOrgCode = null;
            if (!StringUtils.isEmpty((CharSequence)monthBudgetEntity.getSalesOrgCode())) {
                salesOrgCode = monthBudgetEntity.getSalesOrgCode();
            } else if (!StringUtils.isEmpty((CharSequence)monthBudgetEntity.getOrgCode())) {
                OrgVo byOrgCode = this.orgVoService.findByOrgCode(monthBudgetEntity.getOrgCode());
                salesOrgCode = byOrgCode.getSalesOrgCode();
            }
            if (StringUtils.isEmpty((CharSequence)salesOrgCode)) {
                return Lists.newArrayList();
            }
            List salesOrgVos = this.salesOrgVoService.findAllChildrenBySalesOrgCode(salesOrgCode);
            if (CollectionUtils.isEmpty((Collection)salesOrgVos)) {
                return Lists.newArrayList();
            }
            List saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            List customerVoList = this.customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty((Collection)customerVoList)) {
                return Lists.newArrayList();
            }
            List customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)mainOnedaySalesDataDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(mainOnedaySalesDataDto.getExcludeCustomerCodeList());
            }
            mainOnedaySalesDataDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            if (CollectionUtils.isEmpty((Collection)budgetCalConfigVo.getSalesOrgList())) {
                return Lists.newArrayList();
            }
            List saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream().map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toList());
            List customerVoList = this.customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty((Collection)customerVoList)) {
                return Lists.newArrayList();
            }
            List customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)mainOnedaySalesDataDto.getExcludeCustomerCodeList())) {
                customerCodeList.removeAll(mainOnedaySalesDataDto.getExcludeCustomerCodeList());
            }
            mainOnedaySalesDataDto.setCustomerCodeList(customerCodeList);
        }
        return this.mainOnedaySaleDataService.listMainOnedaySalesData(mainOnedaySalesDataDto);
    }

    private List<MonthBudgetEntity> getByYearMonthCodeAndMonth(List<String> yearBudgetList, List<String> yearMonth) {
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return null;
        }
        return this.monthBudgetRepository.getByYearMonthCodeAndMonth(yearBudgetList, yearMonth);
    }

    public List<MonthBudgetVo> listByConditions(MonthBudgetDto monthBudgetDto) {
        Validate.notNull((Object)monthBudgetDto, (String)"\u67e5\u8be2\u6708\u5ea6\u9884\u7b97\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MonthBudgetEntity> monthBudgetEntities = this.monthBudgetRepository.listByConditions(monthBudgetDto);
        if (CollectionUtils.isEmpty(monthBudgetEntities)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntities, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Pageable pageable, MonthBudgetExamineCircularQueryDto dto) {
        if (Objects.isNull(dto)) {
            return new Page();
        }
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode())) {
            return new Page();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.subComMonthBudgetService.findExamineCircularByConditions(page, dto);
        }
        return this.monthBudgetMapper.findExamineCircularByConditions((Page<MonthBudgetExamineCircularQueryVo>)page, dto);
    }

    public Page<MonthBudgetBusinessPolicyQueryVo> findBusinessPolicyByConditions(Pageable pageable, MonthBudgetBusinessPolicyQueryDto dto) {
        org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new MonthBudgetBusinessPolicyQueryDto();
        }
        ArrayList budgetItemCodeList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)dto.getActivityTypeCode())) {
            ActivityTypeVo activityTypeVo = this.activityTypeService.getActivityTypeByActivityTypeCode(dto.getActivityTypeCode());
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)activityTypeVo)) {
                return new Page();
            }
            List activityTypeRelationDtoList = activityTypeVo.getActivityTypeRelationDtoList();
            if (CollectionUtils.isEmpty((Collection)activityTypeRelationDtoList)) {
                return new Page();
            }
            activityTypeRelationDtoList.forEach(activityTypeRelationDto -> {
                if (CollectionUtils.isEmpty((Collection)activityTypeRelationDto.getActivityTypeBudgetDtoList())) {
                    return;
                }
                List collect = activityTypeRelationDto.getActivityTypeBudgetDtoList().stream().map(ActivityTypeBudgetDto::getBudgetProjectCode).collect(Collectors.toList());
                budgetItemCodeList.addAll(collect);
            });
        }
        MonthBudgetDto monthBudgetDto = (MonthBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        monthBudgetDto.setBudgetItemCodeList(budgetItemCodeList);
        Page<MonthBudgetVo> conditions = this.findByConditions(pageable, monthBudgetDto);
        if (CollectionUtils.isEmpty((Collection)conditions.getRecords())) {
            return new Page();
        }
        List records = conditions.getRecords();
        List result = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, MonthBudgetVo.class, MonthBudgetBusinessPolicyQueryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Page pageResult = new Page();
        pageResult.setTotal(conditions.getTotal());
        pageResult.setCurrent(conditions.getCurrent());
        pageResult.setSize(conditions.getSize());
        pageResult.setRecords(result);
        HashSet budgetItemCodeSet = Sets.newHashSet();
        for (MonthBudgetBusinessPolicyQueryVo monthBudgetBusinessPolicyQueryVo : result) {
            if (BudgetItemLevelEnum.THIRD.getCode().equals(monthBudgetBusinessPolicyQueryVo.getBudgetItemLevelCode())) {
                budgetItemCodeSet.add(monthBudgetBusinessPolicyQueryVo.getBudgetItemCode());
                continue;
            }
            if (BudgetItemLevelEnum.SECOND.getCode().equals(monthBudgetBusinessPolicyQueryVo.getBudgetItemLevelCode())) {
                monthBudgetBusinessPolicyQueryVo.setSecondBudgetItemCode(monthBudgetBusinessPolicyQueryVo.getBudgetItemCode());
                monthBudgetBusinessPolicyQueryVo.setSecondBudgetItemName(monthBudgetBusinessPolicyQueryVo.getBudgetItemName());
                monthBudgetBusinessPolicyQueryVo.setSecondBudgetItemBalance(monthBudgetBusinessPolicyQueryVo.getAccumulatedAvailableBalance());
                monthBudgetBusinessPolicyQueryVo.setBudgetItemCode(null);
                monthBudgetBusinessPolicyQueryVo.setBudgetItemName(null);
                continue;
            }
            if (!BudgetItemLevelEnum.FIRST.getCode().equals(monthBudgetBusinessPolicyQueryVo.getBudgetItemLevelCode())) continue;
            monthBudgetBusinessPolicyQueryVo.setFirstBudgetItemCode(monthBudgetBusinessPolicyQueryVo.getBudgetItemCode());
            monthBudgetBusinessPolicyQueryVo.setFirstBudgetItemName(monthBudgetBusinessPolicyQueryVo.getBudgetItemName());
            monthBudgetBusinessPolicyQueryVo.setBudgetItemCode(null);
            monthBudgetBusinessPolicyQueryVo.setBudgetItemName(null);
        }
        List budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemCodeSet));
        if (!CollectionUtils.isEmpty((Collection)budgetItemVos)) {
            List parentBudgetItemVos;
            Map<String, String> parentMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getParentBudgetItemCode));
            Set parentCodeSet = budgetItemVos.stream().map(BudgetItemVo::getParentBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List sonBudgetItemVos = this.budgetItemService.listByParent(new ArrayList(parentCodeSet));
            if (!CollectionUtils.isEmpty((Collection)sonBudgetItemVos) && !CollectionUtils.isEmpty((Collection)(parentBudgetItemVos = this.budgetItemService.listByCodes(new ArrayList(parentCodeSet))))) {
                Map parentBudgetMap = parentBudgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
                Map<String, List<BudgetItemVo>> sonMap = sonBudgetItemVos.stream().collect(Collectors.groupingBy(BudgetItemVo::getParentBudgetItemCode));
                List thirdBudgetList = sonBudgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
                List<MonthBudgetVo> monthBudgetVoList = this.listByBudgetItemCodeList(new ArrayList<String>(thirdBudgetList));
                if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
                    result.forEach(businessPolicy -> {
                        String parentCode = (String)parentMap.get(businessPolicy.getBudgetItemCode());
                        if (!StringUtils.isEmpty((CharSequence)parentCode)) {
                            BudgetItemVo parentBudgetItemVo = (BudgetItemVo)parentBudgetMap.get(parentCode);
                            List thirdList = ((List)sonMap.get(parentCode)).stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
                            BigDecimal reduce = monthBudgetVoList.stream().filter(vo -> thirdList.contains(vo.getBudgetItemCode()) && vo.getAccumulatedAvailableBalance() != null).map(MonthBudgetVo::getAccumulatedAvailableBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
                            businessPolicy.setSecondBudgetItemCode(parentCode);
                            businessPolicy.setSecondBudgetItemName(parentBudgetItemVo.getBudgetItemName());
                            businessPolicy.setSecondBudgetItemBalance(reduce);
                        }
                    });
                }
            }
        }
        Set secondBudgetItemCodeSet = result.stream().map(MonthBudgetBusinessPolicyQueryVo::getSecondBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(secondBudgetItemCodeSet)) {
            List secondBudgetItemList = this.budgetItemService.listByCodes(new ArrayList(secondBudgetItemCodeSet));
            Map<String, String> parentBudgetMap = secondBudgetItemList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getParentBudgetItemCode));
            Set firstBudgetItemSet = secondBudgetItemList.stream().map(BudgetItemVo::getParentBudgetItemCode).collect(Collectors.toSet());
            List firstBudgetItemList = this.budgetItemService.listByCodes(new ArrayList(firstBudgetItemSet));
            Map firstBudgetItemMap = firstBudgetItemList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            result.forEach(businessPolicy -> {
                if (StringUtils.isEmpty((CharSequence)businessPolicy.getSecondBudgetItemCode())) {
                    return;
                }
                String firstBudgetItemCode = (String)parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode());
                if (StringUtils.isEmpty((CharSequence)firstBudgetItemCode)) {
                    return;
                }
                businessPolicy.setFirstBudgetItemCode(firstBudgetItemCode);
                if (firstBudgetItemMap.containsKey(firstBudgetItemCode)) {
                    businessPolicy.setFirstBudgetItemName(((BudgetItemVo)firstBudgetItemMap.get(firstBudgetItemCode)).getBudgetItemName());
                }
            });
        }
        pageResult.setRecords(result);
        return pageResult;
    }

    public List<MonthBudgetVo> listByCodes(List<String> codes) {
        return this.listByCodes(codes, null);
    }

    public List<MonthBudgetVo> listByCodes(List<String> codes, String businessUnitCode) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByCodes(codes, businessUnitCode);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<MonthBudgetBusinessPolicyQueryVo> findBusinessPolicyByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByCodes(codes);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        List monthBudgetBusinessPolicyQueryVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetBusinessPolicyQueryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Map<String, MonthBudgetControlVo> map = this.mapControlAmount(codes);
        monthBudgetBusinessPolicyQueryVos.forEach(monthBudgetBusinessPolicyQueryVo -> {
            if (map.containsKey(monthBudgetBusinessPolicyQueryVo.getMonthBudgetCode())) {
                MonthBudgetControlVo monthBudgetControlVo = (MonthBudgetControlVo)map.get(monthBudgetBusinessPolicyQueryVo.getMonthBudgetCode());
                monthBudgetBusinessPolicyQueryVo.setControlTypeCode(monthBudgetControlVo.getControlTypeCode());
                monthBudgetBusinessPolicyQueryVo.setControlRatio(monthBudgetControlVo.getControlRatio());
                monthBudgetBusinessPolicyQueryVo.setControlBalanceAmount(monthBudgetControlVo.getControlBalanceAmount());
                monthBudgetBusinessPolicyQueryVo.setControlSituation(monthBudgetControlVo.getControlSituation());
            }
        });
        Set budgetItemCodeSet = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemCodeSet));
        if (CollectionUtils.isEmpty((Collection)budgetItemVos)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        Map<String, String> parentMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getParentBudgetItemCode));
        Set parentCodeSet = budgetItemVos.stream().map(BudgetItemVo::getParentBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List sonBudgetItemVos = this.budgetItemService.listByParent(new ArrayList(parentCodeSet));
        if (CollectionUtils.isEmpty((Collection)sonBudgetItemVos)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        List parentBudgetItemVos = this.budgetItemService.listByCodes(new ArrayList(parentCodeSet));
        if (CollectionUtils.isEmpty((Collection)parentBudgetItemVos)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        Map parentBudgetMap = parentBudgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Map<String, List<BudgetItemVo>> sonMap = sonBudgetItemVos.stream().collect(Collectors.groupingBy(BudgetItemVo::getParentBudgetItemCode));
        List thirdBudgetList = sonBudgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
        List<MonthBudgetVo> monthBudgetVoList = this.listByBudgetItemCodeList(new ArrayList<String>(thirdBudgetList));
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            return monthBudgetBusinessPolicyQueryVos;
        }
        monthBudgetBusinessPolicyQueryVos.forEach(businessPolicy -> {
            String parentCode = (String)parentMap.get(businessPolicy.getBudgetItemCode());
            BudgetItemVo parentBudgetItemVo = (BudgetItemVo)parentBudgetMap.get(parentCode);
            List thirdList = ((List)sonMap.get(parentCode)).stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
            BigDecimal reduce = monthBudgetVoList.stream().filter(vo -> thirdList.contains(vo.getBudgetItemCode()) && vo.getAccumulatedAvailableBalance() != null).map(MonthBudgetVo::getAccumulatedAvailableBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
            businessPolicy.setSecondBudgetItemCode(parentCode);
            businessPolicy.setSecondBudgetItemName(parentBudgetItemVo.getBudgetItemName());
            businessPolicy.setSecondBudgetItemBalance(reduce);
        });
        Set secondBudgetItemCodeSet = monthBudgetBusinessPolicyQueryVos.stream().map(MonthBudgetBusinessPolicyQueryVo::getSecondBudgetItemCode).collect(Collectors.toSet());
        List secondBudgetItemList = this.budgetItemService.listByCodes(new ArrayList(secondBudgetItemCodeSet));
        Set firstBudgetItemSet = secondBudgetItemList.stream().map(BudgetItemVo::getParentBudgetItemCode).collect(Collectors.toSet());
        List firstBudgetItemList = this.budgetItemService.listByCodes(new ArrayList(firstBudgetItemSet));
        Map firstBudgetItemMap = firstBudgetItemList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        monthBudgetBusinessPolicyQueryVos.forEach(businessPolicy -> {
            if (!parentBudgetMap.containsKey(businessPolicy.getSecondBudgetItemCode())) {
                return;
            }
            businessPolicy.setFirstBudgetItemCode(((BudgetItemVo)parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode())).getParentBudgetItemCode());
            if (firstBudgetItemMap.containsKey(((BudgetItemVo)parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode())).getParentBudgetItemCode())) {
                businessPolicy.setFirstBudgetItemName(((BudgetItemVo)firstBudgetItemMap.get(((BudgetItemVo)parentBudgetMap.get(businessPolicy.getSecondBudgetItemCode())).getParentBudgetItemCode())).getBudgetItemName());
            }
        });
        return monthBudgetBusinessPolicyQueryVos;
    }

    public List<MonthBudgetVo> listByYearBudgetCodes(List<String> yearBudgetList) {
        if (CollectionUtils.isEmpty(yearBudgetList)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearBudgetCodes(yearBudgetList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        List monthBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.convertMonthBudgetProperty(monthBudgetVos);
        return monthBudgetVos;
    }

    public void autoPlan(String yearMonth, List<String> businessUnitCodeList) {
    }

    public List<String> listByYearMonth(String yearMonth, List<String> businessUnitCodeList) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        return monthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    public void autoPlanReplay(String yearMonth, List<String> businessUnitCodeList, String planFlag) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return;
        }
        List budgetItemCodeList = monthBudgetEntityList.stream().map(MonthBudgetEntity::getBudgetItemCode).collect(Collectors.toList());
        List budgetItemVos = this.budgetItemService.listByCodes(budgetItemCodeList);
        HashMap budgetItemVoMap = CollectionUtils.isEmpty((Collection)budgetItemVos) ? Maps.newHashMap() : budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity(), (oldVo, newVo) -> newVo));
        monthBudgetEntityList.forEach(entity -> {
            ArrayList lockKeys = Lists.newArrayList();
            lockKeys.add(entity.getMonthBudgetCode());
            boolean lock = true;
            try {
                lock = this.monthBudgetLockService.lock((List)lockKeys, TimeUnit.SECONDS, 5);
                if (lock) {
                    this.calPlanReplay(entity.getId(), budgetItemVoMap, BooleanEnum.FALSE.getCapital());
                }
            }
            finally {
                if (lock) {
                    this.monthBudgetLockService.unLock((List)lockKeys);
                }
            }
        });
    }

    public List<String> autoActualSales(String yearMonth, List<String> businessUnitCodeList) {
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return null;
        }
        return monthBudgetEntityList.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    public List<MonthBudgetVo> findCustomerGroupMonthBudget(List<MonthBudgetDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return Lists.newArrayList();
        }
        List<String> monthBudgetCodeList = dtos.stream().map(MonthBudgetDto::getMonthBudgetCode).collect(Collectors.toList());
        List<MonthBudgetVo> monthBudgetVoList = this.listByCodes(monthBudgetCodeList);
        Map monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        for (MonthBudgetDto dto : dtos) {
            MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetVoMap.get(dto.getMonthBudgetCode());
            if (monthBudgetVo == null) continue;
            dto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
            dto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
        }
        List<MonthBudgetVo> customerMonthBudget = this.monthBudgetRepository.findCustomerGroupMonthBudget(dtos);
        Map monthBudgetVoMap2 = monthBudgetVoList.stream().collect(Collectors.toMap(o -> o.getYearMonthLy() + o.getBudgetItemCode(), Function.identity()));
        for (MonthBudgetVo monthBudgetVo : customerMonthBudget) {
            MonthBudgetVo monthBudgetVo1 = (MonthBudgetVo)monthBudgetVoMap2.get(monthBudgetVo.getYearMonthLy() + monthBudgetVo.getBudgetItemCode());
            if (monthBudgetVo1 == null) continue;
            monthBudgetVo.setDepartMonthBudgetCode(monthBudgetVo1.getMonthBudgetCode());
        }
        return customerMonthBudget;
    }

    @Transactional
    public void updateControlBalanceAmountByIds(Set<String> ids, BigDecimal controlBalanceAmount) {
        this.monthBudgetRepository.updateControlBalanceAmountByIds(ids, controlBalanceAmount);
    }

    public Map<String, MonthBudgetControlVo> mapControlAmount(List<String> monthBudgetCodeList) {
        if (CollectionUtils.isEmpty(monthBudgetCodeList)) {
            return new HashMap<String, MonthBudgetControlVo>();
        }
        List<MonthBudgetEntity> monthBudgetList = this.monthBudgetRepository.getByMonthBudgetCodes(monthBudgetCodeList, EnableStatusEnum.ENABLE.getCode());
        return this.mapControlAmountByBudgetList(monthBudgetList);
    }

    public Map<String, MonthBudgetControlVo> mapControlAmountByBudgetList(List<MonthBudgetEntity> monthBudgetList) {
        if (CollectionUtils.isEmpty(monthBudgetList)) {
            return new HashMap<String, MonthBudgetControlVo>();
        }
        HashMap<String, MonthBudgetControlVo> amountMap = new HashMap<String, MonthBudgetControlVo>();
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
        monthBudgetList.forEach(monthBudgetEntity -> {
            MonthBudgetControlVo monthBudgetControlVo = new MonthBudgetControlVo();
            monthBudgetControlVo.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());
            List<DimensionControlsVo> collect = dimensionControlsVos.stream().filter(vo -> monthBudgetEntity.getBusinessUnitCode().equals(vo.getBusinessUnitCode())).collect(Collectors.toList());
            DimensionControlsVo sameItemControlsVo = null;
            DimensionControlsVo dimensionControlsVo = null;
            if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode()) || BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetEntity.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
                sameItemControlsVo = this.findSameItemControlConfig((MonthBudgetEntity)((Object)monthBudgetEntity), collect);
            }
            dimensionControlsVo = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)sameItemControlsVo) ? this.findControlConfig((MonthBudgetEntity)((Object)monthBudgetEntity), collect) : sameItemControlsVo;
            if (MonthBudgetGroupEnum.customer.getCode().equals(monthBudgetEntity.getGroupCode()) && BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetEntity.getBusinessUnitCode())) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.WARNING_TIPS.getCode());
                monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dimensionControlsVo)) {
                    monthBudgetControlVo.setIfRolling(dimensionControlsVo.getIfRolling());
                    monthBudgetControlVo.setControlsCaliber(dimensionControlsVo.getControlsCaliber());
                }
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            }
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dimensionControlsVo)) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            }
            monthBudgetControlVo.setIfRolling(dimensionControlsVo.getIfRolling());
            monthBudgetControlVo.setControlsCaliber(dimensionControlsVo.getControlsCaliber());
            monthBudgetControlVo.setControlsConfigCode(dimensionControlsVo.getControlsConfigCode());
            List<MonthBudgetEntity> sameDimensionControlList = this.listSameDimensionControlBudget((MonthBudgetEntity)((Object)monthBudgetEntity), dimensionControlsVo);
            if (CollectionUtils.isEmpty(sameDimensionControlList)) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            }
            if (BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
                BudgetItemVo controlItem = this.budgetItemService.findByCode(dimensionControlsVo.getControlBudgetItemCode(), null);
                if (CollectionUtils.isEmpty((Collection)controlItem.getControlConditionDtoList())) {
                    monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                    monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                } else {
                    List onlineList = controlItem.getControlConditionDtoList().stream().filter(budgetItemControlConditionVo -> BusinessUnitEnum.ONLINE.getCode().equals(budgetItemControlConditionVo.getBusinessUnitCode())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(onlineList)) {
                        monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                        monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                    } else {
                        monthBudgetControlVo.setControlTypeCode(((BudgetItemControlConditionVo)onlineList.get(0)).getControlTypeCode());
                        if (BudgetControlTypeEnum.CONTROL_RATIO.getCode().equals(((BudgetItemControlConditionVo)onlineList.get(0)).getControlTypeCode())) {
                            BigDecimal initResolveAmount = sameDimensionControlList.stream().map(MonthBudgetEntity::getInitResolveAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal reduce = BigDecimal.ZERO;
                            if (TimeDimension.MONTHLY.getCode().equals(dimensionControlsVo.getTimeDimension())) {
                                reduce = sameDimensionControlList.get(0).getTotalGoalQuantity() == null || BigDecimal.ZERO.compareTo(sameDimensionControlList.get(0).getTotalGoalQuantity()) == 0 ? BigDecimal.ZERO : initResolveAmount.divide(sameDimensionControlList.get(0).getTotalGoalQuantity(), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                            }
                            if (TimeDimension.QUARTER.getCode().equals(dimensionControlsVo.getTimeDimension()) || TimeDimension.YEAR.getCode().equals(dimensionControlsVo.getTimeDimension())) {
                                BigDecimal totalGoal = sameDimensionControlList.stream().filter(sameDimensionControl -> sameDimensionControl.getYearBudgetCode().equals(monthBudgetEntity.getYearBudgetCode()) && sameDimensionControl.getTotalGoalQuantity() != null).map(MonthBudgetEntity::getTotalGoalQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                                reduce = BigDecimal.ZERO.compareTo(totalGoal) == 0 ? BigDecimal.ZERO : initResolveAmount.divide(totalGoal, 6, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                            }
                            monthBudgetControlVo.setControlSituation(dimensionControlsVo.getControlSituation());
                            monthBudgetControlVo.setControlRatio(reduce);
                            monthBudgetControlVo.setControlBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
                        } else {
                            BigDecimal reduce = sameDimensionControlList.stream().map(MonthBudgetEntity::getAccumulatedAvailableBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                            monthBudgetControlVo.setControlSituation(dimensionControlsVo.getControlSituation());
                            monthBudgetControlVo.setControlBalanceAmount(reduce);
                        }
                    }
                }
            } else {
                BigDecimal reduce = sameDimensionControlList.stream().map(MonthBudgetEntity::getAccumulatedAvailableBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                monthBudgetControlVo.setControlSituation(dimensionControlsVo.getControlSituation());
                monthBudgetControlVo.setControlBalanceAmount(reduce);
            }
            amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
        });
        return amountMap;
    }

    private DimensionControlsVo findSameItemControlConfig(MonthBudgetEntity monthBudgetEntity, List<DimensionControlsVo> dimensionControlsVos) {
        if (CollectionUtils.isEmpty(dimensionControlsVos)) {
            return null;
        }
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        AtomicBoolean flag = new AtomicBoolean(false);
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (flag.get()) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)dimensionControlsVo.getBudgetItemCodeList())) {
                return;
            }
            if (!dimensionControlsVo.getBudgetItemCodeList().contains(monthBudgetEntity.getBudgetItemCode())) {
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)dimensionControlsVo.getOrgCode()) && !dimensionControlsVo.getOrgCode().equals(monthBudgetEntity.getOrgCode())) {
                return;
            }
            StringBuilder fieldsStr = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getSalesOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.TISSUE.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.DEPARTMENT.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getCustomerChannelCode()) || StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getCustomerChannelCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CHANNEL.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getSystemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SYSTEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getRegionCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.REGION.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getCustomerCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CLIEN.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getTerminalCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SHOP.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductBrandCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.BRAND.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductCategoryCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CATEGORY.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductItemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.ITEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.PRODUCT.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)dimensionControlsVo.getFieldsDimensionality())) {
                ArrayList dimensionalityList;
                ArrayList fieldList = Lists.newArrayList((Object[])fieldsStr.toString().split(","));
                if (fieldList.containsAll(dimensionalityList = Lists.newArrayList((Object[])dimensionControlsVo.getFieldsDimensionality().split(","))) || dimensionalityList.containsAll(fieldList)) {
                    dimensionControlsVo.setSameBudgetItemCodeList((List)Lists.newArrayList((Object[])new String[]{monthBudgetEntity.getBudgetItemCode()}));
                    dimensionControlsVo.setControlBudgetItemCode(monthBudgetEntity.getBudgetItemCode());
                    result.set(dimensionControlsVo);
                    flag.set(true);
                }
            } else {
                dimensionControlsVo.setSameBudgetItemCodeList((List)Lists.newArrayList((Object[])new String[]{monthBudgetEntity.getBudgetItemCode()}));
                dimensionControlsVo.setControlBudgetItemCode(monthBudgetEntity.getBudgetItemCode());
                result.set(dimensionControlsVo);
                flag.set(true);
            }
        });
        return result.get();
    }

    private List<MonthBudgetEntity> listSameDimensionControlBudget(MonthBudgetEntity monthBudgetEntity, DimensionControlsVo dimensionControlsVo) {
        String fieldsDimensionality = dimensionControlsVo.getFieldsDimensionality();
        ArrayList fieldsList = Lists.newArrayList((Object[])fieldsDimensionality.split(","));
        MonthBudgetControlQueryDto monthBudgetControlQueryDto = new MonthBudgetControlQueryDto();
        if (!CollectionUtils.isEmpty((Collection)fieldsList)) {
            if (fieldsList.contains(FieldsDimenDiameterEnum.TISSUE.getName())) {
                monthBudgetControlQueryDto.setSalesOrgCode(monthBudgetEntity.getSalesOrgCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.DEPARTMENT.getName())) {
                monthBudgetControlQueryDto.setOrgCode(monthBudgetEntity.getOrgCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.CHANNEL.getName())) {
                monthBudgetControlQueryDto.setCustomerChannelCode(monthBudgetEntity.getCustomerChannelCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.SYSTEM.getName())) {
                monthBudgetControlQueryDto.setSystemCode(monthBudgetEntity.getSystemCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.REGION.getName())) {
                monthBudgetControlQueryDto.setRegionCode(monthBudgetEntity.getRegionCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.CLIEN.getName())) {
                monthBudgetControlQueryDto.setCustomerCode(monthBudgetEntity.getCustomerCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.SHOP.getName())) {
                monthBudgetControlQueryDto.setTerminalCode(monthBudgetEntity.getTerminalCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.BRAND.getName())) {
                monthBudgetControlQueryDto.setProductBrandCode(monthBudgetEntity.getProductBrandCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.CATEGORY.getName())) {
                monthBudgetControlQueryDto.setProductCategoryCode(monthBudgetEntity.getProductCategoryCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.ITEM.getName())) {
                monthBudgetControlQueryDto.setProductItemCode(monthBudgetEntity.getProductItemCode());
            }
            if (fieldsList.contains(FieldsDimenDiameterEnum.PRODUCT.getName())) {
                monthBudgetControlQueryDto.setProductCode(monthBudgetEntity.getProductCode());
            }
        }
        ArrayList<String> yearMonthList = new ArrayList<String>();
        String yearly = monthBudgetEntity.getYearMonthLy().split("-")[0];
        if (TimeDimension.YEAR.getCode().equals(dimensionControlsVo.getTimeDimension())) {
            List monthList = MonthEnum.concertEnumToList();
            monthList.forEach(monthly -> yearMonthList.add(yearly + "-" + monthly));
        }
        if (TimeDimension.QUARTER.getCode().equals(dimensionControlsVo.getTimeDimension())) {
            Calendar calendar = DateUtil.getCalendar();
            calendar.setTime(DateUtil.parseDate((String)monthBudgetEntity.getYearMonthLy(), (String)"yyyy-MM"));
            int quarterByMonth = DateUtil.getQuarterByMonth((int)(calendar.get(2) + 1));
            if (quarterByMonth == 1) {
                yearMonthList.add(yearly + "-" + MonthEnum.JANUARY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.FEBRUARY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.MARCH.getCode());
            }
            if (quarterByMonth == 2) {
                yearMonthList.add(yearly + "-" + MonthEnum.APRIL.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.MAY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.JUNE.getCode());
            }
            if (quarterByMonth == 3) {
                yearMonthList.add(yearly + "-" + MonthEnum.JULY.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.AUGUST.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.SEPTEMBER.getCode());
            }
            if (quarterByMonth == 4) {
                yearMonthList.add(yearly + "-" + MonthEnum.OCTOBER.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.NOVEMBER.getCode());
                yearMonthList.add(yearly + "-" + MonthEnum.DECEMBER.getCode());
            }
        }
        if (TimeDimension.MONTHLY.getCode().equals(dimensionControlsVo.getTimeDimension())) {
            yearMonthList.add(monthBudgetEntity.getYearMonthLy());
        }
        monthBudgetControlQueryDto.setBusinessFormatCode(monthBudgetEntity.getBusinessFormatCode());
        monthBudgetControlQueryDto.setBusinessUnitCode(monthBudgetEntity.getBusinessUnitCode());
        monthBudgetControlQueryDto.setGroupCode(monthBudgetEntity.getGroupCode());
        monthBudgetControlQueryDto.setFeeBelongCode(monthBudgetEntity.getFeeBelongCode());
        monthBudgetControlQueryDto.setYearMonthList(yearMonthList);
        monthBudgetControlQueryDto.setSameBudgetItemCodeList(dimensionControlsVo.getSameBudgetItemCodeList());
        return this.monthBudgetMapper.listSameDimensionControlBudget(monthBudgetControlQueryDto);
    }

    private DimensionControlsVo findControlConfig(MonthBudgetEntity monthBudgetEntity, List<DimensionControlsVo> dimensionControlsVos) {
        if (CollectionUtils.isEmpty(dimensionControlsVos)) {
            return null;
        }
        ArrayList budgetItemCodeList = new ArrayList();
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (!CollectionUtils.isEmpty((Collection)dimensionControlsVo.getBudgetItemCodeList())) {
                budgetItemCodeList.addAll(dimensionControlsVo.getBudgetItemCodeList());
            }
        });
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return null;
        }
        List budgetItemVos = this.budgetItemService.listByParent(budgetItemCodeList);
        if (CollectionUtils.isEmpty((Collection)budgetItemVos)) {
            return null;
        }
        Map<String, List<BudgetItemVo>> parentMap = budgetItemVos.stream().collect(Collectors.groupingBy(BudgetItemVo::getParentBudgetItemCode));
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        AtomicBoolean flag = new AtomicBoolean(false);
        dimensionControlsVos.forEach(dimensionControlsVo -> {
            if (flag.get()) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)dimensionControlsVo.getBudgetItemCodeList())) {
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)dimensionControlsVo.getOrgCode()) && !dimensionControlsVo.getOrgCode().equals(monthBudgetEntity.getOrgCode())) {
                return;
            }
            ArrayList allItemList = new ArrayList();
            AtomicReference controlBudgetItemCode = new AtomicReference();
            dimensionControlsVo.getBudgetItemCodeList().forEach(parentCode -> {
                ArrayList thirdBudgetItemCodeList = new ArrayList();
                if (parentMap.containsKey(parentCode)) {
                    thirdBudgetItemCodeList.addAll(((List)parentMap.get(parentCode)).stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList()));
                }
                if (thirdBudgetItemCodeList.contains(monthBudgetEntity.getBudgetItemCode())) {
                    allItemList.addAll(thirdBudgetItemCodeList);
                    controlBudgetItemCode.set(parentCode);
                }
            });
            if (CollectionUtils.isEmpty(allItemList)) {
                return;
            }
            StringBuilder fieldsStr = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getSalesOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.TISSUE.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getOrgCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.DEPARTMENT.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getCustomerChannelCode()) || StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getCustomerChannelCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CHANNEL.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getSystemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SYSTEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getRegionCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.REGION.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getCustomerCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CLIEN.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getTerminalCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.SHOP.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductBrandCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.BRAND.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductCategoryCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.CATEGORY.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductItemCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.ITEM.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetEntity.getProductCode())) {
                fieldsStr.append(FieldsDimenDiameterEnum.PRODUCT.getName() + ",");
            }
            if (StringUtils.isNotEmpty((CharSequence)dimensionControlsVo.getFieldsDimensionality())) {
                ArrayList dimensionalityList;
                ArrayList fieldList = Lists.newArrayList((Object[])fieldsStr.toString().split(","));
                if (fieldList.containsAll(dimensionalityList = Lists.newArrayList((Object[])dimensionControlsVo.getFieldsDimensionality().split(","))) || dimensionalityList.containsAll(fieldList)) {
                    dimensionControlsVo.setSameBudgetItemCodeList(allItemList);
                    dimensionControlsVo.setControlBudgetItemCode((String)controlBudgetItemCode.get());
                    result.set(dimensionControlsVo);
                    flag.set(true);
                }
            } else {
                dimensionControlsVo.setControlBudgetItemCode((String)controlBudgetItemCode.get());
                dimensionControlsVo.setSameBudgetItemCodeList((List)Lists.newArrayList((Object[])new String[]{monthBudgetEntity.getBudgetItemCode()}));
                result.set(dimensionControlsVo);
                flag.set(true);
            }
        });
        return result.get();
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(String monthBudgetCode, BigDecimal operationAmount, String budgetType, String operationType, String businessCode) {
        Validate.notEmpty((CharSequence)budgetType, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (MonthBudgetTypeEnum.MONTH_BUDGET.getCode().equals(budgetType)) {
            this.operateBudget(monthBudgetCode, BigDecimal.ZERO, operationAmount, operationType, businessCode);
        } else if (MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode().equals(budgetType)) {
            this.subComMonthBudgetService.operateBudget(monthBudgetCode, operationAmount, operationType, businessCode);
        } else {
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u9884\u7b97\u7c7b\u578b\u9519\u8bef\uff01");
        }
    }

    public void operatePromotionBudget(List<PromotionOperateMonthBudgetDto> operateMonthBudgetDtoList) {
        Validate.notEmpty(operateMonthBudgetDtoList, (String)"\u9884\u7b97\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        operateMonthBudgetDtoList.forEach(operateMonthBudgetDto -> {
            if (MonthBudgetTypeEnum.MONTH_BUDGET.getCode().equals(operateMonthBudgetDto.getBudgetType())) {
                this.operateBudget(operateMonthBudgetDto.getMonthBudgetCode(), operateMonthBudgetDto.getFeeRatio(), operateMonthBudgetDto.getOperationAmount(), operateMonthBudgetDto.getOperationType(), operateMonthBudgetDto.getBusinessCode());
            } else if (MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode().equals(operateMonthBudgetDto.getBudgetType())) {
                this.subComMonthBudgetService.operateBudget(operateMonthBudgetDto.getMonthBudgetCode(), operateMonthBudgetDto.getOperationAmount(), operateMonthBudgetDto.getOperationType(), operateMonthBudgetDto.getBusinessCode());
            } else {
                throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u9884\u7b97\u7c7b\u578b\u9519\u8bef\uff01");
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(String monthBudgetCode, BigDecimal feeRatio, BigDecimal operationAmount, String operationType, String businessCode) {
        Validate.notEmpty((CharSequence)monthBudgetCode, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)operationAmount, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)operationType, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(monthBudgetCode, EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)monthBudgetEntity), (String)("\u6708\u5ea6\u9884\u7b97" + monthBudgetCode + "\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01"), (Object[])new Object[0]);
        if (!this.redisLockService.isLock("month_budget:lock:" + monthBudgetCode)) {
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97" + monthBudgetCode + "\u672a\u52a0\u9501\uff01");
        }
        BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
        if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
            Map<String, MonthBudgetControlVo> map = this.mapControlAmount(Lists.newArrayList((Object[])new String[]{monthBudgetCode}));
            MonthBudgetControlVo monthBudgetControlVo = map.get(monthBudgetCode);
            String controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();
            if (StringUtils.isNotEmpty((CharSequence)monthBudgetControlVo.getControlSituation())) {
                controlSituation = monthBudgetControlVo.getControlSituation();
            }
            if (BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode()) && BudgetControlTypeEnum.CONTROL_RATIO.getCode().equals(monthBudgetControlVo.getControlTypeCode())) {
                if (Optional.ofNullable(feeRatio).orElse(BigDecimal.ZERO).compareTo(monthBudgetControlVo.getControlRatio()) > 0 && ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    throw new RuntimeException("[" + businessCode + "]\u8d39\u7528\u7387[" + feeRatio + "]\u5927\u4e8e\u7ba1\u63a7\u7387" + monthBudgetControlVo.getControlRatio() + "\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                monthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else {
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    Validate.isTrue((monthBudgetControlVo.getControlBalanceAmount().compareTo(operationAmount) >= 0 ? 1 : 0) != 0, (String)("[" + businessCode + "]\u4f7f\u7528\u91d1\u989d[" + operationAmount + "]\u5927\u4e8e\u7ba1\u63a7\u4f59\u989d" + monthBudgetControlVo.getControlBalanceAmount() + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                }
                monthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            }
        } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
            monthBudgetEntity.setApprovedAmount(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
        } else if (BudgetOperationTypeEnum.ADJUST.getCode().equals(operationType)) {
            monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
            monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
        } else if (BudgetOperationTypeEnum.AUDIT_DIFF.getCode().equals(operationType)) {
            monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
        } else if (BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType)) {
            monthBudgetEntity.setEstimatedExcessAmount(Optional.ofNullable(monthBudgetEntity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.DUTY_PROFIT_ADJUST.getCode().equals(operationType)) {
            Validate.isTrue((Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u53ef\u7528\u4f59\u989d", (Object[])new Object[0]);
            monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
        }
        this.monthBudgetRepository.updateById((Object)monthBudgetEntity);
        MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, operationAmount, beforeAmount, operationType, businessCode);
        this.monthBudgetDetailService.create(monthBudgetDetailDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(List<OperateMonthBudgetDto> operateList) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        Set monthBudgetCodeSet = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(monthBudgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.operateBudget(operateList, Maps.newHashMap());
        }
        finally {
            this.monthBudgetLockService.unLock(new ArrayList(monthBudgetCodeSet));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(List<OperateMonthBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        operateList.forEach(dto -> {
            if (!this.redisLockService.isLock("month_budget:lock:" + dto.getMonthBudgetCode())) {
                throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97" + dto.getMonthBudgetCode() + "\u672a\u52a0\u9501\uff01");
            }
        });
        ArrayList<String> ids = new ArrayList<String>();
        List<MonthBudgetEntity> budgetEntityList = this.validateOperateBudget(operateList);
        Map budgetEntityMap = budgetEntityList.stream().collect(Collectors.toMap(MonthBudgetEntity::getMonthBudgetCode, Function.identity()));
        Map<String, MonthBudgetControlVo> controlMap = this.mapControlAmountByBudgetList(budgetEntityList);
        log.info("\u6d3b\u52a8\u65b9\u6848\u9884\u7b97\u8ddf\u8e2a\u8868\u9000\u9884\u7b972:controlMap-key:{},value:{}", (Object)JsonUtils.obj2JsonString(controlMap.keySet()), (Object)JsonUtils.obj2JsonString(controlMap.values()));
        ArrayList detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            List<MonthBudgetEntity> monthBudgetEntities;
            Calendar cal;
            Date budgetYearMonth;
            Date nowYearMonth;
            ArrayList yearMonths;
            SimpleDateFormat df;
            String yearMonth;
            String controlSituation;
            MonthBudgetEntity monthBudgetEntity = (MonthBudgetEntity)((Object)budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode()));
            BigDecimal beforeAmount = monthBudgetEntity.getAccumulatedAvailableBalance();
            MonthBudgetControlVo monthBudgetControlVo = controlMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = Optional.ofNullable(operateMonthBudgetDto.getOperationAmount()).orElse(BigDecimal.ZERO);
            BigDecimal looseAmount = looseAmountMap.getOrDefault(operateMonthBudgetDto.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal alreadyEndCaseAmount = Optional.ofNullable(operateMonthBudgetDto.getAlreadyEndCaseAmount()).orElse(BigDecimal.ZERO);
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType) || BudgetOperationTypeEnum.DEDUCTION.getCode().equals(operationType)) {
                controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();
                if (StringUtils.isNotEmpty((CharSequence)monthBudgetControlVo.getControlSituation())) {
                    controlSituation = monthBudgetControlVo.getControlSituation();
                }
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    String controlsConfigCode = monthBudgetControlVo.getControlsConfigCode();
                    String controlCodeDesc = "\u9884\u7b97\u7f16\u7801[" + operateMonthBudgetDto.getMonthBudgetCode() + "]";
                    if (StringUtils.isNotBlank((CharSequence)controlsConfigCode)) {
                        controlCodeDesc = controlCodeDesc + "\u7ba1\u63a7\u7ef4\u5ea6[" + controlsConfigCode + "]";
                    }
                    Validate.isTrue((monthBudgetControlVo.getControlBalanceAmount().add(looseAmount).compareTo(operationAmount) >= 0 ? 1 : 0) != 0, (String)((StringUtils.isEmpty((CharSequence)businessCode) ? "\u7b2c[" + operateMonthBudgetDto.getIndexNo() + "\u884c]" : "[" + businessCode + "]") + "\u4f7f\u7528\u91d1\u989d[" + operationAmount + "]\u5927\u4e8e\u5f53\u524d" + controlCodeDesc + "\u4f59\u989d" + monthBudgetControlVo.getControlBalanceAmount() + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                }
                monthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                monthBudgetEntity.setApprovedAmount(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType)) {
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.RELEASE.getCode().equals(operationType)) {
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType)) {
                Validate.isTrue((monthBudgetEntity.getAccumulatedAvailableBalance().compareTo(operationAmount) >= 0 ? 1 : 0) != 0, (String)("\u8c03\u51fa\u65b9\u3010" + monthBudgetEntity.getMonthBudgetCode() + "\u3011\u8c03\u51fa\u91d1\u989d" + operationAmount + "\u5143\u5927\u4e8e\u5f53\u524d\u7d2f\u8ba1\u53ef\u7528\u4f59\u989d" + monthBudgetEntity.getAccumulatedAvailableBalance() + "\u5143"), (Object[])new Object[0]);
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setApprovingAmount(Optional.ofNullable(monthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.AUDIT_DIFF.getCode().equals(operationType)) {
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType)) {
                monthBudgetEntity.setEstimatedExcessAmount(Optional.ofNullable(monthBudgetEntity.getEstimatedExcessAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.DUTY_PROFIT_ADJUST.getCode().equals(operationType)) {
                Validate.isTrue((Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u53ef\u7528\u4f59\u989d", (Object[])new Object[0]);
                monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
                controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();
                if (StringUtils.isNotEmpty((CharSequence)monthBudgetControlVo.getControlSituation())) {
                    controlSituation = monthBudgetControlVo.getControlSituation();
                }
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation)) {
                    Validate.isTrue((monthBudgetControlVo.getControlBalanceAmount().compareTo(operationAmount) >= 0 ? 1 : 0) != 0, (String)("[" + businessCode + "]\u4f7f\u7528\u91d1\u989d[" + operationAmount + "]\u5927\u4e8e\u5f53\u524d\u7ba1\u63a7\u4f59\u989d" + monthBudgetControlVo.getControlBalanceAmount() + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                }
                monthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
                monthBudgetEntity.setApprovedAmount(Optional.ofNullable(monthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetControlVo.setControlBalanceAmount(Optional.ofNullable(monthBudgetControlVo.getControlBalanceAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType)) {
                monthBudgetEntity.setFreezeAmount(Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType)) {
                monthBudgetEntity.setFreezeAmount(Optional.ofNullable(monthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
            } else if (BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
                monthBudgetEntity.setAuditAmount(Optional.ofNullable(monthBudgetEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(alreadyEndCaseAmount));
                monthBudgetEntity.setChangeAuditAmount(YesOrNoEnum.YES.getCode());
                monthBudgetEntity.setAlreadyEndCaseAmount(alreadyEndCaseAmount);
                monthBudgetEntity.setApprovedAuditDiff(Optional.ofNullable(monthBudgetEntity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                monthBudgetEntity.setChangeApprovedAuditDiff(YesOrNoEnum.YES.getCode());
                monthBudgetEntity.setOldAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance());
                yearMonth = null;
                if (StringUtils.isEmpty((CharSequence)operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth())) {
                    df = new SimpleDateFormat("yyyy-MM");
                    yearMonth = df.format(new Date());
                } else {
                    yearMonth = operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth();
                }
                String yearMonthLy = monthBudgetEntity.getYearMonthLy();
                String yearLy = yearMonthLy.substring(0, 4);
                String currYearLy = yearMonth.substring(0, 4);
                if (!yearLy.equals(currYearLy)) {
                    yearMonth = yearLy + "-12";
                }
                monthBudgetEntity.setPlanReturnBudgetYearAndMonth(yearMonth);
                monthBudgetEntity.setAuditCode(operateMonthBudgetDto.getAuditCode());
                if (monthBudgetControlVo == null) {
                    monthBudgetEntity.setLogRemark("\u7ba1\u63a7\u7f16\u7801:\u65e0");
                } else {
                    monthBudgetEntity.setLogRemark("\u7ba1\u63a7\u7f16\u7801:" + monthBudgetControlVo.getControlsConfigCode() + ",\u662f\u5426\u6eda\u52a8:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode((String)Optional.ofNullable(monthBudgetControlVo.getControlsCaliber()).orElse("").trim()));
                }
                if (!yearMonth.equals(monthBudgetEntity.getYearMonthLy()) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) {
                    if (BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM");
                        yearMonths = Lists.newArrayList();
                        try {
                            nowYearMonth = df2.parse(yearMonth);
                            budgetYearMonth = df2.parse(monthBudgetEntity.getYearMonthLy());
                            cal = Calendar.getInstance();
                            do {
                                cal.setTime(budgetYearMonth);
                                cal.add(2, 1);
                                yearMonths.add(df2.format(cal.getTime()));
                            } while ((budgetYearMonth = cal.getTime()).compareTo(nowYearMonth) < 0);
                        }
                        catch (ParseException e) {
                            log.error("\u7ed3\u6848\u6838\u9500\u9000\u9884\u7b97\u9519\u8bef", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceBefore(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                        monthBudgetEntity.setChangeAccumulatedAvailableBalance(YesOrNoEnum.YES.getCode());
                        monthBudgetEntities = this.monthBudgetRepository.getListByYearMonth(monthBudgetEntity.getYearBudgetCode(), yearMonths);
                        ids.addAll(monthBudgetEntities.stream().map(UuidEntity::getId).collect(Collectors.toList()));
                    } else {
                        MonthBudgetEntity one = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(monthBudgetEntity.getYearBudgetCode(), yearMonth);
                        Validate.notNull((Object)((Object)one), (String)"\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5e74\u5ea6\u9884\u7b97\u4e0b\u5f53\u524d\u6708\u4efd%s\u7684\u9884\u7b97", (Object[])new Object[]{monthBudgetEntity.getMonthBudgetCode(), yearMonth});
                        MonthBudgetEntity monthBudgetEntity1 = (MonthBudgetEntity)((Object)budgetEntityMap.get(one.getMonthBudgetCode()));
                        if (monthBudgetEntity1 != null) {
                            one = monthBudgetEntity1;
                        }
                        one.setOldAccumulatedAvailableBalance(one.getAccumulatedAvailableBalance());
                        one.setAdjustAmount(Optional.ofNullable(one.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                        one.setChangeAdjustAmount(YesOrNoEnum.YES.getCode());
                        one.setAccumulatedAvailableBalance(Optional.ofNullable(one.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                        one.setChangeAccumulatedAvailableBalance(YesOrNoEnum.YES.getCode());
                        one.setAfterFreezeAmount(Optional.ofNullable(one.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                        one.setChangeAfterFreezeAmount(YesOrNoEnum.YES.getCode());
                        one.setLogRemark("\u7ba1\u63a7\u7f16\u7801:" + monthBudgetControlVo.getControlsConfigCode() + ",\u662f\u5426\u6eda\u52a8:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode((String)monthBudgetControlVo.getControlsCaliber().trim()));
                        one.setAuditCode(operateMonthBudgetDto.getAuditCode());
                        budgetEntityMap.put(one.getMonthBudgetCode(), one);
                        detailList.add(this.buildDetail(one, operationAmount, one.getOldAccumulatedAvailableBalance(), operationType, businessCode));
                    }
                }
                if (yearMonth.equals(monthBudgetEntity.getYearMonthLy()) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim()) || monthBudgetControlVo == null || monthBudgetControlVo.getIfRolling() == null || YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) {
                    monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                    monthBudgetEntity.setChangeAdjustAmount(YesOrNoEnum.YES.getCode());
                    monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                    monthBudgetEntity.setChangeAccumulatedAvailableBalance(YesOrNoEnum.YES.getCode());
                    monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                    monthBudgetEntity.setChangeAfterFreezeAmount(YesOrNoEnum.YES.getCode());
                }
            } else if (BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType)) {
                monthBudgetEntity.setAuditAmount(Optional.ofNullable(monthBudgetEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(alreadyEndCaseAmount));
                monthBudgetEntity.setAlreadyEndCaseAmount(alreadyEndCaseAmount);
                monthBudgetEntity.setOldAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance());
                if (Optional.ofNullable(operationAmount).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) != 0 || BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                    monthBudgetEntity.setApprovedAuditDiff(Optional.ofNullable(monthBudgetEntity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO).add(operationAmount));
                    yearMonth = null;
                    df = new SimpleDateFormat("yyyy-MM");
                    yearMonth = StringUtils.isEmpty((CharSequence)operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth()) ? df.format(new Date()) : operateMonthBudgetDto.getPlanReturnBudgetYearAndMonth();
                    String yearMonthLy = monthBudgetEntity.getYearMonthLy();
                    String yearLy = yearMonthLy.substring(0, 4);
                    String currYearLy = yearMonth.substring(0, 4);
                    if (!yearLy.equals(currYearLy)) {
                        yearMonth = yearLy + "-12";
                    }
                    log.info("\u6d3b\u52a8\u65b9\u6848\u9884\u7b97\u8ddf\u8e2a\u8868\u9000\u9884\u7b97yearMonth:{},monthBudgetEntity:{},monthBudgetControlVo:{}", new Object[]{yearMonth, monthBudgetEntity, monthBudgetControlVo});
                    monthBudgetEntity.setPlanReturnBudgetYearAndMonth(yearMonth);
                    if (monthBudgetControlVo == null) {
                        monthBudgetEntity.setLogRemark("\u7ba1\u63a7\u7f16\u7801:\u65e0");
                    } else {
                        monthBudgetEntity.setLogRemark("\u7ba1\u63a7\u7f16\u7801:" + monthBudgetControlVo.getControlsConfigCode() + ",\u662f\u5426\u6eda\u52a8:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode((String)Optional.ofNullable(monthBudgetControlVo.getControlsCaliber()).orElse("").trim()));
                    }
                    if (!yearMonth.equals(monthBudgetEntity.getYearMonthLy()) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) {
                        log.info("\u6d3b\u52a8\u65b9\u6848\u9884\u7b97\u8ddf\u8e2a\u8868\u9000\u9884\u7b97operateMonthBudgetDto:{}", (Object)operateMonthBudgetDto);
                        if (BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                            yearMonths = Lists.newArrayList();
                            try {
                                nowYearMonth = df.parse(yearMonth);
                                budgetYearMonth = df.parse(monthBudgetEntity.getYearMonthLy());
                                cal = Calendar.getInstance();
                                do {
                                    cal.setTime(budgetYearMonth);
                                    cal.add(2, 1);
                                    yearMonths.add(df.format(cal.getTime()));
                                } while ((budgetYearMonth = cal.getTime()).compareTo(nowYearMonth) < 0);
                            }
                            catch (ParseException e) {
                                log.error("\u7ed3\u6848\u6838\u9500\u9000\u9884\u7b97\u9519\u8bef", (Throwable)e);
                                throw new RuntimeException(e);
                            }
                            monthBudgetEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceBefore(monthBudgetEntity, BusinessUnitEnum.VERTICAL));
                            monthBudgetEntities = this.monthBudgetRepository.getListByYearMonth(monthBudgetEntity.getYearBudgetCode(), yearMonths);
                            ids.addAll(monthBudgetEntities.stream().map(UuidEntity::getId).collect(Collectors.toList()));
                            log.info("\u6d3b\u52a8\u65b9\u6848\u9884\u7b97\u8ddf\u8e2a\u8868\u9000\u9884\u7b97ids:{}", (Object)JsonUtils.obj2JsonString(ids));
                        } else {
                            MonthBudgetEntity one = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(monthBudgetEntity.getYearBudgetCode(), yearMonth);
                            Validate.notNull((Object)((Object)one), (String)"\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5e74\u5ea6\u9884\u7b97\u4e0b\u5f53\u524d\u6708\u4efd%s\u7684\u9884\u7b97", (Object[])new Object[]{monthBudgetEntity.getMonthBudgetCode(), yearMonth});
                            MonthBudgetEntity monthBudgetEntity1 = (MonthBudgetEntity)((Object)budgetEntityMap.get(one.getMonthBudgetCode()));
                            if (monthBudgetEntity1 != null) {
                                one = monthBudgetEntity1;
                            }
                            one.setOldAccumulatedAvailableBalance(one.getAccumulatedAvailableBalance());
                            one.setAdjustAmount(Optional.ofNullable(one.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                            one.setAccumulatedAvailableBalance(Optional.ofNullable(one.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                            one.setAfterFreezeAmount(Optional.ofNullable(one.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                            one.setLogRemark("\u7ba1\u63a7\u7f16\u7801:" + monthBudgetControlVo.getControlsConfigCode() + ",\u662f\u5426\u6eda\u52a8:" + monthBudgetControlVo.getIfRolling() + "," + ControlsCaliberEnum.getNameByCode((String)monthBudgetControlVo.getControlsCaliber().trim()));
                            budgetEntityMap.put(one.getMonthBudgetCode(), one);
                            detailList.add(this.buildDetail(one, operationAmount, beforeAmount, operationType, businessCode));
                        }
                    }
                    if (yearMonth.equals(monthBudgetEntity.getYearMonthLy()) && YesOrNoEnum.YES.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim()) || monthBudgetControlVo == null || monthBudgetControlVo.getIfRolling() == null || YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling()) && ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) {
                        if (!BusinessUnitEnum.VERTICAL.getCode().equals(operateMonthBudgetDto.getBusinessUnitCode())) {
                            monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                        }
                        monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                        monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                    }
                } else if (Optional.ofNullable(operationAmount).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) == 0 || BusinessUnitEnum.isDefaultBusinessUnit((String)operateMonthBudgetDto.getBusinessUnitCode())) {
                    monthBudgetEntity.setLogRemark("\u7ba1\u63a7\u7f16\u7801:\u65e0");
                }
            } else if (BudgetOperationTypeEnum.AUDIT_REJECT.getCode().equals(operationType)) {
                monthBudgetEntity.setOldAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance());
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAuditAmount())) {
                    monthBudgetEntity.setAuditAmount(Optional.ofNullable(monthBudgetEntity.getAuditAmount()).orElse(BigDecimal.ZERO).subtract(alreadyEndCaseAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeApprovedAuditDiff())) {
                    monthBudgetEntity.setApprovedAuditDiff(Optional.ofNullable(monthBudgetEntity.getApprovedAuditDiff()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAdjustAmount())) {
                    monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAccumulatedAvailableBalance())) {
                    monthBudgetEntity.setAccumulatedAvailableBalance(Optional.ofNullable(monthBudgetEntity.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
                if (YesOrNoEnum.YES.getCode().equals(operateMonthBudgetDto.getChangeAfterFreezeAmount())) {
                    monthBudgetEntity.setAfterFreezeAmount(Optional.ofNullable(monthBudgetEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                }
            } else {
                throw new RuntimeException("\u6708\u5ea6\u9884\u7b97\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
            }
            MonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(monthBudgetEntity, operationAmount, beforeAmount, operationType, businessCode);
            detailList.add(monthBudgetDetailDto);
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave.booleanValue()) {
            this.monthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            this.manualRolling(ids);
        }
    }

    public void operateBudgetStrategy(List<OperateMonthBudgetDto> operateList) {
        this.operateBudgetStrategy(operateList, Maps.newHashMap());
    }

    public void operateBudgetStrategy(List<OperateMonthBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        List<MonthBudgetEntity> budgetEntityList = this.validateOperateBudget(operateList);
        Map budgetEntityMap = budgetEntityList.stream().collect(Collectors.toMap(MonthBudgetEntity::getMonthBudgetCode, Function.identity()));
        Map<String, MonthBudgetControlVo> controlMap = this.mapControlAmountByBudgetList(budgetEntityList);
        Boolean throwException = operateList.get(0).getThrowException();
        ArrayList detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            MonthBudgetEntity monthBudgetEntity = (MonthBudgetEntity)((Object)budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode()));
            MonthBudgetControlVo monthBudgetControlVo = controlMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            BigDecimal looseAmount = looseAmountMap.getOrDefault(monthBudgetEntity.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal usedStrategyAmount = Optional.ofNullable(monthBudgetEntity.getUsedStrategyAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usableStrategyAmount = monthBudgetEntity.getAfterFreezeAmount().add(looseAmount).subtract(usedStrategyAmount);
            String businessDesc = "";
            if (StringUtils.isNotEmpty((CharSequence)businessCode)) {
                businessDesc = "[" + businessCode + "]";
            }
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                String controlSituation = ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode();
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)monthBudgetControlVo) && StringUtils.isNotEmpty((CharSequence)monthBudgetControlVo.getControlSituation())) {
                    controlSituation = monthBudgetControlVo.getControlSituation();
                }
                if (ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode().equals(controlSituation) && usableStrategyAmount.compareTo(operationAmount) < 0) {
                    if (throwException.booleanValue()) {
                        throw new RuntimeException(businessDesc + "\u4f7f\u7528\u91d1\u989d[" + operationAmount + "]\u5927\u4e8e\u9884\u7b97[" + operateMonthBudgetDto.getMonthBudgetCode() + "]\u53ef\u7528\u4f59\u989d" + usableStrategyAmount + "\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    operateMonthBudgetDto.setGapAmount(operationAmount.subtract(usableStrategyAmount));
                    monthBudgetEntity.setUsedStrategyAmount(monthBudgetEntity.getAfterFreezeAmount());
                    continue;
                }
                monthBudgetEntity.setUsedStrategyAmount(usedStrategyAmount.add(operationAmount));
                continue;
            }
            if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                monthBudgetEntity.setUsedStrategyAmount(usedStrategyAmount.subtract(operationAmount));
                continue;
            }
            throw new RuntimeException(businessDesc + "\u6708\u5ea6\u9884\u7b97\u7b56\u7565\u5360\u7528\u91d1\u989d\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave.booleanValue()) {
            this.monthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
        }
    }

    public List<MonthBudgetEntity> validateOperateBudget(List<OperateMonthBudgetDto> operateList) {
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getMonthBudgetCode(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> monthBudgetCodeList = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<MonthBudgetEntity> budgetEntityList = this.monthBudgetRepository.listByCodes(monthBudgetCodeList);
        if (budgetEntityList.size() < monthBudgetCodeList.size()) {
            List existsCodes = budgetEntityList.stream().map(MonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
            String notExistsJoinCodesStr = monthBudgetCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97[" + notExistsJoinCodesStr + "]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01\uff01");
        }
        for (MonthBudgetEntity monthBudgetEntity : budgetEntityList) {
            if (null == monthBudgetEntity.getUsedStrategyAmount()) {
                monthBudgetEntity.setUsedStrategyAmount(BigDecimal.ZERO);
            }
            if (null != monthBudgetEntity.getInitResolveAmount()) continue;
            monthBudgetEntity.setInitResolveAmount(BigDecimal.ZERO);
        }
        return budgetEntityList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOperateBudget(Collection<MonthBudgetEntity> budgetList, List<MonthBudgetDetailDto> detailList) {
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.monthBudgetRepository.updateBatchById(budgetList);
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            this.monthBudgetDetailService.createList(detailList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void transfer(MonthBudgetTransferDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getMonthBudgetCode(), (String)"\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getDetailDtoList(), (String)"\u64cd\u4f5c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)monthBudgetEntity), (String)"\u5f53\u524d\u9884\u7b97\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        ArrayList<MonthBudgetEntity> dimensionBudgetList = new ArrayList<MonthBudgetEntity>();
        dto.getDetailDtoList().forEach(detailDto -> {
            MonthBudgetDto monthBudgetDto = (MonthBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList(detailDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            monthBudgetDto.setYearMonthLy(monthBudgetEntity.getYearMonthLy());
            List<MonthBudgetEntity> monthBudgetEntityList = this.findByDimension(monthBudgetDto);
            if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
                MonthBudgetEntity addMonthBudgetEntity = (MonthBudgetEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(detailDto, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
                addMonthBudgetEntity.setYearMonthLy(monthBudgetEntity.getYearMonthLy());
                addMonthBudgetEntity.setAdjustAmount(detailDto.getTransferAmount());
                addMonthBudgetEntity.setAccumulatedAvailableBalance(detailDto.getTransferAmount());
                dimensionBudgetList.add(addMonthBudgetEntity);
            } else {
                log.info("\u67e5\u8be2\u540c\u7ef4\u5ea6\u6708\u5ea6\u9884\u7b97\u6210\u529f\uff0c\u5171\u67e5\u8be2\u5230" + monthBudgetEntityList.size() + "\u6761");
                MonthBudgetEntity dimensionBudget = monthBudgetEntityList.get(0);
                if (StringUtils.equals((CharSequence)monthBudgetEntity.getMonthBudgetCode(), (CharSequence)dimensionBudget.getMonthBudgetCode())) {
                    throw new RuntimeException("\u5212\u62e8\u5931\u8d25\uff0c\u9884\u7b97" + monthBudgetEntity.getMonthBudgetCode() + "\u4e0d\u80fd\u5212\u62e8\u81f3\u9884\u7b97" + dimensionBudget.getMonthBudgetCode());
                }
                dimensionBudget.setAdjustAmount(Optional.ofNullable(dimensionBudget.getAdjustAmount()).orElse(BigDecimal.ZERO).add(detailDto.getTransferAmount()));
                dimensionBudget.setAccumulatedAvailableBalance(dimensionBudget.getAccumulatedAvailableBalance().add(detailDto.getTransferAmount()));
                dimensionBudgetList.add(dimensionBudget);
            }
        });
        boolean lockFlag = true;
        List<String> lockKeys = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(dimensionBudgetList)) {
            lockKeys = dimensionBudgetList.stream().map(MonthBudgetEntity::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toList());
        }
        lockKeys.add(dto.getMonthBudgetCode());
        try {
            lockFlag = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 5);
            BigDecimal transferAmount = dto.getDetailDtoList().stream().map(MonthBudgetTransferDetailDto::getTransferAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            monthBudgetEntity.setAdjustAmount(Optional.ofNullable(monthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(transferAmount));
            monthBudgetEntity.setAccumulatedAvailableBalance(monthBudgetEntity.getAccumulatedAvailableBalance().subtract(transferAmount));
            dimensionBudgetList.add(monthBudgetEntity);
            dimensionBudgetList.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
            this.monthBudgetRepository.saveOrUpdateBatch(dimensionBudgetList);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    public MonthBudgetMainAdjustVo adjustQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MonthBudgetDetailEntity> monthBudgetDetailEntityList = this.monthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        List<String> codeList = monthBudgetDetailEntityList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMonthBudgetCode())).map(MonthBudgetDetailEntity::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<MonthBudgetEntity> budgetEntityList = this.monthBudgetRepository.getByMonthBudgetCodes(codeList, null);
        HashMap budgetAdjustVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(budgetEntityList)) {
            Collection adjustList = this.nebulaToolkitService.copyCollectionByWhiteList(budgetEntityList, MonthBudgetEntity.class, MonthBudgetAdjustVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetAdjustVoMap.putAll(adjustList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMonthBudgetCode())).collect(Collectors.toMap(MonthBudgetAdjustVo::getMonthBudgetCode, v -> v, (n, o) -> n)));
        }
        MonthBudgetMainAdjustVo monthBudgetMainAdjustVo = new MonthBudgetMainAdjustVo();
        ArrayList adjustOutVoList = new ArrayList();
        monthBudgetDetailEntityList.forEach(detailEntity -> {
            MonthBudgetAdjustVo monthBudgetVo = (MonthBudgetAdjustVo)budgetAdjustVoMap.get(detailEntity.getMonthBudgetCode());
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(detailEntity.getOperationType())) {
                monthBudgetVo.setAccumulatedAvailableBalance(detailEntity.getBeforeAmount());
                monthBudgetVo.setAdjustInAmount(detailEntity.getCurOperationAmount());
                monthBudgetVo.setAdjustInBalance(detailEntity.getBalanceAmount().add(detailEntity.getCurOperationAmount()));
                monthBudgetVo.setOperationRemarks(detailEntity.getOperationRemarks());
                monthBudgetMainAdjustVo.setAdjustInVo(monthBudgetVo);
            } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(detailEntity.getOperationType())) {
                monthBudgetVo.setAccumulatedAvailableBalance(detailEntity.getBeforeAmount());
                monthBudgetVo.setAdjustOutAmount(detailEntity.getCurOperationAmount());
                monthBudgetVo.setAdjustInBalance(detailEntity.getBalanceAmount());
                adjustOutVoList.add(monthBudgetVo);
            }
        });
        monthBudgetMainAdjustVo.setAdjustOutVoList(adjustOutVoList);
        return monthBudgetMainAdjustVo;
    }

    public MonthBudgetMainAdjustVo adjustSumQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MonthBudgetDetailEntity> monthBudgetDetailEntityList = this.monthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        List<String> codeList = monthBudgetDetailEntityList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMonthBudgetCode())).map(MonthBudgetDetailEntity::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<MonthBudgetEntity> budgetEntityList = this.monthBudgetRepository.getByMonthBudgetCodes(codeList, null);
        HashMap budgetAdjustVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(budgetEntityList)) {
            Collection adjustList = this.nebulaToolkitService.copyCollectionByWhiteList(budgetEntityList, MonthBudgetEntity.class, MonthBudgetAdjustVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetAdjustVoMap.putAll(adjustList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getMonthBudgetCode())).collect(Collectors.toMap(MonthBudgetAdjustVo::getMonthBudgetCode, v -> v, (n, o) -> n)));
        }
        MonthBudgetMainAdjustVo monthBudgetMainAdjustVo = new MonthBudgetMainAdjustVo();
        HashMap sumMap = Maps.newHashMap();
        monthBudgetDetailEntityList.forEach(detailEntity -> {
            MonthBudgetAdjustVo monthBudgetVo = (MonthBudgetAdjustVo)budgetAdjustVoMap.get(detailEntity.getMonthBudgetCode());
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(detailEntity.getOperationType())) {
                monthBudgetVo.setAccumulatedAvailableBalance(detailEntity.getBeforeAmount());
                monthBudgetVo.setAdjustInAmount(detailEntity.getCurOperationAmount());
                monthBudgetVo.setAdjustInBalance(detailEntity.getBalanceAmount().add(detailEntity.getCurOperationAmount()));
                monthBudgetVo.setOperationRemarks(detailEntity.getOperationRemarks());
                monthBudgetMainAdjustVo.setAdjustInVo(monthBudgetVo);
            } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(detailEntity.getOperationType())) {
                String key = monthBudgetVo.getBudgetItemName() + monthBudgetVo.getOrgName() + monthBudgetVo.getYearMonthLy();
                MonthBudgetAdjustVo sumVo = sumMap.computeIfAbsent(key, tempKey -> monthBudgetVo);
                sumVo.setAccumulatedAvailableBalance(Optional.ofNullable(sumVo.getAccumulatedAvailableBalance()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getBeforeAmount()).orElse(BigDecimal.ZERO)));
                sumVo.setAdjustOutAmount(Optional.ofNullable(sumVo.getAdjustOutAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                sumVo.setAdjustOutBalance(Optional.ofNullable(sumVo.getAdjustOutBalance()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(detailEntity.getBalanceAmount()).orElse(BigDecimal.ZERO)));
            }
        });
        ArrayList adjustOutVoList = Lists.newArrayList(sumMap.values());
        monthBudgetMainAdjustVo.setAdjustOutVoList((List)adjustOutVoList);
        return monthBudgetMainAdjustVo;
    }

    public MonthBudgetChangeVo changeQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MonthBudgetDetailEntity> monthBudgetDetailEntityList = this.monthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(monthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        MonthBudgetDetailEntity monthBudgetDetailEntity = monthBudgetDetailEntityList.get(0);
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getByMonthBudgetCode(monthBudgetDetailEntity.getMonthBudgetCode(), null);
        MonthBudgetChangeVo monthBudgetChangeVo = (MonthBudgetChangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, MonthBudgetChangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (BudgetOperationTypeEnum.ADD.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
            monthBudgetChangeVo.setAccumulatedAvailableBalance(monthBudgetDetailEntity.getBeforeAmount());
            monthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.ADD.getCode());
            monthBudgetChangeVo.setChangeAmount(monthBudgetDetailEntity.getCurOperationAmount());
            monthBudgetChangeVo.setChangeBalance(monthBudgetDetailEntity.getBalanceAmount().add(monthBudgetDetailEntity.getCurOperationAmount()));
            monthBudgetChangeVo.setChangeRemarks(monthBudgetDetailEntity.getOperationRemarks());
        }
        if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
            monthBudgetChangeVo.setAccumulatedAvailableBalance(monthBudgetDetailEntity.getBeforeAmount());
            monthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.SUBTRACT.getCode());
            monthBudgetChangeVo.setChangeAmount(monthBudgetDetailEntity.getCurOperationAmount());
            monthBudgetChangeVo.setChangeBalance(monthBudgetDetailEntity.getBalanceAmount());
            monthBudgetChangeVo.setChangeRemarks(monthBudgetDetailEntity.getOperationRemarks());
        }
        return monthBudgetChangeVo;
    }

    private List<MonthBudgetEntity> findByDimension(MonthBudgetDto monthBudgetDto) {
        Validate.notNull((Object)monthBudgetDto, (String)"\u67e5\u8be2\u540c\u7ef4\u5ea6\u7684\u6708\u5ea6\u9884\u7b97\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetMapper.findByDimension(monthBudgetDto);
        return monthBudgetEntityList;
    }

    private MonthBudgetDetailDto buildDetail(MonthBudgetEntity monthBudgetEntity, BigDecimal operationAmount, BigDecimal beforeAmount, String operationType, String businessCode) {
        MonthBudgetDetailDto monthBudgetDetailDto = (MonthBudgetDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetEntity, MonthBudgetDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        operationAmount = Objects.isNull(operationAmount) ? BigDecimal.ZERO : operationAmount;
        monthBudgetDetailDto.setId(null);
        monthBudgetDetailDto.setBusinessCode(businessCode);
        monthBudgetDetailDto.setOperationType(operationType);
        monthBudgetDetailDto.setInitialAmount(monthBudgetEntity.getInitResolveAmount());
        monthBudgetDetailDto.setBalanceAmount(monthBudgetEntity.getAccumulatedAvailableBalance());
        if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.RETURN.getCode().equals(operationType) || BudgetOperationTypeEnum.REPLAY.getCode().equals(operationType) || BudgetOperationTypeEnum.PLAN.getCode().equals(operationType) || BudgetOperationTypeEnum.ACTUAL_SALES.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType) || BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType) || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType) || BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType) || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.USE.getCode().equals(operationType) || BudgetOperationTypeEnum.DEDUCTION.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.ADD.getCode().equals(operationType) || BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType) || BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.AUDIT_DIFF.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
        } else if (BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType) || BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType) || BudgetOperationTypeEnum.AUDIT_REJECT.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
            monthBudgetDetailDto.setAlreadyEndCaseAmount(monthBudgetEntity.getAlreadyEndCaseAmount());
            monthBudgetDetailDto.setPlanReturnBudgetYearAndMonth(monthBudgetEntity.getPlanReturnBudgetYearAndMonth());
            monthBudgetDetailDto.setAuditCode(monthBudgetEntity.getAuditCode());
            monthBudgetDetailDto.setRemark(monthBudgetEntity.getLogRemark());
            if (BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
                monthBudgetDetailDto.setChangeAuditAmount(monthBudgetEntity.getChangeAuditAmount());
                monthBudgetDetailDto.setChangeApprovedAuditDiff(monthBudgetEntity.getChangeApprovedAuditDiff());
                monthBudgetDetailDto.setChangeAdjustAmount(monthBudgetEntity.getChangeAdjustAmount());
                monthBudgetDetailDto.setChangeAccumulatedAvailableBalance(monthBudgetEntity.getChangeAccumulatedAvailableBalance());
                monthBudgetDetailDto.setChangeAfterFreezeAmount(monthBudgetEntity.getChangeAfterFreezeAmount());
            }
        } else if (BudgetOperationTypeEnum.IMPORT.getCode().equals(operationType)) {
            monthBudgetDetailDto.setBeforeAmount(beforeAmount);
            operationAmount = monthBudgetDetailDto.getBeforeAmount().subtract(monthBudgetDetailDto.getBalanceAmount()).abs();
        }
        monthBudgetDetailDto.setCurOperationAmount(operationAmount);
        return monthBudgetDetailDto;
    }

    private void updateValidate(MonthBudgetDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        DimensionInformationQueryData dimensionVo = new DimensionInformationQueryData();
        dimensionVo.setBusinessFormatCode(dto.getBusinessFormatCode());
        dimensionVo.setBusinessUnitCode(dto.getBusinessUnitCode());
        dimensionVo.setMenu(MenuCodeEnum.MONTH_BUDGET.getCode());
        dimensionVo.setSalesOrgCodeList(Arrays.asList(dto.getSalesOrgCode()));
        List dimensionVoList = this.dimensionDimensionInformationService.findDetailsByCodes(dimensionVo);
        if (CollectionUtils.isEmpty((Collection)dimensionVoList)) {
            throw new RuntimeException("\u672a\u7ef4\u62a4\u5bf9\u5e94\u7ef4\u5ea6\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Class<MonthBudgetDto> clazz = MonthBudgetDto.class;
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty((CharSequence)informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(dto);
                if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
    }

    public void importSave(MonthBudgetDto monthBudgetDto) {
        MonthBudgetEntity entity = (MonthBudgetEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)monthBudgetDto, MonthBudgetEntity.class, HashSet.class, ArrayList.class, new String[0]));
        List monthCodeList = this.generateCodeService.generateCode("YDYS", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS);
        entity.setMonthBudgetCode((String)monthCodeList.get(0));
        monthBudgetDto.setMonthBudgetCode(entity.getMonthBudgetCode());
        entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM"));
        this.monthBudgetRepository.save((Object)entity);
        MonthBudgetDetailEntity detailEntity = (MonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, MonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        detailEntity.setInitialAmount(entity.getInitResolveAmount());
        detailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
        this.monthBudgetDetailRepository.save((Object)detailEntity);
        MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(monthBudgetDto);
        SerializableBiConsumer & Serializable onCreate = MonthBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MonthBudgetLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, MonthBudgetActualSalesVo> calculateActualSales(List<String> ids) {
        Map<String, MonthBudgetActualSalesVo> salesVos = MonthBudgetActualSalesBuilder.init(ids, this.budgetCalculateStrategies, this.monthBudgetHelper).basic().salesData().builder();
        List monthBudgetEntities = this.monthBudgetRepository.listByIds(ids);
        monthBudgetEntities.forEach(entity -> {
            MonthBudgetActualSalesVo salesVo = (MonthBudgetActualSalesVo)salesVos.get(entity.getMonthBudgetCode());
            if (Objects.isNull(salesVo)) {
                log.info("\u6708\u5ea6\u9884\u7b97[" + entity.getMonthBudgetCode() + "]\u672a\u83b7\u53d6\u5230\u6708\u5ea6\u9884\u7b97\u8ba1\u7b97\u5b9e\u9645\u9500\u91cfVo");
                return;
            }
            BudgetCalConfigVo budgetCalConfigVo = salesVo.getBudgetCalConfigVo();
            log.info("\u6708\u5ea6\u9884\u7b97[" + entity.getMonthBudgetCode() + "]\u6708\u5ea6\u9884\u7b97\u8ba1\u7b97\u5b9e\u9645\u9500\u91cfVo" + JSONObject.toJSONString((Object)salesVo));
            if (Objects.isNull(budgetCalConfigVo)) {
                entity.setBudgetCalCode("");
            } else {
                entity.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
            }
            entity.setBillActualSales(salesVo.getActualSales());
            entity.setActualSales(salesVo.getActualSalesAmount());
            entity.setActualCosts(salesVo.getActualCostsAmount());
        });
        this.monthBudgetRepository.updateBatchById(monthBudgetEntities);
        return salesVos;
    }

    public MonthBudgetVo findCurrMonthBudgetById(String id, String yearMonthLy) {
        MonthBudgetDto dto = new MonthBudgetDto();
        dto.setId(id);
        Date date = DateUtil.parseDate((String)yearMonthLy, (String)"yyyy-MM");
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.add(2, 1);
        dto.setYearMonthLy(DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM"));
        return this.monthBudgetRepository.findCurrMonthBudgetById(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeBudgetVo auditUseBudget(AuditBudgetHeadVo auditBudgetHeadVo) {
        ChangeBudgetVo changeBudgetVo = new ChangeBudgetVo();
        ArrayList<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<OperateMonthBudgetDto>();
        ArrayList subComBudgetForecastDetailDtoList = new ArrayList();
        for (AuditBudgetVo auditBudgetVo : auditBudgetHeadVo.getAuditBudgetVoList()) {
            OperateMonthBudgetDto operateMonthBudgetDto;
            AuditBudgetItemVo auditBudgetItemVo = (AuditBudgetItemVo)auditBudgetVo.getBudgetItems().get(0);
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)auditBudgetHeadVo.getBusinessUnitCode())) {
                operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setOperationAmount(auditBudgetVo.getAmount());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                if (AuditUseBudgetTypeEnum.USE.equals((Object)auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                } else if (AuditUseBudgetTypeEnum.USE_RETURN.equals((Object)auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
                } else {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                }
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(auditBudgetVo.getPlanReturnBudgetYearAndMonth());
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {
                List budgetItems = auditBudgetVo.getBudgetItems();
                operateMonthBudgetDtos.addAll(this.buildBudgetItem(budgetItems, auditBudgetVo));
                if (!CollectionUtils.isEmpty(operateMonthBudgetDtos)) {
                    operateMonthBudgetDtos.forEach(item -> item.setAuditCode(auditBudgetHeadVo.getAuditCode()));
                }
            }
            if (BusinessUnitEnum.ONLINE.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {
                operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setOperationAmount(auditBudgetVo.getAmount());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                if (AuditUseBudgetTypeEnum.USE.equals((Object)auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                } else if (AuditUseBudgetTypeEnum.USE_RETURN.equals((Object)auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
                } else {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                }
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAuditCode(auditBudgetHeadVo.getAuditCode());
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
            }
            if (!BusinessUnitEnum.SON_COMPANY.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) continue;
            if (!CollectionUtils.isEmpty((Collection)auditBudgetVo.getBudgetItems())) {
                operateMonthBudgetDtos.addAll((Collection<OperateMonthBudgetDto>)Objects.requireNonNull(this.buildBudgetSonItem(auditBudgetVo)));
            }
            if (CollectionUtils.isEmpty((Collection)auditBudgetVo.getDesignBudgetItems())) continue;
            subComBudgetForecastDetailDtoList.addAll(Objects.requireNonNull(this.buildForecastBudgetSonItem(auditBudgetVo, changeBudgetVo)));
        }
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(auditBudgetHeadVo.getBusinessUnitCode())) {
            log.info("\u7ed3\u6848\u6838\u9500\u5206\u5b50\u9000\u9884\u7b97operateMonthBudgetDtos:{}", (Object)JsonUtils.obj2JsonString(operateMonthBudgetDtos));
            if (!CollectionUtils.isEmpty(operateMonthBudgetDtos)) {
                List monthBudgetCodes = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).collect(Collectors.toList());
                List subComMonthBudgetVos = this.subComMonthBudgetService.listByBudgetCodeList(monthBudgetCodes);
                Map<String, MonthBudgetControlVo> controlMap = this.mapControlAmountBySonComBudgetList(subComMonthBudgetVos);
                boolean lockSuccess = false;
                List lockKeys = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
                try {
                    lockSuccess = this.subComMonthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 1200);
                    Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                    this.subComMonthBudgetService.operateBudgetByAudit(operateMonthBudgetDtos, controlMap);
                }
                finally {
                    if (lockSuccess) {
                        this.subComMonthBudgetLockService.unlock(lockKeys);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(subComBudgetForecastDetailDtoList)) {
                List budgetForecastCodes = subComBudgetForecastDetailDtoList.stream().map(SubComBudgetForecastDetailDto::getBudgetForecastCode).distinct().collect(Collectors.toList());
                boolean lock = this.subComBudgetForecastService.lock(budgetForecastCodes, TimeUnit.SECONDS, 60);
                Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u5931\u8d25\uff0c\u83b7\u53d6\u64cd\u4f5c\u9501\u5931\u8d25\uff01", (Object[])new Object[0]);
                try {
                    subComBudgetForecastDetailDtoList.forEach(item -> item.setProcessNo(auditBudgetHeadVo.getProcessNo()));
                    this.subComBudgetForecastService.operationBudgetForecast(subComBudgetForecastDetailDtoList);
                }
                finally {
                    this.subComBudgetForecastService.unLock(budgetForecastCodes);
                }
                return changeBudgetVo;
            }
        } else if (!CollectionUtils.isEmpty(operateMonthBudgetDtos)) {
            boolean lock = true;
            List lockKeys = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
            try {
                lock = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 1200);
                if (lock) {
                    this.operateBudget(operateMonthBudgetDtos);
                }
            }
            finally {
                if (lock) {
                    this.monthBudgetLockService.unLock(lockKeys);
                }
            }
        }
        return null;
    }

    private List<SubComBudgetForecastDetailDto> buildForecastBudgetSonItem(AuditBudgetVo auditBudgetVo, ChangeBudgetVo changeBudgetVo) {
        ArrayList<SubComBudgetForecastDetailDto> operateMonthBudgetDtos;
        block24: {
            SonComBugdetDimensionalityDto detailPlanItemVo;
            Object subComBudgetForecastVos;
            BigDecimal budgetCanReturnAmount;
            SubComBudgetForecastDetailDto subComBudgetForecastDetailDto;
            BigDecimal amount;
            block22: {
                List autoFeeVoList;
                block23: {
                    operateMonthBudgetDtos = new ArrayList<SubComBudgetForecastDetailDto>();
                    List designBudgetItems = auditBudgetVo.getDesignBudgetItems();
                    List monthBudgetCodes = designBudgetItems.stream().map(AuditDesignBudgetItemVo::getBudgetForecastCode).collect(Collectors.toList());
                    List subComBudgetForecastVoList = this.subComBudgetForecastService.findListByCodes(monthBudgetCodes);
                    amount = auditBudgetVo.getAmount();
                    if (!AuditUseBudgetTypeEnum.USE.equals((Object)auditBudgetVo.getType())) break block22;
                    List offPointFeeVoList = subComBudgetForecastVoList.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(offPointFeeVoList)) {
                        for (Object subComBudgetForecastVo : offPointFeeVoList) {
                            SubComBudgetForecastDetailDto operateMonthBudgetDto = new SubComBudgetForecastDetailDto();
                            operateMonthBudgetDto.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                            operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                            operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                            operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                            if (amount.compareTo(subComBudgetForecastVo.getRemainderAmount()) <= 0) {
                                operateMonthBudgetDto.setCurOperationAmount(amount);
                                operateMonthBudgetDtos.add(operateMonthBudgetDto);
                                amount = BigDecimal.ZERO;
                                break;
                            }
                            amount = amount.subtract(subComBudgetForecastVo.getRemainderAmount());
                            operateMonthBudgetDto.setCurOperationAmount(subComBudgetForecastVo.getRemainderAmount());
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        }
                    }
                    if (amount.compareTo(BigDecimal.ZERO) == 0) {
                        return operateMonthBudgetDtos;
                    }
                    List internalPointFeeVoList = subComBudgetForecastVoList.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(internalPointFeeVoList)) {
                        for (SubComBudgetForecastVo subComBudgetForecastVo : internalPointFeeVoList) {
                            SubComBudgetForecastDetailDto operateMonthBudgetDto = new SubComBudgetForecastDetailDto();
                            operateMonthBudgetDto.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                            operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                            operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                            operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                            if (amount.compareTo(subComBudgetForecastVo.getRemainderAmount()) <= 0) {
                                operateMonthBudgetDto.setCurOperationAmount(amount);
                                operateMonthBudgetDtos.add(operateMonthBudgetDto);
                                amount = BigDecimal.ZERO;
                                break;
                            }
                            amount = amount.subtract(subComBudgetForecastVo.getRemainderAmount());
                            operateMonthBudgetDto.setCurOperationAmount(subComBudgetForecastVo.getRemainderAmount());
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        }
                    }
                    if (amount.compareTo(BigDecimal.ZERO) == 0) {
                        return operateMonthBudgetDtos;
                    }
                    autoFeeVoList = subComBudgetForecastVoList.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(autoFeeVoList)) break block23;
                    SonComBugdetDimensionalityDto detailPlanItemVo2 = auditBudgetVo.getDetailPlanItemVo();
                    List<SubComBudgetForecastVo> subComBudgetForecastVos2 = this.findAutoFeeForForecast(detailPlanItemVo2);
                    Validate.isTrue((!CollectionUtils.isEmpty(subComBudgetForecastVos2) ? 1 : 0) != 0, (String)"\u5360\u7528\u9884\u7b97\u672a\u67e5\u8be2\u5230\u81ea\u6295\u7684\u9884\u7b97\u9884\u6d4b", (Object[])new Object[0]);
                    if (CollectionUtils.isEmpty(subComBudgetForecastVos2)) break block24;
                    SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVos2.get(0);
                    SubComBudgetForecastDetailDto subComBudgetForecastDetailDto2 = new SubComBudgetForecastDetailDto();
                    subComBudgetForecastDetailDto2.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                    subComBudgetForecastDetailDto2.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    subComBudgetForecastDetailDto2.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    subComBudgetForecastDetailDto2.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    subComBudgetForecastDetailDto2.setCurOperationAmount(amount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto2);
                    if (amount.compareTo(subComBudgetForecastVo.getRemainderAmount()) >= 0) break block24;
                    changeBudgetVo.setIsSpecial(YesOrNoEnum.YES.getCode());
                    break block24;
                }
                SubComBudgetForecastVo subComMonthBudgetVo = (SubComBudgetForecastVo)autoFeeVoList.get(0);
                SubComBudgetForecastDetailDto subComBudgetForecastDetailDto3 = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto3.setBudgetForecastCode(subComMonthBudgetVo.getBudgetForecastCode());
                subComBudgetForecastDetailDto3.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                subComBudgetForecastDetailDto3.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto3.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                subComBudgetForecastDetailDto3.setCurOperationAmount(amount);
                operateMonthBudgetDtos.add(subComBudgetForecastDetailDto3);
                if (amount.compareTo(subComMonthBudgetVo.getRemainderAmount()) >= 0) break block24;
                changeBudgetVo.setIsSpecial(YesOrNoEnum.YES.getCode());
                break block24;
            }
            List designBudgetItemVos = auditBudgetVo.getDesignBudgetItems();
            List autoFeeItems = designBudgetItemVos.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(autoFeeItems)) {
                boolean negativeIsReturn = false;
                for (AuditDesignBudgetItemVo autoFeeItem : autoFeeItems) {
                    subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                    subComBudgetForecastDetailDto.setBudgetForecastCode(autoFeeItem.getBudgetForecastCode());
                    subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                    subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    budgetCanReturnAmount = autoFeeItem.getBudgetAmount();
                    if (!negativeIsReturn && auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0) {
                        negativeIsReturn = true;
                        if ((amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs())).compareTo(budgetCanReturnAmount) <= 0) {
                            subComBudgetForecastDetailDto.setCurOperationAmount(amount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                            operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                            amount = BigDecimal.ZERO;
                            break;
                        }
                        subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                        operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                        amount = amount.subtract(budgetCanReturnAmount);
                        continue;
                    }
                    if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                        subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                        operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                        amount = BigDecimal.ZERO;
                        break;
                    }
                    subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    amount = amount.subtract(budgetCanReturnAmount);
                }
            } else if (auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0 && !CollectionUtils.isEmpty(subComBudgetForecastVos = this.findAutoFeeForForecast(detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo()))) {
                SubComBudgetForecastVo subComMonthBudgetVo = subComBudgetForecastVos.get(0);
                subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto.setBudgetForecastCode(subComMonthBudgetVo.getBudgetForecastCode());
                subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                subComBudgetForecastDetailDto.setCurOperationAmount(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs());
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            List internalPointFeeItems = designBudgetItemVos.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditDesignBudgetItemVo internalPointFeeItem : internalPointFeeItems) {
                subComBudgetForecastDetailDto = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto.setBudgetForecastCode(internalPointFeeItem.getBudgetForecastCode());
                subComBudgetForecastDetailDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                subComBudgetForecastDetailDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                budgetCanReturnAmount = internalPointFeeItem.getBudgetAmount();
                if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                    subComBudgetForecastDetailDto.setCurOperationAmount(amount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                    amount = BigDecimal.ZERO;
                    break;
                }
                subComBudgetForecastDetailDto.setCurOperationAmount(budgetCanReturnAmount);
                operateMonthBudgetDtos.add(subComBudgetForecastDetailDto);
                amount = amount.subtract(budgetCanReturnAmount);
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            List offPointFeeItems = designBudgetItemVos.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditDesignBudgetItemVo offPointFeeItem : offPointFeeItems) {
                SubComBudgetForecastDetailDto subComBudgetForecastDetailDto4 = new SubComBudgetForecastDetailDto();
                subComBudgetForecastDetailDto4.setBudgetForecastCode(offPointFeeItem.getBudgetForecastCode());
                subComBudgetForecastDetailDto4.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                subComBudgetForecastDetailDto4.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                subComBudgetForecastDetailDto4.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                BigDecimal budgetCanReturnAmount2 = offPointFeeItem.getBudgetAmount();
                if (amount.compareTo(budgetCanReturnAmount2) <= 0) {
                    subComBudgetForecastDetailDto4.setCurOperationAmount(amount);
                    operateMonthBudgetDtos.add(subComBudgetForecastDetailDto4);
                    break;
                }
                subComBudgetForecastDetailDto4.setCurOperationAmount(budgetCanReturnAmount2);
                operateMonthBudgetDtos.add(subComBudgetForecastDetailDto4);
                amount = amount.subtract(budgetCanReturnAmount2);
            }
        }
        return operateMonthBudgetDtos;
    }

    private List<SubComBudgetForecastVo> findAutoFeeForForecast(SonComBugdetDimensionalityDto detailPlanItemVo) {
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setBusinessFormatCode(detailPlanItemVo.getBusinessFormatCode());
        subComBudgetForecastDto.setOrgCode(detailPlanItemVo.getOrgCode());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        subComBudgetForecastDto.setYearMonthLy(df.format(detailPlanItemVo.getFeeYearMonth()));
        subComBudgetForecastDto.setBusinessUnitCode(detailPlanItemVo.getBusinessUnitCode());
        subComBudgetForecastDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        return this.subComBudgetForecastService.findListByConditions(subComBudgetForecastDto);
    }

    private Map<String, MonthBudgetControlVo> mapControlAmountBySonComBudgetList(List<SubComMonthBudgetVo> monthBudgetList) {
        if (CollectionUtils.isEmpty(monthBudgetList)) {
            return new HashMap<String, MonthBudgetControlVo>();
        }
        HashMap<String, MonthBudgetControlVo> amountMap = new HashMap<String, MonthBudgetControlVo>();
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
        monthBudgetList.forEach(monthBudgetEntity -> {
            MonthBudgetControlVo monthBudgetControlVo = new MonthBudgetControlVo();
            monthBudgetControlVo.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());
            List<DimensionControlsVo> collect = dimensionControlsVos.stream().filter(vo -> monthBudgetEntity.getBusinessUnitCode().equals(vo.getBusinessUnitCode())).collect(Collectors.toList());
            DimensionControlsVo sameItemControlsVo = null;
            DimensionControlsVo dimensionControlsVo = null;
            MonthBudgetEntity monthBudgetEntity1 = (MonthBudgetEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetEntity, MonthBudgetEntity.class, null, null, new String[0])));
            sameItemControlsVo = this.findSameItemControlConfig(monthBudgetEntity1, collect);
            dimensionControlsVo = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)sameItemControlsVo) ? this.findControlConfig(monthBudgetEntity1, collect) : sameItemControlsVo;
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dimensionControlsVo)) {
                monthBudgetControlVo.setControlSituation(ControlSituationEnum.SUBMISSION_ISNOT_ALLOWED.getCode());
                amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
                return;
            }
            monthBudgetControlVo.setIfRolling(dimensionControlsVo.getIfRolling());
            monthBudgetControlVo.setControlsCaliber(dimensionControlsVo.getControlsCaliber());
            amountMap.put(monthBudgetEntity.getMonthBudgetCode(), monthBudgetControlVo);
        });
        return amountMap;
    }

    private List<OperateMonthBudgetDto> buildBudgetSonItem(AuditBudgetVo auditBudgetVo) {
        ArrayList<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<OperateMonthBudgetDto>();
        List budgetItems = auditBudgetVo.getBudgetItems();
        List monthBudgetCodes = budgetItems.stream().map(AuditBudgetItemVo::getMonthBudgetCode).collect(Collectors.toList());
        List subComMonthBudgetVoList = this.subComMonthBudgetService.listByBudgetCodeList(monthBudgetCodes);
        List designBudgetItems = auditBudgetVo.getDesignBudgetItems();
        List budgetForecastCodes = designBudgetItems.stream().map(AuditDesignBudgetItemVo::getBudgetForecastCode).collect(Collectors.toList());
        List subComBudgetForecastVoList = this.subComBudgetForecastService.findListByCodes(budgetForecastCodes);
        Map subComBudgetForecastVoMap = subComBudgetForecastVoList.stream().collect(Collectors.toMap(o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode() + o.getBudgetItemCode(), Function.identity()));
        BigDecimal amount = auditBudgetVo.getAmount();
        if (AuditUseBudgetTypeEnum.USE.equals((Object)auditBudgetVo.getType())) {
            OperateMonthBudgetDto operateMonthBudgetDto;
            List offPointFeeVoList = subComMonthBudgetVoList.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(offPointFeeVoList)) {
                for (Object subComMonthBudgetVo : offPointFeeVoList) {
                    OperateMonthBudgetDto operateMonthBudgetDto2 = new OperateMonthBudgetDto();
                    operateMonthBudgetDto2.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                    operateMonthBudgetDto2.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto2.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto2.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto2.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    SubComBudgetForecastVo subComBudgetForecastVo = (SubComBudgetForecastVo)subComBudgetForecastVoMap.get(subComMonthBudgetVo.getYearMonthLy() + subComMonthBudgetVo.getBusinessFormatCode() + subComMonthBudgetVo.getBusinessUnitCode() + subComMonthBudgetVo.getOrgCode() + subComMonthBudgetVo.getFeeSourceCode() + subComMonthBudgetVo.getBudgetItemCode());
                    Validate.notNull((Object)subComBudgetForecastVo, (String)"\u6708\u5ea6\u9884\u7b97\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9884\u7b97\u9884\u6d4b", (Object[])new Object[]{subComMonthBudgetVo.getMonthBudgetCode()});
                    BigDecimal balance = subComBudgetForecastVo.getRemainderAmount();
                    if (amount.compareTo(balance) <= 0) {
                        operateMonthBudgetDto2.setOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto2);
                        amount = BigDecimal.ZERO;
                        break;
                    }
                    amount = amount.subtract(balance);
                    operateMonthBudgetDto2.setOperationAmount(balance);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto2);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            List internalPointFeeVoList = subComMonthBudgetVoList.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(internalPointFeeVoList)) {
                for (SubComMonthBudgetVo subComMonthBudgetVo : internalPointFeeVoList) {
                    operateMonthBudgetDto = new OperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    SubComBudgetForecastVo subComBudgetForecastVo = (SubComBudgetForecastVo)subComBudgetForecastVoMap.get(subComMonthBudgetVo.getYearMonthLy() + subComMonthBudgetVo.getBusinessFormatCode() + subComMonthBudgetVo.getBusinessUnitCode() + subComMonthBudgetVo.getOrgCode() + subComMonthBudgetVo.getFeeSourceCode() + subComMonthBudgetVo.getBudgetItemCode());
                    Validate.notNull((Object)subComBudgetForecastVo, (String)"\u6708\u5ea6\u9884\u7b97\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9884\u7b97\u9884\u6d4b", (Object[])new Object[]{subComMonthBudgetVo.getMonthBudgetCode()});
                    BigDecimal balance = subComBudgetForecastVo.getRemainderAmount();
                    if (amount.compareTo(balance) <= 0) {
                        operateMonthBudgetDto.setOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = BigDecimal.ZERO;
                        break;
                    }
                    amount = amount.subtract(balance);
                    operateMonthBudgetDto.setOperationAmount(balance);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            List autoFeeVoList = subComMonthBudgetVoList.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(autoFeeVoList)) {
                SonComBugdetDimensionalityDto detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo();
                List<SubComMonthBudgetVo> subComMonthBudgetVos = this.findAutoFee(detailPlanItemVo);
                if (!CollectionUtils.isEmpty(subComMonthBudgetVos)) {
                    SubComMonthBudgetVo subComMonthBudgetVo = subComMonthBudgetVos.get(0);
                    OperateMonthBudgetDto operateMonthBudgetDto3 = new OperateMonthBudgetDto();
                    operateMonthBudgetDto3.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                    operateMonthBudgetDto3.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto3.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                    operateMonthBudgetDto3.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto3.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    operateMonthBudgetDto3.setOperationAmount(amount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto3);
                }
            } else {
                SubComMonthBudgetVo subComMonthBudgetVo;
                subComMonthBudgetVo = (SubComMonthBudgetVo)autoFeeVoList.get(0);
                operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setOperationAmount(amount);
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
            }
        } else {
            SonComBugdetDimensionalityDto detailPlanItemVo;
            Object subComMonthBudgetVos;
            BigDecimal budgetCanReturnAmount;
            OperateMonthBudgetDto operateMonthBudgetDto;
            List returnBudgetItems = auditBudgetVo.getBudgetItems();
            List autoFeeItems = returnBudgetItems.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(autoFeeItems)) {
                boolean negativeIsReturn = false;
                for (AuditBudgetItemVo autoFeeItem : autoFeeItems) {
                    operateMonthBudgetDto = new OperateMonthBudgetDto();
                    operateMonthBudgetDto.setMonthBudgetCode(autoFeeItem.getMonthBudgetCode());
                    operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                    operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                    operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                    budgetCanReturnAmount = autoFeeItem.getUseAmount().subtract(Optional.ofNullable(autoFeeItem.getCloseAmount()).orElse(BigDecimal.ZERO));
                    if (!negativeIsReturn && auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0) {
                        negativeIsReturn = true;
                        if ((amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs())).compareTo(budgetCanReturnAmount) <= 0) {
                            operateMonthBudgetDto.setOperationAmount(amount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                            operateMonthBudgetDtos.add(operateMonthBudgetDto);
                            amount = BigDecimal.ZERO;
                            break;
                        }
                        operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount.add(auditBudgetVo.getAlreadyEndCaseAmount().abs()));
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = amount.subtract(budgetCanReturnAmount);
                        continue;
                    }
                    if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                        operateMonthBudgetDto.setOperationAmount(amount);
                        operateMonthBudgetDtos.add(operateMonthBudgetDto);
                        amount = BigDecimal.ZERO;
                        break;
                    }
                    operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    amount = amount.subtract(budgetCanReturnAmount);
                }
            } else if (auditBudgetVo.getAlreadyEndCaseAmount().compareTo(BigDecimal.ZERO) < 0 && !CollectionUtils.isEmpty(subComMonthBudgetVos = this.findAutoFee(detailPlanItemVo = auditBudgetVo.getDetailPlanItemVo()))) {
                SubComMonthBudgetVo subComMonthBudgetVo = subComMonthBudgetVos.get(0);
                operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(subComMonthBudgetVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                operateMonthBudgetDto.setOperationAmount(auditBudgetVo.getAlreadyEndCaseAmount().abs());
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
                amount = amount.subtract(auditBudgetVo.getAlreadyEndCaseAmount().abs());
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            List internalPointFeeItems = returnBudgetItems.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditBudgetItemVo internalPointFeeItem : internalPointFeeItems) {
                operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setMonthBudgetCode(internalPointFeeItem.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                budgetCanReturnAmount = internalPointFeeItem.getUseAmount().subtract(Optional.ofNullable(internalPointFeeItem.getCloseAmount()).orElse(BigDecimal.ZERO));
                if (amount.compareTo(budgetCanReturnAmount) <= 0) {
                    operateMonthBudgetDto.setOperationAmount(amount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto);
                    amount = BigDecimal.ZERO;
                    break;
                }
                operateMonthBudgetDto.setOperationAmount(budgetCanReturnAmount);
                operateMonthBudgetDtos.add(operateMonthBudgetDto);
                amount = amount.subtract(budgetCanReturnAmount);
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return operateMonthBudgetDtos;
            }
            List offPointFeeItems = returnBudgetItems.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
            for (AuditBudgetItemVo offPointFeeItem : offPointFeeItems) {
                OperateMonthBudgetDto operateMonthBudgetDto4 = new OperateMonthBudgetDto();
                operateMonthBudgetDto4.setMonthBudgetCode(offPointFeeItem.getMonthBudgetCode());
                operateMonthBudgetDto4.setBudgetType(MonthBudgetTypeEnum.SUB_COM_MONTH_BUDGET.getCode());
                operateMonthBudgetDto4.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                operateMonthBudgetDto4.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto4.setAlreadyEndCaseAmount(auditBudgetVo.getAlreadyEndCaseAmount());
                BigDecimal budgetCanReturnAmount2 = offPointFeeItem.getUseAmount().subtract(Optional.ofNullable(offPointFeeItem.getCloseAmount()).orElse(BigDecimal.ZERO));
                if (amount.compareTo(budgetCanReturnAmount2) <= 0) {
                    operateMonthBudgetDto4.setOperationAmount(amount);
                    operateMonthBudgetDtos.add(operateMonthBudgetDto4);
                    break;
                }
                operateMonthBudgetDto4.setOperationAmount(budgetCanReturnAmount2);
                operateMonthBudgetDtos.add(operateMonthBudgetDto4);
                amount = amount.subtract(budgetCanReturnAmount2);
            }
        }
        return operateMonthBudgetDtos;
    }

    private List<SubComMonthBudgetVo> findAutoFee(SonComBugdetDimensionalityDto detailPlanItemVo) {
        SubComMonthBudgetDto subComMonthBudgetDto = new SubComMonthBudgetDto();
        subComMonthBudgetDto.setBusinessFormatCode(detailPlanItemVo.getBusinessFormatCode());
        subComMonthBudgetDto.setBusinessUnitCode(detailPlanItemVo.getBusinessUnitCode());
        subComMonthBudgetDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        subComMonthBudgetDto.setBudgetItemCode("A023");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        subComMonthBudgetDto.setYearMonthLy(df.format(detailPlanItemVo.getFeeYearMonth()));
        subComMonthBudgetDto.setSalesInstitutionCode(detailPlanItemVo.getSalesInstitutionCode());
        subComMonthBudgetDto.setSalesRegionCode(detailPlanItemVo.getSalesOrgCode());
        subComMonthBudgetDto.setSalesOrgCode(detailPlanItemVo.getSalesGroupCode());
        subComMonthBudgetDto.setOrgCode(detailPlanItemVo.getOrgCode());
        subComMonthBudgetDto.setChannelCode(detailPlanItemVo.getChannelCode());
        subComMonthBudgetDto.setCustomerCode(detailPlanItemVo.getCustomerCode());
        subComMonthBudgetDto.setTerminalCode(detailPlanItemVo.getTerminalCode());
        subComMonthBudgetDto.setProductBrandCode(detailPlanItemVo.getProductBrandCode());
        subComMonthBudgetDto.setProductCategoryCode(detailPlanItemVo.getProductCategoryCode());
        subComMonthBudgetDto.setProductItemCode(detailPlanItemVo.getProductItemCode());
        subComMonthBudgetDto.setProductCode(detailPlanItemVo.getProductCode());
        List subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
        if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
            subComMonthBudgetDto.setProductCode(null);
            subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
            if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                subComMonthBudgetDto.setProductItemCode(null);
                subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                    subComMonthBudgetDto.setProductCategoryCode(null);
                    subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                    if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                        subComMonthBudgetDto.setProductBrandCode(null);
                        subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                        if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                            subComMonthBudgetDto.setTerminalCode(null);
                            subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                            if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                                subComMonthBudgetDto.setCustomerCode(null);
                                subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                                if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                                    subComMonthBudgetDto.setChannelCode(null);
                                    subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                                    if (CollectionUtils.isEmpty((Collection)subComMonthBudgetVos)) {
                                        subComMonthBudgetDto.setOrgCode(null);
                                        subComMonthBudgetVos = this.subComMonthBudgetService.findListByCondition(subComMonthBudgetDto);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return subComMonthBudgetVos;
    }

    private List<OperateMonthBudgetDto> buildBudgetItem(List<AuditBudgetItemVo> budgetItems, AuditBudgetVo auditBudgetVo) {
        List<MonthBudgetDetailVo> monthBudgetDetailVoList;
        LinkedList<OperateMonthBudgetDto> operateMonthBudgetDtoList = new LinkedList<OperateMonthBudgetDto>();
        Map<Object, Object> monthBudgetDetailVoMap = new HashMap();
        if (Objects.nonNull(auditBudgetVo.getOverBudgetAmount()) && auditBudgetVo.getOverBudgetAmount().compareTo(BigDecimal.ZERO) != 0 && !CollectionUtils.isEmpty(monthBudgetDetailVoList = this.monthBudgetDetailService.findListByDetailPlanItemCodes(auditBudgetVo.getDetailPlanItemCodes()))) {
            monthBudgetDetailVoMap = monthBudgetDetailVoList.stream().collect(Collectors.groupingBy(MonthBudgetDetailVo::getMonthBudgetCode));
        }
        if (AuditUseBudgetTypeEnum.USE.equals((Object)auditBudgetVo.getType())) {
            List<String> monthBudgetCodes = budgetItems.stream().map(AuditBudgetItemVo::getMonthBudgetCode).collect(Collectors.toList());
            List<MonthBudgetVo> monthBudgetVos = this.listByCodes(monthBudgetCodes);
            Map monthBudgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            List regionReferendumBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_REFERENDUM.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            LinkedList useBudget = new LinkedList(regionReferendumBudget);
            List headBudget = budgetItems.stream().filter(o -> FeeBelongEnum.HEAD.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            useBudget.addAll(headBudget);
            List regionAutomaticBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(regionAutomaticBudget)) {
                regionAutomaticBudget = regionAutomaticBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).reversed().thenComparing(AuditBudgetItemVo::getMonthBudgetCode)).collect(Collectors.toList());
                useBudget.addAll(regionAutomaticBudget);
            } else {
                ActivityDetailPlanItemVo2 planItemVo = auditBudgetVo.getPlanItemVo();
                MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
                monthBudgetDto.setRegionCode(planItemVo.getRegion());
                SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
                monthBudgetDto.setYearMonthLy(yearMonthFormat.format(planItemVo.getFeeYearMonth()));
                monthBudgetDto.setSystemCode(planItemVo.getSystemCode());
                monthBudgetDto.setBudgetItemCode("C0023");
                List<MonthBudgetVo> monthBudgetVoList = this.findListByConditions(monthBudgetDto);
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)monthBudgetVoList) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u9884\u7b97\u9879\u76ee\u4e3a\u4ea7\u54c1\u4fc3\u9500-\u5782\u76f4\u7684\u6708\u5ea6\u9884\u7b97", (Object[])new Object[0]);
                useBudget.add(this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetVoList.get(0), AuditBudgetItemVo.class, null, null, new String[0]));
            }
            int regionAutomaticCount = (int)useBudget.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).count();
            int count = 0;
            BigDecimal useAmount = auditBudgetVo.getAmount();
            for (AuditBudgetItemVo auditBudgetItemVo : useBudget) {
                MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetVoMap.get(auditBudgetItemVo.getMonthBudgetCode());
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_USE.getCode());
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                BigDecimal itemUseAmount = Optional.ofNullable(auditBudgetItemVo.getUseAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(auditBudgetItemVo.getRollbackAmount()).orElse(BigDecimal.ZERO));
                List monthBudgetDetailVos = (List)monthBudgetDetailVoMap.get(auditBudgetItemVo.getMonthBudgetCode());
                if (!CollectionUtils.isEmpty((Collection)monthBudgetDetailVos)) {
                    itemUseAmount = itemUseAmount.add(monthBudgetDetailVos.stream().map(MonthBudgetDetailVo::getCurOperationAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                }
                if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(auditBudgetItemVo.getFeeBelongCode())) {
                    ++count;
                    if (useAmount.compareTo(BigDecimal.ZERO) != 0) {
                        if (count == regionAutomaticCount) {
                            operateMonthBudgetDto.setOperationAmount(useAmount);
                            itemUseAmount = itemUseAmount.add(useAmount);
                            useAmount = BigDecimal.ZERO;
                        } else if (useAmount.compareTo(monthBudgetVo.getAccumulatedAvailableBalance()) <= 0) {
                            operateMonthBudgetDto.setOperationAmount(useAmount);
                            itemUseAmount = itemUseAmount.add(useAmount);
                            useAmount = BigDecimal.ZERO;
                        } else {
                            operateMonthBudgetDto.setOperationAmount(monthBudgetVo.getAccumulatedAvailableBalance());
                            itemUseAmount = itemUseAmount.add(monthBudgetVo.getAccumulatedAvailableBalance());
                            useAmount = useAmount.subtract(monthBudgetVo.getAccumulatedAvailableBalance());
                        }
                    }
                }
                operateMonthBudgetDto.setAlreadyEndCaseAmount(itemUseAmount);
                operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(auditBudgetVo.getPlanReturnBudgetYearAndMonth());
                operateMonthBudgetDtoList.add(operateMonthBudgetDto);
            }
        } else {
            List regionAutomaticBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            regionAutomaticBudget = regionAutomaticBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).thenComparing(AuditBudgetItemVo::getMonthBudgetCode).reversed()).collect(Collectors.toList());
            LinkedList returnBudget = new LinkedList(regionAutomaticBudget);
            List regionReferendumBudget = budgetItems.stream().filter(o -> FeeBelongEnum.REGION_REFERENDUM.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            regionReferendumBudget = regionReferendumBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).thenComparing(AuditBudgetItemVo::getMonthBudgetCode).reversed()).collect(Collectors.toList());
            returnBudget.addAll(regionReferendumBudget);
            List headBudget = budgetItems.stream().filter(o -> FeeBelongEnum.HEAD.getCode().equals(o.getFeeBelongCode())).collect(Collectors.toList());
            headBudget = headBudget.stream().sorted(Comparator.comparing(AuditBudgetItemVo::getUseAmount).thenComparing(AuditBudgetItemVo::getMonthBudgetCode).reversed()).collect(Collectors.toList());
            returnBudget.addAll(headBudget);
            BigDecimal returnAmount = auditBudgetVo.getAmount();
            BigDecimal alreadyEndCaseAmount = auditBudgetVo.getAlreadyEndCaseAmount();
            for (AuditBudgetItemVo auditBudgetItemVo : returnBudget) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
                operateMonthBudgetDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                operateMonthBudgetDto.setMonthBudgetCode(auditBudgetItemVo.getMonthBudgetCode());
                operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                if (AuditUseBudgetTypeEnum.RETURN.equals((Object)auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_RETURN.getCode());
                } else if (AuditUseBudgetTypeEnum.USE_RETURN.equals((Object)auditBudgetVo.getType())) {
                    operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
                }
                operateMonthBudgetDto.setBusinessCode(auditBudgetVo.getAuditDetailCode());
                operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(auditBudgetVo.getPlanReturnBudgetYearAndMonth());
                BigDecimal useAmount = Optional.ofNullable(auditBudgetItemVo.getUseAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(auditBudgetItemVo.getRollbackAmount()).orElse(BigDecimal.ZERO));
                List monthBudgetDetailVos = (List)monthBudgetDetailVoMap.get(auditBudgetItemVo.getMonthBudgetCode());
                if (!CollectionUtils.isEmpty((Collection)monthBudgetDetailVos)) {
                    useAmount = useAmount.add(monthBudgetDetailVos.stream().map(MonthBudgetDetailVo::getCurOperationAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                }
                BigDecimal useMinusReturnAmount = BigDecimal.ZERO;
                if (returnAmount.compareTo(BigDecimal.ZERO) != 0) {
                    if (returnAmount.compareTo(useAmount) <= 0) {
                        operateMonthBudgetDto.setOperationAmount(returnAmount);
                        useMinusReturnAmount = useAmount.subtract(returnAmount);
                        returnAmount = BigDecimal.ZERO;
                    } else {
                        operateMonthBudgetDto.setOperationAmount(useAmount);
                        returnAmount = returnAmount.subtract(useAmount);
                    }
                }
                if (returnAmount.compareTo(BigDecimal.ZERO) == 0) {
                    if (useMinusReturnAmount.compareTo(BigDecimal.ZERO) > 0) {
                        operateMonthBudgetDto.setAlreadyEndCaseAmount(useMinusReturnAmount);
                        alreadyEndCaseAmount = alreadyEndCaseAmount.subtract(useMinusReturnAmount);
                    } else {
                        if (alreadyEndCaseAmount.compareTo(useAmount) <= 0) {
                            operateMonthBudgetDto.setAlreadyEndCaseAmount(alreadyEndCaseAmount);
                            operateMonthBudgetDtoList.add(operateMonthBudgetDto);
                            break;
                        }
                        operateMonthBudgetDto.setAlreadyEndCaseAmount(useAmount);
                        alreadyEndCaseAmount = alreadyEndCaseAmount.subtract(useAmount);
                    }
                }
                operateMonthBudgetDtoList.add(operateMonthBudgetDto);
            }
        }
        return operateMonthBudgetDtoList;
    }

    private Map<String, DimensionControlsVo> mapDimensionControl(List<String> monthBudgetCodeList) {
        if (CollectionUtils.isEmpty(monthBudgetCodeList)) {
            return new HashMap<String, DimensionControlsVo>();
        }
        List<MonthBudgetEntity> monthBudgetList = this.monthBudgetRepository.getByMonthBudgetCodes(monthBudgetCodeList, EnableStatusEnum.ENABLE.getCode());
        return this.mapDimensionControlByBudgetList(monthBudgetList);
    }

    private Map<String, DimensionControlsVo> mapDimensionControlByBudgetList(List<MonthBudgetEntity> monthBudgetList) {
        if (CollectionUtils.isEmpty(monthBudgetList)) {
            return new HashMap<String, DimensionControlsVo>();
        }
        HashMap returnMap = Maps.newHashMap();
        DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
        dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
        dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
        monthBudgetList.forEach(monthBudgetEntity -> {
            List<DimensionControlsVo> collect = dimensionControlsVos.stream().filter(vo -> monthBudgetEntity.getBusinessUnitCode().equals(vo.getBusinessUnitCode())).collect(Collectors.toList());
            DimensionControlsVo sameItemControlsVo = null;
            DimensionControlsVo dimensionControlsVo = null;
            if (BusinessUnitEnum.VERTICAL.getCode().equals(monthBudgetEntity.getBusinessUnitCode()) || BusinessUnitEnum.isDefaultBusinessUnit((String)monthBudgetEntity.getBusinessUnitCode()) || BusinessUnitEnum.ONLINE.getCode().equals(monthBudgetEntity.getBusinessUnitCode())) {
                sameItemControlsVo = this.findSameItemControlConfig((MonthBudgetEntity)((Object)monthBudgetEntity), collect);
            }
            dimensionControlsVo = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)sameItemControlsVo) ? this.findControlConfig((MonthBudgetEntity)((Object)monthBudgetEntity), collect) : sameItemControlsVo;
            returnMap.put(monthBudgetEntity.getMonthBudgetCode(), dimensionControlsVo);
        });
        return returnMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void calculateActualReplyDiff(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget) {
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)actualSalesVo.getBusinessUnitCode());
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)actualSalesVo.getBusinessUnitCode())) {
            businessUnitEnum = BusinessUnitEnum.HEADQUARTERS;
        }
        BusinessUnitEnum finalBusinessUnitEnum = businessUnitEnum;
        this.budgetCalculateStrategies.forEach(strategy -> {
            if (finalBusinessUnitEnum.getCode().equals(strategy.getBusinessUnit())) {
                strategy.calculation(actualSalesVo, currMonthBudget);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u9009\u62e9\u7684\u6570\u636eids\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List<MonthBudgetDetailVo> detailVos = this.monthBudgetDetailRepository.findByMainIds(ids);
        if (!CollectionUtils.isEmpty(detailVos)) {
            throw new IllegalArgumentException("[" + detailVos.get(0).getMonthBudgetCode() + "]\u6708\u5ea6\u9884\u7b97\uff0c\u5b58\u5728\u64cd\u4f5c\u7c7b\u578b\u4e0d\u4e3a\u2018\u671f\u521d\u2019\u7684\u5176\u4ed6\u4f7f\u7528\u660e\u7ec6\uff0c\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6");
        }
        this.monthBudgetRepository.deleteBatch(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void calHeadYearTotalAvailableBalanceSyncXxlJob(String yearMonth) {
        if (StringUtils.isBlank((CharSequence)yearMonth)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.strToDate((String)yearMonth, (SimpleDateFormat)DateUtil.date_yyyy_MM));
        int month = calendar.get(2);
        ArrayList<String> businessUnitCodeList = new ArrayList<String>();
        businessUnitCodeList.add(BusinessUnitEnum.HEADQUARTERS.getCode());
        List<MonthBudgetEntity> entities = this.monthBudgetRepository.listByYearMonth(yearMonth, businessUnitCodeList);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        ArrayList<MonthBudgetEntity> updateList = new ArrayList<MonthBudgetEntity>();
        for (MonthBudgetEntity entity : entities) {
            MonthBudgetEntity e;
            int i;
            List<MonthBudgetEntity> list = this.monthBudgetRepository.listByYearBudgetCode(entity.getYearBudgetCode());
            if (CollectionUtils.isEmpty(list) || list.size() < 12) {
                log.error("\u901a\u8fc7\u5e74\u5ea6\u9884\u7b97\u7f16\u7801\u672a\u83b7\u53d612\u6708\u7684\u6708\u5ea6\u9884\u7b97\uff0c\u5e74\u5ea6\u9884\u7b97\u7f16\u7801={}", (Object)entity.getYearBudgetCode());
                continue;
            }
            list = list.stream().sorted(Comparator.comparing(MonthBudgetEntity::getYearMonthLy)).collect(Collectors.toList());
            List conditionVos = this.budgetItemControlConditionVoService.findByCode(entity.getBudgetItemCode());
            if (CollectionUtils.isEmpty((Collection)conditionVos)) {
                log.error("\u901a\u8fc7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u672a\u67e5\u627e\u5230\u9884\u7b97\u7ba1\u63a7\u6761\u4ef6\uff0c\u9884\u7b97\u9879\u76ee\u7f16\u7801={}", (Object)entity.getBudgetItemCode());
                continue;
            }
            MonthBudgetEntity newEn = new MonthBudgetEntity();
            newEn.setId(entity.getId());
            BigDecimal totalBalance = BigDecimal.ZERO;
            String controlTypeCode = ((BudgetItemControlConditionVo)conditionVos.get(0)).getControlTypeCode();
            if (BudgetControlTypeEnum.AMOUNT.getCode().equals(controlTypeCode)) {
                BigDecimal yearTotalBalance = BigDecimal.ZERO;
                for (i = 0; i < list.size(); ++i) {
                    e = list.get(i);
                    yearTotalBalance = i <= month ? yearTotalBalance.add(Optional.ofNullable(e.getInitResolveAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO)) : yearTotalBalance.add(Optional.ofNullable(e.getInitResolveAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                }
                newEn.setYearTotalAvailableAmount(yearTotalBalance);
                totalBalance = yearTotalBalance;
            } else if (BudgetControlTypeEnum.RATIO.getCode().equals(controlTypeCode) || BudgetControlTypeEnum.INTENSITY.getCode().equals(controlTypeCode)) {
                BigDecimal yearTotalBalance = BigDecimal.ZERO;
                for (i = 0; i < list.size(); ++i) {
                    e = list.get(i);
                    if (i <= month) {
                        yearTotalBalance = null != e.getActualSales() && BigDecimal.ZERO.compareTo(e.getActualSales()) != 0 ? yearTotalBalance.add(e.getActualSales()) : yearTotalBalance.add(Optional.ofNullable(e.getFirstReplyAmount()).orElse(BigDecimal.ZERO));
                        yearTotalBalance = yearTotalBalance.subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                        continue;
                    }
                    yearTotalBalance = yearTotalBalance.add(Optional.ofNullable(e.getInitResolveAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(e.getApprovedAmount()).orElse(BigDecimal.ZERO));
                }
                newEn.setYearTotalAvailableAmount(yearTotalBalance);
                totalBalance = yearTotalBalance;
            }
            log.error("\u6708\u5ea6\u9884\u7b97\u7f16\u7801={}\uff0c\u5e74\u5ea6\u7d2f\u8ba1\u53ef\u7528\u4f59\u989d={}", (Object)entity.getMonthBudgetCode(), (Object)newEn.getYearTotalAvailableAmount());
            updateList.add(newEn);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 < month) continue;
                MonthBudgetEntity e2 = list.get(i2);
                MonthBudgetEntity en = new MonthBudgetEntity();
                en.setId(e2.getId());
                en.setYearTotalAvailableAmount(totalBalance);
                updateList.add(en);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.monthBudgetRepository.updateBatchById(updateList);
        }
    }

    public List<MonthBudgetDetailVo> findDetailByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return Lists.newArrayList();
        }
        return this.monthBudgetDetailRepository.findByBusinessCodes(businessCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String auditUseRetrunOperateBudget(List<String> auditDetailCodes, String auditCode) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return null;
        }
        List<MonthBudgetDetailVo> monthBudgetDetailVos = this.monthBudgetDetailService.findListByBusiness(auditDetailCodes, auditCode);
        if (CollectionUtils.isEmpty(monthBudgetDetailVos)) {
            return null;
        }
        log.info("\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u901a\u8fc7,\u9a73\u56de\u9000\u9884\u7b97-1:{},monthBudgetDetailVos:{}", (Object)auditCode, (Object)JsonUtils.obj2JsonString(monthBudgetDetailVos));
        ArrayList<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<OperateMonthBudgetDto>();
        for (MonthBudgetDetailVo monthBudgetDetailVo : monthBudgetDetailVos) {
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto();
            operateMonthBudgetDto.setMonthBudgetCode(monthBudgetDetailVo.getMonthBudgetCode());
            operateMonthBudgetDto.setOperationAmount(monthBudgetDetailVo.getCurOperationAmount());
            operateMonthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
            operateMonthBudgetDto.setOperationType(BudgetOperationTypeEnum.AUDIT_REJECT.getCode());
            operateMonthBudgetDto.setBusinessCode(monthBudgetDetailVo.getBusinessCode());
            operateMonthBudgetDto.setBusinessUnitCode(monthBudgetDetailVo.getMonthBudgetCode());
            operateMonthBudgetDto.setAlreadyEndCaseAmount(monthBudgetDetailVo.getAlreadyEndCaseAmount());
            operateMonthBudgetDto.setPlanReturnBudgetYearAndMonth(monthBudgetDetailVo.getPlanReturnBudgetYearAndMonth());
            operateMonthBudgetDto.setChangeAuditAmount(monthBudgetDetailVo.getChangeAuditAmount());
            operateMonthBudgetDto.setChangeApprovedAuditDiff(monthBudgetDetailVo.getChangeApprovedAuditDiff());
            operateMonthBudgetDto.setChangeAdjustAmount(monthBudgetDetailVo.getChangeAdjustAmount());
            operateMonthBudgetDto.setChangeAccumulatedAvailableBalance(monthBudgetDetailVo.getChangeAccumulatedAvailableBalance());
            operateMonthBudgetDto.setChangeAfterFreezeAmount(monthBudgetDetailVo.getChangeAfterFreezeAmount());
            operateMonthBudgetDtos.add(operateMonthBudgetDto);
        }
        boolean lock = true;
        List lockKeys = operateMonthBudgetDtos.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
        try {
            lock = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 1200);
            if (lock) {
                this.operateBudget(operateMonthBudgetDtos);
                this.monthBudgetDetailService.updateStatusByBusiness(monthBudgetDetailVos);
            }
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(lockKeys);
            }
        }
        return monthBudgetDetailVos.get(0).getBusinessCode();
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> saveBatchForOut(List<MonthBudgetDto> monthBudgetDtoList) {
        if (CollectionUtils.isEmpty(monthBudgetDtoList)) {
            return null;
        }
        Set yearBudgetCodeList = monthBudgetDtoList.stream().map(MonthBudgetDto::getYearBudgetCode).collect(Collectors.toSet());
        this.delByYearBudgetCode(Lists.newArrayList(yearBudgetCodeList));
        ArrayList<MonthBudgetEntity> monthBudgetEntities = new ArrayList<MonthBudgetEntity>(this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetDtoList, MonthBudgetDto.class, MonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        monthBudgetEntities.forEach(entity -> entity.setYearMonthDate(DateUtil.parseDate((String)entity.getYearMonthLy(), (String)"yyyy-MM")));
        this.monthBudgetRepository.saveBatch(monthBudgetEntities);
        this.buildInitDetail(monthBudgetEntities);
        monthBudgetDtoList.forEach(dto -> {
            MonthBudgetLogEventDto logEventDto = new MonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = MonthBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MonthBudgetLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
        return monthBudgetEntities.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    public List<MonthBudgetVo> findBudgetByMonthBudgetCodes(List<String> monthBudgetCodes) {
        if (CollectionUtils.isEmpty(monthBudgetCodes)) {
            return Lists.newArrayList();
        }
        List<MonthBudgetEntity> list = this.monthBudgetRepository.listByCodes(monthBudgetCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, MonthBudgetEntity.class, MonthBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void updateAndRoll(List<MonthBudgetDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> ids = dtoList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List monthBudgetCodeList = monthBudgetEntityList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getMonthBudgetCode())).map(MonthBudgetEntity::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lockSuccess = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MINUTES, 10);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            Map<String, List<DimensionControlsVo>> dimensionControlMap = this.monthBudgetHelper.findDimensionControl();
            Map<String, List<DimensionControlsVo>> dimensionControlMap2 = this.monthBudgetHelper.findDimensionControlNoSalesOrg();
            Map dtoMap = dtoList.stream().collect(Collectors.toMap(MonthBudgetDto::getMonthBudgetCode, Function.identity(), (n, o) -> n));
            monthBudgetEntityList.stream().sorted(Comparator.comparing(MonthBudgetEntity::getYearMonthLy)).forEach(entity -> {
                DimensionControlsVo dimensionControlsVo;
                String dimensionControlKey;
                MonthBudgetDto budgetDto = (MonthBudgetDto)dtoMap.get(entity.getMonthBudgetCode());
                if (!Objects.isNull(budgetDto.getCalAmount())) {
                    entity.setCalAmount(budgetDto.getCalAmount());
                }
                if (!Objects.isNull(budgetDto.getFirstReplyAmount())) {
                    entity.setFirstReplyAmount(budgetDto.getFirstReplyAmount());
                }
                if (!Objects.isNull(budgetDto.getFirstReplyResolveDiffAmount())) {
                    entity.setFirstReplyResolveDiffAmount(budgetDto.getFirstReplyResolveDiffAmount());
                }
                if (!Objects.isNull(budgetDto.getLastMonthRollingAmount())) {
                    entity.setLastMonthRollingAmount(budgetDto.getLastMonthRollingAmount());
                }
                if (!Objects.isNull(budgetDto.getActualSales())) {
                    entity.setActualSales(budgetDto.getActualSales());
                }
                List dimensionControlsVos = null;
                if (FeeBelongEnum.HEAD.getCode().equals(entity.getFeeBelongCode())) {
                    dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode();
                    dimensionControlsVos = (List)dimensionControlMap2.get(dimensionControlKey);
                } else {
                    dimensionControlKey = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getSalesOrgCode();
                    dimensionControlsVos = (List)dimensionControlMap.get(dimensionControlKey);
                }
                boolean rollTag = false;
                String rollingType = null;
                if (!CollectionUtils.isEmpty((Collection)dimensionControlsVos) && null != (dimensionControlsVo = this.monthBudgetHelper.matchDimensionControl(dimensionControlsVos, entity.getBudgetItemCode())) && StringUtils.isNotBlank((CharSequence)dimensionControlsVo.getIfRolling()) && BooleanEnum.TRUE.getCapital().equals(dimensionControlsVo.getIfRolling())) {
                    LocalDate lastLocalDate;
                    String lastYearMonth;
                    MonthBudgetEntity lastMonthBudget;
                    rollTag = true;
                    rollingType = dimensionControlsVo.getRollingType();
                    String yearMonthLy = entity.getYearMonthLy();
                    String[] yearMonthArray = yearMonthLy.split("-");
                    LocalDate currMonthBudgetLocalDate = LocalDate.of(Integer.parseInt(yearMonthArray[0]), Integer.parseInt(yearMonthArray[1]), 1);
                    int monthValue = currMonthBudgetLocalDate.getMonthValue();
                    if (monthValue != 1 && null != (lastMonthBudget = this.monthBudgetRepository.findByYearMonthAndYearBudgetCode(lastYearMonth = (lastLocalDate = currMonthBudgetLocalDate.minusMonths(1L)).format(DateTimeFormatter.ofPattern("yyyy-MM")), entity.getYearBudgetCode())) && null != lastMonthBudget.getAccumulatedAvailableBalance() && BigDecimal.ZERO.compareTo(lastMonthBudget.getAccumulatedAvailableBalance()) != 0) {
                        BigDecimal lastBalance = lastMonthBudget.getAccumulatedAvailableBalance();
                        lastMonthBudget.setMonthRollingAmount(lastBalance);
                        lastMonthBudget.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(lastMonthBudget, BusinessUnitEnum.HEADQUARTERS));
                        lastMonthBudget.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(lastMonthBudget, BusinessUnitEnum.HEADQUARTERS));
                        MonthBudgetDetailEntity detailEntity = this.monthBudgetHelper.buildDetail(lastMonthBudget, lastBalance, lastBalance, BudgetOperationTypeEnum.ROLLING.getCode(), null);
                        this.monthBudgetDetailRepository.save((Object)detailEntity);
                        this.monthBudgetRepository.updateById((Object)lastMonthBudget);
                    }
                }
                this.updateMonthBudget((MonthBudgetEntity)((Object)entity));
                if (!Objects.isNull(entity.getFirstReplyAmount()) && !Objects.isNull(entity.getActualSales())) {
                    BigDecimal diffAmount = entity.getActualSales().subtract(entity.getFirstReplyAmount()).setScale(6, 4);
                    entity.setActualReplyDiff(diffAmount);
                    if (BigDecimal.ZERO.compareTo(diffAmount) == 0) {
                        this.monthBudgetRepository.updateById(entity);
                        return;
                    }
                    Date date = DateUtil.strToDate((String)entity.getYearMonthLy(), (SimpleDateFormat)DateUtil.date_yyyy_MM);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    Date currDate = DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM);
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(currDate);
                    String curryearMonth = DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM);
                    if (calendar.get(1) != calendar2.get(1)) {
                        log.error("\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee-\u300b\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u5e74");
                        return;
                    }
                    boolean roll = false;
                    if (rollTag && StringUtils.isNotBlank((CharSequence)rollingType)) {
                        if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType)) {
                            roll = true;
                        }
                        if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType) && BigDecimal.ZERO.compareTo(diffAmount) < 0) {
                            roll = true;
                        }
                        if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType) && BigDecimal.ZERO.compareTo(diffAmount) > 0) {
                            roll = true;
                        }
                    }
                    DateUtil.getCurrentMonth();
                    if (roll) {
                        if (currDate.getTime() <= date.getTime()) {
                            log.error("\u8ba1\u7b97\u5b9e\u9500\u56de\u590d\u5dee-\u300b\u5f53\u524d\u5e74\u6708\u5fc5\u987b\u5927\u4e8e\u9009\u62e9\u7684\u9884\u7b97\u5e74\u6708");
                            return;
                        }
                        MonthBudgetEntity currEntity = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(entity.getYearBudgetCode(), curryearMonth);
                        this.monthBudgetRepository.updateById(entity);
                        String businessCode = currEntity.getMonthBudgetCode() + DateUtil.getDate((String)"yyyyMM");
                        MonthBudgetDetailVo monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode);
                        if (Objects.isNull(monthBudgetDetailVo)) {
                            BigDecimal beforeAmount = currEntity.getAccumulatedAvailableBalance();
                            currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                            currEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                            currEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                            MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(currEntity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                            this.monthBudgetDetailRepository.save((Object)detailEntity);
                            this.monthBudgetRepository.updateById((Object)currEntity);
                        } else {
                            BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
                            if (histOperationAmount.compareTo(diffAmount) != 0) {
                                BigDecimal beforeAmount = currEntity.getAccumulatedAvailableBalance();
                                currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(histOperationAmount));
                                currEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                currEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                MonthBudgetDetailEntity histDetailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(currEntity, histOperationAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                                this.monthBudgetDetailRepository.save((Object)histDetailEntity);
                                BigDecimal beforeAmount2 = currEntity.getAccumulatedAvailableBalance();
                                currEntity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                                currEntity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                currEntity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(currEntity, BusinessUnitEnum.VERTICAL));
                                MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead(currEntity, diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount2);
                                this.monthBudgetDetailRepository.save((Object)detailEntity);
                                this.monthBudgetRepository.updateById((Object)currEntity);
                            }
                        }
                    } else {
                        String businessCode = entity.getMonthBudgetCode() + DateUtil.getDate((String)"yyyyMM");
                        MonthBudgetDetailVo monthBudgetDetailVo = this.monthBudgetDetailRepository.findByBusinessCode(businessCode);
                        if (Objects.isNull(monthBudgetDetailVo)) {
                            BigDecimal beforeAmount = entity.getAccumulatedAvailableBalance();
                            entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                            entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline((MonthBudgetEntity)((Object)entity), BusinessUnitEnum.VERTICAL));
                            entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline((MonthBudgetEntity)((Object)entity), BusinessUnitEnum.VERTICAL));
                            MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead((MonthBudgetEntity)((Object)entity), diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                            this.monthBudgetDetailRepository.save((Object)detailEntity);
                            this.monthBudgetRepository.updateById(entity);
                        } else {
                            BigDecimal histOperationAmount = monthBudgetDetailVo.getCurOperationAmount();
                            if (histOperationAmount.compareTo(diffAmount) != 0) {
                                BigDecimal beforeAmount = entity.getAccumulatedAvailableBalance();
                                entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(histOperationAmount));
                                entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline((MonthBudgetEntity)((Object)entity), BusinessUnitEnum.VERTICAL));
                                entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline((MonthBudgetEntity)((Object)entity), BusinessUnitEnum.VERTICAL));
                                MonthBudgetDetailEntity histDetailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead((MonthBudgetEntity)((Object)entity), histOperationAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount);
                                this.monthBudgetDetailRepository.save((Object)histDetailEntity);
                                BigDecimal beforeAmount2 = entity.getAccumulatedAvailableBalance();
                                entity.setAdjustAmount(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(diffAmount));
                                entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline((MonthBudgetEntity)((Object)entity), BusinessUnitEnum.VERTICAL));
                                entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline((MonthBudgetEntity)((Object)entity), BusinessUnitEnum.VERTICAL));
                                MonthBudgetDetailEntity detailEntity = this.monthBudgetCalculateHelper.buildActualReplyDiffDetailHead((MonthBudgetEntity)((Object)entity), diffAmount, BudgetOperationTypeEnum.ACTUAL_SALES.getCode(), businessCode, beforeAmount2);
                                this.monthBudgetDetailRepository.save((Object)detailEntity);
                                this.monthBudgetRepository.updateById(entity);
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.monthBudgetLockService.unLock(monthBudgetCodeList);
        }
    }

    public Page<MonthBudgetVo> auditAdjustFindBudget(Pageable pageable, String customerCode) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        MonthBudgetDto dto = new MonthBudgetDto();
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isNotEmpty((CharSequence)customerCode)) {
            CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, customerCode);
            if (RtmModelCodeEnum.SON_COMPANY.getCode().equals(customerVo.getRtmModelCode())) {
                dto.setGroupCode(MonthBudgetGroupEnum.customer.getCode());
            } else {
                dto.setGroupCode(MonthBudgetGroupEnum.organization.getCode());
            }
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.monthBudgetRepository.findByConditions((Page<MonthBudgetVo>)page, dto);
    }

    public List<MonthBudgetVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<MonthBudgetEntity> monthBudgetEntityList = this.monthBudgetRepository.getByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull(monthBudgetEntityList, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, MonthBudgetEntity.class, MonthBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public MonthBudgetVo getOneByYearBudgetCodeAndMonth(String yearBudgetCode, String feeYearMonth) {
        if (StringUtils.isEmpty((CharSequence)yearBudgetCode)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)feeYearMonth)) {
            return null;
        }
        MonthBudgetEntity monthBudgetEntity = this.monthBudgetRepository.getOneByYearBudgetCodeAndMonth(yearBudgetCode, feeYearMonth);
        MonthBudgetVo monthBudgetVo = (MonthBudgetVo)this.nebulaToolkitService.copyObjectByBlankList((Object)monthBudgetEntity, MonthBudgetVo.class, null, null, new String[0]);
        return monthBudgetVo;
    }

    public void updateMonthBudget(MonthBudgetEntity entity) {
        BigDecimal balance = entity.getAccumulatedAvailableBalance();
        entity.setAfterFreezeAmount(this.monthBudgetCalculateHelper.buildAfterFreezeAmountHeadquartersAndOnline(entity, BusinessUnitEnum.HEADQUARTERS));
        entity.setAccumulatedAvailableBalance(this.monthBudgetCalculateHelper.buildAccumulatedAvailableBalanceHeadquartersAndOnline(entity, BusinessUnitEnum.HEADQUARTERS));
        MonthBudgetDetailDto detailDto = this.buildDetail(entity, balance, balance, BudgetOperationTypeEnum.IMPORT.getCode(), null);
        this.monthBudgetDetailService.create(detailDto);
        this.monthBudgetRepository.updateById((Object)entity);
    }

    public Page<MonthBudgetVo> findPageForOut(Pageable pageable, MonthBudgetDto dto) {
        return this.monthBudgetRepository.findPageForOut(pageable, dto);
    }

    @Transactional
    public void verticalAreaFeeWarning(List<String> yearMonths) {
        PageRequest pageable;
        Page<VerticalAreaFeeWarningEntity> result;
        this.loginUserService.refreshAuthentication(null);
        ((LambdaUpdateChainWrapper)this.verticalAreaFeeWarningRepository.lambdaUpdate().in(VerticalAreaFeeWarningEntity::getYearMonthLy, yearMonths)).remove();
        int pageSize = 200;
        int current = 1;
        int count = 1;
        while (!Objects.isNull(result = this.verticalAreaFeeWarningRepository.verticalAreaFeeWarning((Pageable)(pageable = PageRequest.of((int)current, (int)pageSize)), yearMonths)) && !CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ++current;
            List salesGoalDtos = result.getRecords().stream().map(e -> new SalesGoalDto((VerticalAreaFeeWarningEntity)((Object)e)){
                final /* synthetic */ VerticalAreaFeeWarningEntity val$e;
                {
                    this.val$e = verticalAreaFeeWarningEntity;
                    this.setYearMonthLy(this.val$e.getYearMonthLy());
                    this.setRegionCode(this.val$e.getRegionCode());
                    this.setSystemCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
            Map salesGoalVoMap = salesGoalVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()}), Function.identity()));
            result.getRecords().forEach(e -> {
                e.setTenantCode(TenantUtils.getTenantCode());
                String key = StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()});
                e.setBudgetSales(BigDecimal.ZERO);
                if (salesGoalVoMap.containsKey(key)) {
                    e.setBudgetSales(((SalesGoalVo)salesGoalVoMap.get(key)).getDeliveryDiscountSalesAmount());
                }
                e.setBudgetPoints(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getBudgetSales()) != 0) {
                    e.setBudgetPoints(e.getInitResolveAmount().divide(e.getBudgetSales(), 4, 4));
                }
                e.setEstimatedFeeAmount(e.getEstimatedDiscountSales().multiply(e.getBudgetPoints()));
            });
            this.verticalAreaFeeWarningRepository.saveOrUpdateBatch(result.getRecords());
            result.getRecords().forEach(e -> {
                VerticalAreaFeeWarningEntity entity = this.verticalAreaFeeWarningRepository.accumulate((VerticalAreaFeeWarningEntity)((Object)e));
                if (Objects.nonNull((Object)entity)) {
                    e.setAccumulateBudgetAmount(entity.getAccumulateBudgetAmount());
                    e.setAccumulateBudgetSales(entity.getAccumulateBudgetSales());
                } else {
                    e.setAccumulateBudgetAmount(BigDecimal.ZERO);
                    e.setAccumulateBudgetSales(BigDecimal.ZERO);
                }
                e.setAccumulateBudgetPoints(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getAccumulateBudgetSales()) != 0) {
                    e.setAccumulateBudgetPoints(e.getAccumulateBudgetAmount().divide(e.getAccumulateBudgetSales(), 4, 4));
                }
                e.setAccumulateUseAmount(e.getAccumulateBudgetAmount());
                e.setAccumulateDiscountAmount(e.getAccumulateDiscountAmount());
                e.setAccumulateResidueAmount(e.getAccumulateBudgetAmount().subtract(e.getAccumulateUseAmount()));
            });
            this.verticalAreaFeeWarningRepository.saveOrUpdateBatch(result.getRecords());
            if (++count <= 1000 && result.hasNext()) continue;
        }
    }

    public List<MonthBudgetVo> findMonthBudgetForVariable(MonthBudgetDto dto) {
        return this.monthBudgetRepository.findMonthBudgetForVariable(dto);
    }

    public List<MonthBudgetVo> findMonthBudgetConditionForVariable(MonthBudgetDto monthBudgetDto) {
        if (Objects.isNull(monthBudgetDto)) {
            return Lists.newArrayList();
        }
        monthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
        List<MonthBudgetVo> list = this.monthBudgetRepository.findMonthBudgetConditionForVariable(monthBudgetDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public MonthBudgetVo findMonthBudgetSumAuditAmount(MonthBudgetDto monthBudgetDto) {
        return this.monthBudgetRepository.findMonthBudgetSumAuditAmount(monthBudgetDto);
    }

    public MonthBudgetVo findMonthBudgetSumInitResolveAmount(MonthBudgetDto monthBudgetDto) {
        return this.monthBudgetRepository.findMonthBudgetSumInitResolveAmount(monthBudgetDto);
    }

    @Transactional
    public void verticalWarningPanel(List<String> yearMonths) {
        PageRequest pageable;
        Page<VerticalWarningPanelEntity> result;
        this.loginUserService.refreshAuthentication(null);
        ((LambdaUpdateChainWrapper)this.verticalWarningPanelRepository.lambdaUpdate().in(VerticalWarningPanelEntity::getYearMonthLy, yearMonths)).remove();
        int pageSize = 200;
        int current = 1;
        int count = 1;
        Map region = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        while (!Objects.isNull(result = this.verticalWarningPanelRepository.verticalWarningPanel((Pageable)(pageable = PageRequest.of((int)current, (int)pageSize)), yearMonths)) && !CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ++current;
            List salesPerformanceDtos = result.getRecords().stream().map(e -> new SalesPerformanceDto((VerticalWarningPanelEntity)((Object)e), region){
                final /* synthetic */ VerticalWarningPanelEntity val$e;
                final /* synthetic */ Map val$region;
                {
                    this.val$e = verticalWarningPanelEntity;
                    this.val$region = map;
                    this.setSalesMonth(this.val$e.getYearMonthLy().replace("-", ""));
                    this.setRegion(this.val$region.getOrDefault(this.val$e.getRegionCode(), "not found"));
                    this.setRetailer(this.val$e.getSystemName());
                }
            }).collect(Collectors.toList());
            List salesPerformanceVos = this.salesPerformanceVoService.findListForFR(salesPerformanceDtos);
            Map salesPerformanceVoMap = salesPerformanceVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getSalesMonth(), e.getRegion(), e.getRetailer()}), Function.identity(), (v1, v2) -> v1));
            List salesDataDtos = result.getRecords().stream().map(e -> new SalesDataDto((VerticalWarningPanelEntity)((Object)e)){
                final /* synthetic */ VerticalWarningPanelEntity val$e;
                {
                    this.val$e = verticalWarningPanelEntity;
                    this.setYearMonth(this.val$e.getYearMonthLy());
                    this.setBusinessArea(this.val$e.getRegionCode());
                    this.setCustomerRetailerCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List salesDataVos = this.invoiceSalesDataVoService.findListForFR(salesDataDtos);
            Map salesDataVoMap = salesDataVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonth(), e.getBusinessArea(), e.getCustomerRetailerCode()}), Function.identity(), (v1, v2) -> v1));
            List salesGoalDtos = result.getRecords().stream().map(e -> new SalesGoalDto((VerticalWarningPanelEntity)((Object)e)){
                final /* synthetic */ VerticalWarningPanelEntity val$e;
                {
                    this.val$e = verticalWarningPanelEntity;
                    this.setYearMonthLy(this.val$e.getYearMonthLy());
                    this.setRegionCode(this.val$e.getRegionCode());
                    this.setSystemCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
            Map salesGoalVoMap = salesGoalVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            List unionKeys = result.getRecords().stream().map(e -> StringUtils.join((Object[])new String[]{e.getLastYear(), e.getRegionCode(), e.getSystemCode(), e.getBudgetItemCode()})).collect(Collectors.toList());
            List lastList = ((LambdaQueryChainWrapper)this.verticalWarningPanelRepository.lambdaQuery().in(VerticalWarningPanelEntity::getUnionKey, unionKeys)).list();
            Map lastMap = lastList.stream().collect(Collectors.toMap(VerticalWarningPanelEntity::getUnionKey, Function.identity(), (v1, v2) -> v1));
            List<MonthBudgetDto> monthBudgetDtos = result.getRecords().stream().map(e -> new MonthBudgetDto((VerticalWarningPanelEntity)((Object)e)){
                final /* synthetic */ VerticalWarningPanelEntity val$e;
                {
                    this.val$e = verticalWarningPanelEntity;
                    this.setYearMonthLy(this.val$e.getYearMonthLy());
                    this.setRegionCode(this.val$e.getRegionCode());
                    this.setSystemCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List<MonthBudgetVo> monthBudgetVos = this.monthBudgetRepository.findListForFR(monthBudgetDtos);
            Map monthMap = monthBudgetVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            result.getRecords().forEach(e -> {
                String key = StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()});
                String key1 = StringUtils.join((Object[])new String[]{e.getYearMonthLy().replace("-", ""), region.getOrDefault(e.getRegionCode(), "not found"), e.getSystemName()});
                e.setDiscountSalesAmount(BigDecimal.ZERO);
                if (salesPerformanceVoMap.containsKey(key1)) {
                    e.setDiscountSalesAmount(((SalesPerformanceVo)salesPerformanceVoMap.get(key1)).getWarehsOutDiscountAmt());
                }
                e.setSalesDiscountAmount(BigDecimal.ZERO);
                if (salesGoalVoMap.containsKey(key)) {
                    e.setSalesDiscountAmount(((SalesGoalVo)salesGoalVoMap.get(key)).getDeliveryDiscountSalesAmount());
                }
                e.setSalesAchievementRate(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0) {
                    e.setSalesAchievementRate(e.getDiscountSalesAmount().divide(e.getSalesDiscountAmount(), 4, 4));
                }
                e.setPosFeeRate(BigDecimal.ZERO);
                if (monthMap.containsKey(key) && salesDataVoMap.containsKey(key)) {
                    BigDecimal pos = (BigDecimal)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)((SalesDataVo)salesDataVoMap.get(key)).getSalesAmount(), (Object)BigDecimal.ZERO);
                    BigDecimal use = (BigDecimal)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)((MonthBudgetVo)monthMap.get(key)).getApprovedAmount(), (Object)BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(pos) != 0) {
                        e.setPosFeeRate(use.divide(pos, 4, 4));
                    }
                }
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setCurrentRate(BigDecimal.ZERO);
                e.setVsBudget(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0) {
                    e.setCurrentRate(((BigDecimal)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)e.getBudgetUseAmount(), (Object)BigDecimal.ZERO)).divide(e.getSalesDiscountAmount(), 4, 4));
                    e.setVsBudget(e.getCurrentRate().subtract(e.getInitResolveAmount().divide(e.getSalesDiscountAmount(), 4, 4)));
                }
                e.setUnionKey(StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode(), e.getBudgetItemCode()}));
                e.setVsTq(BigDecimal.ZERO);
                String last = StringUtils.join((Object[])new String[]{e.getLastYear(), e.getRegionCode(), e.getSystemCode(), e.getBudgetItemCode()});
                if (lastMap.containsKey(last)) {
                    e.setVsTq(e.getCurrentRate().subtract(((VerticalWarningPanelEntity)((Object)((Object)lastMap.get(last)))).getCurrentRate()));
                }
            });
            this.verticalWarningPanelRepository.saveOrUpdateBatch(result.getRecords());
            List<VerticalWarningPanelEntity> panelList = this.verticalWarningPanelRepository.findListForFR(yearMonths);
            if (!CollectionUtils.isEmpty(panelList)) {
                List totalUnionKeys = panelList.stream().map(e -> StringUtils.join((Object[])new String[]{e.getLastYear(), e.getRegionCode(), e.getSystemCode(), "total"})).collect(Collectors.toList());
                List totalLastList = ((LambdaQueryChainWrapper)this.verticalWarningPanelRepository.lambdaQuery().in(VerticalWarningPanelEntity::getUnionKey, totalUnionKeys)).list();
                Map totalLastMap = totalLastList.stream().collect(Collectors.toMap(VerticalWarningPanelEntity::getUnionKey, Function.identity(), (v1, v2) -> v1));
                panelList.forEach(panel -> {
                    panel.setBudgetItemCode("total");
                    panel.setBudgetItemName("\u8d39\u7528\u5408\u8ba1");
                    panel.setTenantCode(TenantUtils.getTenantCode());
                    panel.setCurrentRate(BigDecimal.ZERO);
                    panel.setVsBudget(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(panel.getSalesDiscountAmount()) != 0) {
                        panel.setCurrentRate(panel.getBudgetUseAmount().divide(panel.getSalesDiscountAmount(), 4, 4));
                        panel.setVsBudget(panel.getCurrentRate().subtract(panel.getInitResolveAmount().divide(panel.getSalesDiscountAmount(), 4, 4)));
                    }
                    panel.setUnionKey(StringUtils.join((Object[])new String[]{panel.getYearMonthLy(), panel.getRegionCode(), panel.getSystemCode(), panel.getBudgetItemCode()}));
                    panel.setVsTq(BigDecimal.ZERO);
                    String last = StringUtils.join((Object[])new String[]{panel.getLastYear(), panel.getRegionCode(), panel.getSystemCode(), panel.getBudgetItemCode()});
                    if (totalLastMap.containsKey(last)) {
                        panel.setVsTq(panel.getCurrentRate().subtract(((VerticalWarningPanelEntity)((Object)((Object)totalLastMap.get(last)))).getCurrentRate()));
                    }
                });
                this.verticalWarningPanelRepository.saveOrUpdateBatch(panelList);
            }
            if (++count <= 1000 && result.hasNext()) continue;
        }
    }
}

