/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetCallBackService;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubComMonthBudgetCallBackServiceImpl
implements SubComMonthBudgetCallBackService {
    private static final Logger log = LoggerFactory.getLogger(SubComMonthBudgetCallBackServiceImpl.class);
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private SubComMonthBudgetRepository subComMonthBudgetRepository;
    @Resource
    private MonthBudgetLockService monthBudgetLockService;
    @Resource
    private SubComMonthBudgetDetailRepository subComMonthBudgetDetailRepository;
    @Resource
    private SubComMonthBudgetDetailService subComMonthBudgetDetailService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustPass(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(subComMonthBudgetDetailEntityList, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List monthBudgetCodeList = subComMonthBudgetDetailEntityList.stream().map(SubComMonthBudgetDetailEntity::getMonthBudgetCode).collect(Collectors.toList());
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lock, (String)"\u9884\u7b97\u8c03\u6574\u5931\u8d25\uff0c\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            subComMonthBudgetDetailEntityList.forEach(subComMonthBudgetDetailEntity -> {
                subComMonthBudgetDetailEntity.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
                SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(subComMonthBudgetDetailEntity.getMonthBudgetCode(), null);
                if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetDetailEntity.setBeforeAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetDetailEntity.setBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
                }
                if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                }
                this.subComMonthBudgetRepository.updateById((Object)subComMonthBudgetEntity);
            });
            this.subComMonthBudgetDetailRepository.updateBatchById(subComMonthBudgetDetailEntityList);
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    private SubComMonthBudgetDetailDto buildDetail(SubComMonthBudgetEntity subComMonthBudgetEntity, BigDecimal operationAmount, String operationType, String businessCode) {
        SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = (SubComMonthBudgetDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        subComMonthBudgetDetailDto.setId(null);
        subComMonthBudgetDetailDto.setBudgetItemCode(businessCode);
        subComMonthBudgetDetailDto.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
        subComMonthBudgetDetailDto.setOperationType(operationType);
        if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType) || BudgetOperationTypeEnum.ADD.getCode().equals(operationType) || BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType) || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType) || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        }
        subComMonthBudgetDetailDto.setCurOperationAmount(operationAmount);
        subComMonthBudgetDetailDto.setBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
        return subComMonthBudgetDetailDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void adjustRejectAndRecover(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(subComMonthBudgetDetailEntityList, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List monthBudgetCodeList = subComMonthBudgetDetailEntityList.stream().map(SubComMonthBudgetDetailEntity::getMonthBudgetCode).collect(Collectors.toList());
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lock, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u9884\u7b97\u8c03\u6574\u5931\u8d25\uff0c\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            subComMonthBudgetDetailEntityList.forEach(subComMonthBudgetDetailEntity -> {
                subComMonthBudgetDetailEntity.setProcessStatus(dto.getProcessStatus());
                SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(subComMonthBudgetDetailEntity.getMonthBudgetCode(), null);
                if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                }
                if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                }
                this.subComMonthBudgetRepository.updateById((Object)subComMonthBudgetEntity);
                if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, subComMonthBudgetDetailEntity.getCurOperationAmount(), BudgetOperationTypeEnum.RELEASE.getCode(), null);
                    this.subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
                }
            });
            this.subComMonthBudgetDetailRepository.updateBatchById(subComMonthBudgetDetailEntityList);
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePass(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(subComMonthBudgetDetailEntityList, (String)"\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List monthBudgetCodeList = subComMonthBudgetDetailEntityList.stream().map(SubComMonthBudgetDetailEntity::getMonthBudgetCode).collect(Collectors.toList());
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lock, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u9884\u7b97\u53d8\u66f4\u5931\u8d25\uff0c\u5f53\u524d\u53d8\u66f4\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            subComMonthBudgetDetailEntityList.forEach(subComMonthBudgetDetailEntity -> {
                subComMonthBudgetDetailEntity.setProcessStatus(dto.getProcessStatus());
                SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(subComMonthBudgetDetailEntity.getMonthBudgetCode(), null);
                if (BudgetOperationTypeEnum.ADD.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetDetailEntity.setBeforeAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetDetailEntity.setBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
                }
                if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                }
                this.subComMonthBudgetRepository.updateById((Object)subComMonthBudgetEntity);
            });
            this.subComMonthBudgetDetailRepository.updateBatchById(subComMonthBudgetDetailEntityList);
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeRejectAndRecover(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessNo(), (String)"\u56de\u8c03\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailRepository.listByProcessNo(dto.getProcessNo());
        Validate.notEmpty(subComMonthBudgetDetailEntityList, (String)"\u56de\u8c03\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u5ba1\u6279\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List monthBudgetCodeList = subComMonthBudgetDetailEntityList.stream().map(SubComMonthBudgetDetailEntity::getMonthBudgetCode).collect(Collectors.toList());
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lock, (String)"\u9884\u7b97\u8c03\u6574\u5931\u8d25\uff0c\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            subComMonthBudgetDetailEntityList.forEach(subComMonthBudgetDetailEntity -> {
                subComMonthBudgetDetailEntity.setProcessStatus(dto.getProcessStatus());
                SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(subComMonthBudgetDetailEntity.getMonthBudgetCode(), null);
                if (BudgetOperationTypeEnum.ADD.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                }
                if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                    subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(subComMonthBudgetDetailEntity.getCurOperationAmount()).orElse(BigDecimal.ZERO)));
                }
                this.subComMonthBudgetRepository.updateById((Object)subComMonthBudgetEntity);
                if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
                    SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, subComMonthBudgetDetailEntity.getCurOperationAmount(), BudgetOperationTypeEnum.RELEASE.getCode(), null);
                    this.subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
                }
            });
            this.subComMonthBudgetDetailRepository.updateBatchById(subComMonthBudgetDetailEntityList);
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }
    }

    @Override
    public void transferPass(ProcessStatusDto dto) {
    }

    @Override
    public void transferRejectAndRecover(ProcessStatusDto dto) {
    }
}

