/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetDetailMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComMonthBudgetDetailServiceImpl
implements SubComMonthBudgetDetailService {
    private static final Logger log = LoggerFactory.getLogger(SubComMonthBudgetDetailServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComMonthBudgetDetailMapper subComMonthBudgetDetailMapper;
    @Autowired(required=false)
    private SubComMonthBudgetDetailRepository subComMonthBudgetDetailRepository;

    @Override
    public Page<SubComMonthBudgetDetailVo> findByConditions(Pageable pageable, SubComMonthBudgetDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SubComMonthBudgetDetailDto();
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComMonthBudgetDetailMapper.findByConditions((Page<SubComMonthBudgetDetailVo>)page, dto);
    }

    @Override
    public void create(SubComMonthBudgetDetailDto detailDto) {
        if (ObjectUtils.isEmpty((Object)detailDto)) {
            return;
        }
        SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = (SubComMonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailDto, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        subComMonthBudgetDetailEntity.setId(null);
        subComMonthBudgetDetailEntity.setTenantCode(TenantUtils.getTenantCode());
        subComMonthBudgetDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        subComMonthBudgetDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.subComMonthBudgetDetailRepository.save((Object)subComMonthBudgetDetailEntity);
    }

    @Override
    public void createList(List<SubComMonthBudgetDetailDto> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, SubComMonthBudgetDetailDto.class, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        entityList.forEach(item -> item.setId(null));
        this.subComMonthBudgetDetailRepository.saveBatch(entityList);
    }

    @Override
    public List<SubComMonthBudgetDetailEntity> listByMonthBudgetCode(String monthBudgetCode) {
        if (StringUtils.isEmpty((CharSequence)monthBudgetCode)) {
            return Lists.newArrayList();
        }
        return this.subComMonthBudgetDetailRepository.listByMonthBudgetCode(monthBudgetCode);
    }
}

