/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.RollingTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.entity.SubComMonthBudgetPlanBudgetEntity;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetMapper;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetDetailRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetPlanBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.repository.SubComMonthBudgetRepository;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetLogService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetExamineCircularQueryDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetAdjustDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetLogEventDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetOperateDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetPlanBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetTransferDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetTransferDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.ControlsCaliberEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.DataSourceEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.month.budget.sdk.event.SubComMonthBudgetLogEventListener;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetControlVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetExamineCircularQueryVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetChangeVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetMainAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetPlanBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SubComMonthBudgetServiceImpl
implements SubComMonthBudgetService {
    private static final Logger log = LoggerFactory.getLogger(SubComMonthBudgetServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private SubComMonthBudgetMapper subComMonthBudgetMapper;
    @Autowired(required=false)
    private DimensionControlsService dimensionControlsService;
    @Autowired(required=false)
    private SubComMonthBudgetRepository subComMonthBudgetRepository;
    @Autowired(required=false)
    private SubComMonthBudgetDetailService subComMonthBudgetDetailService;
    @Autowired(required=false)
    private SubComMonthBudgetDetailRepository subComMonthBudgetDetailRepository;
    @Autowired(required=false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;
    @Autowired(required=false)
    private SubComMonthBudgetPlanBudgetRepository subComMonthBudgetPlanBudgetRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SubComMonthBudgetServiceImpl subComMonthBudgetService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SubComMonthBudgetLogService subComMonthBudgetLogService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;

    public Page<SubComMonthBudgetVo> findByConditions(Pageable pageable, SubComMonthBudgetDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SubComMonthBudgetDto();
        }
        Page<SubComMonthBudgetVo> page = new Page<SubComMonthBudgetVo>((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page = this.subComMonthBudgetMapper.findByConditions(page, dto);
        this.convertSubComMonthBudgetProperty(page.getRecords());
        return page;
    }

    public void convertSubComMonthBudgetProperty(List<SubComMonthBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_source");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                log.error("\u5206\u516c\u53f8\u8d39\u7528\u6765\u6e90\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (SubComMonthBudgetVo vo : list) {
            if (!StringUtils.isNotEmpty((CharSequence)vo.getFeeSourceCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeSourceCode(), vo.getFeeSourceCode()));
        }
    }

    public SubComMonthBudgetVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)((Object)subComMonthBudgetEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (SubComMonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public SubComMonthBudgetVo create(SubComMonthBudgetDto dto) {
        this.createValidate(dto);
        SubComMonthBudgetEntity subComMonthBudgetEntity = (SubComMonthBudgetEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        subComMonthBudgetEntity.setDataSource(DataSourceEnum.MANUAL.getCode());
        subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getBudgetAmount());
        this.subComMonthBudgetRepository.saveOrUpdate((Object)subComMonthBudgetEntity);
        this.buildInitDetail(subComMonthBudgetEntity);
        dto.setId(subComMonthBudgetEntity.getId());
        SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = SubComMonthBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComMonthBudgetLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (SubComMonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void buildInitDetail(SubComMonthBudgetEntity subComMonthBudgetEntity) {
        SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = (SubComMonthBudgetDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        subComMonthBudgetDetailEntity.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
        subComMonthBudgetDetailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
        this.subComMonthBudgetDetailRepository.save((Object)subComMonthBudgetDetailEntity);
    }

    private void createValidate(SubComMonthBudgetDto dto) {
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.findByDimension(dto);
        if (!CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u9884\u7b97\u7ef4\u5ea6\u5df2\u5b58\u5728");
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setMonthBudgetCode((String)this.generateCodeService.generateCode("FZYDYS", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS).get(0));
        dto.setCurrentBalanceAmount(dto.getBudgetAmount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public SubComMonthBudgetVo update(SubComMonthBudgetDto dto) {
        this.updateValidate(dto);
        boolean lockFlag = false;
        try {
            lockFlag = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, 5);
            Assert.isTrue((boolean)lockFlag, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            SubComMonthBudgetVo subComMonthBudgetVo = this.findById(dto.getId());
            Validate.isTrue((!DataSourceEnum.AUTO.getCode().equals(subComMonthBudgetVo.getDataSource()) ? 1 : 0) != 0, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u4e0d\u5141\u8bb8\u7f16\u8f91", (Object[])new Object[0]);
            SubComMonthBudgetDto oldVo = (SubComMonthBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetVo, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            SubComMonthBudgetEntity subComMonthBudgetEntity = (SubComMonthBudgetEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getBudgetAmount());
            this.subComMonthBudgetRepository.saveOrUpdate((Object)subComMonthBudgetEntity);
            SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onUpdate = SubComMonthBudgetLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComMonthBudgetLogEventListener.class, (SerializableBiConsumer)onUpdate);
            SubComMonthBudgetVo subComMonthBudgetVo2 = (SubComMonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return subComMonthBudgetVo2;
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void adjust(SubComMonthBudgetAdjustDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getAdjustOutBudgetCode(), (String)"\u8c03\u51fa\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAdjustOutAmount(), (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getAdjustInBudgetCode(), (String)"\u8c03\u5165\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList<String> lockKeys = new ArrayList<String>();
        lockKeys.add(dto.getAdjustOutBudgetCode());
        lockKeys.add(dto.getAdjustInBudgetCode());
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u9884\u7b97\u8c03\u6574\u5931\u8d25\uff0c\u5f53\u524d\u8c03\u5165\u3001\u8c03\u51fa\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            SubComMonthBudgetEntity adjustInEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getAdjustInBudgetCode(), null);
            Validate.notNull((Object)((Object)adjustInEntity), (String)"\u8c03\u5165\u65b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            SubComMonthBudgetEntity adjustOutEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getAdjustOutBudgetCode(), null);
            Validate.notNull((Object)((Object)adjustOutEntity), (String)"\u8c03\u51fa\u65b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((!DataSourceEnum.AUTO.getCode().equals(adjustOutEntity.getDataSource()) ? 1 : 0) != 0, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u4e0d\u5141\u8bb8\u8c03\u6574", (Object[])new Object[0]);
            if (Optional.ofNullable(adjustOutEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getAdjustOutAmount()) < 0) {
                throw new RuntimeException("\u6708\u5ea6\u9884\u7b97[" + dto.getAdjustOutBudgetCode() + "]\u7684\u8c03\u51fa\u91d1\u989d" + dto.getAdjustOutAmount().setScale(4, RoundingMode.HALF_UP) + "\u4e0d\u80fd\u5927\u4e8e\u672c\u671f\u7ed3\u4f59\u4f59\u989d" + Optional.ofNullable(adjustOutEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP));
            }
            adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustOutEntity.setCurrentBalanceAmount(Optional.ofNullable(adjustOutEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
            adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
            this.subComMonthBudgetRepository.updateById((Object)adjustOutEntity);
            this.subComMonthBudgetRepository.updateById((Object)adjustInEntity);
            String processNo = this.adjustSubmit(dto);
            SubComMonthBudgetDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, dto.getAdjustOutAmount(), BudgetOperationTypeEnum.ADJUST_OUT.getCode(), null);
            adjustOutDetailDto.setProcessNo(processNo);
            adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            this.subComMonthBudgetDetailService.create(adjustOutDetailDto);
            SubComMonthBudgetDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustOutAmount(), BudgetOperationTypeEnum.ADJUST_IN.getCode(), null);
            adjustInDetailDto.setProcessNo(processNo);
            adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            this.subComMonthBudgetDetailService.create(adjustInDetailDto);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    public SubComMonthBudgetMainAdjustVo adjustQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComMonthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        SubComMonthBudgetMainAdjustVo subComMonthBudgetMainAdjustVo = new SubComMonthBudgetMainAdjustVo();
        subComMonthBudgetDetailEntityList.forEach(monthBudgetDetailEntity -> {
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(monthBudgetDetailEntity.getMonthBudgetCode(), null);
            SubComMonthBudgetAdjustVo subComMonthBudgetAdjustVo = (SubComMonthBudgetAdjustVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetAdjustVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
                subComMonthBudgetAdjustVo.setCurrentBalanceAmount(monthBudgetDetailEntity.getBeforeAmount());
                subComMonthBudgetAdjustVo.setAdjustInAmount(monthBudgetDetailEntity.getCurOperationAmount());
                subComMonthBudgetAdjustVo.setAdjustInBalance(subComMonthBudgetAdjustVo.getCurrentBalanceAmount().add(monthBudgetDetailEntity.getCurOperationAmount()));
                subComMonthBudgetMainAdjustVo.setAdjustInVo(subComMonthBudgetAdjustVo);
            }
            if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(monthBudgetDetailEntity.getOperationType())) {
                subComMonthBudgetAdjustVo.setCurrentBalanceAmount(monthBudgetDetailEntity.getBeforeAmount());
                subComMonthBudgetAdjustVo.setAdjustOutAmount(monthBudgetDetailEntity.getCurOperationAmount());
                subComMonthBudgetAdjustVo.setAdjustOutBalance(monthBudgetDetailEntity.getBalanceAmount());
                subComMonthBudgetMainAdjustVo.setAdjustOutVo(subComMonthBudgetAdjustVo);
            }
        });
        return subComMonthBudgetMainAdjustVo;
    }

    public SubComMonthBudgetChangeVo changeQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComMonthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = subComMonthBudgetDetailEntityList.get(0);
        SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(subComMonthBudgetDetailEntity.getMonthBudgetCode(), null);
        SubComMonthBudgetChangeVo subComMonthBudgetChangeVo = (SubComMonthBudgetChangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetChangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (BudgetOperationTypeEnum.ADD.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
            subComMonthBudgetChangeVo.setCurrentBalanceAmount(subComMonthBudgetDetailEntity.getBeforeAmount());
            subComMonthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.ADD.getCode());
            subComMonthBudgetChangeVo.setChangeAmount(subComMonthBudgetDetailEntity.getCurOperationAmount());
            subComMonthBudgetChangeVo.setChangeBalance(subComMonthBudgetDetailEntity.getBalanceAmount().add(subComMonthBudgetDetailEntity.getCurOperationAmount()));
        }
        if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(subComMonthBudgetDetailEntity.getOperationType())) {
            subComMonthBudgetChangeVo.setCurrentBalanceAmount(subComMonthBudgetDetailEntity.getBeforeAmount());
            subComMonthBudgetChangeVo.setOperationType(BudgetOperationTypeEnum.SUBTRACT.getCode());
            subComMonthBudgetChangeVo.setChangeAmount(subComMonthBudgetDetailEntity.getCurOperationAmount());
            subComMonthBudgetChangeVo.setChangeBalance(subComMonthBudgetDetailEntity.getBalanceAmount());
        }
        return subComMonthBudgetChangeVo;
    }

    private String adjustSubmit(SubComMonthBudgetAdjustDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("sub_com_adjust_month_budget");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        return processBusinessVo.getProcessNo();
    }

    private SubComMonthBudgetDetailDto buildDetail(SubComMonthBudgetEntity subComMonthBudgetEntity, BigDecimal operationAmount, String operationType, String businessCode) {
        SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = (SubComMonthBudgetDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        subComMonthBudgetDetailDto.setId(null);
        subComMonthBudgetDetailDto.setBusinessCode(businessCode);
        subComMonthBudgetDetailDto.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
        subComMonthBudgetDetailDto.setOperationType(operationType);
        if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType) || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType) || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.USE.getCode().equals(operationType) || BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        } else if (BudgetOperationTypeEnum.ADD.getCode().equals(operationType) || BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType) || BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType)) {
            subComMonthBudgetDetailDto.setBeforeAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
        }
        subComMonthBudgetDetailDto.setCurOperationAmount(operationAmount);
        subComMonthBudgetDetailDto.setBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount());
        return subComMonthBudgetDetailDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void change(SubComMonthBudgetOperateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getMonthBudgetCode(), (String)"\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)BudgetOperationTypeEnum.changeMap().containsKey(dto.getOperationType()), (String)"\u53d8\u66f4\u7c7b\u578b\u53ea\u80fd\u662f\u8ffd\u52a0\u3001\u524a\u51cf\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationAmount(), (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull((Object)((Object)subComMonthBudgetEntity), (String)"\u5f53\u524d\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            Validate.isTrue((!DataSourceEnum.AUTO.getCode().equals(subComMonthBudgetEntity.getDataSource()) ? 1 : 0) != 0, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u4e0d\u5141\u8bb8\u53d8\u66f4", (Object[])new Object[0]);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)("\u524a\u51cf\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9884\u7b97\u53ef\u7528\u91d1\u989d" + Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP) + "\uff01"), (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.ADD.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setApprovingAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
            }
            this.subComMonthBudgetRepository.saveOrUpdate((Object)subComMonthBudgetEntity);
            String processNo = this.changeSubmit(dto);
            SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, dto.getOperationAmount(), dto.getOperationType(), null);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            } else {
                subComMonthBudgetDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            }
            subComMonthBudgetDetailDto.setProcessNo(processNo);
            subComMonthBudgetDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            this.subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    private String changeSubmit(SubComMonthBudgetOperateDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("sub_com_change_month_budget");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        return processBusinessVo.getProcessNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void unOrFreeze(SubComMonthBudgetOperateDto dto, String operationType) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setOperationType(operationType);
        Validate.notBlank((CharSequence)dto.getMonthBudgetCode(), (String)"\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)BudgetOperationTypeEnum.freezeMap().containsKey(dto.getOperationType()), (String)"\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u662f\u51bb\u7ed3\u3001\u89e3\u51bb\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationAmount(), (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        boolean lockFlag = true;
        try {
            lockFlag = this.monthBudgetLockService.lock(dto.getMonthBudgetCode(), TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), null);
            Validate.notNull((Object)((Object)subComMonthBudgetEntity), (String)"\u5f53\u524d\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            Validate.isTrue((!DataSourceEnum.AUTO.getCode().equals(subComMonthBudgetEntity.getDataSource()) ? 1 : 0) != 0, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u4e0d\u5141\u8bb8\u51bb\u7ed3\u6216\u89e3\u51bb", (Object[])new Object[0]);
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)("\u51bb\u7ed3\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9884\u7b97\u53ef\u7528\u91d1\u989d" + Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP) + "\uff01"), (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)("\u89e3\u51bb\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u51bb\u7ed3\u91d1\u989d" + Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).setScale(4, RoundingMode.HALF_UP) + "\uff01"), (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setFreezeAmount(Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                subComMonthBudgetEntity.setFreezeAmount(Optional.ofNullable(subComMonthBudgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComMonthBudgetEntity.setCurrentBalanceAmount(Optional.ofNullable(subComMonthBudgetEntity.getCurrentBalanceAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            this.subComMonthBudgetRepository.saveOrUpdate((Object)subComMonthBudgetEntity);
            SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, dto.getOperationAmount(), dto.getOperationType(), null);
            this.subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(dto.getMonthBudgetCode());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(String monthBudgetCode, BigDecimal operationAmount, String operationType, String businessCode) {
        Validate.notEmpty((CharSequence)monthBudgetCode, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)operationAmount, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)operationType, (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(monthBudgetCode, EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)subComMonthBudgetEntity), (String)("\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97" + monthBudgetCode + "\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01"), (Object[])new Object[0]);
        if (!this.redisLockService.isLock("month_budget:lock:" + monthBudgetCode)) {
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97" + monthBudgetCode + "\u672a\u52a0\u9501\uff01");
        }
        if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
            subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
        }
        this.subComMonthBudgetRepository.updateById((Object)subComMonthBudgetEntity);
        SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, operationAmount, operationType, businessCode);
        this.subComMonthBudgetDetailService.create(subComMonthBudgetDetailDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(List<OperateMonthBudgetDto> operateList) {
        Map<String, SubComMonthBudgetEntity> budgetEntityMap = this.validateOperateBudget(operateList);
        ArrayList detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            SubComMonthBudgetEntity subComMonthBudgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else {
                throw new RuntimeException("\u6708\u5ea6\u9884\u7b97\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
            }
            SubComMonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, operationAmount, operationType, businessCode);
            detailList.add(monthBudgetDetailDto);
        }
        this.subComMonthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void operateBudgetByAudit(List<OperateMonthBudgetDto> operateList, Map<String, MonthBudgetControlVo> controlMap) {
        Map<String, SubComMonthBudgetEntity> budgetEntityMap = this.validateOperateBudget(operateList);
        ArrayList detailList = Lists.newArrayList();
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            SubComMonthBudgetEntity subComMonthBudgetEntity = budgetEntityMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            MonthBudgetControlVo monthBudgetControlVo = controlMap.get(operateMonthBudgetDto.getMonthBudgetCode());
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(operationAmount.add(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else if (BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(operationType)) {
                subComMonthBudgetEntity.setApprovedAmount(Optional.ofNullable(subComMonthBudgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            } else if (BudgetOperationTypeEnum.AUDIT_USE.getCode().equals(operationType)) {
                if (!YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling()) || !ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) throw new RuntimeException("\u9884\u7b97\u4fee\u6539\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ba1\u63a7\u7ef4\u5ea6");
                subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(operationAmount));
            } else {
                if (!BudgetOperationTypeEnum.AUDIT_RETURN.getCode().equals(operationType)) throw new RuntimeException("\u6708\u5ea6\u9884\u7b97\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
                if (!YesOrNoEnum.NO.getCode().equals(monthBudgetControlVo.getIfRolling()) || !ControlsCaliberEnum.DIAMETER_CASE_REPLY.getCode().equals(monthBudgetControlVo.getControlsCaliber().trim())) throw new RuntimeException("\u9884\u7b97\u4fee\u6539\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ba1\u63a7\u7ef4\u5ea6");
                subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
                subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(operationAmount));
            }
            SubComMonthBudgetDetailDto monthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, operationAmount, operationType, businessCode);
            detailList.add(monthBudgetDetailDto);
        }
        log.info("\u7ed3\u6848\u6838\u9500\u5206\u5b50\u9000\u9884\u7b97\uff1abudgetEntity:{}", (Object)JsonUtils.obj2JsonString(budgetEntityMap.values()));
        this.subComMonthBudgetService.updateOperateBudget(budgetEntityMap.values(), detailList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOperateBudget(Collection<SubComMonthBudgetEntity> budgetList, List<SubComMonthBudgetDetailDto> detailList) {
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.subComMonthBudgetRepository.updateBatchById(budgetList);
        }
        if (!CollectionUtils.isEmpty(detailList)) {
            this.subComMonthBudgetDetailService.createList(detailList);
        }
    }

    public Map<String, SubComMonthBudgetEntity> validateOperateBudget(List<OperateMonthBudgetDto> operateList) {
        for (OperateMonthBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getMonthBudgetCode(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)operateMonthBudgetDto.getOperationAmount(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> monthBudgetCodeList = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<SubComMonthBudgetEntity> budgetEntityList = this.subComMonthBudgetRepository.listByCodes(monthBudgetCodeList);
        if (budgetEntityList.size() < monthBudgetCodeList.size()) {
            List existsCodes = budgetEntityList.stream().map(SubComMonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
            String notExistsJoinCodesStr = monthBudgetCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97[" + notExistsJoinCodesStr + "]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01\uff01");
        }
        return budgetEntityList.stream().collect(Collectors.toMap(SubComMonthBudgetEntity::getMonthBudgetCode, Function.identity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void transfer(SubComMonthBudgetTransferDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getMonthBudgetCode(), (String)"\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getDetailDtoList(), (String)"\u64cd\u4f5c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComMonthBudgetEntity subComMonthBudgetEntity = this.subComMonthBudgetRepository.getByMonthBudgetCode(dto.getMonthBudgetCode(), EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)((Object)subComMonthBudgetEntity), (String)"\u5f53\u524d\u9884\u7b97\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        ArrayList<SubComMonthBudgetEntity> dimensionBudgetList = new ArrayList<SubComMonthBudgetEntity>();
        dto.getDetailDtoList().forEach(detailDto -> {
            SubComMonthBudgetDto subComMonthBudgetDto = (SubComMonthBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList(detailDto, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            subComMonthBudgetDto.setYearMonthLy(subComMonthBudgetEntity.getYearMonthLy());
            List<SubComMonthBudgetEntity> monthBudgetEntityList = this.findByDimension(subComMonthBudgetDto);
            if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
                SubComMonthBudgetEntity addMonthBudgetEntity = (SubComMonthBudgetEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(detailDto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
                addMonthBudgetEntity.setYearMonthLy(subComMonthBudgetEntity.getYearMonthLy());
                addMonthBudgetEntity.setAdjustAmount(detailDto.getTransferAmount());
                addMonthBudgetEntity.setCurrentBalanceAmount(detailDto.getTransferAmount());
                dimensionBudgetList.add(addMonthBudgetEntity);
            } else {
                log.info("\u67e5\u8be2\u540c\u7ef4\u5ea6\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u6210\u529f\uff0c\u5171\u67e5\u8be2\u5230" + monthBudgetEntityList.size() + "\u6761");
                SubComMonthBudgetEntity dimensionBudget = monthBudgetEntityList.get(0);
                if (StringUtils.equals((CharSequence)subComMonthBudgetEntity.getMonthBudgetCode(), (CharSequence)dimensionBudget.getMonthBudgetCode())) {
                    throw new RuntimeException("\u5212\u62e8\u5931\u8d25\uff0c\u9884\u7b97" + subComMonthBudgetEntity.getMonthBudgetCode() + "\u4e0d\u80fd\u5212\u62e8\u81f3\u9884\u7b97" + dimensionBudget.getMonthBudgetCode());
                }
                dimensionBudget.setAdjustAmount(Optional.ofNullable(dimensionBudget.getAdjustAmount()).orElse(BigDecimal.ZERO).add(detailDto.getTransferAmount()));
                dimensionBudget.setCurrentBalanceAmount(dimensionBudget.getCurrentBalanceAmount().add(detailDto.getTransferAmount()));
                dimensionBudgetList.add(dimensionBudget);
            }
        });
        boolean lockFlag = true;
        List<String> lockKeys = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(dimensionBudgetList)) {
            lockKeys = dimensionBudgetList.stream().map(SubComMonthBudgetEntity::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toList());
        }
        lockKeys.add(dto.getMonthBudgetCode());
        try {
            lockFlag = this.monthBudgetLockService.lock(lockKeys, TimeUnit.SECONDS, 5);
            BigDecimal transferAmount = dto.getDetailDtoList().stream().map(SubComMonthBudgetTransferDetailDto::getTransferAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            subComMonthBudgetEntity.setAdjustAmount(Optional.ofNullable(subComMonthBudgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(transferAmount));
            subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().subtract(transferAmount));
            dimensionBudgetList.add(subComMonthBudgetEntity);
            this.subComMonthBudgetRepository.saveOrUpdateBatch(dimensionBudgetList);
        }
        finally {
            if (lockFlag) {
                this.monthBudgetLockService.unLock(lockKeys);
            }
        }
    }

    public List<SubComMonthBudgetVo> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.subComMonthBudgetRepository.listByBudgetItemCodeList(budgetItemCodeList);
        if (CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return new ArrayList<SubComMonthBudgetVo>(this.nebulaToolkitService.copyCollectionByWhiteList(subComMonthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public List<SubComMonthBudgetVo> listByBudgetCodeList(List<String> budgetCodeList) {
        if (CollectionUtils.isEmpty(budgetCodeList)) {
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetEntity> monthBudgetEntityList = this.subComMonthBudgetRepository.listByCodes(budgetCodeList);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void manualRolling(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u624b\u5de5\u6267\u884c\u6eda\u52a8\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetEntity> asyncList = this.subComMonthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(asyncList)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        this.calRolling(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calRolling(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.subComMonthBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        List subComMonthBudgetCodeList = subComMonthBudgetEntityList.stream().map(SubComMonthBudgetEntity::getMonthBudgetCode).collect(Collectors.toList());
        boolean lock = true;
        try {
            lock = this.monthBudgetLockService.lock(subComMonthBudgetCodeList, TimeUnit.SECONDS, 1200);
            Validate.isTrue((boolean)lock, (String)"\u624b\u52a8\u6267\u884c\u6eda\u52a8\u5931\u8d25\uff0c\u5f53\u524d\u9884\u7b97\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            DimensionControlsDto dimensionControlsDto = new DimensionControlsDto();
            dimensionControlsDto.setControlType(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode());
            dimensionControlsDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List dimensionControlsVos = this.dimensionControlsService.listByConditions(dimensionControlsDto);
            if (CollectionUtils.isEmpty((Collection)dimensionControlsVos)) {
                return;
            }
            Map<String, List<DimensionControlsVo>> controlMap = dimensionControlsVos.stream().collect(Collectors.groupingBy(vo -> vo.getBusinessFormatCode() + vo.getBusinessUnitCode()));
            AtomicReference<String> rollingType = new AtomicReference<String>("");
            AtomicReference<String> isRolling = new AtomicReference<String>(BooleanEnum.FALSE.getCapital());
            subComMonthBudgetEntityList.forEach(subComMonthBudgetEntity -> {
                int curYear;
                SubComMonthBudgetDto subComMonthBudgetDto;
                Date date;
                int lastMonthYear;
                String controlKey = subComMonthBudgetEntity.getBusinessFormatCode() + subComMonthBudgetEntity.getBusinessUnitCode();
                if (controlMap.containsKey(controlKey)) {
                    List dimensionControlsList = (List)controlMap.get(controlKey);
                    dimensionControlsList.forEach(dimensionControlsVo -> {
                        if (!CollectionUtils.isEmpty((Collection)dimensionControlsVo.getBudgetItemCodeList()) && dimensionControlsVo.getBudgetItemCodeList().contains(subComMonthBudgetEntity.getBudgetItemCode())) {
                            rollingType.set(dimensionControlsVo.getRollingType());
                            isRolling.set(dimensionControlsVo.getIfRolling());
                        }
                    });
                }
                if ((lastMonthYear = DateUtil.getDaysOfYear((Date)(date = DateUtil.formatAddMonth((Date)DateUtil.parseDate((String)(subComMonthBudgetDto = (SubComMonthBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0])).getYearMonthLy(), (String)"yyyy-MM"), (int)-1)))) != (curYear = DateUtil.getDaysOfYear((Date)DateUtil.parseDate((String)subComMonthBudgetDto.getYearMonthLy(), (String)"yyyy-MM")))) {
                    return;
                }
                subComMonthBudgetDto.setYearMonthLy(DateUtil.format((Date)date, (String)"yyyy-MM"));
                List<SubComMonthBudgetEntity> dimensions = this.findByDimension(subComMonthBudgetDto);
                if (CollectionUtils.isEmpty(dimensions)) {
                    subComMonthBudgetEntity.setLastMonthRollingAmount(BigDecimal.ZERO);
                    return;
                }
                SubComMonthBudgetEntity lastMonthBudget = dimensions.get(0);
                if (BooleanEnum.TRUE.getCapital().equals(isRolling.get())) {
                    BigDecimal lastRolling = Optional.ofNullable(subComMonthBudgetEntity.getLastMonthRollingAmount()).orElse(BigDecimal.ZERO);
                    if (RollingTypeEnum.PLEASE_SPECIFY.getCode().equals(rollingType.get())) {
                        subComMonthBudgetEntity.setLastMonthRollingAmount(lastMonthBudget.getCurrentBalanceAmount());
                        subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(subComMonthBudgetEntity.getLastMonthRollingAmount()).subtract(lastRolling));
                    }
                    if (RollingTypeEnum.SURPLUS_ROLL.getCode().equals(rollingType.get()) && BigDecimal.ZERO.compareTo(lastMonthBudget.getCurrentBalanceAmount()) < 0) {
                        subComMonthBudgetEntity.setLastMonthRollingAmount(lastMonthBudget.getCurrentBalanceAmount());
                        subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(subComMonthBudgetEntity.getLastMonthRollingAmount()).subtract(lastRolling));
                    }
                    if (RollingTypeEnum.OVERSPEND_ROLL.getCode().equals(rollingType.get()) && BigDecimal.ZERO.compareTo(lastMonthBudget.getCurrentBalanceAmount()) > 0) {
                        subComMonthBudgetEntity.setLastMonthRollingAmount(lastMonthBudget.getCurrentBalanceAmount());
                        subComMonthBudgetEntity.setCurrentBalanceAmount(subComMonthBudgetEntity.getCurrentBalanceAmount().add(subComMonthBudgetEntity.getLastMonthRollingAmount()).subtract(lastRolling));
                    }
                } else {
                    subComMonthBudgetEntity.setLastMonthRollingAmount(BigDecimal.ZERO);
                }
            });
            this.subComMonthBudgetRepository.updateBatchById(subComMonthBudgetEntityList);
        }
        finally {
            if (lock) {
                this.monthBudgetLockService.unLock(subComMonthBudgetCodeList);
            }
        }
    }

    public Page<MonthBudgetExamineCircularQueryVo> findExamineCircularByConditions(Page<MonthBudgetExamineCircularQueryVo> page, MonthBudgetExamineCircularQueryDto dto) {
        return this.subComMonthBudgetMapper.findExamineCircularByConditions(page, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<SubComMonthBudgetVo> designMonthBudget(List<SubComMonthBudgetDto> subComMonthBudgetDtoList) {
        if (CollectionUtils.isEmpty(subComMonthBudgetDtoList)) {
            return Lists.newArrayList();
        }
        ArrayList<SubComMonthBudgetVo> subComMonthBudgetVoList = new ArrayList<SubComMonthBudgetVo>();
        List codeList = this.generateCodeService.generateCode("FZYDYS", subComMonthBudgetDtoList.size(), Integer.valueOf(8), 2L, TimeUnit.DAYS);
        Iterator iterator = codeList.iterator();
        ArrayList subComMonthBudgetEntityList = new ArrayList();
        ArrayList initList = new ArrayList();
        ArrayList approvedDetailList = new ArrayList();
        ArrayList planBudgetEntityList = new ArrayList();
        subComMonthBudgetDtoList.forEach(subComMonthBudgetDto -> {
            subComMonthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
            subComMonthBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            subComMonthBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            subComMonthBudgetDto.setMonthBudgetCode((String)iterator.next());
            SubComMonthBudgetEntity subComMonthBudgetEntity = (SubComMonthBudgetEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(subComMonthBudgetDto, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            subComMonthBudgetEntity.setDataSource(DataSourceEnum.AUTO.getCode());
            subComMonthBudgetEntityList.add(subComMonthBudgetEntity);
            SubComMonthBudgetVo subComMonthBudgetVo = (SubComMonthBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List planBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)subComMonthBudgetDto.getPlanBudgetList(), SubComMonthBudgetPlanBudgetDto.class, SubComMonthBudgetPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            subComMonthBudgetVo.setPlanBudgetList(planBudgetVos);
            subComMonthBudgetVoList.add(subComMonthBudgetVo);
            SubComMonthBudgetDetailEntity subComMonthBudgetDetailEntity = (SubComMonthBudgetDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetEntity, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            subComMonthBudgetDetailEntity.setInitialAmount(subComMonthBudgetEntity.getBudgetAmount());
            subComMonthBudgetDetailEntity.setOperationType(BudgetOperationTypeEnum.INIT.getCode());
            initList.add(subComMonthBudgetDetailEntity);
            SubComMonthBudgetDetailDto subComMonthBudgetDetailDto = this.buildDetail(subComMonthBudgetEntity, subComMonthBudgetEntity.getApprovedAmount(), BudgetOperationTypeEnum.USE.getCode(), "");
            SubComMonthBudgetDetailEntity approvedDetail = (SubComMonthBudgetDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComMonthBudgetDetailDto, SubComMonthBudgetDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            approvedDetail.setId(null);
            approvedDetailList.add(approvedDetail);
            List planBudgetList = subComMonthBudgetDto.getPlanBudgetList();
            if (!CollectionUtils.isEmpty((Collection)planBudgetList)) {
                List subComMonthBudgetPlanBudgetEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planBudgetList, SubComMonthBudgetPlanBudgetDto.class, SubComMonthBudgetPlanBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                subComMonthBudgetPlanBudgetEntityList.forEach(subComMonthBudgetPlanBudgetEntity -> {
                    subComMonthBudgetPlanBudgetEntity.setId(null);
                    subComMonthBudgetPlanBudgetEntity.setMonthBudgetCode(subComMonthBudgetDto.getMonthBudgetCode());
                    subComMonthBudgetPlanBudgetEntity.setTenantCode(TenantUtils.getTenantCode());
                    subComMonthBudgetPlanBudgetEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                });
                planBudgetEntityList.addAll(subComMonthBudgetPlanBudgetEntityList);
            }
            subComMonthBudgetDto.setId(subComMonthBudgetEntity.getId());
            SubComMonthBudgetLogEventDto logEventDto = new SubComMonthBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(subComMonthBudgetDto);
            SerializableBiConsumer & Serializable onCreate = SubComMonthBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComMonthBudgetLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
        if (!CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            Set onlykeys = subComMonthBudgetEntityList.stream().map(o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode()).collect(Collectors.toSet());
            List forecastVos = this.subComBudgetForecastService.listByOnlyKeys(new ArrayList(onlykeys));
            Map<Object, Object> forMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)forecastVos)) {
                forMap = forecastVos.stream().collect(Collectors.toMap(o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode(), SubComBudgetForecastVo::getBudgetAmount, (oldV, newV) -> newV));
            }
            for (SubComMonthBudgetEntity budgetEntity : subComMonthBudgetEntityList) {
                String key = budgetEntity.getYearMonthLy() + budgetEntity.getBusinessFormatCode() + budgetEntity.getBusinessUnitCode() + budgetEntity.getOrgCode() + budgetEntity.getFeeSourceCode();
                if (forMap.containsKey(key) && null != forMap.get(key)) {
                    budgetEntity.setApprovedAmount((BigDecimal)forMap.get(key));
                }
                budgetEntity.setCurrentBalanceAmount(Optional.ofNullable(budgetEntity.getApprovedAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(budgetEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(budgetEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)));
            }
        }
        this.subComMonthBudgetRepository.saveBatch(subComMonthBudgetEntityList);
        this.subComMonthBudgetDetailRepository.saveBatch(initList);
        this.subComMonthBudgetDetailRepository.saveBatch(approvedDetailList);
        this.subComMonthBudgetPlanBudgetRepository.saveBatch(planBudgetEntityList);
        return subComMonthBudgetVoList;
    }

    private void buildPlanDetail(SubComMonthBudgetDto subComMonthBudgetDto) {
        List planBudgetList = subComMonthBudgetDto.getPlanBudgetList();
        if (CollectionUtils.isEmpty((Collection)planBudgetList)) {
            return;
        }
        List subComMonthBudgetPlanBudgetEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planBudgetList, SubComMonthBudgetPlanBudgetDto.class, SubComMonthBudgetPlanBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        subComMonthBudgetPlanBudgetEntityList.forEach(subComMonthBudgetPlanBudgetEntity -> {
            subComMonthBudgetPlanBudgetEntity.setId(null);
            subComMonthBudgetPlanBudgetEntity.setMonthBudgetCode(subComMonthBudgetDto.getMonthBudgetCode());
            subComMonthBudgetPlanBudgetEntity.setTenantCode(TenantUtils.getTenantCode());
            subComMonthBudgetPlanBudgetEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        this.subComMonthBudgetPlanBudgetRepository.saveBatch(subComMonthBudgetPlanBudgetEntityList);
    }

    private List<SubComMonthBudgetEntity> findByDimension(SubComMonthBudgetDto subComMonthBudgetDto) {
        Validate.notNull((Object)subComMonthBudgetDto, (String)"\u67e5\u8be2\u540c\u7ef4\u5ea6\u7684\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.subComMonthBudgetMapper.findByDimension(subComMonthBudgetDto);
        return subComMonthBudgetEntityList;
    }

    private void updateValidate(SubComMonthBudgetDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getId(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setExcludeCode(dto.getMonthBudgetCode());
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.findByDimension(dto);
        if (!CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            throw new RuntimeException("\u5f53\u524d\u9884\u7b97\u7ef4\u5ea6\u5df2\u5b58\u5728\uff01");
        }
        List<SubComMonthBudgetDetailEntity> subComMonthBudgetDetailEntityList = this.subComMonthBudgetDetailService.listByMonthBudgetCode(dto.getMonthBudgetCode());
        if (subComMonthBudgetDetailEntityList.size() > 1) {
            throw new RuntimeException("\u5f53\u524d\u9884\u7b97\u5df2\u5b58\u5728\u660e\u7ec6\uff0c\u65e0\u6cd5\u7f16\u8f91\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bulkImportSave(List<SubComMonthBudgetDto> importList) {
        try {
            if (CollectionUtils.isEmpty(importList)) {
                return;
            }
            AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
            Date date = new Date();
            ArrayList<SubComMonthBudgetDto> addList = new ArrayList<SubComMonthBudgetDto>();
            ArrayList<SubComMonthBudgetDto> editList = new ArrayList<SubComMonthBudgetDto>();
            for (SubComMonthBudgetDto dto : importList) {
                dto.setCurrentBalanceAmount(dto.getBudgetAmount());
                if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
                    dto.setModifyAccount(loginDetails.getUsername());
                    dto.setModifyName(loginDetails.getRealName());
                    dto.setModifyTime(date);
                    editList.add(dto);
                    continue;
                }
                dto.setCreateAccount(loginDetails.getUsername());
                dto.setCreateName(loginDetails.getRealName());
                dto.setCreateTime(date);
                dto.setTenantCode(loginDetails.getTenantCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                dto.setDataSource(DataSourceEnum.MANUAL.getCode());
                addList.add(dto);
            }
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u65b0\u589e\u6570\u636e\u6761\u6570\uff1a{}", (Object)editList.size());
                List codes = this.generateCodeService.generateCode("FZYDYS", addList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
                for (int i = 0; i < addList.size(); ++i) {
                    SubComMonthBudgetDto budgetDto = (SubComMonthBudgetDto)addList.get(i);
                    budgetDto.setMonthBudgetCode((String)codes.get(i));
                }
                Collection adds = this.nebulaToolkitService.copyCollectionByWhiteList(addList, SubComMonthBudgetDto.class, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                List rateList = (List)adds;
                List rates = Lists.partition((List)rateList, (int)500);
                for (List list : rates) {
                    this.subComMonthBudgetRepository.saveBatch(list);
                }
            }
            ArrayList<SubComMonthBudgetLogEventDto> editLogs = new ArrayList<SubComMonthBudgetLogEventDto>();
            if (!CollectionUtils.isEmpty(editList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u7f16\u8f91\u6570\u636e\u6761\u6570\uff1a{}", (Object)editList.size());
                List rates = Lists.partition(editList, (int)500);
                for (List list : rates) {
                    List ids = list.stream().map(UuidDto::getId).collect(Collectors.toList());
                    List oldList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.subComMonthBudgetRepository.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
                    Collection oldDtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)oldList, SubComMonthBudgetEntity.class, SubComMonthBudgetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    Map oldMap = oldDtoList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
                    for (SubComMonthBudgetDto dto : list) {
                        SubComMonthBudgetLogEventDto eventDto = new SubComMonthBudgetLogEventDto();
                        eventDto.setNewest(dto);
                        eventDto.setOriginal(oldMap.getOrDefault(dto.getId(), new SubComMonthBudgetDto()));
                        editLogs.add(eventDto);
                    }
                    Collection res = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, SubComMonthBudgetDto.class, SubComMonthBudgetEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    this.subComMonthBudgetRepository.updateBatchByIdAndTenantCode(res, TenantUtils.getTenantCode());
                }
            }
            if (!CollectionUtils.isEmpty(addList)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u65b0\u589e\u65e5\u5fd7");
                this.subComMonthBudgetLogService.addLogAsync(addList);
            }
            if (!CollectionUtils.isEmpty(editLogs)) {
                log.info("\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u4fdd\u5b58-----------------\u7f16\u8f91\u65e5\u5fd7");
                this.subComMonthBudgetLogService.updateLogAsync(editLogs);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new NullPointerException(e.getMessage());
        }
    }

    public List<SubComMonthBudgetVo> listByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetEntity> monthBudgetEntityList = this.subComMonthBudgetRepository.listByCodes(codes);
        if (CollectionUtils.isEmpty(monthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<SubComMonthBudgetEntity> entityList = this.subComMonthBudgetRepository.findByIds(ids);
        Assert.notEmpty(entityList, (String)"\u5220\u9664\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        entityList.forEach(entity -> Validate.isTrue((!DataSourceEnum.AUTO.getCode().equals(entity.getDataSource()) ? 1 : 0) != 0, (String)"\u81ea\u52a8\u751f\u6210\u7684\u6570\u636e\u4e0d\u53ef\u5220\u9664\uff01", (Object[])new Object[0]));
        this.subComMonthBudgetRepository.deleteById(ids);
    }

    public List<SubComMonthBudgetVo> findListByCondition(SubComMonthBudgetDto subComMonthBudgetDto) {
        if (Objects.isNull(subComMonthBudgetDto)) {
            return Lists.newArrayList();
        }
        List<SubComMonthBudgetEntity> subComMonthBudgetEntityList = this.subComMonthBudgetRepository.findListByCondition(subComMonthBudgetDto);
        if (CollectionUtils.isEmpty(subComMonthBudgetEntityList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(subComMonthBudgetEntityList, SubComMonthBudgetEntity.class, SubComMonthBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void updateSubComMonthBudgetByBudgetForecast(Map<String, BigDecimal> forecastMap) {
        if (forecastMap.isEmpty()) {
            return;
        }
        ArrayList<String> onlyKeys = new ArrayList<String>(forecastMap.keySet());
        List<SubComMonthBudgetEntity> list = this.subComMonthBudgetRepository.listByOnlyKeys(onlyKeys);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (SubComMonthBudgetEntity entity : list) {
            String key = entity.getYearMonthLy() + entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getOrgCode() + entity.getFeeSourceCode() + entity.getBudgetItemCode();
            if (!forecastMap.containsKey(key)) continue;
            entity.setApprovedAmount(Optional.ofNullable(forecastMap.get(key)).orElse(BigDecimal.ZERO));
            entity.setCurrentBalanceAmount(Optional.ofNullable(entity.getApprovedAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO)));
        }
        this.subComMonthBudgetRepository.updateBatchById(list);
    }

    public Page<SubComMonthBudgetVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        if (CollectionUtils.isEmpty(yearMonthList)) {
            return new Page(0L, 0L);
        }
        return this.subComMonthBudgetRepository.findBySonCompanyBudgetWarn(pageable, yearMonthList, orgCode, saleCompanyCode, channelCode, saleGroupCode, customerCode, budgetItemCode);
    }
}

