/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.listener;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.DimensionControlsTypeEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.FieldsDimenDiameterEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.event.DimensionControlsEventListener;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.local.service.FieldsDimenDiameterGroupStrategy;
import com.biz.crm.tpm.business.month.budget.local.service.TimeDimensionGroupStrategy;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ChangeControlBalanceAmountEventListener
implements DimensionControlsEventListener {
    private static final Logger log = LoggerFactory.getLogger(ChangeControlBalanceAmountEventListener.class);
    @Autowired
    private BudgetItemService budgetItemService;
    @Autowired
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private List<FieldsDimenDiameterGroupStrategy> fieldsDimenDiameterGroupStrategies;
    @Autowired(required=false)
    private List<TimeDimensionGroupStrategy> timeDimensionGroupStrategies;

    @Transactional(rollbackFor={Exception.class})
    public void onCreate(DimensionControlsVo dimensionControlsVo) {
        String fieldsDimensionalitys = dimensionControlsVo.getFieldsDimensionality();
        String timeDimension = dimensionControlsVo.getTimeDimension();
        Object[] split = fieldsDimensionalitys.split(",");
        ArrayList fieldsDimensionality = Lists.newArrayList((Object[])split);
        List budgetItemCodeList = dimensionControlsVo.getBudgetItemCodeList();
        if (dimensionControlsVo.getControlType().equals(DimensionControlsTypeEnum.DIMENSION_CONTROL.getCode())) {
            List budgetItemVos = this.budgetItemService.listByParent(budgetItemCodeList);
            if (!CollectionUtils.isEmpty((Collection)budgetItemVos)) {
                List budgetItemCodes = budgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).collect(Collectors.toList());
                budgetItemCodeList.addAll(budgetItemCodes);
            }
            List monthBudgetVos = this.monthBudgetService.listByBudgetItemCodeList(budgetItemCodeList);
            List<MonthBudgetVo> monthBudgetVoList = this.screenMonthBudgetVo(monthBudgetVos, fieldsDimensionality);
            Map<String, List<MonthBudgetVo>> groupMap = monthBudgetVoList.stream().collect(Collectors.groupingBy(MonthBudgetVo::getBudgetItemCode));
            for (String s : fieldsDimensionality) {
                List fieldsDimenDiameterGroupStrategyList = this.fieldsDimenDiameterGroupStrategies.stream().filter(fieldsDimenDiameterGroupStrategy -> fieldsDimenDiameterGroupStrategy.getFieldsDimenDiameterCode().equals(s)).collect(Collectors.toList());
                FieldsDimenDiameterGroupStrategy fieldsDimenDiameterGroupStrategy2 = (FieldsDimenDiameterGroupStrategy)fieldsDimenDiameterGroupStrategyList.get(0);
                groupMap = fieldsDimenDiameterGroupStrategy2.onFieldsDimenDiameterGroup(groupMap);
            }
            List timeDimensionGroupStrategyList = this.timeDimensionGroupStrategies.stream().filter(timeDimensionGroupStrategy -> timeDimensionGroupStrategy.getTimeDimensionCode().equals(timeDimension)).collect(Collectors.toList());
            TimeDimensionGroupStrategy timeDimensionGroupStrategy2 = (TimeDimensionGroupStrategy)timeDimensionGroupStrategyList.get(0);
            groupMap = timeDimensionGroupStrategy2.onTimeDimensionGroup(groupMap);
            for (String code : groupMap.keySet()) {
                List<MonthBudgetVo> budgetVos = groupMap.get(code);
                BigDecimal amount = budgetVos.stream().map(MonthBudgetVo::getAccumulatedAvailableBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
                Set ids = budgetVos.stream().map(UuidVo::getId).collect(Collectors.toSet());
                this.monthBudgetService.updateControlBalanceAmountByIds(ids, amount);
            }
        }
    }

    private List<MonthBudgetVo> screenMonthBudgetVo(List<MonthBudgetVo> monthBudgetVos, List<String> fieldsDimensionality) {
        List<Object> monthBudgetVoList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(monthBudgetVos) && !CollectionUtils.isEmpty(fieldsDimensionality)) {
            for (String s : fieldsDimensionality) {
                FieldsDimenDiameterEnum dimenDiameterEnum = FieldsDimenDiameterEnum.codeToEnum((String)s);
                switch (dimenDiameterEnum) {
                    case TISSUE: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getSalesOrgCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getSalesOrgCode()})).collect(Collectors.toList());
                        break;
                    }
                    case DEPARTMENT: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getOrgCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getOrgCode()})).collect(Collectors.toList());
                        break;
                    }
                    case CHANNEL: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getCustomerChannelCode()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getTerminalChannelCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getCustomerChannelCode()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getTerminalChannelCode()})).collect(Collectors.toList());
                        break;
                    }
                    case SYSTEM: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getSystemCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getSystemCode()})).collect(Collectors.toList());
                        break;
                    }
                    case REGION: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getRegionCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getRegionCode()})).collect(Collectors.toList());
                        break;
                    }
                    case CLIEN: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getCustomerCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getCustomerCode()})).collect(Collectors.toList());
                        break;
                    }
                    case BRAND: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductBrandCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductBrandCode()})).collect(Collectors.toList());
                        break;
                    }
                    case SHOP: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getTerminalCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getTerminalCode()})).collect(Collectors.toList());
                        break;
                    }
                    case CATEGORY: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductCategoryCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductCategoryCode()})).collect(Collectors.toList());
                        break;
                    }
                    case ITEM: {
                        if (!CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
                            monthBudgetVoList = monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductItemCode()})).collect(Collectors.toList());
                            break;
                        }
                        monthBudgetVoList = monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductItemCode()})).collect(Collectors.toList());
                        break;
                    }
                    case PRODUCT: {
                        monthBudgetVoList = !CollectionUtils.isEmpty((Collection)monthBudgetVoList) ? monthBudgetVoList.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductCode()})).collect(Collectors.toList()) : monthBudgetVos.stream().filter(monthBudgetVo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monthBudgetVo.getProductCode()})).collect(Collectors.toList());
                    }
                }
            }
        }
        return monthBudgetVoList;
    }
}

