/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.month.budget.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanLogEventDto;
import com.biz.crm.tpm.business.sales.plan.sdk.event.SalesPlanJobEventListener;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesPlanJobEventListenerImpl
implements SalesPlanJobEventListener {
    private static final Logger log = LoggerFactory.getLogger(SalesPlanJobEventListenerImpl.class);
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    public void onPlan(SalesPlanLogEventDto param) {
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u8ba1\u5212\u91cf[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        SalesPlanDto newest = param.getNewest();
        String yearMonthLy = newest.getYearMonthLy();
        ArrayList<String> businessUnitCodeList = new ArrayList<String>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        this.monthBudgetService.autoPlanReplay(yearMonthLy, businessUnitCodeList, BooleanEnum.TRUE.getCapital());
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u8ba1\u5212\u91cf[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }

    public void onReplay(SalesPlanLogEventDto param) {
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u56de\u590d\u91cf[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        SalesPlanDto newest = param.getNewest();
        String yearMonthLy = newest.getYearMonthLy();
        ArrayList<String> businessUnitCodeList = new ArrayList<String>();
        businessUnitCodeList.add(BusinessUnitEnum.VERTICAL.getCode());
        this.monthBudgetService.autoPlanReplay(yearMonthLy, businessUnitCodeList, BooleanEnum.FALSE.getCapital());
        log.info("=====>    \u5782\u76f4\u8ba1\u7b97\u56de\u590d\u91cf[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

